################################################################################
# Define custom enemy classes
################################################################################
import Bladex
import Reference
import AniSound
import BCopy
import GameText

import Ally_Def
import AllyCombat



#
# Boolean value
#
TRUE = 1==1
FALSE = not TRUE


################################################################################
# Define the Dwarf_Ally class
################################################################################
class Dwarf_Ally (Ally_Def.NPCAlly):
	def __init__(self, me):
		# base class init
		Ally_Def.NPCAlly.__init__(self, me)
		#print "Personage Creado",me.Name,self.changed_func

		# Set up traitor knight specific sound priorities
		self.SoundPriorities[Reference.SND_ARROW]   = 10.0
		self.SoundPriorities[Reference.SND_HIT]     = 50.0
		self.SoundPriorities[Reference.SND_NPC]     = 25.0
		self.SoundPriorities[Reference.SND_NOISYPC] = 30.0
		self.SoundPriorities[Reference.SND_PC]      = 80.0
		
		me.SetMesh ('DwfSkin1')
		Reference.EnemiesScorerData[self.Name]=("DwarfIcon3","Dwarf")

		# Un enano paciente
		self.HLCFunc = self.StdHLCFunc
	
	def ResetSounds(self, EntityName):
		me=Bladex.GetEntity(EntityName)
		AniSound.AsignarSonidosEnano(EntityName)
		Reference.EnemiesScorerData[self.Name]=("DwarfIcon3","Dwarf")

	# Functions for loading and saving state
	def __getstate__(self):	
		#print "Changed Funcs",self.changed_func
		
		NPCAlly_state=Ally_Def.NPCAlly.__getstate__(self)
		if(NPCAlly_state[0]!=1):
			print "ERROR: Dwarf_Ally.__getstate__(): Base class version differs."
			return NPCAlly_state
		NPCAlly_state[1]["Dwarf_Ally"]=()
		return NPCAlly_state
	
	def __setstate__(self,parm):
		# Toma como parmetro lo que devuelve __getstate__() y debe recrear la clase
		Ally_Def.NPCAlly.__setstate__(self,parm)

	def ResetCombat (self,EntityName):		
		Ally_Def.NPCAlly.ResetCombat(self, EntityName)
		me = Bladex.GetEntity(EntityName)	
		if me and me.Life>0:
			self.AttacksOwnKind=TRUE
			self.AttackNPCTime = 1.5
			me.BlockingPropensity = 0.7
			me.AttackList = BCopy.deepcopy(Dwarf_AllyAttackData)
			self.ChanceOfFuryOnHurt = 0.25
			self.ChanceOfFuryOnLeaderDeath = 1.00

	def StdHLCFunc (self, entityName):
		GameText.WriteTextAux(entityName+":  "+"Hey ten cuidado con ese arma!!!",2.0,252,247,167,[],100)

################################################################################
# Define the Dummy_Ally class
################################################################################
class Dummy_Ally (Ally_Def.NPCAlly):
	def __init__(self, me):
		# base class init
		Ally_Def.NPCAlly.__init__(self, me)
		#print "Personage Creado",me.Name,self.changed_func

		# Set up traitor knight specific sound priorities
		self.SoundPriorities[Reference.SND_ARROW]   = 10.0
		self.SoundPriorities[Reference.SND_HIT]     = 50.0
		self.SoundPriorities[Reference.SND_NPC]     = 25.0
		self.SoundPriorities[Reference.SND_NOISYPC] = 30.0
		self.SoundPriorities[Reference.SND_PC]      = 80.0
		
		# Esconde al traitor
		me.SetMesh ('KgtSkin2')
		Reference.EnemiesScorerData[self.Name]=("KnightIcon","Knight")

		# La Paciencia sin lmites
		self.HLCFunc = self.StdHLCFunc
	
	def ResetSounds(self, EntityName):
		me=Bladex.GetEntity(EntityName)
		AniSound.AsignarSonidosCaballero(EntityName)
		Reference.EnemiesScorerData[self.Name]=("KnightIcon","Knight")

	# Functions for loading and saving state
	def __getstate__(self):	
		#print "Changed Funcs",self.changed_func
		
		NPCAlly_state=Ally_Def.NPCAlly.__getstate__(self)
		if(NPCAlly_state[0]!=1):
			print "ERROR: Dummy_Ally.__getstate__(): Base class version differs."
			return NPCAlly_state
		NPCAlly_state[1]["Dummy_Ally"]=()
		return NPCAlly_state
	
	def __setstate__(self,parm):
		# Toma como parmetro lo que devuelve __getstate__() y debe recrear la clase
		Ally_Def.NPCAlly.__setstate__(self,parm)

	def ResetCombat (self,EntityName):		
		pass

	def StdHLCFunc (self, entityName):
		GameText.WriteTextAux("Hey ten cuidado con ese arma!!!",2.0,252,247,167,[],100)


# Si no quieres que ataque por su cuenta / To disable self attacking mode of NPC
#	def MyGetEnemyName (self):
#		self.DesencaraPlayer1()
#		#me=Bladex.GetEntity(self.Name)
#                #me.SetEnemy(None)
#                self.EnemyName=None
#		return self.EnemyName


################################################################################
################################################################################
###
### Customized combat tables
###
################################################################################
################################################################################


################################################################################
#           Type    Weight  Move                  MinD  BestD  MaxD     Time (s [Interruptable])
################################################################################


Dwarf_AllyAttackData = [
           # inner zone blocks:
            [AllyCombat.BLOCK,  0.20, "tr",                 650.0, 1300.0, 3500.0, 0.50],
            [AllyCombat.BLOCK,  0.20, "tl",                 650.0, 1300.0, 3500.0, 0.50],
            [AllyCombat.BLOCK,  0.20, "tb",                 650.0, 1300.0, 3500.0, 0.50],
            [AllyCombat.BLOCK,  0.30, "tf",                 650.0, 1300.0, 3500.0, 0.50],

           # outer zone blocks:
            [AllyCombat.BLOCK,  0.05, "tr",                3400.0, 7000.0, 9000.0, 0.50],
            [AllyCombat.BLOCK,  0.05, "tl",                3400.0, 7000.0, 9000.0, 0.50],
            [AllyCombat.BLOCK,  0.35, "tb",                3400.0, 7000.0, 9000.0, 0.50],
            [AllyCombat.BLOCK,  0.10, "tf",                3400.0, 7000.0, 9000.0, 0.50],

           # dodges:
            [AllyCombat.DODGE,  0.25, "D_r",                400.0, 1000.0, 2800.0, 0.35],
            [AllyCombat.DODGE,  0.25, "D_l",                400.0, 1000.0, 2800.0, 0.35],
            [AllyCombat.DODGE,  0.10, "D_b",                400.0, 1000.0, 2800.0, 0.35],
#            [AllyCombat.DODGE, 0.15, ("DL_G_1H",),    0.0, 1000.0, 2500.0, 0.35], # Esquivar con golpe
#            [AllyCombat.DODGE, 0.15, ("DR_G_1H",),    0.0, 1000.0, 2500.0, 0.35], # Esquivar con golpe
#            [AllyCombat.DODGE, 0.10, ("DB_G_1H",),    0.0, 1000.0, 2500.0, 0.35], # Esquivar con golpe

           # attacks:
            [AllyCombat.ATTACKDOWN, 0.90, ("STAIRS",),         800.0, 1000.0, 2500.0, 0.35],

	    [AllyCombat.ATTACK, 0.1, ("GI_1H",),            0.0, 1800.0, 2500.0, 0.35], # Light Attack 
	    [AllyCombat.ATTACK, 0.1, ("GM12_1H",),          0.0, 1800.0, 2500.0, 0.35], # Light High Attack 
	    [AllyCombat.ATTACK, 0.1, ("GM18_1H",),          0.0, 1800.0, 2500.0, 0.35], # Light Low Attack 
	    [AllyCombat.ATTACK, 0.1, ("GM16_1H",),          0.0, 1800.0, 2500.0, 0.35], # Light Left Attack 
	    [AllyCombat.ATTACK, 0.1, ("GM14_1H",),          0.0, 1800.0, 2500.0, 0.35], # Light Right Attack 

#            [AllyCombat.ATTACK, 0.10, ("GM31_1H",),        0.0, 1000.0, 2500.0, 0.35], # Golpe Hacha
#            [AllyCombat.ATTACK, 0.10, ("GM32_1H",),        0.0, 1000.0, 2500.0, 0.35], # Golpe Hacha2
            [AllyCombat.ATTACK, 0.1, ("GM15_1H",),         0.0, 1000.0, 2500.0, 0.35], # Golpe Hacha4
            [AllyCombat.ATTACK, 0.1, ("GM25_1H",),         0.0, 1000.0, 2500.0, 0.35], # Golpe Hacha5
            [AllyCombat.ATTACK, 0.1, ("GM11_1H",),         0.0, 1000.0, 2500.0, 0.35], # Golpe Hacha6

            [AllyCombat.ATTACK, 0.30, "RespectDistance",      0.0,  500.0, 1000.0, 0.30, 1],

           # inner zone moves:
            [AllyCombat.MOVE,   0.05, "tr",                   0.0, 2000.0, 5000.0, 0.35],
            [AllyCombat.MOVE,   0.05, "tl",                   0.0, 2000.0, 5000.0, 0.35],
            [AllyCombat.MOVE,   0.10, "tb",                   0.0, 2000.0, 5000.0, 0.35],
            [AllyCombat.MOVE,   0.15, "tf",                   0.0, 2000.0, 5000.0, 0.35],

           # outer zone moves:
            [AllyCombat.MOVE,   0.06, "tr",                5001.0, 7000.0, 9000.0, 0.50, 1],
            [AllyCombat.MOVE,   0.06, "tl",                5002.0, 7000.0, 9000.0, 0.50, 1],
            [AllyCombat.MOVE,   0.10, "tb",                5003.0, 7000.0, 9000.0, 0.50, 1],
            [AllyCombat.MOVE,   0.05, "tf",                5004.0, 7000.0, 9000.0, 0.50, 1],
            [AllyCombat.MOVE,   0.07, AllyCombat.TempMoveInProc,      3000.0, 7000.0, 9000.0, 0.35, 1],
            [AllyCombat.MOVE,   0.05, AllyCombat.UsePotion,           3000.0, 7000.0, 9000.0, 1.00],
]
        
