
import Bladex
import GameText
import CharStats
import Language

import resistcfg

global RESISTANCE_KEY


valid = ("A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P",
	"Q","R","S","T","U","V","W","X","Y","Z",
	"1","2","3","4","5","6","7","8","9","0"
	"F1","F2","F3","F4","F5","F6","F7","F8","F9","F10","F11","F12")


if not (resistcfg.RESISTANCE_KEY in valid):

	resistcfg.RESISTANCE_KEY = F9


def ShowResist():

	getplayer = Bladex.GetEntity("Player1")

	if (getplayer.Data.selected_enemy):

		victim = Bladex.GetEntity(getplayer.Data.selected_enemy[0])
		kind   = victim.Kind
		values = CharStats.GetCharResistances(kind)


		impale   = 0
		slash    = 0
		crush    = 0
		fire     = 0
		ice      = 0
		venom    = 0
		light    = 0
		electric = 0
		acid     = 0
		drain    = 0


		try:
			impale = values['Impale']*100
		except: pass

		try:
			slash   = values['Slash']*100
		except: pass

		try:
			crush   = values['Crush']*100
		except: pass

		try:
			fire   = values['Fire']*100
		except: pass

		try:
			ice   = values['Ice']*100
		except: pass

		try:
			venom   = values['Venom']*100
		except: pass

		try:
			light   = values['Light']*100
		except: pass

		try:
			electric   = values['Electric']*100
		except: pass

		try:
			acid   = values['Acid']*100
		except: pass

		try:
			drain   = values['Drain']*100
		except: pass


		s_impale   = "%i"%impale
		s_slash    = "%i"%slash
		s_crush    = "%i"%crush
		s_fire     = "%i"%fire
		s_ice 	   = "%i"%ice
		s_venom    = "%i"%venom
		s_light    = "%i"%light
		s_electric = "%i"%electric
		s_acid     = "%i"%acid
		s_drain    = "%i"%drain

		"""1
		if (Language.Current == "German"):

			GameText.ShowMessage(	"Spieen:    " +s_impale+ "\n"
						"Schneiden:    " +s_slash+ "\n"
						"Malmen:    " +s_crush+ "\n"
						"Feuer:    " +s_fire+ "\n"
						"Eis:    " +s_ice+ "\n"
						"Gift:    " +s_venom+ "\n"
						"Licht:    " +s_light+ "\n"
						"Elektrik:    " +s_electric+ "\n"
						"Sure:    " +s_acid+ "\n"
						"Auslaugen:    " +s_drain )

		else:
		2"""

		GameText.ShowMessage(	"Impale:    " +s_impale+ "\n"
					"Slash:    " +s_slash+ "\n"
					"Crush:    " +s_crush+ "\n"
					"Fire:    " +s_fire+ "\n"
					"Ice:    " +s_ice+ "\n"
					"Venom:    " +s_venom+ "\n"
					"Light:    " +s_light+ "\n"
					"Electric:    " +s_electric+ "\n"
					"Acid:    " +s_acid+ "\n"
					"Drain:    " +s_drain )


def ClearResist():
	GameText.ShowMessage()


def Bind():

	import BInput
	IManager = BInput.GetInputManager()
	oldSet   = IManager.GetInputActionsSet()
	IManager.SetInputActionsSet("Default")

	ON_RELEASE = 0
	ON_PRESS   = 1

	Bladex.AddInputAction("ShowResist", 0)
	Bladex.AddBoundFunc("ShowResist",ShowResist)
	Bladex.AssocKey("ShowResist", "Keyboard", resistcfg.RESISTANCE_KEY, ON_PRESS)

	Bladex.AddInputAction("ClearResist", 0)
	Bladex.AddBoundFunc("ClearResist",ClearResist)
	Bladex.AssocKey("ClearResist", "Keyboard", resistcfg.RESISTANCE_KEY, ON_RELEASE)

	IManager.SetInputActionsSet(oldSet)


Bladex.AddScheduledFunc(Bladex.GetTime(), Bind, () )





