################################################################################
# Gladiator Combat information 
# by Josh Dahlby
# Defines combat moves for characters not specified in Combat.py
################################################################################
import Combat
import Bladex
import string

ATK_UNIQUE=0
ATK_RANDOM=1
ATK_SEQUENTIAL=2

def CreateCombo(weapon, sequence, char, list, type=Combat.ATTACK, weight=0.30, minD=0.0, bestD=1400.0, maxD=2500.0, time=0.35, interruptable=0):
	attackName = "GC_" + string.upper(weapon)
	for i in sequence:
		char.AddAttack(attackName, i)
	char.AttackTypeFlag(attackName, ATK_SEQUENTIAL)
	list[weapon] = [type, weight, (attackName,), minD, bestD, maxD, time, interruptable]

def CreateLevelCombo(name, level, sequence, char, list, type=Combat.ATTACK, weight=0.30, minD=0.0, bestD=1400.0, maxD=2500.0, time=0.35, interruptable=0):
	comboName = "GC_" + string.upper(name)
	for i in sequence:
		char.AddAttack(comboName, i)
	char.AttackTypeFlag(comboName, ATK_SEQUENTIAL)
	if not list.has_key(level):
		list[level] = []
	list[level].append([type, weight, (comboName,), minD, bestD, maxD, time, interruptable])

################################################################################
# KNIGHT
################################################################################

kgt=Bladex.GetCharType("Knight_N","Kgt_N")
 
KnightCombos = {}

CreateCombo("Gladius", ["Kgt_g_08_new", "Kgt_g_28new"], kgt, KnightCombos) # Level 4
CreateCombo("Maza", ["Kgt_g_08_new", "Kgt_g_01_new"], kgt, KnightCombos) # Level 7
CreateCombo("Espadaromana", ["Kgt_g_b06_new", "Kgt_g_27kata_new"], kgt, KnightCombos)  # Level 8
CreateCombo("Espadaelfica",  ["Kgt_g_08_new", "Kgt_g_32_5_3new"], kgt, KnightCombos) # Level 9
CreateCombo("Maza2", ["Kgt_g_01low_new", "Kgt_g_21_6_s8new"], kgt, KnightCombos) # Level 10
CreateCombo("QueenSword", ["Kgt_g_b06_new", "Kgt_g_06lowkata_new"], kgt, KnightCombos) # Level 11
CreateCombo("HookSword", ["Kgt_g_07_new", "Kgt_g_s22low_new"], kgt, KnightCombos) # Level 11
CreateCombo("Espadacurva", ["Kgt_g_12_new", "Kgt_g_sb25_new"], kgt, KnightCombos) # Level 12
CreateCombo("FireSword", ["Kgt_g_08_new", "Kgt_g_01_7_new", "Kgt_g_s28kata_new"], kgt, KnightCombos) # Level 13
CreateCombo("Dagesse", ["Kgt_g_08_new", "Kgt_g_s19_new"], kgt, KnightCombos) # Level 14
CreateCombo("Cimitarra", ["Kgt_g_08_new", "Kgt_g_01_7_new", "Kgt_g_18_11_22_new"], kgt, KnightCombos) # Level 15
CreateCombo("Maza3", ["Kgt_g_01low_new", "Kgt_g_b32kata_new"], kgt, KnightCombos) # Level 16
CreateCombo("DoubleSword", ["Kgt_g_12_new", "Kgt_g_02_new", "Kgt_g_22kata_23_new"], kgt, KnightCombos) # Level 17
CreateCombo("IceSword", ["Kgt_g_08_new", "Kgt_g_01_7_new", "Kgt_g_12_7_s1new"], kgt, KnightCombos) # Level 18
CreateCombo("Espadafilo", ["Kgt_g_08_new", "Kgt_g_09_07_s6low_new"], kgt, KnightCombos) # Level 18
CreateCombo("Espada", ["Kgt_g_07_new", "Kgt_g_29_3new"], kgt, KnightCombos) # Level 19

KnightLevelCombos = {}

CreateLevelCombo("RDA", 2, ["D_r", "g_d_r"], kgt, KnightLevelCombos, Combat.DODGE)
CreateLevelCombo("LDA", 2, ["D_l", "g_d_l"], kgt, KnightLevelCombos, Combat.DODGE)
CreateLevelCombo("NORTHCROSS", 3, ["Kgt_g_08_new", "Kgt_g_01_7_new"], kgt, KnightLevelCombos)
CreateLevelCombo("SPEEDKILL", 5, ["Kgt_g_12_new", "Kgt_g_02_new"], kgt, KnightLevelCombos)
CreateLevelCombo("HAWKATTACK", 6, ["Kgt_g_b06_new", "Kgt_g_19_bs1_new"], kgt, KnightLevelCombos)
CreateLevelCombo("LOWSMASH", 7, ["Kgt_g_01low_new", "Kgt_g_22lowkata_new"], kgt, KnightLevelCombos)
CreateLevelCombo("RIPPER", 8, ["Kgt_g_07_new", "Kgt_g_s3_new"], kgt, KnightLevelCombos)
CreateLevelCombo("SOUTHCROSS", 12, ["Kgt_g_08_new", "Kgt_g_01_7_new", "Kgt_g_3s9_6new"], kgt, KnightLevelCombos)

KnightAttackData = [
	# inner zone blocks:
	[Combat.BLOCK,  0.20, "tr",                 750.0, 1500.0, 3500.0, 0.50],
	[Combat.BLOCK,  0.20, "tl",                 750.0, 1500.0, 3500.0, 0.50],
	[Combat.BLOCK,  0.20, "tb",                 750.0, 1500.0, 3500.0, 0.50],
    [Combat.BLOCK,  0.40, "tf",                 750.0, 1500.0, 3500.0, 0.50],

    # outer zone blocks:
    [Combat.BLOCK,  0.05, "tr",                3500.0, 7000.0, 9000.0, 0.50],
    [Combat.BLOCK,  0.05, "tl",                3500.0, 7000.0, 9000.0, 0.50],
    [Combat.BLOCK,  0.35, "tb",                3500.0, 7000.0, 9000.0, 0.50],
    [Combat.BLOCK,  0.10, "tf",                3500.0, 7000.0, 9000.0, 0.50],

	# dodges
    [Combat.DODGE,  0.15, "d_r",                0.0, 1200.0, 2800.0, 0.35],
    [Combat.DODGE,  0.15, "d_l",                0.0, 1200.0, 2800.0, 0.35],
    [Combat.DODGE,  0.10, "d_b",                0.0, 1200.0, 2800.0, 0.35],

	# basic attacks
	[Combat.ATTACK, 0.05, ("GI_1H",),            1200.0, 1800.0, 2500.0, 0.35], # Light Attack 
	[Combat.ATTACK, 0.05, ("GM1_1H",),            1200.0, 1800.0, 2500.0, 0.35], # Light High Attack 
	[Combat.ATTACK, 0.05, ("GM8_1H",),            1200.0, 1800.0, 2500.0, 0.35], # Light Low Attack 
	[Combat.ATTACK, 0.05, ("GM6_1H",),            1200.0, 1800.0, 2500.0, 0.35], # Light Left Attack 
	[Combat.ATTACK, 0.05, ("GM3_1H",),            1200.0, 1800.0, 2500.0, 0.35], # Light Right Attack 

    # inner zone moves:
    [Combat.MOVE,   0.05, "tr",                   0.0, 2000.0, 5000.0, 0.35],
    [Combat.MOVE,   0.05, "tl",                   0.0, 2000.0, 5000.0, 0.35],
    [Combat.MOVE,   0.10, "tb",                   0.0, 2000.0, 5000.0, 0.35],
    [Combat.MOVE,   0.25, "tf",                   0.0, 2000.0, 5000.0, 0.35],
]


################################################################################
# BARBARIAN
################################################################################

bar=Bladex.GetCharType("Barbarian_N","Bar")
 
BarbarianCombos = {}

CreateCombo("Chaosword", ["Bar_g2h_b6kata", "Bar_g2h_b6"], bar, BarbarianCombos, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0) # Level 5
CreateCombo("Eclipse", ["Bar_g_axe111", "Bar_g_axe211"], bar, BarbarianCombos, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0) # Level 7
CreateCombo("Deathsword", ["Bar_g2h_b6kata", "Bar_g2h_b6low"], bar, BarbarianCombos, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0) # Level 8
CreateCombo("Guadanya", ["Bar_g_axe02", "Bar_g_axe33"], bar, BarbarianCombos, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0) # Level 9
CreateCombo("LongSword", ["Bar_g2h_s7", "Bar_g2h_13"], bar, BarbarianCombos, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0) # Level 10
CreateCombo("Alfanje", ["Bar_g2h_12low", "Bar_g2h_02low", "Bar_g2h_s8"], bar, BarbarianCombos, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0) # Level 11
CreateCombo("QueenSword", ["Bar_g_16", "Bar_g_06lowkata_new"], bar, BarbarianCombos) # Level 11
CreateCombo("Hacha2hojas", ["Bar_g_axe13", "Bar_g_axe34"], bar, BarbarianCombos, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0) # Level 12
CreateCombo("IceAxe", ["Bar_g_axe08", "Bar_g_axe30"], bar, BarbarianCombos, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0) # Level 13
CreateCombo("FireBigSword", ["Bar_g2h_08", "Bar_g2h_21_6kata", "Bar_g2h_21_2"], bar, BarbarianCombos, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0) # Level 13
CreateCombo("FlatSword", ["Bar_g2h_08", "Bar_g2h_28"], bar, BarbarianCombos, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0) # Level 14
CreateCombo("BigSword", ["Bar_g2h_b6kata", "Bar_g2h_b29"], bar, BarbarianCombos, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0) # Level 15
CreateCombo("RhinoClub", ["Bar_g_axe13", "Bar_g_axe12"], bar, BarbarianCombos, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0) # Level 16
CreateCombo("Hacharrajada", ["Bar_g_axe02", "Bar_g_axe32"], bar, BarbarianCombos, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0) # Level 18
CreateCombo("FireBigSword_18", ["Bar_g2h_08", "Bar_g2h_21_6kata", "Bar_g2h_earthpow"], bar, BarbarianCombos, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0) # Level 18
CreateCombo("SawSword", ["Bar_g2h_b6kata", "Bar_g2h_21_7"], bar, BarbarianCombos, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0) # Level 19

BarbarianLevelCombos1H = {}
BarbarianLevelCombos1H[0] = [
	# inner zone blocks:
	[Combat.BLOCK,  0.20, "tr",                 750.0, 1500.0, 3500.0, 0.50],
	[Combat.BLOCK,  0.20, "tl",                 750.0, 1500.0, 3500.0, 0.50],
	[Combat.BLOCK,  0.20, "tb",                 750.0, 1500.0, 3500.0, 0.50],
    [Combat.BLOCK,  0.40, "tf",                 750.0, 1500.0, 3500.0, 0.50],

    # outer zone blocks:
    [Combat.BLOCK,  0.05, "tr",                3500.0, 7000.0, 9000.0, 0.50],
    [Combat.BLOCK,  0.05, "tl",                3500.0, 7000.0, 9000.0, 0.50],
    [Combat.BLOCK,  0.35, "tb",                3500.0, 7000.0, 9000.0, 0.50],
    [Combat.BLOCK,  0.10, "tf",                3500.0, 7000.0, 9000.0, 0.50],

	[Combat.ATTACK, 0.05, ("GI_1H",),            1200.0, 1800.0, 2500.0, 0.35], # Attack 
	[Combat.ATTACK, 0.05, ("GM1_1H",),            1200.0, 1800.0, 2500.0, 0.35], # High Attack 
	[Combat.ATTACK, 0.05, ("GM4_1H",),            1200.0, 1800.0, 2500.0, 0.35], # Low Attack 
	[Combat.ATTACK, 0.05, ("GM3_1H",),            1200.0, 1800.0, 2500.0, 0.35], # Left Attack 
	[Combat.ATTACK, 0.05, ("GM2_1H",),            1200.0, 1800.0, 2500.0, 0.35], # Right Attack 
]

BarbarianLevelCombosAxe = {}
BarbarianLevelCombosAxe[0] = [
	[Combat.ATTACK, 0.05, ("GI_AXE",),            1500.0, 2500.0, 3500.0, 0.35], # Attack 
	[Combat.ATTACK, 0.05, ("GM17_AXE",),            1500.0, 2500.0, 3500.0, 0.35], # High Attack 
	[Combat.ATTACK, 0.05, ("GM28_AXE",),            1500.0, 2500.0, 3500.0, 0.35], # Low Attack 
	[Combat.ATTACK, 0.05, ("GM21_AXE",),            1500.0, 2500.0, 3500.0, 0.35], # Left Attack 
	[Combat.ATTACK, 0.05, ("GM19_AXE",),            1500.0, 2500.0, 3500.0, 0.35], # Right Attack 
]

BarbarianLevelCombos2H = {}
BarbarianLevelCombos2H[0] = [
	[Combat.ATTACK, 0.05, ("GI_2H",),            1500.0, 2500.0, 3500.0, 0.35], # Attack 
	[Combat.ATTACK, 0.05, ("GM1_2H",),            1500.0, 2500.0, 3500.0, 0.35], # High Attack 
	[Combat.ATTACK, 0.05, ("GM10_2H",),            1500.0, 2500.0, 3500.0, 0.35], # Low Attack 
	[Combat.ATTACK, 0.05, ("GM7_2H",),            1500.0, 2500.0, 3500.0, 0.35], # Left Attack 
	[Combat.ATTACK, 0.05, ("GM4_2H",),            1500.0, 2500.0, 3500.0, 0.35], # Right Attack 
]

#AXE ABILITIES
CreateLevelCombo("RDAXE", 3, ["D_r", "g_d_r_axe"], bar, BarbarianLevelCombosAxe, Combat.DODGE)
CreateLevelCombo("LDAXE", 3, ["D_l", "g_d_l_axe"], bar, BarbarianLevelCombosAxe, Combat.DODGE)
CreateLevelCombo("SUPERSMASH", 8, ["Bar_g_axe18", "Bar_g_axe01"], bar, BarbarianLevelCombosAxe, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0)
CreateLevelCombo("SHREDDER", 11, ["Bar_g_axe18", "Bar_g_axe31"], bar, BarbarianLevelCombosAxe, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0)

#SWORDS ABILITIES
CreateLevelCombo("RAGE", 2, ["Bar_g2h_11", "Bar_g2h_02kata"], bar, BarbarianLevelCombos2H, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0)
CreateLevelCombo("RDSW", 3, ["D_r", "g2h_d_r"], bar, BarbarianLevelCombos2H, Combat.DODGE)
CreateLevelCombo("LDSW", 3, ["D_l", "g2h_d_l"], bar, BarbarianLevelCombos2H, Combat.DODGE)
CreateLevelCombo("THUNDERSMASH", 6, ["Bar_g2h_s7", "Bar_g2h_01"], bar, BarbarianLevelCombos2H, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0)
CreateLevelCombo("THUNDERSWEEP", 7, ["Bar_g2h_12low", "Bar_g2h_02low"], bar, BarbarianLevelCombos2H, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0)
CreateLevelCombo("SKYSMASH", 8, ["Bar_g2h_b6kata", "Bar_g2h_b7"], bar, BarbarianLevelCombos2H, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0)
CreateLevelCombo("DEATHDEALER", 9, ["Bar_g2h_08", "Bar_g2h_21_6kata"], bar, BarbarianLevelCombos2H, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0)
CreateLevelCombo("HELLWIND", 12, ["Bar_g2h_08", "Bar_g2h_21_6kata", "Bar_g2h_26_b6"], bar, BarbarianLevelCombos2H, Combat.ATTACK, 0.3, 1500.0, 2500.0, 3500.0)

BarbarianAttackData = [
	# dodges
    [Combat.DODGE,  0.35, "d_r",                0.0, 1200.0, 2800.0, 0.35],
    [Combat.DODGE,  0.35, "d_l",                0.0, 1200.0, 2800.0, 0.35],
    [Combat.DODGE,  0.30, "d_b",                0.0, 1200.0, 2800.0, 0.35],

    # inner zone moves:
    [Combat.MOVE,   0.05, "tr",                   0.0, 2000.0, 5000.0, 0.35],
    [Combat.MOVE,   0.05, "tl",                   0.0, 2000.0, 5000.0, 0.35],
    [Combat.MOVE,   0.10, "tb",                   0.0, 2000.0, 5000.0, 0.35],
    [Combat.MOVE,   0.25, "tf",                   0.0, 2000.0, 5000.0, 0.35],
]


################################################################################
# Dwarf
################################################################################

dwf=Bladex.GetCharType("Dwarf_N","Dwf_N")
 
DwarfCombos = {}

CreateCombo("Garrote", ["Dwf_g_01low_new", "Dwf_g_14"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 3
CreateCombo("Hacha", ["Dwf_g_08", "Dwf_g_15"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 4
CreateCombo("Hacha5", ["Dwf_g_02", "Dwf_g_07"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 7
CreateCombo("Garropin", ["Dwf_g_08", "Dwf_g_11"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 8
CreateCombo("Hacha4", ["Dwf_g_02", "Dwf_g_16"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 9
CreateCombo("Hacha3", ["Dwf_g_02", "Dwf_g_05"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 10
CreateCombo("QueenSword", ["Dwf_g_06", "Dwf_g_06lowkata_new"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 11
CreateCombo("Martillo", ["Dwf_g_01", "Dwf_g_12"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 11
CreateCombo("Martillo2", ["Dwf_g_01low_new", "Dwf_g_18"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 12
CreateCombo("IceHammer", ["Dwf_g_01", "Dwf_g_09"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 13
CreateCombo("Garrote2", ["Dwf_g_08", "Dwf_g_13"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 14
CreateCombo("MazaDoble", ["Dwf_g_08", "Dwf_g_21"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 15
CreateCombo("Hacha6", ["Dwf_g_01", "Dwf_g_s3_new"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 16
CreateCombo("CrushHammer", ["Dwf_g_01low_new", "Dwf_g_s22low_new"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 17
CreateCombo("Hacha2", ["Dwf_g_06", "Dwf_g_17"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 18
CreateCombo("FireAxe", ["Dwf_g_01", "Dwf_g_22"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 18
CreateCombo("Martillo3", ["Dwf_g_08", "Dwf_g_31"], dwf, DwarfCombos, Combat.ATTACK, 0.6) # Level 19

DwarfLevelCombos = {}

CreateLevelCombo("RDA", 2, ["D_r", "g_d_r"], dwf, DwarfLevelCombos, Combat.DODGE, 0.15)
CreateLevelCombo("LDA", 2, ["D_l", "g_d_l"], dwf, DwarfLevelCombos, Combat.DODGE, 0.15)
CreateLevelCombo("CYCLONE", 5, ["Dwf_g_01", "Dwf_g_26"], dwf, DwarfLevelCombos, Combat.ATTACK, 0.40)

DwarfAttackData = [
	# inner zone blocks:
	[Combat.BLOCK,  0.20, "tr",                 750.0, 1500.0, 3500.0, 0.50],
	[Combat.BLOCK,  0.20, "tl",                 750.0, 1500.0, 3500.0, 0.50],
	[Combat.BLOCK,  0.20, "tb",                 750.0, 1500.0, 3500.0, 0.50],
    [Combat.BLOCK,  0.40, "tf",                 750.0, 1500.0, 3500.0, 0.50],

    # outer zone blocks:
    [Combat.BLOCK,  0.05, "tr",                3500.0, 7000.0, 9000.0, 0.50],
    [Combat.BLOCK,  0.05, "tl",                3500.0, 7000.0, 9000.0, 0.50],
    [Combat.BLOCK,  0.35, "tb",                3500.0, 7000.0, 9000.0, 0.50],
    [Combat.BLOCK,  0.10, "tf",                3500.0, 7000.0, 9000.0, 0.50],

	# dodges
    [Combat.DODGE,  0.10, "d_r",                0.0, 1200.0, 2800.0, 0.35],
    [Combat.DODGE,  0.10, "d_l",                0.0, 1200.0, 2800.0, 0.35],
    [Combat.DODGE,  0.10, "d_b",                0.0, 1200.0, 2800.0, 0.35],

	# basic attacks
	[Combat.ATTACK, 0.1, ("GI_1H",),            0.0, 1800.0, 2500.0, 0.35], # Light Attack 
	[Combat.ATTACK, 0.1, ("GM12_1H",),          0.0, 1800.0, 2500.0, 0.35], # Light High Attack 
	[Combat.ATTACK, 0.1, ("GM18_1H",),          0.0, 1800.0, 2500.0, 0.35], # Light Low Attack 
	[Combat.ATTACK, 0.1, ("GM16_1H",),          0.0, 1800.0, 2500.0, 0.35], # Light Left Attack 
	[Combat.ATTACK, 0.1, ("GM14_1H",),          0.0, 1800.0, 2500.0, 0.35], # Light Right Attack 

    # inner zone moves:
    [Combat.MOVE,   0.05, "tr",                   0.0, 2000.0, 5000.0, 0.35],
    [Combat.MOVE,   0.05, "tl",                   0.0, 2000.0, 5000.0, 0.35],
    [Combat.MOVE,   0.10, "tb",                   0.0, 2000.0, 5000.0, 0.35],
    [Combat.MOVE,   0.25, "tf",                   0.0, 2000.0, 5000.0, 0.35],
]

################################################################################
# AMAZON
################################################################################

amz=Bladex.GetCharType("Amazon_N","Amz_N")
 
AmazonCombos = {}

CreateCombo("Bo", ["Amz_g_spear16low", "Amz_g_spears8"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 3
CreateCombo("Bichero", ["Amz_g_spear08", "Amz_g_spear_2katab6low"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 7
CreateCombo("Lanza", ["Amz_g_spears1", "Amz_g_spear19"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 8
CreateCombo("Naginata", ["Amz_g_spear12", "Amz_g_06lowkata_new"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 9
CreateCombo("Tridente", ["Amz_g_spears1", "Amz_g_spear09"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 10
CreateCombo("QueenSword", ["Amz_g_06", "Amz_g_06lowkata_new"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 11
CreateCombo("Axpear", ["Amz_g_spears6", "Amz_g_spear32kata_b2"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 11
CreateCombo("DeathBo", ["Amz_g_spear08", "Amz_g_spear_kata23"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 12
CreateCombo("IceWand", ["Amz_g_spears1", "Amz_g_spear16"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 13
CreateCombo("Crosspear", ["Amz_g_spears6", "Amz_g_spear13"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 14
CreateCombo("FireBo", ["Amz_g_spears1", "Amz_g_spear_b6_26"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 15
CreateCombo("Hachacuchilla", ["Amz_g_spear12", "Amz_g_spear3s2"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 15
CreateCombo("CrushBo", ["Amz_g_spear08", "Amz_g_spear_21"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 16
CreateCombo("Arpon", ["Amz_g_spears1", "Amz_g_spear_b29"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 17
CreateCombo("SteelFeather", ["Amz_g_spear08", "Amz_g_spear19_bs1"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 18
CreateCombo("Naginata2", ["Amz_g_spears1", "Amz_g_spear26kata", "Amz_g_spear33"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 18
CreateCombo("LanzaAncha", ["Amz_g_spear16low", "Amz_g_spear_sb11"], amz, AmazonCombos, Combat.ATTACK, 0.6, 1500.0, 2500.0, 3500.0) # Level 19

AmazonLevelCombos1H = {}
AmazonLevelCombos1H[0] = [
	# inner zone blocks:
	[Combat.BLOCK,  0.20, "tr",                 750.0, 1500.0, 3500.0, 0.50],
	[Combat.BLOCK,  0.20, "tl",                 750.0, 1500.0, 3500.0, 0.50],
	[Combat.BLOCK,  0.20, "tb",                 750.0, 1500.0, 3500.0, 0.50],
    [Combat.BLOCK,  0.40, "tf",                 750.0, 1500.0, 3500.0, 0.50],

    # outer zone blocks:
    [Combat.BLOCK,  0.05, "tr",                3500.0, 7000.0, 9000.0, 0.50],
    [Combat.BLOCK,  0.05, "tl",                3500.0, 7000.0, 9000.0, 0.50],
    [Combat.BLOCK,  0.35, "tb",                3500.0, 7000.0, 9000.0, 0.50],
    [Combat.BLOCK,  0.10, "tf",                3500.0, 7000.0, 9000.0, 0.50],

	[Combat.ATTACK, 0.05, ("GM16_1H",),            1200.0, 1800.0, 2500.0, 0.35], # Attack 
	[Combat.ATTACK, 0.05, ("GM17_1H",),            1200.0, 1800.0, 2500.0, 0.35], # High Attack 
	[Combat.ATTACK, 0.05, ("GM20_1H",),            1200.0, 1800.0, 2500.0, 0.35], # Low Attack 
	[Combat.ATTACK, 0.05, ("GM19_1H",),            1200.0, 1800.0, 2500.0, 0.35], # Left Attack 
	[Combat.ATTACK, 0.05, ("GM18_1H",),            1200.0, 1800.0, 2500.0, 0.35], # Right Attack 
]

AmazonLevelCombosSP = {}
AmazonLevelCombosSP[0] = [
	[Combat.ATTACK, 0.05, ("GI_SP",),            1200.0, 1800.0, 2500.0, 0.35], # Attack 
	[Combat.ATTACK, 0.05, ("GM1_SP",),            1200.0, 1800.0, 2500.0, 0.35], # High Attack 
	[Combat.ATTACK, 0.05, ("GM8_SP",),            1200.0, 1800.0, 2500.0, 0.35], # Low Attack 
	[Combat.ATTACK, 0.05, ("GM6_SP",),            1200.0, 1800.0, 2500.0, 0.35], # Left Attack 
	[Combat.ATTACK, 0.05, ("GM3_SP",),            1200.0, 1800.0, 2500.0, 0.35], # Right Attack 
]

CreateLevelCombo("WHIRLWIND", 2, ["Amz_g_spears1", "Amz_g_spear26kata"], amz, AmazonLevelCombosSP, Combat.ATTACK, 0.5, 1500.0, 2500.0, 3500.0)

AmazonAttackData = [
	# inner zone blocks:
	[Combat.BLOCK,  0.20, "tr",                 750.0, 1500.0, 3500.0, 0.50],
	[Combat.BLOCK,  0.20, "tl",                 750.0, 1500.0, 3500.0, 0.50],
	[Combat.BLOCK,  0.20, "tb",                 750.0, 1500.0, 3500.0, 0.50],
    [Combat.BLOCK,  0.40, "tf",                 750.0, 1500.0, 3500.0, 0.50],

    # outer zone blocks:
    [Combat.BLOCK,  0.05, "tr",                3500.0, 7000.0, 9000.0, 0.50],
    [Combat.BLOCK,  0.05, "tl",                3500.0, 7000.0, 9000.0, 0.50],
    [Combat.BLOCK,  0.35, "tb",                3500.0, 7000.0, 9000.0, 0.50],
    [Combat.BLOCK,  0.10, "tf",                3500.0, 7000.0, 9000.0, 0.50],

	# dodges
    [Combat.DODGE,  0.35, "d_r",                0.0, 1200.0, 2800.0, 0.35],
    [Combat.DODGE,  0.35, "d_l",                0.0, 1200.0, 2800.0, 0.35],
    [Combat.DODGE,  0.30, "d_b",                0.0, 1200.0, 2800.0, 0.35],

    # inner zone moves:
    [Combat.MOVE,   0.05, "tr",                   0.0, 2000.0, 5000.0, 0.35],
    [Combat.MOVE,   0.05, "tl",                   0.0, 2000.0, 5000.0, 0.35],
    [Combat.MOVE,   0.10, "tb",                   0.0, 2000.0, 5000.0, 0.35],
    [Combat.MOVE,   0.25, "tf",                   0.0, 2000.0, 5000.0, 0.35],
]
