######################################################################################	
# Playground Menus and Widgets
# by Josh Dahlby
######################################################################################	
import Bladex
import PlayCfg
import Language
import MenuText

def LoadPlayground(option):
	import Bladex
	Bladex.LoadLevel("Playground")

def GetTeam1Value():
	return PlayCfg.Team1Types

def SetTeam1Value(option):
	PlayCfg.Team1Types = option
	PlayCfg.SaveConfiguration()

def GetTeam2Value():
	return PlayCfg.Team2Types

def SetTeam2Value(option):
	PlayCfg.Team2Types = option
	PlayCfg.SaveConfiguration()

######################################################################################	
# Enemy list widget.  Modified netwidgets.MapListWidget.
######################################################################################	

import Menu
import MenuWidget
import BUIx
class B_EnemyListWidget(BUIx.B_RectWidget,MenuWidget.B_MenuTreeItem):
	def __init__(self,Parent,MenuDescr,StackMenu):
		import BBLib
		import DefaultScorerData
		import Reference
		import Bladex
		import Raster

		name=MenuDescr["LeftMap"]
		self.LeftMap       = BBLib.B_BitMap24()
		self.LeftMap.ReadFromBMP(name)
		self.LSize,garbage = self.LeftMap.GetDimension()

		name=MenuDescr["RightMap"]
		self.RightMap      = BBLib.B_BitMap24()
		self.RightMap.ReadFromBMP(name)
		self.RSize,garbage = self.RightMap.GetDimension()

		name=MenuDescr["SelMap"]
		self.SelMap      = BBLib.B_BitMap24()
		self.SelMap.ReadFromBMP(name)
		self.SSize,self.vidh = self.SelMap.GetDimension()

		name=MenuDescr["MarkMap"]
		self.MarkMap     = BBLib.B_BitMap24()
		self.MarkMap.ReadFromBMP(name)
		self.SSize,self.vidh = self.MarkMap.GetDimension()

		self.vidw = self.SSize*3+self.LSize+self.RSize

		UseEnemies = ("Spidersmall", "Cos", "Ork", "Great_Ork", "Ragnar", 
			"Knight_Traitor", "Dark_Knight", "ChaosKnight", "Knight_Zombie", "Lich", 
			"Skeleton", "Salamander", "Troll_Dark", "Troll_snow", "Minotaur", 
			"Golem_clay", "Golem_stone", "Golem_metal", "Golem_lava", "Golem_ice", 
			"Vamp", "Little_Demon", "Great_Demon", "DalGurak", "Knight_N", 
			"Barbarian_N", "Amazon_N", "Dwarf_N", 
		#	"DarkLord", "Enano1", "Enano2", "Gold_Ork", "Dark_Ork",
		)
		DefaultScorerData.Init()
		# Setup the missing ones
		Bladex.ReadBitMap("../../Data/Icons/icono barbaro.bmp","BarbarianIcon")
		Reference.EnemiesDefaultScorerData['Barbarian_N']=("BarbarianIcon","Barbarian")
		Bladex.ReadBitMap("../../Data/Icons/icono amazona.bmp","AmazonIcon")
		Reference.EnemiesDefaultScorerData['Amazon_N']=("AmazonIcon","Amazon")
		Bladex.ReadBitMap("../../Data/Icons/icono enano.bmp","DwarfIcon")
		Reference.EnemiesDefaultScorerData['Dwarf_N']=("DwarfIcon","Dwarf")

		self.Bitmap=[]
		self.IDX = 0

		self.EnemySetValue = MenuDescr["EnemySetValue"]
		dta			       = MenuDescr["EnemyGetValue"]()
		if len(dta) == 0:
			dta = UseEnemies

		for enemy in UseEnemies:
			try:
				ref = Reference.EnemiesDefaultScorerData[enemy]
				bitm = Raster.BmpHandle(ref[0])
				self.Bitmap.append([bitm, enemy, MenuText.GetMenuText(ref[1]), 0])
			except:
				pass

			for j in dta:
				if j == enemy:
					self.Bitmap[len(self.Bitmap)-1][3] = 1

		self.MapW = (self.SSize - 64)/2
		self.MapH = (self.vidh  - 64)/2

		BUIx.B_RectWidget.__init__(self,Parent,MenuDescr["Name"],self.vidw,self.vidh)
		MenuWidget.B_MenuTreeItem.__init__(self,MenuDescr,StackMenu)

		self.Selected=0
		self.Solid=0
		self.Border=0
		self.SetDrawFunc(self.Draw)

	def Draw(self,x,y,time):
		import Raster
		if self.IDX == 0:
			first = len(self.Bitmap)-1
		else:
			first = self.IDX-1

		if self.IDX == len(self.Bitmap)-1:
			last = 0
		else:
			last = self.IDX+1


		bmps = [first, self.IDX, last]
		for i in range(len(bmps)):
			if self.Bitmap[bmps[i]][3]:
				Raster.SetPosition(x+self.SSize*i+self.LSize, y)
				Raster.DrawImage(self.SSize,self.vidh,"BGR","Normal",self.MarkMap.GetData())

		if self.GetHasFocus():
			Raster.SetPosition(x,y+self.MapH)
			Raster.DrawImage(self.LSize,self.vidh-2*self.MapH,"BGR","Normal",self.LeftMap.GetData())

			Raster.SetPosition(x+self.SSize*3+self.LSize, y+self.MapH)
			Raster.DrawImage(self.LSize,self.vidh-2*self.MapH,"BGR","Normal",self.RightMap.GetData())

			if int(time*5)%2 == 0:
				Raster.SetPosition(x+self.SSize*1+self.LSize, y)
				Raster.DrawImage(self.SSize,self.vidh,"BGR","Normal",self.SelMap.GetData())

		bmpWidth = self.SSize-2*self.MapW
		bmpHeight = self.vidh-2*self.MapH
		Raster.SetPenColor(255,255,255)
		for i in range(len(bmps)):
			Raster.SetPosition(x+self.MapW+self.SSize*i+self.LSize, y+self.MapH)
			Raster.DrawBitmap(self.Bitmap[bmps[i]][0], bmpWidth, bmpHeight)


		self.DefDraw(x,y,time)

		#netwidgets.LabelName = self.Bitmap[self.IDX][2]

	def IncMenuItem(self):
		self.IDX = self.IDX+1
		if self.IDX >= len(self.Bitmap):
			self.IDX = 0


	def DecMenuItem(self):
		self.IDX = self.IDX-1
		if self.IDX < 0:
			self.IDX = len(self.Bitmap)-1

	def ActivateItem(self,act):
		if not act:
			MenuWidget.B_MenuTreeItem.ActivateItem(self,act)
			return
		self.Bitmap[self.IDX][3] = not self.Bitmap[self.IDX][3]
		v = []
		for i in self.Bitmap:
			if i[3]:
				v.append(i[1])
		self.EnemySetValue(v)


	def AcceptsFocus(self):
		return 1

################################################################################
# The menu
################################################################################

global ModMenu
ModMenu = [
	{
	"Name":MenuText.GetMenuText("TEAM 1"),
	"Kind":MenuWidget.B_MenuItemTextNoFXNoFocus,
	"Font":Menu.MenuFontBig,
	"VSep":20,
	},
	{
	"Name"       : "Team 1 List",
	"Kind"       : B_EnemyListWidget,                                                                    
	"LeftMap"    : "../../Data/net/MapL.bmp",
	"RightMap"   : "../../Data/net/MapR.bmp",
	"SelMap"     : "../../Data/net/MapM.bmp",
	"MarkMap"    : "../../Data/net/MapS.bmp",
	"EnemyGetValue": GetTeam1Value,
	"EnemySetValue": SetTeam1Value,
	"VSep"		 : 10,
	},
	{
	"Name":MenuText.GetMenuText("TEAM 2"),
	"Kind":MenuWidget.B_MenuItemTextNoFXNoFocus,
	"Font":Menu.MenuFontBig,
	"VSep":20,
	},
	{
	"Name"       : "Team 2 List",
	"Kind"       : B_EnemyListWidget,                                                                    
	"LeftMap"    : "../../Data/net/MapL.bmp",
	"RightMap"   : "../../Data/net/MapR.bmp",
	"SelMap"     : "../../Data/net/MapM.bmp",
	"MarkMap"    : "../../Data/net/MapS.bmp",
	"EnemyGetValue": GetTeam2Value,
	"EnemySetValue": SetTeam2Value,
	"VSep"		 : 10,
	},
	{
	"Name":MenuText.GetMenuText("START"),
	"Font":Menu.MenuFontBig,
	"VSep":20,
	"Command": LoadPlayground,
	},
	{
	"Name"    : MenuText.GetMenuText("BACK"),
	"VSep"    : 10,
	"Command" : Menu.BackMenu,
	"Font"    : Menu.MenuFontBig,
	},
	{
	"Name":"Back",
	"Kind":MenuWidget.B_BackBlank,
	}
	]
