###############################################################################
#  Playground
#  by Josh Dahlby
###############################################################################
import Bladex
import Reference
import GladTypes
import GladCombat
import TeamGen
import whrandom
import Actions
import PlayCfg

###############################################################################
# Positioning
###############################################################################

spawnPositions = [
	{"Position": (0, -4000, 16000), "Angle": 0 },
	{"Position": (0, -4000, -16000), "Angle": 0 },
	{"Position": (16000, -4000, 0), "Angle": 0 },
	{"Position": (-16000, -4000, 0), "Angle": 0 },
	{"Position": (10000, -4000, 10000), "Angle": 0 },
	{"Position": (10000, -4000, -10000), "Angle": 0 },
	{"Position": (-10000, -4000, 10000), "Angle": 0 },
	{"Position": (-10000, -4000, -10000), "Angle": 0 }
	]

def GetPosition():
	return spawnPositions[whrandom.randint(0, len(spawnPositions)-1)]["Position"];

###############################################################################
# This function makes the enemies fight eachother
###############################################################################

Team1Name = None
Team2Name = None

Team1Member = None
Team2Member = None

def OnShowEnemy(ally):
	global Team1Name
	global Team2Name
	global Team1Member
	global Team2Member

	enemyMember = None;
	if ally.CombatGroup == Team1Name:
		if (Team2Member) and (Bladex.GetEntity(Team2Member)) and (Bladex.GetEntity(Team2Member).Life > 0):
			enemyMember = Team2Member;
		if (not Team1Member) or (not Bladex.GetEntity(Team1Member)) or (Bladex.GetEntity(Team1Member).Life <= 0):
			Team1Member = ally.Name;
	else:
		if (Team1Member) and (Bladex.GetEntity(Team1Member)) and (Bladex.GetEntity(Team1Member).Life > 0):
			enemyMember = Team1Member;
		if (not Team2Member) or (not Bladex.GetEntity(Team2Member)) or (Bladex.GetEntity(Team2Member).Life <= 0):
			Team2Member = ally.Name;

	# If there is no enemy, then get out
	if not enemyMember:
		return;
	
	enemy = Bladex.GetEntity(enemyMember);
	if not enemy: 
		return;

	if enemy.Life <= 0:
		enemy_list = enemy.GetCombatants()
		for enemy_name in enemy_list:
			enemy = Bladex.GetEntity(enemy_name);
			if enemy.Life > 0:
				break;

	ally.Wuea = Reference.WUEA_ENDED
	ally.InterruptCombat()
	enemy.Wuea = Reference.WUEA_ENDED
	enemy.InterruptCombat()
	Actions.TurnToFaceEntity(ally.Name, enemy.Name)
	Actions.TurnToFaceEntity(enemy.Name, ally.Name)
	ally.SetEnemy(enemy)
	ally.SetActiveEnemy(enemy)
	ally.Chase(enemy, ally.ActionAreaMax)
	enemy.SetEnemy(ally)
	enemy.SetActiveEnemy(ally)
	enemy.Chase(ally, enemy.ActionAreaMax)

###############################################################################
# Key implementation
###############################################################################

def KillSelected():
	char = Bladex.GetEntity("Player1")
	if char.Data.selected_enemy:
		en = Bladex.GetEntity(char.Data.selected_enemy[0])
		if en:
			en.Life = 0

Bladex.AddInputAction("KillSelected", 0)
Bladex.AddBoundFunc("KillSelected", KillSelected)
Bladex.AssocKey("KillSelected", "Keyboard", "K", 1)

###############################################################################
# Start the fun
###############################################################################

Team1Gen = TeamGen.EnemyGenerator("Player1", PlayCfg.Team1Types, GetPosition, None, None, OnShowEnemy, 0, 1)
Team1Name = "generated" + str(Team1Gen.ObjId);
Team2Gen = TeamGen.EnemyGenerator("Player1", PlayCfg.Team2Types, GetPosition, None, None, OnShowEnemy, 0, 1)
Team2Name = "generated" + str(Team2Gen.ObjId);
Team1Gen.StartGeneration()
Team2Gen.StartGeneration()

