######################################################################################	
# Skins Mod (by Josh Dahlby)
######################################################################################	
import Bladex
import NetworkResources
import Actions

def GetMeshIndex():
	import NetMisc
	player = Bladex.GetEntity("Player1");
	pkind = player.Kind[:len(player.Kind)-2];
	meshidx = 0;
	try:
		meshidx = NetMisc.Caracteres[pkind].index(player.MeshName) - 2;
	except:
		pass
	if meshidx < 0:
		meshidx = 0;
	return meshidx

def SetMeshIndex(meshidx):
	import NetMisc
	player = Bladex.GetEntity("Player1");
	pkind = player.Kind[:len(player.Kind)-2];
	mesh = NetMisc.Caracteres[pkind][meshidx+2];
	if meshidx == 0:
		level = player.Data.armour_level
		ct = Bladex.GetCharType(player.CharType, player.CharTypeExt)
		if level==0:
			mesh = ct.NoArmour;
		elif level==1:
			mesh = ct.LowArmour;
		elif level==2:
			mesh = ct.MedArmour;
		elif level==3:
			mesh = ct.HighArmour;
	player.SetMesh(mesh);


def SwitchSkin():
	player = Bladex.GetEntity("Player1");
	meshidx = GetMeshIndex()+1;
	if meshidx > 2:
	  meshidx = 0;
	SetMeshIndex(meshidx);

Bladex.AddInputAction("SwitchSkin", 0)
Bladex.AddBoundFunc("SwitchSkin", SwitchSkin)
Bladex.AssocKey("SwitchSkin", "Keyboard", "U", 1)

import Menu
import MenuText
import KeybWidget
keyMenu = {
	"Name":MenuText.GetMenuText("Switch Skin"),
	"Position": Menu.CtrlsPosition,
	"Action": "SwitchSkin", 
	"Kind": KeybWidget.ControlMenuItem,
    "kFlags":[], "Size":(200,300)}

Menu.GetMenuItem(['CONTROLS','KEYBOARD', 'KeybList'])['ListDescr'].append(keyMenu);

import acts
acts.ConfigurableActions.append(("Switch Skins", "SwitchSkin", [],));

import BInput
IManager = BInput.GetInputManager()
oldSet = IManager.GetInputActionsSet()
IManager.SetInputActionsSet("Default")
IActions = IManager.GetInputActions()
IAction = IActions.Find("SwitchSkin")
if IAction.Name() == "NULL":
	Bladex.AddInputAction("SwitchSkin", 0)
	Bladex.AddBoundFunc("SwitchSkin", SwitchSkin)
	Bladex.AssocKey("SwitchSkin", "Keyboard", "U", 1)
IManager.SetInputActionsSet(oldSet)
if IAction.Name() == "NULL":
	import KeybWidget
	KeybWidget.SaveListConfig()

OldTakeArmour = Actions.TakeArmour

def TakeArmour(EntityName):
	meshidx = GetMeshIndex();
	try:
		OldTakeArmour(EntityName);
	except:
		pass
	if meshidx != 0:
		SetMeshIndex(meshidx)

Actions.TakeArmour = TakeArmour
