

import Bladex
import ExtraData
import GameText
import Raster
import Scorer
import AuxFuncs
import ItemTypes
import GenFX
import whrandom

import pCONFIG

GameText.MapList ['PLATEAU'] = 'Plateau'

execfile("sol.py")




################################################################################
# player init
################################################################################


def PlateauInit():

	p1 = GenFX.AddParticles("Player1", "LittleEnergyDissip", 6000, 60, 0, 0.05, 20, 0.1)
	p2 = GenFX.AddParticles("Player1", "FastEnergyConc", 600, 3, -10, 0.01, 20, 1.0)
	o = Bladex.GetEntity("Player1")
	AuxFuncs.FadeObject(o.Name, 0, 1, 3)

	o = Bladex.GetEntity("armor")
	o.SelfIlum = 1
	AuxFuncs.FadeObject(o.Name, 0, 1, 4)
	o.Impulse(0,-50000,0)


Bladex.AddScheduledFunc(Bladex.GetTime(), PlateauInit,())





################################################################################
# change stars pos 
################################################################################ 


xCoord = []
yCoord = []
zCoord = []

for i in range(25): 

	xCoord.append(i * 1000)
	xCoord.append(i * -1000)
	yCoord.append(i * 1000)
	yCoord.append(i * -1000)


for i in range(20):

	# zCoord.append(i * 1000)
	zCoord.append(i * -1000)




def flicker_star(name):

	global StarsNumber
	global xCoord
	global yCoord
	global zCoord

	idx = whrandom.randint(0, len(xCoord)-1)
	xCOORD = xCoord[idx]
	
	idx = whrandom.randint(0, len(yCoord)-1)
	yCOORD = yCoord[idx]

	idx = whrandom.randint(0, len(zCoord)-1)
	zCOORD = zCoord[idx]

	o=Bladex.GetEntity(name)
	o.Position = (xCOORD, zCOORD, yCOORD)

	delay = whrandom.randint(0,1)
	if (delay == 0):
		time = whrandom.randint(100,300) / 100
	else:   time = whrandom.randint(25,75) / 100

	Bladex.AddScheduledFunc(Bladex.GetTime()+time, flicker_star,(o.Name, ))




def flicker_colored_star(name):

	global StarsNumber
	global xCoord
	global yCoord
	global zCoord

	idx = whrandom.randint(0, len(xCoord)-1)
	xCOORD = xCoord[idx]
	
	idx = whrandom.randint(0, len(yCoord)-1)
	yCOORD = yCoord[idx]

	idx = whrandom.randint(0, len(zCoord)-1)
	zCOORD = zCoord[idx]

	o=Bladex.GetEntity(name)
	o.Color = whrandom.randint(0, 255),whrandom.randint(0, 255),whrandom.randint(0, 255)
	o.Position = (xCOORD, zCOORD, yCOORD)

	delay = whrandom.randint(0,1)
	if (delay == 0):
		time = whrandom.randint(100,300) / 100
	else:   time = whrandom.randint(25,75) / 100
		
	Bladex.AddScheduledFunc(Bladex.GetTime()+time, flicker_colored_star,(o.Name, ))