import Bladex
import Auras
import ItemTypes
import MenuText
import GameText


o=Bladex.CreateEntity("PwrUpOrb","EsferaGemaAzul",14500, -1500, 0,"Weapon")
o.Scale=3
o.SelfIlum=0
o.Orientation=0.7,0.7,0,0
o.Static=1
ItemTypes.ItemDefaultFuncs (o)

OrbWork=1   # SET FLAG FOR ORB


###############################
def GetText(s):
	return MenuText.GetMenuText(s)
def ClearText():
	GameText.ClearText()
###############################


def BreakCycle():
	o=Bladex.GetEntity("PwrUpOrb")
	o.Alpha=1                       ### Make Orb visible

	global OrbWork
	OrbWork=1                       ### Reset Trigger Flag

	ClearText()
	GameText.WriteTextAux(GetText("Power-up ready!"), 5.0, 255,170,0,10,200,[])

#######

def TakePower():
	me = Bladex.GetEntity("Player1")
	me.Data.FDefense = 1.0
	me.Data.FAttack = 1.0

	Bladex.AddScheduledFunc(Bladex.GetTime() + 60.0, BreakCycle,())

	ClearText()
	GameText.WriteTextAux(GetText("Power-up drained!"), 5.0, 255,170,0,10,200,[])
####################################################

def GivePower():
	destro=Bladex.GetEntity("PwrUpOrb")
	destro.Alpha=0             # Makes orb invisible so you can just reappear it!
	me = Bladex.GetEntity("Player1")
	aura= Auras.MakeAura ("Player1",10.0,(80, 1, 1, 0,0,1), (),(),(2, 0.0, 0.0, 1.0, 0.6, 0.0, 0.3, 1.0, 0.5, 0.0, 0.6))
	me.Data.FDefense = 4.0
	me.Data.FAttack = 8.0
	sound=Bladex.CreateSound("..\\..\\Sounds\\Demon-spirit2.wav", "SndAppSwrd")
	sound.Volume=10
	sound.MinDistance=1000000.0
	sound.MaxDistance=1000000.0
	sound.Play(o.Position[0], o.Position[1], o.Position[2], 0)
	Bladex.AddScheduledFunc(Bladex.GetTime() + 10.0, TakePower,())
	ClearText()
	GameText.WriteTextAux(GetText("You have Power-up!"), 5.0, 255,170,0,10,200,[])

#########


def GetGivePower(sector,entity):
    if (entity == "Player1"): ## You don't want enemies to trigger it!!!
	global OrbWork
	if OrbWork==1: # If the Flag is on, give power and turn off Flag...
		OrbWork=0
		GivePower()

GivePowerTrigger = Bladex.GetSector(14500, -1500, 0)
GivePowerTrigger.OnEnter = GetGivePower
