######################################################################################	
# Gladiator Menus and Widgets
# by Josh Dahlby
######################################################################################	

import Menu
import MenuWidget

# Mod imports

import NetMisc
import Bladex
import GladCfg

# Translations

import Language
import MenuText

SCharText = "Press ENTER to use the selected character\nPress DELETE to remove the selected character"
SCharExists = "A character with that name already exists"

if Language.Current == "Spanish":
	MenuText.ForeingDict['ENEMY CONFIGURATION']         = 'CONFIGURACION DE ENEMIGOS'
	MenuText.ForeingDict['Music:']                      = 'Msica:'
	MenuText.ForeingDict['INVISIBLE ENEMIES:']          = 'ENEMIGOS INVISILES:'
	MenuText.ForeingDict['MAX ENEMIES:']                = 'N. MAX. DE ENEMIGOS:'
	MenuText.ForeingDict['CREATE CHARACTER']			= 'CREAR PERSONAJE'
	MenuText.ForeingDict['AVAILABLE CHARACTERS']		= 'PERSONAJES DISPONIBLES'
	MenuText.ForeingDict[SCharText] = "Presiona ENTER para usar el personaje seleccionado\nPresiona SUPRIMIR para eliminar el personaje seleccionado"
	MenuText.ForeingDict['Save']						= 'Guardar'
	MenuText.ForeingDict['Cancel']						= 'Cancelar'
	MenuText.ForeingDict[SCharExists] = "Ya existe un personaje con este nombre"
	MenuText.ForeingDict["Gladiator Respawn"] = "Gladiator Reiniciar Jugador"
	MenuText.ForeingDict["Gladiator Start Music"] = "Gladiator Activa/Desactiva Msica"
	MenuText.ForeingDict["Gladiator Start Round"] = "Gladiator Inicia Asalto"
	MenuText.ForeingDict["<Current>"] = "<Actual>"
	
# Menu methods

CurrentPlayer = "<Current>"
CurPlayerType = "Knight"
CurPlayerModel = 0
CurPlayerName = "BLADE"

def GetArenaMaps():
	return []

def LoadLevel(option):
	GladCfg.LastLevel = option[0]
	GladCfg.PlayerName = CurPlayerName
	GladCfg.SaveConfiguration()
	Bladex.LoadLevel("gladiator")

def SetMusicDirectory(name):
	GladCfg.MusicDir = name
	GladCfg.SaveConfiguration()

def GetMusicDirectory():
	return GladCfg.MusicDir

def SetInvisibleEnemies(option):
	GladCfg.InvisibleEnemies = (option == "Yes")
	GladCfg.SaveConfiguration()

def GetInvisibleEnemies():
	return GladCfg.InvisibleEnemies

def SetMaxEnemies(option):
	GladCfg.MaxEnemies = int(option) - 1
	GladCfg.SaveConfiguration()

def GetMaxEnemies():
	return GladCfg.MaxEnemies

def CharExists(name):
	import os
	if os.path.isdir("../../save/gladiator"):
		return os.path.isfile("../../save/gladiator/" + name + ".sav")
	else:
		return 0

def SavePlayerConfiguration(dummy=0):
	if not CharExists(CurPlayerName):
		GladCfg.SaveNewPlayer(CurPlayerName, CurPlayerType, CurPlayerModel)
		Menu.BackMenu(0)
		Menu._MainMenu.MenuStack.Top().MenuItems[1].AddPlayer(CurPlayerName)

def SetPlayerName(option):
	status = Menu._MainMenu.MenuStack.Top().MenuItems[6]
	if CharExists(option):
		status.SetVisible(1)
	else:
		global CurPlayerName
		CurPlayerName = option
		status.SetVisible(0)

def GetPlayerName():
	return CurPlayerName

def GetCharType():
	return NetMisc.Caracteres[CurPlayerType][0]

def SetCharType(option):
	import netwidgets
	global CurPlayerType
	global CurPlayerModel
	CurPlayerType = option
	CurPlayerModel = 0
	netwidgets.ChangePlayer(NetMisc.Caracteres[CurPlayerType][CurPlayerModel+2])

def GetCharStatus():
	import NetMisc
	return NetMisc.Caracteres[CurPlayerType][CurPlayerModel+2]

def NextSkin(menu_class):
	import netwidgets
	global CurPlayerModel
	size = len(NetMisc.Caracteres[CurPlayerType])-2
	CurPlayerModel = CurPlayerModel + 1
	if CurPlayerModel >= size:
		CurPlayerModel = 0
	netwidgets.ChangePlayer(NetMisc.Caracteres[CurPlayerType][CurPlayerModel+2])

def PreviousSkin(menu_class):
	import netwidgets
	global CurPlayerModel
	size = len(NetMisc.Caracteres[CurPlayerType])-2
	CurPlayerModel = CurPlayerModel - 1
	if CurPlayerModel < 0:
		CurPlayerModel = size - 1
	netwidgets.ChangePlayer(NetMisc.Caracteres[CurPlayerType][CurPlayerModel+2])

def GetEnemyValue():
	return GladCfg.SelectedEnemies

def SetEnemyValue(option):
	GladCfg.SelectedEnemies = option
	GladCfg.SaveConfiguration()

######################################################################################	
# Input box that allows '/' and ':' for music directory
######################################################################################	

import netwidgets
class B_InputBox2(netwidgets.B_InputBox):
	def __init__(self,Parent,MenuDescr,StackMenu):
		netwidgets.B_InputBox.__init__(self,Parent,MenuDescr,StackMenu)

	def ListenDevice(self,x,y,z):
		if z==1.0:
			if x == "Slash":
				self.AddLetter("/")
			elif x == "BackSlash":
				self.AddLetter("/")
			elif x == "SemiColon":
				self.AddLetter(":")
		netwidgets.B_InputBox.ListenDevice(self, x, y, z)

######################################################################################	
# Enemy list widget.  Modified netwidgets.MapListWidget.
######################################################################################	

import Menu
import MenuWidget
import BUIx
class B_EnemyListWidget(BUIx.B_RectWidget,MenuWidget.B_MenuTreeItem):
	def __init__(self,Parent,MenuDescr,StackMenu):
		import BBLib
		import DefaultScorerData
		import Reference
		import Bladex
		import Raster

		name=MenuDescr["LeftMap"]
		self.LeftMap       = BBLib.B_BitMap24()
		self.LeftMap.ReadFromBMP(name)
		self.LSize,garbage = self.LeftMap.GetDimension()

		name=MenuDescr["RightMap"]
		self.RightMap      = BBLib.B_BitMap24()
		self.RightMap.ReadFromBMP(name)
		self.RSize,garbage = self.RightMap.GetDimension()

		name=MenuDescr["SelMap"]
		self.SelMap      = BBLib.B_BitMap24()
		self.SelMap.ReadFromBMP(name)
		self.SSize,self.vidh = self.SelMap.GetDimension()

		name=MenuDescr["MarkMap"]
		self.MarkMap     = BBLib.B_BitMap24()
		self.MarkMap.ReadFromBMP(name)
		self.SSize,self.vidh = self.MarkMap.GetDimension()

		self.vidw = self.SSize*3+self.LSize+self.RSize

		UseEnemies = ("Spidersmall", "Cos", "Ork", "Great_Ork", "Ragnar", 
			"Knight_Traitor", "Dark_Knight", "ChaosKnight", "Knight_Zombie", "Lich", 
			"Skeleton", "Salamander", "Troll_Dark", "Troll_snow", "Minotaur", 
			"Golem_clay", "Golem_stone", "Golem_metal", "Golem_lava", "Golem_ice", 
			"Vamp", "Little_Demon", "Great_Demon", "DalGurak", "Knight_N", 
			"Barbarian_N", "Amazon_N", "Dwarf_N", 
		#	"DarkLord", "Enano1", "Enano2", "Gold_Ork", "Dark_Ork",
		)
		DefaultScorerData.Init()
		# Setup the missing ones
		Bladex.ReadBitMap("../../Data/Icons/icono barbaro.bmp","BarbarianIcon")
		Reference.EnemiesDefaultScorerData['Barbarian_N']=("BarbarianIcon","Barbarian")
		Bladex.ReadBitMap("../../Data/Icons/icono amazona.bmp","AmazonIcon")
		Reference.EnemiesDefaultScorerData['Amazon_N']=("AmazonIcon","Amazon")
		Bladex.ReadBitMap("../../Data/Icons/icono enano.bmp","DwarfIcon")
		Reference.EnemiesDefaultScorerData['Dwarf_N']=("DwarfIcon","Dwarf")

		self.Bitmap=[]
		self.IDX = 0

		self.EnemySetValue = MenuDescr["EnemySetValue"]
		dta			       = MenuDescr["EnemyGetValue"]()
		if len(dta) == 0:
			dta = UseEnemies

		for enemy in UseEnemies:
			try:
				ref = Reference.EnemiesDefaultScorerData[enemy]
				bitm = Raster.BmpHandle(ref[0])
				self.Bitmap.append([bitm, enemy, MenuText.GetMenuText(ref[1]), 0])
			except:
				pass

			for j in dta:
				if j == enemy:
					self.Bitmap[len(self.Bitmap)-1][3] = 1

		self.MapW = (self.SSize - 64)/2
		self.MapH = (self.vidh  - 64)/2

		BUIx.B_RectWidget.__init__(self,Parent,MenuDescr["Name"],self.vidw,self.vidh)
		MenuWidget.B_MenuTreeItem.__init__(self,MenuDescr,StackMenu)

		self.Selected=0
		self.Solid=0
		self.Border=0
		self.SetDrawFunc(self.Draw)

	def Draw(self,x,y,time):
		import Raster
		if self.IDX == 0:
			first = len(self.Bitmap)-1
		else:
			first = self.IDX-1

		if self.IDX == len(self.Bitmap)-1:
			last = 0
		else:
			last = self.IDX+1


		bmps = [first, self.IDX, last]
		for i in range(len(bmps)):
			if self.Bitmap[bmps[i]][3]:
				Raster.SetPosition(x+self.SSize*i+self.LSize, y)
				Raster.DrawImage(self.SSize,self.vidh,"BGR","Normal",self.MarkMap.GetData())

		if self.GetHasFocus():
			Raster.SetPosition(x,y+self.MapH)
			Raster.DrawImage(self.LSize,self.vidh-2*self.MapH,"BGR","Normal",self.LeftMap.GetData())

			Raster.SetPosition(x+self.SSize*3+self.LSize, y+self.MapH)
			Raster.DrawImage(self.LSize,self.vidh-2*self.MapH,"BGR","Normal",self.RightMap.GetData())

			if int(time*5)%2 == 0:
				Raster.SetPosition(x+self.SSize*1+self.LSize, y)
				Raster.DrawImage(self.SSize,self.vidh,"BGR","Normal",self.SelMap.GetData())

		bmpWidth = self.SSize-2*self.MapW
		bmpHeight = self.vidh-2*self.MapH
		Raster.SetPenColor(255,255,255)
		for i in range(len(bmps)):
			Raster.SetPosition(x+self.MapW+self.SSize*i+self.LSize, y+self.MapH)
			Raster.DrawBitmap(self.Bitmap[bmps[i]][0], bmpWidth, bmpHeight)


		self.DefDraw(x,y,time)

		netwidgets.LabelName = self.Bitmap[self.IDX][2]

	def IncMenuItem(self):
		self.IDX = self.IDX+1
		if self.IDX >= len(self.Bitmap):
			self.IDX = 0


	def DecMenuItem(self):
		self.IDX = self.IDX-1
		if self.IDX < 0:
			self.IDX = len(self.Bitmap)-1

	def ActivateItem(self,act):
		if not act:
			MenuWidget.B_MenuTreeItem.ActivateItem(self,act)
			return
		self.Bitmap[self.IDX][3] = not self.Bitmap[self.IDX][3]
		v = []
		for i in self.Bitmap:
			if i[3]:
				v.append(i[1])
		self.EnemySetValue(v)


	def AcceptsFocus(self):
		return 1

######################################################################################	
# Gladiator Map list widget.  Modified netwidgets.MapListWidget.
######################################################################################	

class B_GladMapWidget(BUIx.B_RectWidget,MenuWidget.B_MenuTreeItem):
	def __init__(self,Parent,MenuDescr,StackMenu):
		import BBLib
		name=MenuDescr["LeftMap"]
		self.LeftMap       = BBLib.B_BitMap24()
		self.LeftMap.ReadFromBMP(name)
		self.LSize,garbage = self.LeftMap.GetDimension()

		name=MenuDescr["RightMap"]
		self.RightMap      = BBLib.B_BitMap24()
		self.RightMap.ReadFromBMP(name)
		self.RSize,garbage = self.RightMap.GetDimension()

		name=MenuDescr["SelMap"]
		self.SelMap      = BBLib.B_BitMap24()
		self.SelMap.ReadFromBMP(name)
		self.SSize,self.vidh = self.SelMap.GetDimension()

		name=MenuDescr["MarkMap"]
		self.MarkMap     = BBLib.B_BitMap24()
		self.MarkMap.ReadFromBMP(name)
		self.SSize,self.vidh = self.MarkMap.GetDimension()

		self.vidw = self.SSize*3+self.LSize+self.RSize

		imagelist = self.GetMaps()
		self.Bitmap=[]
		self.IDX = 0

		self.MapSetValue = MenuDescr["MapSetValue"]
		dta              = MenuDescr["MapGetValue"]()

		for i in imagelist:
			bitm = BBLib.B_BitMap24()
			bitm.ReadFromBMP(i[0])

			self.Bitmap.append([bitm,i[1],i[2],0])

			for j in dta:
				if j == i[2]:
					self.Bitmap[len(self.Bitmap)-1][3] = 1

		self.MapW,self.MapH = self.Bitmap[self.IDX][0].GetDimension()

		self.MapW = (self.SSize - self.MapW)/2
		self.MapH = (self.vidh  - self.MapH)/2

		BUIx.B_RectWidget.__init__(self,Parent,MenuDescr["Name"],self.vidw,self.vidh)
		MenuWidget.B_MenuTreeItem.__init__(self,MenuDescr,StackMenu)

		self.Selected=0
		self.Solid=0
		self.Border=0
		self.SetDrawFunc(self.Draw)

	def Draw(self,x,y,time):
		import Raster
		if self.IDX == 0:
			first = len(self.Bitmap)-1
		else:
			first = self.IDX-1

		if self.IDX == len(self.Bitmap)-1:
			last = 0
		else:
			last = self.IDX+1

		if self.Bitmap[first][3]:
			Raster.SetPosition(x+self.SSize*0+self.LSize, y)
			Raster.DrawImage(self.SSize,self.vidh,"BGR","Normal",self.MarkMap.GetData())

		if self.Bitmap[self.IDX][3]:
			Raster.SetPosition(x+self.SSize*1+self.LSize, y)
			Raster.DrawImage(self.SSize,self.vidh,"BGR","Normal",self.MarkMap.GetData())

		if self.Bitmap[last][3]:
			Raster.SetPosition(x+self.SSize*2+self.LSize, y)
			Raster.DrawImage(self.SSize,self.vidh,"BGR","Normal",self.MarkMap.GetData())

		if self.GetHasFocus():
			Raster.SetPosition(x,y+self.MapH)
			Raster.DrawImage(self.LSize,self.vidh-2*self.MapH,"BGR","Normal",self.LeftMap.GetData())

			Raster.SetPosition(x+self.SSize*3+self.LSize, y+self.MapH)
			Raster.DrawImage(self.LSize,self.vidh-2*self.MapH,"BGR","Normal",self.RightMap.GetData())

			if int(time*5)%2 == 0:
				Raster.SetPosition(x+self.SSize*1+self.LSize, y)
				Raster.DrawImage(self.SSize,self.vidh,"BGR","Normal",self.SelMap.GetData())


		Raster.SetPosition(x+self.MapW+self.SSize*0+self.LSize, y+self.MapH)
		Raster.DrawImage(self.SSize-2*self.MapW,self.vidh-2*self.MapH,"BGR","Normal",self.Bitmap[first][0].GetData())


		Raster.SetPosition(x+self.MapW+self.SSize*1+self.LSize, y+self.MapH)
		Raster.DrawImage(self.SSize-2*self.MapW,self.vidh-2*self.MapH,"BGR","Normal",self.Bitmap[self.IDX][0].GetData())

		Raster.SetPosition(x+self.MapW+self.SSize*2+self.LSize, y+self.MapH)
		Raster.DrawImage(self.SSize-2*self.MapW,self.vidh-2*self.MapH,"BGR","Normal",self.Bitmap[last][0].GetData())

		self.DefDraw(x,y,time)

		netwidgets.LabelName = self.Bitmap[self.IDX][1]

	def AddMap(self, maps, mapname, maptext):
		import os
		defbmp = "../../Data/net/Logo.BMP"
		bmp = defbmp
		if os.path.exists("../Gladiator/" + mapname + ".bmp"):
			bmp = "../Gladiator/" + mapname + ".bmp";
		maps.append(bmp, MenuText.GetMenuText(maptext), mapname)

	def GetMaps(self):
		import os
		import string
		import GladCfg

		maps = []
		# The Arena maps
		maps.append("../Arena1/shoot.bmp", MenuText.GetMenuText("Vulcano's hell"), "Arena1")
		maps.append("../Arena3/shoot.bmp", MenuText.GetMenuText("Gates of Karum"), "Arena3")
		maps.append("../Arena4/shoot.bmp", MenuText.GetMenuText("The castle of doom"), "Arena4")
		maps.append("../Arena5/shoot.bmp", MenuText.GetMenuText("Vertigo"), "Arena5")
		maps.append("../Arena7/shoot.bmp", MenuText.GetMenuText("The dark tower"), "Arena7")
		# Other special maps
		import Language
		MapList = {}
		execfile ("../../data/text/"+Language.Current+"/map2D.py")
		self.AddMap(maps, "Casa", "Casa")
		#self.AddMap(maps, "Final", 'Temple')
		#self.AddMap(maps, "Tutorial", 'Tutorial')

		self.AddMap(maps, "Barb_M1", MapList["BARB_M1"])
		#self.AddMap(maps, "Ragnar_M2", MapList["RAGNAR_M2"])
		#self.AddMap(maps, "Dwarf_M3", MapList["DWARF_M3"])
		#self.AddMap(maps, "Ruins_M4", MapList["RUINS_M4"])
		#self.AddMap(maps, "Mine_M5", MapList["MINE_M5"])
		#self.AddMap(maps, "Labyrinth_M6", MapList["LABYRINTH_M6"])
		#self.AddMap(maps, "Tomb_M7", MapList["TOMB_M7"])
		#self.AddMap(maps, "Island_M8", MapList["ISLAND_M8"])
		#self.AddMap(maps, "Orc_M9", MapList["ORC_M9"])
		#self.AddMap(maps, "Orlok_M10", MapList["ORLOK_M10"])
		#self.AddMap(maps, "Ice_M11", MapList["ICE_M11"])
		#self.AddMap(maps, "Btomb_M12", MapList["BTOMB_M12"])
		#self.AddMap(maps, "Desert_M13", MapList["DESERT_M13"])
		#self.AddMap(maps, "Volcano_M14", MapList["VOLCANO_M14"])
		#self.AddMap(maps, "Palace_M15", MapList["PALACE_M15"])
		#self.AddMap(maps, "Tower_M16", MapList["TOWER_M16"])
		#self.AddMap(maps, "Chaos_M17", MapList["CHAOS_M17"])

		#self.AddMap(maps, "Btomb_back", MapList["BTOMB_BACK"])
		#self.AddMap(maps, "Desert_back", MapList["DESERT_BACK"])
		#self.AddMap(maps, "Ice_back", MapList["ICE_BACK"])
		#self.AddMap(maps, "Palace_back", MapList["PALACE_BACK"])
		#self.AddMap(maps, "Tomb_back", MapList["TOMB_BACK"])
		#self.AddMap(maps, "Mine_back", MapList["MINE_BACK"])
		#self.AddMap(maps, "Labyrinth_back", MapList["LABYRINTH_BACK"])


		# Custom maps
		dirlist = os.listdir("..")
		for dirname in dirlist:
			if os.path.isdir("../"+dirname):
				files = os.listdir("../"+dirname)
				for file in files:
					ext = string.upper(os.path.splitext(file)[1])
					if ext == ".GLAD":
						try:
							initFiles = []
							GladCfg.levelimage = "../../Data/net/Logo.BMP"
							GladCfg.levelname = dirname
							execfile(os.path.join("..\\"+dirname, file))
							if not os.path.isfile(GladCfg.levelimage):
								GladCfg.levelimage = "../../Data/net/Logo.BMP"
							maps.append(GladCfg.levelimage, MenuText.GetMenuText(GladCfg.levelname), dirname)
						except:
							pass
		return maps

	def IncMenuItem(self):
		self.IDX = self.IDX+1
		if self.IDX >= len(self.Bitmap):
			self.IDX = 0


	def DecMenuItem(self):
		self.IDX = self.IDX-1
		if self.IDX < 0:
			self.IDX = len(self.Bitmap)-1

	def ActivateItem(self,act):
		if not act:
			MenuWidget.B_MenuTreeItem.ActivateItem(self,act)
			return
		self.Bitmap[self.IDX][3] = not self.Bitmap[self.IDX][3]
		v = []
		for i in self.Bitmap:
			if i[3]:
				v.append(i[2])
		self.MapSetValue(v)


	def AcceptsFocus(self):
		return 1

################################################################################
# PlayerList
################################################################################
import ListWidget
import ScorerWidgets
class B_PlayerList(ListWidget.B_ListWidget):
  def __init__(self,Parent,Menudesc,StackMenu,VertPos=0):
	ListWidget.B_ListWidget.__init__(self,Parent,Menudesc,StackMenu,VertPos)
	self.StatusText=BUIx.B_TextWidget(self,"Status",MenuText.GetMenuText(SCharText),ScorerWidgets.font_server,"..\\..\\Data\\Letras menu peq.bmp")
	self.StatusText.SetColor(252,247,167)
	self.StatusText.SetAlpha(1)
	self.AddLabel(self.StatusText,0.5,25,BUIx.B_Widget.B_LAB_HCenter,BUIx.B_Widget.B_LAB_Bottom,
				  BUIx.B_Widget.B_FR_HRelative,BUIx.B_Widget.B_LAB_HCenter,
				  BUIx.B_Widget.B_FR_AbsoluteTop,BUIx.B_Widget.B_FR_Top)
	self.DownArrow.SetAlpha(1) # Parche, no funciona la llamada a AdjustScrollArrows() en AddMenuElement(),
	self.SetClipDraw(1)
	self.SetDrawFunc(self.Draw)
	self.StackMenu = StackMenu
	self.Parent = Parent

	import os
	import string
	files = []
	if os.path.isdir("../../save/gladiator"):
		files = os.listdir("../../save/gladiator")
	for file in files:
		file, ext = os.path.splitext(file)
		if string.upper(ext) == ".SAV":
			self.AddPlayer(file)
	import Bladex
	player = Bladex.GetEntity('Player1')
	if player != None:
		try:
			player.Data.SaveName
		except:
			if player.CharTypeExt in ('Kgt', 'Dwf', 'Amz', 'Bar'):
				self.AddPlayer(CurrentPlayer)
	if len(self.MenuItems) > 0:
		self.SetFocus_Idx(0)
		self.MenuItems[0].SetHasFocus(1)
	else:
		self.NextFocus()

  def Draw(self,x,y,time):
	self.SetClipDraw(1)
	self.DefDraw(x,y,time)

  def SetStatusText(self,text):
	self.StatusText.SetText(text)
	self.RecalcLabelLayout(BUIx.B_Widget.B_LAB_HCenter,BUIx.B_Widget.B_LAB_Bottom)

  def SetHasFocus(self, foc):
	ListWidget.B_ListWidget.SetHasFocus(self, foc)
	curfoc = self.GetFocus()
	if curfoc != None:
		curfoc.SetHasFocus(foc)

  def SetFocus(self, menu_element):
	return ListWidget.B_ListWidget.SetFocus(self, menu_element)

  def NextFocus(self):
	try:
		if len(self.MenuItems) == 0:
			self.Parent.NextFocus()
			return
		lastfocus = self.GetFocus()
		index = self.MenuItems.index(lastfocus)
		if index == len(self.MenuItems) - 1:
			lastfocus.SetHasFocus(0)
			self.Parent.NextFocus()
			return
	except:
		pass
	ListWidget.B_ListWidget.NextFocus(self)

  def GetCharacter(self, name):
	return {"Name": MenuText.GetMenuText(name),
			"Position" :(70, BUIx.B_FrameWidget.B_FR_AbsoluteLeft, BUIx.B_FrameWidget.B_FR_Left),
			"Kind" 	:B_PlayerItem,
			"Size" 	:(640,480),
			"ListDescr":[  {"Name"       : "Lista de mapas",
							"Kind"       : B_GladMapWidget,
							"LeftMap"    : "../../Data/net/MapL.bmp",
							"RightMap"   : "../../Data/net/MapR.bmp",
							"SelMap"     : "../../Data/net/MapM.bmp",
							"MarkMap"    : "../../Data/net/MapS.bmp",
							"MapGetValue": GetArenaMaps,
							"MapSetValue": LoadLevel,
							"VSep"		 : 150,
						   },
						   {"Name":MenuText.GetMenuText("The bad place"),
							"VSep":1,
							"Kind":netwidgets.B_DescriptorLabel
							},
						   {"Name"    : MenuText.GetMenuText("BACK"),
							"VSep"    : 10,
							"Command" : Menu.BackMenu,
						   },
						   {"Name":"Back",
							"Kind":MenuWidget.B_BackBlank
						   }
             			]}

  def AddPlayer(self, name):
	try:
		oldidx = self.MenuItems.index(self.GetFocus())
	except:
		oldidx = -1
	sub = B_PlayerItem(self, self.GetCharacter(name), self.StackMenu)
	self.AddMenuElement(sub)
	self.RecalcLayout()

  def AcceptsFocus(self):
    if len(self.MenuItems) <= 0:
      return 0
    else:
      return 1

  def DoScroll(self,amount):
	for i in range(2, self.nWidgets(), 1): 
		self.MoveWidgetRel_Idx(i,0,amount)
	self.VertPos=self.VertPos+amount

  def RemoveItem(self, item):
	index = self.MenuItems.index(item)
	if index == self.nWidgets() - 3:
		self.PrevFocus()
	else:
		self.NextFocus()
	index = self.MenuItems.index(item)
	self.RemoveWidget_Idx(index + 2)
	self.MenuItems.pop(index)
	self.ListSize = self.ListSize - item.GetSize()[1]
	self.WidgetsVPos.pop()
	self.WidgetsHeights.pop(index)
	for i in range(index, len(self.MenuItems), 1):
		self.MoveWidgetRel_Idx(i + 2, 0, -15)
	self.RecalcLayout()

################################################################################
# PlayerText
################################################################################
class B_PlayerText(MenuWidget.B_MenuItemText):
  def __init__(self,Parent,MenuDescr,StackMenu,font_server=ScorerWidgets.font_server):
	MenuWidget.B_MenuItemText.__init__(self,Parent,MenuDescr,StackMenu,font_server)
	self.SetDrawFunc(self.Draw)
	self.SetAlpha(1.0)
	self.SelectionFilterUpdated=0
	self.FilterUpdated=0
	self.SetColor(207,144,49)
	self._foc=-1
	self.ActionName = None

  def SetText(self,text,ActionName=None):
	MenuWidget.B_MenuItemText.SetText(self,text)
	self.SelectionFilterUpdated=0
	self.FilterUpdated=0
	self.ActionName = ActionName

  def Draw(self,x,y,time):
	if self.GetVisible()==0:
	  return

	foc=self.GetHasFocus()
	if foc!=self._foc:		  
	  self.SelectionFilterUpdated=0
	  self.FilterIncX=0
	  self.FilterUpdated=0

	self._foc=foc
	w,h=self.GetSize()

	if foc:
	  if self.SelectionFilterUpdated:
		Raster.SetPosition(x-self.FilterIncX,y-self.FilterIncY)
		Raster.DrawImage(w+2*self.FilterIncX,h+2*self.FilterIncY,"RGB","Native",self.SelectionFilter.GetImageBuffer())
		self.SetColor(252,247,167)
		self.DefDraw(x,y,time)
		self.SetColor(207,144,49)
		return
	else:
	  self.DefDraw(x,y,time)
	  return

	if foc:
	  self.SetColor(252,247,167)
	  self.DefDraw(x,y,time)
	  self.SetColor(207,144,49)

	  if self.FilterIncX>25:
		self.SelectionFilterUpdated=1
	  else:
		self.SelectionFilterUpdated=0

################################################################################
# PlayerItem
################################################################################
class B_PlayerItem(BUIx.B_FrameWidget,MenuWidget.B_MenuTreeItem):
  def __init__(self,Parent,MenuDescr,StackMenu):
	BUIx.B_FrameWidget.__init__(self,Parent,MenuDescr["Name"],400,15)
	MenuWidget.B_MenuTreeItem.__init__(self,MenuDescr,StackMenu)
	self.wName=B_PlayerText(self,MenuDescr,StackMenu)
	self.wDesc=B_PlayerText(self,MenuDescr,StackMenu)
	self.AddWidget(self.wName,0,0,
				   BUIx.B_FrameWidget.B_FR_AbsoluteLeft,BUIx.B_FrameWidget.B_FR_Left,
				   BUIx.B_FrameWidget.B_FR_AbsoluteTop,BUIx.B_FrameWidget.B_FR_Top)
	self.AddWidget(self.wDesc,0,0,
                   BUIx.B_FrameWidget.B_FR_AbsoluteRight,BUIx.B_FrameWidget.B_FR_Right,
                   BUIx.B_FrameWidget.B_FR_AbsoluteTop,BUIx.B_FrameWidget.B_FR_Top)
	self.HasFocus=0
	self.SetClipDraw(0)
	self.PlayerName = MenuText.GetInverseMenuText(MenuDescr["Name"])
	import GladCfg
	data = GladCfg.GetPlayerInfo(self.PlayerName)
	level = 0
	type = 'Unknown'
	if data != None:
		level = data[1]['Level']
		type = data[0]['Kind']
		type = type[:len(type)-2]
	self.wDesc.SetText("Level %d %s" %(level + 1, type))
	self.RecalcLayout()
	self.Parent = Parent

  def __del__(self):
	BUIx.B_FrameWidget.__del__(self)
	MenuWidget.B_MenuTreeItem.__del__(self)

  def SetHasFocus(self,foc):
	if not self.wName:
		return
	self.HasFocus=foc
	self.wName.SetHasFocus(foc)
	if foc == 1:
		global CurPlayerName
		CurPlayerName = self.PlayerName

  def GetHasFocus(self,foc):
	return self.HasFocus

  def SuprMenuItem(self):
	if self.PlayerName == CurrentPlayer:
		return
	import os
	try:
		os.remove("../../save/gladiator/" + self.PlayerName + ".sav")
		self.wName.SetDrawFunc(None)
		self.wDesc.SetDrawFunc(None)
		self.SetDrawFunc(None)
		self.Parent.RemoveItem(self)
	except:
		pass


################################################################################
# The menu
################################################################################
import NetMisc

global ModMenu
ModMenu = [{"Name":MenuText.GetMenuText("AVAILABLE CHARACTERS"),
			"Kind":MenuWidget.B_MenuItemTextNoFXNoFocus,
			"Font":Menu.MenuFontBig,
			"VSep":50,
		   },
		   {"Name":"Characters",
			"Kind":B_PlayerList,
			"Font":Menu.MenuFontMed,
			"VSep":20,
			"Position" :(70, BUIx.B_FrameWidget.B_FR_AbsoluteLeft, BUIx.B_FrameWidget.B_FR_Left),
			"Size":(640,80),
			"ListDescr": []
		   },
		   {"Name":MenuText.GetMenuText("CREATE CHARACTER"),
			"Font":Menu.MenuFontBig,
			"Size":(640,480),
			"VSep":60,
			"ListDescr":[
						   {"Name":MenuText.GetMenuText("Name:"),
						    "VSep":30,
						    "Kind":netwidgets.B_InputBox,
						    "MaxSize":10,
						    "GetInput":GetPlayerName,
						    "SetInput":SetPlayerName
						   },
						   {"Name":MenuText.GetMenuText("Character:"),
 							"Font":Menu.MenuFontMed,
							"Kind":MenuWidget.B_MenuItemOption,
							"Options":[MenuText.GetMenuText("Knight"),MenuText.GetMenuText("Barbarian"),MenuText.GetMenuText("Dwarf"),MenuText.GetMenuText("Amazon")],
							"SelOptionFunc":GetCharType,
							"Command":SetCharType
						   },
						   {"Name":"Lista de jugadores",
							"Kind":netwidgets.B_ImageListWidget,
							"ImageList":NetMisc.CharBitmaps,
							"GetCharType":GetCharStatus,
							"VSep":30
						   },
						   {"Name":"< "+MenuText.GetMenuText("Next Skin")+" >",
							"VSep":30,
							"Command":NextSkin,
							"LeftCommand":NextSkin,
							"RightCommand":PreviousSkin,
						   },
						   {"Name":MenuText.GetMenuText("Save"),
							"Command":SavePlayerConfiguration
						   },
						   {"Name":MenuText.GetMenuText("Cancel"),
							"Command":Menu.BackMenu,
						   },
						   {"Name":MenuText.GetMenuText(SCharExists),
						    "Kind":MenuWidget.B_MenuItemTextNoFXNoFocus
						   },
						   {"Name":"Back",
							"Kind":MenuWidget.B_BackBlank
						   }                  
						  ]
			 },
			 {"Name":MenuText.GetMenuText("ENEMY CONFIGURATION"),
			  "Size":(640,480),
			  "Font":Menu.MenuFontBig,
			  "ListDescr":[
						   {"Name"       : "List of enemies",
							"Kind"       : B_EnemyListWidget,                                                                    
							"LeftMap"    : "../../Data/net/MapL.bmp",
							"RightMap"   : "../../Data/net/MapR.bmp",
							"SelMap"     : "../../Data/net/MapM.bmp",
							"MarkMap"    : "../../Data/net/MapS.bmp",
							"EnemyGetValue": GetEnemyValue,
							"EnemySetValue": SetEnemyValue,
							"VSep"		 : 150,
						   },
						   {"Name":MenuText.GetMenuText("The bad place"),
							"VSep":1,
							"Kind":netwidgets.B_DescriptorLabel
						   },
						   {"Name":MenuText.GetMenuText("INVISIBLE ENEMIES:"),
						    "VSep":10,
						    "Font":Menu.MenuFontMed,
						    "Kind":MenuWidget.B_MenuItemOption,
						    "Options": [MenuText.GetMenuText("No"), MenuText.GetMenuText("Yes")],
						    "Command":SetInvisibleEnemies,
						    "SelOptionFunc":GetInvisibleEnemies
						   },
						   {"Name":MenuText.GetMenuText("MAX ENEMIES:"),
						    "VSep":10,
						    "Font":Menu.MenuFontMed,
						    "Kind":MenuWidget.B_MenuItemOption,
						    "Options": ["1", "2", "3", "4"],
						    "Command":SetMaxEnemies,
						    "SelOptionFunc":GetMaxEnemies
						   },
						   {"Name"    : MenuText.GetMenuText("BACK"),
							"VSep"    : 10,
							"Command" : Menu.BackMenu,
						   },
						   {"Name":"Back",
							"Kind":MenuWidget.B_BackBlank
						   }
						  ]
			 },
			 {"Name":MenuText.GetMenuText("Music:"),
			  "Font":Menu.MenuFontMed,
			  "Kind":B_InputBox2,
			  "MaxSize":60,
			  "VSep":20,
			  "GetInput":GetMusicDirectory,
			  "SetInput":SetMusicDirectory
			 },
			 Menu.BackOption,
			 {"Name":"Back",
			  "Kind":MenuWidget.B_BackBlank
			 }
		   ]

def Initialize():
	pass

###############################################################################
# Keyboard binding
###############################################################################

KEY_RESPAWN = 'H'
KEY_MUSIC = 'M'
KEY_ROUND = 'J'

def GetKey(line):
	import re
	return re.split('"*"', line)[5]

def GetKeyBindings():
	try:
		import string
		f = open('../../Config/Control.py', 'r')
		if not f:
			return
		line = "tmp"
		while line != "":
			line = f.readline()
			idx = string.find(line, '"ReSpawn"')
			if idx != -1:
				global KEY_RESPAWN
				KEY_RESPAWN = GetKey(line)
			idx = string.find(line, '"StartMusic"')
			if idx != -1:
				global KEY_MUSIC
				KEY_MUSIC = GetKey(line)
			idx = string.find(line, '"StartRound"')
			if idx != -1:
				global KEY_ROUND
				KEY_ROUND = GetKey(line)
		f.close()
	except:
		pass

GetKeyBindings()

def NewKeyMenu(name, action, defkey):
	# Add to configurable list
	import acts
	acts.ConfigurableActions.append((name, action, [],));

	# Add to key configs
	import BInput
	import KeybWidget
	IManager = BInput.GetInputManager()
	oldSet = IManager.GetInputActionsSet()
	IManager.SetInputActionsSet("Default")
	IActions = IManager.GetInputActions()
	IAction = IActions.Find(action)
	if IAction.Name() == "NULL":
		Bladex.AddInputAction(action, 0)
		Bladex.AssocKey(action, "Keyboard", defkey, 1)
	elif IAction.nInputEvents() == 0:
		Bladex.AssocKey(action, "Keyboard", defkey, 1)
	IManager.SetInputActionsSet(oldSet)
	IActions = IManager.GetInputActions()
	IAction = IActions.Find(action)
	if IAction.Name() == "NULL":
		Bladex.AddInputAction(action, 0)
		Bladex.AssocKey(action, "Keyboard", defkey, 1)
	elif IAction.nInputEvents() == 0:
		Bladex.AssocKey(action, "Keyboard", defkey, 1)
	Menu.GetMenuItem(['CONTROLS','KEYBOARD', 'KeybList'])['ListDescr'].append({
		"Name":MenuText.GetMenuText(name),
		"Position": Menu.CtrlsPosition,
		"Action": action, 
		"Kind": KeybWidget.ControlMenuItem,
		"kFlags":[], "Size":(200,300)
		})

NewKeyMenu("Gladiator Respawn", "ReSpawn", KEY_RESPAWN);
NewKeyMenu("Gladiator Start Music", "StartMusic", KEY_MUSIC);
NewKeyMenu("Gladiator Start Round", "StartRound", KEY_ROUND);
