################################################################################
# Defines custom type for gladiator
# by Josh Dahlby
################################################################################
import Bladex
import Enm_Def
import AniSound
import BCopy
import Reference
import Combat
import whrandom

import GladCombat

# Boolean value
TRUE = 1==1
FALSE = not TRUE

################################################################################
# Base custom class
################################################################################

class BaseGladiatorType (Enm_Def.NPCPerson):
	def __init__(self, me):
		Enm_Def.NPCPerson.__init__(self, me)

		# Set up sound priorities
		self.SoundPriorities[Reference.SND_ARROW]   = 10.0
		self.SoundPriorities[Reference.SND_HIT]     = 50.0
		self.SoundPriorities[Reference.SND_NPC]     = 25.0
		self.SoundPriorities[Reference.SND_NOISYPC] = 30.0
		self.SoundPriorities[Reference.SND_PC]      = 80.0
		
		self.Kind = me.Kind
	
	def ResetSounds(self, EntityName):
		# override this function to assign sounds
		pass

	# Functions for loading and saving state
	def __getstate__(self):	
		NPCPerson_state=Enm_Def.NPCPerson.__getstate__(self)
		if(NPCPerson_state[0]!=1):
			Reference.debugprint("ERROR: BaseGladiatorType.__getstate__(): Base class version differs.")
			return NPCPerson_state
		NPCPerson_state[1][self.Kind]=()
		return NPCPerson_state
	
	def __setstate__(self,parm):
		# Toma como parmetro lo que devuelve __getstate__() y debe recrear la clase
		Enm_Def.NPCPerson.__setstate__(self,parm)
		version=parm[0]
		if version==1:
			parms=parm[1][self.Kind]
			#self.SoundPriorities=parms[0]

	def ResetCombat (self,EntityName):		
		Enm_Def.NPCPerson.ResetCombat(self, EntityName)
		me = Bladex.GetEntity(EntityName)	
		if me and me.Life>0:
			self.SetCombatInfo(me)

	def SetCombatInfo(self, me):
		pass

	def CheckAttackList(self, me, levelData, weaponData):
		# Add level related combos
		for i in range(me.Level + 1):
			if levelData.has_key(i):
				data = levelData[i]
				for info in data:
					me.AttackList.append(info)

		weapon = Bladex.GetEntity(me.InvRight)
		if weapon != None:
			if weaponData.has_key(weapon.Kind):
				me.AttackList.append(weaponData[weapon.Kind])

################################################################################
# Define the Gladiator Knight class
################################################################################
class Knight_N (BaseGladiatorType):
	def __init__(self, me):
		BaseGladiatorType.__init__(self, me)
		names = ("Knight_N", "KgtSkin1", "KgtSkin2")
		idx = whrandom.randint(0, len(names)-1)
		me.MeshName = names[idx]
	
	def ResetSounds(self, EntityName):
		AniSound.AsignarSonidosCaballero(EntityName)

	def SetCombatInfo(self, me):
		self.AttacksOwnKind=FALSE
		self.AttackNPCTime = 2.0
		me.AttackList = BCopy.deepcopy(GladCombat.KnightAttackData)
		self.CheckAttackList(me, GladCombat.KnightLevelCombos, GladCombat.KnightCombos)
		self.ChanceOfFuryOnHurt = 0.0
		self.ChanceOfFuryOnLeaderDeath = 0.0
		inv= me.GetInventory()
		if inv.HoldingShield: 
			me.BlockingPropensity = 1.0
			me.RangeDefenceCapable = TRUE
		else: 
			me.BlockingPropensity = 0.2
			me.RangeDefenceCapable = FALSE

################################################################################

################################################################################
# Define the Gladiator Barbarian class
################################################################################
class Barbarian_N (BaseGladiatorType):
	def __init__(self, me):
		BaseGladiatorType.__init__(self, me)
		names = ("Barbarian_N", "BarSkin1", "BarSkin2")
		idx = whrandom.randint(0, len(names)-1)
		me.MeshName = names[idx]
	
	def ResetSounds(self, EntityName):
		AniSound.AsignarSonidosBarbaro(EntityName)

	def SetCombatInfo(self, me):
		self.AttacksOwnKind=FALSE
		self.AttackNPCTime = 1.5
		me.AttackList = BCopy.deepcopy(GladCombat.BarbarianAttackData)
		weapon = Bladex.GetEntity(me.InvRight)
		if weapon != None:
			levelCombos = None
			if weapon.Kind == "QueenSword":
				levelCombos = GladCombat.BarbarianLevelCombos1H
			elif weapon.Kind in ("Eclipse", "Guadanya", "Hacha2hojas", "IceAxe", "RhinoClub", "Hacharrajada"):
				levelCombos = GladCombat.BarbarianLevelCombosAxe
			else:
				levelCombos = GladCombat.BarbarianLevelCombos2H
			self.CheckAttackList(me, levelCombos, GladCombat.BarbarianCombos)
			# Special case for a weapon with 2 combos
			if weapon.Kind == "FireBigSword" and me.Level >= 17:
				me.AttackList.append(GladCombat.BarbarianCombos["FireBigSword_18"])
		self.ChanceOfFuryOnHurt = 0.0
		self.ChanceOfFuryOnLeaderDeath = 0.0
		inv= me.GetInventory()
		if inv.HoldingShield: 
			me.BlockingPropensity = 0.7
			me.RangeDefenceCapable = TRUE
		else: 
			me.BlockingPropensity = 0.4
			me.RangeDefenceCapable = FALSE

################################################################################


################################################################################
# Define the Gladiator Dwarf class
################################################################################
class Dwarf_N (BaseGladiatorType):
	def __init__(self, me):
		BaseGladiatorType.__init__(self, me)
		names = ("Dwarf_N", "DwfSkin1", "DwfSkin2")
		idx = whrandom.randint(0, len(names)-1)
		me.MeshName = names[idx]
	
	def ResetSounds(self, EntityName):
		AniSound.AsignarSonidosEnano(EntityName)

	def SetCombatInfo(self, me):
		self.AttacksOwnKind=FALSE
		self.AttackNPCTime = 2.0
		me.AttackList = BCopy.deepcopy(GladCombat.DwarfAttackData)
		self.CheckAttackList(me, GladCombat.DwarfLevelCombos, GladCombat.DwarfCombos)
		self.ChanceOfFuryOnHurt = 0.15
		self.ChanceOfFuryOnLeaderDeath = 0.1
		inv= me.GetInventory()
		if inv.HoldingShield: 
			me.BlockingPropensity = 1.0
			me.RangeDefenceCapable = TRUE
		else: 
			me.BlockingPropensity = 0.2
			me.RangeDefenceCapable = FALSE

################################################################################

################################################################################
# Define the Gladiator Amazon class
################################################################################
class Amazon_N (BaseGladiatorType):
	def __init__(self, me):
		BaseGladiatorType.__init__(self, me)
		names = ("Amazon_N", "AmzSkin1", "AmzSkin2")
		idx = whrandom.randint(0, len(names)-1)
		me.MeshName = names[idx]
	
	def ResetSounds(self, EntityName):
		AniSound.AsignarSonidosAmazona(EntityName)

	def SetCombatInfo(self, me):
		self.AttacksOwnKind=FALSE
		self.AttackNPCTime = 2.0
		me.AttackList = BCopy.deepcopy(GladCombat.AmazonAttackData)
		weapon = Bladex.GetEntity(me.InvRight)
		if weapon != None:
			levelCombos = None
			if weapon.Kind == "QueenSword":
				levelCombos = GladCombat.AmazonLevelCombos1H
			else:
				levelCombos = GladCombat.AmazonLevelCombosSP
			self.CheckAttackList(me, levelCombos, GladCombat.AmazonCombos)
		self.ChanceOfFuryOnHurt = 0.15
		self.ChanceOfFuryOnLeaderDeath = 0.1
		inv= me.GetInventory()
		if inv.HoldingShield: 
			me.BlockingPropensity = 0.7
			me.RangeDefenceCapable = TRUE
		else: 
			me.BlockingPropensity = 0.4
			me.RangeDefenceCapable = FALSE

################################################################################

################################################################################
# Parse the CharType  automatically
################################################################################
classes_defined= dir()
def GladiatorDefaultFuncs (pers):		
	if pers.CharType in classes_defined:	
		exec_string = 'pers.Data=' + pers.CharType + '(pers)'
		exec (exec_string)		
		Bladex.CheckPyErrors()
		if not pers.Data:
			raise NameError, 'CharType must not have valid associated class'
		Bladex.CheckPyErrors()	
	else:
		Reference.debugprint("WARNING: "+pers.CharType+" is an unrecognised class in GladiatorTypes.py!")
		pers.Data= Enm_Def.NPCPerson (pers)		
################################################################################