###############################################################################
#  Gladiator Mod
#  by Josh Dahlby
#
#  Map loading/configuration
#
###############################################################################

import Bladex
import LoadBar
import whrandom
import os
import GladCfg

if GladCfg.PlayerName != '<Current>':
	Bladex.DeleteStringValue('MainChar')
else:
	GladCfg.PlayerScore = (0, 0, 0, 0)

loadTime = 200
if len(GladCfg.SelectedEnemies) == 0:
	loadTime = 400
else:
	loadTime = loadTime + len(GladCfg.SelectedEnemies) * 8

LoadBar.ECTSProgressBar(loadTime,"blade_progress.jpg")

# Clear out the old pak so that a new one can be built
try:
	os.remove("../../Maps/Gladiator/pak/BODPak.dat")
	os.remove("../../Maps/Gladiator/pak/pf.pak")
except:
	pass

execfile("../../Scripts/sys_init.py")

initFiles = []
level = None
if GladCfg.LastLevel == 'Arena1':
	level = "king.lvl"
	GladCfg.playerPosition = (-1060.49388999, -3200, 2567.27016586)
	GladCfg.spawnPositions = [
			 {"Position": (5328.32278238, -3179.75997073, -4484.91534521), "Angle": 0.852158892935 },
			 {"Position": (1066.12022226, -5225.6174496, 9657.1034063), "Angle": 2.96319965764 },
			 {"Position": (-6361.81093273, -4452.41887828, 7286.20120991), "Angle": 3.78468802723 },
			 {"Position": (-9237.28212213, -2858.85037515, -1047.86904886), "Angle": 5.10809074004 },
			 {"Position": (-3277.9614324, -3314.04929288, -8901.93760897), "Angle": 6.0945917846 },
			 {"Position": (7771.99358833, -1767.19989087, 3398.68567746), "Angle": 2.34011965923 }]
	initFiles = ["lavax.py", "traps.py"]
elif GladCfg.LastLevel == 'Arena3':
	level = "3arena.lvl"
	GladCfg.playerPosition = (17357.5903205, -8607.17320549,-7239.03893886)
	GladCfg.playerAngle = 3.82765280822
	GladCfg.spawnPositions = [
			 {"Position": (29025.9729742, -2887.44000099,14680.7250827), "Angle": 2.42799448537 },
			 {"Position": (22312.1042316, -8138.48472817,-4606.68168809), "Angle": 0.957927499919 },
			 {"Position": (-2046.36456624, -7145.81558843,1068.77587607), "Angle": 6.10968703493 },
			 {"Position": (5082.94935092, -2637.90972346,13718.2899675), "Angle": 3.6109925343 },
			 {"Position": (16522.9133838, -879.818752273,-18645.0028065), "Angle": 0.40333896663 }]
	initFiles = ["Objs.py"]
elif GladCfg.LastLevel == 'Arena4':
	level = "castle.lvl"
	GladCfg.playerPosition = (10228.0664116, 1111.38849021,30671.671282)
	GladCfg.playerAngle = 2.0127724297
	GladCfg.spawnPositions = [
			 {"Position": (18600.4108168, 859.599830139,14308.9785242), "Angle": 1.72437848319 },
			 {"Position": (141.962791675, -385.820879845,-9548.79456147), "Angle": 6.25706081434 },
			 {"Position": (-10031.3607802, 860.848663848,460.383439796), "Angle": 4.723511702 },
			 {"Position": (-15748.2350803, -4393.17975708,1973.64934523), "Angle": 5.21063290332 },
			 {"Position": (-7672.87331702, -2888.43308093,12927.3173394), "Angle": 3.32182805516 }]
	initFiles = ['Luces.py', "..\\Gladiator\\objetos.py"] 
elif GladCfg.LastLevel == 'Arena5':
	level = "arena5.lvl"
	GladCfg.playerPosition = (-24367, -11239, 28623)
	GladCfg.playerAngle = 3.09585939158
	GladCfg.spawnPositions = [
			 {"Position": (-19926.5162628, -11689.647587,4399.12697377), "Angle": 0.678346954593 },
			 {"Position": (-30555.560936, -11673.820639,4871.02929535), "Angle": 5.6489203347 },
			 {"Position": (-24566.6403968, -11691.9569011,46432.0578077), "Angle": 3.13351292112 },
			 {"Position": (-22191.4072225, -11190.3503374,23855.163454), "Angle": 0.890833162134 }]
	initFiles = ["Luces.py","Objs.py", "cuervos.py", "sonidos.py"]
elif GladCfg.LastLevel == 'Arena7':
	level = "arena7.lvl"
	GladCfg.playerPosition = (30002.6331049, -3344.60421916,10839.2111294)
	GladCfg.playerAngle = 1.59375002375
	GladCfg.spawnPositions = [
			 {"Position": (12311.3769519, -3895.65353762,10843.0134582), "Angle": 4.09868871956 },
			 {"Position": (17284.2168584, -3888.23012725,-5706.87661456), "Angle": 0.645876024303 },
			 {"Position": (-543.469226171, -888.447731823,384.610890059), "Angle": 4.93750077478 },
			 {"Position": (626.552600157, -2389.60715639,10881.3776604), "Angle": 3.81083829303 }]
	initFiles = ["agua.py", "objs.py"]
elif GladCfg.LastLevel == 'Casa':
	level = "casa.lvl"
	GladCfg.playerPosition = (29.2662216584, -1117.82226537, 13.7592263554)
	GladCfg.playerAngle = 5.52534647247
	GladCfg.randomPositions = 1
	initFiles = ["sonidos.py", "Sonidospuntuales.py", "sol.py", "agua.py", "objs.py"]
elif GladCfg.LastLevel == 'Barb_M1':
	import Sparks
	level = "barb.lvl"
	GladCfg.playerPosition = (-83243,8785,-127941)
	GladCfg.playerAngle = 0.0
	GladCfg.randomPositions = 1
	initFiles = ["ActorsInit.py", "DefFuncs.py", "MusicEvents.py", "TextureMaterials.py", 
		"Musica.py", "totem.py", "Trampa_pinchos.py", "pinchos3.py", "luces.py", "sol.py", 
		"cascada.py", "cascadaint.py", "cascadapint.py", "objs.py", "bloqueo.py", 
		"OBJETOS.py", "barriles.py", "antorchas.py", "rastrillo.py", "comestibles.py", 
		"armas.py", "cosas.py", "puente.py", "agua.py", "bolas.py", "cadaveres.py",
		"gentrampa.py", "deslz.py", "derr.py", "BreakDoors.py", "pinchos1.py", 
		"pinchos2.py", "puertas.py", "Sonidos.py", "Sonidospuntuales.py"]
elif GladCfg.LastLevel == 'Ragnar_M2':
	level = "ragnar.lvl"
	GladCfg.playerPosition = (-111000,7500,80000)
	GladCfg.playerAngle = 0.0
	GladCfg.randomPositions = 1
	initFiles = ["DefFuncs.py", "ActorsInit.py", "MusicEvents.py", "objs.py", "objsbrk.py", 
		"puertas.py", "pinchos.py", "antorchas.py", "TextureMaterials.py", "sonidos.py", 
		"Sonidospuntuales.py", "cascada.py", "agua.py", "escape.py", 
		"pendulos.py", "trampa_pinchos.py", "pivotes.py", "trampa_flechas.py", 
		"traps.py", "levadizo.py", "elevador.py", "Pocimas.py", "comestibles.py"]
elif GladCfg.LastLevel == 'Final':
	level = "palace.lvl"
	GladCfg.playerPosition = (94000, -3000, 219000)
	GladCfg.playerAngle = 3.14159
	GladCfg.randomPositions = 1
	initFiles = ["DefFuncs.py", "TextureMaterials.py", "objs.py", "sol.py", "puertas.py", "fuegos.py"]

else:
	# Custom map
	execfile("../" + GladCfg.LastLevel + "/" + GladCfg.LastLevel + ".glad")
	level = GladCfg.level

# Actions
import BInput
InputManager=BInput.GetInputManager()
InputManager.SetInputActionsSet("Default")
Bladex.AddInputAction("ReSpawn",0)
Bladex.AddInputAction("StartMusic", 0)
Bladex.AddInputAction("StartRound", 0)

# Load the level
if level != None:
	import sys
	sys.path.insert(0,"../" + GladCfg.LastLevel)
	os.chdir("../" + GladCfg.LastLevel)
	Bladex.ReadLevel("../Gladiator/gladiator.lvl")
	Bladex.ReadLevel(level)
	os.chdir("../Gladiator")
	execfile("../../Scripts/BladeInit.py")
	os.chdir("../" + GladCfg.LastLevel)
	for file in initFiles:
		try:
			print file
			execfile(file)
		except:
			import traceback
			traceback.print_exc()
	os.chdir("../Gladiator")
	import gladiator
