###############################################################################
#  Game Browser Mod (see readme.txt for update details)
#  by Josh Dahlby
#
#  http://www.dahlby.net/games/blade/
###############################################################################

import Language
import MenuText

SSelText = "Press ENTER to select a server"
if Language.Current == "Spanish":
	MenuText.ForeingDict[SSelText] = 'Press ENTER to select a server'
	MenuText.ForeingDict['Servers list'] = 'Servers list'
	MenuText.ForeingDict['Game Browser'] = 'Game Browser'

###############################################################################
# Server Functions
###############################################################################

import sys
# Add the path for the socket.py file
sys.path.insert(0,"../../lib/pythonlib/plat-win")
import urllib
import NetMisc
import Menu
import Reference
import netgame
import Bladex

urlroot = "http://www.dahlby.net/games/blade/scripts/"

def GetArenaName():
	return NetMisc.ARENANAME

registered = 0

def RegisterServer():
	Reference.debugprint("RegisterServer");
	try:
		url = urllib.urlopen(urlroot + "reggame.mv?arenaname=%s" %(GetArenaName()))
		line = "x"
		while line != "":
			line = url.readline()
			if len(line) > 4:
				Reference.debugprint(line)
		global registered
		registered = 1
	except:
		if Reference.DEBUG_INFO > 0:
			import traceback;
			traceback.print_exc();
	Bladex.AddScheduledFunc(Bladex.GetTime()+120, RegisterServer,(), "RegisterServer")


def UnRegisterServer():
	if registered != 1:
		return;
	Reference.debugprint("UnRegisterServer");
	url = urllib.urlopen(urlroot + "unregserver.mv")
	line = "x"
	while line != "":
		line = url.readline()
		if len(line) > 4:
			Reference.debugprint(line)

try:
	if  netgame.GetNetState() == 1:
		RegisterServer()
except:
	if Reference.DEBUG_INFO > 0:
		import traceback;
		traceback.print_exc();

def GetServerList():
	import string
	cmd = urlroot + "getservers.mv"
	url = urllib.urlopen(cmd)
	line = "x"
	servers = []
	while line != "":
		line = url.readline()
		if len(line) >=7:
			servers.append(string.split(string.strip(line), ','))
	return servers

try:
	oldexitfunc = sys.exitfunc
except:
	oldexitfunc = None

def HookExit():
	try:
		UnRegisterServer();
	except:
		if Reference.DEBUG_INFO > 0:
			import traceback;
			traceback.print_exc();
	if oldexitfunc:
		oldexitfunc()

sys.exitfunc = HookExit

################################################################################
# ServerList
################################################################################
import MenuText
import netwidgets
import MenuWidget
import BUIx

import ListWidget
import ScorerWidgets
class B_ServerList(ListWidget.B_ListWidget):
  def __init__(self,Parent,Menudesc,StackMenu,VertPos=0):
	ListWidget.B_ListWidget.__init__(self,Parent,Menudesc,StackMenu,VertPos)
	self.StatusText=BUIx.B_TextWidget(self,"Status",MenuText.GetMenuText(SSelText),ScorerWidgets.font_server,"..\\..\\Data\\Letras menu peq.bmp")
	self.StatusText.SetColor(252,247,167)
	self.StatusText.SetAlpha(1)
	self.AddLabel(self.StatusText,0.5,25,BUIx.B_Widget.B_LAB_HCenter,BUIx.B_Widget.B_LAB_Bottom,
				  BUIx.B_Widget.B_FR_HRelative,BUIx.B_Widget.B_LAB_HCenter,
				  BUIx.B_Widget.B_FR_AbsoluteTop,BUIx.B_Widget.B_FR_Top)
	self.DownArrow.SetAlpha(1) # Parche, no funciona la llamada a AdjustScrollArrows() en AddMenuElement(),
	self.SetClipDraw(1)
	self.SetDrawFunc(self.Draw)
	self.StackMenu = StackMenu
	self.Parent = Parent

	servers = GetServerList()
	for server in servers:
		self.AddServer(server)
	if len(self.MenuItems) > 0:
		self.SetFocus_Idx(0)
		self.MenuItems[0].SetHasFocus(1)
	else:
		self.NextFocus()

  def Draw(self,x,y,time):
	self.SetClipDraw(1)
	self.DefDraw(x,y,time)

  def SetStatusText(self,text):
	self.StatusText.SetText(text)
	self.RecalcLabelLayout(BUIx.B_Widget.B_LAB_HCenter,BUIx.B_Widget.B_LAB_Bottom)

  def SetHasFocus(self, foc):
	ListWidget.B_ListWidget.SetHasFocus(self, foc)
	curfoc = self.GetFocus()
	if curfoc != None:
		curfoc.SetHasFocus(foc)

  def SetFocus(self, menu_element):
	return ListWidget.B_ListWidget.SetFocus(self, menu_element)

  def NextFocus(self):
	try:
		if len(self.MenuItems) == 0:
			self.Parent.NextFocus()
			return
		lastfocus = self.GetFocus()
		index = self.MenuItems.index(lastfocus)
		if index == len(self.MenuItems) - 1:
			lastfocus.SetHasFocus(0)
			self.Parent.NextFocus()
			return
	except:
		pass
	ListWidget.B_ListWidget.NextFocus(self)

  def GetServer(self, server):
	return {"Name": server[0],
			"IP": server[1],
			"Kind" 	:B_ServerText
		   }

  def AddServer(self, server):
	try:
		oldidx = self.MenuItems.index(self.GetFocus())
	except:
		oldidx = -1
	sub = B_ServerText(self, self.GetServer(server), self.StackMenu)
	self.AddMenuElement(sub)
	self.RecalcLayout()

  def AcceptsFocus(self):
    if len(self.MenuItems) <= 0:
      return 0
    else:
      return 1

  def DoScroll(self,amount):
	for i in range(2, self.nWidgets(), 1): 
		self.MoveWidgetRel_Idx(i,0,amount)
	self.VertPos=self.VertPos+amount

  def RemoveItem(self, item):
	index = self.MenuItems.index(item)
	if index == self.nWidgets() - 3:
		self.PrevFocus()
	else:
		self.NextFocus()
	index = self.MenuItems.index(item)
	self.RemoveWidget_Idx(index + 2)
	self.MenuItems.pop(index)
	self.ListSize = self.ListSize - item.GetSize()[1]
	self.WidgetsVPos.pop()
	self.WidgetsHeights.pop(index)
	for i in range(index, len(self.MenuItems), 1):
		self.MoveWidgetRel_Idx(i + 2, 0, -15)
	self.RecalcLayout()

################################################################################
# ServerText
################################################################################
class B_ServerText(MenuWidget.B_MenuItemTextNoFX):
	def __init__(self,Parent,MenuDescr,StackMenu,VertPos=0):
		MenuWidget.B_MenuItemTextNoFX.__init__(self,Parent,MenuDescr,StackMenu)
		self.name = MenuDescr["Name"]
		self.ip = MenuDescr["IP"]

	def ActivateItem(self,act):
		if(act):
			import NetMisc
			NetMisc.SetIp(self.ip)
			Menu.BackMenu(0)
			addr = Menu._MainMenu.MenuStack.Top().MenuItems[0]
			addr.Input = self.ip
			Menu._MainMenu.MenuNextItem()
		else:
			MenuWidget.B_MenuItemTextNoFX.ActivateItem(self,act)

	def Draw(self,x,y,z):
		if self.GetVisible()==0:
			return
		foc=self.GetHasFocus()
		if foc:
			self.SetColor(252,247,167)
		else:
			self.SetColor(207,144,49)
		self.SetText(self.name + ' (' + self.ip + ')')
		self.DefDraw(x,y,z)

BrowseMenu = {"Name":MenuText.GetMenuText("Game Browser"),
              "Size":(640,480),
              "ListDescr":[
                           {"Name"     : MenuText.GetMenuText("Servers list"),
                            "Kind"     : B_ServerList,
                            "Size"     : (610,200),
							"VSep"     : 120,
                            "ListDescr": []
                           },
                           {"Name"    : MenuText.GetMenuText("BACK"),
                            "VSep"    : 10,
                            "Command" : Menu.BackMenu,
                           },
                           {"Name":"Back",
                            "Kind":MenuWidget.B_BackBlank
                           }
                          ]
             }

try:
	joinmenu = Menu.GetMenuItem(['GAME','ARENA', 'JOIN GAME'])['ListDescr']
	if joinmenu != None:
		joinmenu.insert(1, BrowseMenu)
except:
	pass
