##############################################################################
## HeadMatrix Mod v0.3 - by Masklin - Apr-2001
##############################################################################

# Mod imports
import Bladex
import Reference
import GameText
import Basic_Funcs
import darfuncs

# Translations

import Language
import MenuText


if Language.Current == "Spanish":
   MenuText.ForeingDict['HeadMatrix  disabled']  = 'HeadMatrix  Desactivado'
   MenuText.ForeingDict['HeadMatrix  enabled']   = 'HeadMatrix  Activado'


HeadMatrix_Enabled = 0

def EnableDisableHeadMatrix ():
	global HeadMatrix_Enabled
	
	if HeadMatrix_Enabled:
		print "HeadMatrix: Disable"
		pj=Bladex.GetEntity ("Player1")
		pj.Data.OnKilledEnemy=pj.Data.OnKilledEnemyOrg
		HeadMatrix_Enabled = 0
		GameText.WriteTextAux(MenuText.GetMenuText("HeadMatrix  disabled"),2.0,255,255,255,[])
	else:
		print "HeadMatrix: Enable"
		pj=Bladex.GetEntity ("Player1")
		pj.Data.OnKilledEnemyOrg=pj.Data.OnKilledEnemy
	        pj.Data.OnKilledEnemy=KilledEnemy
		HeadMatrix_Enabled = 1
		GameText.WriteTextAux(MenuText.GetMenuText("HeadMatrix  enabled"),2.0,255,255,255,[])

def HeadMatrix (EntityName,obj_name,x,y,z,nx,ny,nz,node):

	Reference.debugprint ("HeadMatrix: "+EntityName+": Mutilation node ="+`node`)
  	bt=Bladex.GetEntity(EntityName)
	if node == bt.GetNodeIndex("Head"): #Reference.BODY_HEAD:
	#if bt.MutilationsMask & 2:
		Reference.debugprint ("HeadMatrix: Matrix ON")
		darfuncs.StartMatrixFX()
		# Slow time in Matrix mode: 1 =~ 10s?
		Bladex.AddScheduledFunc(Bladex.GetTime()+1.0,darfuncs.StopMatrixFX,())
	bt.Data.MutilateFuncOrg (EntityName,obj_name,x,y,z,nx,ny,nz,node)


def KilledEnemy (EntityName):

	Reference.debugprint ("HeadMatrix: Killed "+EntityName)
  	bt=Bladex.GetEntity(EntityName)
	bt.MutilateFunc=HeadMatrix
	pj=Bladex.GetEntity ("Player1")
	pj.Data.OnKilledEnemyOrg (EntityName)



import BInput
IManager = BInput.GetInputManager()
oldSet = IManager.GetInputActionsSet()
IManager.SetInputActionsSet("Default")
Bladex.AddInputAction("EnableDisableHeadMatrix", 0)
Bladex.AddBoundFunc("EnableDisableHeadMatrix", EnableDisableHeadMatrix)
Bladex.AssocKey("EnableDisableHeadMatrix",  "Keyboard",	"Y", 	1)
IManager.SetInputActionsSet(oldSet)

