import Bladex
import Doors
import Reference
import darfuncs
import AuxFuncs
import B3DLib
import Actions
import Change
import Gems
import Objects
import AbreCam
import Torchs
import Arrows
import Auras
import GameText
import GenFX
import Actions
import stone
import Water
import LevelFuncs
import Sparks
import Levers
import Scorer
import GotoMapVars
import Ontake
import BUIx
import Select
import Breakings
import CharData

import whrandom
import BCopy
import re

from Tr import Tr
import Talk
import MoriaTypes
from MoriaMenu import DifficultyLevel  




##-------------------------------------------------------------
## Save Game
##-------------------------------------------------------------

GameText.MapList['INN'] = Tr('El ltimo Puente');


##-------------------------------------------------------------
## Control de dificultad
##-------------------------------------------------------------

expected_player_lvl_min= 6  #   7 in Scorer
expected_player_lvl_max= 14 #  15 in Scorer

TRUE = 1==1
FALSE = not TRUE

DIF_EASY = FALSE
DIF_NORMAL = FALSE
DIF_HARD = FALSE

if   DifficultyLevel == -1:
     DIF_EASY = TRUE
elif DifficultyLevel == 0:
     DIF_NORMAL = TRUE 
else:
     DIF_HARD = TRUE 


def PlayerHasWeapon (Weapon):
	me = Bladex.GetEntity('Player1')
	inv = me.GetInventory()
	for i in range (inv.nWeapons):
	    item_name = inv.GetWeapon(i)
	    if item_name == None: return 0
	    if item_name == Weapon: return 1
	    item=Bladex.GetEntity(item_name)
	    if item.Kind == Weapon: return 1
	return 0
	
def PlayerHasObject (Object):
	me = Bladex.GetEntity('Player1')
	inv = me.GetInventory()
	for i in range (inv.nObjects):
	    item_name = inv.GetObject(i)
	    if item_name == None: return 0
	    if item_name == Object: return 1
	    item=Bladex.GetEntity(item_name)
	    if item.Kind == Object: return 1
	return 0

"""
8- Espada de combate (la justa furia) - Espadaromana - 35 * 10 = 350 =>490  Kgt_g_27kata_new 
9- Espada elfica (el sueo) - Espadaelfica 50 * 8.5 = 425 *3 ataques (anm_def.py) = 1275 Kgt_g_32_5_3new
10- maza de combate (golpe de lord kerman) - Maza2 - 70 * 9 = 630 * 3=1890 Kgt_g_21_6_s8new

Amazona
8- lanza de combate ( corte del relampago) - Lanza - 35* 10 = 350 Amz_g_spear19
9- naginata (cortavidas) - Naginata - 50 * 8.6 = 430 Amz_g_spear22
10- tridente (furia del mar) - Tridente - 75 * 8.0 = 600 Amz_g_spear09

"""

def SetLevelAndLife (EntityName, MinLevel, MaxLevel=None, MinLife=80, MaxLife=100):
	global expected_player_lvl_min, expected_player_lvl_max, DifficultyLevel

	expected_player_lvl_max = expected_player_lvl_max + DifficultyLevel

	Entity=Bladex.GetEntity(EntityName)
	if MaxLevel == None:
	   MaxLevel = MinLevel + (expected_player_lvl_max-expected_player_lvl_min)
	if MinLevel > MaxLevel:
	   MaxLevel= MinLevel
	# Ajuste por nivel del jugador / player level adjust
	lvl_control= LevelFuncs.EnemyLevelControl (expected_player_lvl_min, expected_player_lvl_max)
#	print "DBG - Ajustando Level de ", Entity.Name, ": Rango: ", MinLevel,"-",MaxLevel
	Entity.Level=lvl_control.GiveLevel(MinLevel,MaxLevel)
#	print "DBG - Ajustando Level de ", Entity.Name, ": Level=", Entity.Level

	# Ajuste por combos / combo availability adjust
	pj=Bladex.GetEntity('Player1')
	if pj.Kind == 'Knight_N':
	   if pj.Level >= 8 and PlayerHasWeapon('Espadaelfica'): Entity.Level=Entity.Level+2
	else:
	   if pj.Level >= 9 and PlayerHasWeapon('Tridente'): Entity.Level=Entity.Level+1

	# Ajuste por objectos especiales / special objects adjust
   	if PlayerHasObject('Araswen_Vial'): Entity.Level=Entity.Level+1

	# Ajuste manual / Manual adjust
	
#	print "DBG - Ajustando Level de ", Entity.Name, ": Dificulty: ", DifficultyLevel
	Entity.Level = Entity.Level + 2* DifficultyLevel
#	print "DBG - Ajustando Level de ", Entity.Name, ": Final Level=", Entity.Level 

	Entity.Life = whrandom.randint(MinLife, MaxLife)*CharStats.GetCharMaxLife(Entity.Kind, Entity.Level)/100
	   


##-------------------------------------------------------------
##     Conversaciones
##-------------------------------------------------------------

pj=Bladex.GetEntity('Player1')
if (pj.Kind == "Knight_N"):
	Talk.Load ('PosadaDamathar')
else:
	Talk.Load ('PosadaMelian')


def AddJournalEntry (personName, dlgId):
	if DIF_EASY and dlgId == 'Mas datos':
	   Talk.AddToJournal ('Facilon')
		   
	if DIF_EASY and dlgId == 'Runas2':
	   Talk.AddToJournal ('Facilon2')
		    
Talk.AddCallBackFunc ('AddJournalEntry', AddJournalEntry)


NoMasVueltas=4
def CercaCorredor (SectorIndex,Entity_Name):
	global Corredor, NoMasVueltas
	if Entity_Name != 'Player1': return
	NoMasVueltas=NoMasVueltas-1
	if NoMasVueltas == 0:
	   if DIF_EASY:
	      Talk.AddToJournal ('Facilon3')
	   Corredor.OnEnter=None
	   
	
def AddJournalEntry (personName, dlgId):
	if DIF_EASY and dlgId == 'Mas datos':
	   Talk.AddToJournal ('Facilon')
		   
	if DIF_EASY and dlgId == 'Runas2':
	   Talk.AddToJournal ('Facilon2')


##-------------------------------------------------------------
##     Animaciones complementarias para Moria guys
##-------------------------------------------------------------

MoriaTypes.ExtraAnmForMoriaEnemies()
	

##-------------------------------------------------------------
##     Funciones complementarias.
##-------------------------------------------------------------

def UseVenom (Nombre,TipoUso):
	Pot= Bladex.GetEntity(Nombre)
	pj=Bladex.GetEntity('Player1')
	Bladex.AddScheduledFunc(Bladex.GetTime()+2.0, pj.Data.EnVenom, ('Player1', Pot.Data.VenomStrength, Nombre))
	pocimac.UsePotion(Nombre,TipoUso)

def CreateVenom (Nombre, VenomInmediateDamage = -50, VenomStrength=6, MaxLife = 180):
	Pot = Bladex.GetEntity(Nombre)
	Pot.Static = 0
	Pot.Data = pocimac.Pocima(Pot)
	Pot.UseFunc = UseVenom
	Pot.Data.Increment = VenomInmediateDamage
	Pot.Data.MaxLife = MaxLife
	Pot.Data.CuresPoison = 0	
	Pot.Data.Sonido = Sonido_Veneno
	Pot.Data.VenomStrength = VenomStrength
	
	return Pot.Data
	
	
def RemueveTierraGen(pos, v1, v2, v3):
	tierra=Bladex.CreateEntity("TierraRemoviendose", "Entity Particle System D3", pos[0]+v1[0], pos[1]-1100.0, pos[2]+v1[2])
	tierra.D1=v2[0]-v1[0], 0.0, v2[2]-v1[2]
	tierra.D2=v3[0]-v1[0], 0.0, v3[2]-v1[2]
	if pos[1]>3000.0:
		tierra.ParticleType="Tierra2sub"
	else:
		tierra.ParticleType="Tierra2"
	tierra.PPS=64
	tierra.YGravity=200.0
	tierra.Friction=0.1
	tierra.Velocity=0.0, -400.0, 0.0
	tierra.RandomVelocity=15.0
	tierra.Time2Live=64
	tierra.DeathTime=Bladex.GetTime()+2.0

def RemueveAguaGen(enmgen):
	pos=enmgen.Position
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.0, Water.RemueveAgua,(pos[0], pos[1]-2000.0, pos[2],1000,1000))
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, Water.DropBubbles,(pos[0], pos[1]-2000.0, pos[2]))

def SaltaTierraGen(enmgen):
	char=Bladex.GetEntity("Player1")
	pos=enmgen.Position
	v=char.Position[0]-pos[0], 0.0, char.Position[2]-pos[2]
	v=B3DLib.Normalize(v)
	v1=v[0]*500.0, 0.0, v[2]*500.0
	v2=v1[0]*math.cos(1.7453)-v1[2]*math.sin(1.7453), 0.0, v1[0]*math.sin(1.7453)+v1[2]*math.cos(1.7453)
	v3=v2[0]*math.cos(2.7925)-v2[2]*math.sin(2.7925), 0.0, v2[0]*math.sin(2.7925)+v2[2]*math.cos(2.7925)
	saltatie=Bladex.CreateEntity("TierraSaltando", "Entity Particle System D1", pos[0], pos[1]-1100.0, pos[2])
	saltatie.ParticleType="Tierra3"
	saltatie.PPS=1024
	saltatie.YGravity=4900.0
	saltatie.Friction=0.05
	saltatie.Velocity=0.0, -600.0, 0.0
	saltatie.RandomVelocity=50.0
	saltatie.Time2Live=60
	saltatie.DeathTime=Bladex.GetTime()+10.0/60.0
	saltati2=Bladex.CreateEntity("TierraSaltando2", "Entity Particle System D1", pos[0], pos[1]-1100.0, pos[2])
	if pos[1]>3000.0:
		saltati2.ParticleType="Tierra2sub"
	else:
		saltati2.ParticleType="Tierra2"
	saltati2.PPS=128
	saltati2.YGravity=200.0
	saltati2.Friction=0.1
	saltati2.Velocity=0.0, -300.0, 0.0
	saltati2.RandomVelocity=15.0
	saltati2.Time2Live=32
	saltati2.DeathTime=Bladex.GetTime()+10.0/60.0
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, RemueveTierraGen, (pos, v1, v2, v3))


def SectoresQueResbalan ():
	
	# Tejado Posada
	Bladex.GetSector(-6023.17567784, -7783.67561336, 345.079637118).TooSteep=1
	Bladex.GetSector(-3722.83261633, -7521.74962461, -1374.31137282).TooSteep=1
	# Inicio Rio
	Bladex.GetSector(67613.2846705, -5805.88989891, 53949.6543759).TooSteep=1
	Bladex.GetSector(60990.0618654, -5434.04531439, 53349.8351443).TooSteep=1
	Bladex.GetSector(69084.3083093, -7069.18788938, 48596.5373274).TooSteep=1
	Bladex.GetSector(67051.0382238, -5436.62120802, 50505.9216925).TooSteep=1
	# Alrededores posada
	Bladex.GetSector(-42895.2515006, -6696.35113668, -23110.9553915).TooSteep=1
	Bladex.GetSector(-38417.8999615, -6590.01954049, -27034.2388185).TooSteep=1
	Bladex.GetSector(-19046.1677589, -6522.31587733, -39143.0209179).TooSteep=1
	Bladex.GetSector(30519.6344351, -5213.41634848, -31434.470567).TooSteep=1
	Bladex.GetSector(-28800.1204713, -3441.98527683, 10784.9366).TooSteep=1
	Bladex.GetSector(-33568.3012066, -3923.54071074, 5075.64854246).TooSteep=1
	# Desfiladero Final
	Bladex.GetSector(103894.821851, -12378.954654, -41868.9568879).TooSteep=1
	Bladex.GetSector(164270.382781, -8076.70488094, -83446.0460818).TooSteep=1
	#Bladex.GetSector(172523.981402, -10906.2202434, -108538.637951).TooSteep=1
	Bladex.GetSector(175782.410391, -13605.2042334, -55325.605406).TooSteep=1
	## Aqui esta el orco arquero
	##Bladex.GetSector(111999.784806, -11638.1667858, -35997.6245584).TooSteep=1
	Bladex.GetSector (145758.887065, -9853.22934151, -57317.1727795).TooSteep=1
	Bladex.GetSector (156118.852628, -9033.56971143, -73148.3486977).TooSteep=1



SectoresQueResbalan()

lavaFpuenteInicio=0
def LavaFpuenteTimer(entityName,time):
	global lavaFpuenteInicio
	time=time-lavaFpuenteInicio
	lava = Bladex.GetEntity(entityName)
	factor=time/100 # El efecto dura 100 segundos, proporcional a la velocidad del rio de lava
	lava.Zoom = 0.03 + factor/100
	# El cambio de iluminacin queda extrao. Sera mejor un cambio de textura
	#r=whrandom.random()
	#if r> 0.85:
	#   lava.SelfLight = r
	#else:
	#   lava.SelfLight = 1
	if (factor>1.00) :
		lavaFpuenteInicio=Bladex.GetTime()

def CreateRiolavaFpuente():
	global lavaFpuenteInicio
	lava=Bladex.GetEntity("LavaFalsoPuente")
	lavaFpuenteInicio=Bladex.GetTime()
	lava.TimerFunc=LavaFpuenteTimer
	lava.SubscribeToList("Timer60")

def ResetCamara():
	Cam = Bladex.GetEntity("Camera")
	Cam.SetPersonView("Player1")
	Cam.Cut()
	
##-------------------------------------------------------------
## Escena inicial
##-------------------------------------------------------------


def InicioMapa ():
  	Bladex.KillMusic()
    	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("EmpiezaElEspectaculo"),))
	Bladex.DeactivateInput()
	pj=Bladex.GetEntity('Player1')
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.3, pj.GoTo, (-23854.7076483, -2170.06869512, 16589.1058096))
	Bladex.AddScheduledFunc(Bladex.GetTime()+5.0, ShowTitulo, ())
	Bladex.AddScheduledFunc(Bladex.GetTime()+10.0, EmpiezaLuchaPosada, ())
    	Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, IntroCam, ())
	Bladex.AddScheduledFunc(Bladex.GetTime()+15.0, MasOrcosParaLaPosada, ())
	## Para que la armadura de la Posada no se pueda usar
	Reference.EntitiesObjectData["Armadura_276"]= [Reference.OBJ_ARMOUR,  "None", 3 , 80]
	## Parece que no funcionan las pociones ocultas
	o=Bladex.GetEntity("Pocima200_Cofre")
	o.RemoveFromWorld()
	## Pista
	if DIF_EASY:
	   o=Bladex.GetEntity("Pergamino2_291")
	   o.UseFunc=LeePergamino
	## Modifica las tablas de experiencia
	#                           at level(lvls            0       1       2       3       4       5       6       7       8       9      10      11      12      13      14      15      16      17      18      19 
	#CharData.CharExperienceReward['Dark_Knight']= [   200,    400,    800,   1600,   3200,   6400,  12800,  25600,  51200,  70000,  90000, 100000, 130000, 150000, 170000, 190000, 210000, 240000, 260000, 280000]
	CharData.CharExperienceReward['Dark_Knight']=  [   200,    400,    800,   1600,   3200,   6400,   6400,   6400,  12800,  51200,  51200,  51200, 100000, 130000, 150000, 170000, 190000, 240000, 260000, 280000]


def ShowTitulo ():
	GameText.WriteTextAux(Tr("MoriaMod.   Captulo  I\nEl  ltimo  Puente"),10.0,252,247,167,[],400)
	
def GlofrorEsHumano ():
	Glofror=Bladex.GetEntity("Glofror")
	Glofror.Data.Invincibility=0

def MasOrcosParaLaPosada ():
	o=Bladex.GetEntity ("Ork_Posada_872b")
	o.Blind=0
	o.Deaf=0
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, o.GoTo, (21081.4422891, -1068.76649863, -5661.7755866))
	o=Bladex.GetEntity ("Ork_Posada_875b")
	o.Blind=0
	o.Deaf=0
	Bladex.AddScheduledFunc(Bladex.GetTime()+2.0, o.GoTo, (23068.184197, -1069.99874182, -12180.3661907))
	Glofror=Bladex.GetEntity("Glofror")
	Bladex.AddScheduledFunc(Bladex.GetTime()+ 5.0, Glofror.Data.ContraMi, ())
	Bladex.AddScheduledFunc(Bladex.GetTime()+10.0, Glofror.Data.ContraMi, ())
	Bladex.AddScheduledFunc(Bladex.GetTime()+10.0, GlofrorEsHumano, ())
	


def IntroCam ():
	AbreCam.ResetNode()
	AbreCam.AddNode ((-27702,-2193,24428),(-32255,-1578,33311), 3)    # Entrada
	AbreCam.AddNode ((-28913,-3748,20122),(-26100,-884,29281),2)
	AbreCam.AddNode ((-36496,-6679,15786),(-27339,-3643,18420),4)     # Cascada
	AbreCam.AddNode ((-36496,-6679,15786),(-26861,-5790,13263),5)
	AbreCam.AddNode ((-26105,-4731,2538),(-18237,-3738,-3554), 2)     # Lateral
	AbreCam.AddNode ((-24666,-6077,-17548),(-15360,-5490,-13935),4)   # Esquina
	AbreCam.AddNode ((-5906,-15004,-30642),(-4305,-12119,-21203), 4)  # Frontal
	AbreCam.LastTime=0
	AbreCam.AbreCam()

def EmpiezaLuchaPosada ():
	SetLevelAndLife ("Ork_Posada_872", 4)
	darfuncs.UnhideBadGuy ("Ork_Posada_872")
	SetLevelAndLife ("Ork_Posada_875", 4)
	darfuncs.UnhideBadGuy ("Ork_Posada_875")
	SetLevelAndLife ("Ork_Posada_872b", 4)
	darfuncs.UnhideBadGuy ("Ork_Posada_872b")
	SetLevelAndLife ("Ork_Posada_875b", 4)
	darfuncs.UnhideBadGuy ("Ork_Posada_875b")
	o=Bladex.GetEntity ("Ork_Posada_872b")
	o.Blind=1
	o.Deaf=1
	o=Bladex.GetEntity ("Ork_Posada_875b")
	o.Blind=1
	o.Deaf=1
	Glofror=Bladex.GetEntity("Glofror")
	Glofror.Data.Invincibility=1
	Bladex.AddScheduledFunc(Bladex.GetTime()+6.0, Glofror.Data.ContraMi, ())

TraslaPosada=None
def TePille (SectorIndex,Entity_Name):
	global TraslaPosada
	if Entity_Name != 'Player1': return
	Actions.TurnToFaceEntityNow("Great_Ork_Posada_878", "Player1")
	TraslaPosada.OnEnter=None

def OrcoGrandeLuchaPosada ():
	global TraslaPosada
	SetLevelAndLife ("Great_Ork_Posada_878", 6)
	darfuncs.UnhideBadGuy ("Great_Ork_Posada_878")
	TraslaPosada=Bladex.GetSector(-6399.37604577, -1070.15739617, 13349.5941069)
	TraslaPosada.OnEnter=TePille
	

def OrcoTejado (SectorIndex,Entity_Name):
	global TRTejado
	if Entity_Name != 'Player1': return
	SetLevelAndLife ("Ork_tejado_866", 4)
	darfuncs.UnhideBadGuy ("Ork_tejado_866")
	Bladex.KillMusic()
    	Bladex.ExeMusicEvent (Bladex.GetMusicEvent("LuchaCorta"))
	TRTejado.OnEnter=""

Posada_N_Ork = 5
def PosadaOrkKilled (entity):
	global Posada_N_Ork
	
	Bladex.GetEntity(entity).Data.DefImDeadFunc(entity)
	Posada_N_Ork = Posada_N_Ork - 1
	if Posada_N_Ork == 1:
	   Actions.TurnToFaceEntityNow("Player1", 'Glofror')
	   Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, Talk.Assign, ('Glofror', 'Hola',Talk.SeeEvent))	

def GoPuertaPosada ():
	Glofror=Bladex.GetEntity("Glofror")
	Glofror.GoTo (8533.00613284, -1070.00562732, -7975.59127454)
	Glofror.RouteEndedFunc = GoDentroPosada
	   
def GoDentroPosada (entityName):
	Glofror=Bladex.GetEntity("Glofror")
	Glofror.GoTo (-2951.44799155, -1067.97725732, 1468.20070529)

GlofrorDlgId=None
ElglarDlgId=None
def VayamosDentro (personName, dlgId):
	global EntraPosada, EntraPosada2
	global GlofrorDlgId, ElglarDlgId
	Glofror=Bladex.GetEntity("Glofror")
	Glofror.Blind=1
	Glofror.Deaf=1
	GlofrorDlgId=Glofror.Data.dlgId
	if GlofrorDlgId == None:
	   GlofrorDlgId='Lo intento otra vez'
	   ElglarDlgId=None	
	   Glofror.Data.SetHLC (1)
	else:
	   ElglarDlgId='Hola'
	Talk.Assign ('Glofror', 'AStar')
	Bladex.AddScheduledFunc(Bladex.GetTime()+5.0, GoPuertaPosada, ())
	OrcoGrandeLuchaPosada ()	
	EntraPosada.OnEnter=IniciaConversacionPosada
	EntraPosada2.OnEnter=IniciaConversacionPosada2


def VayaMdePathFinding (personName, dlgId):
	Glofror=Bladex.GetEntity("Glofror")
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, GoPuertaPosada, ())

Talk.AddCallBackFunc ('VayaMdePathFinding', VayaMdePathFinding)


GlofrorHaLlegado=0
def PorfinLlegoGlofror ():
	global GlofrorDlgId, ElglarDlgId, GlofrorHaLlegado
	GlofrorHaLlegado=1
	Glofror=Bladex.GetEntity("Glofror")
	Glofror.Data.dlgId=GlofrorDlgId
	Elglar=Bladex.GetEntity("Elglar")
	Elglar.Data.dlgId=ElglarDlgId
	darfuncs.UnhideBadGuy ("Elglar")

Talk.AddCallBackFunc ('VayamosDentro', VayamosDentro)

def Perdonado (personName, dlgId):
	Glofror=Bladex.GetEntity("Glofror")
	Glofror.Data.SetHLC (0)
	Bladex.AddScheduledFunc(Bladex.GetTime()+60.0, Talk.Assign, ('Elglar', 'Hola'))	
	Bladex.AddScheduledFunc(Bladex.GetTime()+60.0, Talk.Assign, ('Glofror', 'Alguno mas',Talk.SeeEvent))	

Talk.AddCallBackFunc ('Perdonado', Perdonado)

def IniciaConversacionPosada (SectorIndex,Entity_Name):
	global EntraPosada, EntraPosada2, GlofrorHaLlegado
	if Entity_Name == 'Glofror' and not GlofrorHaLlegado: 
	   PorfinLlegoGlofror()
	   return
	if Entity_Name != 'Player1': return
	darfuncs.UnhideBadGuy ("Elglar")
	if GlofrorHaLlegado:
	   Glofror=Bladex.GetEntity("Glofror")
	   Glofror.Angle=3.25648040708
	   Glofror.Blind=0
	   Glofror.Deaf=0
	   Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, Talk.Assign, ('Glofror', Glofror.Data.dlgId, Talk.SeeEvent))	
	   EntraPosada.OnEnter=None
	   EntraPosada2.OnEnter=None

def IniciaConversacionPosada2 (SectorIndex,Entity_Name):
	global EntraPosada, EntraPosada2, GlofrorHaLlegado
	if Entity_Name == 'Glofror': 
	   PorfinLlegoGlofror()
	   return
	if Entity_Name != 'Player1': return
	darfuncs.UnhideBadGuy ("Elglar")
	if GlofrorHaLlegado:
	   Glofror=Bladex.GetEntity("Glofror")
	   Glofror.Angle=1.0
	   Glofror.Blind=0
	   Glofror.Deaf=0
	   Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, Talk.Assign, ('Glofror', Glofror.Data.dlgId, Talk.SeeEvent))	
	   EntraPosada.OnEnter=None
	   EntraPosada2.OnEnter=None


def UnPocoDeMusicaON (personName, dlgId):
  	Bladex.KillMusic()
    	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("Leyendas"),))
Talk.AddCallBackFunc ('UnPocoDeMusicaON', UnPocoDeMusicaON)

def UnPocoDeMusicaOFF (personName, dlgId):
  	Bladex.KillMusic()
	Talk.Assign ('Glofror', 'Mas datos')

Talk.AddCallBackFunc ('UnPocoDeMusicaOFF', UnPocoDeMusicaOFF)


def MejorNoMuero (EntityName):
	Scorer.SetVisible(0)
	cam = Bladex.GetEntity("Camera")
	cam.SType=0
	cam.TType=0
	AuxFuncs.FadeTo(3.0,60.0,32,0,0)
    	Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, GameText.WriteTextAux,(Tr("La sangre inocente de ")+EntityName+Tr(" pesa sobre tu conciencia..."),10.0,252,247,167,[],400))	
  	Bladex.KillMusic()  	
    	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("MuerteAliado"),))
	pj = Bladex.GetEntity('Player1')
	#Bladex.AddScheduledFunc(Bladex.GetTime()+5.0, Matame,(pj,))
	#Bladex.AddScheduledFunc(Bladex.GetTime()+10.0,Bladex.LoadLevel,("Casa",))
	Bladex.AddScheduledFunc(Bladex.GetTime()+10.0,Menu.ActivateMenu,())


def MonjeSorpresa (EntityName, weapon_name, px, py, pz, ximpulse, yimpulse, zimpulse, x_norm, y_norm, z_norm,ximpulse=0,yimpulse=0,zimpulse=0,x_norm=0,y_norm=0,z_norm=0,material=""):
	Bladex.AddScheduledFunc(Bladex.GetTime(), ObjectMagicallyDisappearing, (EntityName, 5, AuxFuncs.DESTROY_METHOD_BIN))
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("SorpresaCorta"),))	


def LeePergamino (entityname, use_from):
	o=Bladex.GetEntity(entityname)
	o.UseFunc=None
	GameText.WriteTextAux(Tr("Parecen las notas de alguien..."),3.0,252,247,167,[],100)
	Talk.AddToJournal ('Facilon4')
		
	
##-------------------------------------------------------------
## Cuervos
##-------------------------------------------------------------

def CreateCrow(pos,fps,orient):
	cuervovolando1=Bladex.CreateEntity("CuervoVolando1", "Crw",pos[0],pos[1],pos[2])
	cuervovolando1.Orientation=orient
	cuervovolando1.CastShadows=0
	cuervovolando1.Actor=1
	cuervovolando1.Animation="Crw_act11"
	cuervovolando1.FPS=fps
	cuervovolando1.SendSectorMsgs=0
	cuervovolando1.TurnOn()

def CreateCrowFijos ():
	crow1=Bladex.CreateEntity("Crow0","Pio",52333, -6641., -26024)
	crow1.Orientation=(0.0,0.0,0.707106769085,-0.707106769085)
	crow1.Actor=1
	crow1.Animation="Crw_pic"
	crow1.FPS=20.0
	crow1.SendSectorMsgs=0
	crow1.TurnOn()

##-------------------------------------------------------------
## Cascadas en el Rio
##-------------------------------------------------------------

def CreateCascadaMoria (Cascada,p,d,v,pc,Time = 16,Grav = 13000,PPS = 600):
	cascada=Bladex.CreateEntity(Cascada, "Entity Particle System D2",p[0],p[1],p[2])
	cascada.D=d[0],d[1],d[2] 
	cascada.ParticleType="AguaCp"
	cascada.Friction=0.07
	cascada.RandomVelocity=10.0
	cascada.Velocity=v[0],v[1],v[2]
	cascada.PPS=PPS
	cascada.YGravity=Grav
	cascada.Time2Live=Time

	espuma=Bladex.CreateEntity(Cascada+"Espuma", "Entity Particle System D2",pc[0],pc[1],pc[2])
	espuma.D=d[0],d[1],d[2]
	espuma.ParticleType="Espumap"
	espuma.PPS=50
	espuma.YGravity=0.0
	espuma.Friction=0.07
	espuma.Velocity=0.0, -1000.0, 0.0
	espuma.RandomVelocity=30.0
	espuma.RandomVelocity_V=30.0
	espuma.Time2Live=10

def BorrarCascadaMoria (cascadaName):
	cascada = Bladex.GetEntity(cascadaName)
	cascada.SubscribeToList("Pin")
	
	espuma = Bladex.GetEntity(cascadaName+"Espuma")
	espuma.SubscribeToList("Pin")

##-------------------------------------------------------------
## Msica
##-------------------------------------------------------------

def MusicaEntradaDesfiladero():
  	Bladex.KillMusic()
    	Bladex.AddScheduledFunc(Bladex.GetTime()+0.2, Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("EntradaDesfiladero"),))
    	SetLevelAndLife ("Great_Ork_Sorpresa_1078", 6)
    	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, darfuncs.UnhideBadGuy, ("Great_Ork_Sorpresa_1078",))
    	
def MusicaEntradaCascadas():
  	Bladex.KillMusic()  	
    	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("EntradaCascadas"),))

def MusicaEntradaTrampas():
  	Bladex.KillMusic()  	
    	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("EntradaCascadas"),))

MusicaEntradaCuevaRioEscuchada=0
def MusicaEntradaCuevaRio():
	global MusicaEntradaCuevaRioEscuchada
  	Bladex.KillMusic()  	
    	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("CuevaRio"),))
    	MusicaEntradaCuevaRioEscuchada = 1

def Sorpresa ():
  	Bladex.KillMusic()  	
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("SuspenseSorpresa"),))	

##-------------------------------------------------------------
## Entrada en sectores mortales
##-------------------------------------------------------------
    	
CancelaAhogaPlayer=0
def Matame (Entity):
	print "DBG Matame"
	print "DBG Matame a ",Entity.Name
	global CancelaAhogaPlayer
	print "DBG Matame cuanto vale CancelaAhogaPlayer",CancelaAhogaPlayer
	if CancelaAhogaPlayer==0:
	   print "DBG Matame OK a ",Entity.Name
	   Entity.Life = 0

def AhogaPlayer(zPos) :
	global CancelaAhogaPlayer
	CancelaAhogaPlayer=0
	pj=Bladex.GetEntity('Player1')
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.0, Water.RemueveAgua,(pj.Position[0],zPos,pj.Position[2],1000,1000))
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, Water.DropBubbles,(pj.Position[0],zPos,pj.Position[2]))
	Bladex.AddScheduledFunc(Bladex.GetTime()+5.0, Matame,(pj,))
	cam  = Bladex.GetEntity("Camera")
	cam.SType = 0
	cam.TType = 0

def AhogaPlayer2000(index,ent) :
	if (ent!="Player1") : return
	AhogaPlayer(2000)
	
def AhogaPlayer3000(index,ent) :
	if (ent!="Player1") : return
	AhogaPlayer(3000)

def AhogaPlayer500(index,ent) :
	if (ent!="Player1") : return
	AhogaPlayer(1000)

def FCancelaAhogaPlayer  (SectorIndex,Entity_Name):
	global CancelaAhogaPlayer
	CancelaAhogaPlayer=1
	ResetCamara()

def AhogaPlayerYa (SectorIndex, Entity_Name):
	if Entity_Name != 'Player1': return
	Bladex.DeactivateInput()
	pj=Bladex.GetEntity('Player1')
	pj.Life = 0
	Bladex.AddScheduledFunc(Bladex.GetTime() + 1.0, pj.Freeze, ())	
	Bladex.AddScheduledFunc(Bladex.GetTime() + 1.2, Bladex.ActivateInput, ())	
	cam  = Bladex.GetEntity("Camera")
	cam.SType = 0
	cam.TType = 0

##-------------------------------------------------------------
## Zona de pozo en el interior de la montaa
##-------------------------------------------------------------

def ActivaEnmPozo (SectorIndex,Entity_Name):
	global TRCorredorPozo
	if Entity_Name != 'Player1': return
	SetLevelAndLife ("Ork_Pozo_808", 5)
	darfuncs.UnhideBadGuy ("Ork_Pozo_808")
	pers=Bladex.GetEntity("Ork_Pozo_808")
	pers.GoTo (66296.2151506, -1670.11565515, 10194.4456008)
	SetLevelAndLife ("Great_Ork_Sotano_837", 4)
	darfuncs.UnhideBadGuy ("Great_Ork_Sotano_837")
	SetLevelAndLife ("Great_Ork_Pozo_841", 5)
	darfuncs.UnhideBadGuy ("Great_Ork_Pozo_841")
	darfuncs.UnhideBadGuy ("Ork_Pozo_834")	
	Bladex.ExeMusicEvent (Bladex.GetMusicEvent("LuchaIntensa"))
	TRCorredorPozo.OnEnter=None

def OrcoTraidorPozo (SectorIndex,Entity_Name):
	global TRCentroPozo
	if Entity_Name != 'Player1': return
	SetLevelAndLife ("Ork_Pozo_Traidor_845", 4)
	darfuncs.UnhideBadGuy ("Ork_Pozo_Traidor_845")
	arquero=Bladex.GetEntity("Ork_Pozo_834")
	if arquero and arquero.Life<0:
	   arquero.LookAtEntity('Player1')
	TRCentroPozo.OnEnter=None


##-------------------------------------------------------------
## Sotano de la Posada
##-------------------------------------------------------------


	
def SeAcabo (Entity_Name):
	global QuienSoy
	QuienSoy.AnmEndedFunc=None
	QuienSoy.Angle= 5.4
	QuienSoy.Life=0

QuienSoySeAcabo=0
Quejio=0
def SigueHablando (Entity_Name, time):
	global QuienSoySeAcabo,QuienSoy,Quejio
	QuienSoy.SetOnFloor()
	if (Quejio >= 300 ):
	   Quejio = 0 
	   Sonido_QS_Herido.PlaySound(0)
	Quejio=Quejio+1
	if QuienSoySeAcabo == 1:
		QuienSoy.RemoveFromList("Timer15")
		QuienSoy.TimerFunc=""
		QuienSoy.Angle= 5.4
#		QuienSoy.AnmEndedFunc=SeAcabo
		QuienSoy.Wuea=Reference.WUEA_ENDED
		QuienSoy.Freeze()
		QuienSoy.Position=(13259., 3803., 4574.)
		QuienSoy.SetOnFloor()
		QuienSoy.Angle= 5.4
		QuienSoy.Life=0


def LaLlaveParaTi(personName, dlgId):
	Bladex.AddScheduledFunc(Bladex.GetTime(), ApareceLlaveCelebrimbor,())
	
Talk.AddCallBackFunc ('LaLlaveParaTi', LaLlaveParaTi)

def ApareceLlaveCelebrimbor(): 
	LC=Bladex.CreateEntity("LlaveCelebrimbor","LlaveBlanca",13288.0692012, 2177.55407327, 4328.50884323)
	LC.Static        = 0
	LC.Scale         = 1
	LC.Orientation   = 0.707106769085, 0.0, 0.0, 0.707106769085
	LC.TimerFunc     = RotaTimer
	LC.SubscribeToList("Timer15")
	darfuncs.SetHint(LC,Tr('Llave de Celebrimbor'))

	Reference.EntitiesObjectData['LlaveCelebrimbor']=[Reference.OBJ_KEY]
   
	luzLC=Bladex.CreateEntity("LuzLlaveCelebrimbor","Entity Spot",13288.0692012, 2177.55407327, 4328.50884323)
	luzLC.Color=64,64,255
	luzLC.Intensity=5
	luzLC.Precission=0.1
	luzLC.CastShadows=0
	luzLC.Visible=1
	luzLC.Flick=0   
	luzLC.SizeFactor = 1.5
	luzLC.AngVel=0.3
	luzLC.GlowTexture="StarParticle"
	LC.Link(luzLC) 

def RotaTimer(e_name, time):
   
	LC = Bladex.GetEntity("LlaveCelebrimbor")
	LC.Rotate(1, 0, 0, 0.08) #0.06532)
  
	if QuienSoySeAcabo:
          LC.RemoveFromList("Timer15")
          LC.TimerFunc     = ""
          luzLC=Bladex.GetEntity("LuzLlaveCelebrimbor")
          luzLC.SubscribeToList('Pin')
          Bladex.AddScheduledFunc(Bladex.GetTime(), Actions.TakeObject,("Player1",LC.Name))
          Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, Scorer.CycleElements,())
   
 
def FinConversacionQuienSoy(personName, dlgId):
	global QuienSoySeAcabo
	QuienSoySeAcabo=1
	pj=Bladex.GetEntity('Player1')
	if (pj.Kind == "Knight_N"):
		Delay=8
	else:
		Delay=11
	Bladex.DeactivateInput()	
 	Bladex.AddScheduledFunc(Bladex.GetTime()+Delay, Bladex.KillMusic, ())
 	Bladex.AddScheduledFunc(Bladex.GetTime()+Delay+0.2, Sonido_QS_Muerte.PlaySound, (0,))
	Bladex.AddScheduledFunc(Bladex.GetTime()+Delay+0.8, ResetCamara, ())	
 	Bladex.AddScheduledFunc(Bladex.GetTime()+Delay+0.8, Bladex.ActivateInput, ())

Talk.AddCallBackFunc ('FinConversacionQuienSoy', FinConversacionQuienSoy)

def IniciaConversacionQuienSoy():
	global QuienSoy
	Actions.TurnToFaceEntityNow("Player1", QuienSoy.Name)
	pj=Bladex.GetEntity('Player1')
	pj.LaunchAnmType('Rlx')
  	Bladex.KillMusic()
	#Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, CierraRastrilloSotano, ())
    	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("OhMelancolia"),))
    	Bladex.ActivateInput()
	Talk.Assign (QuienSoy.Name, 'Quien Eres')
	Talk.Say (QuienSoy.Name)
		
def EncuentraQuienSoy (SectorIndex,Entity_Name):
	global QuienSoySector
	global QuienSoy
	if Entity_Name != 'Player1': return
	QuienSoySector.OnEnter=None
	Bladex.DeactivateInput()
	pj=Bladex.GetEntity('Player1')
	pj.GoTo (15290.1583474, 2950.63304942, 5330.3651014)
	cam=Bladex.GetEntity("Camera")
	auxi1=cam.Position
	auxi2=cam.TPos
	Point=(14078,1620,7363)
	Target=(13075,6758,-1157)
	AuxFuncs.MoveCamFromTo(auxi1[0], auxi1[1], auxi1[2], Point[0], Point[1], Point[2], auxi2[0],auxi2[1], auxi2[2],Target[0], Target[1], Target[2], 3)
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, IniciaConversacionQuienSoy, ())

def OcultaRastrilloSotano ():
	r=Bladex.GetEntity("Rastrillo_863")
	#r.Scale=0.25
	r.SubscribeToList('Pin')
	
def AbreRastrilloSotano ():
	r=Bladex.GetEntity("Rastrillo_863")
	dinobj = Objects.CreateDinamicObject(r.Name)
	Objects.DisplaceObjectFromTo(dinobj, r.Position, (r.Position[0],r.Position[1]-2800,r.Position[2]), 3000, 1,Sonido_Rastrillo_Activado, Sonido_Rastrillo_Moviendo, Sonido_Rastrillo_Final)	
	Bladex.AddScheduledFunc(Bladex.GetTime()+5.0, OcultaRastrilloSotano, ())
	
    	   
def CierraRastrilloSotano ():
	r=Bladex.GetEntity("Rastrillo_863")
	#r.Scale=0.6
	dinobj = Objects.CreateDinamicObject(r.Name)
	Objects.DisplaceObjectFromTo(dinobj, r.Position, (r.Position[0],r.Position[1]+2800,r.Position[2]), 3000, 1,Sonido_Rastrillo_Activado, Sonido_Rastrillo_Moviendo, Sonido_Rastrillo_Final)	

def ExplicaGemaR(ent,object) :
	GameText.WriteTextAux(Tr("El prisionero tena un objeto de valor...\nEl Gworan Rojo!!!"),3.0,252,247,167,[],100)

def ApareceGemarR (ent, usedfrom):
	o=Bladex.CreateEntity("GemaR","Gemaroja",0,-60000,0, Reference.ObjType("Gemaroja"))
	o.Scale=1.0
	o.Orientation=(1.0,0.0,0.0,0.0)
	darfuncs.SetHint(o,Tr('El Gworan Rojo'))
	Actions.TakeObject("Player1", "GemaR")
	Change.ChangeObject("Player1","GemaR",ExplicaGemaR)
	o=Bladex.GetEntity("PrisioneroMuerto")
	o.UseFunc=None

def OrcoSotanoKilled (entity):
	global QuienSoySector
	global QuienSoy
	Bladex.GetEntity(entity).Data.DefImDeadFunc(entity)
	AbreRastrilloSotano()
	pj=Bladex.GetEntity('Player1')
	if (pj.Kind == "Knight_N"):
#	   No se puede cargar dos veces
	   try:
	     Bladex.ReadBitMap("../../Data/Icons/icono amazona.bmp","AmazonIcon")
	   except:
	     pass
	   Reference.EnemiesScorerData[QuienSoy.Name]=("AmazonIcon","Amazon")
	else:
	   try:
	     Bladex.ReadBitMap("../../Data/Icons/icono caballero.bmp","KnightIcon")
	   except:
	     pass
	   Reference.EnemiesScorerData[QuienSoy.Name]=("KnightIcon","Knight")	   
	darfuncs.UnhideBadGuy (QuienSoy.Name)
	QuienSoy.TimerFunc=SigueHablando
	QuienSoy.SubscribeToList("Timer15")	
	QuienSoy.SetTmpAnmFlags(1,1,0,0,1,1,0)	
#	QuienSoy.LaunchAnimation("sufre")
	QuienSoy.LaunchAnimation("Tkn_death_btomb")
	QuienSoy.SetOnFloor()
	QuienSoy.Angle= 5.4
	QuienSoySector.OnEnter=EncuentraQuienSoy
	o=Bladex.GetEntity("PrisioneroMuerto")
	o.UseFunc=ApareceGemarR
	

OrcosEnLaPosada=0
def AbreBodega ():
	global AccesoBodega
	global OrcosEnLaPosada
	AccesoBodega.SetWhileOpenSound(Sonido_Puerta_Subiendo)
	AccesoBodega.SetEndOpenSound(Sonido_Puerta_Final)
	AccesoBodega.SetEndCloseSound(Sonido_Puerta_Final)
	AccesoBodega.OpenDoor()
	if OrcosEnLaPosada == 0:
	   OrcosEnLaPosada=1
    	   Glofror=Bladex.GetEntity("Glofror")
    	   Glofror.Position=(-2546.34364469, -1097.04704134, -216.584411454)
    	   Glofror.Angle=2.32107495571
    	   Glofror.Life=CharStats.GetCharMaxLife(Glofror.Kind, Glofror.Level)
	   darfuncs.HideBadGuy ("Glofror")
    	   Elglar=Bladex.GetEntity("Elglar")
    	   Elglar.Position=(537.632343645, -1097.047172, 8007.90296539)
    	   Elglar.Angle=6.01639193722
	   darfuncs.UnhideBadGuy ("Elglar")    	   
	   
	   o=Bladex.GetEntity("mesa113")
	   o.Position=-2793.82157222,-697.389718684,-2359.01894067
	   o.Orientation=(0.0189450290054,0.707489192486,0.706165492535,-0.0207480397075)
	   o=Bladex.GetEntity("silla125")
	   o.Position=-6280.94197798,-338.986188636,6268.77484205
	   o.Orientation=(0.288154095411,-0.574326217175,0.728939950466,-0.236142396927)
	   o=Bladex.GetEntity("silla126")
	   o.Position=-5862.96654085,-386.607639495,6576.66452053
	   o.Orientation=(0.0425251722336,0.00461945030838,-0.998785555363,0.0244485456496)
	   o=Bladex.GetEntity("silla127")
	   o.Position=-3359.16018531,-383.94670855,6837.33379505
	   o.Orientation=(0.00864599552006,0.00150581670459,0.999702095985,-0.0227762069553)
	   o=Bladex.GetEntity("mesa185")
	   o.Position=-4582.04180806,-1103.02808338,-2233.29332094#-1096.72090033,-2287.91775138,-2288.06826183
	   o.Orientation= (0.334899157286,-0.942250430584,0.00245344219729,0.000834505131934)#(0.281072288752,-0.959378182888,0.0215691030025,-0.0112512987107)
	   o=Bladex.GetEntity("tab186")
	   o.Position=142.698592577,-357.061382321,2508.46194794
	   o.Orientation=(0.985729455948,0.0536704026163,0.0481027774513,0.152128353715)
	   o=Bladex.GetEntity("tab187")
	   o.Position=-2917.62437971,-248.764597296,-1631.45135946
	   o.Orientation=(0.506014466286,-0.58508682251,-0.478043615818,-0.416049301624)
	   o=Bladex.GetEntity("farol324")
	   o.Position=102.421880514,-155.649707937,-4516.51011813
	   o.Orientation=(0.0,0.693327724934,0.720609903336,0.00425014039502)
	   o=Bladex.GetEntity("farol323")
	   o.FiresIntensity=[ 30 ]
	   o.Lights= [(0.0, 0.03125, (255, 196, 128))]

#	   AbreRastrilloSotano()
	   global Bodega
	   Bodega.OnEnter=Socorro
	   
	   try:
	     Breakings.BreakSpecialObject( 'cajon193', 'FirstPlayerSword' , 2263.35228848 , -2078.70322921 , 8627.35155504 , 7699.00543484 , 4300.87941868 , 4714.63164417 , -0.0312652587891 , -234.445343018 , 0.624626159668 , 0.000996381986688 , 859.323697867 , 0.00290704904556 )
	     Breakings.BreakSpecialObject( 'cajama188', 'FirstPlayerSword' , 3085.27334826 , -1051.23889613 , 9749.8136622 , 2003.53480883 , 14092.6871009 , 17035.9035592 , -0.00975545247396 , 178.176017761 , 0.627700805664 , -4.17983780305e-005 , 446.987312317 , 0.000193357467651 )
	   except:
	     pass




def Socorro (SectorIndex,Entity_Name):
	global Bodega
	if Entity_Name != 'Player1': return
	Bodega.OnEnter=None
   	Bladex.KillMusic()
    	Bladex.ExeMusicEvent (Bladex.GetMusicEvent("LuchaLigera"))
    	darfuncs.UnhideBadGuy ("Elglar")
	Bladex.AddScheduledFunc(Bladex.GetTime()+4, Talk.Assign, ('Elglar', 'Sotano',Talk.SeeEvent))

def LuchaEnLaPosada (personName, dlgId):
   	Bladex.KillMusic()
    	Bladex.ExeMusicEvent (Bladex.GetMusicEvent("LuchaLigera"))
    	SetLevelAndLife ("Great_Ork_Posada2_1", 7)
	darfuncs.UnhideBadGuy ("Great_Ork_Posada2_1")
	SetLevelAndLife ("Great_Ork_Posada2_2", 8)
	darfuncs.UnhideBadGuy ("Great_Ork_Posada2_2")
	darfuncs.UnhideBadGuy ("Glofror")
    	Glofror=Bladex.GetEntity("Glofror")
	Glofror.Data.ContraMi()
	Glofror.Data.Invincibility=1
	Bladex.AddScheduledFunc(Bladex.GetTime()+15.0, GlofrorEsHumano, ())
Talk.AddCallBackFunc ('LuchaEnLaPosada', LuchaEnLaPosada)

Posada2_N_Ork = 2
def Posada2OrkKilled (entity):
	global Posada2_N_Ork
	
	Bladex.GetEntity(entity).Data.DefImDeadFunc(entity)
	Posada2_N_Ork = Posada2_N_Ork - 1
	if Posada2_N_Ork == 1:
   	   Bladex.KillMusic()
	   Actions.TurnToFaceEntityNow("Player1", 'Glofror')
	   Glofror=Bladex.GetEntity("Glofror")
	   Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, Talk.Assign, ('Glofror', 'Por poco',Talk.SeeEvent))	


def CierraBodega ():
	global AccesoBodega
	AccesoBodega.CloseDoor()	


##-------------------------------------------------------------
## Zona de Trampas en el interior de la montaa
##-------------------------------------------------------------

## Rutinas comunes
##-------------------------------------------------------------

def TRPolvo (posx, posz, posy):
	polvo3=Bladex.CreateEntity("Polvo3", "Entity Particle System D2",posx,posz,posy)
	polvo3.ParticleType="SpDust"
	polvo3.D=-3600, 0, 0
	polvo3.YGravity=0.0
	polvo3.Friction=0.2
	polvo3.PPS=480
	polvo3.Velocity=0.0, -2000.0, 4000.0
	polvo3.RandomVelocity=40.0
	polvo3.Time2Live=60
	polvo3.DeathTime=Bladex.GetTime()+3.0/60.0
	polvo4=Bladex.CreateEntity("Polvo4", "Entity Particle System D2", posx,posz,posy)
	polvo4.ParticleType="SpDust"
	polvo4.D=-3600, 0, 0
	polvo4.YGravity=0.0
	polvo4.Friction=0.2
	polvo4.PPS=480
	polvo4.Velocity=0.0, -2000.0, -4000.0
	polvo4.RandomVelocity=40.0
	polvo4.Time2Live=60
	polvo4.DeathTime=Bladex.GetTime()+10.0/60.0

def ObjectMagicallyDisappearing(ObjName, TimeEffect, destroy=0):
	time=Bladex.GetTime()
	o=Bladex.GetEntity(ObjName)
	o.Alpha=1.0
	o.RasterMode="Read"
	InitDataField.Initialise(o)
	o.Data.AuxFuncsData= AuxFuncs.ObjectAuxFuncsData()
	AuxFuncs.FadeObject(ObjName, 1.0, 0.01, TimeEffect, destroy)
	AuraParams0=(240, 0.01, 1.0, 0, 1, 1)
	AuraParams1=(50 , 1.0 , 1.0, 0, 1, 1)
	AuraParams2=(50 , 0.01, 1.0, 0, 1, 1)
	AuraGradient0=(2,  0.2, 0.4, 0.8, 1.0, 0.2  ,  0.0, 0.2, 0.8, 0.0, 0.7)
	AuraGradient1=(2,  0.8, 0.9, 1.0, 1.0, 0.2  ,  0.0, 0.2, 0.9, 0.1, 1.0)
	aura=Auras.MakeAura(ObjName, TimeEffect, AuraParams2, (), (), AuraGradient0)
	aura.Data.AddEvent (time+TimeEffect/2.0, AuraParams1, (), (), AuraGradient1)
	aura.Data.AddEvent (time+TimeEffect, AuraParams0, (), (), AuraGradient0)
	ps=Bladex.CreateEntity("PSPersonMagicallyAppearing", "Entity Particle System Dperson", 0.0, 0.0, 0.0)
	ps.ObjectName=ObjName
	ps.ParticleType="EnergyDissip"
	ps.PPS=200
	ps.YGravity=0.0
	ps.Friction=0.0
	ps.Velocity=0.0, 0.0, 0.0
	ps.RandomVelocity=0.5
	ps.NormalVelocity=2.0
	ps.Time2Live=60
	ps.DeathTime=time+TimeEffect/3.0

def ObjectMagicallyAppearing(ObjName, TimeEffect, destroy=0):
	time=Bladex.GetTime()
	o=Bladex.GetEntity(ObjName)
	o.Alpha=0.0
	o.RasterMode="Read"
	InitDataField.Initialise(o)
	o.Data.AuxFuncsData= AuxFuncs.ObjectAuxFuncsData()
	AuxFuncs.FadeObject(ObjName, 0.01, 1.0, TimeEffect, destroy)
	AuraParams0=(240, 0.01, 1.0, 0, 1, 1)
	AuraParams1=(50 , 1.0 , 1.0, 0, 1, 1)
	AuraParams2=(50 , 0.01, 1.0, 0, 1, 1)
	AuraGradient0=(2,  0.2, 0.4, 0.8, 1.0, 0.2  ,  0.0, 0.2, 0.8, 0.0, 0.7)
	AuraGradient1=(2,  0.8, 0.9, 1.0, 1.0, 0.2  ,  0.0, 0.2, 0.9, 0.1, 1.0)
	aura=Auras.MakeAura(ObjName, TimeEffect, AuraParams2, (), (), AuraGradient0)
	aura.Data.AddEvent (time+TimeEffect/2.0, AuraParams1, (), (), AuraGradient1)
	aura.Data.AddEvent (time+TimeEffect, AuraParams0, (), (), AuraGradient0)
	ps=Bladex.CreateEntity("PSPersonMagicallyAppearing", "Entity Particle System Dperson", 0.0, 0.0, 0.0)
	ps.ObjectName=ObjName
	ps.ParticleType="EnergyDissip"
	ps.PPS=200
	ps.YGravity=0.0
	ps.Friction=0.0
	ps.Velocity=0.0, 0.0, 0.0
	ps.RandomVelocity=0.5
	ps.NormalVelocity=2.0
	ps.Time2Live=60
	ps.DeathTime=time+TimeEffect/3.0

def PersonMagicallyAppearing(PersonName, TimeEffect):
	time=Bladex.GetTime()
	char=Bladex.GetEntity(PersonName)
	char.Alpha=0.01
	char.RasterMode="Read"
	char.CastShadows=1
	Bladex.AddScheduledFunc(time+TimeEffect, ChangeRasterMode, ("Player1", "Full"))
	AuxFuncs.FadeObject(PersonName, 0.01, 1.0, 2.0)
	if char.InvLeft<>"":
		obj=Bladex.GetEntity(char.InvLeft)
		obj.RasterMode="Read"
		Bladex.AddScheduledFunc(time+TimeEffect, ChangeRasterMode, (char.InvLeft, "Full"))
		AuxFuncs.FadeObject(char.InvLeft, 0.01, 1.0, TimeEffect)
	if char.InvRight<>"":
		obj=Bladex.GetEntity(char.InvRight)
		obj.RasterMode="Read"
		Bladex.AddScheduledFunc(time+TimeEffect, ChangeRasterMode, (char.InvRight, "Full"))
		AuxFuncs.FadeObject(char.InvRight, 0.01,  1.0, TimeEffect)
	if char.InvLeftBack<>"":
		obj=Bladex.GetEntity(char.InvLeftBack)
		obj.RasterMode="Read"
		Bladex.AddScheduledFunc(time+TimeEffect, ChangeRasterMode, (char.InvLeftBack, "Full"))
		AuxFuncs.FadeObject(char.InvLeftBack, 0.01,  1.0, TimeEffect)
	if char.InvRightBack<>"":
		obj=Bladex.GetEntity(char.InvRightBack)
		obj.RasterMode="Read"
		Bladex.AddScheduledFunc(time+TimeEffect, ChangeRasterMode, (char.InvRightBack, "Full"))
		AuxFuncs.FadeObject(char.InvRightBack, 0.01,  1.0, TimeEffect)
	AuraParams0=(240, 0.01, 1.0, 0, 1, 1)
	AuraParams1=(50 , 1.0 , 1.0, 0, 1, 1)
	AuraParams2=(50 , 0.01, 1.0, 0, 1, 1)
	AuraGradient0=(2,  0.2, 0.4, 0.8, 1.0, 0.2  ,  0.0, 0.2, 0.8, 0.0, 0.7)
	AuraGradient1=(2,  0.8, 0.9, 1.0, 1.0, 0.2  ,  0.0, 0.2, 0.9, 0.1, 1.0)
	aura=Auras.MakeAura(PersonName, TimeEffect, AuraParams0, (), (), AuraGradient0)
	aura.Data.AddEvent (time+TimeEffect/2.0, AuraParams1, (), (), AuraGradient1)
	aura.Data.AddEvent (time+TimeEffect, AuraParams2, (), (), AuraGradient0)
	ps=Bladex.CreateEntity("PSPersonMagicallyAppearing", "Entity Particle System Dperson", 0.0, 0.0, 0.0)
	ps.PersonName=PersonName
	ps.ParticleType="FastEnergyConc"
	ps.PPS=200
	ps.YGravity=0.0
	ps.Friction=0.0
	ps.Velocity=0.0, 0.0, 0.0
	ps.RandomVelocity=0.5
	ps.NormalVelocity=-2.0
	ps.Time2Live=30
	ps.DeathTime=time+TimeEffect/2.0

def PersonMagicallyDisappearing(PersonName, TimeEffect):
	time=Bladex.GetTime()
	char=Bladex.GetEntity(PersonName)
	char.Alpha=1.0
	char.RasterMode="Read"
	char.CastShadows=0
	Bladex.AddScheduledFunc(time+TimeEffect, ChangeRasterMode, ("Player1", "Full"))
	AuxFuncs.FadeObject(PersonName, 1.0, 0.01, 2.0)
	if char.InvLeft<>"":
		obj=Bladex.GetEntity(char.InvLeft)
		obj.RasterMode="Read"
		Bladex.AddScheduledFunc(time+TimeEffect, ChangeRasterMode, (char.InvLeft, "Full"))
		AuxFuncs.FadeObject(char.InvLeft, obj.Alpha, 0.01, TimeEffect)
	if char.InvRight<>"":
		obj=Bladex.GetEntity(char.InvRight)
		obj.RasterMode="Read"
		Bladex.AddScheduledFunc(time+TimeEffect, ChangeRasterMode, (char.InvRight, "Full"))
		AuxFuncs.FadeObject(char.InvRight, obj.Alpha, 0.01, TimeEffect)
	if char.InvLeftBack<>"":
		obj=Bladex.GetEntity(char.InvLeftBack)
		obj.RasterMode="Read"
		Bladex.AddScheduledFunc(time+TimeEffect, ChangeRasterMode, (char.InvLeftBack, "Full"))
		AuxFuncs.FadeObject(char.InvLeftBack, obj.Alpha, 0.01, TimeEffect)
	if char.InvRightBack<>"":
		obj=Bladex.GetEntity(char.InvRightBack)
		obj.RasterMode="Read"
		Bladex.AddScheduledFunc(time+TimeEffect, ChangeRasterMode, (char.InvRightBack, "Full"))
		AuxFuncs.FadeObject(char.InvRightBack, obj.Alpha, 0.01, TimeEffect)
	AuraParams0=(240, 0.01, 1.0, 0, 1, 1)
	AuraParams1=(50 , 1.0 , 1.0, 0, 1, 1)
	AuraParams2=(50 , 0.01, 1.0, 0, 1, 1)
	AuraGradient0=(2,  0.2, 0.4, 0.8, 1.0, 0.2  ,  0.0, 0.2, 0.8, 0.0, 0.7)
	AuraGradient1=(2,  0.8, 0.9, 1.0, 1.0, 0.2  ,  0.0, 0.2, 0.9, 0.1, 1.0)
	aura=Auras.MakeAura(PersonName, TimeEffect, AuraParams0, (), (), AuraGradient0)
	aura.Data.AddEvent (time+TimeEffect/2.0, AuraParams1, (), (), AuraGradient1)
	aura.Data.AddEvent (time+TimeEffect, AuraParams2, (), (), AuraGradient0)
	ps=Bladex.CreateEntity("PSPersonMagicallyDisappearing", "Entity Particle System Dperson", 0.0, 0.0, 0.0)
	ps.PersonName=PersonName
	ps.ParticleType="FastEnergyConc"
	ps.PPS=200
	ps.YGravity=0.0
	ps.Friction=0.0
	ps.Velocity=0.0, 0.0, 0.0
	ps.RandomVelocity=0.5
	ps.NormalVelocity=-2.0
	ps.Time2Live=30
	ps.DeathTime=time+TimeEffect/2.0

def DisipatePerson (persName):
	o=Bladex.GetEntity(persName)
	shootball=Bladex.CreateEntity(persName+"_Shoot","Entity Particle System Dperson", o.Position[0], o.Position[1], o.Position[2])
	shootball.PersonName=persName
	#shootball.ParticleType="EnergyConc" #"DeepOrangeEnergyConc" "MulticolourEnergyDissip" "DeepGreenMagicMissile" "DeepRedEnergyConc"
	shootball.ParticleType="FastEnergyConc"
	shootball.PPS=3000 #1000
	shootball.YGravity=0.0
	shootball.Friction=0.0
	shootball.RandomVelocity=5.0
	shootball.NormalVelocity=20.0
	shootball.Time2Live=30
	shootball.DeathTime=Bladex.GetTime()+2.0 #0.5

	
## Hace las antorchas atlantes y la bola de fuego seleccionables

Reference.DefaultSelectionData['AntorchaAtlante']=(8.0,2000.0,"Antorcha Atlante")
#Reference.DefaultSelectionData['BoladeFuego']=(8.0,2000.0,"Gworan")
Reference.EntitiesSelectionData['BF_GemaR']=(8.0,2000.0,"Gworan")

## Hace las antorchas atlantes usables como antorchas

Torchs.tipos_antorcha=("Antorcha", "Antorchaenpared", "Palangana", "AntorchaAtlante", "BoladeFuego")

## Permite almacenar hasta cuatro pociones de fuego

Reference.StackObjects['Botella']= 4

## Para que la armadura de la Posada no se pueda usar
Reference.EntitiesObjectData["Armadura_276"]= [Reference.OBJ_ARMOUR,  "None", 3 , 80]

## Parece que no funcionan las pociones ocultas
o=Bladex.GetEntity("Pocima200_Cofre")
if o:
   if o.Position[0]==0:
      	Bladex.AddScheduledFunc(Bladex.GetTime() + 10.0, o.RemoveFromWorld,())

## Modifica las tablas de experiencia
#                           at level(lvls            0       1       2       3       4       5       6       7       8       9      10      11      12      13      14      15      16      17      18      19 
#CharData.CharExperienceReward['Dark_Knight']= [   200,    400,    800,   1600,   3200,   6400,  12800,  25600,  51200,  70000,  90000, 100000, 130000, 150000, 170000, 190000, 210000, 240000, 260000, 280000]
CharData.CharExperienceReward['Dark_Knight']=  [   200,    400,    800,   1600,   3200,   6400,   6400,   6400,  12800,  51200,  51200,  51200, 100000, 130000, 150000, 170000, 190000, 240000, 260000, 280000]


## Entrada
##-------------------------------------------------------------
	

## Altar


def TRrestoreHand(ent):
	Change.RestoreHand(ent,1)
	Bladex.AddScheduledFunc(Bladex.GetTime() + 4.0, TRApartaPlayer,())
	Bladex.AddScheduledFunc(Bladex.GetTime() + 7.0, TRSubeColumna,())


TRInicioGema=0

def TRLightTimer(light,time):
	global TRInicioGema
	time=Bladex.GetTime()
	time=time-TRInicioGema
	luz = Bladex.GetEntity(light)
	luz.Intensity = time * 3.0		# red gem max int 3
	if (time>1.00) :
			luz.RemoveFromList("Timer15")
			luz.TimerFunc=""


def TRGemaPuesta(ent,event) :
	global TRInicioGema

	pj = Bladex.GetEntity('Player1')
	inv = pj.GetInventory()
	handItem = pj.InvRight
	inv.LinkRightHand("None")

	inv.RemoveObject(handItem)
	gemobj = None

	gspt = Bladex.GetEntity("GemRGPointer")
	gemobj = Bladex.GetEntity(handItem)
	gemobj.Position = gspt.Position
	gemobj.Static = 1
	gemobj.Scale = 1.061520
	gemobj.Orientation = 0.707080,0.006171,-0.006171,-0.707080
	
	luz = Bladex.CreateEntity("GemaRLight","Entity Spot",76052.1342351,-7576.21383898,15261.6715923)
	luz.Color = 120,1,4
	luz.Intensity = 2
	luz.CastShadows = 1
	luz.Precission = 0.06
	luz.Visible = 0
	luz.Flick = 0

	luz = Bladex.GetEntity("GemaRLight")
	luz.Position = gemobj.Position
	luz.TimerFunc=TRLightTimer;
	luz.SubscribeToList("Timer15")
	TRInicioGema=Bladex.GetTime()
	Gems.SetGemColor(Gems.RED_GEM)
	Gems.Concentrator(gemobj.Position)

	if gemobj:
		gemobj.SelfIlum = 1
		Bladex.ExeMusicEvent(Bladex.GetMusicEvent("PonerGema"))

def TRPonGema(ent,object) :
	pj = Bladex.GetEntity('Player1')
	AbreCam.ResetNode()
	AbreCam.AddNode ((82766,-14031,20198),(75198,-9083,14984), 5)
	AbreCam.AddNode ((83864,-11650,18015),(74717,-7954,16471), 7)
	AbreCam.AddNode ((80862,-9508,7871),(75440,-8936,16255), 7)
	AbreCam.AddNode ((76405,-9602,13133),(73851,-6594,22321), 7)
	AbreCam.AbreCam()
	pj.GoTo(75343.3632801, -8323.47523619, 15827.1694021)
	pj.LookAt ("GemRGPointer")
	Bladex.AddScheduledFunc(Bladex.GetTime() + 2.0, TRPonGema1,())

def TRPonGema1 ():
	pj = Bladex.GetEntity('Player1')
	pj.Position=(75343.3632801, -8323.47523619, 15827.1694021)
	pj.Angle = 4.08802090385
      	pj.LaunchAnmType("Kgt_fire_g")
	pj.AddAnmEventFunc("SetAlightEvent",TRGemaPuesta)
	pj.AnmEndedFunc = TRrestoreHand

def TRActivaAltarGemaR(gpointer,usefrom):

	if B3DLib.GetXZDistance('Player1', gpointer)> 1750:
		return

	pj = Bladex.GetEntity("Player1")
	inv = pj.GetInventory()

	if (inv.CarringObject("GemaR")) :
		Actions.TurnToFaceEntityNow("Player1",gpointer)
		Change.ChangeObject("Player1","GemaR",TRPonGema)
		Bladex.DeactivateInput()
		print "Tienes la gema roja"
	else:
		print "NO Tienes la gema roja"
		GameText.WriteTextAux(Tr("El Gworan Rojo traer el fuego\n y con l viajaremos de Sur a Norte\nde Oeste a Este"),10.0,252,247,167,[],100)

def TRUsaBF(bfName,usefrom):

	if B3DLib.GetXZDistance('Player1', bfName)> 1750:
		return

	pj = Bladex.GetEntity("Player1")
	objright=Bladex.GetEntity(pj.InvRight)
	if objright and (objright.Kind in Torchs.tipos_antorcha):
		Torchs.TorchUseFunc(bfName, usefrom)
		print "Tienes una antorcha"
	else:
		print "NO tienes una antorcha"
		GameText.WriteTextAux(Tr("El Gworan Rojo traer el fuego\n y con l viajaremos de Sur a Norte\nde Oeste a Este"),4.0,252,247,167,[],100)

def TRApagaAntorchaEnMano ():

	pj = Bladex.GetEntity("Player1")
	objright=Bladex.GetEntity(pj.InvRight)
	if objright and (objright.Kind in Torchs.tipos_antorcha):
		Torchs.ExtingueAntorcha(pj.InvRight)
		
def TRApartaPlayer():
	pj = Bladex.GetEntity("Player1")
      	pj.LaunchAnmType("Kgt_wbk")

def TRSubeColumna ():

	luz = Bladex.GetEntity("GemaRLight")
	luz.SubscribeToList("Pin")

	g=Bladex.GetEntity("GemaR")
	g.Position = g.Position[0], g.Position[1]-100, g.Position[2]
	dinobj = Objects.CreateDinamicObject(g.Name)
	Objects.DisplaceObjectFromTo(dinobj, g.Position, (g.Position[0],g.Position[1]-1400,g.Position[2]), 400, 1)
	Objects.RotateObject(dinobj, 3.14159*3, 1, 1, (0,0,0), (0,0,1), Objects.REL, "", "", "", "", (), "", ())
	
	o=Bladex.GetEntity("ColumnaGema")
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj, o.Position, (o.Position[0],o.Position[1]-1200,o.Position[2]), 400, 1)
	Objects.RotateObject(dinobj, 3.14159*3, 1, 1, (0,0,0), (0,0,1), Objects.REL, "", Sonido_Columna_Moviendo, "", "", (), TRCreaBolaFuego, ())

	Bladex.GetEntity("GemRGPointer").Position=g.Position[0],g.Position[1]-1400,g.Position[2]
	
	TRPolvo (g.Position[0]+100,g.Position[1]-50,g.Position[2]+100)
	TRPolvo (g.Position[0]-100,g.Position[1]-50,g.Position[2]-100)
	
def TRCreaBolaFuego ():
	global TRInicioBF
	g=Bladex.GetEntity("GemaR")
	bf=Bladex.CreateEntity("BF_GemaR","BoladeFuego",g.Position[0],g.Position[1],g.Position[2], Reference.ObjType("BoladeFuego"))
	bf.Orientation=(1.0,0.0,0.0,0.0)
	# Hacer la escala variable da algn problema (scale=-1.#ind) en algunas combinaciones de tiempo
	bf.Scale=0.5
	bf.FiresIntensity=[ 30.0 ]
	bf.Lights = [(0.0, 0.03125, (255, 0, 0))]
	Torchs.SetUsable(bf.Name)
	darfuncs.SetHint(bf,Tr('El Gworan Rojo'))
	TRInicioBF=Bladex.GetTime()
	bf.TimerFunc=TRFireTimer
	bf.SubscribeToList("Timer15")
	bf.UseFunc = TRUsaBF
	bf.Data.torchobjdata.LiveStatus=Torchs.ALIVE
	bf.Data.torchobjdata.LightStatus=Torchs.ON
	gspt = Bladex.GetEntity("GemRGPointer")
	gspt.SubscribeToList("Pin")
	Sonido_Encendido_BF.Play (bf.Position[0],bf.Position[1],bf.Position[2],0)
	Bladex.ActivateInput()
	



TRInicioBF=0
def TRFireTimer(entityName,time):
	global TRInicioBF
#	time=Bladex.GetTime()
	time=time-TRInicioBF
	bf = Bladex.GetEntity(entityName)
	factor=time/4 # El efecto dura 4 segundos
#	bf.Scale=factor*0.5 # 0->0.5
	bf.FiresIntensity=[ 30 - factor*27.0 ] # 30 -> 3
	bf.Lights = [(factor*3.0, 0.03125, (255, 196*factor, 128*factor))] # 0 -> 3.0 y Luces de Rojo a anaranjado
	if (factor>1.00) :
			bf.RemoveFromList("Timer15")
			bf.TimerFunc=""
			g=Bladex.GetEntity("GemaR")
			g.SubscribeToList('Pin')



## Puerta exterior



TRUltimaPuertad1 = 0
TRAbrirPuertad1  = 0

def TRConcentracionEnergia (pos):
	wps=Bladex.CreateEntity("TR_WPS", "Entity Particle System D1", pos[0]-800, pos[1], pos[2])
	wps.ParticleType="EnergyConc"
	wps.PPS=400
	wps.YGravity=0.0
	wps.Friction=0.0
	wps.Velocity=0.0, 0.0, 0.0
	wps.RandomVelocity=10.0
	wps.NormalVelocity=14.0
	wps.Time2Live=60
	wps.DeathTime=Bladex.GetTime()+1.75


def TRHideSector (sector):
	sector.Active=1

def TRUnhideSector (sector):
	sector.Active=0


#AI AD
#BI BD


def TRAbrePuertad1 (pos, sector):
	Sonido_Concentracion.Play (pos[0],pos[1],pos[2],0)	
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5,  TRConcentracionEnergia, (pos,))
	Bladex.AddScheduledFunc(Bladex.GetTime()+2.25, TRHideSector, (sector,))

def TRResetSectors ():
	global TRUltimaPuertad1,TRd1ai,TRd1bi,TRd1ad,TRd1bd
	Sonido_Concentracion.Play (91969, -10100, 14441,0)	
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.75, TRUnhideSector, (TRd1ai,))
	if TRUltimaPuertad1 >= 0:
	   Bladex.AddScheduledFunc(Bladex.GetTime()+0.5,  TRConcentracionEnergia, ((92848,-10441,15900),))
	   Bladex.AddScheduledFunc(Bladex.GetTime()+2.25, TRUnhideSector, (TRd1bi,))
	   TRApagaAntorcha ('S2_AD')
	if TRUltimaPuertad1 >= 1:
	   Bladex.AddScheduledFunc(Bladex.GetTime()+1.0,  TRConcentracionEnergia, ((92848,-10441,13029),))
	   Bladex.AddScheduledFunc(Bladex.GetTime()+2.75, TRUnhideSector, (TRd1ad,))
	   TRApagaAntorcha ('E3_BI')
	if TRUltimaPuertad1 >= 2:
	   Bladex.AddScheduledFunc(Bladex.GetTime()+1.5,  TRConcentracionEnergia, ((92896,-9034,16034),))
	   Bladex.AddScheduledFunc(Bladex.GetTime()+3.25, TRUnhideSector, (TRd1bd,))
	   TRApagaAntorcha ('O4_BD')
	TRUltimaPuertad1 = 0
	Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, TRApagaAntorcha, ('N1_AI',))
	Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, TRApagaAntorcha, ('S2_AD',))
	Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, TRApagaAntorcha, ('E3_BI',))
   	Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, TRApagaAntorcha, ('O4_BD',))


def TREnciendeLlamaAI ():
	global TRUltimaPuertad1
	global TRd1ai
	if TRUltimaPuertad1 <> 0:
	   TRResetSectors()	   
	else:
	   TRUltimaPuertad1 = 1
	   TRAbrePuertad1 ((92848,-10441,15900),TRd1ai)

def TREnciendeLlamaAD ():
	global TRUltimaPuertad1
	global TRd1ad
	if TRUltimaPuertad1 <> 1:
	   TRResetSectors()	   
	else:
	   TRUltimaPuertad1 = 2
	   TRAbrePuertad1 ((92896,-10441,13029),TRd1ad)

def TREnciendeLlamaBI ():
	global TRUltimaPuertad1
	global TRd1bi
	if TRUltimaPuertad1 <> 2:
	   TRResetSectors()	   
	else:
	   TRUltimaPuertad1 = 3
	   TRAbrePuertad1 ((92690,-9034,16034),TRd1bi)

def TREnciendeLlamaBD ():
	global TRUltimaPuertad1
	global TRd1bd
	if TRUltimaPuertad1 <> 3:
	   TRResetSectors()	   
	else:
	   TRApagaAntorchaEnMano()
	   TRUltimaPuertad1 = 4
	   TRAbrePuertad1 ((92690,-9034,13460), TRd1bd)
	   s=Bladex.GetSector(88783.2088372, -9070.71948691, 14618.3124125)
	   s.OnEnter=AbrirPuertad2


def Sesamo ():
	TREnciendeLlamaAI ()
	TREnciendeLlamaAD ()
	TREnciendeLlamaBI ()
	TREnciendeLlamaBD ()

def TRApagaAntorcha (torch_name):
	torch=Bladex.GetEntity(torch_name)
	#Torchs.ExtingueAntorcha(o.Name)
	torchspot=AuxFuncs.GetSpot(torch)
	torchspot.Intensity = 0
	torchfire=AuxFuncs.GetFire(torch)
	torchfire.Intensity=30
	torchobj=torch.Data.torchobjdata
	torchobj.LiveStatus=Torchs.ALIVE
	torchobj.LightStatus=Torchs.OFF
	
def TRMiraPuerta ():
	AbreCam.ResetNode()
	AbreCam.AddNode ( (70513,-9780,15254),(80455,-10657,14633), 5)
	AbreCam.AbreCam()

def TREnciendeAntorcha(torch_name, use_from):
	
	pj=Bladex.GetEntity("Player1")
	objright=Bladex.GetEntity(pj.InvRight)
	if not objright or (objright.Kind not in Torchs.tipos_antorcha): return
	if objright.Data.torchobjdata.LightStatus==Torchs.OFF:  return
	torch=Bladex.GetEntity(torch_name)
	if torch.Data.torchobjdata.LightStatus==Torchs.ON:  return
	Torchs.TorchUseFunc(torch_name, use_from)
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.5, TRMiraPuerta, ())	
	if    torch_name == 'E3_BI':
		Bladex.AddScheduledFunc(Bladex.GetTime()+2.0, TREnciendeLlamaBI, ())
	elif  torch_name == 'S2_AD':
		Bladex.AddScheduledFunc(Bladex.GetTime()+2.0, TREnciendeLlamaAD, ())
	elif  torch_name == 'N1_AI':
		Bladex.AddScheduledFunc(Bladex.GetTime()+2.0, TREnciendeLlamaAI, ())
	elif  torch_name == 'O4_BD':
		Bladex.AddScheduledFunc(Bladex.GetTime()+2.0, TREnciendeLlamaBD, ())



TRPuertad1Abierta= 0

def AbrirPuertad2 (Sector,Entity_Name):	
	global TRPuertad1Abierta
	if Entity_Name != 'Player1':
		return
	if TRPuertad1Abierta == 0:
	   TRPuertad1Abierta = 1
  	   Bladex.KillMusic()
    	   Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("EntradaTrampas"),))
	   Bladex.AddScheduledFunc(Bladex.GetTime()+4.0,TRRompePuertad2,())


## Puerta interior

def TRRompePuertad2 ():
	global TRd2
	Sonido_Derribo_Muro.Play(93174, -8418, 13009)
	TRd2.DoBreak((300, 0,0), (0,0,0), (0, 0, 0))
	Bladex.AddScheduledFunc(Bladex.GetTime()+2.0,TREnciendeLamparas,())
	
## Lmparas zona inicial

def TREnciendeLampara (lampName):
	lamp=Bladex.GetEntity(lampName)
	lamp.FiresIntensity=[ 3.0 ]
	lamp.Lights = [(10.0, 0.03125, (255, 196, 128))]
	AuxFuncs.GetSpot(Bladex.GetEntity(lampName)).CastShadows=0

def TREnciendeLamparasS1():
	Sonido_Enciende_Lampara.Play(103355,-9251,14190)
	TREnciendeLampara ('LampS1_1')
	TREnciendeLampara ('LampS1_2')
	
def TREnciendeLamparasS2():
	Sonido_Enciende_Lampara.Play(114250,-8969,14660)
	TREnciendeLampara ('LampS2_1')
	TREnciendeLampara ('LampS2_2')
	
def TREnciendeLamparasS3():
	Sonido_Enciende_Lampara.Play(124592,-8565,14849)
	TREnciendeLampara ('LampS3_1')
	TREnciendeLampara ('LampS3_2')

def TREnciendeLamparasS4():
	Sonido_Enciende_Lampara.Play(134592,-7665,14849)
	TREnciendeLampara ('LampS4_1')
	TREnciendeLampara ('LampS4_2')

def TREnciendeLamparas ():
	Sonido_Trampa_Bajando1.Play(96995,-10485,14601)
	Sonido_Trampa_Bajando2.Play(96995,-10485,14601)
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, TREnciendeLamparasS1, ())
	Bladex.AddScheduledFunc(Bladex.GetTime()+2.5, TREnciendeLamparasS2, ())
	Bladex.AddScheduledFunc(Bladex.GetTime()+4.0, TREnciendeLamparasS3, ())
	Bladex.AddScheduledFunc(Bladex.GetTime()+5.5, TREnciendeLamparasS4, ())
	
##
## Sala de la Reina
##-------------------------------------------------------------

def ChangeRasterMode(ent_name, mode):
	Bladex.GetEntity(ent_name).RasterMode=mode



def TRDesaparecenEstatuasCaballeros ():
	Bladex.AddScheduledFunc(Bladex.GetTime(), ObjectMagicallyDisappearing, ("Reyaurelio_I", 5, AuxFuncs.DESTROY_METHOD_BIN))
	Bladex.AddScheduledFunc(Bladex.GetTime(), ObjectMagicallyDisappearing, ("Reyaurelio_D", 5, AuxFuncs.DESTROY_METHOD_BIN))
	Bladex.AddScheduledFunc(Bladex.GetTime()+3.5, TRAparecenCaballeros, ())

def TRActivaCaballeros ():
	persI=Bladex.GetEntity("Knight_I")
	persD=Bladex.GetEntity("Knight_D")
	SetLevelAndLife ("Knight_I", 6)
	darfuncs.UnhideBadGuy ("Knight_I")
	persI.Data.ResetSounds("Knight_I")
	SetLevelAndLife ("Knight_D", 6)
	darfuncs.UnhideBadGuy ("Knight_D")
	persD.Data.ResetSounds("Knight_D")
	persI.Freeze()
	persD.Freeze()

def TRAparecenCaballeros ():
	persI=Bladex.GetEntity("Knight_I")
	persD=Bladex.GetEntity("Knight_D")
	time=Bladex.GetTime()
	Bladex.AddScheduledFunc(time+0.2, TRActivaCaballeros, ())
	Bladex.AddScheduledFunc(time+0.5, TRLuzAzul, ())
	Bladex.AddScheduledFunc(time, PersonMagicallyAppearing, ("Knight_I", 3))
	Bladex.AddScheduledFunc(time, PersonMagicallyAppearing, ("Knight_D", 3))
	Bladex.AddScheduledFunc(time+3.0, persI.UnFreeze, ())
	Bladex.AddScheduledFunc(time+3.0, persD.UnFreeze, ())

TRInicioLuzAzul = 0
def TRLuzAzul ():
	global TRInicioLuzAzul
	TRInicioLuzAzul=Bladex.GetTime()
	luz=Bladex.GetEntity("LampS1_1")
	luz.TimerFunc=TRLuzAzulTimer
	luz.SubscribeToList("Timer15")
	luz=Bladex.GetEntity("LampS1_2")
	luz.TimerFunc=TRLuzAzulTimer
	luz.SubscribeToList("Timer15")
	luz=Bladex.GetEntity("LampS2_1")
	luz.TimerFunc=TRLuzAzulTimer
	luz.SubscribeToList("Timer15")
	luz=Bladex.GetEntity("LampS2_2")
	luz.TimerFunc=TRLuzAzulTimer
	luz.SubscribeToList("Timer15")
	

def TRLuzAzulTimer (light, time):
	global TRInicioLuzAzul
	time=Bladex.GetTime()
	time=time-TRInicioLuzAzul
	luz = Bladex.GetEntity(light)
	factor=time/5
	if   (factor<1.00) :
		luz.FiresIntensity=[ factor*9.0 +3.0] # 3->12
#		luz.Lights = [(10.0 - factor*8.0 , 0.03125, (255 - 125*factor, 196-70*factor, 128+factor*112))] # 10.0 -> 2.0
#									 # (255, 196, 128) -> (130, 126, 240)
		luz.Lights = [(10.0 , 0.03125, (255 - 125*factor, 196-70*factor, 128+factor*112))] # 10.0
									 # (255, 196, 128) -> (130, 126, 240)
	else:
		luz.RemoveFromList("Timer15")
		luz.TimerFunc=""

	
	
	
def TRLuzNormal ():
	o=Bladex.GetEntity("LampS1_1")
	o.FiresIntensity=[ 3.0 ]
	o.Lights = [(10.0, 0.03125, (255, 196, 128))]
	o=Bladex.GetEntity("LampS1_2")
	o.FiresIntensity=[ 3.0 ]
	o.Lights = [(10.0, 0.03125, (255, 196, 128))]
	o=Bladex.GetEntity("LampS2_1")
	o.FiresIntensity=[ 3.0 ]
	o.Lights = [(10.0, 0.03125, (255, 196, 128))]
	o=Bladex.GetEntity("LampS2_2")
	o.FiresIntensity=[ 3.0 ]
	o.Lights = [(10.0, 0.03125, (255, 196, 128))]

TR_N_Kgt = 2
def TRKgtKilled (entity):
	global TR_N_Kgt
	
	Bladex.GetEntity(entity).Data.DefImDeadFunc(entity)
	if TR_N_Kgt == 1:
		TRLuzNormal()
	else:
		TR_N_Kgt = TR_N_Kgt - 1


TRInicioFlare=0
def TRMFTimer(light,time):
	global TRInicioFlare
	time=Bladex.GetTime()
	time=time-TRInicioFlare
	luz = Bladex.GetEntity(light)
	factor=time/5
	if   (factor<1.00) :
		luz.Intensity = factor * 3.0
		luz.SizeFactor= factor * 10.0
	elif (factor<2.00) :
		factor=(2.0 - factor)
		luz.Intensity = factor * 3.0
		luz.SizeFactor= factor * 10.0
	else:
		luz.RemoveFromList("Timer15")
		luz.TimerFunc=""
		luz.SubscribeToList ('Pin')
		o=Bladex.GetEntity("ReinaAurelio_634")
		o.SelfIlum=0

def TRCreaMagicFlare ():
	global TRInicioFlare
	o=Bladex.GetEntity("ReinaAurelio_634")
	o.SelfIlum=0.4
	luz=Bladex.CreateEntity("OhReina","Entity Spot",108622, -10973,7583)
	luz.Color=130.0, 126.0, 240.0
	luz.Intensity=0
	luz.Precission=1
	luz.CastShadows=0	
	luz.GlowTexture="MagicFlare128"	
	luz.GlowTestZ=1
	luz.AngVel=0.5
	luz.SizeFactor=0
	TRInicioFlare=Bladex.GetTime()
	luz.TimerFunc=TRMFTimer
	luz.SubscribeToList("Timer15")

	
def TRLeeLibroReina (ent, usedfrom):
	GameText.WriteTextAux(Tr("El Gworan Rojo abrir las puertas\ny los guardianes despertarn\npara dar de nuevo la vida\n por su amada Reina"),8.0,252,247,167,[],100)	
	Sonido_Aparecen_Caballeros.Play(104896,-11565,17409)
	AbreCam.ResetNode()
	AbreCam.AddNode ((104896,-11565,17409),(110538,-7466,24576), 6)
	AbreCam.AddNode ((106524,-11521,21461),(108337,-11527,11626), 5)
	AbreCam.AddNode ((108577,-11544,12235),(109090,-8312,2785), 7)
	AbreCam.AbreCam()	
	Bladex.AddScheduledFunc(Bladex.GetTime()+7, TRCreaMagicFlare, ())
	Bladex.AddScheduledFunc(Bladex.GetTime()+10, TRDesaparecenEstatuasCaballeros, ())
	o=Bladex.GetEntity("LibroReina")
	o.UseFunc=TRLeeLibroReina2
	
def TRLeeLibroReina2 (ent, usedfrom):
	GameText.WriteTextAux(Tr("El Gworan Rojo abrir las puertas\ny los guardianes despertarn\npara dar de nuevo la vida\n por su amada Reina"),8.0,252,247,167,[],100)	

## Sala Esqueletos
##-------------------------------------------------------------

def TRActivaSkl (Sector,Entity_Name):
	global TRSkl0
	if Entity_Name != 'Player1':
		return
	Bladex.ExeMusicEvent(Bladex.GetMusicEvent("Esqueletos"))
	Bladex.AddScheduledFunc(Bladex.GetTime()+13.0, TRAparecenSkl, ())
	TRSkl0.OnEnter=""


def TRAparecenSkl ():
	global TRSkl1
	global TRSkl2
	TRSkl1.DoBreak((0, 0,-500), (0,0,0), (0, 0, 0))
	TRSkl2.DoBreak((0, 0, 500), (0,0,0), (0, 0, 0))
	SetLevelAndLife ("Skeleton_610", 7)
	darfuncs.UnhideBadGuy("Skeleton_610")
	s1=Bladex.GetEntity("Skeleton_610")
	s1.SetActiveEnemy ("Player1")
	SetLevelAndLife ("Skeleton_613", 7)
	darfuncs.UnhideBadGuy("Skeleton_613")
	s1=Bladex.GetEntity("Skeleton_613")
	s1.SetActiveEnemy ("Player1")

TR_N_Skl = 2
def TRSklKilled (entity):
	global TR_N_Skl
	
	Bladex.GetEntity(entity).Data.DefImDeadFunc(entity)
	if TR_N_Skl == 1:
		AbrirPuertaPuente()
	else:
		TR_N_Skl = TR_N_Skl - 1


def AbrirPuertaPuente ():
	global TRdp
	TRdp.OpenDoor()
	

## Puente 	
##-------------------------------------------------------------

def TRRompePuente1Y4a (Sector,Entity_Name):
	global TRp1, TRp4a
	if TRp4a.Active == 0:
	    Sonido_Derribo_Muro.Play(150500, -5850, 15250)
	    TRp4a.DoBreak((0,-100,0), (0,0,0), (0, 0, 0))
	if TRp1.Active == 0:
	    Sonido_Derribo_Muro.Play(140940, -7354, 14977)
	    Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, TRRompePuente2, (None,None,))
	    TRp1.DoBreak((0,-100,0), (0,0,0), (0, 0, 0))

def TRRompePuente2 (Sector,Entity_Name):
	global TRp2
	if TRp2.Active == 0:
	   Sonido_Derribo_Muro.Play(145517, -7162, 14883)
	   Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, TRRompePuente3, (None,None,))
	   TRp2.DoBreak((0,-100,0), (0,0,0), (0, 0, 0))

def TRRompePuente3 (Sector,Entity_Name):
	global TRp3
	if TRp3.Active == 0:
	   Sonido_Derribo_Muro.Play(148032, -7046, 14818)
	   Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, TRRompePuente4, (None,None,))
	   TRp3.DoBreak((0,-100,0), (0,0,0), (0, 0, 0))

def TRRompePuente4 (Sector,Entity_Name):
	global TRp4b
	if TRp4b.Active == 0:
	   Sonido_Derribo_Muro.Play(153000, -5924, 14500)
	   Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, TRRompePuente5, (None,None,))
	   TRp4b.DoBreak((0,-100,0), (0,0,0), (0, 0, 0))

def TRRompePuente5 (Sector,Entity_Name):
	global TRp5
	if TRp5.Active == 0:
	   Sonido_Derribo_Muro.Play(152464, -6843, 14704)
	   TRp5.DoBreak((0,-100,0), (0,0,0), (0, 0, 0))


def CruzaRapido (Sector,Entity_Name):	
	global TRps1
	Sonido_Quake.Play(140940, -7354, 14977)
	darfuncs.Temblores(0.75, 200)	
	TRps1.OnEnter=None

## Flechas
##-------------------------------------------------------------

Flecha = {}

def TRInicializaFlechas():
	global Flecha
	Flecha ['Flecha_Trampa_D1'] = {'Desplazamiento':(0,0, 90000), 'Tiempo': 0,     'Polvo': (0, +70,  1000)}
	Flecha ['Flecha_Trampa_I1'] = {'Desplazamiento':(0,0,-90000), 'Tiempo': 0.75,  'Polvo': (0, +70, -1000)}
	Flecha ['Flecha_Trampa_D2'] = {'Desplazamiento':(0,0, 90000), 'Tiempo': 1.5,   'Polvo': (0, +70,  1000)}
	Flecha ['Flecha_Trampa_I2'] = {'Desplazamiento':(0,0,-90000), 'Tiempo': 2.25,  'Polvo': (0, +70,  1000)}
	for flecha in Flecha.keys():
	    Arrows.InitArrow(flecha,Flecha[flecha]['Desplazamiento'],(0,0,0))

def LanzarFlechaConPolvo(Arrow_P,Tiempo):
	global Flecha		
	Arrow = Bladex.GetEntity(Arrow_P.Lanzar)

	if (Arrow_P.Estado == 1):		
		PolvoPositionIncr= Flecha[Arrow.Name]['Polvo']
		polvoposition=Arrow.Position[0]+PolvoPositionIncr[0], Arrow.Position[1]+PolvoPositionIncr[1], Arrow.Position[2]+PolvoPositionIncr[2]
		Arrow.MessageEvent(Arrows.MESSAGE_START_WEAPON,0,0)
		Arrow.Fly(Arrow_P.Vel[0],Arrow_P.Vel[1],Arrow_P.Vel[2])
		#Arrow_P.Ultimo_Lanzamiento = Bladex.GetTime()
		Arrow_P.Sound.Play(Arrow.Position[0],Arrow.Position[1],Arrow.Position[2],0)

		Bladex.AddScheduledFunc(Bladex.GetTime()+2.0/60.0, Arrows.PasoPolvo, (polvoposition, 0, 0),"PasoPolvo")
		Bladex.AddScheduledFunc(Bladex.GetTime() + Arrow_P.Tiempo_Parada,Arrows.PararFlecha,(Arrow_P,0))
		Bladex.AddScheduledFunc(Bladex.GetTime() + Arrow_P.Tiempo_Lanzamiento,Arrows.LanzarFlecha,(Arrow_P,0))

#Arrows.LanzarFlecha = LanzarFlechaConPolvo

def ActivarTrampaFlechas(sector,Entity_Name):
	global Flecha
	if Entity_Name != 'Player1':
		return
	pj = Bladex.GetEntity("Player1")
	Sonido_Flechas_Activadas.Play(pj.Position[0],pj.Position[1],pj.Position[2],0)
	Tiempo = Bladex.GetTime()			
	for flecha in Flecha.keys():
		Bladex.AddScheduledFunc(Tiempo,Arrows.ActivateArrow,(flecha,Flecha[flecha]['Tiempo'],1.3))

def DesactivarTrampaFlechas(sector,Entity_Name):	
	global Flecha
	if Entity_Name != 'Player1':
		return
	for flecha in Flecha.keys():
		Arrows.DeactivateArrow(flecha)
	char = Bladex.GetEntity("Player1")
	Sonido_Flechas_Desactivadas.Play(char.Position[2],char.Position[2],char.Position[2],0)


## Cuchillas
##-------------------------------------------------------------

## Tiempos en los que se cubre el desplazamiento
## Para un desplazamiento de 700 poner aproximadamente un segundo.
## No poner menos de 1 segundo.

BITime=1.3
BCTime=1.3
BDTime=1.3

## Desplazamiento vertical en el arranque y en la parada 
## de la cuchilla central (siempre positivo)

IncrZ = 1000

## Desplazamiento horizontal en el arranque y en la parada 
## de las cuchillas laterales (siempre positivo)

IncrX = 2100

## Desplazamiento horizontal de las cuchillas (siempre positivo)

IncrY = 6950

## Posicion de la chispa respecto a la cuchilla

IncrChispaX = 1940
IncrChispaY = 2000
IncrChispaZ = 1600

## Posiciones iniciales de las cuchillas (donde se crean)

BIInitPos=(185932.2461690,-5556.67984746,-5589.02870281)
BCInitPos=(180178.511873,-2210.91526921,-4997.78674407)
BDInitPos=(174577.377018,-5556.67984746,-4589.02870281)

## Tiempo de espera hasta que se lanza de nuevo la cuchilla.
## Hay que descontar el tiempo que tarda en hacer el recorrido (BnTime).

WAIT_TIME = 1.0

stop_blades = 0
blades_ready = 1
playerstate = 0

Bladex.CreateTimer("Timer60",1.0/60.0)

CounterXCU = 0
CounterXCU1 = 0
CounterXCU2 = 0


def CreateChispaIf(name,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u):
	chispa = Bladex.GetEntity(name)	
	if chispa == None:
		chispa=Bladex.CreateSpark(name, a,b,c,d,e,f,g,h,i,j,k,l,m, n, o, p, q,r,s,t,u)
	return chispa

def BladeCTimerFunc(blade_name,time):
	global bc_time
	global WAIT_TIME
	global CounterXCU
	global IncrX, IncrY, IncrZ
	global IncrChispaX, IncrChispaY, IncrChispaZ
	global BCInitPos
	global BCTime
	
	itime=time-bc_time
	itime=itime/BCTime
	blade = Bladex.GetEntity(blade_name)	
	chispa = CreateChispaIf("Chispas0", BCInitPos[0], BCInitPos[1], BCInitPos[2],0,  0, 0.5,  1,3000,2000,0,150, 200, 100, 0, 32, 32, 32,800,0.1,100,0)
	if(itime <= 0.25):
		if itime>0.0:
			blade.SetPosition(BCInitPos[0], BCInitPos[1] - IncrZ * 4*itime,BCInitPos[2]+ IncrY * itime,0)
			if CounterXCU == 0:
				Sonido_Cuchilla_Inicio.PlaySound(0)
				Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5,Sonido_Cuchilla_Bucle.PlaySound,(12,))
				CounterXCU = 1
	elif (itime < 0.75):
		blade.SetPosition(BCInitPos[0],BCInitPos[1]-IncrZ,BCInitPos[2] + IncrY * itime,0)
	elif (itime < 1):
		blade.SetPosition(BCInitPos[0],BCInitPos[1]-IncrZ * 4*(1 - itime),BCInitPos[2] + IncrY * itime,0)
	else:
		bc_time = time+WAIT_TIME		
		blade.SetPosition(BCInitPos[0],BCInitPos[1]+IncrZ,BCInitPos[2],0)
		blade.MessageEvent(MESSAGE_START_WEAPON,0,0)
		if CounterXCU == 1:
			Sonido_Cuchilla_Fin.PlaySound(0)
			Sonido_Cuchilla_Bucle.StopSound()
		CounterXCU = 0
		if (stop_blades):
			if(playerstate == 0):
				blade.Position=BCInitPos
				StopBlade(blade,chispa)
	if itime < 0.0:
		chispa.Position = 0,0,0
	else:
		chispa.Position = BCInitPos[0], BCInitPos[1] -IncrChispaZ, blade.Position[2] + IncrChispaY
		Sonido_Cuchilla_Inicio.Position = chispa.Position
		Sonido_Cuchilla_Bucle.Position  = chispa.Position
		Sonido_Cuchilla_Fin.Position    = chispa.Position
	
	blade.Rotate(0.0,1.0,0.0,0.3,1)


def BladeITimerFunc(blade_name,time):
	global bi_time
	global WAIT_TIME
	global CounterXCU1
	global IncrX, IncrY, IncrZ
	global IncrChispaX, IncrChispaY, IncrChispaZ
	global BIInitPos
	global BITime
	
	itime=time-bi_time
	itime=itime/BITime
	blade=Bladex.GetEntity(blade_name)
	chispa=CreateChispaIf("Chispas1", BIInitPos[0], BIInitPos[1], BIInitPos[2],-0.7,0, 0.7,0.5,3000,2000,0,150, 200, 100, 0, 32, 32, 32,800,0.1,100,0)	
	if(itime <= 0.25):
		if itime>0.0:
			blade.SetPosition(BIInitPos[0] - IncrX * 4*itime, BIInitPos[1],BIInitPos[2] + IncrY * itime,0)
			if CounterXCU1 == 0:
				Sonido_Cuchilla_Inicio1.PlaySound(0)
				Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5,Sonido_Cuchilla_Bucle1.PlaySound,(12,))
				CounterXCU1 = 1
	elif (itime < 0.75):
		blade.SetPosition(BIInitPos[0]-IncrX ,BIInitPos[1],BIInitPos[2] + IncrY * itime,0)
	elif (itime < 1):
		blade.SetPosition(BIInitPos[0]-IncrX * 4*(1 - itime),BIInitPos[1],BIInitPos[2] + IncrY * itime,0)
	else:
		bi_time = time+WAIT_TIME
		blade.SetPosition(BIInitPos[0]+IncrX,BIInitPos[1],BIInitPos[2],0)
		blade.MessageEvent(MESSAGE_START_WEAPON,0,0)
		if CounterXCU1 == 1:
			Sonido_Cuchilla_Fin1.PlaySound(0)
			Sonido_Cuchilla_Bucle1.StopSound()
		CounterXCU1 = 0		
		if (stop_blades):
			if(playerstate == 0):
				blade.Position=BIInitPos
				StopBlade(blade,chispa)

	if itime < 0.0:
		chispa.Position = 0,0,0
	else:
		chispa.Position = BIInitPos[0] - IncrChispaX, BIInitPos[1], blade.Position[2] + IncrChispaY
		Sonido_Cuchilla_Inicio1.Position = chispa.Position
		Sonido_Cuchilla_Bucle1.Position  = chispa.Position
		Sonido_Cuchilla_Fin1.Position    = chispa.Position

	blade.Rotate(0.0,1.0,0.0,-0.3,1)

def BladeDTimerFunc(blade_name,time):
	global bd_time
	global WAIT_TIME
	global CounterXCU2
	global IncrX, IncrY, IncrZ
	global IncrChispaX, IncrChispaY, IncrChispaZ
	global BDInitPos
	global BDTime

	itime=time-bd_time
	itime=itime/BDTime		
	blade=Bladex.GetEntity(blade_name)	
	chispa=CreateChispaIf("Chispas2", BDInitPos[0], BDInitPos[1], BDInitPos[2], 0.7,0, 0.7,0.7,3000,2000,0,150, 200, 100, 0, 32, 32, 32,800,0.1,100,0)

	if(itime <= 0.25):
		if itime>0.0:
			blade.SetPosition(BDInitPos[0]+ IncrX * 4*itime,BDInitPos[1],BDInitPos[2] + IncrY * itime,0)
			if CounterXCU2 == 0:
				Sonido_Cuchilla_Inicio2.PlaySound(0)
				Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5,Sonido_Cuchilla_Bucle2.PlaySound,(12,))
				CounterXCU2 = 1				
	elif (itime < 0.75):
		blade.SetPosition(BDInitPos[0]+ IncrX,BDInitPos[1],BDInitPos[2] + IncrY * itime,0)
	elif (itime < 1):
		blade.SetPosition(BDInitPos[0]+IncrX * 4*(1 - itime),BDInitPos[1],BDInitPos[2] + IncrY * itime,0)
	else:
		bd_time = time+WAIT_TIME		
		blade.SetPosition(BDInitPos[0]-IncrX,BDInitPos[1],BDInitPos[2],0)
		blade.MessageEvent(MESSAGE_START_WEAPON,0,0)		
		if CounterXCU2 == 1:
			Sonido_Cuchilla_Fin2.PlaySound(0)
			Sonido_Cuchilla_Bucle2.StopSound()
		CounterXCU2 = 0
		if (stop_blades):
			if(playerstate == 0):
				blade.Position=BDInitPos
				StopBlade(blade,chispa)

	if itime < 0.0:
		chispa.Position = 0,0,0
	else:
		chispa.Position = BDInitPos[0] + IncrChispaX, BDInitPos[1], blade.Position[2] + IncrChispaY
		Sonido_Cuchilla_Inicio2.Position = chispa.Position
		Sonido_Cuchilla_Bucle2.Position  = chispa.Position
		Sonido_Cuchilla_Fin2.Position    = chispa.Position

	blade.Rotate(0.0,1.0,0.0,0.3,1)


bc_time=0.0

def LaunchBladeC():
	global bc_time	
	global BCInitPos
	bc_time=Bladex.GetTime()
	blade=Bladex.GetEntity("BladeC")

	chispas0=CreateChispaIf("Chispas0", BCInitPos[0], BCInitPos[1], BCInitPos[2],0,  0, 0.5,  1,3000,2000,0,150, 200, 100, 0, 32, 32, 32,800,0.1,100,0)
	
	blade.Solid=0
	blade.MessageEvent(MESSAGE_START_WEAPON,0,0)
	blade.TimerFunc=BladeCTimerFunc
	blade.SubscribeToList("Timer60")
	
bi_time=0.0

def LaunchBladeI():
	global bi_time
	global BIInitPos
	bi_time=Bladex.GetTime()
	blade=Bladex.GetEntity("BladeI")	

	chispas1=CreateChispaIf("Chispas1", BIInitPos[0], BIInitPos[1], BIInitPos[2],-0.7,0, 0.7,0.5,3000,2000,0,150, 200, 100, 0, 32, 32, 32,800,0.1,100,0)

	blade.Solid=0
	blade.MessageEvent(MESSAGE_START_WEAPON,0,0)
	blade.TimerFunc=BladeITimerFunc
	blade.SubscribeToList("Timer60")

bd_time=0.0

def LaunchBladeD():
	global bd_time
	global BDInitPos
	bd_time=Bladex.GetTime()
	blade=Bladex.GetEntity("BladeD")	

	chispas2=CreateChispaIf("Chispas2", BDInitPos[0], BDInitPos[1], BDInitPos[2], 0.7,0, 0.7,0.7,3000,2000,0,150, 200, 100, 0, 32, 32, 32,800,0.1,100,0)

	blade.Solid=0	
	blade.MessageEvent(MESSAGE_START_WEAPON,0,0)	
	blade.TimerFunc=BladeDTimerFunc
	blade.SubscribeToList("Timer60")	

def LaunchBlades():
	global blades_ready	
	global WAIT_TIME
	LaunchBladeD()
	LaunchBladeI()
#	LaunchBladeC()	
	Bladex.AddScheduledFunc(Bladex.GetTime() + WAIT_TIME,LaunchBladeC,())
	blades_ready=0
	

def ActivateBlades(SectorIndex,EntityName):
	global playerstate
	global stop_blades
	if (EntityName == "Player1"):
		if (playerstate == 0):
			playerstate = 1
			stop_blades = 0

			if(blades_ready):
				#print ("Activada")
				pj=Bladex.GetEntity('Player1')
				Sonido_Trampa_Activada.Play(pj.Position[0],pj.Position[1],pj.Position[2],0)
				LaunchBlades()
		global BolonActivado
		if BolonActivado == 1:
			BolonActivado = 0
			Bladex.RemoveScheduledFunc("AhiVieneEso")

def DeactivateBlades(SectorIndex,EntityName):
	global playerstate
	global stop_blades
	if (EntityName == "Player1"):
		if (playerstate == 1):
			playerstate = 0
			stop_blades = 0			
			Bladex.AddScheduledFunc(Bladex.GetTime() + 6.0,StopBlades,())

def StopBlades():
	global stop_blades
	stop_blades = 1
	
def StopBlade(blade,chispa):
	global blades_ready
	blade.TimerFunc=None
	blade.RemoveFromList("Timer60")
	chispa.SubscribeToList("Pin")
	blades_ready = 1

## Bolon
##-------------------------------------------------------------

BolonActivado=0
def ActivateBolon (SectorIndex,Entity_Name):
	global TRBL, BolonActivado
	if Entity_Name != 'Player1': return
	if BolonActivado == 0:
	   BolonActivado = 1
	   Bladex.AddScheduledFunc(Bladex.GetTime() + 5.0, AhiVieneEso, (), "AhiVieneEso")	


def AhiVieneEso ():
	global TRdb
	Bladex.ExeMusicEvent(Bladex.GetMusicEvent("PonerGema"))

	AbreCam.ResetNode()
	AbreCam.AddNode ( (175710,-5917,-13480),(185287,-4564,-10940), 3)
	Bladex.AddScheduledFunc(Bladex.GetTime() + 3.0, TRdb.CloseDoor, ())	
	AbreCam.AddNode ( (186233,-6305,-12695),(195841,-9076,-12801), 3)
	AbreCam.AddNode ( (170251,-4500,-12940),(180000,-2285,-12500), 5)	
	AbreCam.LastTime=0
	AbreCam.AbreCam()
	Bladex.AddScheduledFunc(Bladex.GetTime() + 5.0, Sonido_Quake.Play, (179921,-5398,-12112))	
	Bladex.AddScheduledFunc(Bladex.GetTime() + 6.0, Sonido_Quake.Play, (179921,-5398,-12112))	
	Bladex.AddScheduledFunc(Bladex.GetTime() + 6.5, darfuncs.Temblores, (1.5, 100))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 7.0, Sonido_Quake.Play, (179921,-5398,-12112))	
	Bladex.AddScheduledFunc(Bladex.GetTime() + 8.8, stone.drop, ( "Bolon1", -20000000,0,0 ))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 10.0, Sonido_Quake.Play, (179921,-5398,-12112))	
	Bladex.AddScheduledFunc(Bladex.GetTime() + 10.0, darfuncs.Temblores, (0.7, 100))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 14.0, Sonido_Quake.Play, (179921,-5398,-12112))	
	Bladex.AddScheduledFunc(Bladex.GetTime() + 14.0, darfuncs.Temblores, (0.7, 100))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 18.0, Sonido_Quake.Play, (179921,-5398,-12112))	
	Bladex.AddScheduledFunc(Bladex.GetTime() + 18.0, darfuncs.Temblores, (0.7, 100))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 8.8+12.0, Sonido_Derribo_Muro.Play, (152493,2566,-12087))

## Rampa
##-------------------------------------------------------------

def EstoyRefugiado (SectorIndex,Entity_Name):
	global TRRefugio
	if Entity_Name != 'Player1': return
	Bladex.AddScheduledFunc(Bladex.GetTime() + 7.0, ActivaRampa, ())	
	TRRefugio.OnEnter=None
	
def ActivaRampa ():
	global TREncimaRampa
	TREncimaRampa.OnEnter=AbreRampa
	
def AbreRampa (Sector,Entity_Name):
	global TRRampa, TRRampaFinal, TREncimaRampa
	if (Entity_Name!="Player1") : return
	Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5, Sonido_Derribo_Muro.Play, (156931, 1634, -12214))	
	Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5, TRRampa.DoBreak, ((0,-100,0), (0,0,0), (0, 0, 0)))	
	TRRampa.TooSteep=1
	TRRampaFinal.TooSteep=1
	TREncimaRampa.OnEnter=None


def CamaraAlAgua (Sector,Entity_Name):
	global TRRampaFinal
	TRRampaFinal.OnEnter=None
	AbreCam.ResetNode()
	AbreCam.AddNode ((156853,17267,-36751),(157604,12950,-27763), 3)
	AbreCam.AddNode ((157661,26669,-57164),(156131,24445,-47535), 2)	
	AbreCam.AddNode ((162997,24260,-67078),(157875,26985,-58934), 2)
	AbreCam.AddNode ((162360,24282,-66293),(158153,25117,-57260), 5)
	AbreCam.LastTime=0
	AbreCam.AbreCam()
	pj = Bladex.GetEntity('Player1')
	Bladex.AddScheduledFunc(Bladex.GetTime() + 0.0, pj.LaunchAnmType, ('wlk_no',))	
	Bladex.AddScheduledFunc(Bladex.GetTime() + 2.0, Sonido_Caida.Play, (156931, 1634, -12214,0))	
	
## Piscina
##-------------------------------------------------------------

def EntraPiscina (SectorIndex,Entity_Name):
	global TRPiscina
	if (Entity_Name!="Player1") : return
	try:
	   pj = Bladex.GetEntity('Player1')
	   Sonido_Caida_Agua.Play, (pj.Position[0],TRNivel_Agua+200,pj.Position[2],0)
	   SplashWater(pj.Position[0],TRNivel_Agua+200,pj.Position[2])
	   Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5, pj.GoTo, (156840.697363, 28931.706225, -57012.5121106))
	except:
	   pass
	Bladex.AddScheduledFunc(Bladex.GetTime() + 13.0, AguaVa, ())
	InicializaPlataformas()
	TRPiscina.OnEnter=None

def SplashWater(x,y,z):
	Aguita=Bladex.CreateEntity("Cristales", "Entity Particle System D1", x, y, z)
	Aguita.ParticleType="Splash"
	Aguita.PPS=2048
	Aguita.YGravity=1000.0
	Aguita.Friction=0
	Aguita.Velocity=0,-1500,0
	Aguita.RandomVelocity=20.0
	Aguita.Time2Live=64
	Aguita.DeathTime=Bladex.GetTime()+0.3

	Water.SndSplash.Position = x, y, z
	Water.SndSplash.PlaySound(0)
	
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.0, Water.RemueveAgua,(x,y,z,1000,1000))



	
def AguaVa ():
	Bladex.ExeMusicEvent(Bladex.GetMusicEvent("AguaPiscina"))
	AbreCam.ResetNode()
	AbreCam.AddNode ((161947,24585,-50516),(158880,26940,-59738), 3)
	AbreCam.AddNode ((161947,24585,-50516),(158880,26940,-59738), 5)
	AbreCam.AbreCam()	
	Bladex.AddScheduledFunc(Bladex.GetTime() + 4.0, AbreGrifos, ())

TRNivel_Agua = 29500

TRNivel_Agua_Maximo = 28250

def AbreGrifos ():	
	CreateCascadaMoria("Trampa_I",(162790, 27162, -57827),(1000.0, 0.0, 0.0),  (-8000.0, 0.0, 0.0),(160790, 29162, -57827),23)
	g=Bladex.GetEntity('Trampa_I')	
	g.ParticleType="AguaTR"
	CreateCascadaMoria("Trampa_D",(151600,27162,-57827),(1000.0, 0.0, 0.0),(8000.0, 0.0, 0.0),(154000, 29162, -57827),23)
	g=Bladex.GetEntity('Trampa_D')	
	g.ParticleType="AguaTR"
	Sonido_Agua_Grifos.Play (158575, 28929, -58398, -1)
	Bladex.AddScheduledFunc(Bladex.GetTime() + 7.5, BajaVolumenGrifos, ())
	agua=Bladex.GetEntity('trampa1')
	agua.TimerFunc=SubeAgua
	agua.SubscribeToList("Timer60")	
		
TRAhogate=0
def Ahogate  (SectorIndex,Entity_Name):
	global TRAhogate
	if (Entity_Name!="Player1") : return
	pj = Bladex.GetEntity('Player1')
	TRAhogate=1
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.0, Water.RemueveAgua,(pj.Position[0],TRNivel_Agua_Maximo-100,pj.Position[2],1000,1000))
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, Water.DropBubbles,(pj.Position[0],TRNivel_Agua_Maximo-100,pj.Position[2]))
	Bladex.AddScheduledFunc(Bladex.GetTime()+5.0, AhogateAhora,(pj,))
	cam  = Bladex.GetEntity("Camera")
	cam.SType = 0
	cam.TType = 0
	
def CancelaAhogate  (SectorIndex,Entity_Name):
	global TRAhogate
	ResetCamara()
	TRAhogate=0

def AhogateAhora(Entity_Name):
	global TRAhogate
	pj = Bladex.GetEntity('Player1')
	if TRAhogate:
	   pj.Life=0
	cam  = Bladex.GetEntity("Camera")
	cam.SType = 0
	cam.TType = 0
	

TRRegalos_en_la_Piscina = 0	
def SubeAgua(ent_name, time):
	global TRNivel_Agua, TRNivel_Agua_Maximo
	global TRPiscina, TRRegalos_en_la_Piscina
	agua=Bladex.GetEntity('trampa1')
	TRNivel_Agua=TRNivel_Agua-0.2
	agua.Position=156257,  TRNivel_Agua, -51459
	if TRNivel_Agua<=TRNivel_Agua_Maximo:
		agua.RemoveFromList("Timer60")
		agua.TimerFunc=""
		CierraGrifos ()
		Bladex.SetTriggerSectorFunc("Piscina", "OnEnter", Ahogate )
		Bladex.SetTriggerSectorFunc("Piscina", "OnLeave", CancelaAhogate )
	elif (not TRRegalos_en_la_Piscina and TRNivel_Agua <= TRNivel_Agua_Maximo +350):
		TRRegalos_en_la_Piscina = 1
		SetLevelAndLife ("Cos_665", 2, 3)
		darfuncs.UnhideBadGuy("Cos_665")
		SetLevelAndLife ("Cos_666", 2, 3)
		darfuncs.UnhideBadGuy("Cos_666")



def BajaVolumenGrifos ():	
	Sonido_Agua_Grifos.Volume=0.7
	Sonido_Agua_Grifos.MaxDistance=5000
	
def CierraGrifos ():	
	BorrarCascadaMoria ("Trampa_I")
	BorrarCascadaMoria ("Trampa_D")
	Sonido_Agua_Grifos.Stop()


## Plantaformas
##-------------------------------------------------------------

TRPlataforma_Actual=None
PlSolid=['Plataforma_1_1','Plataforma_2_1','Plataforma_3_2','Plataforma_2_2','Plataforma_2_3','Plataforma_3_4','Plataforma_4_3','Plataforma_5_3']
PlCaidas=[]
PlDinObj={}
dopl11=None
dopl12=None
dopl13=None
dopl14=None
dopl21=None
dopl22=None
dopl23=None
dopl31=None
dopl32=None
dopl33=None
dopl34=None
dopl41=None
dopl42=None
dopl43=None
dopl51=None
dopl52=None
dopl53=None
dopl54=None


def InicializaPlataformas():
	global PlDinObj
	global dopl11
	global PLDinObjInitialized
	dopl11 = Objects.CreateDinamicObject('Plataforma_1_1')
	PlDinObj['Plataforma_1_1']=dopl11
	global dopl12
	dopl12 = Objects.CreateDinamicObject('Plataforma_1_2')
	PlDinObj['Plataforma_1_2']=dopl12
	global dopl13
	dopl13 = Objects.CreateDinamicObject('Plataforma_1_3')
	PlDinObj['Plataforma_1_3']=dopl13
	global dopl14
	dopl14 = Objects.CreateDinamicObject('Plataforma_1_4')
	PlDinObj['Plataforma_1_4']=dopl14
	global dopl21
	dopl21 = Objects.CreateDinamicObject('Plataforma_2_1')
	PlDinObj['Plataforma_2_1']=dopl21
	global dopl22
	dopl22 = Objects.CreateDinamicObject('Plataforma_2_2')
	PlDinObj['Plataforma_2_2']=dopl22
	global dopl23
	dopl23 = Objects.CreateDinamicObject('Plataforma_2_3')
	PlDinObj['Plataforma_2_3']=dopl23
	global dopl31
	dopl31 = Objects.CreateDinamicObject('Plataforma_3_1')
	PlDinObj['Plataforma_3_1']=dopl31
	global dopl32
	dopl32 = Objects.CreateDinamicObject('Plataforma_3_2')
	PlDinObj['Plataforma_3_2']=dopl32
	global dopl33
	dopl33 = Objects.CreateDinamicObject('Plataforma_3_3')
	PlDinObj['Plataforma_3_3']=dopl33
	global dopl34
	dopl34 = Objects.CreateDinamicObject('Plataforma_3_4')
	PlDinObj['Plataforma_3_4']=dopl34
	global dopl41
	dopl41 = Objects.CreateDinamicObject('Plataforma_4_1')
	PlDinObj['Plataforma_4_1']=dopl41
	global dopl42
	dopl42 = Objects.CreateDinamicObject('Plataforma_4_2')
	PlDinObj['Plataforma_4_2']=dopl42
	global dopl43
	dopl43 = Objects.CreateDinamicObject('Plataforma_4_3')
	PlDinObj['Plataforma_4_3']=dopl43
	global dopl51
	dopl51 = Objects.CreateDinamicObject('Plataforma_5_1')
	PlDinObj['Plataforma_5_1']=dopl51
	global dopl52
	dopl52 = Objects.CreateDinamicObject('Plataforma_5_2')
	PlDinObj['Plataforma_5_2']=dopl52
	global dopl53
	dopl53 = Objects.CreateDinamicObject('Plataforma_5_3')
	PlDinObj['Plataforma_5_3']=dopl53
	global dopl54
	dopl54 = Objects.CreateDinamicObject('Plataforma_5_4')
	PlDinObj['Plataforma_5_4']=dopl54

def CheckInicializaPl ():
	try:
	   dummy=dopl11.obj.Data.dinobjdata
	except  AttributeError:
	   InicializaPlataformas()


def PisaPlataforma (SectorIndex,Entity_Name):
	if (Entity_Name!="Player1") : return
	CheckInicializaPl()
	global PlDinObj
	global TRPlataforma_Actual
	TRPlataforma_Actual=SectorIndex
	pj = Bladex.GetEntity('Player1')
	if pj.Wuea==Reference.WUEA_WAIT:
	   pj.AnmEndedFunc = CheckPlataforma
	else:
	   CheckPlataforma(Entity_Name)



def CheckPlataforma (Entity_Name):
	global TRPlataforma_Actual, PlDinObj
	pj = Bladex.GetEntity('Player1')
	if not TRPlataforma_Actual: return
	if TRPlataforma_Actual not in PlSolid and TRPlataforma_Actual not in PlCaidas:
	   CaePlataforma (PlDinObj[TRPlataforma_Actual])
	if   TRPlataforma_Actual[11]=='1':
	   DesactivaFila3 ()
	   DesactivaFila4 ()
	   DesactivaFila5 ()
	elif TRPlataforma_Actual[11]=='2':
	   ActivaFila3 ()
	   DesactivaFila4 ()
	   DesactivaFila5 ()
	elif TRPlataforma_Actual[11]=='3':
	   ActivaFila4 ()
	   DesactivaFila5 ()
	elif TRPlataforma_Actual[11]=='4':
	   ActivaFila5 ()



Fila3Active=0
Fila4Active=0
Fila5Active=0

def ActivaFila3 ():
	global Fila3Active
	if Fila3Active == 0:
	   Fila3Active=1
#	   Bladex.AddScheduledFunc(Bladex.GetTime()+0.3, ActivaPlataforma, (dopl31,))
#	   Bladex.AddScheduledFunc(Bladex.GetTime()+0.3, ActivaPlataforma, (dopl32,))
#	   Bladex.AddScheduledFunc(Bladex.GetTime()+0.3, ActivaPlataforma, (dopl33,))
#	   Bladex.AddScheduledFunc(Bladex.GetTime()+0.3, ActivaPlataforma, (dopl34,))
	   ActivaPlataforma (dopl31)
	   ActivaPlataforma (dopl32)
	   ActivaPlataforma (dopl33)
	   ActivaPlataforma (dopl34)

def ActivaFila4 ():
	global Fila4Active
	if Fila4Active == 0:
	   Fila4Active=1
#	   Bladex.AddScheduledFunc(Bladex.GetTime()+0.3, ActivaPlataforma, (dopl41,))
#	   Bladex.AddScheduledFunc(Bladex.GetTime()+0.3, ActivaPlataforma, (dopl42,))
#	   Bladex.AddScheduledFunc(Bladex.GetTime()+0.3, ActivaPlataforma, (dopl43,))
	   ActivaPlataforma (dopl41)
	   ActivaPlataforma (dopl42)
	   ActivaPlataforma (dopl43)

def ActivaFila5 ():
	global Fila5Active
	if Fila5Active == 0:
	   Fila5Active=1
#	   Bladex.AddScheduledFunc(Bladex.GetTime()+0.3, ActivaPlataforma, (dopl51,))
#	   Bladex.AddScheduledFunc(Bladex.GetTime()+0.3, ActivaPlataforma, (dopl52,))
#	   Bladex.AddScheduledFunc(Bladex.GetTime()+0.3, ActivaPlataforma, (dopl53,))
#	   Bladex.AddScheduledFunc(Bladex.GetTime()+0.3, ActivaPlataforma, (dopl54,))
	   ActivaPlataforma (dopl51)
	   ActivaPlataforma (dopl52)
	   ActivaPlataforma (dopl53)
	   ActivaPlataforma (dopl54)

def DesactivaFila3 ():
	global Fila3Active
	if Fila3Active == 1:
	  Fila3Active=0
	  DesactivaPlataforma (dopl31)
	  DesactivaPlataforma (dopl32)
	  DesactivaPlataforma (dopl33)
	  DesactivaPlataforma (dopl34)
	  Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, ResetFila3, ())

def DesactivaFila4 ():
	global Fila4Active
	if Fila4Active == 1:
	  Fila4Active=0
	  DesactivaPlataforma (dopl41)
	  DesactivaPlataforma (dopl42)
	  DesactivaPlataforma (dopl43)
	  Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, ResetFila4, ())
	
def DesactivaFila5 ():
	global Fila5Active
	if Fila5Active == 1:
	  Fila5Active=0
	  DesactivaPlataforma (dopl51)
	  DesactivaPlataforma (dopl52)
	  DesactivaPlataforma (dopl53)
	  DesactivaPlataforma (dopl54)
	  Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, ResetFila5, ())


AlturaBase=28930-300
IncrAltura=-1400#-300
def ResetFila3():
	global Fila3Active
	global AlturaBase, IncrAltura
	if Fila3Active == 0:
	  o=Bladex.GetEntity("Plataforma_3_1")
	  if o.Name not in PlCaidas:
	     o.Position=163000,AlturaBase+2*IncrAltura,-68684
	     o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)
	  o=Bladex.GetEntity("Plataforma_3_2")
	  if o.Name not in PlCaidas:
	     o.Position=	o.Position=159270,AlturaBase+2*IncrAltura,-68684
	     o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)
	  o=Bladex.GetEntity("Plataforma_3_3")
	  if o.Name not in PlCaidas:
	     o.Position=155540,AlturaBase+2*IncrAltura,-68684
	     o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)
	  o=Bladex.GetEntity("Plataforma_3_4")
	  if o.Name not in PlCaidas:
	     o.Position=151810,AlturaBase+2*IncrAltura,-68684
	     o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

def ResetFila4():
	global Fila4Active
	global AlturaBase, IncrAltura
	if Fila4Active == 0:
	  o=Bladex.GetEntity("Plataforma_4_1")
	  if o.Name not in PlCaidas:
	     o.Position=161075,AlturaBase+3*IncrAltura,-68684
	     o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)
	  o=Bladex.GetEntity("Plataforma_4_2")
	  if o.Name not in PlCaidas:
	     o.Position=157345,AlturaBase+3*IncrAltura,-68684
	     o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)
	  o=Bladex.GetEntity("Plataforma_4_3")
	  if o.Name not in PlCaidas:
	     o.Position=153615,AlturaBase+3*IncrAltura,-68684
	     o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)
	
def ResetFila5():
	global Fila5Active
	global AlturaBase, IncrAltura
	if Fila5Active == 0:
	  o=Bladex.GetEntity("Plataforma_5_1")
	  if o.Name not in PlCaidas:
	     o.Position=163000,AlturaBase+4*IncrAltura,-68684
	     o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)
	  o=Bladex.GetEntity("Plataforma_5_2")
	  if o.Name not in PlCaidas:
	     o.Position=	o.Position=159270,AlturaBase+4*IncrAltura,-68684
	     o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)
	  o=Bladex.GetEntity("Plataforma_5_3")
	  if o.Name not in PlCaidas:
	     o.Position=155540,AlturaBase+4*IncrAltura,-68684
	     o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)
	  o=Bladex.GetEntity("Plataforma_5_4")
	  if o.Name not in PlCaidas:
	     o.Position=151810,AlturaBase+4*IncrAltura,-68684
	     o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

def ActivaPlataforma (dinobj):
	global PLCaidas
	if dinobj.obj.Name not in PlCaidas:
	   Objects.DisplaceObject(dinobj, 1500, (0,0,1), 10000, 1, "",Sonido_Deslizamiento_Plataformas,Sonido_Final_Plataformas)

def DesactivaPlataforma (dinobj):
	global PLCaidas
	if dinobj.obj.Name not in PlCaidas:
	   Objects.DisplaceObject(dinobj, 1500, (0,0,-1), 10000, 1, "",Sonido_Deslizamiento_Plataformas,Sonido_Final_Plataformas)

PLMusica = 0
def CaePlataforma (dinobj):
	global PLMusica
	global PLCaidas
	PlCaidas.append (dinobj.obj.Name)
	if PLMusica == 0:
	   PLMusica = 1
	   Bladex.ExeMusicEvent(Bladex.GetMusicEvent("Ambiente5"))
	Objects.RotateObject(dinobj, 3.14159/2.0, 20, 1, (0, 500, 0), (-1, 0,0), Objects.REL, "", Sonido_Final_Plataformas)

def LevantaPlataforma (dinobj):
	Objects.RotateObject(dinobj, 3.14159/2.0, 20, 1, (0, 500, 0), (1, 0,0), Objects.REL, "", Sonido_Final_Plataformas)	
	
	
## Canal
##-------------------------------------------------------------


def EntraZonaCanal (SectorIndex,Entity_Name):
	if (Entity_Name!="Player1") : return
	global TRECanal, TRdce
	Bladex.DeactivateInput()
	pj = Bladex.GetEntity('Player1')
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5,pj.GoTo,(174344.485325, 19930.3243167, -60533.0217055))
	AbreCam.ResetNode()
	AbreCam.AddNode ( (178540,17700,-56008),(173456,20688,-64084), 3)
	AbreCam.AddNode ( (178540,17700,-56008),(173456,20688,-64084), 4)
	AbreCam.LastTime=0
	AbreCam.AbreCam()
	Bladex.AddScheduledFunc(Bladex.GetTime()+ 3.0, Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("SorpresaCorta"),))	
	Bladex.AddScheduledFunc(Bladex.GetTime()+ 4.0, TRdce.CloseDoor, ())	
	TRECanal.OnEnter=None	

def RompeMuroCanal (sector_index, weapon_name, px, py, pz, ximpulse, yimpulse, zimpulse, x_norm, y_norm, z_norm,ximpulse=0,yimpulse=0,zimpulse=0,x_norm=0,y_norm=0,z_norm=0,material=""):
	global TRCanal, TRCanalGolpe
	Sonido_RoturaMuroFalso.Play(177737.524673, 20980.7317952, -54000, 0)
	TRCanal.DoBreak((0.0, 0.0, 500), (px, py, pz), (0.0, 0.0, 0.0))
	TRCanalGolpe.OnHit=""
  	Bladex.KillMusic()  	
    	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("EntradaCascadas"),))
	Bladex.SetTriggerSectorFunc("Canal", "OnEnter", EntraInteriorCanal )
	Bladex.SetTriggerSectorFunc("Pinchos", "OnEnter", EntraTrampaPinchos )

def EntraInteriorCanal (SectorIndex,Entity_Name):
	if (Entity_Name!="Player1") : return
	global generador2
	generador2.Activate()
	Enm_Gen.TryToGenerateEnemy(SectorIndex,Entity_Name)

def TimerDisplaceTrampaPared(sld_name, time):	
	global TRMDCanal
	global PM11, PM12, PM13, PM21, PM22, PM31, PM32, PM33
	PM11.Position =  207600-TRMDCanal.sld_area().Displacement,PM11.Position[1], PM11.Position[2]
	PM12.Position =  207600-TRMDCanal.sld_area().Displacement,PM12.Position[1], PM12.Position[2]
	PM13.Position =  207600-TRMDCanal.sld_area().Displacement,PM13.Position[1], PM13.Position[2]
	PM21.Position =  207600-TRMDCanal.sld_area().Displacement,PM21.Position[1], PM21.Position[2]
	PM22.Position =  207600-TRMDCanal.sld_area().Displacement,PM22.Position[1], PM22.Position[2]
	PM31.Position =  207600-TRMDCanal.sld_area().Displacement,PM31.Position[1], PM31.Position[2]
	PM32.Position =  207600-TRMDCanal.sld_area().Displacement,PM32.Position[1], PM32.Position[2]
	PM33.Position =  207600-TRMDCanal.sld_area().Displacement,PM33.Position[1], PM33.Position[2]
	Doors.DisplaceSound(sld_name, time)

def EntraTrampaPinchos (SectorIndex,Entity_Name):
	if (Entity_Name!="Player1") : return
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.2, Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("EntradaCascadas"),))
	AbreCam.ResetNode()
	AbreCam.AddNode ((197914,19966,-63605),(206763,23259,-60312), 3)
	AbreCam.AddNode ((197914,19966,-63605),(206763,23259,-60312), 5)
	AbreCam.LastTime=0
	AbreCam.AbreCam()
	Bladex.AddScheduledFunc(Bladex.GetTime()+4.0, ActivaTrampaPared, ())
	Bladex.AddScheduledFunc(Bladex.GetTime()+5.0, CerrarTrampaPared, ())
	Bladex.RemoveTriggerSectorFunc("Pinchos", "OnEnter")
	
def ActivaTrampaPared():
	global PM11, PM12, PM13, PM21, PM22, PM31, PM32, PM33
	global PV11, PV12, PV13, PV21, PV22, PV31, PV32, PV33
	Sonido_Final_Plataformas.Position    = PM12.Position
	Sonido_Final_Plataformas.PlaySound(0)
	PM11.Position =  PM11.Position[0]-1800,PM11.Position[1], PM11.Position[2]
	PM12.Position =  PM12.Position[0]-1800,PM12.Position[1], PM12.Position[2]
	PM13.Position =  PM13.Position[0]-1800,PM13.Position[1], PM13.Position[2]
	PM21.Position =  PM21.Position[0]-1800,PM21.Position[1], PM21.Position[2]
	PM22.Position =  PM22.Position[0]-1800,PM22.Position[1], PM22.Position[2]
	PM31.Position =  PM31.Position[0]-1800,PM31.Position[1], PM31.Position[2]
	PM32.Position =  PM32.Position[0]-1800,PM32.Position[1], PM32.Position[2]
	PM33.Position =  PM33.Position[0]-1800,PM33.Position[1], PM33.Position[2]
	PV11.SubscribeToList('Pin')
	PV12.SubscribeToList('Pin')
	PV13.SubscribeToList('Pin')
	PV21.SubscribeToList('Pin')
	PV22.SubscribeToList('Pin')
	PV31.SubscribeToList('Pin')
	PV32.SubscribeToList('Pin')
	PV33.SubscribeToList('Pin')

def CerrarTrampaPared():
	global TRMDCanal
	TRMDCanal.prevdispl=TRMDCanal.sld_area().Displacement
	TRMDCanal.sld_area().TimerFunc = TimerDisplaceTrampaPared
	TRMDCanal.sld_area().SubscribeToList("DoorTimer")
	TRMDCanal.sld_area().SlideTo(13000,0,30)
	TRMDCanal.WhileCloseSound.Position=TRMDCanal.soundpos
	TRMDCanal.WhileCloseSound.PlaySound(-1)

def RompeMuroCanalSalida (sector_index, weapon_name, px, py, pz, ximpulse, yimpulse, zimpulse, x_norm, y_norm, z_norm,ximpulse=0,yimpulse=0,zimpulse=0,x_norm=0,y_norm=0,z_norm=0,material=""):
	global TRCanalMDSalida, TRCanalMDSalidaGolpe
	Sonido_RoturaMuroFalso.Play(195229.428899, 23931.9573761, -59492.2165488, 0)
	TRCanalMDSalida.DoBreak((-700.0, 0.0, 00), (px, py, pz), (0.0, 0.0, 0.0))
	TRCanalMDSalidaGolpe.OnHit=""

def TRAbreCanal (lever):
	global TRdcv, TRECanal
	lever.OnTurnOnFunc=None
	lever.OnTurnOnArgs=None
	TRdcv.OpenDoor()
	TRECanal.OnEnter=VuelveEntradaZonaCanal
	o=Bladex.GetEntity("Skeleton_Optimiced_967")
	o.SubscribeToList('Pin')
	SetLevelAndLife ("Knight_Skeleton_972", 8)
	darfuncs.UnhideBadGuy("Knight_Skeleton_972")
	o=Bladex.GetEntity("Knight_Skeleton_972")
	o.Blind=1
	o.Deaf=1

def VuelveEntradaZonaCanal (SectorIndex,Entity_Name):
	if (Entity_Name!="Player1") : return
	global TRECanal, TRdcv
	o=Bladex.GetEntity("Knight_Skeleton_972")
	o.Blind=0
	o.Deaf=0
	#Bladex.AddScheduledFunc(Bladex.GetTime()+ 4.0, TRdcv.CloseDoor, ())	
	TRECanal.OnEnter=None	

def SklCanalKilled (entity):
	Bladex.GetEntity(entity).Data.DefImDeadFunc(entity)
	global TRdce, TRdm
	AbreCam.ResetNode()
	AbreCam.AddNode ( (179756,18258,-60355),(169760,18557,-60357), 3)
	AbreCam.AddNode ( (170749,19376,-60682),(161461,23075,-60880), 2)
	AbreCam.AddNode ( (165521,21298,-60694),(155540,20706,-60541), 2)
	AbreCam.AddNode ( (165521,21298,-60694),(155540,20706,-60541), 4)
	AbreCam.LastTime=0
	AbreCam.AbreCam()
	TRdce.OpenDoor()
	Bladex.AddScheduledFunc(Bladex.GetTime()+ 6.0, TRdm.OpenDoor, ())	
	

## Muro deslizante
##-------------------------------------------------------------


def CerrarPared():
	global TRdm2
	TRdm2.sld_area().TimerFunc = Doors.DisplaceSound
	TRdm2.sld_area().SubscribeToList("DoorTimer")
	TRdm2.prevdispl=TRdm2.sld_area().Displacement
	TRdm2.sld_area().SlideTo(13000,0,3000)
	TRdm2.WhileCloseSound.Position=TRdm2.soundpos
	TRdm2.WhileCloseSound.PlaySound(-1)

def AbrirPared():
	global TRdm2
	TRdm2.sld_area().TimerFunc = Doors.DisplaceSound
	TRdm2.sld_area().SubscribeToList("DoorTimer")
	TRdm2.prevdispl=TRdm2.sld_area().Displacement
	TRdm2.sld_area().SlideTo(0,-3000,0)	
	TRdm2.WhileOpenSound.Position=TRdm2.soundpos
	TRdm2.WhileOpenSound.PlaySound(-1)


def MDPolvo (dustName, pos):
	polvareda=Bladex.CreateEntity(dustName, "Entity Particle System D2", pos[0], pos[1], pos[2])
	polvareda.ParticleType="LargeDust"
	polvareda.YGravity=0.0
	polvareda.Friction=0.2
	polvareda.PPS=250
	polvareda.DeathTime=Bladex.GetTime()+0.15
	polvareda.Velocity=-500, -1000, -750
	polvareda.RandomVelocity=60.0
	polvareda.RandomVelocity_V=1.0	
	

def MDPolvos ():
	MDPolvo ("MDPolvo1",(119407., 19432., -64266.))
	#MDPolvo ("MDPolvo2",(119407., 19432., -62766.))
	MDPolvo ("MDPolvo2",(119407., 19432., -61666.))
	MDPolvo ("MDPolvo3",(119451., 19432., -60500.))
	#MDPolvo ("MDPolvo3",(119451., 19432., -58500.))
	MDPolvo ("MDPolvo4",(119451., 19432., -57000.))


def ActivarPlancha ():	
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5,MDPolvos,())
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.5,CerrarPared,())

def MDCamara ():
	AbreCam.ResetNode()
	AbreCam.AddNode ( (133906, 17849, -59318),(143723, 19173, -60692), 4)
	AbreCam.AddNode ( (137931,18707,-63641),(145048,19148,-56630), 2)
	AbreCam.AddNode ( (141883, 18042,-60200),(132122,19203,-62038), 2)
	AbreCam.AddNode ( (141883, 18042,-60200),(132122,19203,-62038), 6)
	AbreCam.LastTime=0
	AbreCam.AbreCam()
	
dolpreina=None
dolprey=None
def InicializaLpDinObjs():
	global dolpreina, dolprey
	dolpreina = Objects.CreateDinamicObject("Lapidareina_668")
	dolprey = Objects.CreateDinamicObject("Lapidarey_669")
		
def EntraMuroDeslizante (SectorIndex,Entity_Name):
	if (Entity_Name!="Player1") : return
	global TRdn, TRmd
	pj = Bladex.GetEntity('Player1')
	pj.GoTo(141587.922875, 19929.5465119, -61222.6248408)
	time=Bladex.GetTime()
	Bladex.AddScheduledFunc( time + 0.5, MDCamara, ())	
	Bladex.ExeMusicEvent(Bladex.GetMusicEvent("PonerGema"))
	Bladex.AddScheduledFunc(time + 4.0, TRdm.CloseDoor, ())	
#	Bladex.AddScheduledFunc(time + 8.0, Sonido_Quake.Play, (120176.610724, 19931.4028347, -60230.9392165))
	Bladex.AddScheduledFunc(time + 8.0, Sonido_Quake.PlayStereo, ())
	Bladex.AddScheduledFunc(time + 8.0, ActivarPlancha, ())
	TRmd.OnEnter=None	
	# Elimina cositas de la piscina
	pers=Bladex.GetEntity("Cos_665")
	if pers:
	   pers.SubscribeToList('Pin')
	pers=Bladex.GetEntity("Cos_666")
	if pers:
	   pers.SubscribeToList('Pin')

def MDEntraLpReina (SectorIndex,Entity_Name):
	global dolpreina
	try:
	   dummy=dolprey.obj
	except:
	   InicializaLpDinObjs()
	Objects.DisplaceObject(dolpreina, 100, (0,1,0), 1000, 1, "",Sonido_Deslizamiento_Plataformas,Sonido_Final_Plataformas)	
	AbrirPared()
	
def MDSalLpReina (SectorIndex,Entity_Name):
	global dolpreina
	try:
	   dummy=dolprey.obj
	except:
	   InicializaLpDinObjs()
	Objects.DisplaceObject(dolpreina, 100, (0,-1,0), 1000, -1, "",Sonido_Deslizamiento_Plataformas,Sonido_Final_Plataformas)	
	CerrarPared()

def MDEntraLpRey (SectorIndex,Entity_Name):
	global dolprey
	try:
	   dummy=dolprey.obj
	except:
	   InicializaLpDinObjs()
	Objects.DisplaceObject(dolprey, 100, (0,1,0), 1000, 1, "",Sonido_Deslizamiento_Plataformas,Sonido_Final_Plataformas)	
	global generador1
	generador1.Activate()
	Enm_Gen.TryToGenerateEnemy(SectorIndex,Entity_Name)

def MDSalLpRey (SectorIndex,Entity_Name):
	global dolprey
	try:
	   dummy=dolprey.obj
	except:
	   InicializaLpDinObjs()
	Objects.DisplaceObject(dolprey, 100, (0,-1,0), 1000, -1, "",Sonido_Deslizamiento_Plataformas,Sonido_Final_Plataformas)	
	global generador1
	generador1.Deactivate()
	Bladex.SetTriggerSectorFunc("LpRey", "OnEnter", MDEntraLpRey )

def EntraAscensor (SectorIndex,Entity_Name):
	if (Entity_Name!="Player1") : return
	global TRasc
	TRasc.OnEnter=None
	Bladex.DeactivateInput()
	pj = Bladex.GetEntity('Player1')
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.0,pj.GoTo,(111376.62729, 23939.0176691, -60236.4628645))
	Bladex.AddScheduledFunc(Bladex.GetTime()+3.0,SubeAscensor,())
	Bladex.AddScheduledFunc(Bladex.GetTime()+20.0,BajaAscensor,())

doasc=None
def SubeAscensor ():
	global doasc
	Bladex.ActivateInput()
	doasc = Objects.CreateDinamicObject("Ascensor_676")
	Objects.DisplaceObject(doasc, 16900, (0,-1,0), 7000, -1, "",Sonido_Deslizamiento_Plataformas,Sonido_Final_Plataformas)	
	
def BajaAscensor ():
	global TRasc
	global doasc
	TRasc.OnEnter=EntraAscensor
	doasc = Objects.CreateDinamicObject("Ascensor_676")
	Objects.DisplaceObject(doasc, 16900, (0,1,0), 7000, -1, "",Sonido_Deslizamiento_Plataformas,Sonido_Final_Plataformas)	
	

## Misiles
##-------------------------------------------------------------

## Posicion inicial de los misiles

MSInitPos=[(112731, 6253, -87094), (111227, 6253, -87094),(109691, 6253, -87094)]

## Velocidad y direccin del disparo

MSVel = (0,0,+10000)

## Tiempo entre misiles

MSTime = 1.5


def MissileImpact( EntityName, VictimName, ImpX, ImpY, ImpZ):
	missile=Bladex.GetEntity(EntityName)
	if missile:
		x, y, z=missile.Position
		impactps=Bladex.CreateEntity("ImpactPS", "Entity Particle System D1", x, y, z)
		impactps.ParticleType="RedMagicMissile"
		impactps.PPS=2000
		impactps.YGravity=1400.0
		impactps.Friction=0.06
		impactps.Velocity=-ImpX/5.0, -ImpY/5.0, -ImpZ/5.0
		impactps.RandomVelocity=40.0
		impactps.Time2Live=20
		impactps.DeathTime=Bladex.GetTime()+0.25
		luzimp=Bladex.CreateEntity("LuzImpacto", "Entity Spot", x-ImpX/10.0, y-ImpY/10.0, z-ImpZ/10.0)
		luzimp.Color=255, 180, 160
		luzimp.Intensity=1.0
		luzimp.Precission=0.001
		luzimp.CastShadows=0
		luzimp.Flick=0
		luzimp.Visible=0
		AuxFuncs.SpotIntensityVariation(luzimp.Name, 1.0, 0.0, 1.0, 1)
		if missile.Data: missile.Data.OldInflictHitFunc(EntityName, VictimName, ImpX, ImpY, ImpZ)

def MissileOnHit ( MissileName, hit_entity):
	missile=Bladex.GetEntity(MissileName)
	if missile:
		if missile.Data:
			missile.Data.RemovePostFunc()
		if hit_entity:
			pass
		else:
			x, y, z=missile.Position
			impactps=Bladex.CreateEntity("ImpactPS", "Entity Particle System D1", x, y, z)
			impactps.ParticleType="RedMagicMissile"
			impactps.PPS=2500
			impactps.YGravity=1400.0
			impactps.Friction=0.06
			impactps.Velocity=0.0, 0.0, 0.0
			impactps.RandomVelocity=40.0
			impactps.Time2Live=20
			impactps.DeathTime=Bladex.GetTime()+0.25
			luzimp=Bladex.CreateEntity("LuzImpacto", "Entity Spot", x, y, z)
			luzimp.Color=255, 180, 160
			luzimp.Intensity=1.0
			luzimp.Precission=0.001
			luzimp.CastShadows=0
			luzimp.Flick=0
			luzimp.Visible=0
			AuxFuncs.SpotIntensityVariation(luzimp.Name, 1.0, 0.0, 1.0, 1)		
		if missile.Data:
			Bladex.AddScheduledFunc(Bladex.GetTime(), missile.Data.RemoveMissile, (1,))


def RemoveMissile( EntityName):
	missile=Bladex.GetEntity(EntityName)
	if missile:
		if Reference.EntitiesObjectData.has_key(missile.Name):
			del Reference.EntitiesObjectData[missile.Name]
		missile.Unlink(missile.Data.missileps2)
		missile.Data.missileps2.DeathTime=Bladex.GetTime()+1.0/60.0
		missile.Data.RemoveMissile()			

def DecreaseMissileIntensity( EntityName, intreduction, sndreduction):
	missile=Bladex.GetEntity(EntityName)
	if missile:
		missilewhilesound=missile.Data.MissileWhileSound
		missile.Intensity=missile.Intensity-intreduction
		missilewhilesound.Volume=missilewhilesound.Volume-sndreduction

def MissileDissipation( EntityName):
	missile=Bladex.GetEntity(EntityName)
	if missile:
		missile.Data.missileps1.DeathTime=Bladex.GetTime()+1.0/60.0
		missilewhilesound=missile.Data.MissileWhileSound
		intreduction=missile.Intensity/4.0
		sndreduction=missilewhilesound.Volume/4.0
		missile.Intensity=missile.Intensity-intreduction
		missilewhilesound.Volume=missilewhilesound.Volume-sndreduction
		Bladex.AddScheduledFunc(Bladex.GetTime()+0.15, DecreaseMissileIntensity, (EntityName, intreduction, sndreduction))
		Bladex.AddScheduledFunc(Bladex.GetTime()+0.3, DecreaseMissileIntensity, (EntityName, intreduction, sndreduction))
		Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, RemoveMissile, (EntityName,))

def FireMissile( missilename, vx, vy, vz):
	missile=Bladex.GetEntity(missilename)
	if missile:
		missile.OnHitFunc=MissileOnHit
		targetName='Player1'
		missile.Data.Fire(vx, vy, vz, targetName, 0.5, 2.0, MissileDissipation, 10.0)
		x, y, z=missile.Position
		missileshootps=Bladex.CreateEntity(missilename+"ShootPS", "Entity Particle System D1", 0, 0, 0)
		missileshootps.ParticleType="RedMagicMissile"
		missileshootps.PPS=1000
		missileshootps.YGravity=0.0
		missileshootps.Friction=0.08
		missileshootps.Velocity=0.0, 0.0, 0.0
		missileshootps.RandomVelocity=40.0
		missileshootps.Time2Live=20
		missileshootps.DeathTime=Bladex.GetTime()+0.25
		missile.Link(missileshootps)

def EndCreateMissile( missilename, x, y, z):
	missile=ItemTypes.MakeGenericMissile(missilename, x, y, z)
	missile.Color=255, 180, 160
	missile.Data.SetMissileSound("shoot", "..\\..\\Sounds\\Fireball-Fire.wav")
	missile.Data.SetMissileSound("while", "..\\..\\Sounds\\bola-fuego.wav")
	missile.Data.SetMissileSound("impact", "..\\..\\Sounds\\fireball-impact-wood.wav")
	missileps1=Bladex.CreateEntity(missilename+"PS1", "Entity Particle System D1", 0, 0, 0)
	missileps1.ParticleType="RedMagicMissile"
	missileps1.PPS=200
	missileps1.YGravity=0.0
	missileps1.Friction=0.08
	missileps1.Velocity=0.0, 0.0, 0.0
	missileps1.RandomVelocity=15.0
	missileps1.Time2Live=30
	missile.Link(missileps1)
	missileps1.FollowFactor=1
	missileps2=Bladex.CreateEntity(missilename+"PS2", "Entity Particle System D1", 0.0, 0.0, 0.0)
	missileps2.ParticleType="RedMagicMissile"
	missileps2.PPS=100
	missileps2.YGravity=0.0
	missileps2.Friction=0.04
	missileps2.Velocity=0.0, 0.0, 0.0
	missileps2.RandomVelocity=-5.0
	missileps2.Time2Live=25
	missile.Link(missileps2)
	missile.Data.missileps1=missileps1
	missile.Data.missileps2=missileps2
	missile.Data.OldInflictHitFunc=missile.InflictHitFunc
	missile.InflictHitFunc=MissileImpact
	Reference.EntitiesObjectData[missile.Name]= BCopy.deepcopy(Reference.DefaultObjectData['EsferaNegraAhk'])


def CreateMissile (initPosition, vel):
	x, y, z=initPosition
	vx, vy, vz = vel
	missilename=Bladex.GenerateEntityName()
	missileconc=Bladex.CreateEntity(missilename+"Conc", "Entity Particle System D1", x, y, z)
	missileconc.ParticleType="FastRedEnergyConc"
	missileconc.PPS=400
	missileconc.YGravity=0.0
	missileconc.Friction=0.0
	missileconc.Velocity=0.0, 0.0, 0.0
	missileconc.RandomVelocity=-20.0
	missileconc.Time2Live=30
	missileconc.DeathTime=Bladex.GetTime()+1.0
	missileconcsound=Bladex.CreateEntity(missilename+"ConcSound", "Entity Sound", x, y, z)
	missileconcsound.SetSound("..\\..\\Sounds\\fireball-swing.wav")
	missileconcsound.MinDistance=5000
	missileconcsound.MaxDistance=30000
	missileconcsound.PlaySound(0)
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, EndCreateMissile, (missilename, x, y, z))
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.5, FireMissile, (missilename, vx, vy, vz))
 	

def SalMisiles (SectorIndex,Entity_Name):
	global MSActivados
	if (Entity_Name!="Player1") : return
	MSActivados = 0
	TRMS.OnEnter=EntraMisiles

MSActivados=0
def EntraMisiles (SectorIndex,Entity_Name):
	global TRMS, MSActivados
	if (Entity_Name!="Player1") : return
	TRMS.OnEnter=None
	MSActivados = 1
	pj = Bladex.GetEntity("Player1")
	Sonido_Trampa_Activada.Play(pj.Position[0],pj.Position[1],pj.Position[2],0)
	Bladex.AddScheduledFunc(Bladex.GetTime(),DisparaMisil,())

def DisparaMisil ():
	global MSInitPos, MSVel, MSActivados
	if MSActivados == 1:
	   i=whrandom.randint(0, 2)
	   Bladex.AddScheduledFunc(Bladex.GetTime(),CreateMissile,(MSInitPos[i],MSVel))
	   Bladex.AddScheduledFunc(Bladex.GetTime()+MSTime,DisparaMisil,())


## Laberinto
##-------------------------------------------------------------



Maze1={}
Maze1[19] = '01000100000000010000'
Maze1[18] = '01011101111111010100'
Maze1[17] = '00010000010001000100'
Maze1[16] = '11011111010101010111'
Maze1[15] = '00010001000101010000'
Maze1[14] = '11010101111101111110'
Maze1[13] = '00000101000000000010'
Maze1[12] = '11111101110111110010'
Maze1[11] = '01000001000000010010'
Maze1[10] = '01011111011111110011'
Maze1[9]  = '01010000000001000001'
Maze1[8]  = '01011111111111011101'
Maze1[7]  = '01000000000000010101'
Maze1[6]  = '01111111111111110101'
Maze1[5]  = '00000100010000000101'
Maze1[4]  = '01011101010101111101'
Maze1[3]  = '01000101010100000001'
Maze1[2]  = '01011101010111111111'
Maze1[1]  = '01000001000000000000'
Maze1[0]  = '00000001111111111111'


Mazes=[Maze1]

# Tamao Celda

CellSize=2000.0

# Sector origen

Org = (131917,6953,-76845)

## Tambin puedes cambiar el tiempo que transcurre entre
## la aparicin de cada muro.

RefreshTime = 0.1

##

IdMaze=0
Maze=Mazes[IdMaze]
Sectors={}
PSectors={}
YMax=len(Maze[0])-1
XMax=len(Maze)-1

for x in range (0,XMax+1):
	ys=[]
	ps=[]
	for y in range (0,YMax+1):
	   pos = (Org[0]+x*CellSize, Org[1],Org[2]-y*CellSize)
#	   print x,"-",y," Pos => ",pos
	   ys.append(Bladex.GetSector(pos[0], pos[1], pos[2]))
	   ps.append(pos[0], pos[1], pos[2])
	Sectors[x]=ys
	PSectors[x]=ps

x=0
y=0
lastTime=0

def AjustaSector(time):
	global x,y,Maze,Sectors,PSectors,lastTime,RefreshTime
	if time - lastTime < RefreshTime:
	   return
	else:
	   lastTime=time

	if y <= YMax:
#	        print "Analiza... ",x,"-",y

		ylocal = y
		while ((ylocal <= YMax) and (Maze[x][y] == Maze [x][ylocal])):
	           if Sectors[x][ylocal]:		   
		      if Maze[x][ylocal] == '1':
#	                 print "Maze ",x,ylocal," Muro"
	                 Sectors[x][ylocal].Active=0
		      else:
#	                 print "Maze ",x,ylocal," Hueco"
	                 Sectors[x][ylocal].Active=1
            	   ylocal = ylocal +1
	        if Maze[x][y] == '1':
	                 Sonido_Maze.Play (PSectors[x][y][0], PSectors[x][y][1], PSectors[x][y][2],0)
		y = ylocal
	else:
	   	y = 0
		x = x + 1
		if x > XMax:
		   EndActivateMaze()

def EndActivateMaze ():
	Bladex.RemoveAfterFrameFunc("AjustaSector")
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.0,EnciendeMaze,())
	CreaAmuleto()
		   
def CreaAmuleto ():
	o=Bladex.GetEntity("Araswen_Vial")
	o.Alpha=1
	luzVial=Bladex.CreateEntity("luzVial","Entity Spot", 0, 0, 0)
	luzVial.Color=0,0,255
	luzVial.Intensity=0.00001
	luzVial.Precission=1
	luzVial.CastShadows=0	
	luzVial.GlowTexture="MagicFlare128"	
	luzVial.GlowTestZ=1
	luzVial.AngVel=0.5
	luzVial.SizeFactor=2.0
	o.Link(luzVial)
	o=Bladex.GetEntity("FireRing_1018")
	o.Alpha=1
	darfuncs.ObjAlpha(o,0.9,0.2)

def TengoAmuleto ():
	Bladex.KillMusic()
	Bladex.ExeMusicEvent(Bladex.GetMusicEvent("SorpresaCorta"))
	Actions.FreeBothHands ("Player1")
	GameText.WriteTextAux(Tr('El Vial de Araswen'),5.0,252,247,167,[],100)
	o=Bladex.GetEntity("Araswen_Vial")
	Ontake.DelOnTakeEvent(o.Name)
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, ObjectMagicallyDisappearing, ("FireRing_1018", 2, AuxFuncs.DESTROY_METHOD_BIN))
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.2,ModificaMaze,())
	Ontake.DelOnTakeEvent(o.Name)

def RegalosLaberinto ():
	SetLevelAndLife ("Knight_Skeleton_932", 7, 9)
	darfuncs.UnhideBadGuy("Knight_Skeleton_932")
	SetLevelAndLife ("Knight_Skeleton_936", 7, 9)
	darfuncs.UnhideBadGuy("Knight_Skeleton_936")
	SetLevelAndLife ("Knight_Skeleton_939", 7, 9)
	darfuncs.UnhideBadGuy("Knight_Skeleton_939")
	SetLevelAndLife ("Knight_Skeleton_943", 7, 9)
	darfuncs.UnhideBadGuy("Knight_Skeleton_943")
	SetLevelAndLife ("Knight_Skeleton_946", 7, 9)
	darfuncs.UnhideBadGuy("Knight_Skeleton_946")

def EsperadQueEstoyDeCine ():
	o=Bladex.GetEntity ("Knight_Skeleton_932")
	if o:
	   o.Freeze()
	o=Bladex.GetEntity ("Knight_Skeleton_936")
	if o:
	   o.Freeze()
	o=Bladex.GetEntity  ("Knight_Skeleton_939")
	if o:
	   o.Freeze()
	o=Bladex.GetEntity  ("Knight_Skeleton_943")
	if o:
	   o.Freeze()
	o=Bladex.GetEntity  ("Knight_Skeleton_946")
	if o:
	   o.Freeze()

def SeguimosQueSeAcaboElCine ():
	o=Bladex.GetEntity ("Knight_Skeleton_932")
	if o:
	   o.UnFreeze()
	o=Bladex.GetEntity ("Knight_Skeleton_936")
	if o:
	   o.UnFreeze()
	o=Bladex.GetEntity  ("Knight_Skeleton_939")
	if o:
	   o.UnFreeze()
	o=Bladex.GetEntity  ("Knight_Skeleton_943")
	if o:
	   o.UnFreeze()
	o=Bladex.GetEntity  ("Knight_Skeleton_946")
	if o:
	   o.UnFreeze()

def EntraMaze (SectorIndex,Entity_Name):
	global TRMS, MSActivados
	if (Entity_Name!="Player1") : return
	Bladex.GetGhostSectorSound('RioFinal5').Volume=0
	Bladex.GetGhostSectorSound('RioFinal6').Volume=0
	Bladex.GetGhostSectorSound('RioFinal7').Volume=0
	MSActivados = 0
	TRMS.OnEnter=EntraMisiles
	Bladex.RemoveTriggerSectorFunc(SectorIndex, "OnEnter")
	Bladex.SetTriggerSectorFunc(SectorIndex, "OnEnter", SalMisiles)
    	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("Laberinto"),))
	AbreCam.ResetNode()
	AbreCam.AddNode ( (147757,4000,-79548),(138618,5207,-83232), 4)
	AbreCam.AddNode ( (159738,4300,-97765),(150806,3780,-93268), 4)
	AbreCam.AddNode ( (164087, 4000,-103918),(156435,4572,-97586), 3)
	AbreCam.AddNode ( (149994,1556,-107211),(157718,4390,-101527), 4)
	AbreCam.AddNode ( (138848,1351,-100807),(148505,3947,-100863), 2)
	AbreCam.LastTime=3
	AbreCam.CallBack=RegalosLaberinto
	AbreCam.AbreCam()
	Bladex.AddScheduledFunc(Bladex.GetTime()+2.0,ActivaMaze,())
	
def EnciendeMaze():
	o=Bladex.GetEntity("Antorchaenpared_1022")
	o.FiresIntensity=[ 3 ]
	o.Lights= [(10.0, 0.03125, (255, 196, 128))]
	o.Alpha=1

	o=Bladex.GetEntity("Antorchaenpared_1023")
	o.FiresIntensity=[ 3 ]
	o.Lights= [(10.0, 0.03125, (255, 196, 128))]
	o.Alpha=1

	o=Bladex.GetEntity("Antorchaenpared_1024")
	o.FiresIntensity=[ 3 ]
	o.Lights= [(10.0, 0.03125, (255, 196, 128))]
	o.Alpha=1

	o=Bladex.GetEntity("Antorchaenpared_1025")
	o.FiresIntensity=[ 3 ]
	o.Lights= [(10.0, 0.03125, (255, 196, 128))]
	o.Alpha=1

	o=Bladex.GetEntity("Antorchaenpared_1026")
	o.FiresIntensity=[ 3 ]
	o.Lights= [(10.0, 0.03125, (255, 196, 128))]
	o.Alpha=1

def ActivaMaze():
	global lastTime
	lastTime=Bladex.GetTime()
	x=0
	y=0
	Bladex.SetAfterFrameFunc("AjustaSector", AjustaSector)

# No se usa en este mapa, slo cuando hay ms de un laberinto completo.

def CambiaMaze():
	global x, y, lastTime, IdMaze, Mazes, Maze
	lastTime=Bladex.GetTime()
	IdMaze=IdMaze+1
	if IdMaze > len (Mazes)+1:
	   IdMaze = 0
	Maze=Mazes[IdMaze]
	Reset()
	x=0
	y=0
	YMax=len(Maze[0])-1
	XMax=len(Maze)
	Bladex.SetAfterFrameFunc("AjustaSector", AjustaSector)
   
def Reset():
	for x in range (1,XMax+1):
	   for y in range (1,YMax+1):
	       if Sectors[x][y]:
	          Sectors[x][y].Active=1
	   
def CountNextY():
	global x,y,Maze
	count = 0
	while (Maze[x][y] == Maze [x][y+count]):
	       count=count+1
	return count	       

CambiosMaze = [(16,12,1), (13,15,1), (11,7,0), (11,18,0), (8,14,1), (6,12,0)]
NCambioMaze = 0
def ASTrampaMaze(time):
	global CambiosMaze,NCambioMaze,Sectors,PSectors,lastTime
	refreshTime=1.0
	if time - lastTime < refreshTime:
	   return
	else:
	   lastTime=time

	if NCambioMaze < len(CambiosMaze):
	   x=CambiosMaze[NCambioMaze][0]
	   y=CambiosMaze[NCambioMaze][1]
	   s=CambiosMaze[NCambioMaze][2]
           if Sectors[x][y]:		   
	      if s == 1:
                 Sectors[x][y].Active=0
	      else:
	         Sectors[x][y].Active=1
              Sonido_Maze.Play (PSectors[x][y][0], PSectors[x][y][1], PSectors[x][y][2],0)
	   NCambioMaze = NCambioMaze +1
	else:
           Bladex.RemoveAfterFrameFunc("ASTrampaMaze")


def ModificaMaze ():
	global lastTime, NCambioMaze
	pj = Bladex.GetEntity("Player1")
	Sonido_Trampa_Activada.Play (pj.Position[0],pj.Position[1],pj.Position[2],0)
	EsperadQueEstoyDeCine ()
	AbreCam.ResetNode()
	AbreCam.AddNode ((156449, 2704, -100638), (165334, 6750, -102802), 1)
	AbreCam.AddNode ((157963, 539, -94251), (155845, 3977, -103400), 2)
	AbreCam.AddNode ((157963, 539, -94251), (155845, 3977, -103400), 5)
	AbreCam.CallBack=SeguimosQueSeAcaboElCine
	AbreCam.AbreCam()
	lastTime=Bladex.GetTime()
	NCambioMaze=0
	Bladex.SetAfterFrameFunc("ASTrampaMaze", ASTrampaMaze)
	

#TRTrampaMaze=Sectors[14][12]
#TRTrampaMaze.OnEnter=TrampaMaze

## Saln de la Magia
##-------------------------------------------------------------

TresEnemies = ['3K','3KSkl', '3GO']
TresId = -1

def PartLimber(PersonName,idx):
	char = Bladex.GetEntity(PersonName)
	if char:
		if idx == 1:
		        o = char.SeverLimb(1)
		        if o: o.Impulse(0,-10000,0)
		if idx == 2:
		        o = char.SeverLimb(2)
		        if o: o.Impulse(-10000*math.cos(char.Angle),-10000,-10000*math.sin(char.Angle))
		if idx == 4:
		        o = char.SeverLimb(4)
		        if o: o.Impulse(10000*math.cos(char.Angle),-10000,10000*math.sin(char.Angle))
		if idx == 6:
		        o = char.SeverLimb(6)
		        if o: o.Impulse(-10000*math.cos(char.Angle),-10000,-10000*math.sin(char.Angle))
		if idx == 8:
		        o = char.SeverLimb(8)
		        if o: o.Impulse(10000*math.cos(char.Angle),-10000,10000*math.sin(char.Angle))

def MuerteRayo (trsector_name, entity_name):
	pers=Bladex.GetEntity(entity_name)
	if pers and pers.Person:
		Sonido_Rayo_Hit.Position=pers.Position
		Sonido_Rayo_Hit.PlaySound(0)
		x, y, z=pers.Position
		rayo=Bladex.CreateEntity("RayoMuerte", "Entity ElectricBolt", x, y-700.0, z)
		rayo.Position=x, y-700.0, z
		rayo.Target=x, y+1100.0, z
		rayo.MaxAmplitude=500.0
		rayo.MinSectorLength=10000.0
		rayo.Damage=0
		rayo.Active=1
		chispas=Bladex.CreateEntity("ChispasMuerte", "Entity Particle System D2", x, y-700.0, z)
		chispas.D=0.0, 1800.0, 0.0
		chispas.ParticleType="ChispasM"
		chispas.PPS=3000
		chispas.YGravity=4900.0
		chispas.Friction=0.01
		chispas.RandomVelocity=50.0
		chispas.Time2Live=20
		chispas.DeathTime=Bladex.GetTime()+8.0/60.0
		Bladex.AddScheduledFunc(Bladex.GetTime()+0.1, rayo.SubscribeToList, ("Pin",))
		pers.Life=0
		pers.Wuea=Reference.WUEA_ENDED
		pers.SetTmpAnmFlags(1,1,1,0,5,1)
		pers.LaunchAnmType("dth_n02")
		Bladex.AddScheduledFunc(Bladex.GetTime()+0.05, PartLimber, (entity_name,1))
		#Bladex.AddScheduledFunc(Bladex.GetTime()+0.50, PartLimber, (entity_name,2))
		#Bladex.AddScheduledFunc(Bladex.GetTime()+0.75, PartLimber, (entity_name,4))
		Bladex.AddScheduledFunc(Bladex.GetTime()+0.05, PartLimber, (entity_name,6))
		Bladex.AddScheduledFunc(Bladex.GetTime()+0.05, PartLimber, (entity_name,8))
	if pers.Name <> 'Player1':
		pers.Data.Invincibility=0
		TresKilled (pers.Name)

def SonidoFinalRayos():
	global Sonido_Rayo
	Sonido_Rayo.Position=194338.429761, 6926.64697286, -113782.534232
	Sonido_Rayo.PlaySound(-1)
	Sonido_Rayo.Volume=0.17
	Sonido_Rayo.MinDistance=1000
	Sonido_Rayo.MaxDistance=8000

def ActivaRayos():
	global Sonido_Rayo
	Sonido_Rayo.Volume=1.0
	Sonido_Rayo.MinDistance=1000
	Sonido_Rayo.MaxDistance=15000
	Sonido_Rayo.Position=179440,3817,-106253
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.0, ActivaRayo, ('Rayo1',))	
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.3, ActivaRayo, ('Rayo2',))	
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.6, ActivaRayo, ('Rayo3',))	
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, SonidoFinalRayos, ())	

def ActivaRayo(rayName):
	global Sonido_Rayo
	rayo=Bladex.GetEntity(rayName)
	rayo.Active=1
	Sonido_Rayo.PlaySound (0)

def DesactivaRayos():
	rayo=Bladex.GetEntity('Rayo3')
	rayo.Active=0
	rayo.SubscribeToList('Pin')
	Sonido_Rayo.StopSound()
	rayo=Bladex.GetEntity('Rayo2')
	rayo.Active=0
	rayo.SubscribeToList('Pin')
	Sonido_Rayo.StopSound()
	rayo=Bladex.GetEntity('Rayo1')
	rayo.Active=0
	rayo.SubscribeToList('Pin')
	Sonido_Rayo.StopSound()
	Bladex.RemoveTriggerSectorFunc("Rayo", "OnEnter") 


def EntraSalonMagia  (SectorIndex,Entity_Name):
	global TRMagia
	if (Entity_Name!="Player1") : return
	SetLevelAndLife ("3K",    8)
	SetLevelAndLife ("3KSkl", 7, 10)
	SetLevelAndLife ("3GO",   6)
	TRMagia.OnEnter=None	
    	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("Ambiente5mp3"),))
	Bladex.DeactivateInput()
	AbreCam.ResetNode()
	#AbreCam.AddNode ( (183884,5809,-112414),(175342,7378,-117370), 3)
	#AbreCam.AddNode ( (186462,4169,-111030),(178042,6748,-115768), 3)
	AbreCam.AddNode ( (190128,3953,-110234),(181213,7193,-113400), 3)	
	AbreCam.AddNode ( (179440,3817,-106253),(186764,5711,-112793), 3)
	AbreCam.AddNode ( (179440,3817,-106253),(186764,5711,-112793), 7)
	AbreCam.LastTime=0
	AbreCam.AbreCam()
	pj=Bladex.GetEntity('Player1')	
	pj.GoTo (180954.535169, 6938.92207047, -114387.24847)
	Bladex.AddScheduledFunc(Bladex.GetTime()+8.0, ActivaRayos, ())	
	Bladex.AddScheduledFunc(Bladex.GetTime()+11.0, ObjectMagicallyDisappearing, ("Amuletofantasma_1012", 5, AuxFuncs.DESTROY_METHOD_BIN))
	Bladex.AddScheduledFunc(Bladex.GetTime()+11.0, TresNextEnemy, (), "TresNextEnemy")	


	
def TresUnHide (entityName):
	darfuncs.UnhideBadGuy (entityName)
	pers=Bladex.GetEntity(entityName)
	pers.UnFreeze()
	Actions.TurnToFaceEntityNow("Player1", entityName)
	pers.SetActiveEnemy ("Player1")
	pj==Bladex.GetEntity('Player1')
	pj.SetActiveEnemy(pers)

def SelectPosition (pos, mindistance, maxdistance, entity):
	
	global LastEne
   	pj=Bladex.GetEntity("Player1")
	entid = Bladex.GetEntitiesAt(pos[0],pos[1],pos[2],800)
   	valid_appear = 1
	for on in entid:
		o = Bladex.GetEntity(on)
		if o.Person and o.Name <> LastEne.Name and o.Life > 0 and o.Alpha > 0.01:
		   	valid_appear = 0
	if valid_appear:
	   entity.Position = pos
	   if entity.Data.NPC:
		Actions.TurnToFaceEntityNow(entity.Name, pj.Name)
		if entity.CanISee (pj):
			return
		else:
			return
	safe_limit=10
   	valid_position = 0
   	n=0
   	while not valid_position and n < safe_limit:
		n=n+1
	  	if whrandom.randint(0, 2)<=1:
			Sign = -1
  		else:
			Sign = 1
  		IncX=whrandom.randint(mindistance, maxdistance)*Sign
  		IncY=0
  		if whrandom.randint(0, 2)<=1:
			Sign = -1
	  	else:
			Sign = 1
  		IncZ=whrandom.randint(mindistance, maxdistance)*Sign
		bpos = pos[0]+IncX, pos[1]+IncY, pos[2]+IncZ
		entid = Bladex.GetEntitiesAt(bpos[0],bpos[1],bpos[2],800)
	   	valid_appear = 1
		for on in entid:
			o = Bladex.GetEntity(on)
			if o.Person and o.Name <> LastEne.Name and o.Life > 0 and o.Alpha > 0.01:
		   		valid_appear = 0
		if valid_appear:
			entity.Position = bpos
			if entity.Data.NPC:
				Actions.TurnToFaceEntityNow(entity.Name, pj.Name)
				if entity.CanISee (pj):
					valid_position=1
			else:
				valid_position=1			
	if not valid_position:
		entity.Position = 187050, 6945, -114405
		Actions.TurnToFaceEntityNow(entity.Name, pj.Name)

def TresAparece (entityName):
	global LastEne
	pers=Bladex.GetEntity(entityName)
	pers.Data.Invincibility=0
	pers.SendTriggerSectorMsgs=1
#	pers.Position=LastEne.Position
	SelectPosition (LastEne.Position, 1500, 3000, pers)
#	pers.Angle=LastEne.Angle
	Sonido_Concentracion.Play (pers.Position[0], pers.Position[1], pers.Position[2],0)	
	TresUnHide (entityName)	
	PersonMagicallyAppearing (entityName, 2)
	DisipatePerson (entityName)

def TresDesaparece (entityName):
	pers=Bladex.GetEntity(entityName)
	pers.Data.Invincibility=1
	pers.SendTriggerSectorMsgs=0
	pers.Freeze()
	PersonMagicallyDisappearing (entityName, 2)	
	Bladex.AddScheduledFunc(Bladex.GetTime()+2.0, darfuncs.HideBadGuy, (entityName,))	

def TresKilled (entity):
	global TresId, TresEnemies, LastEne
	Bladex.RemoveScheduledFunc("TresNextEnemy")
	TresEnemies.remove (entity)
	if TresId > len (TresEnemies)-1:
	   TresId = 0
	pers=Bladex.GetEntity(entity)
	pers.Data.DefImDeadFunc(entity)
	if len (TresEnemies) == 0:
	   TresFinal()
	else:
	   LastEne=Bladex.GetEntity(TresEnemies[TresId])
	   LastEne.Position=pers.Position
	   Bladex.AddScheduledFunc(Bladex.GetTime()+0.2, TresAparece, (TresEnemies[TresId],))	

def TresNextEnemy ():
	global TresEnemies, TresId, LastEne
	Bladex.RemoveScheduledFunc("TresNextEnemy")
	if len (TresEnemies) > 1:
	   LastEne=Bladex.GetEntity(TresEnemies[TresId])
	   LastEne.Freeze()
	   if TresId > -1:
	      TresDesaparece(LastEne.Name)
	   TresId = TresId + 1
	   if TresId > len (TresEnemies)-1:
	      TresId = 0
	   Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, TresAparece, (TresEnemies[TresId],))	
	   Bladex.AddScheduledFunc(Bladex.GetTime()+30.0, TresNextEnemy, (), "TresNextEnemy")	
	else:
	   TresId = 0
	   Bladex.AddScheduledFunc(Bladex.GetTime()+0.0, TresAparece, (TresEnemies[TresId],))	

def TresFinal ():
	DesactivaRayos ()
	SetLevelAndLife ("Skeleton_728", 7)
	darfuncs.UnhideBadGuy ("Skeleton_728")
	SetLevelAndLife ("Skeleton_736", 8)
	darfuncs.UnhideBadGuy ("Skeleton_736")
	# Elimina regalos del laberinto
	pers=Bladex.GetEntity("Knight_Skeleton_932")
	if pers:
	   pers.SubscribeToList('Pin')
	pers=Bladex.GetEntity("Knight_Skeleton_936")
	if pers:
	   pers.SubscribeToList('Pin')
	pers=Bladex.GetEntity("Knight_Skeleton_939")
	if pers:
	   pers.SubscribeToList('Pin')
	pers=Bladex.GetEntity("Knight_Skeleton_943")
	if pers:
	   pers.SubscribeToList('Pin')
	pers=Bladex.GetEntity("Knight_Skeleton_946")
	if pers:
	   pers.SubscribeToList('Pin')
	CreateRiolavaFpuente()

## Falso Puente
##-------------------------------------------------------------

## The Path of God- "Only the leap from the lion head will prove his worth." 
	
def LeePlacaIndy (ent, usedfrom):
	GameText.WriteTextAux(Tr("- El Camino de Dios -\n Slo la F verdadera te ayudar.\n Indy"),3.0,252,247,167,[],100)

def EntraFalsoPuente (SectorIndex,Entity_Name):

	MuestraPuente=0
	if (Entity_Name=="Player1"):
	   pj=Bladex.GetEntity('Player1')
	   if re.search ('Jump', pj.AnimName):
		MuestraPuente=0
	   else:
		MuestraPuente=1
	if MuestraPuente==1:
	   Bladex.RemoveTriggerSectorFunc(SectorIndex, "OnEnter")
	   AbreCam.ResetNode()
	   AbreCam.AddNode ((213321,-9603,-90081),(219243, -5386,-83215), 2)
	   AbreCam.AddNode ((213321,-9603,-90081),(219243, -5386,-83215), 7)
	   AbreCam.AbreCam()
	   Bladex.KillMusic()
	   Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("EntradaTrampas"),))
	   Bladex.AddScheduledFunc(Bladex.GetTime()+2.0, ObjectMagicallyAppearing, ("PuenteAurelio_707", 10))
	else:
	   Bladex.GetEntity ("PuenteAurelio_707").SubscribeToList('Pin')


## Sala Runa
##-------------------------------------------------------------


def TransfusionTablilla():
	RoofPosition=(216963, -10895, -61000)
	Transfusion=Bladex.CreateEntity("Transfusion", "Entity Particle System D2", 0,0,0)
	Transfusion.Position = (216963, -8595, -61000)
	Transfusion.D = RoofPosition[0]-Transfusion.Position[0],RoofPosition[1]-Transfusion.Position[1],RoofPosition[2]-Transfusion.Position[2]

 	Transfusion.ParticleType="Chispas"
	Transfusion.YGravity=0.0
	Transfusion.Friction=0.3
	Transfusion.PPS=1024
	Transfusion.Velocity=40, -40.0, 0.0
	Transfusion.RandomVelocity=9.0
	Transfusion.Time2Live=60
	Transfusion.DeathTime=Bladex.GetTime()+10.0/60.0

	Transfusion=Bladex.CreateEntity("Transfusion", "Entity Particle System D1", 0,0,0)
	Transfusion.Position = (216963, -8595, -61000)
	Transfusion.ParticleType="Chispas"
	Transfusion.Friction=0.05
	Transfusion.YGravity=0.0
	Transfusion.PPS=512
	Transfusion.Velocity=40, -40.0, 0.0
	Transfusion.RandomVelocity=9.0
	Transfusion.Time2Live=60
	Transfusion.DeathTime=Bladex.GetTime()+0.25

def AlTipoTablilla():
	Transfusion=Bladex.CreateEntity("Transfusion", "Entity Particle System D1", 0,0,0)
	Transfusion.Position = (216963, -10895, -61000)
	Transfusion.ParticleType="Chispas"
	Transfusion.Friction=0.05
	Transfusion.YGravity=0.0
	Transfusion.PPS=512
	Transfusion.Velocity=40, -40.0, 0.0
	Transfusion.RandomVelocity=9.0
	Transfusion.Time2Live=60
	Transfusion.DeathTime=Bladex.GetTime()+10.0/60.0



def RunaTimer(entName,Time):
	global TRInicioRuna
	time = Bladex.GetTime()
	time = time-TRInicioRuna
	Runa=Bladex.GetEntity(entName)
	luzRuna=Bladex.GetEntity("luzRuna")
	factor=time/3
	if (factor <1.00) :
		Runa.Alpha = factor
		luzRuna.Intensity = factor*15 # 0 -> 15
	else :
		Runa.RemoveFromList("RunaTimer")
		Runa.TimerFunc=""
		luzRuna.SubscribeToList("Pin")
		luzRuna.RemoveFromWorld()
		AlTipoTablilla()


def EnciendeColumnaLuz ():
	luzsolida=Bladex.CreateEntity("LuzSolidaTablilla", "Entity Particle System D2", 216963, -10595, -61000)
	luzsolida.D = 0, 5000, 0
	luzsolida.ParticleType="LuzSolida"
	luzsolida.YGravity=0.0
	luzsolida.Friction=0.01
	luzsolida.PPS=10
	luzsolida.Velocity=0.0, 0.0, 0.0
	luzsolida.RandomVelocity=5.0
	luzsolida.Time2Live=240

def EnciendeRuna ():
	pj=Bladex.GetEntity('Player1')
	pj.Angle=0.0
	Runa=Bladex.GetEntity("Tablilla1")
	luzRuna=Bladex.CreateEntity("luzRuna","Entity Spot",Runa.Position[0], Runa.Position[1], Runa.Position[2])
	luzRuna.Color=230,200,230
	luzRuna.Intensity=0
	luzRuna.CastShadows=0
	luzRuna.Precission=0.06
	luzRuna.Visible=1
	luzRuna.Flick=0
	luzRuna.SizeFactor=0
	Runa.Link(luzRuna) 
	
TRInicioRuna=0.0
def ApareceRuna () :
	global TRInicioRuna	
	TRInicioRuna = Bladex.GetTime()
	Runa=Bladex.GetEntity("Tablilla1")
	Sonido_Concentracion.Play (Runa.Position[0], Runa.Position[1], Runa.Position[2],0)	
	EnciendeRuna ()
	Bladex.CreateTimer("RunaTimer",0.1)
	Runa.SubscribeToList("RunaTimer")
 	Runa.TimerFunc=RunaTimer;
 	TransfusionTablilla()

	
def LamparasRunasTimer (light, time):
	global TRInicioLamparasRunas
	time=Bladex.GetTime()
	time=time-TRInicioLamparasRunas
	luz = Bladex.GetEntity(light)
	factor=time/3
	if   (factor<1.00) :
		luz.FiresIntensity=[ 30 - factor*27.0] # 30->3
		luz.Lights = [(factor*5 , 0.03125, (255, 196, 128))] # 0 -> 5
	else:
		luz.RemoveFromList("Timer15")
		luz.TimerFunc=""


TRInicioLamparasRunas = 0
def EnciendeLamparasRunas ():
	global TRInicioLamparasRunas
	TRInicioLamparasRunas=Bladex.GetTime()
	luz=Bladex.GetEntity("Lamparaegipto_R1")
	luz.TimerFunc=LamparasRunasTimer
	luz.SubscribeToList("Timer15")
	luz=Bladex.GetEntity("Lamparaegipto_R2")
	luz.TimerFunc=LamparasRunasTimer
	luz.SubscribeToList("Timer15")
	luz=Bladex.GetEntity("Lamparaegipto_R3")
	luz.TimerFunc=LamparasRunasTimer
	luz.SubscribeToList("Timer15")
	luz=Bladex.GetEntity("Lamparaegipto_R4")
	luz.TimerFunc=LamparasRunasTimer
	luz.SubscribeToList("Timer15")


def EntraSalaRuna (SectorIndex,Entity_Name):
	if (Entity_Name!="Player1") : return
	global TRRuna
	TRRuna.OnEnter=None
	Bladex.GetGhostSectorSound('RioFinal5').Volume=1
	Bladex.GetGhostSectorSound('RioFinal6').Volume=1
	Bladex.GetGhostSectorSound('RioFinal7').Volume=1
	Bladex.ExeMusicEvent(Bladex.GetMusicEvent("RunaIntro"))
	pj=Bladex.GetEntity('Player1')
	Runa=Bladex.GetEntity("Tablilla1")
 	darfuncs.SetHint(Runa,Tr("Runa del Conocimiento"), 9, 6000)
	Runa=Bladex.GetEntity("Tablilla1")
	Runa.UseFunc=CogeRuna
 	AbreCam.ResetNode()
	AbreCam.AddNode ( (216199,-7981,-66573),(218570,-5690,-76013), 2)
	AbreCam.AddNode ( (213983,-9657,-67001),(222322,-5143,-63823), 4)
	AbreCam.AddNode ( (212684,-9501,-67924),(217723,-7669,-59482), 2)
	AbreCam.AddNode ( (212684,-9501,-67924),(217723,-7669,-59482), 10)
	
	AbreCam.LastTime=0
	AbreCam.AbreCam()
 	pj.GoTo (216815, -7070, -65223)
	Bladex.AddScheduledFunc(Bladex.GetTime()+7.0, EnciendeColumnaLuz, ())
	Bladex.AddScheduledFunc(Bladex.GetTime()+7.0, Actions.FreeBothHands, ("Player1",))
	Bladex.AddScheduledFunc(Bladex.GetTime()+9.0, ApareceRuna, ())
	Bladex.AddScheduledFunc(Bladex.GetTime()+11.0, EnciendeLamparasRunas, ())

def UnRegalo ():	
	pj=Bladex.GetEntity("Player1")
	pj.PartialLevel=0
	pj.Level=pj.Level+1
	Scorer.LevelUp()
	Scorer.SetLevelLimits(0,CharStats.GetCharExperienceCost(pj.CharType,pj.Level))
	maxlevel=CharStats.GetMaxLevel()
	maxsize=50+(140/maxlevel)*pj.Level # 50->190
	maxPPS=120+(600/maxlevel)*pj.Level # 120->720
	maxint=0.5+(4.5/maxlevel)*pj.Level # 0.5->5.0
	AuraParams=(5, 0, 1, 0, 0, 1)
	AuraGradient=(2, 0.4, 0.6, 1.0, 0.5, 0.0, 0.1, 0.2, 1.0, 0.0, 0.8)
	AuraVar1Args=(5, maxsize, 0, 1, 0.5)
	AuraVar2Args=(maxsize, 5, 1, 0, 1.0)
	PSParams=(pj.Data.LevelUpParticleData, "LevelUpParticle", 30, 50, 150, 255, maxPPS, -600, 0.0, 2, 2, 0.4, 30, 0.5)
	GenFX.LevelUpFX("Player1", 1, AuraParams, AuraGradient, AuraVar1Args, AuraVar2Args, PSParams, maxint, "Timer15", 15, "..\\..\\Sounds\\aparicion-escudo.wav")
	pj.Life = CharStats.GetCharMaxLife(pj.Kind, pj.Level)
	pj.ResetWounds()
	pj.Energy= CharStats.GetCharMaxEnergy(pj.Kind, pj.Level)
	if pj.Data.Poisoned:
		pj.Data.UnVenom ()

def InformaDelRegalo ():
	Scorer.SlideTBS(0)
	Scorer.LevelUpFlash()


def QuakePuente ():
	o=Bladex.GetEntity("QuitaMe")
	o.Position=152915, 1595, -132499
	o.Alpha=1.0
	o=Bladex.GetEntity("RocaPuente1")
	o.Position=147647.253314,1186.23273286,-128454.243087
	o=Bladex.GetEntity("RocaPuente2")
	o.Position=149363.263093, -384.53421863, -133841.677553
	o=Bladex.GetEntity("RocaPuente3")
	o.Position=149621.0,240.0,-130472.0
	o=Bladex.GetEntity("RocaPuente4")
	o.Position=150769.228228,1274.20598054,-129321.048464	
	o=Bladex.GetEntity("RocaPuente5")
	o.Position=150556.416105,1425.74051225,-134671.649687
	o=Bladex.GetEntity("RocaPuente6")
	o.Position=150518.970884,-2679.82875066,-135529.280937
#	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, Sonido_Quake.Play, (144352,-11853,-139067))
#	Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, Sonido_Quake.Play, (144352,-11853,-139067))
#	Bladex.AddScheduledFunc(Bladex.GetTime()+6.0, Sonido_Quake.Play, (144352,-11853,-139067))
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, Sonido_Quake.PlayStereo, ())
	Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, Sonido_Quake.PlayStereo, ())
	Bladex.AddScheduledFunc(Bladex.GetTime()+6.0, Sonido_Quake.PlayStereo, ())
	darfuncs.Temblores(6.0, 300)	
	AbreCam.ResetNode()
	AbreCam.AddNode ((144352,-11853,-139067),(152301,-10131,-133250), 0)
	AbreCam.AddNode ((144352,-11853,-139067),(152301,-10131,-133250), 7)
	AbreCam.AddNode ((144067,-14825,-132729),(149963,-6785,-131955), 3)
	AbreCam.AddNode ((144067,-14825,-132729),(149963,-6785,-131955), 2)
	AbreCam.LastTime=0
	if DIF_EASY:
	   AbreCam.CallBack=InformaDelRegalo
	AbreCam.AbreCam()
	
def CogeRuna (ent, usedfrom):
	Bladex.KillMusic()
	Bladex.ExeMusicEvent(Bladex.GetMusicEvent("Runa"))
	Actions.FreeBothHands ("Player1")
	GameText.WriteTextAux(Tr("La Runa del Conocimiento\nMuchos son los que han hablado\nde ella sin conocerla.\nMuchos los que la han buscado.\nAlgunos la tuvieron en sus manos.\nPero slo los elegidos llegarn a usarla.\n"),9.5,252,247,167,[],100)
 	AbreCam.ResetNode()
	AbreCam.AddNode ( (223829,-9517,-56920),(215333,-8756,-62139), 2)
	AbreCam.AddNode ( (223829,-9517,-56920),(215333,-8756,-62139), 13)
	AbreCam.AddNode ( (217300,-9160,-67781),(212605,-7123,-59190), 7)
	AbreCam.AddNode ( (213756,-9758,-60778),(204563,-5863,-61341), 2)
	AbreCam.AddNode ( (213756,-9758,-60778),(204563,-5863,-61341), 3)	
	AbreCam.CallBack=QuakePuente	
	AbreCam.LastTime=0
	AbreCam.AbreCam()	
	Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, Actions.FreeBothHands, ("Player1",))
	Bladex.AddScheduledFunc(Bladex.GetTime()+8.0, CogeRunaAhora, ())


def CogeRunaAhora ():
	Runa=Bladex.GetEntity("Tablilla1")
	Runa.UseFunc=None
	pj=Bladex.GetEntity('Player1')
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.5, pj.Data.TakeFunc, ('Player1',))
	if DIF_EASY:
	   Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, UnRegalo, ())
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.5, EstoSeHunde, ())

TRQuakeOn=0
def EstoSeHunde ():
	global TRQuakeOn
	TRQuakeOn=1
  	RunaQuake()
  	TiraColumna()
	TiraLamparas()
  	Bladex.AddScheduledFunc(Bladex.GetTime()+6.0, RompePuerta, ())
  	Bladex.AddScheduledFunc(Bladex.GetTime()+7.0, EscapaRuna, ())
  	Bladex.AddScheduledFunc(Bladex.GetTime()+8.0, RompeTecho, ())

def RunaQuake ():
	global TRQuakeOn
#	Sonido_Quake.Play(216963, -10895, -61000)
	Sonido_Quake.PlayStereo()
	darfuncs.Temblores(3.0, 100)	
	if TRQuakeOn==1:
	   Bladex.AddScheduledFunc(Bladex.GetTime()+4.0, RunaQuake, ())

def RompePuerta():
	global TRfinal
	Sonido_Derribo_Muro.Play(207823,-7275,-61024)
  	TRfinal.DoBreak ((-500, 0,0), (0,0,0), (0, 0, 0))

def RompeTecho():
	global TRTRuna
	Sonido_Derribo_Muro.Play(212497,-11122,-55221)
  	TRTRuna.DoBreak ((0,2500,-6000), (0,0,0), (0, 0, 0))
	MDPolvo('TRTecho',(212497,-11122,-55221))
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.6, MDPolvo, ('TRSuelo',(212497,-11122+3500,-55221)))
	
def TiraColumna():
	o=Bladex.GetEntity("Columnaestrecha_711")
	o.Static=0
	o.Impulse(1000000,1000000,1000000)
	pj=Bladex.GetEntity('Player1')
  	pj.LaunchAnmType('d_b')
	MDPolvo('Columnaestrecha_711',(o.Position[0],o.Position[1],o.Position[2]))

def TiraLamparas():
	luz=Bladex.GetEntity("Lamparaegipto_R1")
	Bladex.AddScheduledFunc(Bladex.GetTime(), luz.Impulse, (-15000,0,2000))
	luz.FiresIntensity=[ 30.0 ]
	luz.Lights = [(0.0, 0.03125, (255, 196, 128))]
	luz=Bladex.GetEntity("Lamparaegipto_R2")
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, luz.Impulse, (-17000,0,-3000))
	luz=Bladex.GetEntity("Lamparaegipto_R3")
	Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, luz.Impulse, (15000,1000,0))
	luz.FiresIntensity=[ 30.0 ]
	luz.Lights = [(0.0, 0.03125, (255, 196, 128))]
	luz=Bladex.GetEntity("Lamparaegipto_R4")
	Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, luz.Impulse, (-18000,0,2000))
	

def EscapaRuna():
	pj=Bladex.GetEntity('Player1')
	pj.GoToJogging=1
	pj.GoTo (203056., -7068., -61233.)

def BloqueaEntrada():

	Sonido_Derribo_Muro.Play(206724.0,-6620.0,-61579.0)
	MDPolvo('TRRuna',(206724.0,-8620.0,-61579.0))
	o=Bladex.CreateEntity("TRPiedra1","Menhir1",206724.0,-6620.0,-61579.0, Reference.ObjType("Menhir1"))
	o.Scale=0.2
	o.Orientation=(0.965925812721,-0.258819043636,0.0,0.0)
	o.Static=0
	o.Solid=1
	Sparks.SetStoneSparkling("TRPiedra1")	


	o=Bladex.CreateEntity("TRPiedra2","Menhir1",206124.0,-6820.0,-60775.0, Reference.ObjType("Menhir1"))
	o.Scale=0.2
	o.Orientation=(0.958191931248,0.285682916641,-0.000374875031412,0.0159176364541)
	o.Static=0
	o.Solid=1
	Sparks.SetStoneSparkling("TRPiedra2")	


	o=Bladex.CreateEntity("TRPiedra3","Menhir1",206524.0,-7020.0,-61179.0, Reference.ObjType("Menhir1"))
	o.Scale=0.2
	o.Orientation=(1.0,0.0,0.0,0.0)
	o.Static=0
	o.Solid=1
	Sparks.SetStoneSparkling("TRPiedra3")	


	o=Bladex.CreateEntity("TRPiedra4","Menhir1",206724.0,-7420.0,-60975.0, Reference.ObjType("Menhir1"))
	o.Scale=0.2
	o.Orientation=(0.956847190857,-0.100733473897,-0.0210437141359,0.271759718657)
	o.Static=0
	o.Solid=1
	Sparks.SetStoneSparkling("TRPiedra4")	


	o=Bladex.CreateEntity("TRPiedra5","Menhir1",206741.05245,-7563.67893353,-60503.9383584, Reference.ObjType("Menhir1"))
	o.Scale=0.2
	o.Orientation=(0.849018037319,-0.120971128345,-0.501210033894,0.115424618125)
	o.Static=0
	o.Solid=1
	Sparks.SetStoneSparkling("TRPiedra5")	


	MDPolvo('TRRuna',(206724.0,-6620.0,-61579.0))
	o=Bladex.CreateEntity("TRPiedra6","Menhir1",206704.87642,-7568.02097455,-61695.4863354, Reference.ObjType("Menhir1"))
	o.Scale=0.2
	o.Orientation=(0.766320466995,-0.157559067011,-0.588018417358,0.205334946513)
	o.Static=0
	o.Solid=1
	Sparks.SetStoneSparkling("TRPiedra6")	


	o=Bladex.CreateEntity("TRPiedra7","Menhir1",206724.0,-7820.0,-60575.0, Reference.ObjType("Menhir1"))
	o.Scale=0.3
	o.Orientation=(0.25784522295,-0.88511043787,0.124032080173,0.367030471563)
	o.Static=0
	o.Solid=1
	Sparks.SetStoneSparkling("TRPiedra7")	


	o=Bladex.CreateEntity("TRPiedra8","Menhir1",206724.0,-8020.0,-61379.0, Reference.ObjType("Menhir1"))
	o.Scale=0.2
	o.Orientation=(0.991444885731,-0.130526185036,0.0,0.0)
	o.Static=0
	o.Solid=1
	Sparks.SetStoneSparkling("TRPiedra8")	

	Sparks.DropStone (206724.0,-8620.0,-60579.0,-20000,1,1,"Piedra_04")
	Sparks.DropStone (206724.0,-8620.0,-61579.0,-20000,1,1,"Piedra_04")
	Sparks.DropStone (206724.0,-8620.0,-61579.0,-20000,1,25000,"Piedra_04")
	Sparks.DropStone (206724.0,-8620.0,-60579.0,-20000,1,-25000,"Piedra_04")

def PasilloRuna (SectorIndex,Entity_Name):
	if (Entity_Name!="Player1") : return
	global TRPasilloRuna
	TRPasilloRuna.OnEnter=None
	global TRQuakeOn
	pj=Bladex.GetEntity('Player1')
	pj.Angle=1.43690492316
	pj.GoToJogging=0
# 	AbreCam.ResetNode()
#	AbreCam.AddNode ( (201009,-8049,-61420),(210913,-8568,-60139), 2)
#	AbreCam.AddNode ( (198059,-8114,-61574),(207625,-6076,-59491), 2)
#	AbreCam.AddNode ( (198059,-8114,-61574),(207625,-6076,-59491), 3)
#	AbreCam.LastTime=0
#	AbreCam.CallBack=QuakePuente
#	AbreCam.AbreCam()	
	Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, BloqueaEntrada, ())
	TRQuakeOn=0

## Salida Trampas
##-------------------------------------------------------------


def TRAbreSalida ():
	global TRdsal, TRCampamento
	TRdsal.OpenDoor()
	SetLevelAndLife ("Great_Ork_Camp_792", 8)
	darfuncs.UnhideBadGuy  ("Great_Ork_Camp_792")
	SetLevelAndLife ("Great_Ork_Camp_796", 7)
        darfuncs.UnhideBadGuy  ("Great_Ork_Camp_796")
        SetLevelAndLife ("Ork_Camp_799", 6)
        darfuncs.UnhideBadGuy  ("Ork_Camp_799")
	TRCampamento.OnEnter=EntraCampamento


def TRCierraSalida ():
	global TRdsal
	TRdsal.CloseDoor()	
	
	
def EntraCampamento (SectorIndex,Entity_Name):
	if (Entity_Name!="Player1") : return
	global TRdsal, TRCampamento
	TRCampamento.OnEnter=None
	if TRdsal.status == Doors.OPENED:
	   TRCierraSalida ()
	   Bladex.KillMusic()
    	   Bladex.ExeMusicEvent (Bladex.GetMusicEvent("LuchaCorta"))
	Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, PreparaEmboscadaFinal, ())

##-------------------------------------------------------------
## Emboscada final: Bolitas.
##-------------------------------------------------------------


def YAhoraNosotros ():
	o=Bladex.GetEntity("Great_Ork_Bolitas_907")
	o.Blind=0
	o.Deaf=0
	o.SetActiveEnemy ("Player1")
	o=Bladex.GetEntity("Ork_Bolitas_909")
	o.Blind=0
	o.Deaf=0
	o.Data.StdEnterLarge(o.Name)
	o=Bladex.GetEntity("Great_Ork_Bolitas_910")
	o.Blind=0
	o.Deaf=0
	o.SetActiveEnemy ("Player1")

def ActivateBolitas (SectorIndex,Entity_Name):
	global TRBLT
	if Entity_Name != 'Player1': return
	Bladex.AddScheduledFunc(Bladex.GetTime() + 1.5, LaDespedida, ())	
	TRBLT.OnEnter=None

def ParaBolitas ():
	o=Bladex.GetEntity("Bolita1")
	o.Mass=200000
	Sparks.SetStoneSparkling(o.Name)
	o=Bladex.GetEntity("Bolita3")
	o.Mass=200000
	Sparks.SetStoneSparkling(o.Name)

def TomaBolitas():
	Bladex.AddScheduledFunc(Bladex.GetTime(), stone.drop, ( "Bolita1", -999999,0,999999 ))
	#Bladex.AddScheduledFunc(Bladex.GetTime(), stone.drop, ( "Bolita2", 0,0,9999999 ))
	Bladex.AddScheduledFunc(Bladex.GetTime(), stone.drop, ( "Bolita3", 999999,0,999999 ))
	Bladex.AddScheduledFunc(Bladex.GetTime()+6.5, Sonido_Derribo_Muro.Play, ( 157761.033825, -4068.76244886, -98408.3037712 ))
	Bladex.AddScheduledFunc(Bladex.GetTime()+8.0, ParaBolitas, ())

	Bladex.AddScheduledFunc(Bladex.GetTime()+5.0, YAhoraNosotros, ())

def LaDespedida ():
	Bladex.AddScheduledFunc(Bladex.GetTime()+2.5, TomaBolitas, ())
	AbreCam.ResetNode()
	AbreCam.AddNode ( (157869,-6907,-98305),(164403,-7422,-105858), 2)
	AbreCam.AddNode ( (157869,-6907,-98305),(164403,-7422,-105858), 2)
	AbreCam.AbreCam()
	pj=Bladex.GetEntity('Player1')
	pj.GoTo (157761.033825, -4068.76244886, -98408.3037712)
	global TheEnd
	TheEnd.OnEnter=HolaAmigos
	Glofror=Bladex.GetEntity("Glofror")
	Glofror.Position=157675.834325, -5778.01085755, -146406.658941
	Glofror.Angle=1.83760349263
	darfuncs.UnhideBadGuy('Glofror')
	Elglar=Bladex.GetEntity("Elglar")
	Elglar.Position=157112.548652, -5312.13064338, -144239.661154
	Elglar.Angle=2.66920915626
	darfuncs.UnhideBadGuy('Elglar')
	global TheEndRlx
	TheEndRlx.OnEnter=TheEndStop

def PreparaEmboscadaFinal(): 
	global TRBLT
	p=167132.962003,-7124.43027741,-103935.42534
	r=0.707107,0.707107,0.000000,0.000000
	o=heavyObjects.CreateHeavyObject("Bolita1","BoladePiedra",p,r,1.0, heavyObjects.StoneHitEvent )
	o.Scale=0.7
	o.SendTriggerSectorMsgs=1
	stone.lock( o.Name, stone.DROPBROWNDUST, +3000, 1100, -3000.0, 0.6, 6.5, stone.STONESOUND, 0.1 ) 

	#p=167009.304959, -8220.20233366, -107526.884513
	#r=0.707107,0.707107,0.000000,0.000000
	#o=heavyObjects.CreateHeavyObject("Bolita2","BoladePiedra",p,r,1.0, heavyObjects.StoneHitEvent )
	#o.Scale=0.7
	#o.SendTriggerSectorMsgs=1
	#stone.lock( o.Name, stone.DROPBROWNDUST, +3000, 1100, -3000.0, 0.6, 6.5, stone.STONESOUND, 0.1 ) 

	p=161603.101292,-7220.12406621,-110820.966884
	r=0.707107,0.707107,0.000000,0.000000
	o=heavyObjects.CreateHeavyObject("Bolita3","BoladePiedra",p,r,1.0, heavyObjects.StoneHitEvent )
	o.Scale=0.7
	o.SendTriggerSectorMsgs=1
	stone.lock( o.Name, stone.DROPBROWNDUST, +3000, 1100, -3000.0, 0.6, 6.5, stone.STONESOUND, 0.1 ) 
	
	o=Bladex.CreateEntity("Hoguera_921","Hoguera",165040.073173,-6880.69797676,-109630.718319, Reference.ObjType("Hoguera"))
	o.Scale=1.0
	o.Orientation=(0.777406275272,0.62497895956,-0.06182987988,-0.0348968617618)
	o.FiresIntensity=[ 3.0 ]
	o.Lights = [(10.0, 0.03125, (255, 196, 128))]

	
	SetLevelAndLife ("Great_Ork_Bolitas_907", 8)
	darfuncs.UnhideBadGuy ("Great_Ork_Bolitas_907")
	o=Bladex.GetEntity("Great_Ork_Bolitas_907")
	o.Blind=1
	o.Deaf=1
	SetLevelAndLife ("Ork_Bolitas_909", 5)
	darfuncs.UnhideBadGuy ("Ork_Bolitas_909")
	o=Bladex.GetEntity("Ork_Bolitas_909")
	o.Blind=1
	o.Deaf=1
	SetLevelAndLife ("Great_Ork_Bolitas_910", 8)
	darfuncs.UnhideBadGuy ("Great_Ork_Bolitas_910")
	o=Bladex.GetEntity("Great_Ork_Bolitas_910")
	o.Blind=1
	o.Deaf=1

	TRBLT=Bladex.GetSector(159315.941999, -4070.3354757, -98825.2727671)
	TRBLT.OnEnter=ActivateBolitas  	   

	# Elimina orcos fase 1
	pers=Bladex.GetEntity("Great_Ork_Bolitas_1_907")
	if pers:
	   pers.SubscribeToList('Pin')
	pers=Bladex.GetEntity("Ork_Bolitas_1_909")
	if pers:
	   pers.SubscribeToList('Pin')



##-------------------------------------------------------------
## Eso es todo amigos
##-------------------------------------------------------------

def NosVamos ():
	Bladex.DeactivateInput()
#	Talk.Hide ()
	Scorer.PowDefWidgets.Deactivate()
#	if Reference.DEMO_MODE==0:
#		Bladex.AddScheduledFunc(Bladex.GetTime() + 4.0, GotoMapVars.EndOfLevel, ())
#		GotoMapVars.MapText(4,"D_M4_T2")
#	else:
	Bladex.AddScheduledFunc(Bladex.GetTime()+2.0,ShowTheEnd,())
	Bladex.AddScheduledFunc(Bladex.GetTime()+5.0,AuxFuncs.FadeTo,(1.0, 5.0, 0, 0, 0))
	Bladex.AddScheduledFunc(Bladex.GetTime()+7.0,Bladex.LoadLevel,("Casa",))
			
def HolaAmigos (SectorIndex,Entity_Name):
	global TheEnd
	if Entity_Name != 'Player1': return
	#Select.TurnOffAutoSelect(Entity_Name)
	#Bladex.SetAutoEngageCombat(0)
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.3, Talk.Assign, ('Glofror', 'Lo has conseguido', Talk.SeeEvent))	

	   
def GoToEnd1 ():
	Bladex.DeactivateInput()
	Bladex.RemoveBoundFunc("Attack","Attack")
	pj=Bladex.GetEntity('Player1')
	Bladex.AddScheduledFunc(Bladex.GetTime(), pj.GoTo , (155291.462861, -6139.86572057, -148358.374273))	
	pj.GoTo (155291.462861, -6139.86572057, -148358.374273)
	pj.RouteEndedFunc = GoToEnd2

def GoToEnd2 (entityName):
	Bladex.DeactivateInput()
	Bladex.RemoveBoundFunc("Attack","Attack")
	pj=Bladex.GetEntity('Player1')
	pj.Angle=4.116089522
	pj.GoTo (166778.477644, -9053.15204007, -154720.087078)
	pj.RouteEndedFunc = GoToEnd3
	Glofror=Bladex.GetEntity("Glofror")
    	Bladex.AddScheduledFunc(Bladex.GetTime()+2.0, Glofror.Data.Sigueme, ())	
	Elglar=Bladex.GetEntity("Elglar")
    	Bladex.AddScheduledFunc(Bladex.GetTime()+2.5, Elglar.Data.Sigueme, ())	

def GoToEnd3 (entityName):
	Bladex.DeactivateInput()
	Bladex.RemoveBoundFunc("Attack","Attack")
	pj=Bladex.GetEntity('Player1')
	pj.Angle=4.4
	pj.GoTo (171641.735332, -9066.90142618, -156970.657009)
	Glofror=Bladex.GetEntity("Glofror")
    	Glofror.Data.Parate()
	Elglar=Bladex.GetEntity("Elglar")
    	Elglar.Data.Parate()	
	pj.RouteEndedFunc = GoToEnd4

def GoToEnd4 (entityName):
	Bladex.DeactivateInput()
	Bladex.RemoveBoundFunc("Attack","Attack")
	pj=Bladex.GetEntity('Player1')
	pj.Angle=4.1
	pj.GoTo (185763.703393, -3327.39259849, -177680.371218)
	Glofror=Bladex.GetEntity("Glofror")
    	Bladex.AddScheduledFunc(Bladex.GetTime()+2.0, Glofror.Data.Sigueme, ())	
	Elglar=Bladex.GetEntity("Elglar")
    	Bladex.AddScheduledFunc(Bladex.GetTime()+2.5, Elglar.Data.Sigueme, ())	
	pj.RouteEndedFunc = StopPlayer

def StopPlayer (entityName):
	Bladex.DeactivateInput()
	Bladex.RemoveBoundFunc("Attack","Attack")
	pj=Bladex.GetEntity('Player1')
	pj.SetActiveEnemy(None)
	pj.Wuea=Reference.WUEA_ENDED
  	pj.SetTmpAnmFlags(1,1,1,0,5,1,0)	  
	pj.LaunchAnmType('Rlx')
	pj.Freeze()

def TheEndStop (SectorIndex,Entity_Name):
	Bladex.DeactivateInput()
	Bladex.RemoveBoundFunc("Attack","Attack")
	if (Entity_Name!="Player1") : return
	global TheEndRlx
	TheEndRlx.OnEnter=None
	finalText=Tr(
	   """Glofror y Elglar continuarn su viaje a Gondor. """\
	   """No quedan esbirros de Sauron en la zona pero el camino """\
	   """hasta Moria ser largo.\n """\
	   """All te espera el Libro de Celebrimbor... incluso puede que """\
	   """ un Nazgl aceche en la sombra. Tal vez la Runa del """\
	   """ Conocimiento pueda ayudarte... """)
   	Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, Talk.ShowMessage, (finalText, 25))

def ToBeContinued (personName, dlgId):
	Bladex.DeactivateInput()
	Bladex.RemoveBoundFunc("Attack","Attack")
	pj=Bladex.GetEntity('Player1')
	pj.SetActiveEnemy(None)
	pj.Wuea=Reference.WUEA_ENDED
  	pj.SetTmpAnmFlags(1,1,1,0,5,1,0)	  
  	Bladex.KillMusic()
    	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("Leyendas"),))
	Scorer.PowDefWidgets.Deactivate()
	AbreCam.ResetNode()	
	AbreCam.AddNode ((151108,-9366,-143331),(156121,-2674,-148818),4)
	AbreCam.AddNode ((150517,-10031,-145554),(158394,-8582,-151543),8)
	AbreCam.AddNode ((128160,-19498,-131039),(136423,-16033,-135480),7)
	AbreCam.AddNode ((128160,-19498,-131039),(136423,-16033,-135480),20)
	AbreCam.AbreCam()

#	AbreCam.AddNode ((152646,-11361,-149258),(156022,-4996,-142333),4)
#	AbreCam.AddNode ((151108,-9366,-143331),(156121,-2674,-148818),4)
#	AbreCam.AddNode ((150517,-10031,-145554),(158394,-8582,-151543),6)
#	AbreCam.AddNode ((128160,-19498,-131039),(136423,-16033,-135480),7)
#	AbreCam.AddNode ((128160,-19498,-131039),(136423,-16033,-135480),18)

   	Bladex.AddScheduledFunc(Bladex.GetTime()+0.3, GoToEnd1, ())
 	Bladex.AddScheduledFunc(Bladex.GetTime()+30.0,NosVamos,())
Talk.AddCallBackFunc ('ToBeContinued', ToBeContinued)
	 	   

# That's All Folks! 


TheEndWidget=None
def CreateTheEndWidget ():
	global TheEndWidget
	TheEndWidget=BUIx.B_BitmapWidget(Scorer.wFrame,"TheEnd",342,165,"Taf", "../Moria/End.mmp")
	TheEndWidget.SetColor(255,255,255)
	Scorer.wFrame.AddWidget(TheEndWidget,138,80,BUIx.B_FrameWidget.B_FR_AbsoluteLeft,BUIx.B_FrameWidget.B_FR_Left,BUIx.B_FrameWidget.B_FR_AbsoluteTop,BUIx.B_FrameWidget.B_FR_Top)
#	TheEndWidget.SetAlpha(0.0)
	TheEndWidget.SetAlpha(1.0)
	TheEndWidget.SetVisible(1)
	TheEndWidget.SetAutoScale(1)
	Bladex.AddMusicEventWAV("TheEnd","..\\Moria\\TheEnd.wav",    0.1, 1.0, 1.0, 200, 0, 0 )

	
TheEndInicio=0
def ShowTheEnd ():
	global TheEndInicio
	CreateTheEndWidget ()
#	pj=Bladex.GetEntity('Player1')
#	pj.TimerFunc=TheEndTimer
#	pj.SubscribeToList("Timer15")
#	TheEndInicio=Bladex.GetTime()
	Bladex.KillMusic()
	Bladex.ExeMusicEvent(Bladex.GetMusicEvent("TheEnd"))


def TheEndTimer (ent,time):
	global TheEndInicio, TheEndWidget
	time=Bladex.GetTime()
	time=time-TheEndInicio
	factor=time/3
	TheEndWidget.SetAlpha(factor*1.0)
	if (factor>1.00) :
		pj=Bladex.GetEntity('Player1')
		pj.RemoveFromList("Timer15")
		pj.TimerFunc=""
