################################################################################
# Define custom enemy classes for MoriaMod
################################################################################
import Bladex
import Enm_Def
import Reference
import AllyCombat
import Combat
import AuxTran
import AniSound
import pdb
import BCopy
import math
import whrandom
import Actions
import Interpolator
import CharStats
import ItemTypes
import AuxFuncs
import Sparks
import Objects
import InitDataField
import Blood
import dust
import B3DLib
import Damage
import darfuncs
import GenFX
import OnOff
import DMusic
import ObjStore
import GameText
import Change
import ScorerActions

from Tr import Tr
import Ally_Def
import def_class



#
# Boolean value
#
TRUE = 1==1
FALSE = not TRUE


################################################################################
# Define the Dwarf_Ally class
################################################################################
class Dwarf_Ally (Ally_Def.NPCAlly):
	def __init__(self, me):
		# base class init
		Ally_Def.NPCAlly.__init__(self, me)
		#print "Personage Creado",me.Name,self.changed_func

		# Set up traitor knight specific sound priorities
		self.SoundPriorities[Reference.SND_ARROW]   = 10.0
		self.SoundPriorities[Reference.SND_HIT]     = 50.0
		self.SoundPriorities[Reference.SND_NPC]     = 25.0
		self.SoundPriorities[Reference.SND_NOISYPC] = 30.0
		self.SoundPriorities[Reference.SND_PC]      = 80.0
		
		# Esconde al traitor
		me.SetMesh ('DwfSkin1')
		Reference.EnemiesScorerData[self.Name]=("DwarfIcon3","Dwarf")

		# Un enano paciente
		self.HLCFunc = self.StdHLCFunc
	
	def ResetSounds(self, EntityName):
		me=Bladex.GetEntity(EntityName)
		AniSound.AsignarSonidosEnano(EntityName)
		Reference.EnemiesScorerData[self.Name]=("DwarfIcon3","Dwarf")

	# Functions for loading and saving state
	def __getstate__(self):	
		#print "Changed Funcs",self.changed_func
		
		NPCAlly_state=Ally_Def.NPCAlly.__getstate__(self)
		if(NPCAlly_state[0]!=1):
			print "ERROR: Dwarf_Ally.__getstate__(): Base class version differs."
			return NPCAlly_state
		NPCAlly_state[1]["Dwarf_Ally"]=()
		return NPCAlly_state
	
	def __setstate__(self,parm):
		# Toma como parmetro lo que devuelve __getstate__() y debe recrear la clase
		Ally_Def.NPCAlly.__setstate__(self,parm)

	def ResetCombat (self,EntityName):		
		Ally_Def.NPCAlly.ResetCombat(self, EntityName)
		me = Bladex.GetEntity(EntityName)	
		if me and me.Life>0:
			self.AttacksOwnKind=TRUE
			self.AttackNPCTime = 1.5
			me.BlockingPropensity = 0.7
			me.AttackList = BCopy.deepcopy(GlofrorAttackData)
			self.ChanceOfFuryOnHurt = 0.25
			self.ChanceOfFuryOnLeaderDeath = 1.00

	def StdHLCFunc (self, entityName):
		GameText.WriteTextAux(entityName+":  "+Tr("Hey ten cuidado con ese arma!!!"),2.0,252,247,167,[],100)

################################################################################
# Define the Dummy_Ally class
################################################################################
class Dummy_Ally (Ally_Def.NPCAlly):
	def __init__(self, me):
		# base class init
		Ally_Def.NPCAlly.__init__(self, me)
		#print "Personage Creado",me.Name,self.changed_func

		# Set up traitor knight specific sound priorities
		self.SoundPriorities[Reference.SND_ARROW]   = 10.0
		self.SoundPriorities[Reference.SND_HIT]     = 50.0
		self.SoundPriorities[Reference.SND_NPC]     = 25.0
		self.SoundPriorities[Reference.SND_NOISYPC] = 30.0
		self.SoundPriorities[Reference.SND_PC]      = 80.0
		
		# Esconde al traitor
		me.SetMesh ('KgtSkin2')
		Reference.EnemiesScorerData[self.Name]=("KnightIcon","Knight")

		# La Paciencia sin lmites
		self.HLCFunc = self.StdHLCFunc
	
	def ResetSounds(self, EntityName):
		me=Bladex.GetEntity(EntityName)
		AniSound.AsignarSonidosCaballero(EntityName)
		Reference.EnemiesScorerData[self.Name]=("KnightIcon","Knight")

	# Functions for loading and saving state
	def __getstate__(self):	
		#print "Changed Funcs",self.changed_func
		
		NPCAlly_state=Ally_Def.NPCAlly.__getstate__(self)
		if(NPCAlly_state[0]!=1):
			print "ERROR: Dummy_Ally.__getstate__(): Base class version differs."
			return NPCAlly_state
		NPCAlly_state[1]["Dummy_Ally"]=()
		return NPCAlly_state
	
	def __setstate__(self,parm):
		# Toma como parmetro lo que devuelve __getstate__() y debe recrear la clase
		Ally_Def.NPCAlly.__setstate__(self,parm)

	def ResetCombat (self,EntityName):		
		pass

	def StdHLCFunc (self, entityName):
		GameText.WriteTextAux(entityName+":  "+Tr("Hey ten cuidado con ese arma!!!"),2.0,252,247,167,[],100)


# Si no quieres que ataque por su cuenta
#	def MyGetEnemyName (self):
#		self.DesencaraPlayer1()
#		#me=Bladex.GetEntity(self.Name)
#                #me.SetEnemy(None)
#                self.EnemyName=None
#		return self.EnemyName


################################################################################
# Define the Knight_Skl class
################################################################################
class Knight_Skl (Enm_Def.NPCPerson):
	def __init__(self, me):
		# base class init
		Enm_Def.NPCPerson.__init__(self, me)
		#print "Personage Creado",me.Name,self.changed_func

		# Set up traitor knight specific sound priorities
		self.SoundPriorities[Reference.SND_ARROW]   = 10.0
		self.SoundPriorities[Reference.SND_HIT]     = 50.0
		self.SoundPriorities[Reference.SND_NPC]     = 25.0
		self.SoundPriorities[Reference.SND_NOISYPC] = 30.0
		self.SoundPriorities[Reference.SND_PC]      = 80.0
		me.ImDeadFunc=self.ImDeadFunc
	
	def ResetSounds(self, EntityName):
		#AniSound.AsignarSonidosCaballeroTraidor(EntityName)
		AniSound.AsignarSonidosEsqueleto(EntityName)
		
		per=Bladex.GetEntity(EntityName)
		from AniSoundSklX import *
		per.AddAnimSound('Tkn_g_21', EsfuerzoCorto3Skl, 0.2000)
		per.AddAnimSound('Tkn_g_21', EsfuerzoCorto2Skl, 0.6778)
		per.AddAnimSound('Kgt_g_escape', EsfuerzoSklMediano, 0.3529)
		per.AddAnimSound('Tkn_g_d_r', EsfuerzoCorto2Skl, 0.5059)
		per.AddAnimSound('Tkn_g_d_l', EsfuerzoSklMediano, 0.4725)
		per.AddAnimSound('Tkn_g_d_l', EsfuerzoCorto3Skl, 0.4725)
		per.AddAnimSound('Tkn_g_03', EsfuerzoCorto5Skl, 0.2388)
		per.AddAnimSound('Tkn_g_01', EsfuerzoCortoSkl, 0.3117)
		per.AddAnimSound('Tkn_g_02', EsfuerzoCorto1Skl, 0.3026)
		per.AddAnimSound('Tkn_g_05', EsfuerzoCorto2Skl, 0.5000)
		per.AddAnimSound('Tkn_g_06', EsfuerzoCorto3Skl, 0.4342)
		per.AddAnimSound('Tkn_g_07', EsfuerzoCorto4Skl, 0.3291)
		per.AddAnimSound('Tkn_g_08', EsfuerzoCorto5Skl, 0.4030)
		per.AddAnimSound('Tkn_g_09', EsfuerzoCorto6Skl, 0.3291)
		per.AddAnimSound('Tkn_g_11', EsfuerzoGolpeFrontalSkl, 0.2252)
		per.AddAnimSound('Tkn_g_12', EsfuerzoGolpeFrontalSkl, 0.5954)
		per.AddAnimSound('Tkn_g_13', EsfuerzoGolpeFrontalSkl, 0.3053)
		per.AddAnimSound('Tkn_g_14', EsfuerzoGolpeLateralSkl, 0.3969)
		per.AddAnimSound('Tkn_g_15', EsfuerzoGolpeLateralSkl, 0.4628)
		per.AddAnimSound('Tkn_g_16', EsfuerzoGolpeLateralSkl, 0.3200)
		per.AddAnimSound('Tkn_g_17', EsfuerzoGolpeLateralSkl, 0.4200)
		per.AddAnimSound('Tkn_g_18', EsfuerzoGolpeArribaSkl, 0.4224)
		per.AddAnimSound('Tkn_g_22', EsfuerzoGolpeAtrasSkl, 0.4698)
		per.AddAnimSound('Tkn_g_26', EsfuerzoGolpeCabezaSkl, 0.3940)
		per.AddAnimSound('Tkn_g_31', EsfuerzoGolpeAtrasSkl, 0.2950)
		per.AddAnimSound('Tkn_clmb_medlow_1h', EsfuerzoCortoSkl, 0.2400)
		per.AddAnimSound('Tkn_clmb_medium_1h', EsfuerzoCortoSkl, 0.1389)
		per.AddAnimSound('Tkn_clmb_medlow_no', EsfuerzoCortoSkl, 0.4000)
		per.AddAnimSound('Tkn_clmb_medium_no', EsfuerzoCortoSkl, 0.1944)
		per.AddAnimSound('Tkn_clmb_high_no', EsfuerzoCortoSkl, 0.1552)
		per.AddAnimSound('Tkn_clmb_medium_1h', EsfuerzoCortoSkl, 0.1389)
		per.AddAnimSound('Tkn_clmb_high_1h', EsfuerzoSklMediano, 0.1000)
		per.AddAnimSound('Tkn_clmb_high_1h', EsfuerzoCortoSkl, 0.7862)
		per.AddAnimSound('Tkn_clmb_medium_no', EsfuerzoCortoSkl, 0.1944)
		per.AddAnimSound('Tkn_clmb_high_no', EsfuerzoSklMediano, 0.1552)
		per.AddAnimSound('Tkn_clmb_high_no', EsfuerzoCortoSkl, 0.1552)
		per.AddAnimSound("Tkn_dth_n00", MuerteSkl1, 0.1200)
		per.AddAnimSound("Tkn_dth_n00", Caida, 0.8000)
		per.AddAnimSound("Tkn_dth_n01", MuerteSkl2, 0.1100)
		per.AddAnimSound("Tkn_dth_n01", Caida, 0.7800)
		per.AddAnimSound("Tkn_dth_n02", MuerteSkl3, 0.1200)
		per.AddAnimSound("Tkn_dth_n02", Caida, 0.8000)
		per.AddAnimSound("Tkn_dth_n03", MuerteSkl4, 0.1200)
		per.AddAnimSound("Tkn_dth_n03", Caida, 0.7550)
		per.AddAnimSound("Tkn_dth_n04", MuerteSkl4, 0.1100)
		per.AddAnimSound("Tkn_dth_n04", Caida, 0.7600)
		per.AddAnimSound("Tkn_dth_n05", MuerteSkl4, 0.1100)
		per.AddAnimSound("Tkn_dth_n05", Caida2, 0.7700)
		per.AddAnimSound("Tkn_dth_n06", MuerteSkl2, 0.1200)
		per.AddAnimSound("Tkn_dth_n06", Caida, 0.7900)
		per.AddAnimSound("Tkn_dth_c1", MuerteSkl4, 0.1250)
		per.AddAnimSound("Tkn_dth_c1", Caida, 0.7800)
		per.AddAnimSound("Tkn_dth_c1", MuerteSkl1, 0.2500)
		per.AddAnimSound("Tkn_dth_c2", MuerteSkl4, 0.1250)
		per.AddAnimSound("Tkn_dth_c2", MuerteSkl1, 0.2500)
		per.AddAnimSound("Tkn_dth_c2", Caida, 0.7720)
		per.AddAnimSound("Tkn_dth_c2", Caida2, 0.8720)
		per.AddAnimSound("Tkn_dth_c3", MuerteSkl1, 0.1250)
		per.AddAnimSound("Tkn_dth_c3", MuerteSkl1, 0.2500)
		per.AddAnimSound("Tkn_dth_c3", Caida, 0.7220)
		per.AddAnimSound("Tkn_dth_c4", MuerteSkl1, 0.1250)
		per.AddAnimSound("Tkn_dth_c4", MuerteSkl1, 0.2500)
		per.AddAnimSound("Tkn_dth_c4", Caida, 0.7000)
		per.AddAnimSound("Tkn_dth_c4", Caida2, 0.8720)
		per.AddAnimSound("Tkn_dth_c5", MuerteSkl1, 0.1250)
		per.AddAnimSound("Tkn_dth_c5", MuerteSkl1, 0.2500)
		per.AddAnimSound("Tkn_dth_c5", Caida, 0.7720)
		per.AddAnimSound("Tkn_dth_c5", Caida2, 0.5500)
		per.AddAnimSound("Tkn_dth_c6", MuerteSkl1, 0.1250)
		per.AddAnimSound("Tkn_dth_c6", MuerteSkl1, 0.2500)
		per.AddAnimSound("Tkn_dth_c6", Caida, 0.7700)
		per.AddAnimSound('Tkn_dth_i1', MuerteSkl1, 0.1000)
		per.AddAnimSound('Tkn_dth_i2', MuerteSkl1, 0.1000)
		per.AddAnimSound('Tkn_dth_bl1', MuerteSkl2, 0.1000)
		per.AddAnimSound('Tkn_dth_bl2', MuerteSkl3, 0.1000)
		per.AddAnimSound('Tkn_dth_rock', MuerteSkl1, 0.1000)
		per.AddAnimSound('Tkn_hurt_jog', HeridaSkl1, 0.2000)
		per.AddAnimSound('Tkn_hurt_neck', HeridaSkl1, 0.2000)
		per.AddAnimSound('Tkn_hurt_breast', HeridaSkl1, 0.2000)
		per.AddAnimSound('Tkn_hurt_back', HeridaSkl1, 0.2000)
		per.AddAnimSound('Tkn_hurt_r_arm', HeridaSkl2, 0.2000)
		per.AddAnimSound('Tkn_hurt_l_arm', HeridaSkl2, 0.2000)
		per.AddAnimSound('Tkn_hurt_r_leg', HeridaSkl2, 0.2000)
		per.AddAnimSound('Tkn_hurt_l_leg', HeridaSkl2, 0.2000)
		per.AddAnimSound('Tkn_hurt_f_neck', HeridaSkl3, 0.2000)
		per.AddAnimSound('Tkn_hurt_f_breast', HeridaSkl3, 0.2000)
		per.AddAnimSound('Tkn_hurt_f_back', HeridaSkl3, 0.2000)
		per.AddAnimSound('Tkn_hurt_f_r_arm', HeridaSkl2, 0.2000)
		per.AddAnimSound('Tkn_hurt_f_l_arm', HeridaSkl2, 0.2000)
		per.AddAnimSound('Tkn_hurt_f_r_leg', HeridaSkl2, 0.2000)
		per.AddAnimSound('Tkn_hurt_f_l_leg', HeridaSkl2, 0.2000)
		per.AddAnimSound('Tkn_hurt_f_lite', HeridaSkl3, 0.2000)
		per.AddAnimSound('Tkn_hurt_f_big', HeridaSkl3, 0.2000)
		per.AddAnimSound('Tkn_hurt_head', HeridaSkl3, 0.2000)
		per.AddAnimSound('Wlk_2h_Tkn',Relax1, 0.5000)
		per.AddAnimSound('Wbk_2h_Tkn',Relax2, 0.5000)
		per.AddAnimSound('Wlk_2h_Tkn',Relax1, 0.5000)
		per.AddAnimSound('Wbk_2h_Tkn',Relax2, 0.5000)
		per.AddAnimSound('Tkn_attack_l',Relax2, 0.5000)
		per.AddAnimSound('Tkn_attack_r_s',Relax1, 0.5000)
		per.AddAnimSound('Tkn_attack_b_s',Relax2, 0.5000)
		per.AddAnimSound('Jog_1h_Tkn',Relax1, 0.1100)
		per.AddAnimSound('Jog_2h_Tkn',Relax1, 0.1100)
		per.AddAnimSound('Rlx_1h_Tkn',Relax2, 0.5000)
		per.AddAnimSound('Rlx_2h_Tkn',Relax2, 0.5000)
		per.AddAnimSound('Rlx_no_Tkn',Relax1, 0.1500)
		per.AddAnimSound('Rlx_no_Tkn',Relax1, 0.7000)
		from AniSoundKgtX import *
		per.AddAnimSound('Kgt_g_32_5_3new', EsfuerzoSklMediano, 0.185)
		per.AddAnimSound('Kgt_g_32_5_3new', SesgadoEspecialCorto2, 0.186)
		per.AddAnimSound('Kgt_g_32_5_3new', EsfuerzoGolpeAtrasSkl, 0.274)
		per.AddAnimSound('Kgt_g_32_5_3new', SesgadoEspecialLargo1, 0.294)
		per.AddAnimSound('Kgt_g_32_5_3new', AndarKgt2, 0.700)
		per.AddAnimSound('Kgt_g_32_5_3new', EsfuerzoGolpeAtrasSkl, 0.508)
		per.AddAnimSound('Kgt_g_32_5_3new', SesgadoEspecialLargo2, 0.518)

	

	# Functions for loading and saving state
	def __getstate__(self):	
		#print "Changed Funcs",self.changed_func
		
		NPCPerson_state=Enm_Def.NPCPerson.__getstate__(self)
		if(NPCPerson_state[0]!=1):
			print "ERROR: Knight_Skl.__getstate__(): Base class version differs."
			return NPCPerson_state
		NPCPerson_state[1]["Knight_Skl"]=()
		return NPCPerson_state
	
	def __setstate__(self,parm):
		# Toma como parmetro lo que devuelve __getstate__() y debe recrear la clase
		Enm_Def.NPCPerson.__setstate__(self,parm)

	def ResetCombat (self,EntityName):		
		Enm_Def.NPCPerson.ResetCombat(self, EntityName)
		me = Bladex.GetEntity(EntityName)
		if me and me.Life>0:
			self.AttacksOwnKind=TRUE
			self.AttackNPCTime = 1.5
			me.BlockingPropensity = 0.7
			me.AttackList = BCopy.deepcopy(KnightSklAttackData)
			self.ChanceOfFuryOnHurt = 0.25
			self.ChanceOfFuryOnLeaderDeath = 1.00

	def ImDeadFunc (self,EntityName):
		Enm_Def.NPCPerson.StdImDead(self,EntityName)
		me = Bladex.GetEntity(EntityName)
		print "El esqueleto se convertira en polvo"
		Bladex.AddScheduledFunc(Bladex.GetTime()+10, dust.EnPolvoPerson,(EntityName,100,0,))

	def MutilateFunc(self,EntityName,obj_name,x,y,z,nx,ny,nz,node):
		limb= Bladex.GetEntity(obj_name)
		InitDataField.Initialise(limb)
		Bladex.AddScheduledFunc(Bladex.GetTime()+10, dust.EnPolvoObjeto,(obj_name,100,0,))


################################################################################
# Define the Knight_Dkn class
################################################################################
class Knight_Dkn (Enm_Def.NPCPerson):
	def __init__(self, me):
		# base class init
		Enm_Def.NPCPerson.__init__(self, me)
		#print "Personage Creado",me.Name,self.changed_func

		# Set up traitor knight specific sound priorities
		self.SoundPriorities[Reference.SND_ARROW]   = 10.0
		self.SoundPriorities[Reference.SND_HIT]     = 50.0
		self.SoundPriorities[Reference.SND_NPC]     = 25.0
		self.SoundPriorities[Reference.SND_NOISYPC] = 30.0
		self.SoundPriorities[Reference.SND_PC]      = 80.0
	
	def ResetSounds(self, EntityName):
		AniSound.AsignarSonidosCaballeroTraidor(EntityName)
		
		per=Bladex.GetEntity(EntityName)
		from AniSoundKgtX import *
		per.AddAnimSound('Kgt_g_32_5_3new', EsfuerzoBarbMediano, 0.185)
		per.AddAnimSound('Kgt_g_32_5_3new', SesgadoEspecialCorto2, 0.186)
		per.AddAnimSound('Kgt_g_32_5_3new', EsfuerzoGolpeAtrasBarb, 0.274)
		per.AddAnimSound('Kgt_g_32_5_3new', SesgadoEspecialLargo1, 0.294)
		per.AddAnimSound('Kgt_g_32_5_3new', AndarKgt2, 0.700)
		per.AddAnimSound('Kgt_g_32_5_3new', EsfuerzoGolpeAtras1Barb, 0.508)
		per.AddAnimSound('Kgt_g_32_5_3new', SesgadoEspecialLargo2, 0.518)

		per.AddAnimSound('Kgt_g_27kata_new',SesgadoEspecialCorto1, 0.110)
		per.AddAnimSound('Kgt_g_27kata_new',EsfuerzoCorto6Barb, 0.110)
		per.AddAnimSound('Kgt_g_27kata_new',SesgadoEspecialCorto2, 0.245)
		per.AddAnimSound('Kgt_g_27kata_new',SesgadoEspecialLargo2, 0.427)
		per.AddAnimSound('Kgt_g_27kata_new',EsfuerzoBarbMediano, 0.400)
		per.AddAnimSound('Kgt_g_27kata_new',AndarKgt2, 0.800)

		per.AddAnimSound('Kgt_g_sb25_new', SesgadoEspecialLargo2, 0.472)
		per.AddAnimSound('Kgt_g_sb25_new', EsfuerzoGolpeAtras1Barb, 0.459)
		per.AddAnimSound('Kgt_g_sb25_new', EsfuerzoCorto2Barb, 0.245)
		per.AddAnimSound('Kgt_g_sb25_new', AndarKgt2, 0.400)
	

	# Functions for loading and saving state
	def __getstate__(self):	
		#print "Changed Funcs",self.changed_func
		
		NPCPerson_state=Enm_Def.NPCPerson.__getstate__(self)
		if(NPCPerson_state[0]!=1):
			print "ERROR: Knight_Dkn.__getstate__(): Base class version differs."
			return NPCPerson_state
		NPCPerson_state[1]["Knight_Dkn"]=()
		return NPCPerson_state
	
	def __setstate__(self,parm):
		# Toma como parmetro lo que devuelve __getstate__() y debe recrear la clase
		Enm_Def.NPCPerson.__setstate__(self,parm)

	def ResetCombat (self,EntityName):		
		Enm_Def.NPCPerson.ResetCombat(self, EntityName)
		me = Bladex.GetEntity(EntityName)
		if me and me.Life>0:
			self.AttacksOwnKind=TRUE
			self.AttackNPCTime = 1.5
			me.BlockingPropensity = 0.7
			me.AttackList = BCopy.deepcopy(KnightDknAttackData)
			self.ChanceOfFuryOnHurt = 0.25
			self.ChanceOfFuryOnLeaderDeath = 1.00



################################################################################
# Define the Moria_Ork class
################################################################################

class Moria_Ork (Enm_Def.NPCPerson):
	def __init__(self, me):
		# base class init
		Enm_Def.NPCPerson.__init__(self, me)

		# anims
		me.AnmTranFunc=AuxTran.AuxTranOrc

		# Set up orc specific sound priorities
		self.SoundPriorities[Reference.SND_ARROW]   = 10.0
		self.SoundPriorities[Reference.SND_HIT]     = 50.0
		self.SoundPriorities[Reference.SND_NPC]     = 25.0
		self.SoundPriorities[Reference.SND_NOISYPC] = 30.0
		self.SoundPriorities[Reference.SND_PC]      = 80.0

		me.EnterLargeFunc=self.MM_EnterLarge
		
		
	def ResetSounds(self, EntityName):
		me=Bladex.GetEntity(EntityName)
		if me.Kind=="Ork":
			AniSound.AsignarSonidosOrco(EntityName)
			from AniSoundOrkX import *
			me.AddAnimSound('Kgt_1tw_h_f',AndarOrc2, 0.4000)
			me.AddAnimSound('Kgt_1tw_h_f',EsfuerzoCortoOrc, 0.3000)
#			me.AddAnimSound('Kgt_1tw_h_f',EsfuerzoBarbMediano, 0.3000)
			me.AddAnimSound('Kgt_1tw_l_f',AndarOrc2, 0.4000)
			me.AddAnimSound('Kgt_1tw_l_f',EsfuerzoCorto2Orc, 0.3000)
		elif me.Kind=="Great_Ork":
			AniSound.AsignarSonidosOrcoGrande(EntityName)
			from AniSoundGokX import *
			me.AddAnimSound('Kgt_1tw_h_f',AndarGorco2, 0.4000)
			me.AddAnimSound('Kgt_1tw_h_f',EsfuerzoCortoGorco, 0.3000)
			me.AddAnimSound('Kgt_1tw_l_f',AndarGorco2, 0.4000)
			me.AddAnimSound('Kgt_1tw_l_f',EsfuerzoCorto2Gorco, 0.3000)
		elif me.Kind=="Dark_Ork":
			AniSound.AsignarSonidosOrcoOscuro(EntityName)
			from AniSoundDokX import *
			me.AddAnimSound('Kgt_1tw_h_f',AndarGorco2, 0.4000)
			me.AddAnimSound('Kgt_1tw_h_f',EsfuerzoCortoDok, 0.3000)
			me.AddAnimSound('Kgt_1tw_l_f',AndarGorco2, 0.4000)
			me.AddAnimSound('Kgt_1tw_l_f',EsfuerzoCorto2Dok, 0.3000)


	# Functions for loading and saving state
	def __getstate__(self):
		# Tiene que devolver cmo poder guardar el estado de la clase
		NPCPerson_state=Enm_Def.NPCPerson.__getstate__(self)
		if(NPCPerson_state[0]!=1):
			print "ERROR: Moria_Ork.__getstate__(): Base class version differs."
			# Throw?
			return NPCPerson_state
		NPCPerson_state[1]["Moria_Ork"]=()

		return NPCPerson_state

	def __setstate__(self,parm):
		# Toma como parmetro lo que devuelve __getstate__() y debe recrear la clase
		Enm_Def.NPCPerson.__setstate__(self,parm)
		version=parm[0]
		if version==1:
			parms=parm[1]["Moria_Ork"]
			#self.SoundPriorities=parms[0]

		me=Bladex.GetEntity(self.Name)
		me.AnmTranFunc=AuxTran.AuxTranOrc

	def ResetCombat (self,EntityName):
		Enm_Def.NPCPerson.ResetCombat(self, EntityName)
		me = Bladex.GetEntity(EntityName)
		if me and me.Life>0:
			me.BlockingPropensity = 0.2
			me.AttackList = BCopy.deepcopy(MoriaOrkAttackData)
			self.ChanceOfFuryOnHurt = 0.45

	def MM_TakeObject (self, EntityName, ObjectName):
		pers=Bladex.GetEntity(EntityName)
		if pers and pers.Life >0:
	   	   pers.Data.selected_entity=(ObjectName, Select.GetSelectionData(ObjectName))
	   	   Actions.StdUse(pers.Name)

	def MM_EnterLarge(self,EntityName):
		me = Bladex.GetEntity(EntityName)
		# Check I'm not dead		
		Reference.debugprint(EntityName + ": Im entering large area!")
		if me.Life > 0 and not me.MeleeActive:
			inv= me.GetInventory()
			if inv.HasBow:
				left_type= Reference.GiveObjectFlag(me.InvLeft)
				if left_type != Reference.OBJ_BOW:
					me.SwitchToBow()
					if inv.GetSelectedWeapon() != me.InvRight and inv.GetSelectedWeapon() != me.InvLeft:
						# Launch the swap weapons animation
						out= ScorerActions.CB_WeaponOutX(EntityName,0)
						if not out:
							me.AnmEndedFunc= ScorerActions.CB_WeaponOutX
						Bladex.AddScheduledFunc(Bladex.GetTime()+2.0, self.MM_EnterLarge,(EntityName,),EntityName+"ReMMEnterLarge")
			def_class.UseFirePotion (EntityName)

################################################################################

################################################################################
###
### Auxiliary Combat Functions
###
################################################################################
################################################################################

def UsePotion (EntityName):
	import pocimac
	me=Bladex.GetEntity(EntityName)	
	if me and me.Life >0:
		
		inv = me.GetInventory()
		for x in range (inv.nObjects):
			item_name = inv.GetObject(x)
			if item_name == None: return 0 # Masklin: Safe check added
			item = Bladex.GetEntity(item_name)
			if item.Data and item.Data.__class__==pocimac.Pocima:
				max_life= CharStats.GetCharMaxLife(me.Kind, me.Level)
				if (me.Life <= max_life/4.0) or (item.Data.Increment and me.Life+item.Data.Increment<=max_life):
					# we have found a potion, I hope its the life giving one...
					me.Data.obj_used=item
					item.Data.UsedBy = EntityName
					item.UseFunc(item_name, Actions.USE_FROM_INV)
					return 1
					
		
			
	return 0

################################################################################
################################################################################
###
### Customized combat tables
###
################################################################################
################################################################################


################################################################################
#           Type    Weight  Move                  MinD  BestD  MaxD     Time (s [Interruptable])
################################################################################


GlofrorAttackData = [
           # inner zone blocks:
            [AllyCombat.BLOCK,  0.20, "tr",                 650.0, 1300.0, 3500.0, 0.50],
            [AllyCombat.BLOCK,  0.20, "tl",                 650.0, 1300.0, 3500.0, 0.50],
            [AllyCombat.BLOCK,  0.20, "tb",                 650.0, 1300.0, 3500.0, 0.50],
            [AllyCombat.BLOCK,  0.30, "tf",                 650.0, 1300.0, 3500.0, 0.50],

           # outer zone blocks:
            [AllyCombat.BLOCK,  0.05, "tr",                3400.0, 7000.0, 9000.0, 0.50],
            [AllyCombat.BLOCK,  0.05, "tl",                3400.0, 7000.0, 9000.0, 0.50],
            [AllyCombat.BLOCK,  0.35, "tb",                3400.0, 7000.0, 9000.0, 0.50],
            [AllyCombat.BLOCK,  0.10, "tf",                3400.0, 7000.0, 9000.0, 0.50],

           # dodges:
            [AllyCombat.DODGE,  0.25, "D_r",                400.0, 1000.0, 2800.0, 0.35],
            [AllyCombat.DODGE,  0.25, "D_l",                400.0, 1000.0, 2800.0, 0.35],
            [AllyCombat.DODGE,  0.10, "D_b",                400.0, 1000.0, 2800.0, 0.35],
#            [AllyCombat.DODGE, 0.15, ("DL_G_1H",),    0.0, 1000.0, 2500.0, 0.35], # Esquivar con golpe
#            [AllyCombat.DODGE, 0.15, ("DR_G_1H",),    0.0, 1000.0, 2500.0, 0.35], # Esquivar con golpe
#            [AllyCombat.DODGE, 0.10, ("DB_G_1H",),    0.0, 1000.0, 2500.0, 0.35], # Esquivar con golpe

           # attacks:
            [AllyCombat.ATTACKDOWN, 0.90, ("STAIRS",),         800.0, 1000.0, 2500.0, 0.35],

	    [AllyCombat.ATTACK, 0.1, ("GI_1H",),            0.0, 1800.0, 2500.0, 0.35], # Light Attack 
	    [AllyCombat.ATTACK, 0.1, ("GM12_1H",),          0.0, 1800.0, 2500.0, 0.35], # Light High Attack 
	    [AllyCombat.ATTACK, 0.1, ("GM18_1H",),          0.0, 1800.0, 2500.0, 0.35], # Light Low Attack 
	    [AllyCombat.ATTACK, 0.1, ("GM16_1H",),          0.0, 1800.0, 2500.0, 0.35], # Light Left Attack 
	    [AllyCombat.ATTACK, 0.1, ("GM14_1H",),          0.0, 1800.0, 2500.0, 0.35], # Light Right Attack 

#            [AllyCombat.ATTACK, 0.10, ("GM31_1H",),        0.0, 1000.0, 2500.0, 0.35], # Golpe Hacha
#            [AllyCombat.ATTACK, 0.10, ("GM32_1H",),        0.0, 1000.0, 2500.0, 0.35], # Golpe Hacha2
            [AllyCombat.ATTACK, 0.1, ("GM15_1H",),         0.0, 1000.0, 2500.0, 0.35], # Golpe Hacha4
            [AllyCombat.ATTACK, 0.1, ("GM25_1H",),         0.0, 1000.0, 2500.0, 0.35], # Golpe Hacha5
            [AllyCombat.ATTACK, 0.1, ("GM11_1H",),         0.0, 1000.0, 2500.0, 0.35], # Golpe Hacha6

            [AllyCombat.ATTACK, 0.30, "RespectDistance",      0.0,  500.0, 1000.0, 0.30, 1],

           # inner zone moves:
            [AllyCombat.MOVE,   0.05, "tr",                   0.0, 2000.0, 5000.0, 0.35],
            [AllyCombat.MOVE,   0.05, "tl",                   0.0, 2000.0, 5000.0, 0.35],
            [AllyCombat.MOVE,   0.10, "tb",                   0.0, 2000.0, 5000.0, 0.35],
            [AllyCombat.MOVE,   0.15, "tf",                   0.0, 2000.0, 5000.0, 0.35],

           # outer zone moves:
            [AllyCombat.MOVE,   0.06, "tr",                5001.0, 7000.0, 9000.0, 0.50, 1],
            [AllyCombat.MOVE,   0.06, "tl",                5002.0, 7000.0, 9000.0, 0.50, 1],
            [AllyCombat.MOVE,   0.10, "tb",                5003.0, 7000.0, 9000.0, 0.50, 1],
            [AllyCombat.MOVE,   0.05, "tf",                5004.0, 7000.0, 9000.0, 0.50, 1],
            [AllyCombat.MOVE,   0.07, AllyCombat.TempMoveInProc,      3000.0, 7000.0, 9000.0, 0.35, 1],
            [AllyCombat.MOVE,   0.05, UsePotion,           3000.0, 7000.0, 9000.0, 1.00],
]
        
# Nuevos combos para Knight Skeleton (Sonidos en ResetSound)

def ExtraAnmForKnight_Skl ():

	Skl=Bladex.GetCharType("Skeleton","Skl")

	#  Espada elfica
	Bladex.AddBipedAction("Skeleton","g_32_5_3new","Kgt_g_32_5_3new",0.0,1.0,0)
	Skl.AddAttack("GM34_1H","Kgt_g_32_5_3new")
	Skl.AttackWindow("Kgt_g_32_5_3new",0.508,0.706,"GM34_1H_Window")
	Skl.AssignTrail("GM34_1H","","EstelaRoja1")
	Skl.AddLevels("Kgt_g_32_5_3new",8,40)
	Skl.AddEnergyLevel("Kgt_g_32_5_3new", 0)


KnightSklAttackData = [
           # inner zone blocks:
            [Combat.BLOCK,  0.08, (),                   500.0, 1000.0, 3000.0, 0.35],
            [Combat.BLOCK,  0.05, "tr",                 750.0, 1500.0, 3500.0, 0.50],
            [Combat.BLOCK,  0.05, "tl",                 750.0, 1500.0, 3500.0, 0.50],
            [Combat.BLOCK,  0.05, "tb",                 750.0, 1500.0, 3500.0, 0.50],
            [Combat.BLOCK,  0.20, "tf",                 750.0, 1500.0, 3500.0, 0.50],

           # outer zone blocks:
            [Combat.BLOCK,  0.05, "tr",                3500.0, 7000.0, 9000.0, 0.50],
            [Combat.BLOCK,  0.05, "tl",                3500.0, 7000.0, 9000.0, 0.50],
            [Combat.BLOCK,  0.35, "tb",                3500.0, 7000.0, 9000.0, 0.50],
            [Combat.BLOCK,  0.10, "tf",                3500.0, 7000.0, 9000.0, 0.50],

           # dodges:
            [Combat.DODGE,  0.25, "d_r",                500.0, 1200.0, 2800.0, 0.35],
            [Combat.DODGE,  0.25, "d_l",                500.0, 1200.0, 2800.0, 0.35],
            [Combat.DODGE,  0.00, "d_b",                500.0, 1200.0, 2800.0, 0.35],

           # attacks:
	    [Combat.ATTACKDOWN, 0.90, ("STAIRS",),         1200.0, 1400.0, 2500.0, 0.35],

            [Combat.ATTACK, 0.30, ("GA",),                0.0, 1400.0, 2500.0, 0.35],
            [Combat.ATTACK, 0.30, ("GA", "GA"),        1200.0, 1600.0, 2500.0, 0.35],
            [Combat.ATTACK, 0.10, ("GA", "GA", "GM1"),    0.0, 1600.0, 2500.0, 0.35],
            [Combat.ATTACK, 0.20, ("GM2",),            1200.0, 1800.0, 2500.0, 0.35],
            [Combat.ATTACK, 0.20, ("GM2",),            2000.0, 2250.0, 2500.0, 0.35],

            [Combat.ATTACK, 0.20, ("GM34_1H",), 	  0.0, 1200.0, 2500.0, 0.35], # Espada Elfica

            [Combat.ATTACK, 0.30, "RespectDistance",      0.0,  500.0, 1000.0, 0.30, 1],

           # inner zone moves:
            [Combat.MOVE,   0.05, "tr",                   0.0, 2000.0, 5000.0, 0.35],
            [Combat.MOVE,   0.05, "tl",                   0.0, 2000.0, 5000.0, 0.35],
            [Combat.MOVE,   0.10, "tb",                   0.0, 2000.0, 5000.0, 0.35],
            [Combat.MOVE,   0.25, "tf",                   0.0, 2000.0, 5000.0, 0.35],

           # outer zone moves:
            [Combat.MOVE,   0.06, "tr",                5001.0, 7000.0, 9000.0, 0.50, 1],
            [Combat.MOVE,   0.06, "tl",                5002.0, 7000.0, 9000.0, 0.50, 1],
            [Combat.MOVE,   0.15, "tb",                5003.0, 7000.0, 9000.0, 0.50, 1],
            [Combat.MOVE,   0.05, "tf",                5004.0, 7000.0, 9000.0, 0.50, 1],
            [Combat.MOVE,   0.15, Combat.TempMoveInProc,      3000.0, 7000.0, 9000.0, 0.35, 1],
            [Combat.MOVE,   0.05, Combat.TempMoveOutProc,     3000.0, 3000.0, 7000.0, 0.35, 1],
            [Combat.MOVE,   0.07, UsePotion,           3000.0, 7000.0, 9000.0, 1.00],
]

# Nuevos combos para Knight Dkn (Sonidos en ResetSound)

def ExtraAnmForKnight_Dkn ():

	Dkn=Bladex.GetCharType("Dark_Knight","Dkn")

	#  Espada romana
	Bladex.AddBipedAction("Dark_Knight","g_27kata_new","Kgt_g_27kata_new",0.0,1.0,0)
	Dkn.AddAttack("GM35_1H","Kgt_g_27kata_new")
	Dkn.AttackWindow("Kgt_g_27kata_new",0.427,0.670,"GM35_1H_Window")
	Dkn.AssignTrail("GM35_1H","","EstelaRoja1")
	Dkn.AddLevels("Kgt_g_27kata_new",7,40)
	Dkn.AddEnergyLevel("Kgt_g_27kata_new", 0)

	#  Espada elfica
	Bladex.AddBipedAction("Dark_Knight","g_32_5_3new","Kgt_g_32_5_3new",0.0,1.0,0)
	Dkn.AddAttack("GM34_1H","Kgt_g_32_5_3new")
	Dkn.AttackWindow("Kgt_g_32_5_3new",0.508,0.706,"GM34_1H_Window")
	Dkn.AssignTrail("GM34_1H","","EstelaRoja1")
	Dkn.AddLevels("Kgt_g_32_5_3new",8,40)
	Dkn.AddEnergyLevel("Kgt_g_32_5_3new", 0)

	#  Espada curva
	Bladex.AddBipedAction("Dark_Knight","g_sb25_new","Kgt_g_sb25_new",0.0,1.0,0)
	Dkn.AddAttack("GM5_1H","Kgt_g_sb25_new")
	Dkn.AttackWindow("Kgt_g_sb25_new",0.472,0.626,"GM5_1H_Window")
	Dkn.AssignTrail("GM5_1H","","EstelaRoja1")
	Dkn.AddLevels("Kgt_g_sb25_new",5,40)
	Dkn.AddEnergyLevel("Kgt_g_sb25_new", 0)

KnightDknAttackData = [
           # inner zone blocks:
            [Combat.BLOCK,  0.08, (),                   500.0, 1000.0, 3000.0, 0.35],
            [Combat.BLOCK,  0.05, "tr",                 750.0, 1500.0, 3500.0, 0.50],
            [Combat.BLOCK,  0.05, "tl",                 750.0, 1500.0, 3500.0, 0.50],
            [Combat.BLOCK,  0.05, "tb",                 750.0, 1500.0, 3500.0, 0.50],
            [Combat.BLOCK,  0.20, "tf",                 750.0, 1500.0, 3500.0, 0.50],

           # outer zone blocks:
            [Combat.BLOCK,  0.05, "tr",                3500.0, 7000.0, 9000.0, 0.50],
            [Combat.BLOCK,  0.05, "tl",                3500.0, 7000.0, 9000.0, 0.50],
            [Combat.BLOCK,  0.35, "tb",                3500.0, 7000.0, 9000.0, 0.50],
            [Combat.BLOCK,  0.10, "tf",                3500.0, 7000.0, 9000.0, 0.50],

           # dodges:
            [Combat.DODGE,  0.25, "d_r",                500.0, 1200.0, 2800.0, 0.35],
            [Combat.DODGE,  0.25, "d_l",                500.0, 1200.0, 2800.0, 0.35],
            [Combat.DODGE,  0.00, "d_b",                500.0, 1200.0, 2800.0, 0.35],

           # attacks:
	    [Combat.ATTACKDOWN, 0.90, ("STAIRS",),         1200.0, 1400.0, 2500.0, 0.35],

            [Combat.ATTACK, 0.11, ("GA",),                0.0, 1400.0, 2500.0, 0.35],
            [Combat.ATTACK, 0.11, ("GA", "GA"),        1200.0, 1600.0, 2500.0, 0.35],
            [Combat.ATTACK, 0.06, ("GA", "GA", "GM1"),    0.0, 1600.0, 2500.0, 0.35],
            [Combat.ATTACK, 0.12, ("GM2",),            1200.0, 1800.0, 2500.0, 0.35],
            [Combat.ATTACK, 0.12, ("GM2",),            2000.0, 2250.0, 2500.0, 0.35],

            [Combat.ATTACK, 0.12, ("GM35_1H",), 	1200.0, 1600.0, 2500.0, 0.35],
            [Combat.ATTACK, 0.09, ("GM34_1H",), 	   0.0, 1200.0, 2500.0, 0.35],
            [Combat.ATTACK, 0.12, ("GM5_1H",),		1200.0, 1800.0, 2500.0, 0.35],

            [Combat.ATTACK, 0.15, "RespectDistance",      0.0,  500.0, 1000.0, 0.30, 1],

           # inner zone moves:
            [Combat.MOVE,   0.05, "tr",                   0.0, 2000.0, 5000.0, 0.35],
            [Combat.MOVE,   0.05, "tl",                   0.0, 2000.0, 5000.0, 0.35],
            [Combat.MOVE,   0.10, "tb",                   0.0, 2000.0, 5000.0, 0.35],
            [Combat.MOVE,   0.25, "tf",                   0.0, 2000.0, 5000.0, 0.35],

           # outer zone moves:
            [Combat.MOVE,   0.06, "tr",                5001.0, 7000.0, 9000.0, 0.50, 1],
            [Combat.MOVE,   0.06, "tl",                5002.0, 7000.0, 9000.0, 0.50, 1],
            [Combat.MOVE,   0.15, "tb",                5003.0, 7000.0, 9000.0, 0.50, 1],
            [Combat.MOVE,   0.05, "tf",                5004.0, 7000.0, 9000.0, 0.50, 1],
            [Combat.MOVE,   0.005, Combat.Laugh,              5000.0, 7000.0, 9000.0, 0.35, 1],
            [Combat.MOVE,   0.005, Combat.Insult,             5000.0, 7000.0, 9000.0, 0.35, 1],
            [Combat.MOVE,   0.15, Combat.TempMoveInProc,      3000.0, 7000.0, 9000.0, 0.35, 1],
            [Combat.MOVE,   0.05, Combat.TempMoveOutProc,     3000.0, 3000.0, 7000.0, 0.35, 1],
            [Combat.MOVE,   0.07, UsePotion,           3000.0, 7000.0, 9000.0, 1.00],
]


# Nuevos combos para Moria Ork (Sonidos en ResetSound)
# Tambin animaciones para FirePotion

def ExtraAnmForMoria_Ork ():

	# Take

	Bladex.AddBipedAction("Orc","tke_r_01",    "Kgt_tke_r_01",0.0,1.0,0)
	Bladex.AddBipedAction("Orc","tke_r_02",    "Kgt_tke_r_02",0.0,1.0,0)
	Bladex.AddBipedAction("Orc","tke_r_03",    "Kgt_tke_r_03",0.0,1.0,0)
	Bladex.AddBipedAction("Orc","tke_r_04",    "Kgt_tke_r_04",0.0,1.0,0)
	Bladex.AddBipedAction("Orc","tke_r_05",    "Kgt_tke_r_05",0.0,1.0,0)
	Bladex.AddBipedAction("Orc","tke_r_key00","Kgt_tke_r_key00",0.0,1.0,0)
	Bladex.AddBipedAction("Orc","tke_r_key01","Kgt_tke_r_key01",0.0,1.0,0)
	Bladex.AddBipedAction("Orc","tke_r_key02","Kgt_tke_r_key02",0.0,1.0,0)
	Bladex.AddBipedAction("Orc","tke_r_key03","Kgt_tke_r_key03",0.0,1.0,0)
	Bladex.AddBipedAction("Orc","tke_r_key04","Kgt_tke_r_key05",0.0,1.0,0)

	# Throw

	Bladex.AddBipedAction("Orc","1tw_h_f","Kgt_1tw_h_f",0.0,1.0,0)	
	Bladex.AddBipedAction("Orc","1tw_l_f","Kgt_1tw_l_f",0.0,0.75,0)	

	# Take

	Bladex.AddBipedAction("Gok","tke_r_01",    "Kgt_tke_r_01",0.0,1.0,0)
	Bladex.AddBipedAction("Gok","tke_r_02",    "Kgt_tke_r_02",0.0,1.0,0)
	Bladex.AddBipedAction("Gok","tke_r_03",    "Kgt_tke_r_03",0.0,1.0,0)
	Bladex.AddBipedAction("Gok","tke_r_04",    "Kgt_tke_r_04",0.0,1.0,0)
	Bladex.AddBipedAction("Gok","tke_r_05",    "Kgt_tke_r_05",0.0,1.0,0)
	Bladex.AddBipedAction("Gok","tke_r_key00","Kgt_tke_r_key00",0.0,1.0,0)
	Bladex.AddBipedAction("Gok","tke_r_key01","Kgt_tke_r_key01",0.0,1.0,0)
	Bladex.AddBipedAction("Gok","tke_r_key02","Kgt_tke_r_key02",0.0,1.0,0)
	Bladex.AddBipedAction("Gok","tke_r_key03","Kgt_tke_r_key03",0.0,1.0,0)
	Bladex.AddBipedAction("Gok","tke_r_key04","Kgt_tke_r_key05",0.0,1.0,0)

	# Throw

	Bladex.AddBipedAction("Gok","1tw_h_f","Kgt_1tw_h_f",0.0,1.0,0)	
	Bladex.AddBipedAction("Gok","1tw_l_f","Kgt_1tw_l_f",0.0,0.75,0)	

	# Take

	Bladex.AddBipedAction("Dok","tke_r_01",    "Kgt_tke_r_01",0.0,1.0,0)
	Bladex.AddBipedAction("Dok","tke_r_02",    "Kgt_tke_r_02",0.0,1.0,0)
	Bladex.AddBipedAction("Dok","tke_r_03",    "Kgt_tke_r_03",0.0,1.0,0)
	Bladex.AddBipedAction("Dok","tke_r_04",    "Kgt_tke_r_04",0.0,1.0,0)
	Bladex.AddBipedAction("Dok","tke_r_05",    "Kgt_tke_r_05",0.0,1.0,0)
	Bladex.AddBipedAction("Dok","tke_r_key00","Kgt_tke_r_key00",0.0,1.0,0)
	Bladex.AddBipedAction("Dok","tke_r_key01","Kgt_tke_r_key01",0.0,1.0,0)
	Bladex.AddBipedAction("Dok","tke_r_key02","Kgt_tke_r_key02",0.0,1.0,0)
	Bladex.AddBipedAction("Dok","tke_r_key03","Kgt_tke_r_key03",0.0,1.0,0)
	Bladex.AddBipedAction("Dok","tke_r_key04","Kgt_tke_r_key05",0.0,1.0,0)

	# Throw

	Bladex.AddBipedAction("Dok","1tw_h_f","Kgt_1tw_h_f",0.0,1.0,0)	
	Bladex.AddBipedAction("Dok","1tw_l_f","Kgt_1tw_l_f",0.0,0.75,0)	

MoriaOrkAttackData =	[ 
           # inner zone blocks:
            [Combat.BLOCK,  0.25, (),                   500.0, 1000.0, 3000.0, 0.50],
            [Combat.BLOCK,  0.05, "tr",                 750.0, 1500.0, 3500.0, 0.50],
            [Combat.BLOCK,  0.05, "tl",                 750.0, 1500.0, 3500.0, 0.50],
            [Combat.BLOCK,  0.05, "tb",                 750.0, 1500.0, 3500.0, 0.50],
            [Combat.BLOCK,  0.05, "tf",                 750.0, 1500.0, 3500.0, 0.50],
           # total inner zone 0.45
           
           # outer zone blocks:
            [Combat.BLOCK,  0.07, (),                  3000.0, 4000.0, 5000.0, 0.50],
            [Combat.BLOCK,  0.035,"tr",                3500.0, 7000.0, 9000.0, 0.50,1],
            [Combat.BLOCK,  0.035,"tl",                3500.0, 7000.0, 9000.0, 0.50,1],
            [Combat.BLOCK,  0.245,"tb",                3500.0, 7000.0, 9000.0, 0.50,1],
            [Combat.BLOCK,  0.07, "tf",                3500.0, 7000.0, 9000.0, 0.50,1],
           # total outer zone 0.455
           
           # dodges:
            [Combat.DODGE,  0.30, "d_r",                500.0, 1200.0, 2800.0, 0.35],
            [Combat.DODGE,  0.30, "d_l",                500.0, 1200.0, 2800.0, 0.35],
            [Combat.DODGE,  0.30, "d_b",                500.0, 1200.0, 2800.0, 0.35],

           # attacks:
        [Combat.ATTACKDOWN, 1.00, ("STAIRS",),         1200.0, 1800.0, 2500.0, 0.35],

            [Combat.ATTACK, 0.50, ("g_01",),            765.0, 2397.5, 3265.0, 0.35],
            [Combat.ATTACK, 0.40, ("g_02",),            873.0, 2123.0, 3373.0, 0.35],
            [Combat.ATTACK, 0.40, ("g_06",),            764.0, 2014.0, 3264.0, 0.35],
            [Combat.ATTACK, 0.20, ("g_15",),            844.0, 2094.0, 3344.0, 0.35],
            [Combat.ATTACK, 0.20, ("g_16",),            243.0, 1493.0, 2743.0, 0.35],
            [Combat.ATTACK, 0.15, ("g_18",),           1917.0, 3167.0, 4417.0, 0.35],
            [Combat.ATTACK, 0.60, "RespectDistance",      0.0,  500.0, 1200.0, 1.00,1],
            
            # combinations
            [Combat.ATTACK, 0.40, ("COMBO1",),            764.0, 2014.0, 3264.0, 0.35],
            [Combat.ATTACK, 0.40, ("COMBO2",),            243.0, 1493.0, 2743.0, 0.35],
            [Combat.ATTACK, 0.40, ("COMBO3",),            873.0, 2123.0, 3000.0, 0.35],

	    # fire potion
            [Combat.ATTACK, 0.70, def_class.UseFirePotion,         5000.0, 8000.0, 12000.0, 1.00],

           # inner zone moves:
            [Combat.MOVE,   0.03, "tr",                   0.0, 2000.0, 5000.0, 0.50],
            [Combat.MOVE,   0.03, "tl",                   0.0, 2000.0, 5000.0, 0.50],
            [Combat.MOVE,   0.05, "tb",                   0.0, 2000.0, 5000.0, 0.50],
            [Combat.MOVE,   0.10, "tf",                   0.0, 2000.0, 5000.0, 0.50],

           # outer zone moves:
            [Combat.MOVE,   0.03, "tr",                5000.0, 7000.0, 9000.0, 0.50,1],
            [Combat.MOVE,   0.03, "tl",                5000.0, 7000.0, 9000.0, 0.50,1],
            [Combat.MOVE,   0.05, "tb",                5000.0, 7000.0, 9000.0, 0.50,1],
            [Combat.MOVE,   0.03, "tf",                5000.0, 7000.0, 9000.0, 0.50,1],
            [Combat.MOVE,   0.15, Combat.TempMoveInProc,      5000.0, 7000.0, 9000.0, 0.35,1],
            [Combat.MOVE,   0.05, Combat.TempMoveOutProc,     3000.0, 3000.0, 7000.0, 0.35, 1],
            [Combat.MOVE,   0.05, UsePotion,           3000.0, 7000.0, 9000.0, 1.00],
]


def ExtraAnmForMoriaEnemies ():
	ExtraAnmForKnight_Skl ()
	ExtraAnmForKnight_Dkn ()
	ExtraAnmForMoria_Ork  ()
