import Bladex
import Doors
import Reference
import Sounds
import Objects
import Arrows
import InitDataField
import heavyObjects
import stone
import Levers

MESSAGE_START_WEAPON         =7
MESSAGE_STOP_WEAPON          =8


##-------------------------------------------------------------
## Partculas
##-------------------------------------------------------------

Bladex.AddParticleGType("SpDust","SmokeParticle",Reference.B_PARTICLE_GTYPE_BLEND,60)

for i in range(60):
	if i>30:
		traux=0.0
	else:
		traux=((30.0-i)/30.0)**0.5
	aux=((60.0-i)/60.0)**0.5
	r=255
	g=230
	b=210
	a=60.0*(1.0-traux)
	size=7.0+aux*700.0
	Bladex.SetParticleGVal("SpDust",i,r,g,b,a,size)

##-------------------------------------------------------------
## Cuevas (Pozo)
##-------------------------------------------------------------

TRCorredorPozo=Bladex.GetSector (68035.5424454, -2064.28828534, 20339.6094043)
TRCorredorPozo.OnEnter=ActivaEnmPozo

TRCentroPozo=Bladex.GetSector(56353.018441, -569.348056426, 5075.27245892)
TRCentroPozo.OnEnter=OrcoTraidorPozo
	
##-------------------------------------------------------------
## Entrada Zona Trampas
##-------------------------------------------------------------

## Altar y gemas

## Gema Roja

o=Bladex.CreateEntity("GemRGPointer","GhostPointer",76052.1342351,-7276.21383898,15261.6715923, Reference.ObjType("GhostPointer"))
o.Static=1
o.Scale=1
o.Orientation=(1.0,0.0,0.0,0.0)
o.UseFunc = TRActivaAltarGemaR

## Puertas exteriores

TRd1bd=Bladex.GetSector (92690, -9034,13660)
TRd1bd.Active=0
TRd1bi=Bladex.GetSector (92690, -9034,16634)
TRd1bi.Active=0
TRd1ad=Bladex.GetSector (92896,-10086,13029)
TRd1ad.Active=0
TRd1ai=Bladex.GetSector (92848,-10441,16102)
TRd1ai.Active=0

## Puerta interior

TRd2=Bladex.GetSector(93174, -8418, 13009)
TRd2.Active=0
TRd2.InitBreak((300,0,0), (0,0,1600), (0.0, 730.0, 0.0), "piedra pesada")

## Enciende Lmparas

#TRlamp=Bladex.GetSector(99414.6047588, -9074.43293605, 14665.4337317)
#TRlamp.OnEnter=TREnciendeLamparas


## Esqueletos

TRSkl1=Bladex.GetSector(129915.429767, -9069.67210883, 24241.3540164)
TRSkl1.Active=0
TRSkl1.InitBreak((0,0,-100), (1800,0,0), (0.0, 730.0, 0.0), "madera pesada")

TRSkl2=Bladex.GetSector(129432.112712, -9061.2022368, 5522.67849144)
TRSkl2.Active=0
TRSkl2.InitBreak((0,0,100), (1800,0,0), (0.0, 730.0, 0.0), "madera pesada")

TRSkl0=Bladex.GetSector(130045.448806, -7068.47075742, 15465.7721517)
TRSkl0.OnEnter=TRActivaSkl


##-------------------------------------------------------------
## Puente
##-------------------------------------------------------------

## Puerta puente

TRdp = Doors.CreateDoor("TRPuente",  (136467.5, -7067.66, 13994.79), (0,1,0),  0, 3200, Doors.CLOSED)
TRdp.opentype=Doors.UNIF
TRdp.o_med_vel=-700
TRdp.o_med_displ=3200
TRdp.closetype=Doors.AC
TRdp.c_init_displ=3200
TRdp.c_med_vel=8000
TRdp.SetWhileOpenSound(Sonido_Puerta_Subiendo)
TRdp.SetEndOpenSound(Sonido_Puerta_Final)
TRdp.SetEndCloseSound(Sonido_Puerta_Final)


## Sectores del puente

TRp1=Bladex.GetSector(141000, -5816, 14500)
TRp1.Active=0
TRp1.InitBreak((0,600,0), (700,0,0), (0.0,730.0,0.0), "piedra pesada")
TRps1=Bladex.GetSector(141000, -7286, 14500)
TRps1.OnEnter=CruzaRapido

TRp2=Bladex.GetSector(146000, -5938, 14500)
TRp2.Active=0
TRp2.InitBreak((0,600,0), (700,0,0), (0.0,730.0,0.0), "piedra pesada")
TRps2=Bladex.GetSector(146000, -7286, 14500)
TRps2.OnEnter=TRRompePuente1Y4a

TRp3=Bladex.GetSector(149000, -5924, 14500)
TRp3.Active=0
TRp3.InitBreak((0,600,0), (700,0,0), (0.0,730.0,0.0), "piedra pesada")
TRps3=Bladex.GetSector(149000, -7286, 14500)
TRps3.OnEnter=TRRompePuente2

TRp4a=Bladex.GetSector(150500, -5850, 15250)
TRp4a.Active=0
TRp4a.InitBreak((0,600,0), (700,0,0), (0.0,730.0,0.0), "piedra pesada")
TRps4a=Bladex.GetSector(150500, -7286, 15250)
TRps4a.OnEnter=TRRompePuente3

TRp4b=Bladex.GetSector(150500, -5850, 14000)
TRp4b.Active=0
TRp4b.InitBreak((0,600,0), (700,0,0), (0.0,730.0,0.0), "piedra pesada")
TRps4b=Bladex.GetSector(150500, -7286, 14000)
TRps4b.OnEnter=TRRompePuente3

TRp5=Bladex.GetSector(153000, -5924, 14500)
TRp5.Active=0
TRp5.InitBreak((0,600,0), (700,0,0), (0.0,730.0,0.0), "piedra pesada")
TRps5=Bladex.GetSector(153000, -7286, 14500)
TRps5.OnEnter=TRRompePuente4

TRps6=Bladex.GetSector(156341, -7286, 14500)
TRps6.OnEnter=TRRompePuente5

##-------------------------------------------------------------
## Trampa Flechas
##-------------------------------------------------------------

TRFL=Bladex.GetSector(159773.711358, -7069.4990892, 13927.9649113)
TRFL.OnEnter=ActivarTrampaFlechas
TRFL.OnLeave=DesactivarTrampaFlechas

o=Bladex.CreateEntity("Flecha_Trampa_D1","FlechaEnvenenada",163285,-7568,9847)
o.Scale=1.0
o.Orientation=(0.0,1.0,0.0,0.0)

o=Bladex.CreateEntity("Flecha_Trampa_I1","FlechaEnvenenada",166284,-7568,19680)
o.Scale=1.0
o.Orientation=(1.0,0.0,0.0,0.0)
o.Position=166283.775105,-7568.24886388,19846.5

o=Bladex.CreateEntity("Flecha_Trampa_D2","FlechaEnvenenada",169498,-7568,9847)
o.Scale=1.0
o.Orientation=(0.0,1.0,0.0,0.0)

o=Bladex.CreateEntity("Flecha_Trampa_I2","FlechaEnvenenada",171949,-7568,19680)
o.Scale=1.0
o.Orientation=(1.0,0.0,0.0,0.0)
TRInicializaFlechas()


o=Bladex.CreateEntity("BotellaSagrada_Veneno_887","BotellaSagrada",174281.429017,-7909.99980551,17926.1563957, Reference.ObjType("BotellaSagrada"))
o.Scale=1.0
o.Orientation=(0.430459409952,0.43045938015,0.560985445976,-0.560985505581)
CreateVenom (o.Name, VenomInmediateDamage = -100, VenomStrength=6)

o=Bladex.CreateEntity("BotellaSagrada_Veneno_888","BotellaSagrada",174324.369125,-7913.4912893,11952.8867613, Reference.ObjType("BotellaSagrada"))
o.Scale=1.0
o.Orientation=(0.430459409952,0.43045938015,0.560985445976,-0.560985505581)
CreateVenom (o.Name, VenomInmediateDamage = -100, VenomStrength=6)


##-------------------------------------------------------------
## Trampa Cuchillas
##-------------------------------------------------------------


o=Bladex.CreateEntity("BladeI","CuchillaFernando",185932.2461690,-5546.67984746,-5589.02870281)
o.Scale=1.0
o.Orientation=(1.0,0.0,0.0,0.0)
o.Weapon = 1
InitDataField.Initialise(o)
o.Data.NoFXOnHit=1

o=Bladex.CreateEntity("BladeC","CuchillaFernando",180178.511873,-2210.91526921,-4997.78674407)
o.Scale=1.0
o.Orientation=(0.707106769085,0.0,0.0,0.707106769085)
o.Weapon = 1
InitDataField.Initialise(o)
o.Data.NoFXOnHit=1

o=Bladex.CreateEntity("BladeD","CuchillaFernando",174577.377018,-5546.67984746,-5589.02870281)
o.Scale=1.0
o.Orientation=(1.0,0.0,0.0,0.0)
o.Weapon = 1
InitDataField.Initialise(o)
o.Data.NoFXOnHit=1

TRCH=Bladex.GetSector(180444.512233, -5068.0313978, 6710.81520869)
TRCH.OnEnter=ActivateBlades
TRCH.OnLeave=DeactivateBlades

##-------------------------------------------------------------
## Bolon
##-------------------------------------------------------------

TRdb = Doors.CreateDoor("TRBolon",  (179469.88923, -5065.82119796, -10453.1559373), (0,1,0),  0, 3200, Doors.OPENED)
TRdb.opentype=Doors.UNIF
TRdb.o_med_vel=-700
TRdb.o_med_displ=3200
TRdb.closetype=Doors.AC
TRdb.c_init_displ=3200
TRdb.c_med_vel=8000
TRdb.SetWhileOpenSound(Sonido_Puerta_Subiendo)
TRdb.SetEndOpenSound(Sonido_Puerta_Final)
TRdb.SetEndCloseSound(Sonido_Puerta_Final)
TRdb.Squezze=1

TRBL=Bladex.GetSector(181131.959172, -5233.46359978, -13025.8856193)
TRBL.OnEnter=ActivateBolon

p=198643.552874, -6853.48546683, -12491.6518448
r=0.707107,0.707107,0.000000,0.000000
o=heavyObjects.CreateHeavyObject("Bolon1","BoladePiedra",p,r,0.7, heavyObjects.StoneHitEvent )
#stone.lock( o.Name, stone.DROPBROWNDUST, -3000, 1100, 0.0, 0.6, 19.0, stone.STONESOUND, 0.1 ) 
stone.lock( o.Name, stone.DROPBROWNDUST, 1000, -1000, 3000.0, 0.6, 12.0, stone.STONESOUND, 0.1 ) 

##-------------------------------------------------------------
## Rampa
##-------------------------------------------------------------

TRRefugio=Bladex.GetSector(156903.595844, -1068.95479634, -9074.)
TRRefugio.OnEnter=EstoyRefugiado

TREncimaRampa=Bladex.GetSector(158023,-1566,-12799)

TRRampa=Bladex.GetSector(156931, 1634, -12214)
TRRampa.Active=0
TRRampa.InitBreak((0,600,0), (700,0,0), (0.0,730.0,0.0), "piedra pesada")
TRRampa.TooSteep=1

TRRampaFinal=Bladex.GetSector(156749,7155,-16417)
TRRampaFinal.TooSteep=1
TRRampaFinal.OnEnter=CamaraAlAgua

##-------------------------------------------------------------
## Piscina
##-------------------------------------------------------------

TRPiscina=Bladex.GetSector(157844.778099, 28930.2218354, -52792.1075791)
TRPiscina.OnEnter=EntraPiscina

#import SolidMask
#Bladex.SetSolidMask('Plataforma', SolidMask.EX_PERSON)

AlturaBase=28930
IncrAltura=-1400

o=Bladex.CreateEntity("Plataforma_1_1","Plataforma",163000,AlturaBase,-67184, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_1_2","Plataforma",159270,AlturaBase,-67184, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_1_3","Plataforma",155540,AlturaBase,-67184, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_1_4","Plataforma",151810,AlturaBase,-67184, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_2_1","Plataforma",161075,AlturaBase+IncrAltura,-67184, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_2_2","Plataforma",157345,AlturaBase+IncrAltura,-67184, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_2_3","Plataforma",153615,AlturaBase+IncrAltura,-67184, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_3_1","Plataforma",163000,AlturaBase+2*IncrAltura,-68684, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_3_2","Plataforma",159270,AlturaBase+2*IncrAltura,-68684, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_3_3","Plataforma",155540,AlturaBase+2*IncrAltura,-68684, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_3_4","Plataforma",151810,AlturaBase+2*IncrAltura,-68684, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_4_1","Plataforma",161075,AlturaBase+3*IncrAltura,-68684, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_4_2","Plataforma",157345,AlturaBase+3*IncrAltura,-68684, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_4_3","Plataforma",153615,AlturaBase+3*IncrAltura,-68684, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_5_1","Plataforma",163000,AlturaBase+4*IncrAltura,-68684, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_5_2","Plataforma",159270,AlturaBase+4*IncrAltura,-68684, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_5_3","Plataforma",155540,AlturaBase+4*IncrAltura,-68684, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Plataforma_5_4","Plataforma",151810,AlturaBase+4*IncrAltura,-68684, Reference.ObjType("Plataforma"))
o.Scale=1.6
o.Solid=1
o.Static=1
o.Orientation=(0.707106769085,-0.707106769085,0.0,0.0)

Bladex.SetTriggerSectorFunc("Plataforma_1_1", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_1_2", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_1_3", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_1_4", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_1_5", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_2_1", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_2_2", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_2_3", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_3_1", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_3_2", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_3_3", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_3_4", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_4_1", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_4_2", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_4_3", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_5_1", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_5_2", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_5_3", "OnEnter", PisaPlataforma )
Bladex.SetTriggerSectorFunc("Plataforma_5_4", "OnEnter", PisaPlataforma )

##-------------------------------------------------------------
## Canal
##-------------------------------------------------------------

TRECanal=Bladex.GetSector(177944.155871, 19945.2873165, -58923.9005596)
TRECanal.OnEnter=EntraZonaCanal

## Puerta entrada

TRdce = Doors.CreateDoor("TRCanalEntrada",  (172031.525679, 19939.2141386, -60225.570955), (0,1,0),  0, 4200, Doors.OPENED)
TRdce.opentype=Doors.UNIF
TRdce.o_med_vel=-700
TRdce.o_med_displ=4200
TRdce.closetype=Doors.AC
TRdce.c_init_displ=4200
TRdce.c_med_vel=8000
TRdce.SetWhileOpenSound(Sonido_Puerta_Subiendo)
TRdce.SetEndOpenSound(Sonido_Puerta_Final)
TRdce.SetEndCloseSound(Sonido_Puerta_Final)
TRdce.Squezze=1

## Puerta de vuelta

TRdcv = Doors.CreateDoor("TRCanalVuelta",  (182530.515146, 19940.4672996, -62042.3726892), (0,1,0), 0, 4200, Doors.CLOSED)
TRdcv.opentype=Doors.UNIF
TRdcv.o_med_vel=-700
TRdcv.o_med_displ=4200
TRdcv.closetype=Doors.AC
TRdcv.c_init_displ=4200
TRdcv.c_med_vel=8000
TRdcv.SetWhileOpenSound(Sonido_Puerta_Subiendo)
TRdcv.SetEndOpenSound(Sonido_Puerta_Final)
TRdcv.SetEndCloseSound(Sonido_Puerta_Final)
TRdcv.Squezze=1

TRdcvLever=Levers.PlaceLever("TRCanalVueltaLever",Levers.LeverType3,(184489.233738,19845.3111116,-59088.8782312),(0.707106769085,0.707106769085,0.0,0.0),0.2)
TRdcvLever.OnTurnOnFunc=TRAbreCanal
TRdcvLever.OnTurnOnArgs=(TRdcvLever,)


## Muro falso entrada canal

TRCanal=Bladex.GetSector(177737.524673, 20980.7317952, -53698.002747)
TRCanal.InitBreak((0.0, 0.0, 300.0), (1230.0, 0.0, 0.0), (0.0, 730.0, 0.0),"piedra pesada")
TRCanal.Active=0
TRCanalGolpe=Bladex.GetSector(177737.524673, 20980.7317952, -54000)
TRCanalGolpe.ActiveSurface= 0.0, 0.0, -1.0
TRCanalGolpe.OnHit=RompeMuroCanal

## Muro falso salida trampa

TRCanalMDSalida=Bladex.GetSector(195229.428899, 23931.9573761, -59492.2165488)
TRCanalMDSalida.InitBreak((-500,0,0),(0,0,-1200),(0,800,0),"piedra pesada")
TRCanalMDSalida.Active=0
TRCanalMDSalidaGolpe=Bladex.GetSector(195423.950047, 23932.0271664, -59553.578572)
TRCanalMDSalidaGolpe.ActiveSurface= 1.0, 0.0, 0.0
TRCanalMDSalidaGolpe.OnHit=RompeMuroCanalSalida

## Trampa Pinchos

TRMDCanal = Doors.CreateDoor("TRMuroDeslizanteCanal",  (198989.992374, 24932.2870556, -60937.5808927), (-1,0,0),  0, 13000, Doors.OPENED)
TRMDCanal.SetWhileOpenSound(Sonido_Puerta_Subiendo)
TRMDCanal.SetWhileCloseSound(Sonido_Puerta_Subiendo)
TRMDCanal.SetEndOpenSound(Sonido_Puerta_Final)
TRMDCanal.SetEndCloseSound(Sonido_Puerta_Final)
TRMDCanal.Squezze=1
TRMDCanal.sld_area().HitFunc = Doors.DoorHit
TRMDCanal.sld_area().OnStopFunc=Doors.EndOpenFunc

PM11=Bladex.CreateEntity("PinchoManuel_981_11","PinchoManuel",207600+1800,25000,-58167+1000, Reference.ObjType("PinchoManuel"))
PM11.Scale=1.0
PM11.Static=1
PM11.Orientation=(1.0,0.0,0.0,0.0)

PV11=Bladex.CreateEntity("Lanzapivotes_981_11","Lanzapivotes",208600.0,25000,-58167+1000, Reference.ObjType("PinchoManuel"))
PV11.Scale=4.8
PV11.Static=1
PV11.Orientation=(0.5, -0.5, -0.5, -0.5)


PM12=Bladex.CreateEntity("PinchoManuel_981_12","PinchoManuel",207600+1800,25000,-58167-2700, Reference.ObjType("PinchoManuel"))
PM12.Scale=1.0
PM12.Static=1
PM12.Orientation=(1.0,0.0,0.0,0.0)

PV12=Bladex.CreateEntity("Lanzapivotes_981_12","Lanzapivotes",208600.0,25000,-58167-2700, Reference.ObjType("PinchoManuel"))
PV12.Scale=4.8
PV12.Static=1
PV12.Orientation=(0.5, -0.5, -0.5, -0.5)

PM13=Bladex.CreateEntity("PinchoManuel_981_13","PinchoManuel",207600+1800,25000,-58167-6000, Reference.ObjType("PinchoManuel"))
PM13.Scale=1.0
PM13.Static=1
PM13.Orientation=(1.0,0.0,0.0,0.0)

PV13=Bladex.CreateEntity("Lanzapivotes_981_13","Lanzapivotes",208600.0,25000,-58167-6000, Reference.ObjType("PinchoManuel"))
PV13.Scale=4.8
PV13.Static=1
PV13.Orientation=(0.5, -0.5, -0.5, -0.5)

PM21=Bladex.CreateEntity("PinchoManuel_981_21","PinchoManuel",207600+1800,24000,-56667-2100, Reference.ObjType("PinchoManuel"))
PM21.Scale=1.0
PM21.Static=1
PM21.Orientation=(1.0,0.0,0.0,0.0)

PV21=Bladex.CreateEntity("Lanzapivotes_981_21","Lanzapivotes",208600.0,24000,-56667-2100, Reference.ObjType("PinchoManuel"))
PV21.Scale=4.8
PV21.Static=1
PV21.Orientation=(0.5, -0.5, -0.5, -0.5)

PM22=Bladex.CreateEntity("PinchoManuel_981_22","PinchoManuel",207600+1800,24000,-56667-6050, Reference.ObjType("PinchoManuel"))
PM22.Scale=1.0
PM22.Static=1
PM22.Orientation=(1.0,0.0,0.0,0.0)

PV22=Bladex.CreateEntity("Lanzapivotes_981_22","Lanzapivotes",208600.0,24000,-56667-6050, Reference.ObjType("PinchoManuel"))
PV22.Scale=4.8
PV22.Static=1
PV22.Orientation=(0.5, -0.5, -0.5, -0.5)

PM31=Bladex.CreateEntity("PinchoManuel_981_31","PinchoManuel",207600+1800,23000,-58167+1000, Reference.ObjType("PinchoManuel"))
PM31.Scale=1.0
PM31.Static=1
PM31.Orientation=(1.0,0.0,0.0,0.0)

PV31=Bladex.CreateEntity("Lanzapivotes_981_31","Lanzapivotes",208600.0,23000,-58167+1000, Reference.ObjType("PinchoManuel"))
PV31.Scale=4.8
PV31.Static=1
PV31.Orientation=(0.5, -0.5, -0.5, -0.5)


PM32=Bladex.CreateEntity("PinchoManuel_981_32","PinchoManuel",207600+1800,23000,-58167-2700, Reference.ObjType("PinchoManuel"))
PM32.Scale=1.0
PM32.Static=1
PM32.Orientation=(1.0,0.0,0.0,0.0)

PV32=Bladex.CreateEntity("Lanzapivotes_981_32","Lanzapivotes",208600.0,23000,-58167-2700, Reference.ObjType("PinchoManuel"))
PV32.Scale=4.8
PV32.Static=1
PV32.Orientation=(0.5, -0.5, -0.5, -0.5)

PM33=Bladex.CreateEntity("PinchoManuel_981_33","PinchoManuel",207600+1800,23000,-58167-6000, Reference.ObjType("PinchoManuel"))
PM33.Scale=1.0
PM33.Static=1
PM33.Orientation=(1.0,0.0,0.0,0.0)

PV33=Bladex.CreateEntity("Lanzapivotes_981_33","Lanzapivotes",208600.0,23000,-58167-6000, Reference.ObjType("PinchoManuel"))
PV33.Scale=4.8
PV33.Static=1
PV33.Orientation=(0.5, -0.5, -0.5, -0.5)

##-------------------------------------------------------------
## Muro deslizante
##-------------------------------------------------------------


## Puerta trasera


TRdm = Doors.CreateDoor("TRMuro",  (142856.581807, 19946.5226468, -61213.5024223), (0,1,0),  0, 3200, Doors.CLOSED)
TRdm.opentype=Doors.UNIF
TRdm.o_med_vel=-700
TRdm.o_med_displ=3200
TRdm.closetype=Doors.AC
TRdm.c_init_displ=3200
TRdm.c_med_vel=8000
TRdm.SetWhileOpenSound(Sonido_Puerta_Subiendo)
TRdm.SetEndOpenSound(Sonido_Puerta_Final)
TRdm.SetEndCloseSound(Sonido_Puerta_Final)
TRdm.Squezze=1

TRmd=Bladex.GetSector(139462.873863, 19946.8256046, -61183.1946526)
TRmd.OnEnter=EntraMuroDeslizante


TRdm2 = Doors.CreateDoor("TRMuroDeslizante",  (139462.873863, 19946.8256046, -61183.1946526), (1,0,0),  0, 13000, Doors.OPENED)
TRdm2.SetWhileOpenSound(Sonido_Puerta_Subiendo)
TRdm2.SetWhileCloseSound(Sonido_Puerta_Subiendo)
TRdm2.SetEndOpenSound(Sonido_Puerta_Final)
TRdm2.SetEndCloseSound(Sonido_Puerta_Final)
TRdm2.Squezze=1
TRdm2.sld_area().HitFunc = Doors.DoorHit
TRdm2.sld_area().OnStopFunc=Doors.EndOpenFunc

o=Bladex.CreateEntity("Lapidareina_668","Lapidareina",135679.784093,20700.,-63786.6057597, Reference.ObjType("Lapidareina"))
o.Scale=1.0
o.Solid=1
o.Orientation=(0.5,0.5,-0.5,0.5)

o=Bladex.CreateEntity("Lapidarey_669","Lapidarey",135679.784093,20700.,-57787.3636817, Reference.ObjType("Lapidarey"))
o.Scale=1.0
o.Solid=1
o.Orientation=(0.5,0.5,-0.5,0.5)

Bladex.SetTriggerSectorFunc("LpReina", "OnEnter", MDEntraLpReina )
Bladex.SetTriggerSectorFunc("LpReina", "OnLeave", MDSalLpReina )
Bladex.SetTriggerSectorFunc("LpRey", "OnEnter", MDEntraLpRey )
Bladex.SetTriggerSectorFunc("LpRey", "OnLeave", MDSalLpRey )


##-------------------------------------------------------------
## Ascensor
##-------------------------------------------------------------


TRasc=Bladex.GetSector(111376.62729, 23939.0176691, -60236.4628645)
TRasc.OnEnter=EntraAscensor

o=Bladex.CreateEntity("Ascensor_676","Plataforma",110960.735336,25041.7396712,-60603.1155438, Reference.ObjType("Plataforma"))
o.Scale=3.2
o.Orientation=(0.707106769085,0.707106769085,0.0,0.0)

##-------------------------------------------------------------
## Misiles
##-------------------------------------------------------------

TRMS=Bladex.GetSector(111637.085651, 6946.84552823, -64392.3409438)
TRMS.OnEnter=EntraMisiles


##-------------------------------------------------------------
## Laberinto
##-------------------------------------------------------------

Bladex.SetTriggerSectorFunc("Maze", "OnEnter", EntraMaze )

##-------------------------------------------------------------
## Salon de la Magia
##-------------------------------------------------------------


for i in range(30):
	if i>10:
		aux=0.0
	else:
		aux=(10.0-i)/10.0
	r=100
	g=100
	b=255
	a=255*math.sqrt(1.0-aux)
	size=30.0*math.sqrt(1.0-aux)
	Bladex.SetParticleGVal("Chispas",i,r,g,b,a,size)


Bladex.AddParticleGType("ChispasM","GenericParticle",B_PARTICLE_GTYPE_ADD,20)

for i in range(20):
	if i>10:
		aux=0.0
	else:
		aux=(10.0-i)/10.0
	r=100
	g=100
	b=255
	a=255*math.sqrt(1.0-aux)
	size=15.0*math.sqrt(1.0-aux)
	Bladex.SetParticleGVal("ChispasM",i,r,g,b,a,size)


#TRMagia=Bladex.GetSector(177717.62571, 6933.97731142, -114811.628806)
TRMagia=Bladex.GetSector(179823.241944, 6902.95283238, -114701.425023)
TRMagia.OnEnter=EntraSalonMagia
MAX_AMP=100.0 
MIN_LEN=1000000.0 #200000.0

rayo1=Bladex.CreateEntity("Rayo1", "Entity ElectricBolt", 0, 0, 0)
rayo1.Position= 194384.0, 7300.0, -112077.0
rayo1.Target=194384.0, 7300.0, -112077.0-4300
rayo1.MaxAmplitude=MAX_AMP
rayo1.MinSectorLength=MIN_LEN
rayo1.Active=0

rayo2=Bladex.CreateEntity("Rayo2", "Entity ElectricBolt", 0, 0, 0)
rayo2.Position= 194384.0, 7300.0-1000, -112077.0
rayo2.Target=194384.0, 7300.0-1000, -112077.0-4300
rayo2.MaxAmplitude=MAX_AMP
rayo2.MinSectorLength=MIN_LEN
rayo2.Active=0

rayo3=Bladex.CreateEntity("Rayo3", "Entity ElectricBolt", 0, 0, 0)
rayo3.Position=194384.0, 7300.0-2000, -112077.0
rayo3.Target=194384.0, 7300.0-2000, -112077.0-4300
rayo3.MaxAmplitude=MAX_AMP
rayo3.MinSectorLength=MIN_LEN
rayo3.Active=0


Bladex.SetTriggerSectorFunc("Rayo", "OnEnter", MuerteRayo )


##-------------------------------------------------------------
## Falso Puente
##-------------------------------------------------------------

Bladex.SetTriggerSectorFunc("Puente", "OnEnter", EntraFalsoPuente )


##-------------------------------------------------------------
## Runa del Conocimiento
##-------------------------------------------------------------



Bladex.ReadAlphaBitMap("../../Data/Estrellita.bmp","Estrellita")

Bladex.AddParticleGType("Chispas","Estrellita",B_PARTICLE_GTYPE_ADD,60)

for i in range(60):
	traux=(i)/60.0
	r=249.0
	g=249.0
	b=249.0
	a=255.0*(traux)
	size=80.0*(1.0-traux)
	Bladex.SetParticleGVal("Chispas",i,r,g,b,a,size)


Bladex.AddParticleGType("LuzSolida","SmokeParticle",B_PARTICLE_GTYPE_ADD,240)

for i in range(240):
	if i>120:
		aux=(i-120.0)/120.0 # 1->0
	else:
		aux=(120.0-i)/120.0 # 0->1
	r=0
	g=0
	b=255
	a=70.0*(1.0-aux)**2.0
	size=1400.0
	Bladex.SetParticleGVal("LuzSolida",i,r,g,b,a,size)


TRRuna=Bladex.GetSector(217106., -7116., -72600.)
TRRuna.OnEnter=EntraSalaRuna 

TRTRuna=Bladex.GetSector(212497,-11122,-55221)
TRTRuna.Active=0
TRTRuna.InitBreak((0,600,0), (700,0,0), (0.0, 730.0, 0.0), "piedra pesada")

TRfinal=Bladex.GetSector(207823,-7275,-61024)
TRfinal.Active=0
TRfinal.InitBreak((300,0,0), (0,0,1600), (0.0, 730.0, 0.0), "piedra pesada")

TRPasilloRuna=Bladex.GetSector(205219.413983, -7070.76108966, -61038.0996423)
TRPasilloRuna.OnEnter=PasilloRuna


##-------------------------------------------------------------
## Salida
##-------------------------------------------------------------


TRdsal = Doors.CreateDoor("TRSalida",  (181702, -7071, -42875), (0,1,0),  0, 3200, Doors.CLOSED)
TRdsal.opentype=Doors.UNIF
TRdsal.o_med_vel=-700
TRdsal.o_med_displ=3200
TRdsal.closetype=Doors.AC
TRdsal.c_init_displ=3200
TRdsal.c_med_vel=8000
TRdsal.SetWhileOpenSound(Sonido_Puerta_Subiendo)
TRdsal.SetEndOpenSound(Sonido_Puerta_Final)
TRdsal.SetEndCloseSound(Sonido_Puerta_Final)
TRdsal.Squezze=1

TRSalLever=Levers.PlaceLever("TRSalidaLever",Levers.LeverType3,(182459, -7357, -41545),(0.612372457981, 0.612372457981, -0.353553324938, 0.35355335474),1)
TRSalLever.OnTurnOnFunc=TRAbreSalida
TRSalLever.OnTurnOnArgs=()
TRSalLever.OnTurnOffFunc=TRCierraSalida
TRSalLever.OnTurnOffArgs=()

TRCampamento=Bladex.GetSector (175834.40475, -8068.59719677, -41868.8007324)

