import Bladex
import ItemTypes
import GenFX
import Reference
import Actions
import B3DLib
import InitDataField
import Change
import MenuText
import Language
import Damage
import ObjStore
import math


################################################################################
### Auxiliary Functions
################################################################################


# Use Fire Potion
def UseFirePotion (EntityName):
	me=Bladex.GetEntity(EntityName)	
	try:
	  if me.Data.UsingFirePotion:
	     if me.Data.UsingFirePotion == 1:
	        return 0
	except:
	  me.Data.UsingFirePotion=0
	if EntityName <> 'Player1':
	   MaxFirePotionDist = 2000*2000 + Bladex.GetCharType(me.CharType,me.CharTypeExt).MaxCombatDist*2
	   pj = Bladex.GetEntity('Player1')
	   if not me.CanISee (pj):
	        return 1
	   if me.SQDistance2(pj) > MaxFirePotionDist*MaxFirePotionDist:
	        return 1

	if me.Wuea==Reference.WUEA_WAIT:
	# Interrupt current animation
	  me.Wuea=Reference.WUEA_ENDED
	  me.SetTmpAnmFlags(1,1,1,0,5,1,0)
	  #me.InterruptCombat()  
	  #me.AnmEndedFunc = UseFirePotion
	  #return 0

	if me and me.Life >0:
		inv = me.GetInventory()
		for x in range (inv.nObjects):
			item_name = inv.GetObject(x)
			if item_name == None: return 0
			item = Bladex.GetEntity(item_name)
			if item.Data and item.Data.__class__==FirePotion:
				me.Data.UsingFirePotion=1
				ThrowForce = 0.5
				#Bladex.AddScheduledFunc(Bladex.GetTime()+4.0, RestoreWeapon2,(me.Name,),"UseFirePotionSafeRestore")
				me.Data.HitFuncOrg=me.HitFunc
				me.HitFunc=InterruptFirePotion
				ThrowInvObject (EntityName, item.Name, ThrowForce)
				return 1			
	return 0

def ThrowInvObject (EntityName, ObjectName, ThrowForce):	
	pers=Bladex.GetEntity(EntityName)
	if pers and pers.Life >0:
	   inv = pers.GetInventory()
	   for x in range (inv.nObjects):
	   	if inv.GetObject(x) == ObjectName:
   	           pers.Data.ThrowForce = ThrowForce
   	           pers.Data.throw_weapon = pers.InvRight
		   #pers.Wuea = Reference.WUEA_ENDED
		   #pers.SetTmpAnmFlags(1,1,1,0,5,1,0)
   	           Change.ChangeObject(EntityName, ObjectName, ThrowObjectFromInv)
		   #pers.LaunchAnmType("Chg_r")
   	           break


def ThrowObjectFromInv (EntityName, ObjectName):
	pers=Bladex.GetEntity(EntityName)
	inv=pers.GetInventory()
	Reference.EntitiesObjectData[ObjectName]= [Reference.OBJ_STANDARD,   2, 0, 1.0, Reference.THR_SPINNING, []]
	if pers and pers.Life >0:
	   inv.RemoveObject(ObjectName)
   	   Actions.StdThrowObject (pers.Name)


def InterruptFirePotion (EntityName, WeaponName, Cx, Cy, Cz, Px, Py, Pz, WeaponCx, WeaponCy, WeaponCz,WeaponDx, WeaponDy, WeaponDz):
	pers=Bladex.GetEntity(EntityName)
	pers.Wuea = Reference.WUEA_ENDED
	pers.SetTmpAnmFlags(1,1,1,0,5,1,0)
	pers.AnmEndedFunc=None
	pers.DelAnmEventFunc("ThrowLightFacingEvent")
	pers.HitFunc=pers.Data.HitFuncOrg
	pers.Data.HitFunc
	WeaponName= pers.Data.throw_weapon
	RestoreWeapon (EntityName)
	if not pers.InvRight and WeaponName <> None:
	   inv=pers.GetInventory()
	   inv.LinkRightHand(WeaponName)
	else:
	   item = Bladex.GetEntity(pers.InvRight)
	   if item.Data and item.Data.__class__==FirePotion:
	      inv=pers.GetInventory()
	      inv.LinkRightHand(WeaponName)

def RestoreWeapon (EntityName):
#	Bladex.RemoveScheduledFunc("UseFirePotionSafeRestore")
	pers=Bladex.GetEntity(EntityName)
	WeaponName= pers.Data.throw_weapon
	if WeaponName <> None:
	   pers.Data.throw_weapon = None
	   inv=pers.GetInventory()
	   inv.LinkRightHand(WeaponName)
	   pers.Data.UsingFirePotion=0


################################################################################
### Invincibility talisman
################################################################################

class AmuletoInvincibility (ItemTypes.ItemOfProtection):
        def __init__ (self, me):
                ItemTypes.ItemOfProtection.__init__(self, me)
                self.UsedBy= "Player1"
                self.UseTime= 30.0
                self.Resistances= {}
                self.nUses= 2

        def UseStart (self, ObjectName, use_from):
                ItemTypes.ItemOfProtection.UseStart (self, ObjectName, use_from)
                pj=Bladex.GetEntity('Player1')
                pj.Data.Invincibility= 1
                #GenFX.AddPersonItemFX(self.UsedBy, ObjectName, self.UseTime)
                pj.Data.PersonItemFX=GenFX.PersonItemFX(pj.Name, ObjectName, self.UseTime)
		    


        def UseEnd (self,ObjectName, UserName):
                pj=Bladex.GetEntity('Player1')
                pj.Data.Invincibility= 0
                ItemTypes.ItemOfProtection.UseEnd (self, ObjectName, UserName)


################################################################################
### Fire Potion
################################################################################


class FirePotion (ItemTypes.PersistantItemType):

	
	def __init__(self, me):
		ItemTypes.PersistantItemType.__init__(self, me)
		me.Weapon= 1
		self.Name= me.Name
		self.Age = 0
		self.Hit = 0
		self.fireballName=None
		
		self.WhileSound=Bladex.CreateEntity (me.Name+"FirePotionLoopSound", "Entity Sound", 0, 0, 0)
		self.WhileSound.SetSound("..\\..\\Sounds\\energy-ball.wav")
		self.WhileSound.MinDistance=5000
		self.WhileSound.MaxDistance=30000
		me.Link(self.WhileSound)
		
		self.ImpactSound=Bladex.CreateEntity (me.Name+"FirePotionImpactSound", "Entity Sound", 0, 0, 0)
		self.ImpactSound.SetSound("..\\..\\Sounds\\energy-ball-impact.wav")
		self.ImpactSound.MinDistance=5000
		self.ImpactSound.MaxDistance=30000
		self.OwnerName= ""
		self.WeaponFX = None
		
		Reference.EntitiesObjectData[self.Name]= [Reference.OBJ_ITEM]
		
		Reference.StackObjects['Botella']= 4
		
		weapon= Bladex.GetEntity(self.Name)
		InitDataField.Initialise(weapon)
		self.AddFirePotionFX(weapon.Name)
		
		if Language.Current == "Spanish":
           		MenuText.ForeingDict['Fire Potion'] = 'Pocin de Fuego'
		Reference.EntitiesSelectionData[self.Name]=(8,4000,MenuText.GetMenuText('Fire Potion'))

		me.UseFunc = self.UseFirePotion

		
	def __getstate__(self):
		state= ItemTypes.PersistantItemType.__getstate__(self)
		state[1]["FirePotion"]=   (				self.Name,
									self.Age,
									self.Hit,
									self.fireballName,
									self.WhileSound.Name,
									self.ImpactSound.Name,
									self.OwnerName,
									self.WeaponFX
									)
		return state
		
	def __setstate__(self,parm):
		ItemTypes.PersistantItemType.__setstate__(self,parm)
		if parm[0]==1:
			parms=parm[1]["FirePotion"]
			self.Name=parms[0]
			self.Age=parms[1]
			self.Hit= parms[2]
			self.fireballName= parms[3]
			self.WhileSound= Bladex.GetEntity(parms[4])
			self.ImpactSound= Bladex.GetEntity(parms[5])
			self.OwnerName=  parms[6]
			self.WeaponFX= parms[7]
		else:
			self.Name=""
			self.Age=0
			self.Hit= 0
			self.fireballName= None
			self.WhileSound= Bladex.GetEntity(self.Name+"MissileLoopSound")
			self.ImpactSound= Bladex.GetEntity(self.Name+"MissileImpactSound")
			self.OwnerName= "Player1"
			self.AddFirePotionFX
		
	def AddFirePotionFX(self, EntityName):
		weapon=Bladex.GetEntity(EntityName)
		auraparams=(40, 1, 1, 0, 0, 1)
		auragradient=(2, 0.8, 0.6, 0.0, 0.6, 0.0, 0.8, 0.1, 0.0, 0.0, 0.6)
		prtldata=("Llamita", 400, (0.0, 0.0, 0.0), 1.0, 0.0, -1000.0, 0.02, 0.0, 10)
		lightdata=(1.0, (255, 120, 0), 1)
		weapon.SelfIlum=0.8
		weapon.Data.WeaponFX=GenFX.WeaponFX(EntityName, auraparams, auragradient, prtldata, lightdata)


	def UseFirePotion(self, PotionName, TipoUso):
		potion=Bladex.GetEntity(PotionName)

		if TipoUso == Actions.USE_FROM_INV:
		   ownerName= potion.Data.UsedBy
		   Actions.FreeBothHands(ownerName)
		   owner=Bladex.GetEntity(ownerName)
		   if owner and owner.Life >0:
      	              owner.Data.throw_weapon = None
      	              inv=owner.GetInventory()
      	              inv.RemoveObject(PotionName)
   	              Change.ChangeObject(ownerName, PotionName, self.FinishChange)
   	        elif TipoUso == Actions.USE_FROM_TAKE:
		   Actions.StdUse (ownerName)


	def FinishChange(self, EntityName,ObjectName):
	       	Reference.EntitiesObjectData[ObjectName]= [Reference.OBJ_STANDARD,   2, 0, 1.0, Reference.THR_SPINNING, []]
   
	def DropReleaseEventHandler (self,EntityName,EventName):
		weapon= Bladex.GetEntity(self.Name)
		if not weapon:
			return
		self.OwnerName= weapon.Parent
		if not self.OwnerName:
			return		
		owner=Bladex.GetEntity(self.OwnerName)
		if not owner or owner.InvRight != self.Name or owner.Life <= 0:
			return	
		if weapon.TestHit:
			return
		Actions.RemoveFromInventory (owner, weapon, EventName)
		ix, iy, iz = owner.Rel2AbsVector(-1000.0, -1500.0, 0.0)
		Reference.EntitiesObjectData[weapon.Name]= [Reference.OBJ_ITEM]
		weapon.Impulse(ix, iy, iz)
		weapon.ExcludeHitFor(owner)
		owner.DelAnmEventFunc(EventName)

	def ThrowThisObject (self,EntityName,EventName):
		pj=Bladex.GetEntity ('Player1')
		object= Bladex.GetEntity(self.Name)
		if not object:
			return
		self.OwnerName= object.Parent
		#if object.TestHit:
		#	###Reference.debugprint(EntityName+": Pre-colliding - abandoning throw")
		#	return

		me=Bladex.GetEntity(self.OwnerName)
		if not me or me.InvRight != self.Name or me.Life <=0 :
			return

		#if self.OwnerName <> 'Player1':
		#   MaxFirePotionDist = Bladex.GetCharType(me.CharType,me.CharTypeExt).MaxCombatDist*2
		#   if me.SQDistance2(pj) > MaxFirePotionDist*MaxFirePotionDist:
		#        return
		
		# Remove from inventory
		Actions.RemoveFromInventory (me, object, EventName)
		# Calculate impulse depending on event type

		# calculate impulse from keypress duration multiplier and character strength
		F= me.Data.ThrowForce*34000.0

		target = None
		if me.InCombat:
			target= Bladex.GetEntity(me.ActiveEnemy)
			target_pos= target.Position
			source_pos= object.Position
			x= target_pos[0]-source_pos[0]
			y= target_pos[1]-source_pos[1]
			z= target_pos[2]-source_pos[2]
			angle, time= Actions.AutoCalcThrow (math.sqrt(x*x+z*z), y, F/object.Mass,+9800.0)
			#angle= -B3DLib.GetYAngle(x,y,z)
		elif self.OwnerName <> 'Player1' and me.CanISee (pj):
			target= pj
			target_pos= target.Position
			source_pos= object.Position
			x= target_pos[0]-source_pos[0]
			y= target_pos[1]-source_pos[1]
			z= target_pos[2]-source_pos[2]
			angle, time= Actions.AutoCalcThrow (math.sqrt(x*x+z*z), y, F/object.Mass,+9800.0)				
			#angle= -B3DLib.GetYAngle(x,y,z)

		elif EventName == "ThrowLightFacingEvent":
			angle= -Actions.PI*0.0625 # max angle/4
		elif EventName == "ThrowHeavyFacingEvent":
			angle= -Actions.PI*0.125 # max angle/2
		else:
			angle= -Actions.PI*0.0625 # max angle/4

		impulse = me.Rel2AbsVector(0.0, -math.cos(angle)*F, -math.sin(angle)*F)

		if target <> None:
			object.Data.ETarget=target.Name # Don't works
			angle= B3DLib.Pos2PosXZAngle(source_pos[0], source_pos[1], source_pos[2],target_pos[0], target_pos[1], target_pos[2])
			diff_angle= min (max (B3DLib.DiffAngle(angle, me.Angle), -Actions.FACINGANGLE), Actions.FACINGANGLE)
			x,y,z= impulse
			cos_ang= math.cos(diff_angle); sin_ang= math.sin(diff_angle)
			impulse = (x*cos_ang-z*sin_ang, y, x*sin_ang+z*cos_ang)

		object.Impulse(impulse[0], impulse[1], impulse[2])
		
		if self.OwnerName <> 'Player1':
		   me.HitFunc=me.Data.HitFuncOrg

		throw_style= Reference.THR_SPINNING
		if Reference.EntitiesObjectData.has_key(object.Name):
			if Reference.EntitiesObjectData[object.Name][0] == Reference.OBJ_WEAPON or Reference.EntitiesObjectData[object.Name][0] == Reference.OBJ_STANDARD:
				weaponData= Reference.EntitiesObjectData[object.Name]
				if len(weaponData) > 4:
					throw_style= weaponData[4]
		else:
			kind = Bladex.GetEntity(object.Name).Kind
			if Reference.DefaultObjectData.has_key(kind):
				if Reference.DefaultObjectData[kind][0] == Reference.OBJ_WEAPON or Reference.DefaultObjectData[kind][0] == Reference.OBJ_STANDARD:
					weaponData = Reference.DefaultObjectData[kind]
					if len(weaponData) > 4:
						throw_style= weaponData[4]
		# exclude people from collision
		object.ExclusionMask= object.ExclusionMask | Actions.B_SOLID_MASK_PERSON

		if throw_style == Reference.THR_SPINNING:
			# Add an angular velocity component as well...
			#print object.AngularVelocity
			axis= object.GetDummyAxis("1H_R", 0.0, 1.0, 0.0)
			mass= object.Mass
			#print mass
			scale = TWOPI*10/mass
			object.AngularVelocity=axis[0]*scale,axis[1]*scale,axis[2]*scale
		object.MessageEvent(Actions.MESSAGE_START_WEAPON,0,0)
		object.MessageEvent(Actions.MESSAGE_START_TRAIL,0,0)
		object.Data.PrevHitFunc= None
		Bladex.AddScheduledFunc(Bladex.GetTime()+2.0, Actions.ThrownWeaponStopFunc,(object.Name,),"Stop Weapon: "+object.Name)
		object.Data.PrevInflictHitFunc= self.FirePotionInflictHitFunc
		object.InflictHitFunc= Actions.ThrownWeaponInflictHitFunc
		object.Data.ThrownBy= me

	def FirePotionInflictHitFunc(self, EntityName, VictimName, ImpX, ImpY, ImpZ):
		# ImpX/Y/Z don't works
		self.FirePotionHit (EntityName, VictimName, 0,0,0,0,0,0,0,0,0,0,0,0)

	def FirePotionHit(self, prtl_name,hit_entity,x,y,z,vx,vy,vz,wcx,wcy,wcz,wdx,wdy,wdz):
		if hit_entity != self.Name and not self.Hit:
			self.Hit=1
			object= Bladex.GetEntity(self.Name)
			object.RemoveFromList("Timer60")
			object.TimerFunc=""
			object.Stop()
			object.RemoveFromWorld()
			try:
			  del ObjStore.ObjectsStore[self.persistent_id()]
			except:
			  pass
			object.SubscribeToList ('Pin')
			if hit_entity == 'BWorld':
			   pos = x,y,z
			else:
			   Victim = Bladex.GetEntity(hit_entity)
			   pos = Victim.Position
			self.Explosion (pos)
			self.ImpactSound.Position=pos
			self.ImpactSound.PlaySound(0)
			FirePotionArea = 3000
			FirePotionMaxDamage = 600
		        for ename in Bladex.GetEntitiesAt(pos[0],pos[1],pos[2], FirePotionArea):
			    pers=Bladex.GetEntity(ename)
			    if pers.Person and pers.Life > 0:
			       distance = B3DLib.GetXZDistance(prtl_name, pers.Name)
			       damage= int(FirePotionMaxDamage - (distance*FirePotionMaxDamage/FirePotionArea))
			       Bladex.AddScheduledFunc(Bladex.GetTime()+0.1, self.SmokeHit, (damage, prtl_name, pers.Name, x,y,z))
			Bladex.AddScheduledFunc(Bladex.GetTime(), self.DeleteWeaponData, (), "DeleteWeaponData")
			
	def SmokeHit(self, damage, prtl_name, VictimName, x,y,z):
		victim=Bladex.GetEntity(VictimName)
		Reference.EntitiesObjectData[prtl_name]= [Reference.OBJ_WEAPON, 0, 0,  1.0,  Reference.THR_STRAIGHT, Reference.W_FLAG_1H, ["Fire", damage]]
#		victim.DamageFunc(VictimName, self.Name, prtl_name, "Fire", 1, -1, x, y, z, 0)
		victim.DamageFunc(VictimName, None, prtl_name, "Fire", 1, -1, x, y, z, 0)
		if Reference.EntitiesObjectData.has_key(prtl_name):
			del Reference.EntitiesObjectData[prtl_name]

		# Generate a smoke effect
		smoke=Bladex.CreateEntity("FireballSmoke", "Entity Particle System D1", x, y, z)
		smoke.ParticleType="DarkSmoke"
		smoke.YGravity=-3000.0
		smoke.Friction=0.05
		smoke.PPS=80
		smoke.Velocity=0.0, -80.0, 0.0
		smoke.RandomVelocity=5.0
		smoke.DeathTime=Bladex.GetTime()+0.5
		node= 0
		victim.LinkToNode(smoke,node)
					
		# Override hurt anim
		if victim.Life>0:
			if victim.InCombat:
				Damage.DropInvalidObjectsOnImpact (victim.Name)
				victim.Wuea=Reference.WUEA_ENDED
				victim.InterruptCombat()
				victim.LaunchAnmType("hurt_f_big")
			else:
				Damage.DropInvalidObjectsOnImpact (victim.Name)
				victim.Wuea=Reference.WUEA_ENDED
				victim.InterruptCombat()
				victim.LaunchAnmType("hurt_f_big")

			
	def CreateTestParticle(self, EntityName, time):
		fireball=Bladex.GetEntity(self.fireballName)
		if(fireball and not self.Hit):
			prtl=fireball.GetParticleEntity()
			prtl.HitFunc=self.FirePotionHit
			prtl.ObjCTest= 1

	def ThrowReleaseEventHandler (self,EntityName,EventName):

		object = Bladex.GetEntity(self.Name)
#		Reference.EntitiesObjectData[object.Name]=[Reference.OBJ_WEAPON, 300, 0, 1.0, Reference.THR_STRAIGHT, [], ['Fire', +500]]
		Reference.EntitiesObjectData[object.Name]=[Reference.OBJ_WEAPON, 600, 0, 1.0, Reference.THR_STRAIGHT, []]
		self.OwnerName= object.Parent
		if not self.OwnerName:
			return		
		owner=Bladex.GetEntity(self.OwnerName)
		if owner.Life <=0: 
		        return
		if self.OwnerName <> 'Player1':
		   owner.AnmEndedFunc=RestoreWeapon
		self.ThrowThisObject (EntityName,EventName)

		fireball=Bladex.CreateEntity(object.Name+"_Fire", "Entity Particle System Dobj", 0, 0, 0)
		fireball.ObjectName=object.Name
		fireball.ParticleType="RedMagicMissile"
		fireball.PPS=100
		fireball.YGravity=0.0
		fireball.Friction=0.04
		fireball.Velocity=0.0, 0.0, 0.0
		fireball.RandomVelocity=-5.0
		fireball.Time2Live=25
		self.Hit= 0
		self.fireballName=fireball.Name
		object.TimerFunc=self.CreateTestParticle
		object.SubscribeToList("Timer60")
	
	def QuickSmokeBall(self, Position):
		wps=Bladex.CreateEntity(PersonName+"WPFr", "Entity Particle System D1",  Position[0],Position[1],Position[2])
		wps.PersonName=PersonName
		wps.ParticleType="LargeFire"
		wps.Time2Live=32
		wps.RandomVelocity=0
		wps.Velocity=0,0,0
		wps.NormalVelocity=5
		wps.YGravity=0
		wps.PPS=2048
		wps.DeathTime=Bladex.GetTime()+0.125

	def Explosion(self, Position):
		llamarada=Bladex.CreateEntity("FPExplosion", "Entity Particle System D1", Position[0],Position[1],Position[2])
		llamarada.ParticleType="LargeFire"
		llamarada.YGravity=300.0
		llamarada.Friction=0.05
		llamarada.PPS=2048
		llamarada.Velocity=0.0, 0.0, 0.0
		llamarada.NormalVelocity=50
		llamarada.RandomVelocity=30.0
		llamarada.Time2Live=32
		llamarada.DeathTime = Bladex.GetTime() + 0.6
		

	def DeleteWeaponData(self):
		if self.Name and Reference.EntitiesObjectData.has_key(self.Name):
			del Reference.EntitiesObjectData[self.Name]
			

################################################################################
### Main api Functions
################################################################################

def CreateFirePotion (fireName, firePosx, firePosy, firePosz):
	firepotion=Bladex.CreateEntity(fireName,"Botella",firePosx,firePosy,firePosz, "Weapon")
	firepotion.Data=FirePotion(firepotion)
	firepotion.Orientation=0.707106769085, 0.707106769085, 0.0, 0.0
	return firepotion.Data
