"""

To debug
import MoriaMod
reload (MoriaMod)
BODLoader.BLModInfo['Moria']['Menu']=MoriaMenu.ModMenu
BODLoader.ReBuildInstalledModsMenu()

"""

######################################################################################	
# Moria Mod Menu
######################################################################################	

import Bladex
import Menu
import MenuText
import BUIx
import Raster
import MenuWidget
import ScorerWidgets
import BBLib
import math
import sys
import Language

######################################################################################	
# Set current Language files
######################################################################################	

if Language.Current == 'Spanish':
	Lang = Language.Current
else:
	Lang = ""

######################################################################################	
# Configuration
######################################################################################	

Personajes = {	 "Damathar":  {"Index":0,"Type":"Knight_N","Skin":"Damathar"},
		 "Melian"  :  {"Index":1,"Type":"Amazon_N","Skin":"Melian"}
	     }

CharBitmaps = 	(
			("Damathar"    , "../Moria/"+Lang+"/Damathar.BMP"   ),
			("KgtSkin1"    , "../../Data/net/KgtSkin1.BMP"   ),
			("KgtSkin2"    , "../../Data/net/KgtSkin2.BMP"   ),
			("Melian"    , "../Moria/"+Lang+"/Melian.BMP"   ),
			("AmzSkin1"    , "../../Data/net/AmzSkin1.BMP"   ),
			("AmzSkin2"    , "../../Data/net/AmzSkin2.BMP"   ),
		)

PlayerName = "Damathar"
DifficultyLevel = 0

MenuLabel={}
MenuLabel['MoriaBanner'] = "Version  0.2  Demo Map"
MoriaLogoFile = "../Moria/"+Lang+"/MoriaMod.bmp"
ClsSkinImgList = None

try:
	execfile("../../Config/Moria.cfg")
except:
	pass

def SaveConfiguration():
	cfgfile = open("../../Config/Moria.cfg", "w")
	cfgfile.write('PlayerName = "' + str(PlayerName) + '"\n')
	cfgfile.write('DifficultyLevel = ' + str(DifficultyLevel) + '\n')
	cfgfile.close()

######################################################################################	
# Custom Widgets
######################################################################################	


class M_B_DescriptorLabel(MenuWidget.B_MenuItemTextNoFX):
	def __init__(self,Parent,MenuDescr,StackMenu):
		
		global MenuLabel
		
		MenuWidget.B_MenuItemTextNoFX.__init__(self,Parent,MenuDescr,StackMenu)
		self.SetDrawFunc(self.Draw)
		self.LastLabel = ""
		self.Parent = Parent
		self.VarName = MenuDescr["Name"]
		self.SetText(MenuLabel[self.VarName])
		self.Parent.RecalcLayout()

	def Draw(self,x,y,time):
		global MenuLabel

		if self.GetVisible()==0:
			return

		if self.LastLabel != MenuLabel[self.VarName]:
			self.SetText(MenuLabel[self.VarName])
			self.Parent.RecalcLayout()
			self.LastLabel = MenuLabel[self.VarName]
			self.Parent.RecalcLayout()

		foc=self.GetHasFocus()
		if foc:
			self.SetColor(252,247,167)
		else:
			self.SetColor(207,144,49)
		self.SetAlpha(1.0)
		self.DefDraw(x,y,time)

	def AcceptsFocus(self):
		return 0

class M_B_MenuItemOption(MenuWidget.B_MenuItemTextNoFX):
  def __init__(self,Parent,MenuDescr,StackMenu,
               font_server=ScorerWidgets.font_server):

    self.Options=["No option defined",]
    self.SelOption=0
    self.OptionText='' #MenuDescr["Name"]

    try:
      self.Options=MenuDescr["Options"]
    except KeyError:
      pass

    try:

      GetSelFunc=MenuDescr["SelOptionFunc"]
      OptionSel=GetSelFunc()
      #print "DM OptionSel",self.OptionText,OptionSel,self.Options
      self.SelOption=OptionSel
      print self.SelOption
    except KeyError:
      pass

    MenuWidget.B_MenuItemTextNoFX.__init__(self,Parent,MenuDescr,StackMenu)
    #self.SetDrawFunc(self.Draw)
    self.Parent=Parent

    OptionText=self.OptionText+" < "+str(self.Options[self.SelOption])+" >"
    self.SetText(OptionText)

  def __del__(self):
    pass
    #print "B_MenuItemOption.__del__()",self.Name()

  def ActivateItem(self,activate):
    if (activate==1):
    	
      self.SelOption=self.SelOption+1
      self.SelOption=self.SelOption% len(self.Options)

      OptionText=self.OptionText+" < "+self.Options[self.SelOption]+" >"
      self.SetText(OptionText)

      try: # Puede que Parent no herede de Frame
        self.Parent.RecalcLayout()
      except:
        pass

      try:
        command=self.MenuDescr["Command"]
        command(MenuText.GetInverseMenuText(self.Options[self.SelOption]))
      except KeyError:
        pass

      try: # Puede que Parent no herede de Frame
        self.Parent.RecalcLayout()
      except:
        pass

    elif activate==0:
      self.StackMenu.Pop()

  def FinalRelease(self):
    print "B_MenuItemOption.FinalRelease()"
    self.Parent=None
    #self.SetDrawFunc(None)

  def IncMenuItem(self):
    self.ActivateItem(1)


  def DecMenuItem(self):

      self.SelOption=self.SelOption+len(self.Options)-1
      self.SelOption=self.SelOption% len(self.Options)
      OptionText=self.OptionText+" < "+self.Options[self.SelOption]+" >"
      self.SetText(OptionText)

      try: # Puede que Parent no herede de Frame
        self.Parent.RecalcLayout()
      except:
        pass

      try:
        command=self.MenuDescr["Command"]
        command(MenuText.GetInverseMenuText(self.Options[self.SelOption]))
      except KeyError:
        pass

      try: # Puede que Parent no herede de Frame
        self.Parent.RecalcLayout()
      except:
        pass


class M_B_ImageListWidget(BUIx.B_RectWidget):

	def __init__(self,Parent,MenuDescr,StackMenu):
		global ClsSkinImgList

		imagelist=MenuDescr["ImageList"]
		self.Bitmap={}
		self.IDX = imagelist[0][0]

		for i in imagelist:
			bitm = BBLib.B_BitMap24()
			bitm.ReadFromBMP(i[1])
			self.Bitmap[i[0]] = bitm

		self.vidw,self.vidh=self.Bitmap[self.IDX].GetDimension()
		BUIx.B_RectWidget.__init__(self,Parent,MenuDescr["Name"],self.vidw,self.vidh)
		self.Selected=0
		self.Solid=0
		self.Border=0
		self.SetDrawFunc(self.Draw)
		ClsSkinImgList = self
		self.IDX         = MenuDescr["GetCharType"]()


	def ChangeImage(self,name):
		self.IDX = name

	def Draw(self,x,y,time):
		Raster.SetPosition(x,y)
		Raster.DrawImage(self.vidw,self.vidh,"BGR","Normal",self.Bitmap[self.IDX].GetData())
		self.DefDraw(x,y,time)

	def FinalRelease(self):
		global ClsSkinImgList
		ClsSkinImgList = None
		BUIx.B_RectWidget.FinalRelease(self)

	def AcceptsFocus(self):
		return 0


class M_B_LogoWidget(BUIx.B_RectWidget):

	def __init__(self,Parent,MenuDescr,StackMenu):

		LogoFile=MenuDescr["LogoFile"]
		self.Bitmap={}

		self.Logobmp = BBLib.B_BitMap24()
		self.Logobmp.ReadFromBMP(LogoFile)

		self.vidw,self.vidh=self.Logobmp.GetDimension()
		BUIx.B_RectWidget.__init__(self,Parent,MenuDescr["Name"],self.vidw,self.vidh)
		self.Selected=0
		self.Solid=0
		self.Border=0
		self.SetDrawFunc(self.Draw)

	def Draw(self,x,y,time):
		Raster.SetPosition(x,y)
		Raster.DrawImage(self.vidw,self.vidh,"BGR","Normal",self.Logobmp.GetData())
		self.DefDraw(x,y,time)

	def FinalRelease(self):
		BUIx.B_RectWidget.FinalRelease(self)

	def AcceptsFocus(self):
		return 0

######################################################################################	
# Menu methods
######################################################################################	

def GetPlayerName():
	global PlayerName
	return Personajes[PlayerName]['Index']

def NextPlayerName(option):
	global PlayerName, ClsSkinImgList
	PlayerName = option
	ClsSkinImgList.ChangeImage (Personajes[PlayerName]['Skin'])
	SaveConfiguration();

def GetPlayerSkin():
	global PlayerName
	return Personajes[PlayerName]['Skin']

def StartMoria (option):
	SaveConfiguration();
	import Bladex
	Bladex.LoadLevel("Inn")
	


if Language.Current == 'Spanish':
	Levels = ["Fcil", "Normal","Difcil"]
	DiffLabel = "Dificultad: "
else:
	Levels = ["Easy", "Medium","Hard"]
	DiffLabel = "Difficulty: "


def SetDifficulty(option):
	global DifficultyLevel
	DifficultyLevel = Levels.index(option)-1
	SaveConfiguration();


def GetDifficulty():
	global DifficultyLevel
	return DifficultyLevel+1
	
		  
ModMenu = [        {"Name":"",
                         "Font":Menu.MenuFontMed,
                         "Kind":M_B_LogoWidget,
                         "VSep":0,
                         "LogoFile":MoriaLogoFile
                   },
                   {"Name":'MoriaBanner',
                         "VSep":5,
                         "Font":Menu.MenuFontSmall,
                         "Kind":M_B_DescriptorLabel
                   },
	           {"Name":"",
                         "Font":Menu.MenuFontBig,
                         "Kind":M_B_MenuItemOption,
                         "VSep":20,
                         "Options":Personajes.keys(),
                         "SelOptionFunc":GetPlayerName,
                         "Command":NextPlayerName
                   },
		   {"Name":"Lista de jugadores",
			"Kind":M_B_ImageListWidget,
			"ImageList":CharBitmaps,
			"GetCharType":GetPlayerSkin,
			"VSep":10
		   },
		   {"Name"          :DiffLabel,
          		"Kind"          :MenuWidget.B_MenuItemOption,
          		"Font"          :Menu.MenuFontMed,
          		"Options"       :Levels,
          		"Command"       :SetDifficulty,
          		"SelOptionFunc" :GetDifficulty,
		        "VSep"          :10
                   },
	           {"Name":MenuText.GetMenuText("START"),
			"VSep":10,
			"Command":StartMoria,
		   },
		   {"Name":MenuText.GetMenuText("BACK"),
			"VSep":10,
			"Command":Menu.BackMenu,
		   },
		   {"Name":"Back",
			"Kind":MenuWidget.B_BackBlank
		   }
		  ]
