

######################################################################################	
# FugitiveII Menu
######################################################################################	

import Bladex
import Menu
import MenuText
import BUIx
import Raster
import MenuWidget
import ScorerWidgets
import BBLib
import math
import sys
import Language

######################################################################################	
# Set current Language files
######################################################################################	

if Language.Current == 'Spanish':
	Lang = Language.Current
else:
	Lang = ""

######################################################################################	
# Configuration
######################################################################################	

Personajes = {	 "Sargon":  {"Index":0,"Type":"Knight_N","Skin":"Sargon"},
		 "Zoe"  :  {"Index":1,"Type":"Amazon_N","Skin":"Zoe"},
		 "Naglfar":  {"Index":2,"Type":"Dwarf_N","Skin":"Naglfar"},
		 "Tukaram":  {"Index":3,"Type":"Barbarian_N","Skin":"Tukaram"}
	     }


CharBitmaps =  (
   ("Tukaram"   , "../../Data/net/Barbarian.BMP"   ),
   ("Zoe"       , "../../Data/net/Amazon_L.BMP"   ),
   ("Sargon"    , "../../Data/net/Knight_N.BMP"   ),
   ("Naglfar"   , "../../Data/net/Dwarf_N.BMP"   ),

  )



PlayerName = "Sargon"


MenuLabel={}
MenuLabel['F2Banner'] = "Version  1.0 "
F2MenuLogoFile = "../FugitiveII/"+Lang+"/F2Menu.bmp"
ClsSkinImgList = None

try:
	execfile("../../Config/FugitiveII.cfg")       
except:
	pass

def SaveConfiguration():
	cfgfile = open("../../Config/FugitiveII.cfg", "w")
	cfgfile.write('PlayerName = "' + str(PlayerName) + '"\n')
	cfgfile.close()

######################################################################################	
# Custom Widgets
######################################################################################	


class M_B_DescriptorLabel(MenuWidget.B_MenuItemTextNoFX):
	def __init__(self,Parent,MenuDescr,StackMenu):
		
		global MenuLabel
		
		MenuWidget.B_MenuItemTextNoFX.__init__(self,Parent,MenuDescr,StackMenu)
		self.SetDrawFunc(self.Draw)
		self.LastLabel = ""
		self.Parent = Parent
		self.VarName = MenuDescr["Name"]
		self.SetText(MenuLabel[self.VarName])
		self.Parent.RecalcLayout()

	def Draw(self,x,y,time):
		global MenuLabel

		if self.GetVisible()==0:
			return

		if self.LastLabel != MenuLabel[self.VarName]:
			self.SetText(MenuLabel[self.VarName])
			self.Parent.RecalcLayout()
			self.LastLabel = MenuLabel[self.VarName]
			self.Parent.RecalcLayout()

		foc=self.GetHasFocus()
		if foc:
			self.SetColor(252,247,167)
		else:
			self.SetColor(207,144,49)
		self.SetAlpha(1.0)
		self.DefDraw(x,y,time)

	def AcceptsFocus(self):
		return 0

class M_B_MenuItemOption(MenuWidget.B_MenuItemTextNoFX):
  def __init__(self,Parent,MenuDescr,StackMenu,
               font_server=ScorerWidgets.font_server):

    self.Options=["No option defined",]
    self.SelOption=0
    self.OptionText='' #MenuDescr["Name"]

    try:
      self.Options=MenuDescr["Options"]
    except KeyError:
      pass

    try:

      GetSelFunc=MenuDescr["SelOptionFunc"]
      OptionSel=GetSelFunc()
      #print "DM OptionSel",self.OptionText,OptionSel,self.Options
      self.SelOption=OptionSel
      print self.SelOption
    except KeyError:
      pass

    MenuWidget.B_MenuItemTextNoFX.__init__(self,Parent,MenuDescr,StackMenu)
    #self.SetDrawFunc(self.Draw)
    self.Parent=Parent

    OptionText=self.OptionText+" < "+str(self.Options[self.SelOption])+" >"
    self.SetText(OptionText)

  def __del__(self):
    pass
    #print "B_MenuItemOption.__del__()",self.Name()

  def ActivateItem(self,activate):
    if (activate==1):
    	
      self.SelOption=self.SelOption+1
      self.SelOption=self.SelOption% len(self.Options)

      OptionText=self.OptionText+" < "+self.Options[self.SelOption]+" >"
      self.SetText(OptionText)

      try: # Puede que Parent no herede de Frame
        self.Parent.RecalcLayout()
      except:
        pass

      try:
        command=self.MenuDescr["Command"]
        command(MenuText.GetInverseMenuText(self.Options[self.SelOption]))
      except KeyError:
        pass

      try: # Puede que Parent no herede de Frame
        self.Parent.RecalcLayout()
      except:
        pass

    elif activate==0:
      self.StackMenu.Pop()

  def FinalRelease(self):
    print "B_MenuItemOption.FinalRelease()"
    self.Parent=None
    #self.SetDrawFunc(None)

  def IncMenuItem(self):
    self.ActivateItem(1)


  def DecMenuItem(self):

      self.SelOption=self.SelOption+len(self.Options)-1
      self.SelOption=self.SelOption% len(self.Options)
      OptionText=self.OptionText+" < "+self.Options[self.SelOption]+" >"
      self.SetText(OptionText)

      try: # Puede que Parent no herede de Frame
        self.Parent.RecalcLayout()
      except:
        pass

      try:
        command=self.MenuDescr["Command"]
        command(MenuText.GetInverseMenuText(self.Options[self.SelOption]))
      except KeyError:
        pass

      try: # Puede que Parent no herede de Frame
        self.Parent.RecalcLayout()
      except:
        pass


class M_B_ImageListWidget(BUIx.B_RectWidget):

	def __init__(self,Parent,MenuDescr,StackMenu):
		global ClsSkinImgList

		imagelist=MenuDescr["ImageList"]
		self.Bitmap={}
		self.IDX = imagelist[0][0]

		for i in imagelist:
			bitm = BBLib.B_BitMap24()
			bitm.ReadFromBMP(i[1])
			self.Bitmap[i[0]] = bitm

		self.vidw,self.vidh=self.Bitmap[self.IDX].GetDimension()
		BUIx.B_RectWidget.__init__(self,Parent,MenuDescr["Name"],self.vidw,self.vidh)
		self.Selected=0
		self.Solid=0
		self.Border=0
		self.SetDrawFunc(self.Draw)
		ClsSkinImgList = self
		self.IDX         = MenuDescr["GetCharType"]()


	def ChangeImage(self,name):
		self.IDX = name

	def Draw(self,x,y,time):
		Raster.SetPosition(x,y)
		Raster.DrawImage(self.vidw,self.vidh,"BGR","Normal",self.Bitmap[self.IDX].GetData())
		self.DefDraw(x,y,time)

	def FinalRelease(self):
		global ClsSkinImgList
		ClsSkinImgList = None
		BUIx.B_RectWidget.FinalRelease(self)

	def AcceptsFocus(self):
		return 0


class M_B_LogoWidget(BUIx.B_RectWidget):

	def __init__(self,Parent,MenuDescr,StackMenu):

		LogoFile=MenuDescr["LogoFile"]
		self.Bitmap={}

		self.Logobmp = BBLib.B_BitMap24()
		self.Logobmp.ReadFromBMP(LogoFile)

		self.vidw,self.vidh=self.Logobmp.GetDimension()
		BUIx.B_RectWidget.__init__(self,Parent,MenuDescr["Name"],self.vidw,self.vidh)
		self.Selected=0
		self.Solid=0
		self.Border=0
		self.SetDrawFunc(self.Draw)

	def Draw(self,x,y,time):
		Raster.SetPosition(x,y)
		Raster.DrawImage(self.vidw,self.vidh,"BGR","Normal",self.Logobmp.GetData())
		self.DefDraw(x,y,time)

	def FinalRelease(self):
		BUIx.B_RectWidget.FinalRelease(self)

	def AcceptsFocus(self):
		return 0

######################################################################################	
# Menu methods
######################################################################################	

def GetPlayerName():
	global PlayerName
	print "DBG - GetPlayerName: ",Personajes[PlayerName]['Index']
	return Personajes[PlayerName]['Index']
	


def NextPlayerName(option):
	global PlayerName, ClsSkinImgList
	PlayerName = option
	ClsSkinImgList.ChangeImage (Personajes[PlayerName]['Skin'])
	SaveConfiguration();

def GetPlayerSkin():
	global PlayerName
	return Personajes[PlayerName]['Skin']


def StartF2 (option):
	SaveConfiguration();
	import Bladex
	Bladex.LoadLevel("FugitiveII")
	
		  
########################################################################################
		  
ModMenu = [        {"Name":"",
                         "Font":Menu.MenuFontMed,
                         "Kind":M_B_LogoWidget,
                         "VSep":10,                   #0
                         "LogoFile":F2MenuLogoFile
                   },
                   {"Name":'F2Banner',
                         "VSep":5,
                         "Font":Menu.MenuFontSmall,
                         "Kind":M_B_DescriptorLabel
                   },
	           {"Name":"",
                         "Font":Menu.MenuFontBig,
                         "Kind":M_B_MenuItemOption,
                         "VSep":20,
                         "Options":["Sargon","Zoe","Naglfar","Tukaram"],
                         "SelOptionFunc":GetPlayerName,
                         "Command":NextPlayerName
                   },
		   {"Name":"Lista de jugadores",
			"Kind":M_B_ImageListWidget,
			"ImageList":CharBitmaps,
			"GetCharType":GetPlayerSkin,
			"VSep":25                      #20
		   },
	           {"Name":MenuText.GetMenuText("START"),
			"VSep":25,                        #20
			"Command":StartF2,
		   },
		   {"Name":MenuText.GetMenuText("BACK"),
			"VSep":10,
			"Command":Menu.BackMenu,
		   },
		   {"Name":"Back",
			"Kind":MenuWidget.B_BackBlank
		   }
		  ]
