###########################################################################
## Talk System Data Base
###########################################################################

import Talk


###########################################################################
## Standard Dialogs
###########################################################################


## Alone: The player says these texts when there is not nobody faced
##-------------------------------------------------------------------------

TSDB.Alone = ["Is anybody there!",
	      "I don't like the look of this",
	      "Hello...I thought I heard something?",
	      "The place looks deserted"]

              
## Alone: The player says these texts when the faced character doesn't
## have assigned any dialogue.
##-------------------------------------------------------------------------
              
TSDB.Ignore = ["You are strangely quiet my friend.",
               "Ignore me then.....I care not",
               "Are you DEAF?.",
               "Hello there"]              
               
###########################################################################
## Customized dialogs for each character
###########################################################################

## Dlg Database:
## Format:
##    TSDB.Dlg [pers.Name]={
##           'dlgId': {
##              'Text':
##                """Texto libre""",
##               'Answers': ['ansId1',...'ansIdn']
##              'OtherKey': value
##           }
##    }
##
## * Text: The text will be formatted for TS.
## * Answer: List of answers (ansId). If the list is null [] the
##   conversation is stopped.
##  Please read the documentation to know the details
##
##-------------------------------------------------------------------------

###########################################################################
## Player Answers
###########################################################################

## Answers Database:
## Format:
##   TSDB.Ans [pers.Name]={
##	'ansId': {
##	    'Text':
##	     """Texto""",
##	    'NextDlg': 'ansId',
##	    'Enabled':1
##          'OtherKey': value
##       }
##    }
## * Text: The text will be formatted for TS.
## * NextDlg: The identifier of the next dialogue (dlgId). To stop a  
##   conversation: None.
##  Please reads the documentation to know the details
##-------------------------------------------------------------------------
##############################################
####   Glofror     ###########################
##############################################


TSDB.Dlg ["Glofror"]={
	'FirstGreeting': {
	    'Text':
	     """%PlayerName !...my friend! 'Tis I,... Glofror! """\
	     """....What are you doing in this accursed place? """,
           'Answers': ['Looking','Leader'],
           'CallBack':'LookAtMeWhenImTalkingToYou', 
           'NewDlg': None
        },
	'SawThem': {
	    'Text':
	     """Ha!...We saw them on the road....... """\
	     """I am with party of brother Dwarves. We have travelled in secret along the old tracks. """\
	     """Soon our people will drive the Orcs from this land. """\
	     """We heard that this place is full of riches that the soldiers """\
	     """have stolen from travellers over the years.""",
            'Answers': ['True','Slain'],
            'NewDlg': 'None'
        },
	'yorright': {
	    'Text':
	     """You are probably right my friend. I will have a quick look around and then we will """\
	     """return the way we came. Good luck!.....watch out for yourself.  """,
            'Answers': [],
            'NewDlg': 'None'
        },
	'Stairs': {
	    'Text':
	     """We broke down a door in the underground vaults. The passage led """\
	     """here. My companions are down there now dealing with some nasty little """\
	     """creatures. You can get out that way and maybe give them a hand!""", 
            'Answers': ['WillDo'],
            'NewDlg': 'None'
        },
        'Perhaps': {
	    'Text':
	     """Ha!...many is the filthy Orc who has fallen to Glofror's Axe. """\
	     """It may be that they too are looking for treasure. Legend has it that the """\
	     """fabulous stone, the Eye of Caradhras, is hidden within these walls.""",
            'Answers': ['Iveheardthat'],
            'NewDlg': 'None'
        },
        'cantopen': {
	    'Text':
	     """Ah!....'tis you %PlayerName. I could not get this damn door open! """\
	     """Have you had any trouble? """,
	    'CallBack':'LookAtMeWhenImTalkingToYou', 	    
            'Answers': ['nothingthat'],
            'NewDlg': 'None'
        },
        'smell': {
	    'Text':
	     """Neither do I.....whatever was locked in that cell could still be about. """\
	     """I smell Troll!.....Be on your guard! """,
	     'CallBack':'TrollsReady', 	   	    
            'Answers': [],
            'NewDlg': 'None'
        },
        'creatures': {
	    'Text':
	     """Are you both alright?......I can't help feeling sorry for the """\
	     """poor beasts. The Orcs treat them very harshly, it is little wonder """\
	     """they are so bad-tempered. """,	  
	    'ExtraDlg': ['Herbert',
	    	         """I have a few scratches Glofror...."""], 
            'Answers': ['ioktoo'],
            'NewDlg': 'None'
        },
        'lookround': {
	    'Text':
	     """This place is getting too dangerous! Herbert, gather the rest of our """\
	     """comrades. We must report to the Dwarf Council. """,  
	    'ExtraDlg': ['Herbert',
	    	         """I think I hear them approaching Glofror."""], 
	    'CallBack':'ReGroup', 	    
            'Answers': [],
            'NewDlg': 'None'
        },
        'creatures2': {
	    'Text':
	     """Alas! I fear Herbert has fought his last battle...... """\
	     """Are you alright %PlayerName? """,
	    'CallBack':'ReGroup', 
            'Answers': ['iok'],
            'NewDlg': 'None'
        },
        'gather': {
	    'Text':
	     """Yes, this place is far too dangerous. I will gather my comrades """\
	     """together and report back to the Dwarf Council. Lets hope we meet again """\
	     """in more peaceful circumstances! """,
	    'CallBack':'ReGroup', 
            'Answers': [],
            'NewDlg': 'None'
        },
	'tales': {
	    'Text':
	     """Yes.....I have heard tales of his evil powers. He is called Vinculanus. """\
	     """Some say he is the half-brother of the Noble Lord Kerman and is plotting """\
	     """to usurp the Dukedom of Tell Halaf. I do not know if it is true.....Who knows....? """,
            'Answers': ['advise'],
            'NewDlg': 'None'
        },
        'helloagain': {
	    'Text':
	     """So,we meet again %PlayerName. You always seem to be in trouble! I decided to have another """\
	     """look around before leaving. I knew by the trail of Orc corpses you could not be far away! """,
            'Answers': ['gotsomething'],
            'NewDlg': 'None'
        },
        'doyoumean': {
	    'Text':
	     """What do you mean? Surely you have not found......Ye Gods! Can it be true! """,
	    'CallBack':'GetTheGem', 
            'Answers': ['sureis'],
            'NewDlg': 'None'
        },
        'isurelywill': {
	    'Text':
	     """By the Mighty Axe of Skorageirr! It will be a great wonder to have """\
	     """the Gem once more reside in the Halls of the Ancestors. """,
	    'CallBack':'PassTheGem', 
            'Answers': ['farewell'],
            'NewDlg': 'None'
        },
        'goodluck': {
	    'Text':
	     """Very well %PlayerName. I will wish you good fortune on your journey. Be assured """\
	     """Your name will will always be regaled whenever Dwarves gather to tell stories of great deeds. """\
	     """ Farewell my friend! May the blades of your enemies never rob you of old age! """,
	    'HideDelay':14, 
	    'CallBack':'GlofrorOut', 
            'Answers': [],
            'NewDlg': 'None'
        }		
}

#####
TSDB.Ans ["Glofror"]={
	'Looking': {
	    'Text':
	     """ Well met Glofror! I could ask you the same question!, """\
	     """ The Black Guard are on my trail. I have slain a few, but there"""\
	     """ are bound to be more.""",
	    'NextDlg': 'SawThem',
	    'Enabled':1
	},	
	'Leader': {
	    'Text':
	     """I was captured by The Orcs, but I managed to escape. I suspect that they """\
	     """were trying to denounce me to the Black Guard. I have just had a fight with """\
	     """the Knight who leads them. He is a dangerous adversary, but someone has been """\
	     """teaching him the Dark Magic. He carried the shield of Dal Gurak.....""",
	    'NextDlg': 'tales',
	    'Enabled':1
        },	
	'True': {
	    'Text':
	     """There may be truth in the stories. I have already """\
	     """found more than a few trinkets.... But how did you get into the hall?""",
	    'NextDlg': 'Stairs',
	    'Enabled':1
        },
	'WillDo': {
	    'Text':
	     """I will do just that! Why don't you check the room in the corner. """\
	     """There are weapons and food up there. Also there is a locked door. Maybe you can """\
	     """presuade it to open!""",
	    'Journal': 'MetGlofror',
	    'Enabled':1
        },
	'Slain': {
	    'Text':
	     """Alas!....What few friendly Knights that remained have been slaughtered """\
	     """By the Orcs. They seem to have occupied the place. """\
	     """They are planning something. I know not what. """,
	    'NextDlg': 'Perhaps',
	    'Enabled':1
	}, 
	'Iveheardthat': {
	   'Text':
	    """I too have heard such tales, but I never gave them credance. """\
	    """....You are welcome to search. I cannot stay and help, I must away """\
	    """before more Guards arrive.""",
	   'Journal': 'TheStone',
	   'Enabled':1
	}, 
	'nothingthat': {
	   'Text':
	    """Nothing that I could not handle.....with the help of young Herbert. """\
	    """But I don't like the look of this place. """,
	   'NextDlg': 'smell',
	   'Enabled':1
	}, 
	'ioktoo': {
	   'Text':
	    """Yes I am still in one piece!...Let us hope there are no more Trolls """\
	    """loose. """,
	   'NextDlg': 'lookround',
	   'Enabled':1
	}, 
	'iok': {
	   'Text':
	    """Nothing that will not heal with time Glofror. I would like to stay and help, """\
	    """but I must be on my way. """,
	   'NextDlg': 'gather',
	   'Enabled':1
	}, 
	'advise': {
	   'Text':
	    """There is dirty work afoot, that is for certain. This place is getting """\
	    """too dangerous. I must get away as soon as possible. I would advise you and """\
	    """your comrades to do the same......""",
	    'Journal': 'MetGlofror',
	   'NextDlg': 'yorright',
	   'Enabled':1
	},
	'gotsomething': {
	   'Text':
	    """I am glad we have met again Glofror. I have found something that rightfully """\
	    """belongs to the Dwarves. """,
	   'NextDlg': 'doyoumean',
	   'Enabled':1
	},
	'sureis': {
	   'Text':
	    """Believe it Glofror. It was in the tomb of some long dead Knight, but now his """\
	    """unquiet spirit is released and the Eye should be restored to the Dwarf Lords. """\
	    """Will you take it with you? """,
	   'NextDlg': 'isurelywill',
	   'Enabled':1
	},
	'farewell': {
	   'Text':
	    """That is good to hear Glofror, but your safe return is imperative. Remain here """\
	    """until you can make good your escape. There is still danger. I will carry on and """\
	    """try to find the key to the Main Gate """,
	   'NextDlg': 'goodluck',
	   'Enabled':1
        }
}
############################################
######    Tukaram  #########################
############################################

TSDB.Dlg ["Tukaram"]={
	'CheersT': {
	    'Text':
	     """ I was never more pleased to see anyone, %PlayerName my old friend. """\
	     """.....I thought I was done for! But you must hurry if you are """\
	     """to leave this place alive. The Orcs have lit the beacon to summon """\
	     """the Black Guard. There must be a big price on your head!""",
           'Answers': ['Idontdoubt','Leave'],
           'NewDlg': 'None'
        },
        'Boxes': {
	    'Text':
	     """You are right. I have been rotting in this filthy hole for weeks. """\
	     """I will stay here awhile and recover my strength. Look behind you in the alcove, """\
	     """I am sure the stupid creatures hide the dungeon key among the boxes. """,
	   'Journal': 'ent2m',
           'Answers': [],
           'NewDlg': None  
        },
        'Iheard': {
	    'Text':
	     """I overheard them plotting. I understand little of the Orcish language, """\
	     """but I think they intend to demolish the Great Bridge to the Citadel. """,
           'Answers': ['Makessense'],
           'NewDlg': None  
        },
        'GoNow': {
	    'Text':
	     """Ha! That will not hold them back for long. The Dwarves are a resourceful """\
	     """people and they know all the secret pathways. But go now. I will try to follow """\
	     """later if I feel strong enough.""",
	   'Journal': 'ent2m',
           'Answers': [],
           'NewDlg': None 
        },
        'yegods': {
	    'Text':
	     """Ye Gods! What a Monster!........are you hurt %PlayerName? """,
           'Answers': ['yesfine'],
           'NewDlg': None
        },
        'lever': {
	    'Text':
	     """I tried to escape across the mountain lake to the south, """\
	     """but the bridge was down. Come let's get the Gate open and leave """\
	     """this place. Where is the carcass of that Orc who had the lever? """,
           'Answers': [],
           'NewDlg': None                                                                                  
        }
}


TSDB.Ans ["Tukaram"]={
	'Idontdoubt': {
	    'Text':
	     """I don't doubt it! ....But you are injured. Stay down here and rest. """\
	     """The jailers will give you no more trouble. I must search for the key to """\
	     """that small door yonder. That foul Orc did not have it.""",
	    'NextDlg': 'Boxes',
	    'Enabled':1
        },	
	'Leave': {
	    'Text':
	     """Yes, I must leave this place as soon as possible, but I am curious. """\
	     """....The Orcs are up to something. Why would they occupy this old fortress? """\
	     """Stupid as they seem, they do nothing without good reason.""",
	    'NextDlg': 'Iheard',
	    'Enabled':1
        },	
        'Makessense': {
	    'Text':
	     """Hmm,.....that makes sense to me. There is a Dwarven army massing to the North. """\
	     """The Orcs must fear attack and are seeking to cut off the advance. """,
	    'NextDlg': 'GoNow',
	    'Enabled':1
	},	
        'yesfine': {
	    'Text':
	     """Yes I am fine,...if a bit tired. Your appearance was well timed. """,
	    'NextDlg': 'lever',
	    'Enabled':1
        }	
}

############################################################################
################   Zoe   ###################################################
############################################################################

TSDB.Dlg ["Zoe"]={
	'CheersZ': {
	    'Text':
	     """It was fortunate that you appeared when you did, %PlayerName my old friend. """\
	     """.....I thought I was done for! But you must hurry if you are """\
	     """to leave this place alive. The Orcs have lit the beacon to summon """\
	     """the Black Guard. There must be a big price on your head!""",
           'Answers': ['Idontdoubt','Leave'],
           'NewDlg': None
        },
        'Boxes': {
	    'Text':
	     """You are right. I have been rotting in this filthy hole for weeks. """\
	     """I will stay here awhile and recover my strength. Look behind you in the alcove, """\
	     """I am sure the stupid creatures hide the dungeon key among the boxes. """,
	   'Journal': 'ent2f',
           'Answers': [],
           'NewDlg': None  
        },
        'Iheard': {
	    'Text':
	     """I overheard them plotting. I understand little of the Orcish language, """\
	     """but I think thet intend to demolish the Great Bridge to the Citadel. """,
           'Answers': ['Makessense'],
           'NewDlg': None  
        },
        'GoNow': {
	    'Text':
	     """Ha! That will not hold them back for long. The Dwarves are a resourceful """\
	     """people and they know all the secret pathways. But go now. I will try to follow """\
	     """later if I feel strong enough.""",
	   'Journal': 'ent2f',
           'Answers': [],
           'NewDlg': None
        },
        'yegods': {
	    'Text':
	     """Ye Gods! What a Monster!........are you alright %PlayerName? """,
           'Answers': ['yesfine'],
           'NewDlg': None
        },
        'lever': {
	    'Text':
	     """I tried to escape across the mountain lake to the south, """\
	     """but the bridge was down. Come let's get the Gate open and leave """\
	     """this place. Where is that Orc who had the lever? """,
           'Answers': [],
           'NewDlg': None                                                                                           
        }
}


TSDB.Ans ["Zoe"]={
	'Idontdoubt': {
	    'Text':
	     """I don't doubt it! ....But you are injured. Stay down here and rest. """\
	     """The jailers will give you no more trouble. I must search for the key to """\
	     """that small door yonder. That foul Orc did not have it.""",
	    'NextDlg': 'Boxes',
	    'Enabled':1
        },	
	'Leave': {
	    'Text':
	     """Yes, I must leave this place as soon as possible, but I am curious. """\
	     """....The Orcs are up to something. Why would they occupy this old fortress? """\
	     """Stupid as they seem, they do nothing without good reason.""",
	    'NextDlg': 'Iheard',
	    'Enabled':1
        },	
        'Makessense': {
	    'Text':
	     """Hmm,.....that makes sense to me. There is a Dwarven army massing to the North. """\
	     """The Orcs must fear attack and are seeking to cut off the advance. """,
	    'NextDlg': 'GoNow',
	    'Enabled':1
	},	
        'yesfine': {
	    'Text':
	     """Yes I am fine,...if a bit tired. Your appearance was well timed. """,
	    'NextDlg': 'lever',
	    'Enabled':1
        }	
}

############################################################################
#########################   Sargon   #######################################
############################################################################

TSDB.Dlg ["Sargon"]={
	'CheersS': {
	    'Text':
	     """I am glad to see your face again, %PlayerName my old friend. """\
	     """....That big Orc was about to put an end to me! But you must hurry if you are """\
	     """to leave this place alive. The Orcs have lit the beacon to summon """\
	     """the Black Guard. There must be a big price on your head!""",
           'Answers': ['Idontdoubt','Leave'],
           'NewDlg': None
        },
        'Boxes': {
	    'Text':
	     """You are right. I have been rotting in this filthy hole for weeks. """\
	     """I will stay here awhile and recover my strength. Look behind you in the alcove, """\
	     """I am sure the stupid creatures hide the dungeon key among the boxes. """,
	   'Journal': 'ent2m',
           'Answers': [],
           'NewDlg': None  
        },
        'Iheard': {
	    'Text':
	     """I overheard them plotting. I understand little of the Orcish language, """\
	     """but I think they intend to demolish the Great Bridge to the Citadel. """,
           'Answers': ['Makessense'],
           'NewDlg': None  
        },
        'GoNow': {
	    'Text':
	     """Ha! That will not hold them back for long. The Dwarves are a resourceful """\
	     """people and they know all the secret pathways. But go now. I will try to follow """\
	     """later if I feel strong enough.""",
	   'Journal': 'ent2m',
           'Answers': [],
           'NewDlg': None  
        },
        'yegods': {
	    'Text':
	     """Ye Gods! What a Monster!........are you alright %PlayerName? """,
           'Answers': ['yesfine'],
           'NewDlg': None
        },
        'lever': {
	    'Text':
	     """I tried to escape across the mountain lake to the south, """\
	     """but the bridge was down. Come let's get the Gate open and leave """\
	     """this place. Where is the carcass of that Orc who had the lever? """,
           'Answers': [],
           'NewDlg': None                                                                                                      
        }
}


TSDB.Ans ["Sargon"]={
	'Idontdoubt': {
	    'Text':
	     """I don't doubt it! ....But you are injured. Stay down here and rest. """\
	     """The jailers will give you no more trouble. I must search for the key to """\
	     """that small door yonder. That foul Orc did not have it.""",
	    'NextDlg': 'Boxes',
	    'Enabled':1
        },	
	'Leave': {
	    'Text':
	     """Yes, I must leave this place as soon as possible, but I am curious. """\
	     """....The Orcs are up to something. Why would they occupy this old fortress? """\
	     """Stupid as they seem, they do nothing without good reason.""",
	    'NextDlg': 'Iheard',
	    'Enabled':1
        },	
        'Makessense': {
	    'Text':
	     """Hmm,.....that makes sense to me. There is a Dwarven army massing to the North. """\
	     """The Orcs must fear attack and are seeking to cut off the advance. """,
	    'NextDlg': 'GoNow',
	    'Enabled':1
	},	
        'yesfine': {
	    'Text':
	     """Yes I am fine,...if a bit tired. Your appearance was well timed. """,
	    'NextDlg': 'lever',
	    'Enabled':1
        }	
}

############################################################################
############################    Naglfar  ###################################
############################################################################

TSDB.Dlg ["Naglfar"]={
	'CheersN': {
	    'Text':
	     """Your timing was immaculate, %PlayerName my big friend. """\
	     """I didn't like the look of that hot iron! But you must hurry if you are """\
	     """to leave this place alive. The Orcs have lit the beacon to summon """\
	     """the Black Guard. There must be a big price on your head!""",
           'Answers': ['Idontdoubt','Leave'],
           'NewDlg': None
        },
        'Boxes': {
	    'Text':
	     """You are right. I have been rotting in this filthy hole for weeks. """\
	     """I will stay here awhile and recover my strength. Look behind you in the alcove, """\
	     """I am sure the stupid creatures hide the dungeon key among the boxes. """,
	   'Journal': 'ent2m',
           'Answers': [],
           'NewDlg': None  
        },
        'Iheard': {
	    'Text':
	     """I overheard them plotting. I understand little of the Orcish language, """\
	     """but I think thet intend to demolish the Great Bridge to the Citadel. """,
            'Answers': ['Makessense'],
            'NewDlg': None  
        },
        'GoNow': {
	    'Text':
	     """Ha! That will not hold them back for long. We Dwarves are a resourceful """\
	     """people and they know all the secret pathways. But go now. I will try to follow """\
	     """later if I feel strong enough.""",
	   'Journal': 'ent2m',
           'Answers': [],
           'NewDlg': None 
        },
        'yegods': {
	    'Text':
	     """Ye Gods! What a Monster!........are you alright %PlayerName? """,
           'Answers': ['yesfine'],
           'NewDlg': None
        },
        'lever': {
	    'Text':
	     """I tried to escape across the mountain lake to the south, """\
	     """but the bridge was down. Come let's get the Gate open and leave """\
	     """this place. Where is that Orc who had the lever? """,
           'Answers': [],
           'NewDlg': None                                                                                           
        }
}


TSDB.Ans ["Naglfar"]={
	'Idontdoubt': {
	    'Text':
	     """I don't doubt it! ....But you are injured. Stay down here and rest. """\
	     """The jailers will give you no more trouble. I must search for the key to """\
	     """that small door yonder. That foul Orc did not have it.""",
	    'NextDlg': 'Boxes',
	    'Enabled':1
        },	
	'Leave': {
	    'Text':
	     """Yes, I must leave this place as soon as possible, but I am curious. """\
	     """....The Orcs are up to something. Why would they occupy this old fortress? """\
	     """Stupid as they seem, they do nothing without good reason.""",
	    'NextDlg': 'Iheard',
	    'Enabled':1
        },	
        'Makessense': {
	    'Text':
	     """Hmm,.....that makes sense to me. There is a Dwarven army massing to the North. """\
	     """The Orcs must fear attack and are seeking to cut off the advance. """,
	    'NextDlg': 'GoNow',
	    'Enabled':1
	},	
        'yesfine': {
	    'Text':
	     """Yes I am fine,...if a bit tired. Your appearance was well timed. """,
	    'NextDlg': 'lever',
	    'Enabled':1
        }	
}

############################################################################
#########   Wounded Orc   ##################################################
############################################################################

TSDB.Dlg ["WoundedOrc"]={
	'Donthurtme': {
	    'Text':
	     """You not kill me %Type! Me tell you how to escape.. """\
	     """....arrgh!....my leg hurts! """,
            'Answers': ['Idonttrust', 'speak'],
            'NewDlg': None
        },
        'wall': {
	    'Text':
	     """You jump over wall at end of passage.. """\
	     """..big door is open. You go down gorge to """\
	     """ Falcon Gate.... Escape across mountains.""",
            'Answers': ['trap'],
            'NewDlg': None
        },
        'lie': {
	    'Text':
	     """I not lie.....I wounded ..Owww! my leg hurt! """,
	    'Journal': 'ent3',
	    'CallBack':'TalkFinished',                               ###################add to sp dia
            'Answers': [],
            'NewDlg': None
        }
}



TSDB.Ans ["WoundedOrc"]={
	'Idonttrust': {
	    'Text':
	     """Why should I trust you.....you foul creature! """,
	    'CallBack':'TalkFinished',                               ###################add to sp dia
	    'NextDlg': 'None',
	    'Enabled':1	
	},
	'speak':{
	    'Text':
	     """Speak quickly then!...and I may spare you. """,
	    'NextDlg': 'wall',
	    'Enabled':1	
	},
	'trap':{
	    'Text':
	     """How do I know it's not a trap.... """,
	    'NextDlg': 'lie',
	    'Enabled':1	
	}
}    

##########################################################################
##############  Lord Kerman  #############################################
##########################################################################

TSDB.Dlg ["LordKerman"]={
	'Whothere': {
	    'Text':
	     """Who is that!....friend or foe? """,
            'Answers': ['itsme'],
            'NewDlg': None
        },
        'Good': {
	    'Text':
	     """It is good to see a friendly face %PlayerName. """\
	     """I was here in this Library studying the Ancient Chronicles """\
	     """when the Orcs invaded the garrison. My personal guards were """\
	     """badly wounded, but we managed to close the great doors. """\
	     """The Orcs cannot get in, but they have locked the outer bars. """\
	     """I have a key, but cannot reach the lock. We are trapped in here. """\
	     """But tell me, how did you get here? The Garrison must be """\
	     """crawling with the evil scum """,
	    'CallBack':'SwitchView', 
            'Answers': ['fearnot'],
            'NewDlg': None
        },
        'bythe': {
	    'Text':
	     """By the Gods! It is all clear to me now! The Orcs are trying to sell me to """\
	     """my half-brother Vinculanus. Tell me, were they led by an ugly bastard with a """\
	     """black beard? Watch out for him! He is a formidable swordsman and he """\
	     """has knowledge of the Dark Arts""", 
            'Answers': ['verywell'],
            'NewDlg': None
        },
        'fought': {
	    'Text':
	     """What!... you have fought him and survived? You are a true """\
	     """warrior indeed!......But did you kill him? """,
            'Answers': ['pet'],
            'NewDlg': None
        },
        'wemust': {
	    'Text':
	     """Good work %PlayerName. Now we must leave this place. """\
	     """The Key to the Main Gate is on the table inside. """\
	     """Will you go and see if you can open it?..If you can, then """\
	     """make good your escape..."""\
	     """I must stay and give some thought to the wounded""",
	    'CallBack':'LookAtMeWhenImTalkingToYou', 
            'Answers': ['asyouwish'],
            'NewDlg': None
        },
        'notime': {
	    'Text':
	     """Ye Gods! Is there no end to his evil?.... """\
	     """Quickly then, There is no time to loose! """\
	     """Take this key and unlock the outer bars. """,
	    'CallBack':'HandOverKey',
            'Answers': ['aye'],
            'NewDlg': None
        },
        'watchit': {
	    'Text':
	     """Thank you %PlayerName...but be alert!...There may yet """\
	     """be Orcs lurking abroad. """,
	    'CallBack':'SwitchViewBack', 
            'Answers': [],
            'NewDlg': None
        },
        'makehaste': {
	    'Text':
	     """Make haste then...May the Gods Protect you. """\
	     """..Mortimer...will you stand guard in the passageway. """,
	    'ExtraDlg': ['Mortimer',
	    	         """Yes my Lord......."""],
	    'CallBack':'GoToCheck1', 
            'Answers': [],
            'NewDlg': None
        },
        'more': {
	    'Text':
	     """Ha!.....It will take more than these jackals to get the better """\
	     """of we three. What say you Mortimer? """,
	    'ExtraDlg': ['Mortimer',
	    	         """As you say my Lord Duke! They are no match for a true warrior!"""],
            'Answers': ['letusnot'],
            'NewDlg': None
        },
        'wounded': {
	    'Text':
	     """You are right %PlayerName.....Come Mortimer! Let us see if we can get the wounded on their feet. """,
	    'CallBack':'GoSee1', 
            'Answers': [],
            'NewDlg': None
        },
        'lost': {
	    'Text':
	     """The jackals are all dead!... Alas my trusted Lieutenant has fallen. """,
            'Answers': ['pity'],
            'NewDlg': None
        },
        'nothing': {
	    'Text':
	     """I shall miss him. But there is nothing more that can be done here. """\
	     """Take the key and make for the Great Gate. I will see if I can get my men moving. """,
	    'CallBack':'GoSee2', 
            'Answers': [],
            'NewDlg': None
        },
        'rebuild': {
	    'Text':
	     """Ye Gods! What a monster! But take heart %Playername, I think the garrison is clear of  """\
	     """enemies. What are your plans now? """,
            'Answers': ['wherelever'],
            'NewDlg': None
        },
        'notaccompany': {
	    'Text':
	     """Of course. I regret I cannot accompany you. I must remain and send for reinforcements.  """\
	     """Good Luck on your journey! """,
            'Answers': [],
            'NewDlg': None
        }
}


TSDB.Ans ["LordKerman"]={
	'itsme': {
	    'Text':
	     """My Lord!.....I am a friend. My name is %PlayerName. """,
	    'NextDlg': 'Good',
	    'Enabled':1	
	},
	'fearnot':{
	    'Text':
	     """I was ambushed at the gate and thrown into a cell, but """\
	     """I managed to escape. But I fear Orcs are the least of our """\
	     """problems....the Black Guard are here. """,
	    'NextDlg': 'bythe',
	    'Enabled':1	
	},
	'verywell':{
	    'Text':
	     """I have already made his aquaintance my Lord! """,
	    'NextDlg': 'fought',
	    'Enabled':1	
	},
	'pet':{
	    'Text':
	     """I am afraid not my Lord. When he knew I had the better of him he """\
	     """used his magic to spirit himself away. He left one of his pet demons to """\
	     """finish me off. """,
	    'NextDlg': 'notime',
	    'Enabled':1	
	},
	'aye':{
	    'Text':
	     """Aye my Lord! I will do that straight away.....""",
	    'NextDlg': 'watchit',
	    'Enabled':1	
	},
	'asyouwish':{
	    'Text':
	     """As you wish my Lord, but I will return if I am able. """,
	    'NextDlg': 'makehaste',
	    'Enabled':1	
	},
	'letusnot':{
	    'Text':
	     """Well said!...but let us not linger. Who knows how many more are prowling about. """,
	    'NextDlg': 'wounded',
	    'Enabled':1	
	},
	'pity':{
	    'Text':
	     """Aye. A great pity my Lord. He fought valiantly right up to the end. """,
	    'NextDlg': 'nothing',
	    'Enabled':1	
	},
	'wherelever':{
	    'Text':
	     """I will journey on though the western mountains my Lord...... that is if I can find """\
	     """the carcass of that Orc who tried to hide the lever. """,
	    'NextDlg': 'notaccompany',
	    'Enabled':1	
	}
}    
###########################################################################
###########      Crazydwarf    ############################################
###########################################################################


TSDB.Dlg ["Crazydwarf"]={
	'welcomeZ': {
	    'Text':
	     """Welcome to my humble shop Sir. """\
	     """How can I be of service? """,
	    'CallBack':'SetRaidTriggs', 
	    'Journal': 'ent7',
            'Answers': ['cheese','callingZ'],
            'NewDlg': None
        },
        'welcomeB': {
	    'Text':
	     """Welcome to my humble shop Miss. """\
	     """How can I be of service? """,
	    'CallBack':'SetRaidTriggs', 
	    'Journal': 'ent7',
            'Answers': ['cheese','callingB'],
            'NewDlg': None
        },
        'gotnone': {
	    'Text':
	     """I'm afraid I have very little cheese left and """\
	     """it is a bit tough. """,
            'Answers': ['ilike'],
            'NewDlg': None
         },
         'tougher': {
	    'Text':
	     """I think it will be tougher than you like it. """,
            'Answers': ['care','silly'],
            'NewDlg': None
         },
         'pardon': {
	    'Text':
	     """I do beg your pardon. I am afraid that all this Cheese has started to """\
	     """to affect my mind. """,
            'Answers': ['layoff'],
            'NewDlg': None
         },
         'toohard': {
	    'Text':
	     """Are you sure? Some of it has been here since my grandfather """\
	     """was a boy""",
            'Answers': ['ifyou'],
            'NewDlg': None
        },
         'catgotit': {
	    'Text':
	     """Ah Yes!....I did have a tin of Spam once, but the cat ate it. """,
            'Answers': ['didntknow'],
            'NewDlg': None
        },
         'notsince': {
	    'Text':
	     """Hmmmm.....now you mention it, I haven't seen it since the Spam incident. """,
            'Answers': ['digress','should'],
            'NewDlg': None
        },
         'ican': {
	    'Text':
	     """Yo puedo hablar espaol! """,
            'Answers': ['thatsenough'],
            'NewDlg': None
        },
         'true': {
	    'Text':
	     """Alas!...what you say is true. The cheese trade is not what it was. """\
	     """I have some excellent weapons however. They are of the """\
	     """finest quality.""",
            'Answers': ['nowyourtalking','fortrolls'],
            'NewDlg': None
        },
         'feelfree': {
	    'Text':
	     """Of course. They are not ordinary weapons. """\
	     """They were forged in the master armourers of my Homeland. """\
	     """They have no equal in this this World! """,
            'Answers': [],
            'NewDlg': None
        },
         'cold': {
	    'Text':
	     """I am sorry!.....I have a cold. """,
            'Answers': ['jokes'],
            'NewDlg': None
        },
         'tooold': {
	    'Text':
	     """I think that is all of them! But I must reward you for your efforts. Look """\
	     """under my book. There is a key to a secret cave tunnel that leads back into to the """\
	     """garrison. It is quite safe. Help yourself to anything you may find inside. """\
	     """I am getting too old for all this exitement! I must go and check the Cheese. """,
	    'Answers': [],
	    'CallBack':'GoCheese', 
	    'Journal': 'ent8',
            'HideDelay':25, 
            'NewDlg': None
        },
         'howseric': {
	    'Text':
	     """Are you alright %PlayerName?....how is Eric? """,
            'Answers': ['iamok'],
            'NewDlg': None
        },
         'alaspooreric': {
	    'Text':
	     """Alas!...Poor Eric!...he was a brave son......... """\
	     """I am getting too old for all this exitement! I must go and check the Cheese. """,
	    'CallBack':'GoCheese', 
            'Answers': [],
            'NewDlg': None
        },
         'helloagain': {
	    'Text':
	     """Hello again.....how did you get here? Eric is guarding the only approach.""",
	    'CallBack':'LookAtMeWhenImTalkingToYou', 
            'Answers': ['secretdoor'],
            'NewDlg': None
        },
         'helloagain2': {
	    'Text':
	     """Hello again.....how did you get here? .""",
	    'CallBack':'LookAtMeWhenImTalkingToYou', 
            'Answers': ['secretdoor2'],
            'NewDlg': None
        },
         'helloagain3': {
	    'Text':
	     """Hello again.....come back for more weapons have you? """,
	    'CallBack':'LookAtMeWhenImTalkingToYou', 
            'Answers': ['backuppath3'],
            'NewDlg': None
        },
         'helloagain4': {
	    'Text':
	     """Hello again.....have you had any more trouble? """,
	    'CallBack':'LookAtMeWhenImTalkingToYou', 
            'Answers': ['backuppath4'],
            'NewDlg': None
        },
         'wellillbe': {
	    'Text':
	     """Well I'll be damned!...I often wondered about that....""",
            'Answers': ['aslong','notherlook'],
            'NewDlg': None
        },
         'protect': {
	    'Text':
	     """I wish you well my friend. May the Gods protect you on your journey!"""\
	     """I have some new provisions inside. Help yourself! """,
            'Answers': [],
            'NewDlg': None
        },
         'goahead': {
	    'Text':
	     """Please go ahead and pick whatever you need. Eric and I are leaving soon."""\
	     """Some extra cash would be useful on our journey. """,
            'Answers': [],
            'NewDlg': None
        },
         'moveon': {
	    'Text':
	     """I hear there is an army of my brother Dwarves to the North. I will ."""\
	     """Seek them out. Maybe they could use the services of an Armourer. """\
	     """There is some new Cheese inside. Help yourself. """,
            'Answers': [],
            'NewDlg': None
        },
         'trollwp': {
	    'Text':
	     """Ah yes!.....They are dangerous beasts. Try the %Trlwp."""\
	     """It is a very lightweight weapon but it will slay a Troll """\
	     """very quickly. """,
            'Answers': ['soundsgood'],
            'NewDlg': None
        },
         'suitsyou': {
	    'Text':
	     """Ah.....a seasoned warrior such as yourself will be able to wield"""\
	     """the %Wptyp. It will make the most of your fighting abilities. """\
	     """It is rather expensive but worth it I assure you. """,
            'Answers': [],
            'NewDlg': None
        }
}
	    
TSDB.Ans ["Crazydwarf"]={
	'cheese': {
	    'Text':
	     """I would like a nice piece of Cheese if you please. """,
	    'NextDlg': 'gotnone',
	    'Enabled':1	
	},
	'ilike':{
	    'Text':
	     """That's fine, I like it tough! """,
	    'NextDlg': 'tougher',
	    'Enabled':1	
	},
	'care':{
	    'Text':
	     """Tougher the better. I like it really chewy! """,
	    'NextDlg': 'toohard',
	    'Enabled':1
	},
	'silly':{
	    'Text':
	     """Whoa!....hold it right there. You are getting silly again! """,
	    'NextDlg': 'pardon',
	    'Enabled':1
	},
	'didntknow':{
	    'Text':
	     """I didn't know you had a cat! """,
	    'NextDlg': 'notsince',
	    'Enabled':1
	},
	'layoff':{
	    'Text':
	     """Well I would stop eating it if I were you! Have you tried Spam? """,
	    'NextDlg': 'catgotit',
	    'Enabled':1
	},
	'thatsenough':{
	    'Text':
	     """OK.....that's enough! This conversation is getting increasingly bizarre! """\
	     """Let us return to sanity. Tell me, what weapons you would you recommend? """,
	    'NextDlg': 'suitsyou',
	    'Enabled':1
	},
	'digress':{
	    'Text':
	     """I think we are loosing the plot here somewhere. Let us return to business. """\
	     """What weapons would you recommend? """,
	    'NextDlg': 'suitsyou',
	    'Enabled':1
	},
	'should':{
	    'Text':
	     """You do realise that all this rubbish will have to be translated """\
	     """into Spanish.....! """,
	    'NextDlg': 'ican',
	    'Enabled':1
	},
	'ifyou':{
	    'Text':
	     """Hmm.... If you don't mind me saying, this is not much of a Cheese """\
	     """Shop""",
	    'NextDlg': 'true',
	    'Enabled':1	
	},
	'nowyourtalking':{
	    'Text':
	     """Alright!...forget the cheese. I will see if any of your armoury """\
	     """is to my liking .""",
	    'NextDlg': 'feelfree',
	    'Enabled':1
	},
	'callingB':{
	    'Text':
	     """What do you mean, "Miss"? """\
	     """Do I look like a girl? """,
	    'NextDlg': 'cold',
	    'Enabled':1	
	},
	'callingZ':{
	    'Text':
	     """What do you mean, "Sir"? """\
	     """...Do I look like a man? """,
	    'NextDlg': 'cold',
	    'Enabled':1
	},
	'jokes':{
	    'Text':
	     """Alright...this conversation is adopting a distinctly Pythonesque tone. """\
	     """Let us stick to the subject of the Cheese.""",
	    'NextDlg': 'gotnone',
	    'Enabled':1	
	},
	'iamok':{
	    'Text':
	     """I am hurt but I will recover, but I am """\
	     """afraid Eric did not survive the skirmish...""",
	    'NextDlg': 'alaspooreric',
	    'Enabled':1	
	},
	'secretdoor':{
	    'Text':
	     """I discovered a concealed door!...It led up to the trapdoor at the back of  """\
	     """the Shop.""",
	    'NextDlg': 'wellillbe',
	    'Enabled':1	
	},
	'secretdoor2':{
	    'Text':
	     """I discovered a concealed door!...It led up to the trapdoor at the back of  """\
	     """the Shop. What will you do now that Eric is not here to help you? """,
	    'NextDlg': 'moveon',
	    'Enabled':1	
	},
	'backuppath3':{
	    'Text':
	     """Yes indeed! But what are you and Eric going to do?  """,
	    'NextDlg': 'goahead',
	    'Enabled':1	
	},
	'backuppath4':{
	    'Text':
	     """Nothing I could not handle! But what will you do now that Eric is not here to guard the place?  """,
	    'NextDlg': 'moveon',
	    'Enabled':1	
	},
	'notherlook':{
	    'Text':
	     """Well I'm glad I found a way back. I would like some more supplies if I may.  """,
	    'NextDlg': 'goahead',
	    'Enabled':1	
	},
	'aslong':{
	    'Text':
	     """Yes, it probably had been closed for centuries!....anyway, as long as you are both  """\
	     """well, I will return the same way. I have to try to reach the Great gate to the west.""",
	    'NextDlg': 'protect',
	    'Enabled':1
	},
	'fortrolls':{
	    'Text':
	     """Where there are Orcs there are usually Trolls. Have you anything that is  """\
	     """especially effective against them? """,
	    'NextDlg': 'trollwp',
	    'Enabled':1	
	},
	'soundsgood':{
	    'Text':
	     """That sounds great! Are there any other weapons you would recommend?  """,
	    'NextDlg': 'suitsyou',
	    'Enabled':1																																											
	}
}    

###########################################################################
################   Eric   #################################################
###########################################################################
TSDB.Dlg ["Eric"]={
	'Iameric': {
	    'Text':
	     """Hello Stranger, what brings you to this place? """,
            'Answers': ['search'],
            'CallBack':'LookAtMeWhenImTalkingToYou', 
            'NewDlg': None
        },
        'blocked': {
	    'Text':
	     """There is a track that leads east across the mountains """\
	     """but it has for many years been blocked by a rockfall. """\
	     """Why not go inside and see my Father. He may be able to help you. """\
	     """I am called Eric. """,
            'Answers': ['willdo','dontlike','ifyou'],
            'NewDlg': None
        },
        'interesting': {
	    'Text':
	     """Oh, there are some good arms for sale, but the cheese is attrocious. """,
            'Answers': [],
            'NewDlg': None
        },
        'yourwelcome': {
	    'Text':
	     """Your are welcome. """,
            'Answers': [],
            'NewDlg': None
        },
         'welldone': {
	    'Text':
	     """Well done %PlayerName ....I could not have handled them """\
	     """alone. """,
	    'CallBack':'EricBackToDoor', 
            'Answers': ['mypleasure'],
            'NewDlg': None
        },
         'where': {
	    'Text':
	     """Right!....I wonder if Crazydwarf is alright..... """,
            'Answers': [],
            'NewDlg': None
        },
        'found': {
	    'Text':
	     """Ahh....I see your point... Crazydwarf, for that is his name, """\
	     """rescued me from the Orcs as a child. He raised me as his son """\
	     """and so I help out in the store and see that there is no trouble.""",
            'Answers': ['useful'],
            'NewDlg': None
        },
        'bolder': {
	    'Text':
	     """Ha!....They grow bolder every day. It is only a matter of time """\
	     """before they pay us a visit. I am keeping watch in case they try """\
	     """a suprise attack.""",
            'Answers': ['shout'],
            'NewDlg': None   
        },
        'cometo': {
	    'Text':
	     """Many thanks, %PlayerName.....it may well come to that. """,
            'Answers': [],
            'NewDlg': None   
        },
        'allquiet2': {
	    'Text':
	     """Hello again!...How did you get past me? """,
            'Answers': ['another'],
            'NewDlg': None 
        },
        'watch': {
	    'Text':
	     """It has been quiet around here, but I am keeping watch anyway....... """,
            'Answers': [''],
            'NewDlg': None
        },
        'allquiet1': {
	    'Text':
	     """%Playername! ....It is only you. I thought it was another attack. """,
            'Answers': ['dontworry'],
            'NewDlg': None 
        },
        'thatswhat': {
	    'Text':
	     """That's great news! """,
            'Answers': [''],
            'NewDlg': None                                                                                                                                                                   
        }
}
	    
TSDB.Ans ["Eric"]={
	'search': {
	    'Text':
	     """Greetings! My name is %PlayerName. """\
	     """I am looking for for a pathway out of this place. """\
	     """Tell me, where does this road lead? """,
	    'NextDlg': 'blocked',
	    'Enabled':1	
	},
	'willdo':{
	    'Text':
	     """Thanks Eric. I will do that.""",
	    'NextDlg': 'yourwelcome',
	    'Enabled':1	
	},
	'dontlike':{
	    'Text':
	     """Are you sure. I don't like the look of the place. """,
	    'NextDlg': 'interesting',
	    'Enabled':1
	},
	'mypleasure':{
	    'Text':
	     """My pleasure I assure you! """\
	     """I need no encouragement to slaughter Orcs.""",
	    'NextDlg': 'where',
	    'Enabled':1	
	},
	'ifyou':{
	    'Text':
	     """Hmmm....If you don't mind me saying, aren't you """\
	     """rather large for a Dwarf? """,
	    'NextDlg': 'found',
	    'Enabled':1
	},
	'useful':{
	    'Text':
	     """Yes, you certainly would be useful in a fight. But surely the """\
	     """Orcs would not find their way to this lonely road? """,
	    'NextDlg': 'bolder',
	    'Enabled':1
	},
	'shout':{
	    'Text':
	     """Yes, I met some on my way here, but they will not be troubling """\
	     """anyone again. I will look inside now. Shout if you need help. """,
	    'NextDlg': 'cometo',
	    'Enabled':1	
	},
	'another':{
	    'Text':
	     """I found a secret trapdoor that comes up behind the shop. """\
	     """Be wary. There are still Orcs about....... """,
	    'NextDlg': 'watch',
	    'Enabled':1	
	},
	'dontworry':{
	    'Text':
	     """Do not worry my friend. There are a lot less Orcs about since """\
	     """last we met! """,
	    'NextDlg': 'thatswhat',
	    'Enabled':1											
	}
}    	    	   

###########################################################################
#####################  The Dying Knight  ##################################
###########################################################################

TSDB.Dlg ["DyingKnight"]={
	'listen': {
	    'Text':
	     """Arrgh! come to finish me off have you! """\
	     """I will tell you nothing.....do your worst! """,
            'Answers': ['fearnot'],
            'NewDlg': None
        },
        'whatof': {
	    'Text':
	     """Listen carefully.....I fear am not long for this world. What of my """\
	     """men. Did any survive the attack? """,
            'Answers': ['no'],
            'NewDlg': None
        },
        'truth': {
	    'Text':
	     """Ah!....there is truth in that. But the only way out is through """\
	     """the torture chamber. There was another prisoner in there, """\
	     """an aventurer like yourself. If you act swiftly you may be able to save """\
	     """the poor wretch.""",
            'Answers': ['willdo'],
            'NewDlg': None
        },
        'doomed': {
	    'Text':
	     """Alas no. I grow weaker by the second. But look out for Lord Kerman, the """\
	     """Duke of Tel Halaf. He was in the Great Library when the Orcs attacked. """,
	    'Answers': ['besure'],
            'NewDlg': None
        },
         'thanks': {
	    'Text':
	     """Thank you.... Slay any Orc that crosses your path. At least my """\
	     """fallen comrades will be avenged......... """,
	    'CallBack':'KnightExpired1', 
            'Answers': [],
            'NewDlg': None                     
        }
}
	    
TSDB.Ans ["DyingKnight"]={
	'fearnot': {
	    'Text':
	     """Fear not friend. I am just a traveller who fell foul of """\
	     """the Orc invaders. I have escaped the cells and seek a way out. """,
	    'NextDlg': 'whatof',
	    'Enabled':1	
	},
	'no':{
	    'Text':
	     """I don't hold out much hope. The Orcs do not take prisoners unless """\
	     """they have a use for them. """, 
	    'NextDlg': 'truth',
	    'Enabled':1	
	},
	'willdo':{
	    'Text':
	     """Say no more, I will try. But is there nothing I can do to help you? """,
	    'NextDlg': 'doomed',
	    'Enabled':1
	},
	'besure':{
	    'Text':
	     """Rest assured. I will do what I can...... """,
	    'NextDlg': 'thanks',
	    'Enabled':1			
	}
}    	    	   
###########################################################################
################### The Deep Chamber ######################################
###########################################################################
TSDB.Dlg ["Heardred"]={
	'speakT': {
	    'Text':
	     """Speak.......and I shall answer your question """,
	    'CallBack':'TextOff', 
            'Answers': ['whichgoodT','whichbadT','whatheT'],
            'NewDlg': None
        },
        'leftT': {
	    'Text':
	     """The Left Serpent leads to Fortune. """,
	    'CallBack':'OnlyOneL',
	    'Answers': [],
            'NewDlg': None
        },
        'rightT': {
	    'Text':
	     """The Right Serpent leads to Death """,
	    'CallBack':'OnlyOneL',
            'Answers': [],
            'NewDlg': None
        },
        'hesayT': {
	    'Text':
	     """He would say.......The Right Serpent. """,
	    'CallBack':'OnlyOneL',
            'Answers': [],
            'NewDlg': None
        },    
        'speakF': {
	    'Text':
	     """Speak.......and I shall answer your question. """,
	    'CallBack':'TextOff', 
            'Answers': ['whichgoodF','whichbadF','whatheF'],
            'NewDlg': None
        },
        'leftF': {
	    'Text':
	     """The Left Serpent leads to Fortune. """,
	    'CallBack':'OnlyOneL',
	    'Answers': [],
            'NewDlg': None
        },
        'rightF': {
	    'Text':
	     """The Right Serpent leads to Death """,
	    'CallBack':'OnlyOneL',
            'Answers': [],
            'NewDlg': None
        },
        'hesayF': {
	    'Text':
	     """He would say.......The Left Serpent. """,
	    'CallBack':'OnlyOneL',
            'Answers': [],
            'NewDlg': None
        },
        'onlyoneL': {
	    'Text':
	     """You may ask only one question. """,
            'Answers': [],
            'NewDlg': None              
        }
}
	    
TSDB.Ans ["Heardred"]={
	'whichgoodT': {
	    'Text':
	     """Which Serpent will lead to Fortune? """,
	    'DisableAns': ['whichbadT', 'whatheT'],
	    'NextDlg': 'leftT',
	    'Enabled':1	
	},
	'whichbadT':{
	    'Text':
	     """Which Serpent will lead to Death? """,
	    'DisableAns': ['whichgoodT', 'whatheT'],
	    'NextDlg': 'rightT',
	    'Enabled':1	
	},
	'whatheT':{
	    'Text':
	     """Which Serpent would the other Guard say is safe? """,
	    'DisableAns': ['whichbadT', 'whichgoodT'],
	    'NextDlg': 'hesayT',
	    'Enabled':1
	},
	'whichgoodF': {
	    'Text':
	     """Which Serpent will lead to Fortune? """,
	    'DisableAns': ['whichbadF', 'whatheF'],
	    'NextDlg': 'leftF',
	    'Enabled':1	
	},
	'whichbadF':{
	    'Text':
	     """Which Serpent will lead to Death? """,
	    'DisableAns': ['whichgoodF', 'whatheF'],
	    'NextDlg': 'rightF',
	    'Enabled':1	
	},
	'whatheF':{
	    'Text':
	     """Which Serpent would the other Guard say is safe? """,
	    'DisableAns': ['whichgoodF', 'whichbadF'],
	    'NextDlg': 'hesayF',
	    'Enabled':1
	}
}    	    	    

TSDB.Dlg ["Hygelac"]={
	'speakT': {
	    'Text':
	     """Speak.......and I shall answer your question """,
	    'CallBack':'TextOff',
            'Answers': ['whichgoodT','whichbadT','whatheT'],
            'NewDlg': None
        },
        'leftT': {
	    'Text':
	     """The Right Serpent leads to Fortune. """,
	    'CallBack':'OnlyOneA',
	    'Answers': [],
            'NewDlg': None
        },
        'rightT': {
	    'Text':
	     """The Left Serpent leads to Death """,
	    'CallBack':'OnlyOneA',
            'Answers': [],
            'NewDlg': None
        },
        'hesayT': {
	    'Text':
	     """He would say.......The Left Serpent. """,
	    'CallBack':'OnlyOneA',
            'Answers': [],
            'NewDlg': None
        },
        'speakF': {
	    'Text':
	     """Speak.......and I shall answer your question """,
	    'CallBack':'TextOff', 
            'Answers': ['whichgoodF','whichbadF','whatheF'],
            'NewDlg': None
        },
        'leftF': {
	    'Text':
	     """The Right Serpent leads to Fortune. """,
	    'CallBack':'OnlyOneA',
	    'Answers': [],
            'NewDlg': None
        },
        'rightF': {
	    'Text':
	     """The Left Serpent leads to Death """,
	    'CallBack':'OnlyOneA',	     
            'Answers': [],
            'NewDlg': None
        },
        'hesayF': {
	    'Text':
	     """He would say.......The Right Serpent. """,
	    'CallBack':'OnlyOneA',
            'Answers': [],
            'NewDlg': None
         },
        'onlyoneA': {
	    'Text':
	     """You may ask only one question. """,
            'Answers': [],
            'NewDlg': None
        },
         'onlyoneA': {
	    'Text':
	     """You may ask only one question. """,
            'Answers': [],
            'NewDlg': None                                           
        }
}
	    
TSDB.Ans ["Hygelac"]={
	'whichgoodT': {
	    'Text':
	     """Which Serpent will lead to Fortune? """,
	    'DisableAns': ['whichgoodT', 'whatheT'],
	    'NextDlg': 'leftT',
	    'Enabled':1	
	},
	'whichbadT':{
	    'Text':
	     """Which Serpent will lead to Death? """,
	    'DisableAns': ['whatheT', 'whichbadT'],
	    'NextDlg': 'rightT',
	    'Enabled':1	
	},
	'whatheT':{
	    'Text':
	     """Which Serpent would the other Guard say is safe? """,
	     'DisableAns': ['whichgoodT', 'whichbadT'],
	    'NextDlg': 'hesayT',
	    'Enabled':1
	},
	'whichgoodF': {
	    'Text':
	     """Which Serpent will lead to Fortune? """,
	    'DisableAns': ['whatheF', 'whichbadF'],
	    'NextDlg': 'leftF',
	    'Enabled':1	
	},
	'whichbadF':{
	    'Text':
	     """Which Serpent will lead to Death? """,
	    'DisableAns': ['whichgoodF', 'whatheF'],
	    'NextDlg': 'rightF',
	    'Enabled':1	
	},
	'whatheF':{
	    'Text':
	     """Which Serpent would the other Guard say is safe? """,
	    'DisableAns': ['whichgoodF', 'whichbadF'],
	    'NextDlg': 'hesayF',
	    'Enabled':1
	}
}    	    	    
#####################################################################################
########################### Herbert #################################################
#####################################################################################

TSDB.Dlg ["Herbert"]={
	'close': {
	    'Text':
	     """Are you alright?....That Orc was one of the """\
	     """weaker ones, but I wonder where he got that Sword? """,
	    'CallBack':'LookAtMeWhenImTalkingToYou', 
            'Answers': ['nearthing'],
            'NewDlg': None
        },
        'haveyou': {
	    'Text':
	     """Why yes!...Have you seen him?  This is """\
	     """not a place to be exploring alone. The """\
	     """Orcs have some fierce beasts caged up. They """\
	     """use them for the heavy labour. I am going to see if I can open the """\
	     """big door yonder""",
	     'CallBack':'Goforawalk', 
	    'Answers': [],
            'NewDlg': None
        },
        'creatures3': {
	    'Text':
	     """Oh No! Glofror is slain! I fear I must report back to the Dwarf Council. """\
	     """Will you not accompany us? """,
	     'CallBack':'ReGroup', 
	    'Answers': ['goeast'],
            'NewDlg': None
        },
        'asuwish': {
	    'Text':
	     """As you wish. Good luck on your journey! """,
	    'Answers': [],
            'NewDlg': None
        }
}
	    
TSDB.Ans ["Herbert"]={
	'nearthing': {
	    'Text':
	     """Yes! That could have been nasty.... """\
	     """It is fortunate you were there. Are you """\
	     """with Glofror's party?""",
	    'NextDlg': 'haveyou',
	    'Enabled':1	
	},
	'goeast':{
	    'Text':
	     """I fear I cannot go with you. I must journey on toward the western mountains """\
	     """Only there will I find santuary from the clutches of Vinculanus. """,
	    'NextDlg': 'asuwish',
	    'Enabled':1	
	}
}    	    	    
###########################################################################
################## Guard Commander ########################################
###########################################################################
TSDB.Dlg ["GuardCommander"]={
	'hold': {
	    'Text':
	     """By the Fires of Xshathra! It is %PlayerName the %Type. """\
	     """Your name is legend among the troops. """,
	     'CallBack':'LookAtMeWhenImTalkingToYou', 
            'Answers': ['noneother'],
            'NewDlg': None
        },
        'twoleft': {
	    'Text':
	     """We have been trapped in this place since the Orcs attacked. Alas only """\
	     """we three survive and our strength is waning rapidly. One more attack """\
	     """will surely be our downfall. Go into the hut. You are welcome to what few """\
	     """supplies we have left.""",
            'Answers': [],
            'HideDelay':25, 
            'NewDlg': None
        },
        'lookout': {
	    'Text':
	     """Ha!....that's a few more accounted for! But tell me %Playername, have"""\
	     """you seen Lord Kerman? I think he was in the Library when the Orcs fell on us. """,
            'Answers': ['nonotseen','yeshaveseen'],
            'NewDlg': None
        },
        'gratitude': {
	    'Text':
	     """Maybe he managed to ecsape. Who knows? I would be grateful if you  """\
	     """would look out for him. """,
	    'Answers': [],
            'NewDlg': None
        },
         'bethanked': {
	    'Text':
	     """May the Gods be thanked!....that is good news at least. """\
	     """But don't linger in this accursed place, make good your ecsape. """,
            'Answers': [],
            'NewDlg': None                     
        }
}
	    
TSDB.Ans ["GuardCommander"]={
	'noneother': {
	    'Text':
	     """Yes Captain. It is none other.....But your men are in a sorry state. """,
	    'NextDlg': 'twoleft',
	    'Enabled':1	
	},
	'nonotseen':{
	    'Text':
	     """No Captain, I have not seen any sign of him. I will try to find him. """,
	    'NextDlg': 'gratitude',
	    'Enabled':1
	},
	'yeshaveseen':{
	    'Text':
	     """Yes Captain, he was alive when last I saw him, but many of his men were """\
	     """badly wounded.""",
	    'NextDlg': 'bethanked',
	    'Enabled':1							
	}
}    	    	   
###########################################################################
## Journal
###########################################################################

TSDB.JrlTxt = {
	'MetGlofror':
	    """I have met up with my old friend Glofror. He and a band of fellow """\
	    """Dwarves have entered the fortress by a secret path.""",
	'TheStone':
	    """I have met up with my old friend Glofror. He and a band of fellow """\
	    """Dwarves intend to rid the fortress of the Orc invaders. He mentioned the Eye of Caradhras """\
	    """I thought it was just a travellers tale, but his words have set me thinking. """\
	    """I must keep my eyes open for clues""",
	'TrsScore':
	    """Total Treasure....%Total. """,
	'foundmap':
	    """I have found an old parchment. It tells of a tomb that is supposed to have been """\
	    """built deep beneath the fortress. It also tells of a great prize concealed within. I """\
	    """suspect this is what the Orcs were looking for.                               """\
	    """The way down looks treacherous, but I have little choice: I must try an get down there. """,
	'ent1':
	    """The Garrison has been invaded by an army of Orcs. I was outnumbered """\
	    """and now they have thrown me into this cell. I must escape before they """\
	    """can get word of my capture to the Black Guard. I think there is a jailer """\
	    """outside. He may have the key. If I can just attract his attention........""",
	'ent2m':
	    """I have rescued my old friend %Buddy, although he is very weak after """\
	    """being tortured by the Orcs. I must seek a way out and if I am able I will """\
	    """return later to check on him. The friendly Knights who were stationed """\
	    """here appear to have been slaughtered.""",
	'ent2f':
	    """I have rescued my old friend %Buddy, although she is very weak after """\
	    """being tortured by the Orcs. I must seek a way out and if I am able I will """\
	    """return later to check on her. The friendly Knights who were stationed """\
	    """here appear to have been slaughtered.""",
	'ent3':
	    """I have encountered a wounded Orc. The cowardly swine gave me some infomation """\
	    """about an escape route in exchange for sparing his life, but I don't trust him.... """,
	'ent4':
	    """The wounded Orc had a concealed weapon and attacked when I """\
	    """turned my back. He won't be doing that again! """,
	'ent5':
	    """The escape route was a trap! The Black Guard were waiting. Their leader Vinculanus """\
	    """was with them, although he retreated to a cave in the side of the gorge when the action """\
	    """started! I have killed four of his foot soldiers and three of his lieutanants. I have an """\
	    """urge to try and follow Vinculanus, but I fear that it is another trap. """,
	'ent6':
	    """I suprised a stray Guard with a box of treasure! There was an Orc with him. """\
	    """I don't know what was going on. Maybe the treasure was some sort of payment....."""\
	    """Ramsom money perhaps? There is another Guard outside the Falcon Gate. He has not seen me """\
	    """If I can fell him with an arrow he will not have a chance to escape and close the door. """,
	'ent7':
	    """I have met two interesting characters in a little shop. The place is full of weapons """\
	    """as well as a lot of very old cheese. Maybe I will exchange some of the tresure for new """\
	    """weapons. I will have to find another route back as the only exit is blocked. """, 
	'ent8':
	    """A raiding party of Orcs attacked the shop as I was looking around! They are all dead """\
	    """now. Crazydwarf was very thankful for my help and has told me of a secret tunnel that """\
	    """leads back to the Garrison. I think I glimpsed a door in the rocks on the right as I """\
	    """walked up...... """,
	'ent9':
	    """I have found my way back into the Garrison. The place is alive with Orcs! One had a  """\
	    """Bronze Key. It must fit the lock to the big door at the end of the passageway below. """\
	    """Maybe I will look around some more before I try to open it. """,
	'ent10':
	    """At the end of the Great Hall there is an archway protected by green lightning bolts.  """\
	    """I dare not try to pass through. If I can only topple the statue that stands before, it """\
	    """May disarm the beams.......... """,
	'ent11m':
	    """I have returned to the dungeons to check on %Buddy only to find a note. He has found a secret """\
	    """way out and has escaped that way. Maybe we will meet again some day........ """,
	'ent11f':
	    """I have returned to the dungeons to check on %Buddy only to find a note. She has found a secret """\
	    """way out and has escaped that way. Maybe we will meet again some day........ """,
	'ent12':
	    """The Tomb is protected by an ancient curse. I will have to use all my wits to get out """\
	    """of this chamber. I sense great danger approaching.......... """,
	'ent13':
	    """I have reached the Main Gate, only to find it secured by a big lock and two """\
	    """locking stones. The release levers are probably up in the two towers of the gate. """\
	    """I need to find a way up onto the walkways. There are still Orcs up there. Maybe one"""\
	    """has the key.....""",
	'ent14':
	    """The Great Bridge is down, demolished by the Orcs. One of the Trolls went beserk and """\
	    """attacked his masters. The beast is now dead. All ways up to the gate towers are """\
	    """sure to be barred. I think I may investigate the damage to the Bridge, if I can get """\
	    """past the barricade that the Orcs have built....""",
	'ent15':
	    """The Bridge is impassable and a rockfall has blocked my way back. I noticed a flimsy """\
	    """rope bridge leading to a path along the cliffs. I may as well follow it as it is the only """\
	    """way forward. I am curious to discover what the Orcs are up to. """,
	'ent16':
	    """I have just killed the biggest Troll I have ever seen! The Orcs have made a tunnel in """\
	    """the cliff face. I wonder what they were digging for........? """,
	'ent17':
	    """I have found a chamber deep in the earth. There appears to be nothing here except for """\
	    """an ancient tomb. Two undead Knights stand guard as they probably have for centuries. """\
	    """The place is littered with dead Orcs. If they were trying to unlock the mysteries of this """\
	    """unholy place they did not succeed.....""",
	'ent18a':
	    """With the help of my friend %Buddy the Great Beast is slain. All I need to do is to find """\
	    """the gate lever. The Orc may have thrown it over the cliff. If he did then there must surely be """\
	    """a spare one hidden somewhere.""",
	'ent18b':
	    """The Great Beast is dead! Alas my friend %Buddy was killed in the struggle...... """\
	    """I am eager to depart this evil place. The Orc who took the lever may have thrown it """\
	    """over the cliff. If it is not to be found then I will have to search for a spare one.""",	
	'ent18c':
	    """The Great Beast is dead! Lord Kerman stepped in to help me. """\
	    """I am eager to depart this evil place. The Orc who took the lever may have thrown it """\
	    """over the cliff. If it is not to be found then I will have to search for a spare one.""",		
	'ent19':
	    """Nine Hundred Gold Pieces will be paid to whosoever delivers the %Type %PlayerName """\
	    """into the hands of the Black Guard. """,	
	'ent20':
	    """It looks as if there are Trolls loose all over the place! It was fortunate that I had """\
	    """help from the Dwarves. However I cannot rely on their help much longer. I will bid them farewell """\
	    """and carry on alone. """,	
	'ent21':
	    """I have opened the Tomb and released whatever restless spirit was imprisoned within. The Eye of """\
	    """Caradhras is mine and the Sword of Ianna has been gifted to me. I have no wish to stay longer in this """\
	    """haunted chamber, although fresh dangers no doubt await me on the surface. """,	
	'ent22':
	    """I have reached Lord Kerman in the library. We were attacked by Black Guard assassins, but now they """\
	    """all lie dead. I have the Main Gate Key. Now is my chance to escape..... """,		    	    	    	    	    	    	    	    
        }
