###########################################################################
## Talk System Data Base
###########################################################################

import Talk


###########################################################################
## Standard Dialogs
###########################################################################


## Alone: The player says these texts when there is not nobody faced
##-------------------------------------------------------------------------

TSDB.Alone = [" Hay alguien ah !",
	      "No me gusta como se est poniendo esto...",
	      " Espera !... Creo que he escuchado algo",
	      "Este lugar parece desierto"]

              
## Alone: The player says these texts when the faced character doesn't
## have assigned any dialogue.
##-------------------------------------------------------------------------
              
TSDB.Ignore = ["Estas muy callado, amigo.",
               "Me ignora.... seguro",
               " Ests SORDO ?",
               " Hola !"]              
               
###########################################################################
## Customized dialogs for each character
###########################################################################

## Dlg Database:
## Format:
##    TSDB.Dlg [pers.Name]={
##           'dlgId': {
##              'Text':
##                """Texto libre""",
##               'Answers': ['ansId1',...'ansIdn']
##              'OtherKey': value
##           }
##    }
##
## * Text: The text will be formatted for TS.
## * Answer: List of answers (ansId). If the list is null [] the
##   conversation is stopped.
##  Please read the documentation to know the details
##
##-------------------------------------------------------------------------

###########################################################################
## Player Answers
###########################################################################

## Answers Database:
## Format:
##   TSDB.Ans [pers.Name]={
##	'ansId': {
##	    'Text':
##	     """Texto""",
##	    'NextDlg': 'ansId',
##	    'Enabled':1
##          'OtherKey': value
##       }
##    }
## * Text: The text will be formatted for TS.
## * NextDlg: The identifier of the next dialogue (dlgId). To stop a  
##   conversation: None.
##  Please reads the documentation to know the details
##-------------------------------------------------------------------------
##############################################
####   Glofror     ###########################
##############################################


TSDB.Dlg ["Glofror"]={
	'FirstGreeting': {
	    'Text':
	     """%PlayerName !...me alegra verte de nuevo! 'Soy yo,...  Glofror ! """\
	     """.... Qu ests haciendo en este maldito lugar ? """,
           'Answers': ['Looking','Leader'],
           'CallBack':'LookAtMeWhenImTalkingToYou', 
           'NewDlg': None
        },
	'SawThem': {
	    'Text':
	     """ Ya !... Los vimos en el camino....... """\
	     """Estoy con una partida de hermanos Enanos. Hemos viajado en secreto por los antiguos caminos. """\
	     """Pronto nuestro pueblo expulsar a los orcos de este pais. """\
	     """Hemos escuchado que este lugar est lleno de riquezas que los soldados """\
	     """han robado a los viajeros durante aos.""",
            'Answers': ['True','Slain'],
            'NewDlg': 'None'
        },
	'yorright': {
	    'Text':
	     """Probablemente ests en lo cierto, amigo. Dar un vistazo rpido a este lugar y """\
	     """volver por mi camino.  Buena suerte !.... y cuidate.  """,
            'Answers': [],
            'NewDlg': 'None'
        },
	'Stairs': {
	    'Text':
	     """Destruimos una de las puertas en los subterraneos. Un pasaje nos condujo hasta """\
	     """aqu. Algunos de los mios estn ah abajo, encargandose de esas asquerosas """\
	     """criaturas.  Tal vez puedas echarles una mano !""", 
            'Answers': ['WillDo'],
            'NewDlg': 'None'
        },
        'Perhaps': {
	    'Text':
	     """ Si !... pero muchos de esos malditos orcos han caido bajo el hacha de Glofror. """\
	     """Puede que estn buscando algn tesoro. Las leyendas dicen que una piedra """\
	     """fabulosa, el Ojo de Caradhras, est oculta entre estos muros.""",
            'Answers': ['Iveheardthat'],
            'NewDlg': 'None'
        },
        'cantopen': {
	    'Text':
	     """ Ah !....eres t %PlayerName.  No puedo abrir esta maldita puerta ! """\
	     """ Has tenido problemas ? """,
	    'CallBack':'LookAtMeWhenImTalkingToYou', 	    
            'Answers': ['nothingthat'],
            'NewDlg': 'None'
        },
        'smell': {
	    'Text':
	     """Ni a mi.... cualquier cosa que bloque esta celda debe seguir ah. """\
	     """ Huelo a Troll !....  En guardia ! """,
	     'CallBack':'TrollsReady', 	   	    
            'Answers': [],
            'NewDlg': 'None'
        },
        'creatures': {
	    'Text':
	     """ Estis bien los dos ?..... No puedo ayudaros a sentir pena por esas """\
	     """pobres bestias. Los orcos las tratan con severidad, comprendo """\
	     """que siempre estn de mal humor. """,	  
	    'ExtraDlg': ['Herbert',
	    	         """Tengo algunos araazos Glofror...."""], 
            'Answers': ['ioktoo'],
            'NewDlg': 'None'
        },
        'lookround': {
	    'Text':
	     """ Este lugar se est volviendo demasiado peligroso ! Herbert, recoge al resto de """\
	     """los nuestros. Debemos informar al Consejo de los Enanos. """,  
	    'ExtraDlg': ['Herbert',
	    	         """Creo que he escuchado a Glofror acercarse."""], 
	    'CallBack':'ReGroup', 	    
            'Answers': [],
            'NewDlg': 'None'
        },
        'creatures2': {
	    'Text':
	     """ Maldita sea ! Me temo que Herbert ha luchado su ltima batalla...... """\
	     """ Ests bien %PlayerName ? """,
	    'CallBack':'ReGroup', 
            'Answers': ['iok'],
            'NewDlg': 'None'
        },
        'gather': {
	    'Text':
	     """Si , este lugar es demasiado peligroso. Reunir a los mios """\
	     """y juntos informaremos al Consejo de los Enanos.  Espero que nos veamos de nuevo """\
	     """en mejores circunstancias ! """,
	    'CallBack':'ReGroup', 
            'Answers': [],
            'NewDlg': 'None'
        },
	'tales': {
	    'Text':
	     """Si... He escuchado algunas historias de su diablico poder. Su nombre es Vinculanus. """\
	     """Algunos dicen que es el hermanastro de Lord Kerman y que est conspirando """\
	     """para usurpar el Ducado de Tell Halaf. No s si esto es cierto....  Quin sabe....? """,
            'Answers': ['advise'],
            'NewDlg': 'None'
        },
        'helloagain': {
	    'Text':
	     """Vaya, nos encontramos de nuevo %PlayerName.  Siempre rodeado de problemas !... He decidido """\
	     """echar un ltimo vistazo antes de partir. Encontr un montn de cuerpos de orcos...  saba que no andaras lejos ! """,
            'Answers': ['gotsomething'],
            'NewDlg': 'None'
        },
        'doyoumean': {
	    'Text':
	     """ Qu quieres decir ? No habrs encontrado.....  Por todos los Dioses !  No puede ser cierto ! """,
	    'CallBack':'GetTheGem', 
            'Answers': ['sureis'],
            'NewDlg': 'None'
        },
        'isurelywill': {
	    'Text':
	     """ Por el Hacha desgarradora de Skorageirr !  Ser un honor escoltar la gran Gema  """\
	     """hasta el Vestbulo de los Antepasados. """,
	    'CallBack':'PassTheGem', 
            'Answers': ['farewell'],
            'NewDlg': 'None'
        },
        'goodluck': {
	    'Text':
	     """As sea %PlayerName. Te deseo buena suerte en t viaje. Ten por seguro que tu nombre """\
	     """estar siempre en la memoria de todos los Enanos y en todas sus leyendas. """\
	     """  Adios amigo !  Que las espadas de tus enemigos nunca te impidan llegar a la vejez ! """,
	    'HideDelay':14, 
	    'CallBack':'GlofrorOut', 
            'Answers': [],
            'NewDlg': 'None'
        }		
}

#####
TSDB.Ans ["Glofror"]={
	'Looking': {
	    'Text':
	     """  Me alegro de encontrarte Glofror !  Yo podra hacerte la misma pregunta !, """\
	     """ La Guardia Negra va detrs de m. He acabado con algunos, pero estn """\
	     """ en todas partes.""",
	    'NextDlg': 'SawThem',
	    'Enabled':1
	},	
	'Leader': {
	    'Text':
	     """Fu capturado por los orcos, pero consegu escapar. Sospecho que ellos """\
	     """queran entregarme a la Guardia Negra. Acabo de luchar con """\
	     """el Caballero que los lidera. Es un adversario peligroso, parece que alguien """\
	     """le ha enseado la Magia Oscura. Llevaba el escudo de Dal Gurak.....""",
	    'NextDlg': 'tales',
	    'Enabled':1
        },	
	'True': {
	    'Text':
	     """Puede haber algo de cierto en esas historias. He encontrado """\
	     """algunas baratijas....  Pero cmo habeis entrado ?""",
	    'NextDlg': 'Stairs',
	    'Enabled':1
        },
	'WillDo': {
	    'Text':
	     """ Lo har !  Por qu no te acercas al cuarto del rincn ? """\
	     """Encontrars armas y comida all. Tambin hay una puerta bloqueada.  Quizs tu puedas """\
	     """persuadirla para que se abra !""",
	    'Journal': 'MetGlofror',
	    'Enabled':1
        },
	'Slain': {
	    'Text':
	     """ Ay !.... Cuntos caballeros han caido en manos de los orcos !  """\
	     """Parece que han ocupado este lugar. """\
	     """Deben estar planeando algo. Pero no s qu ser. """,
	    'NextDlg': 'Perhaps',
	    'Enabled':1
	}, 
	'Iveheardthat': {
	   'Text':
	    """Yo tambin escuch esos cuentos, aunque nunca les d crdito... """\
	    """pero puedes intentar encontrarla. Yo no puedo quedarme para ayudarte, debo partir """\
	    """antes de que la Guardia llegue.""",
	   'Journal': 'TheStone',
	   'Enabled':1
	}, 
	'nothingthat': {
	   'Text':
	    """Nada que no pudiese manejar.... con la ayuda del joven Herbert. """\
	    """Pero no me gusta como se est poniendo este lugar. """,
	   'NextDlg': 'smell',
	   'Enabled':1
	}, 
	'ioktoo': {
	   'Text':
	    """ Si, estoy an de una sola pieza !... Esperemos que no haya muchos Trolls """\
	    """perdidos. """,
	   'NextDlg': 'lookround',
	   'Enabled':1
	}, 
	'iok': {
	   'Text':
	    """Nada que no cure el tiempo, Glofror. Me gustara quedarme y ayudar, """\
	    """pero debo seguir mi camino. """,
	   'NextDlg': 'gather',
	   'Enabled':1
	}, 
	'advise': {
	   'Text':
	    """Algn trabajo sucio est en marcha, eso es seguro. Este lugar se est volviendo """\
	    """demasiado peligroso. Debo salir lo antes posible. Te aconsejo que t y los """\
	    """tuyos hagais lo mismo......""",
	    'Journal': 'MetGlofror',
	   'NextDlg': 'yorright',
	   'Enabled':1
	},
	'gotsomething': {
	   'Text':
	    """Me alegro de verte de nuevo, Glofror. He encontrado algo que legtimamente """\
	    """pertenece a los Enanos. """,
	   'NextDlg': 'doyoumean',
	   'Enabled':1
	},
	'sureis': {
	   'Text':
	    """Creeme Glofror. Estaba en la tumba de un Caballero muerto hace mucho tiempo, pero ahora su """\
	    """espritu ha sido liberado y el Ojo de Caradhras debe ser devuelto al pueblo de los Enanos. """\
	    """ Querras hacerte cargo de l ? """,
	   'NextDlg': 'isurelywill',
	   'Enabled':1
	},
	'farewell': {
	   'Text':
	    """Me alegran tus palabras, Glofror, pero tienes que buscar un camino seguro. Qudate aqu """\
	    """hasta que yo encuentre una va de escape. Hay an muchos peligros. Continuar por aqu """\
	    """e intentar encontrar la llave de la Puerta Principal. """,
	   'NextDlg': 'goodluck',
	   'Enabled':1
        }
}
############################################
######    Tukaram  #########################
############################################

TSDB.Dlg ["Tukaram"]={
	'CheersT': {
	    'Text':
	     """ Nunca me he alegrado tanto de ver a alguien, %PlayerName.... """\
	     """ Yo fui hecho para esto ! pero t debes darte prisa y """\
	     """abandonar este lugar con vida. Los orcos han encendido una luz en la atalaya para """\
	     """convocar a la Guardia Negra.  Han puesto un alto precio por tu cabeza !""",
           'Answers': ['Idontdoubt','Leave'],
           'NewDlg': 'None'
        },
        'Boxes': {
	    'Text':
	     """Ests en lo cierto. He estado pudrindome en este asqueroso agujero durante semanas. """\
	     """Descansar un poco para recobrar mis fuerzas. Mira detrs tuya, en la alcoba, """\
	     """estoy seguro de que esas estpidas bestias esconden la llave entre las cajas. """,
	   'Journal': 'ent2m',
           'Answers': [],
           'NewDlg': None  
        },
        'Iheard': {
	    'Text':
	     """Los escuch por casualidad mientras tramaban algo. Comprendo poco el lenguaje orco, """\
	     """pero pienso que intentan destruir el Gran Puente hacia la Ciudadela. """,
           'Answers': ['Makessense'],
           'NewDlg': None  
        },
        'GoNow': {
	    'Text':
	     """ Bah ! Eso no los detendr mucho tiempo. Los Enanos son un pueblo lleno """\
	     """de recursos y conocen todos los caminos secretos. Pero vayamos. Intentar seguirte despus """\
	     """si me encuentro con suficientes fuerzas.""",
	   'Journal': 'ent2m',
           'Answers': [],
           'NewDlg': None 
        },
        'yegods': {
	    'Text':
	     """ Por todos los Dioses !  Qu monstruosidad !......  ests herido %PlayerName ? """,
           'Answers': ['yesfine'],
           'NewDlg': None
        },
        'lever': {
	    'Text':
	     """He intentado escapar a travs de las montaas del lago, al sur, """\
	     """pero el puente ha caido. Vayamos por la Puerta y dejemos este """\
	     """lugar.  Dnde est el orco que tena la palanca ? """,
           'Answers': [],
           'NewDlg': None                                                                                  
        }
}


TSDB.Ans ["Tukaram"]={
	'Idontdoubt': {
	    'Text':
	     """ No lo dudo ! ... Pero ests herido. Qudate aqu y descansa. """\
	     """Los carceleros no te darn ms problemas. Debo buscar la llave """\
	     """de la puerta pequea que ah ms all. Ese orco loco no la tena.""",
	    'NextDlg': 'Boxes',
	    'Enabled':1
        },	
	'Leave': {
	    'Text':
	     """Si, debo dejar este lugar tan pronto como sea posible, pero siento curiosidad. """\
	     """.... Los orcos planean algo.  Por qu ocuparon esta vieja fortaleza ? """\
	     """Tan estpidos como parecen, ellos no haran algo sin una buena razn.""",
	    'NextDlg': 'Iheard',
	    'Enabled':1
        },	
        'Makessense': {
	    'Text':
	     """Hmm,.....tiene sentido. Hay una armada Enana agrupandose al Norte. """\
	     """Los orcos deben temer su ataque e intentan parar su avance. """,
	    'NextDlg': 'GoNow',
	    'Enabled':1
	},	
        'yesfine': {
	    'Text':
	     """Estoy bien,... un poco cansado. Parece que t tambin ests bien. """,
	    'NextDlg': 'lever',
	    'Enabled':1
        }	
}

############################################################################
################   Zoe   ###################################################
############################################################################

TSDB.Dlg ["Zoe"]={
	'CheersZ': {
	    'Text':
	     """La Fortuna ha vuelto a mi, %PlayerName. """\
	     """ Yo fui hecha para esto ! pero t debes darte prisa y """\
	     """abandonar este lugar con vida. Los orcos han encendido una luz en la atalaya para """\
	     """convocar a la Guardia Negra.  Han puesto un alto precio por tu cabeza !""",
           'Answers': ['Idontdoubt','Leave'],
           'NewDlg': None
        },
        'Boxes': {
	    'Text':
	     """Ests en lo cierto. He estado pudrindomen en este asqueroso agujero durante semanas. """\
	     """Descansar un poco para recobrar mis fuerzas. Mira detrs tuya, en la alcoba, """\
	     """estoy segura de que esas estpidas bestias esconden la llave entre las cajas. """,
	   'Journal': 'ent2f',
           'Answers': [],
           'NewDlg': None  
        },
        'Iheard': {
	    'Text':
	     """Los escuch por casualidad mientras tramaban algo. Comprendo poco el lenguaje orco, """\
	     """pero pienso que intentan destruir el Gran Puente hacia la Ciudadela. """,
           'Answers': ['Makessense'],
           'NewDlg': None  
        },
        'GoNow': {
	    'Text':
	     """ Bah ! Eso nos los detendr mucho tiempo. Los Enanos son un pueblo lleno """\
	     """de recursos y conocen todos los caminos secretos. Pero vayamos. Intentar seguirte despus """\
	     """si me encuentro con suficientes fuerzas.""",
	   'Journal': 'ent2f',
           'Answers': [],
           'NewDlg': None
        },
        'yegods': {
	    'Text':
	     """ Por todos los Dioses !  Qu monstruosidad !......  ests herido %PlayerName ? """,
           'Answers': ['yesfine'],
           'NewDlg': None
        },
        'lever': {
	    'Text':
	     """He intentado escapar a travs de las montaas del lago, al sur, """\
	     """pero el puente est caido. Vayamos por la Puerta y dejemos este """\
	     """lugar.  Dnde est el orco que tena la palanca ? """,
           'Answers': [],
           'NewDlg': None                                                                                           
        }
}


TSDB.Ans ["Zoe"]={
	'Idontdoubt': {
	    'Text':
	     """ No lo dudo ! ....Pero ests herida. Qudate aqu y descansa. """\
	     """Los carceleros no te darn ms problemas. Debo buscar la llave """\
	     """de la puerta pequea que ah ms all. Ese orco loco no la tena.""",
	    'NextDlg': 'Boxes',
	    'Enabled':1
        },	
	'Leave': {
	    'Text':
	     """Si, debo dejar este lugar tan pronto como sea posible, pero siento curiosidad. """\
	     """....Los orcos planean algo.  Por qu ocuparon esta vieja fortaleza ? """\
	     """Tan estpidos como parecen, ellos no haran algo sin una buena razn.""",
	    'NextDlg': 'Iheard',
	    'Enabled':1
        },	
        'Makessense': {
	    'Text':
	     """Hmm,.... tiene sentido. Hay una armada Enana agrupandose al Norte. """\
	     """Los orcos deben temer su ataque e intentan parar su avance. """,
	    'NextDlg': 'GoNow',
	    'Enabled':1
	},	
        'yesfine': {
	    'Text':
	     """Estoy bien,...  un poco cansada. Parece que t tambin ests bien. """,
	    'NextDlg': 'lever',
	    'Enabled':1
        }	
}

############################################################################
#########################   Sargon   #######################################
############################################################################

TSDB.Dlg ["Sargon"]={
	'CheersS': {
	    'Text':
	     """Me alegra verte de nuevo, %PlayerName. """\
	     """ Yo fui hecho para esto ! pero t debes darte prisa y """\
	     """abandonar este lugar con vida. Los orcos han encendido una luz en la atalaya para """\
	     """convocar a la Guardia Negra.  Han puesto un alto precio por tu cabeza !""",
           'Answers': ['Idontdoubt','Leave'],
           'NewDlg': None
        },
        'Boxes': {
	    'Text':
	     """Ests en lo cierto. He estado pudrindomen en este asqueroso agujero durante semanas. """\
	     """Descansar un poco para recobrar mis fuerzas. Mira detrs tuya, en la alcoba, """\
	     """estoy seguro de que esas estpidas bestias esconden la llave entre las cajas. """,
	   'Journal': 'ent2m',
           'Answers': [],
           'NewDlg': None  
        },
        'Iheard': {
	    'Text':
	     """Los escuch por casualidad mientras tramaban algo. Comprendo poco el lenguaje orco, """\
	     """pero pienso que intentan destruir el Gran Puente hacia la Ciudadela. """,
           'Answers': ['Makessense'],
           'NewDlg': None  
        },
        'GoNow': {
	    'Text':
	     """ Bah ! Eso nos los detendr mucho tiempo. Los Enanos son un pueblo lleno """\
	     """de recursos y conocen todos los caminos secretos. Pero vayamos. Intentar seguirte despus """\
	     """si me encuentro con suficientes fuerzas.""",
	   'Journal': 'ent2m',
           'Answers': [],
           'NewDlg': None  
        },
        'yegods': {
	    'Text':
	     """ Por todos los Dioses !  Qu monstruosidad !......  ests herido %PlayerName ? """,
           'Answers': ['yesfine'],
           'NewDlg': None
        },
        'lever': {
	    'Text':
	     """He intentado escapar a travs de las montaas del lago, al sur, """\
	     """pero el puente est caido. Vayamos por la Puerta y dejemos este """\
	     """lugar.  Dnde est el orco que tena la palanca ? """,
           'Answers': [],
           'NewDlg': None                                                                                                      
        }
}


TSDB.Ans ["Sargon"]={
	'Idontdoubt': {
	    'Text':
	     """ No lo dudo ! ... Pero ests herido. Qudate aqu y descansa. """\
	     """Los carceleros no te darn ms problemas. Debo buscar la llave """\
	     """de la puerta pequea que ah ms all. Ese orco loco no la tena.""",
	    'NextDlg': 'Boxes',
	    'Enabled':1
        },	
	'Leave': {
	    'Text':
	     """Si, debo dejar este lugar tan pronto como sea posible, pero siento curiosidad. """\
	     """....Los orcos planean algo.  Por qu ocuparon esta vieja fortaleza ? """\
	     """Tan estpidos como parecen, ellos no haran algo sin una buena razn.""",
	    'NextDlg': 'Iheard',
	    'Enabled':1
        },	
        'Makessense': {
	    'Text':
	     """Hmm,.....tiene sentido. Hay una armada Enana agrupandose al Norte. """\
	     """Los orcos deben temer su ataque e intentan parar su avance. """,
	    'NextDlg': 'GoNow',
	    'Enabled':1
	},	
        'yesfine': {
	    'Text':
	     """Estoy bien,...un poco cansado. Parece que t tambin ests bien. """,
	    'NextDlg': 'lever',
	    'Enabled':1
        }	
}

############################################################################
############################    Naglfar  ###################################
############################################################################

TSDB.Dlg ["Naglfar"]={
	'CheersN': {
	    'Text':
	     """Tu eleccin del momento ha sido exquisita, %PlayerName. """\
	     """ No me gustaba cmo me miraba ese hierro caliente ! Pero t debes darte prisa y """\
	     """abandonar este lugar con vida. Los orcos han encendido una luz en la atalaya para """\
	     """convocar a la Guardia Negra.  Han puesto un alto precio por tu cabeza !""",
           'Answers': ['Idontdoubt','Leave'],
           'NewDlg': None
        },
        'Boxes': {
	    'Text':
	     """Ests en lo cierto. He estado pudrindomen en este asqueroso agujero durante semanas. """\
	     """Descansar un poco para recobrar mis fuerzas. Mira detrs tuya, en la alcoba, """\
	     """estoy seguro de que esas estpidas bestias esconden la llave entre las cajas. """,
	   'Journal': 'ent2m',
           'Answers': [],
           'NewDlg': None  
        },
        'Iheard': {
	    'Text':
	     """Los escuch por casualidad mientras tramaban algo. Comprendo poco el lenguaje orco, """\
	     """pero pienso que intentan destruir el Gran Puente hacia la Ciudadela. """,
            'Answers': ['Makessense'],
            'NewDlg': None  
        },
        'GoNow': {
	    'Text':
	     """ Bah ! Eso nos los detendr mucho tiempo. Los Enanos son un pueblo lleno """\
	     """de recursos y conocen todos los caminos secretos. Pero vayamos. Intentar seguirte despus """\
	     """si me encuentro con suficientes fuerzas.""",
	   'Journal': 'ent2m',
           'Answers': [],
           'NewDlg': None 
        },
        'yegods': {
	    'Text':
	     """ Por todos los Dioses !  Qu monstruosidad !.......  ests herido %PlayerName ? """,
           'Answers': ['yesfine'],
           'NewDlg': None
        },
        'lever': {
	    'Text':
	     """He intentado escapar a travs de las montaas del lago, al sur, """\
	     """pero el puente est caido. Vayamos por la Puerta y dejemos este """\
	     """lugar.  Dnde est el orco que tena la palanca ? """,
           'Answers': [],
           'NewDlg': None                                                                                           
        }
}


TSDB.Ans ["Naglfar"]={
	'Idontdoubt': {
	    'Text':
	     """ No lo dudo ! ....Pero ests herido. Qudate aqu y descansa. """\
	     """Los carceleros no te darn ms problemas. Debo buscar la llave """\
	     """de la puerta pequea que ah ms all. Ese orco loco no la tena.""",
	    'NextDlg': 'Boxes',
	    'Enabled':1
        },	
	'Leave': {
	    'Text':
	     """Si, debo dejar este lugar tan pronto como sea posible, pero siento curiosidad. """\
	     """....Los orcos planean algo.  Por qu ocuparon esta vieja fortaleza ? """\
	     """Tan estpidos como parecen, ellos no haran algo sin una buena razn.""",
	    'NextDlg': 'Iheard',
	    'Enabled':1
        },	
        'Makessense': {
	    'Text':
	     """Hmm,.....tiene sentido. Hay una armada Enana agrupandose al Norte. """\
	     """Los orcos deben temer su ataque e intentan parar su avance. """,
	    'NextDlg': 'GoNow',
	    'Enabled':1
	},	
        'yesfine': {
	    'Text':
	     """Estoy bien,...un poco cansado. Parece que t tambin ests bien. """,
	    'NextDlg': 'lever',
	    'Enabled':1
        }	
}

############################################################################
#########   Wounded Orc   ##################################################
############################################################################

TSDB.Dlg ["WoundedOrc"]={
	'Donthurtme': {
	    'Text':
	     """ No matar %Type ! Yo decir cmo escapar.. """\
	     """....arrgh !....   mis piernas estn heridas ! """,
            'Answers': ['Idonttrust', 'speak'],
            'NewDlg': None
        },
        'wall': {
	    'Text':
	     """Puedes saltar el muro al final del pasillo.. """\
	     """..la Puerta Grande est abierta. Sigue garganta abajo hasta """\
	     """ Falcon Gate.... y escapa por las montaas.""",
            'Answers': ['trap'],
            'NewDlg': None
        },
        'lie': {
	    'Text':
	     """No mentir.....Yo herido..  Owww !  mis piernas !  No siento las piernas ! """,
	    'Journal': 'ent3',
            'Answers': [],
            'NewDlg': None
        }
}



TSDB.Ans ["WoundedOrc"]={
	'Idonttrust': {
	    'Text':
	     """ Por qu debera fiarme de t... estpida criatura ? """,
	    'NextDlg': 'None',
	    'Enabled':1	
	},
	'speak':{
	    'Text':
	     """ Habla rpido !... y tal vez te perdone la vida. """,
	    'NextDlg': 'wall',
	    'Enabled':1	
	},
	'trap':{
	    'Text':
	     """ Cmo s que no es una trampa... ? """,
	    'NextDlg': 'lie',
	    'Enabled':1	
	}
}    

##########################################################################
##############  Lord Kerman  #############################################
##########################################################################

TSDB.Dlg ["LordKerman"]={
	'Whothere': {
	    'Text':
	     """ Quin anda ah ?....  amigo o enemigo ? """,
            'Answers': ['itsme'],
            'NewDlg': None
        },
        'Good': {
	    'Text':
	     """Es bueno encontrar un rostro amigo %PlayerName. """\
	     """Estaba aqu, en la Biblioteca, estudiando unas Crnicas antiqusimas """\
	     """cuando los orcos invadieron la Guarnicin. Mi guardia personal fue """\
	     """malherida, pero consegu cerrar la Gran Puerta. """\
	     """Los orcos no pueden entrar, pero han bloqueado la salida con barras. """\
	     """Tengo una llave, pero no puedo alcanzar la cerradura. Estamos atrapados aqu. """\
	     """Pero dime,  cmo has entrado ? La Guarnicin debe estar """\
	     """llena de escoria""",
	    'CallBack':'SwitchView', 
            'Answers': ['fearnot'],
            'NewDlg': None
        },
        'bythe': {
	    'Text':
	     """ Por todos los Dioses !  Ahora lo entiendo todo ! Los orcos intentan venderme a """\
	     """mi hermanastro Vinculanus. Dime,  los conduce un horrible bastardo """\
	     """con la barba negra ?  Ten cuidado con l !  Es un formidable guerrero y tiene """\
	     """conocimientos de las Artes Oscuras""", 
            'Answers': ['verywell'],
            'NewDlg': None
        },
        'fought': {
	    'Text':
	     """ Qu !...  has luchado contra l y has sobrevivido ?  Debes ser un verdadero """\
	     """guerrero !...  pero lo has matado ? """,
            'Answers': ['pet'],
            'NewDlg': None
        },
        'wemust': {
	    'Text':
	     """Buen trabajo %PlayerName. Ahora debes abandonar este lugar. """\
	     """La llave de la Puerta Principal est en la mesa. """\
	     """Intenta abrirla... Si lo consigues, haras bien en """\
	     """escapar..."""\
	     """Yo debo quedarme y dar moral a los heridos.""",
	    'CallBack':'LookAtMeWhenImTalkingToYou', 
            'Answers': ['asyouwish'],
            'NewDlg': None
        },
        'notime': {
	    'Text':
	     """ Por la memoria de mis antepasados !  su maldad no tiene fin !... """\
	     """Rpido entonces,  no hay tiempo que perder ! """\
	     """Toma esta llave y desbloquea las barras exteriores. """,
	    'CallBack':'HandOverKey',
            'Answers': ['aye'],
            'NewDlg': None
        },
        'watchit': {
	    'Text':
	     """Gracias %PlayerName...   pero mantente alerta !... Puede haber an muchos orcos """\
	     """acechando en el exterior. """,
	    'CallBack':'SwitchViewBack', 
            'Answers': [],
            'NewDlg': None
        },
        'makehaste': {
	    'Text':
	     """Date prisa pues...  qu los Dioses te protejan !... """\
	     """Mortimer...manten la guardia en el pasadizo. """,
	    'ExtraDlg': ['Mortimer',
	    	         """S, mi Seor..."""],
	    'CallBack':'GoToCheck1', 
            'Answers': [],
            'NewDlg': None
        },
        'more': {
	    'Text':
	     """ Vaya !.... Necesitarn ms de esos tres chacales para acabar con nosotros... """\
	     """ t que dices Mortimer ? """,
	    'ExtraDlg': ['Mortimer',
	    	         """ As es mi Lord Duke !  no son nada para un guerrero de verdad !"""],
            'Answers': ['letusnot'],
            'NewDlg': None
        },
        'wounded': {
	    'Text':
	     """Ests en lo cierto %PlayerName...  Vamos Mortimer ! Veamos si podemos arrastrar a los heridos. """,
	    'CallBack':'GoSee1', 
            'Answers': [],
            'NewDlg': None
        },
        'lost': {
	    'Text':
	     """ Los chacales estn todos muertos !... pero mi buen lugarteniente ha caido. """,
            'Answers': ['pity'],
            'NewDlg': None
        },
        'nothing': {
	    'Text':
	     """Lo echar de menos. Pero no hay nada ms que podamos hacer aqu. """\
	     """Toma la llave y vayamos a la Gran Puerta. Veamos si puedo conseguir mover a mis hombres. """,
	    'CallBack':'GoSee2', 
            'Answers': [],
            'NewDlg': None
        },
        'rebuild': {
	    'Text':
	     """ Por los Dioses !  Menuda bestia ! Pero creeme, %Playername, yo pienso que la Guarnicin est libre  """\
	     """de enemigos.  Qu piensas hacer ahora ? """,
            'Answers': ['wherelever'],
            'NewDlg': None
        },
        'notaccompany': {
	    'Text':
	     """Por supuesto. Siento no poder acompaarte. Debo quedarme y enviar refuerzos.  """\
	     """ Buena suerte en tu viaje ! """,
            'Answers': [],
            'NewDlg': None
        }
}


TSDB.Ans ["LordKerman"]={
	'itsme': {
	    'Text':
	     """ Seor !.... Soy amigo. Mi nombre es %PlayerName. """,
	    'NextDlg': 'Good',
	    'Enabled':1	
	},
	'fearnot':{
	    'Text':
	     """Sufr una emboscada en la puerta y me arrojaron a una celda, pero """\
	     """consegu escapar. Me temo que los orcos son el menor de nuestros """\
	     """problemas... la Guardia Negra est aqu. """,
	    'NextDlg': 'bythe',
	    'Enabled':1	
	},
	'verywell':{
	    'Text':
	     """ Ya nos han presentado, Seor ! """,
	    'NextDlg': 'fought',
	    'Enabled':1	
	},
	'pet':{
	    'Text':
	     """Me temo que no, mi Seor. Cuando se vi perdido us su magia para """\
	     """desaparecer. Me dej una de sus mscotas, un terrible demonio, para """\
	     """que acabase conmigo. """,
	    'NextDlg': 'notime',
	    'Enabled':1	
	},
	'aye':{
	    'Text':
	     """ Si, mi Seor ! Lo har...""",
	    'NextDlg': 'watchit',
	    'Enabled':1	
	},
	'asyouwish':{
	    'Text':
	     """Como desee Seor, pero intentar regresar. """,
	    'NextDlg': 'makehaste',
	    'Enabled':1	
	},
	'letusnot':{
	    'Text':
	     """ Bien dicho !... pero no nos demoremos. Quin sabe cuntos ms estarn rondando por ah. """,
	    'NextDlg': 'wounded',
	    'Enabled':1	
	},
	'pity':{
	    'Text':
	     """Lo siento. Fue un gran hombre, mi Lord. Luch valientemente hasta el final. """,
	    'NextDlg': 'nothing',
	    'Enabled':1	
	},
	'wherelever':{
	    'Text':
	     """Viajar hacia las montaas occidentales, mi Seor... a ver si puedo encontrar el cadaver """\
	     """del orco que intent ocultar la palanca. """,
	    'NextDlg': 'notaccompany',
	    'Enabled':1	
	}
}    
###########################################################################
###########      Crazydwarf    ############################################
###########################################################################


TSDB.Dlg ["Crazydwarf"]={
	'welcomeZ': {
	    'Text':
	     """Bienvenido a mi humilde tienda, Seor. """\
	     """ Cmo puedo serviros ? """,
	    'CallBack':'SetRaidTriggs', 
	    'Journal': 'ent7',
            'Answers': ['cheese','callingZ'],
            'NewDlg': None
        },
        'welcomeB': {
	    'Text':
	     """Bienvenido a mi humilde tienda, Seora. """\
	     """ Cmo puedo serviros ? """,
	    'CallBack':'SetRaidTriggs', 
	    'Journal': 'ent7',
            'Answers': ['cheese','callingB'],
            'NewDlg': None
        },
        'gotnone': {
	    'Text':
	     """Lo siento, apenas me queda queso y est """\
	     """un poco duro. """,
            'Answers': ['ilike'],
            'NewDlg': None
         },
         'tougher': {
	    'Text':
	     """Creo que est ms duro de lo que a vos os gustara.""",
            'Answers': ['care','silly'],
            'NewDlg': None
         },
         'pardon': {
	    'Text':
	     """Mil excusas, Seor. Tengo miedo de que todo este queso haya """\
	     """empezado a afectar mi mente. """,
            'Answers': ['layoff'],
            'NewDlg': None
         },
         'toohard': {
	    'Text':
	     """ Est seguro ? Alguno lleva aqu desde que mi abuelo  """\
	     """era un nio. """,
            'Answers': ['ifyou'],
            'NewDlg': None
        },
         'catgotit': {
	    'Text':
	     """ Por supuesto !... Yo tuve un trozo de jamn una vez, pero el gato se lo comi. """,
            'Answers': ['didntknow'],
            'NewDlg': None
        },
         'notsince': {
	    'Text':
	     """Hmmmm... ahora que lo menciona, no lo he vuelto a ver desde el incidente del jamn. """,
            'Answers': ['digress','should'],
            'NewDlg': None
        },
         'ican': {
	    'Text':
	     """I can speak Spanish! """,
            'Answers': ['thatsenough'],
            'NewDlg': None
        },
         'true': {
	    'Text':
	     """ Vaya !...creo que est en lo cierto. El comercio de queso no es lo que era. """\
	     """Pero yo tengo unas excelentes armas. Hay algunas de """\
	     """la mejor calidad.""",
            'Answers': ['nowyourtalking','fortrolls'],
            'NewDlg': None
        },
         'feelfree': {
	    'Text':
	     """Por supuesto. No son armas ordinarias. """\
	     """Fueron forjadas por maestros artesanos de mi patria. """\
	     """ No tienen igual en este mundo ! """,
            'Answers': [],
            'NewDlg': None
        },
         'cold': {
	    'Text':
	     """ Excseme !.... Tengo un poco de frio. """,
            'Answers': ['jokes'],
            'NewDlg': None
        },
         'tooold': {
	    'Text':
	     """ Esto es terrible ! Creo que debera recompensar tus esfuerzos. Mire """\
	     """debajo de mi libro. Hay una llave que abre un tunel secreto por el que puede volver a la """\
	     """Guarnicin. Es bastante seguro. Puede quedarse con cualquier cosa que encuentre en su interior. """\
	     """ Estoy demasiado viejo para tantas emociones ! Debo regresar y comprobar como est el queso. """,
	    'Answers': [],
	    'CallBack':'GoCheese', 
	    'Journal': 'ent8',
            'HideDelay':25, 
            'NewDlg': None
        },
         'howseric': {
	    'Text':
	     """ Estas bien %PlayerName ?...   cmo est Eric ? """,
            'Answers': ['iamok'],
            'NewDlg': None
        },
         'alaspooreric': {
	    'Text':
	     """ Ay !...  pobre Eric !... fue tan valiente...... """\
	     """ Me estoy haciendo viejo para tantas emociones ! Debo regresar y comprobar como est el queso. """,
	    'CallBack':'GoCheese', 
            'Answers': [],
            'NewDlg': None
        },
         'helloagain': {
	    'Text':
	     """Hola de nuevo...  cmo has enctrado ? Eric est vigilando la nica entrada.""",
	    'CallBack':'LookAtMeWhenImTalkingToYou', 
            'Answers': ['secretdoor'],
            'NewDlg': None
        },
         'helloagain2': {
	    'Text':
	     """Hola de nuevo...  cmo has enctrado ? .""",
	    'CallBack':'LookAtMeWhenImTalkingToYou', 
            'Answers': ['secretdoor2'],
            'NewDlg': None
        },
         'helloagain3': {
	    'Text':
	     """Hola de nuevo...  vienes a por ms armas ?""",
	    'CallBack':'LookAtMeWhenImTalkingToYou', 
            'Answers': ['backuppath3'],
            'NewDlg': None
        },
         'helloagain4': {
	    'Text':
	     """Hola de nuevo...  otra vez con problemas ? """,
	    'CallBack':'LookAtMeWhenImTalkingToYou', 
            'Answers': ['backuppath4'],
            'NewDlg': None
        },
         'wellillbe': {
	    'Text':
	     """ Maldita sea !... A menudo me he preguntado que sera esa trampilla...""",
            'Answers': ['aslong','notherlook'],
            'NewDlg': None
        },
         'protect': {
	    'Text':
	     """Os deseo lo mejor amigo.  Qu los Dioses os protejan en vuestro viaje ! """\
	     """Tengo algunas provisiones en el interior.  Hazte un favor... ! """,
            'Answers': [],
            'NewDlg': None
        },
         'goahead': {
	    'Text':
	     """Por favor, coge lo que necesites. Eric y yo nos iremos pronto. """\
	     """Algn dinero extra nos vendr bien para el viaje. """,
            'Answers': [],
            'NewDlg': None
        },
         'moveon': {
	    'Text':
	     """He oido que hay una armada de Enanos al norte. Ir a buscarlos."""\
	     """Tal vez necesiten mis servicios como armero. """\
	     """Hay un poco de queso en el interior. Hazte un favor... """,
            'Answers': [],
            'NewDlg': None
        },
         'trollwp': {
	    'Text':
	     """ Oh, claro !... Son bestias peligrosas. Intenta con %Trlwp."""\
	     """Es un arma ligera pero que podr con cualquier troll """\
	     """rpidamente. """,
            'Answers': ['soundsgood'],
            'NewDlg': None
        },
         'suitsyou': {
	    'Text':
	     """Bueno... un guerrero experimentado como usted podra ser capaz de manejar """\
	     """el %Wptyp. Aprovechar todas sus habilidades ofensivas. """\
	     """Es bastante caro, pero es una buena compra, se lo aseguro. """,
            'Answers': [],
            'NewDlg': None
        }
}
	    
TSDB.Ans ["Crazydwarf"]={
	'cheese': {
	    'Text':
	     """Me gustara adquirir un buen trozo de queso. """,
	    'NextDlg': 'gotnone',
	    'Enabled':1	
	},
	'ilike':{
	    'Text':
	     """ No importa, me gusta duro ! """,
	    'NextDlg': 'tougher',
	    'Enabled':1	
	},
	'care':{
	    'Text':
	     """ Cunto ms duro mejor ! """,
	    'NextDlg': 'toohard',
	    'Enabled':1
	},
	'silly':{
	    'Text':
	     """ Qu !...  hablas en serio ? """,
	    'NextDlg': 'pardon',
	    'Enabled':1
	},
	'didntknow':{
	    'Text':
	     """ No saba que usted tuvo un gato ! """,
	    'NextDlg': 'notsince',
	    'Enabled':1
	},
	'layoff':{
	    'Text':
	     """Bueno, tal vez debera dejar de comer queso...  ha probado el jamn ? """,
	    'NextDlg': 'catgotit',
	    'Enabled':1
	},
	'thatsenough':{
	    'Text':
	     """Vale,  es suficiente !  Esta conversacin es cada vez ms terrible ! """\
	     """Recuperemos la lucidez. Digame,  qu armas me recomienda ? """,
	    'NextDlg': 'suitsyou',
	    'Enabled':1
	},
	'digress':{
	    'Text':
	     """Me parece que estamos desvariando un poco. Mejor vayamos a los negocios. """\
	     """ Qu armas me recomienda ? """,
	    'NextDlg': 'suitsyou',
	    'Enabled':1
	},
	'should':{
	    'Text':
	     """ Usted comprende que toda esta basura tendr que ser traducida """\
	     """al castellano...! """,
	    'NextDlg': 'ican',
	    'Enabled':1
	},
	'ifyou':{
	    'Text':
	     """Hmm.... espero no molestarle, pero creo que no es forma de llevar una tienda """\
	     """de quesos""",
	    'NextDlg': 'true',
	    'Enabled':1	
	},
	'nowyourtalking':{
	    'Text':
	     """ De acuerdo !... olvidemos el queso. Veamos si algo de vuestra armera """\
	     """es de mi agrado.""",
	    'NextDlg': 'feelfree',
	    'Enabled':1
	},
	'callingB':{
	    'Text':
	     """ Qu quiso usted decir con "Seora" ? ...  """\
	     """ Le parezco una mujer ? """,
	    'NextDlg': 'cold',
	    'Enabled':1	
	},
	'callingZ':{
	    'Text':
	     """ Qu quiso usted decir con "Seor" ? ... """\
	     """ Le parezco un hombre ? """,
	    'NextDlg': 'cold',
	    'Enabled':1
	},
	'jokes':{
	    'Text':
	     """Bueno va... esta conversacin est adoptando un clsico tono Pythoniano. """\
	     """Permtame regresar al tema del Queso.""",
	    'NextDlg': 'gotnone',
	    'Enabled':1	
	},
	'iamok':{
	    'Text':
	     """Estoy herido aunque me recuperar, pero me temo """\
	     """que Eric no ha sobrevivido a la escaramuza...""",
	    'NextDlg': 'alaspooreric',
	    'Enabled':1	
	},
	'secretdoor':{
	    'Text':
	     """ Descubr una puerta secreta !... Conduce hasta la trampilla trasera de la """\
	     """tienda.""",
	    'NextDlg': 'wellillbe',
	    'Enabled':1	
	},
	'secretdoor2':{
	    'Text':
	     """ Descubr una puerta secreta !... Conduce hasta la trampilla trasera de la  """\
	     """tienda.  Qu har ahora que Eric no est aqu para ayudarle ? """,
	    'NextDlg': 'moveon',
	    'Enabled':1	
	},
	'backuppath3':{
	    'Text':
	     """ Si, por supuesto !  Pero que vais ha hacer t y Eric ?  """,
	    'NextDlg': 'goahead',
	    'Enabled':1	
	},
	'backuppath4':{
	    'Text':
	     """ Nada que no pueda manejar !  Pero que har ahora que no est Eric para proteger el lugar ?  """,
	    'NextDlg': 'moveon',
	    'Enabled':1	
	},
	'notherlook':{
	    'Text':
	     """Bueno, me alegro de haber encontrado una forma de regresar. Necesitara alguna cosa ms...  """,
	    'NextDlg': 'goahead',
	    'Enabled':1	
	},
	'aslong':{
	    'Text':
	     """Si,  probablemente ha estado cerrada durante siglos !... en cualquier caso, si los dos estis bien  """\
	     """regresar por el mismo camino. Tengo que intentar llegar a la Gran Puerta del oeste.""",
	    'NextDlg': 'protect',
	    'Enabled':1
	},
	'fortrolls':{
	    'Text':
	     """Donde hay orcos suele haber trolls.  Tiene algo realmente efectivo """\
	     """contra ellos ? """,
	    'NextDlg': 'trollwp',
	    'Enabled':1	
	},
	'soundsgood':{
	    'Text':
	     """ Suena bien !  Alguna otra arma que me recomiende ?  """,
	    'NextDlg': 'suitsyou',
	    'Enabled':1																																											
	}
}    

###########################################################################
################   Eric   #################################################
###########################################################################
TSDB.Dlg ["Eric"]={
	'Iameric': {
	    'Text':
	     """Bienvenido extranjero,  qu te trae a este lugar ? """,
            'Answers': ['search'],
            'CallBack':'LookAtMeWhenImTalkingToYou', 
            'NewDlg': None
        },
        'blocked': {
	    'Text':
	     """Hay una pista que lleva al este a travs de las montaas """\
	     """pero hace aos que est bloqueada por un desprendimiento. """\
	     """Por qu no entras y hablas con mi padre. l puede ayudarte. """\
	     """Por cierto, me llaman Eric. """,
            'Answers': ['willdo','dontlike','ifyou'],
            'NewDlg': None
        },
        'interesting': {
	    'Text':
	     """Bueno, hay algunas buenas armas a la venta, pero el queso es insufrible. """,
            'Answers': [],
            'NewDlg': None
        },
        'yourwelcome': {
	    'Text':
	     """Eres bienvenido. """,
            'Answers': [],
            'NewDlg': None
        },
         'welldone': {
	    'Text':
	     """Bien hecho %PlayerName ... No hubiese podido con todos """\
	     """slo. """,
	    'CallBack':'EricBackToDoor', 
            'Answers': ['mypleasure'],
            'NewDlg': None
        },
         'where': {
	    'Text':
	     """ Gracias de nuevo !... Me pregunto si Crazydwarf estar bien... """,
            'Answers': [],
            'NewDlg': None
        },
        'found': {
	    'Text':
	     """Ahh....ya veo lo que quieres decir... Crazydwarf, lo dices por su nombre (EnanoLoco). """\
	     """Me rescat de entre los orcos cuando era un chiquillo. Me ha criado como su hijo """\
	     """y yo le ayudo con la tienda para que no tenga problemas.""",
            'Answers': ['useful'],
            'NewDlg': None
        },
        'bolder': {
	    'Text':
	     """ Seguro !... cada da son ms atrevidos. Es slo cuestin de tiempo """\
	     """que nos hagan una visita. Supongo que pronto intentarn """\
	     """un ataque sorpresa.""",
            'Answers': ['shout'],
            'NewDlg': None   
        },
        'cometo': {
	    'Text':
	     """Gracias %PlayerName... lo tendr en cuenta. """,
            'Answers': [],
            'NewDlg': None   
        },
        'allquiet2': {
	    'Text':
	     """ Hola de nuevo !...  Va todo bien ? """,
            'Answers': ['another'],
            'NewDlg': None 
        },
        'watch': {
	    'Text':
	     """Todo parece tranquilo, pero estar atento de todas formas... """,
            'Answers': [''],
            'NewDlg': None
        },
        'allquiet1': {
	    'Text':
	     """ %Playername ! ... eres t. Pensaba que sera otro ataque. """,
            'Answers': ['dontworry'],
            'NewDlg': None 
        },
        'thatswhat': {
	    'Text':
	     """ Eso son grandes noticias ! """,
            'Answers': [''],
            'NewDlg': None                                                                                                                                                                   
        }
}
	    
TSDB.Ans ["Eric"]={
	'search': {
	    'Text':
	     """ Saludos ! Mi nombre es %PlayerName. """\
	     """Estoy buscando un camino para salir de aqu. """\
	     """Dime,  adnde conduce este camino ? """,
	    'NextDlg': 'blocked',
	    'Enabled':1	
	},
	'willdo':{
	    'Text':
	     """Gracias Eric. Lo har.""",
	    'NextDlg': 'yourwelcome',
	    'Enabled':1	
	},
	'dontlike':{
	    'Text':
	     """Ests seguro. No me gusta este lugar. """,
	    'NextDlg': 'interesting',
	    'Enabled':1
	},
	'mypleasure':{
	    'Text':
	     """ Ha sido un placer ! """\
	     """No necesito mucha motivacin para descabezar orcos.""",
	    'NextDlg': 'where',
	    'Enabled':1	
	},
	'ifyou':{
	    'Text':
	     """Hmmm... Espero no molestarte,  pero no eres un poco grande para ser hijo de """\
	     """un Enano ? """,
	    'NextDlg': 'found',
	    'Enabled':1
	},
	'useful':{
	    'Text':
	     """Si, pareces bastante bueno como guerrero. Pero tarde o temprano los orcos encontrarn """\
	     """este solitario camino y atacarn... """,
	    'NextDlg': 'bolder',
	    'Enabled':1
	},
	'shout':{
	    'Text':
	     """Si, me he encontrado algunos por el camino, pero no os darn problemas. """\
	     """Mirar dentro ahora. Grita si necesitas ayuda. """,
	    'NextDlg': 'cometo',
	    'Enabled':1	
	},
	'another':{
	    'Text':
	     """He encontrado una trampilla secreta que conduce a la parte trasera de la tienda. """\
	     """Ten cuidado. Hay orcos todava por all... """,
	    'NextDlg': 'watch',
	    'Enabled':1	
	},
	'dontworry':{
	    'Text':
	     """No te preocupes amigo.  Hay menos orcos alrededor desde la ltima vez que """\
	     """nos vimos ! """,
	    'NextDlg': 'thatswhat',
	    'Enabled':1											
	}
}    	    	   

###########################################################################
#####################  The Dying Knight  ##################################
###########################################################################

TSDB.Dlg ["DyingKnight"]={
	'listen': {
	    'Text':
	     """ Arrgh !  ven y acaba conmigo ! """\
	     """No os dir nada...  bestias asquerosas ! """,
            'Answers': ['fearnot'],
            'NewDlg': None
        },
        'whatof': {
	    'Text':
	     """Escucha cuidadosamente... Me temo que no me queda mucho tiempo en este mundo. """\
	     """ Qu fue de mis hombres ?  Han sobrevivido al ataque ?""",
            'Answers': ['no'],
            'NewDlg': None
        },
        'truth': {
	    'Text':
	     """ Ah !... cunta verdad hay en tus palabras... La nica salida es a travs de """\
	     """la cmara de torturas. Hay otro prisionero all, """\
	     """un aventurero como vos. Si actuais con rapidez tal vez puedas salvar """\
	     """a ese pobre desgraciado.""",
            'Answers': ['willdo'],
            'NewDlg': None
        },
        'doomed': {
	    'Text':
	     """Me temo que no. Mi debilidad crece por momentos. Pero busca a Lord Kerman, el """\
	     """Seor de Tel Halaf. Estaba en la Gran Biblioteca cuando los orcos nos atacaron. """,
	    'Answers': ['besure'],
            'NewDlg': None
        },
         'thanks': {
	    'Text':
	     """Gracias... y acaba con todos los orcos que se crucen en tu camino. Al menos mis compaeros """\
	     """caidos sern vengados... """,
	    'CallBack':'KnightExpired1', 
            'Answers': [],
            'NewDlg': None                     
        }
}
	    
TSDB.Ans ["DyingKnight"]={
	'fearnot': {
	    'Text':
	     """No temais amigo. Soy slo un viajero que cay preso de los orcos """\
	     """que han invadido el lugar. He escapado de la celda y busco la salida. """,
	    'NextDlg': 'whatof',
	    'Enabled':1	
	},
	'no':{
	    'Text':
	     """No tengo muchas esperanzas. Los orcos no hacen prisioneros a menos que """\
	     """puedan usarlos para algo """, 
	    'NextDlg': 'truth',
	    'Enabled':1	
	},
	'willdo':{
	    'Text':
	     """No digais ms, lo intentar. Pero  hay algo que pueda hacer por vos ? """,
	    'NextDlg': 'doomed',
	    'Enabled':1
	},
	'besure':{
	    'Text':
	     """Descansa seguro. Har todo lo que pueda... """,
	    'NextDlg': 'thanks',
	    'Enabled':1			
	}
}    	    	   
###########################################################################
################### The Deep Chamber ######################################
###########################################################################
TSDB.Dlg ["Heardred"]={
	'speakT': {
	    'Text':
	     """Habla.... y Yo responder a tu pregunta. """,
	    'CallBack':'TextOff', 
            'Answers': ['whichgoodT','whichbadT','whatheT'],
            'NewDlg': None
        },
        'leftT': {
	    'Text':
	     """La serpiente de la izquierda conduce a la Fortuna. """,
	    'CallBack':'OnlyOneL',
	    'Answers': [],
            'NewDlg': None
        },
        'rightT': {
	    'Text':
	     """La serpiente de la derecha conduce a la Muerte """,
	    'CallBack':'OnlyOneL',
            'Answers': [],
            'NewDlg': None
        },
        'hesayT': {
	    'Text':
	     """El debera decir... la serpiente de la derecha. """,
	    'CallBack':'OnlyOneL',
            'Answers': [],
            'NewDlg': None
        },    
        'speakF': {
	    'Text':
	     """Habla.... y Yo responder a tu pregunta. """,
	    'CallBack':'TextOff', 
            'Answers': ['whichgoodF','whichbadF','whatheF'],
            'NewDlg': None
        },
        'leftF': {
	    'Text':
	     """La serpiente de la izquierda conduce a la Fortuna. """,
	    'CallBack':'OnlyOneL',
	    'Answers': [],
            'NewDlg': None
        },
        'rightF': {
	    'Text':
	     """La serpiente de la derecha conduce a la Muerte. """,
	    'CallBack':'OnlyOneL',
            'Answers': [],
            'NewDlg': None
        },
        'hesayF': {
	    'Text':
	     """l debera decir... la serpiente de la izquierda. """,
	    'CallBack':'OnlyOneL',
            'Answers': [],
            'NewDlg': None
        },
        'onlyoneL': {
	    'Text':
	     """T slo puedes hacer una pregunta. """,
            'Answers': [],
            'NewDlg': None              
        }
}
	    
TSDB.Ans ["Heardred"]={
	'whichgoodT': {
	    'Text':
	     """ Qu serpiente conduce a la Fortuna ? """,
	    'DisableAns': ['whichbadT', 'whatheT'],
	    'NextDlg': 'leftT',
	    'Enabled':1	
	},
	'whichbadT':{
	    'Text':
	     """ Qu serpiente conduce a la Muerte ? """,
	    'DisableAns': ['whichgoodT', 'whatheT'],
	    'NextDlg': 'rightT',
	    'Enabled':1	
	},
	'whatheT':{
	    'Text':
	     """ Qu serpiente dir el otro Guardin que es segura ? """,
	    'DisableAns': ['whichbadT', 'whichgoodT'],
	    'NextDlg': 'hesayT',
	    'Enabled':1
	},
	'whichgoodF': {
	    'Text':
	     """ Qu serpiente conduce a la Fortuna ? """,
	    'DisableAns': ['whichbadF', 'whatheF'],
	    'NextDlg': 'leftF',
	    'Enabled':1	
	},
	'whichbadF':{
	    'Text':
	     """ Qu serpiente conduce a la Muerte ? """,
	    'DisableAns': ['whichgoodF', 'whatheF'],
	    'NextDlg': 'rightF',
	    'Enabled':1	
	},
	'whatheF':{
	    'Text':
	     """ Qu serpiente dir el otro Guardin que es segura ?  """,
	    'DisableAns': ['whichgoodF', 'whichbadF'],
	    'NextDlg': 'hesayF',
	    'Enabled':1
	}
}    	    	    

TSDB.Dlg ["Hygelac"]={
	'speakT': {
	    'Text':
	     """Habla.... y Yo responder a tu pregunta. """,
	    'CallBack':'TextOff',
            'Answers': ['whichgoodT','whichbadT','whatheT'],
            'NewDlg': None
        },
        'leftT': {
	    'Text':
	     """La serpiente de la derecha conduce a la Fortuna. """,
	    'CallBack':'OnlyOneA',
	    'Answers': [],
            'NewDlg': None
        },
        'rightT': {
	    'Text':
	     """La serpiente de la izquierda conduce a la Muerte. """,
	    'CallBack':'OnlyOneA',
            'Answers': [],
            'NewDlg': None
        },
        'hesayT': {
	    'Text':
	     """El debera decir... la serpiente de la izquierda. """,
	    'CallBack':'OnlyOneA',
            'Answers': [],
            'NewDlg': None
        },
        'speakF': {
	    'Text':
	     """Habla.... y Yo responder a tu pregunta. """,
	    'CallBack':'TextOff', 
            'Answers': ['whichgoodF','whichbadF','whatheF'],
            'NewDlg': None
        },
        'leftF': {
	    'Text':
	     """La serpiente de la derecha conduce a la Fortuna. """,
	    'CallBack':'OnlyOneA',
	    'Answers': [],
            'NewDlg': None
        },
        'rightF': {
	    'Text':
	     """La serpiente de la izquierda conduce a la Muerte. """,
	    'CallBack':'OnlyOneA',	     
            'Answers': [],
            'NewDlg': None
        },
        'hesayF': {
	    'Text':
	     """El debera decir... la serpiente de la derecha. """,
	    'CallBack':'OnlyOneA',
            'Answers': [],
            'NewDlg': None
         },
         'onlyoneA': {
	    'Text':
	     """T slo puedes hacer una pregunta. """,
            'Answers': [],
            'NewDlg': None                                           
        }
}
	    
TSDB.Ans ["Hygelac"]={
	'whichgoodT': {
	    'Text':
	     """ Qu serpiente conduce a la Fortuna ? """,
	    'DisableAns': ['whichgoodT', 'whatheT'],
	    'NextDlg': 'leftT',
	    'Enabled':1	
	},
	'whichbadT':{
	    'Text':
	     """ Qu serpiente conduce a la Muerte?  """,
	    'DisableAns': ['whatheT', 'whichbadT'],
	    'NextDlg': 'rightT',
	    'Enabled':1	
	},
	'whatheT':{
	    'Text':
	     """ Qu serpiente dir el otro Guardin que es segura ?  """,
	     'DisableAns': ['whichgoodT', 'whichbadT'],
	    'NextDlg': 'hesayT',
	    'Enabled':1
	},
	'whichgoodF': {
	    'Text':
	     """ Qu serpiente conduce a la Fortuna ? """,
	    'DisableAns': ['whatheF', 'whichbadF'],
	    'NextDlg': 'leftF',
	    'Enabled':1	
	},
	'whichbadF':{
	    'Text':
	     """ Qu serpiente conduce a la Muerte ? """,
	    'DisableAns': ['whichgoodF', 'whatheF'],
	    'NextDlg': 'rightF',
	    'Enabled':1	
	},
	'whatheF':{
	    'Text':
	     """ Qu serpiente dir el otro Guardin que es segura ?  """,
	    'DisableAns': ['whichgoodF', 'whichbadF'],
	    'NextDlg': 'hesayF',
	    'Enabled':1
	}
}    	    	    
#####################################################################################
########################### Herbert #################################################
#####################################################################################

TSDB.Dlg ["Herbert"]={
	'close': {
	    'Text':
	     """ Te encuentras bien ?... Ese orco era uno de los """\
	     """ms dbiles, pero no s de dnde ha sacado la espada. """,
	    'CallBack':'LookAtMeWhenImTalkingToYou', 
            'Answers': ['nearthing'],
            'NewDlg': None
        },
        'haveyou': {
	    'Text':
	     """Si,  por qu ?...  Lo has visto ?  Este no es un lugar """\
	     """para explorar en solitario. Los """\
	     """orcos tienen algunas bestias enjauladas. Ellos """\
	     """las usan para los trabajos ms duros. Estamos intentando abrir la Gran Puerta """\
	     """que hay ms all""",
	     'CallBack':'Goforawalk', 
	    'Answers': [],
            'NewDlg': None
        },
        'creatures3': {
	    'Text':
	     """ Oh No !  Glofror ha muerto ! Me temo que debo regresar para informar al Consejo de los Enanos. """\
	     """ Nos quieres acompaar ? """,
	     'CallBack':'ReGroup', 
	    'Answers': ['goeast'],
            'NewDlg': None
        },
        'asuwish': {
	    'Text':
	     """Como desees.  Buena suerte en tu viaje ! """,
	    'Answers': [],
            'NewDlg': None
        }
}
	    
TSDB.Ans ["Herbert"]={
	'nearthing': {
	    'Text':
	     """ Si ! Ha sido asqueroso... """\
	     """Afortunadamente t estabas aqu.  Eres """\
	     """compaero de Glofror ?""",
	    'NextDlg': 'haveyou',
	    'Enabled':1	
	},
	'goeast':{
	    'Text':
	     """No me es posible. Debo continuar mi viaje hacia las montaas del oeste. """\
	     """Slo all encontrar a Vinculanus. """,
	    'NextDlg': 'asuwish',
	    'Enabled':1	
	}
}    	    	    
###########################################################################
################## Guard Commander ########################################
###########################################################################
TSDB.Dlg ["GuardCommander"]={
	'hold': {
	    'Text':
	     """ Por los Fuegos de Xshathra ! Es %PlayerName el %Type. """\
	     """Tu nombre es una leyenda entre nuestras tropas. """,
	     'CallBack':'LookAtMeWhenImTalkingToYou', 
            'Answers': ['noneother'],
            'NewDlg': None
        },
        'twoleft': {
	    'Text':
	     """Hemos estado atrapados en este lugar desde que nos atacaron los orcos. Slo """\
	     """nosotros tres logramos sobrevivir y nuestras fuerzas estn desapareciendo rpidamente. """\
	     """Otro ataque y seguramente no lo contaremos. Entra. Eres bienvenido """\
	     """a compartir lo poco que nos queda.""",
            'Answers': [],
            'HideDelay':25, 
            'NewDlg': None
        },
        'lookout': {
	    'Text':
	     """Pero dime, %Playername,  has """\
	     """visto a Lord Kerman ? Creo que estaba en la Biblioteca cuando los orcos se nos echaron encima. """,
            'Answers': ['nonotseen','yeshaveseen'],
            'NewDlg': None
        },
        'gratitude': {
	    'Text':
	     """Tal vez haya podido escapar.  Quin sabe ? Te estara agradecido si  """\
	     """intentaras encontrarlo. """,
	    'Answers': [],
            'NewDlg': None
        },
         'bethanked': {
	    'Text':
	     """ Qu los Dioses nos ayuden !... son buenas noticias al menos. """\
	     """Pero no te demores en este maldito lugar, busca una buena forma de escapar. """,
            'Answers': [],
            'NewDlg': None                     
        }
}
	    
TSDB.Ans ["GuardCommander"]={
	'noneother': {
	    'Text':
	     """Si Capitan. No hay nadie ms... pero sus hombres se encuentran en un estado preocupante. """,
	    'NextDlg': 'twoleft',
	    'Enabled':1	
	},
	'nonotseen':{
	    'Text':
	     """No Capitan, No hay rastro de l. Intentar encontrarlo. """,
	    'NextDlg': 'gratitude',
	    'Enabled':1
	},
	'yeshaveseen':{
	    'Text':
	     """Si Capitan, estaba vivo la ltima vez que habl con l, pero muchos de sus hombres """\
	     """estaban malheridos.""",
	    'NextDlg': 'bethanked',
	    'Enabled':1							
	}
}    	    	   
###########################################################################
## Journal
###########################################################################

TSDB.JrlTxt = {
	'MetGlofror':
	    """Me he encontrado con mi viejo amigo Glofror. l y una banda de Enanos """\
	    """que le siguen han entrado en la fortaleza por un camino secreto.""",
	'TheStone':
	    """Me he encontrado con mi viejo amigo Glofror. l y una banda de Enanos """\
	    """que le siguen han entrado en la fortaleza por un camino secreto."""
	    """Ha mencionado el Ojo de Caradhras. """\
	    """Creo que es un cuento de viajeros, pero sus palabras me han hecho pensar. """\
	    """Debo mantener mis ojos abiertos por si doy con alguna pista...""",
	'TrsScore':
	    """Tesoro Total.... %Total. """,
	'foundmap':
	    """He encontrado un antiguo pergamino. Habla de una tumba que se supone fue construida """\
	    """en las profundidades de la fortaleza. Menciona un preciado tesoro oculto en ella. Sospecho """\
	    """que es lo que los orcos andan buscando.                               """\
	    """El camino hacia abajo parece traicionero, pero tengo pocas opciones: debo intentar bajar. """,
	'ent1':
	    """La Guarnicin ha sido invadida por una banda de orcos. Eran demasiados """\
	    """y por eso me encuentro ahora en esta celda. Debo escapar antes de que ellos informen de """\
	    """mi captura a la Guardia Negra. Pienso que hay un carcelero ah fuera. """\
	    """Puede que tenga la llave. Si consiguiera atraer su atencin...""",
	'ent2m':
	    """He encontrado a mi viejo amigo %Buddy, aunque l est muy dbil an """\
	    """por las torturas de los orcos. Debo encontrar una salida y luego volver """\
	    """para ver cmo se encuentra. Todos los caballeros amigos parece que han sido """\
	    """masacrados.""",
	'ent2f':
	    """He encontrado a mi viejo amigo %Buddy, aunque ella est muy dbil an """\
	    """por las torturas de los orcos. Debo encontrar una salida y luego volver """\
	    """para ver cmo se encuentra. Todos los caballeros amigos parece que han sido """\
	    """masacrados.""",
	'ent3':
	    """He encontrado un orco herido. El muy cobarde me di informacin sobre una ruta de escape """\
	    """a cambio de su vida, pero no me fio de l... """,
	'ent4':
	    """El orco herido tena un arma escondida y me atac cuando le d la """\
	    """espalda.  No lo volver a hacer ! """,
	'ent5':
	    """ La ruta de escape era una trampa ! La Guardia Negra estaba esperndome. Su lider, Vinculanus, """\
	    """estaba con ellos,  aunque se retir a una cueva en el lateral del desfiladero cuando comenz la """\
	    """accin ! He acabado con cuatro de sus soldados de tropa y tres de sus lugartenientes. Es importante """\
	    """perseguir a Vinculanus, pero me temo que puede ser otra trampa. """,
	'ent6':
	    """ He sorprendido a un Guardia extraviado con una caja llena de tesoros ! Habia un orco con l. """\
	    """No s qu estaban tramando. Tal vez los tesoros fuesen una especie de pago..."""\
	    """ Quizs el dinero de un rescate ? Hay otro Guardia fuera de Falcon Gate. No me ha visto. """\
	    """Si puedo tumbarlo con un flecha no tendr oportunidad de escapar y cerrar la puerta. """,
	'ent7':
	    """Me he encontrado con dos interesantes personajes en una pequea tienda. El lugar estaba lleno de """\
	    """armas y tamben haba montones de queso aejo. Quizs cambie algunos de los tesoros por nuevas """\
	    """armas. Tendr que encontrar un camino de vuelta y la nica salida est bloqueada. """, 
	'ent8':
	    """ Una banda de orcos hizo una incursin atacando la tienda que yo estaba mirando ! Todos estn """\
	    """muertos ahora. Crazydwarf fue muy amable conmigo por la ayuda y me habl de un tunel secreto que """\
	    """conduce de vuelta a la Guarnicin. Me pareci ver una puerta en las rocas de la derecha cuando pas  """\
	    """junto a ellas... """,
	'ent9':
	    """He encontrado el camino hacia la Guarnicin.  Este lugar est lleno de orcos ! Uno de ellos tena una  """\
	    """llave de bronce. Debe ser de la gran puerta que hay al final del pasadizo inferior. """\
	    """Pero, tal vez pueda echar otra ojeada alrededor antes de intentar abrirla. """,
	'ent10':
	    """Al final del Gran Hall hay una arcada protegida por saeteros que disparan rayos verdes.  """\
	    """No me atrevo a pasar. Si antes puedo volcar la estatua tal ves los rayos desaparezcan...""",
	'ent11m':
	    """He vuelto a las mazmorras para buscar a %Buddy, pero slo queda una nota. Dice que ha encontrado un """\
	    """paso secreto por el que ha escapado. Quizs nos encontremos otro da........ """,
	'ent11f':
	    """He vuelto a las mazmorras para buscar a %Buddy, pero slo queda una nota. Dice que ha encontrado un """\
	    """paso secreto por el que ha escapado. Quizs nos encontremos otro da........ """,
	'ent12':
	    """La Tumba est protegida por una antigua maldicin. Tendr que usar todo mi ingenio para salir de """\
	    """esta cmara. Presiento que un gran peligro se avecina... """,
	'ent13':
	    """He alcanzado la Puerta Principal, slo para comprobar que est bloqueada por una gran cerradura y dos """\
	    """piedras. Las palancas que liberan la puerta pueden estar en las dos torres que la rodean. """\
	    """Necesito encontrar la forma de llegar hasta esos pasos. An hay orcos all. Tal vez alguno """\
	    """tenga la llave...""",
	'ent14':
	    """El Gran Puente est roto, demolido por los orcos. Uno de los Trolls enloqueci y """\
	    """atac a sus maestros. La bestia est ahora muerta. Todos los caminos hacia las torres de la puerta """\
	    """estn bloqueados. Pienso que debo investigar el dao en el Puente, si puedo pasar la barricada """\
	    """que los orcos han construido...""",
	'ent15':
	    """El Puente no puede pasarse y unas rocas caidas han bloqueado mi camino de vuelta. He descubierto una frgil """\
	    """pasarela que conduce hacia el acantilado. Puedo intentar seguirla porque es el nico camino """\
	    """que veo.  Dnde se habrn metido los orcos ?. """,
	'ent16':
	    """ Acabo de matar al mayor Troll que jams he visto ! Los orcos han excavado un tunel """\
	    """en el acantilado. Es demasiado extrao...  Por qu habrn hecho este tunel... ? """,
	'ent17':
	    """He encontrado una cmara en las profundidades de la tierra. Parece que no hay nada aqu excepto una """\
	    """vieja tumba. Dos Caballeros zombies la guardan probablemente desde hace siglos. """\
	    """Todo est lleno de restos de orcos. Estaran intentando revelar los misterios de este santo lugar... """\
	    """sin mucho xito...""",
	'ent18a':
	    """Con la ayuda de %Buddy la Gran Bestia est muerta. Todo lo que necesito es encontrar """\
	    """la palanca de la Puerta. Los orcos se llevaron la palanca. Pero seguramente haya una """\
	    """de repuesto escondida en algn lugar.""",
	'ent18b':
	    """La Gran Bestia ha muerto! Pero %Buddy no sobrevivi al combate... """\
	    """He de apresurarme ha abandonar este maldito lugar. Los orcos se llevaron la palanca. """\
	    """Pero seguramente haya una de repuesto escondida en alguna parte.""",
	'ent18c':
	    """La Gran Bestia ha muerto! Lord Kerman me ha ayudado. """\
	    """He de apresurarme ha abandonar este maldito lugar. Los orcos se llevaron la palanca. """\
	    """Pero seguramente haya una de repuesto escondida en alguna parte.""",
	'ent19':
	    """Se premiar con Novecientas Piezas de Oro a cualquiera que entregue al %Type %PlayerName """\
	    """a la Guardia Negra. """,	
	'ent20':
	    """ Parece que hay Trolls perdidos por todas partes ! He tenido suerte de que me hayan ayudado """\
	    """los Enanos. Sin embargo, no puedo esperar mucha ms ayuda de ellos. Me despedir de ellos """\
	    """y continuar slo mi camino. """,
	'ent21':
	    """He abierto la Tumba y he liberado un espritu que fu encerrado en ella. El Ojo de """\
	    """Caradhras es mio y la Espada de Ianna tambin. No quiero seguir en este lugar, """\
	    """aunque supongo que nuevos peligros me esperan en la superficie. """,	
	'ent22':
	    """He alcanzado a Lord Kerman en la Biblioteca. Fuimos atacados por asesinos de la Guardia Negra, """\
	    """pero todos han muerto ya. Tengo la llave de la Puerta Principal. Es hora de escapar... """,			    	    	    	    	    	    	    	    
        }
