import Bladex
import EnemyTypes
import Enm_Def
import Reference
import AniSound
import Sounds
import Combat
import copy
import Actions
import GameStateAux
import Language
import AuxTran

import BCopy
import math
import whrandom

import Interpolator
import CharStats
import ItemTypes
import AuxFuncs
import Sparks
import Objects
import InitDataField
import Blood
import dust
import B3DLib
import Damage
import darfuncs
import GenFX

import Ally_Def

import ObjStore

########################################################################################################################

TRUE = 1
FALSE = 0


#########################################################################################################################
class BurningKnight (EnemyTypes.Knight_Traitor):
	def __init__(self, me):
		Enm_Def.NPCPerson.__init__(self, me)
		EnemyTypes.Knight_Traitor.__init__(self,me)
		AniSound.AsignarSonidosCaballeroTraidor(me.Name)
		me.Blind=1
		me.Deaf=1
		
		me.ImDeadFunc=self.ImDeadFuncFried
		
	def SetMyAssAlight(self,EntityName):
		Bladex.AddCombustionDataFor("Knight_Traitor", "Fire", 250, 400, 4, 0.5, 1, 50)
		me = Bladex.GetEntity(EntityName)
		me.CatchOnFire(0,0,0)
		print("why am I not on fire")
	
		
	def ImDeadFuncFried (self,EntityName):
		Enm_Def.NPCPerson.StdImDead(self,EntityName)
		me = Bladex.GetEntity(EntityName)
		me.Wuea=Reference.WUEA_ENDED
		me.LaunchAnmType("dth0")
		
	def StartRunning (self,EntityName):
		me = Bladex.GetEntity(EntityName)		
		me.LaunchAnimation ("Tkn_burn")
		me.AnmEndedFunc=self.StartFalling

	def StartFalling (self,EntityName):
		me = Bladex.GetEntity(EntityName)
		me.SetTmpAnmFlags(1,1,1,0,1,1) 
		me.LaunchAnimation ("Tkn_dth_burn")		
	
		
##########################################################################################################################

class AmuletoInvincibility (ItemTypes.ItemOfProtection):
        def __init__ (self, me):
                ItemTypes.ItemOfProtection.__init__(self, me)
                self.UsedBy= "Player1"
                self.UseTime= 60.0
                self.Resistances= {}
                self.nUses= 2

        def UseStart (self, ObjectName, use_from):
                ItemTypes.ItemOfProtection.UseStart (self, ObjectName, use_from)
                pj=Bladex.GetEntity('Player1')
                pj.Data.Invincibility= 1
                GenFX.AddPersonItemFX(self.UsedBy, ObjectName, self.UseTime)
		    


        def UseEnd (self,ObjectName, UserName):
                pj=Bladex.GetEntity('Player1')
                pj.Data.Invincibility= 0
                ItemTypes.ItemOfProtection.UseEnd (self, ObjectName, UserName)
			
			
###############################################################################################################
class VictimAmz(Enm_Def.StupidNPCPerson):

	DurmiendoA=0
	MurmurandoA=0
	MolestadoA=0
	MuertoA=0
	ronquidosa=None
	habladormidoa=None
	molestiaa=None
	muertea=None

	def __init__(self, person):
		Enm_Def.StupidNPCPerson.__init__(self, person)
		self.DurmiendoA=0
		self.MurmurandoA=0
		self.MolestadoA=0
		self.MuertoA=0
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep2")
		person.SetOnFloor()

		self.ronquidosa=Bladex.CreateSound("..\\..\\Sounds\\rat-squeak.wav", "RonquidosA")
		self.ronquidosa.Volume=1
		self.ronquidosa.Scale=1.0
		self.ronquidosa.MinDistance= 5000
		self.ronquidosa.MaxDistance=15000

		self.habladormidoa=Bladex.CreateSound("..\\..\\Sounds\\rat-squeak.wav", "HablaDormidoA")
		self.habladormidoa.Volume=1
		self.habladormidoa.Scale=1.0
		self.habladormidoa.MinDistance= 5000
		self.habladormidoa.MaxDistance=50000

		self.molestiaa=Bladex.CreateSound("..\\..\\Sounds\\herida-amz2.wav", "MolestiaA")
		self.molestiaa.Volume=1
		self.molestiaa.Scale=1.0
		self.molestiaa.MinDistance= 5000
		self.molestiaa.MaxDistance=25000

		self.muertea=Bladex.CreateSound("..\\..\\Sounds\\Muerte-Amz3.wav", "MuerteA")
		self.muertea.Volume=1
		self.muertea.Scale=1.0
		self.muertea.MinDistance= 5000
		self.muertea.MaxDistance=15000

	def MurmuraA(self, entity_name):
#		print "Murmura..."
		self.MurmurandoA=1
		if self.DurmiendoA:
			self.DurmiendoA=0
			self.ronquidosa.Stop()
		if self.MolestadoA:
			self.MolestadoA=0
			self.molestiaa.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep")
		person.SetOnFloor()
		#self.habladormidoa.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		person.AnmEndedFunc=self.DuermeA

	def DuermeA(self, entity_name):
#		print "Duerme..."
		if self.MuertoA:
			return
		self.DurmiendoA=1
		if self.MurmurandoA:
			self.MurmurandoA=0
		if self.MolestadoA:
			self.MolestadoA=0
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep2")
		person.SetOnFloor()
		#self.ronquidosa.Play(person.Position[0], person.Position[1], person.Position[2], -1)

	def MolestiaA(self, entity_name):
#		print "Se molesta..."
		self.MolestadoA=1
		if self.DurmiendoA:
			self.DurmiendoA=0
			self.ronquidosa.Stop()
		if self.MurmurandoA:
			self.MurmurandoA=0
			self.habladormidoa.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep_hit")
		person.SetOnFloor()
		self.molestiaa.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		person.AnmEndedFunc=self.DuermeA

	def MuereA(self, entity_name):
		#print "Muere..."
		#Bldb.set_trace()
		if self.DurmiendoA:
			self.DurmiendoA=0
			self.ronquidosa.Stop()
		if self.MurmurandoA:
			self.MurmurandoA=0
			self.habladormidoa.Stop()
		if self.MolestadoA:
			self.MolestadoA=0
			self.molestiaa.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_dth_sleep")
		person.SetOnFloor()
		self.muertea.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		self.MuertoA=1

	# Functions for loading and saving state
	def __getstate__(self):
		#print "DrunkWarder.__getstate__"
		NPCPerson_state=Enm_Def.StupidNPCPerson.__getstate__(self)
		if(NPCPerson_state[0]!=1):
			#print "ERROR: DrunkWarder.__getstate__(): Base class version differs."
			return NPCPerson_state
		NPCPerson_state[1]["VictimAmz"]=(self.ronquidosa.Name,self.habladormidoa.Name,
										   self.molestiaa.Name,self.muertea.Name,
										   self.DurmiendoA,self.MurmurandoA,self.MolestadoA,self.MuertoA
										  )
		return NPCPerson_state
	
	def __setstate__(self,parm):
		#print "DrunkWarder.__setstate__"
		# Toma como par⮥tro lo que devuelve __getstate__() y debe recrear la clase
		Enm_Def.StupidNPCPerson.__setstate__(self,parm)
		version=parm[0]
		if version==1:
			parms=parm[1]["VictimAmz"]
			self.ronquidosa=Bladex.GetSound(parms[0])
			self.habladormidoa=Bladex.GetSound(parms[1])
			self.molestiaa=Bladex.GetSound(parms[2])
			self.muertea=Bladex.GetSound(parms[3])
			self.DurmiendoA=parms[4]
			self.MurmurandoA=parms[5]
			self.MolestadoA=parms[6]
			self.MuertoA=parms[7]
#################################################################################################################			
class VictimDwf(Enm_Def.StupidNPCPerson):

	DurmiendoD=0
	MurmurandoD=0
	MolestadoD=0
	MuertoD=0
	ronquidosd=None
	habladormidod=None
	molestiad=None
	muerted=None

	def __init__(self, person):
		Enm_Def.StupidNPCPerson.__init__(self, person)
		self.DurmiendoD=0
		self.MurmurandoD=0
		self.MolestadoD=0
		self.MuertoD=0
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep2")
		person.SetOnFloor()

		self.ronquidosd=Bladex.CreateSound("..\\..\\Sounds\\traidor-respira.wav", "RonquidosD")
		self.ronquidosd.Volume=1
		self.ronquidosd.Scale=1.0
		self.ronquidosd.MinDistance= 5000
		self.ronquidosd.MaxDistance=15000

		self.habladormidod=Bladex.CreateSound("..\\..\\Sounds\\rat-squeak.wav", "HablaDormidoD")
		self.habladormidod.Volume=1
		self.habladormidod.Scale=1.0
		self.habladormidod.MinDistance= 5000
		self.habladormidod.MaxDistance=50000

		self.molestiad=Bladex.CreateSound("..\\..\\Sounds\\herida-Dwf3.wav", "MolestiaD")
		self.molestiad.Volume=1
		self.molestiad.Scale=1.0
		self.molestiad.MinDistance= 5000
		self.molestiad.MaxDistance=25000

		self.muerted=Bladex.CreateSound("..\\..\\Sounds\\Muerte-Dwf3.wav", "MuerteD")
		self.muerted.Volume=1
		self.muerted.Scale=1.0
		self.muerted.MinDistance= 5000
		self.muerted.MaxDistance=15000

	def MurmuraD(self, entity_name):
#		print "Murmura..."
		self.MurmurandoD=1
		if self.DurmiendoD:
			self.DurmiendoD=0
			self.ronquidosd.Stop()
		if self.MolestadoD:
			self.MolestadoD=0
			self.molestiad.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep")
		person.SetOnFloor()
		#self.habladormidod.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		person.AnmEndedFunc=self.DuermeD

	def DuermeD(self, entity_name):
#		print "Duerme..."
		if self.MuertoD:
			return
		self.DurmiendoD=1
		if self.MurmurandoD:
			self.MurmurandoD=0
		if self.MolestadoD:
			self.MolestadoD=0
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep2")
		person.SetOnFloor()
		#self.ronquidosd.Play(person.Position[0], person.Position[1], person.Position[2], -1)

	def MolestiaD(self, entity_name):
#		print "Se molesta..."
		self.MolestadoD=1
		if self.DurmiendoD:
			self.DurmiendoD=0
			self.ronquidosd.Stop()
		if self.MurmurandoD:
			self.MurmurandoD=0
			self.habladormidod.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep_hit")
		person.SetOnFloor()
		self.molestiad.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		person.AnmEndedFunc=self.DuermeD

	def MuereD(self, entity_name):
		#print "Muere..."
		#Bldb.set_trace()
		if self.DurmiendoD:
			self.DurmiendoD=0
			self.ronquidosd.Stop()
		if self.MurmurandoD:
			self.MurmurandoD=0
			self.habladormidod.Stop()
		if self.MolestadoD:
			self.MolestadoD=0
			self.molestiad.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_dth_sleep")
		person.SetOnFloor()
		self.muerted.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		self.MuertoD=1

	# Functions for loading and saving state
	def __getstate__(self):
		#print "DrunkWarder.__getstate__"
		NPCPerson_state=Enm_Def.StupidNPCPerson.__getstate__(self)
		if(NPCPerson_state[0]!=1):
			#print "ERROR: DrunkWarder.__getstate__(): Base class version differs."
			return NPCPerson_state
		NPCPerson_state[1]["VictimDwf"]=(self.ronquidosd.Name,self.habladormidod.Name,
										   self.molestiad.Name,self.muerted.Name,
										   self.DurmiendoD,self.MurmurandoD,self.MolestadoD,self.MuertoD
										  )
		return NPCPerson_state
	
	def __setstate__(self,parm):
		#print "DrunkWarder.__setstate__"
		# Toma como par⮥tro lo que devuelve __getstate__() y debe recrear la clase
		Enm_Def.StupidNPCPerson.__setstate__(self,parm)
		version=parm[0]
		if version==1:
			parms=parm[1]["VictimDwf"]
			self.ronquidosd=Bladex.GetSound(parms[0])
			self.habladormidod=Bladex.GetSound(parms[1])
			self.molestiad=Bladex.GetSound(parms[2])
			self.muerted=Bladex.GetSound(parms[3])
			self.DurmiendoD=parms[4]
			self.MurmurandoD=parms[5]
			self.MolestadoD=parms[6]
			self.MuertoD=parms[7]
			
#################################################################################################################			
class VictimKnt(Enm_Def.StupidNPCPerson):

	DurmiendoK=0
	MurmurandoK=0
	MolestadoK=0
	MuertoK=0
	ronquidosk=None
	habladormidok=None
	molestiak=None
	muertek=None

	def __init__(self, person):
		Enm_Def.StupidNPCPerson.__init__(self, person)
		self.DurmiendoK=0
		self.MurmurandoK=0
		self.MolestadoK=0
		self.MuertoK=0
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep2")
		person.SetOnFloor()

		self.ronquidosk=Bladex.CreateSound("..\\..\\Sounds\\traidor-respira.wav", "RonquidosK")
		self.ronquidosk.Volume=1
		self.ronquidosk.Scale=1.0
		self.ronquidosk.MinDistance= 5000
		self.ronquidosk.MaxDistance=15000

		self.habladormidok=Bladex.CreateSound("..\\..\\Sounds\\rat-squeak.wav", "HablaDormidoK")
		self.habladormidok.Volume=1
		self.habladormidok.Scale=1.0
		self.habladormidok.MinDistance= 5000
		self.habladormidok.MaxDistance=50000

		self.molestiak=Bladex.CreateSound("..\\..\\Sounds\\knight-effort2.wav", "MolestiaK")
		self.molestiak.Volume=1
		self.molestiak.Scale=1.0
		self.molestiak.MinDistance= 5000
		self.molestiak.MaxDistance=25000

		self.muertek=Bladex.CreateSound("..\\..\\Sounds\\knight-die.wav", "MuerteK")
		self.muertek.Volume=1
		self.muertek.Scale=1.0
		self.muertek.MinDistance= 5000
		self.muertek.MaxDistance=15000

	def MurmuraK(self, entity_name):
#		print "Murmura..."
		self.MurmurandoK=1
		if self.DurmiendoK:
			self.DurmiendoK=0
			self.ronquidosk.Stop()
		if self.MolestadoK:
			self.MolestadoK=0
			self.molestiak.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep")
		person.SetOnFloor()
		#self.habladormidok.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		person.AnmEndedFunc=self.DuermeK

	def DuermeK(self, entity_name):
#		print "Duerme..."
		if self.MuertoK:
			return
		self.DurmiendoK=1
		if self.MurmurandoK:
			self.MurmurandoK=0
		if self.MolestadoK:
			self.MolestadoK=0
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep2")
		person.SetOnFloor()
		#self.ronquidosk.Play(person.Position[0], person.Position[1], person.Position[2], -1)

	def MolestiaK(self, entity_name):
#		print "Se molesta..."
		self.MolestadoK=1
		if self.DurmiendoK:
			self.DurmiendoK=0
			self.ronquidosk.Stop()
		if self.MurmurandoK:
			self.MurmurandoK=0
			self.habladormidok.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep_hit")
		person.SetOnFloor()
		self.molestiak.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		person.AnmEndedFunc=self.DuermeK

	def MuereK(self, entity_name):
		#print "Muere..."
		#Bldb.set_trace()
		if self.DurmiendoK:
			self.DurmiendoK=0
			self.ronquidosk.Stop()
		if self.MurmurandoK:
			self.MurmurandoK=0
			self.habladormidok.Stop()
		if self.MolestadoK:
			self.MolestadoK=0
			self.molestiak.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_dth_sleep")
		person.SetOnFloor()
		self.muertek.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		self.MuertoK=1

	# Functions for loading and saving state
	def __getstate__(self):
		#print "DrunkWarder.__getstate__"
		NPCPerson_state=Enm_Def.StupidNPCPerson.__getstate__(self)
		if(NPCPerson_state[0]!=1):
			#print "ERROR: DrunkWarder.__getstate__(): Base class version differs."
			return NPCPerson_state
		NPCPerson_state[1]["VictimKnt"]=(self.ronquidosk.Name,self.habladormidok.Name,
										   self.molestiak.Name,self.muertek.Name,
										   self.DurmiendoK,self.MurmurandoK,self.MolestadoK,self.MuertoK
										  )
		return NPCPerson_state
	
	def __setstate__(self,parm):
		#print "DrunkWarder.__setstate__"
		# Toma como par⮥tro lo que devuelve __getstate__() y debe recrear la clase
		Enm_Def.StupidNPCPerson.__setstate__(self,parm)
		version=parm[0]
		if version==1:
			parms=parm[1]["VictimKnt"]
			self.ronquidosk=Bladex.GetSound(parms[0])
			self.habladormidok=Bladex.GetSound(parms[1])
			self.molestiak=Bladex.GetSound(parms[2])
			self.muertek=Bladex.GetSound(parms[3])
			self.DurmiendoK=parms[4]
			self.MurmurandoK=parms[5]
			self.MolestadoK=parms[6]
			self.MuertoK=parms[7]
			
###############################################################################################################
class VictimBar(Enm_Def.StupidNPCPerson):

	DurmiendoB=0
	MurmurandoB=0
	MolestadoB=0
	MuertoB=0
	ronquidosb=None
	habladormidob=None
	molestiab=None
	muerteb=None

	def __init__(self, person):
		Enm_Def.StupidNPCPerson.__init__(self, person)
		self.DurmiendoB=0
		self.MurmurandoB=0
		self.MolestadoB=0
		self.MuertoB=0
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep2")
		person.SetOnFloor()

		self.ronquidosb=Bladex.CreateSound("..\\..\\Sounds\\rat-squeak.wav", "RonquidosB")
		self.ronquidosb.Volume=1
		self.ronquidosb.Scale=1.0
		self.ronquidosb.MinDistance= 5000
		self.ronquidosb.MaxDistance=15000

		self.habladormidob=Bladex.CreateSound("..\\..\\Sounds\\traidor-respira.wav", "HablaDormidoB")
		self.habladormidob.Volume=1
		self.habladormidob.Scale=1.0
		self.habladormidob.MinDistance= 5000
		self.habladormidob.MaxDistance=50000

		self.molestiab=Bladex.CreateSound("..\\..\\Sounds\\herida_barb_3.wav", "MolestiaB")
		self.molestiab.Volume=1
		self.molestiab.Scale=1.0
		self.molestiab.MinDistance= 5000
		self.molestiab.MaxDistance=25000

		self.muerteb=Bladex.CreateSound("..\\..\\Sounds\\muerte-barb-2.wav", "MuerteB")
		self.muerteb.Volume=1
		self.muerteb.Scale=1.0
		self.muerteb.MinDistance= 5000
		self.muerteb.MaxDistance=15000

	def MurmuraB(self, entity_name):
#		print "Murmura..."
		self.MurmurandoB=1
		if self.DurmiendoB:
			self.DurmiendoB=0
			self.ronquidosb.Stop()
		if self.MolestadoB:
			self.MolestadoB=0
			self.molestiab.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep")
		person.SetOnFloor()
		self.habladormidoa.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		person.AnmEndedFunc=self.DuermeB

	def DuermeB(self, entity_name):
#		print "Duerme..."
		if self.MuertoB:
			return
		self.DurmiendoB=1
		if self.MurmurandoB:
			self.MurmurandoB=0
		if self.MolestadoB:
			self.MolestadoB=0
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep2")
		person.SetOnFloor()
		#self.ronquidosb.Play(person.Position[0], person.Position[1], person.Position[2], -1)

	def MolestiaB(self, entity_name):
#		print "Se molesta..."
		self.MolestadoB=1
		if self.DurmiendoB:
			self.DurmiendoB=0
			self.ronquidosb.Stop()
		if self.MurmurandoB:
			self.MurmurandoB=0
			self.habladormidob.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep_hit")
		person.SetOnFloor()
		self.molestiab.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		person.AnmEndedFunc=self.DuermeB

	def MuereB(self, entity_name):
		#print "Muere..."
		#Bldb.set_trace()
		if self.DurmiendoB:
			self.DurmiendoB=0
			self.ronquidosb.Stop()
		if self.MurmurandoB:
			self.MurmurandoB=0
			self.habladormidob.Stop()
		if self.MolestadoB:
			self.MolestadoB=0
			self.molestiab.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_dth_sleep")
		person.SetOnFloor()
		self.muerteb.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		self.MuertoB=1

	# Functions for loading and saving state
	def __getstate__(self):
		#print "DrunkWarder.__getstate__"
		NPCPerson_state=Enm_Def.StupidNPCPerson.__getstate__(self)
		if(NPCPerson_state[0]!=1):
			#print "ERROR: DrunkWarder.__getstate__(): Base class version differs."
			return NPCPerson_state
		NPCPerson_state[1]["VictimBar"]=(self.ronquidosb.Name,self.habladormidob.Name,
										   self.molestiab.Name,self.muerteb.Name,
										   self.DurmiendoB,self.MurmurandoB,self.MolestadoB,self.MuertoB
										  )
		return NPCPerson_state
	
	def __setstate__(self,parm):
		#print "DrunkWarder.__setstate__"
		# Toma como par⮥tro lo que devuelve __getstate__() y debe recrear la clase
		Enm_Def.StupidNPCPerson.__setstate__(self,parm)
		version=parm[0]
		if version==1:
			parms=parm[1]["VictimBar"]
			self.ronquidosb=Bladex.GetSound(parms[0])
			self.habladormidob=Bladex.GetSound(parms[1])
			self.molestiab=Bladex.GetSound(parms[2])
			self.muerteb=Bladex.GetSound(parms[3])
			self.DurmiendoB=parms[4]
			self.MurmurandoB=parms[5]
			self.MolestadoB=parms[6]
			self.MuertoB=parms[7]
			
##############################################################################################################			
class ReallySillyKnight(Ally_Def.NPCAlly):

	DurmiendoRS=0
	MurmurandoRS=0
	MolestadoRS=0
	MuertoRS=0
	ronquidosrs=None
	habladormidors=None
	molestiars=None
	muerters=None

	def __init__(self, person):
		Ally_Def.NPCAlly.__init__(self, person)
		self.DurmiendoRS=0
		self.MurmurandoRS=0
		self.MolestadoRS=0
		self.MuertoRS=0
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep2")
		person.SetOnFloor()

		self.ronquidosrs=Bladex.CreateSound("..\\..\\Sounds\\traidor-respira.wav", "RonquidosRS")
		self.ronquidosrs.Volume=1
		self.ronquidosrs.Scale=1.0
		self.ronquidosrs.MinDistance= 5000
		self.ronquidosrs.MaxDistance=15000

		self.habladormidors=Bladex.CreateSound("..\\..\\Sounds\\traidor-respira.wav", "HablaDormidoRS")
		self.habladormidors.Volume=1
		self.habladormidors.Scale=1.0
		self.habladormidors.MinDistance= 5000
		self.habladormidors.MaxDistance=50000

		self.molestiars=Bladex.CreateSound("..\\..\\Sounds\\knight-effort2.wav", "MolestiaRS")
		self.molestiars.Volume=1
		self.molestiars.Scale=1.0
		self.molestiars.MinDistance= 5000
		self.molestiars.MaxDistance=25000

		self.muerters=Bladex.CreateSound("..\\..\\Sounds\\muerte-traidor-3.wav", "MuerteRS")
		self.muerters.Volume=1
		self.muerters.Scale=1.0
		self.muerters.MinDistance= 5000
		self.muerters.MaxDistance=15000

	def MurmuraRS(self, entity_name):
#		print "Murmura..."
		self.MurmurandoRS=1
		if self.DurmiendoRS:
			self.DurmiendoRS=0
			self.ronquidosrs.Stop()
		if self.MolestadoRS:
			self.MolestadoRS=0
			self.molestiars.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep")
		person.SetOnFloor()
		#self.habladormidors.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		person.AnmEndedFunc=self.DuermeRS

	def DuermeRS(self, entity_name):
#		print "Duerme..."
		if self.MuertoRS:
			return
		self.DurmiendoRS=1
		if self.MurmurandoRS:
			self.MurmurandoRS=0
		if self.MolestadoRS:
			self.MolestadoRS=0
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep2")
		person.SetOnFloor()
		#self.ronquidosrs.Play(person.Position[0], person.Position[1], person.Position[2], -1)

	def MolestiaRS(self, entity_name):
#		print "Se molesta..."
		self.MolestadoRS=1
		if self.DurmiendoRS:
			self.DurmiendoRS=0
			self.ronquidosrs.Stop()
		if self.MurmurandoRS:
			self.MurmurandoRS=0
			self.habladormidors.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep_hit")
		person.SetOnFloor()
		self.molestiars.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		person.AnmEndedFunc=self.DuermeRS

	def MuereRS(self, entity_name):
		#print "Muere..."
		#Bldb.set_trace()
		if self.DurmiendoRS:
			self.DurmiendoRS=0
			self.ronquidosrs.Stop()
		if self.MurmurandoRS:
			self.MurmurandoRS=0
			self.habladormidors.Stop()
		if self.MolestadoRS:
			self.MolestadoRS=0
			self.molestiars.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_dth_sleep")
		person.SetOnFloor()
		self.muerters.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		self.MuertoRS=1

	# Functions for loading and saving state
	def __getstate__(self):
		#print "DrunkWarder.__getstate__"
		NPCAlly_state=Ally_Def.NPCAlly.__getstate__(self)
		if(NPCAlly_state[0]!=1):
			#print "ERROR: DrunkWarder.__getstate__(): Base class version differs."
			return NPCAlly_state
		NPCAlly_state[1]["ReallySillyKnight"]=(self.ronquidosrs.Name,self.habladormidors.Name,
										   self.molestiars.Name,self.muerters.Name,
										   self.DurmiendoRS,self.MurmurandoRS,self.MolestadoRS,self.MuertoRS
										  )
		return NPCAlly_state
	
	def __setstate__(self,parm):
		#print "DrunkWarder.__setstate__"
		# Toma como par⮥tro lo que devuelve __getstate__() y debe recrear la clase
		Ally_Def.NPCAlly.__setstate__(self,parm)
		version=parm[0]
		if version==1:
			parms=parm[1]["ReallySillyKnight"]
			self.ronquidosrs=Bladex.GetSound(parms[0])
			self.habladormidors=Bladex.GetSound(parms[1])
			self.molestiars=Bladex.GetSound(parms[2])
			self.muerters=Bladex.GetSound(parms[3])
			self.DurmiendoRS=parms[4]
			self.MurmurandoRS=parms[5]
			self.MolestadoRS=parms[6]
			self.MuertoRS=parms[7]
########################################################################################################################
class CaptiveKnight(Ally_Def.NPCAlly):

	DurmiendoCK=0
	MurmurandoCK=0
	MolestadoCK=0
	MuertoCK=0
	ronquidosrck=None
	habladormidorck=None
	molestiarck=None
	muerterck=None

	def __init__(self, person):
		Ally_Def.NPCAlly.__init__(self, person)
		self.DurmiendoCK=0
		self.MurmurandoCK=0
		self.MolestadoCK=0
		self.MuertoCK=0
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep_wall")
		person.SetOnFloor()

		self.ronquidosrck=Bladex.CreateSound("..\\..\\Sounds\\traidor-respira.wav", "RonquidosCK")
		self.ronquidosrck.Volume=1
		self.ronquidosrck.Scale=1.0
		self.ronquidosrck.MinDistance= 5000
		self.ronquidosrck.MaxDistance=15000

		self.habladormidorck=Bladex.CreateSound("..\\..\\Sounds\\traidor-respira.wav", "HablaDormidoCK")
		self.habladormidorck.Volume=1
		self.habladormidorck.Scale=1.0
		self.habladormidorck.MinDistance= 5000
		self.habladormidorck.MaxDistance=50000

		self.molestiarck=Bladex.CreateSound("..\\..\\Sounds\\herida-caballero1.wav", "MolestiaCK")
		self.molestiarck.Volume=1
		self.molestiarck.Scale=1.0
		self.molestiarck.MinDistance= 5000
		self.molestiarck.MaxDistance=25000

		self.muerterck=Bladex.CreateSound("..\\..\\Sounds\\muerte-caballero1.wav", "MuerteCK")
		self.muerterck.Volume=1
		self.muerterck.Scale=1.0
		self.muerterck.MinDistance= 5000
		self.muerterck.MaxDistance=15000

	def MurmuraCK(self, entity_name):
#		print "Murmura..."
		self.MurmurandoCK=1
		if self.DurmiendoCK:
			self.DurmiendoCK=0
			self.ronquidosrck.Stop()
		if self.MolestadoCK:
			self.MolestadoCK=0
			self.molestiarck.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep_wall")
		person.SetOnFloor()
		#self.habladormidorck.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		person.AnmEndedFunc=self.DuermeCK

	def DuermeCK(self, entity_name):
#		print "Duerme..."
		if self.MuertoCK:
			return
		self.DurmiendoCK=1
		if self.MurmurandoCK:
			self.MurmurandoCK=0
		if self.MolestadoCK:
			self.MolestadoCK=0
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep_wall")
		person.SetOnFloor()
		#self.ronquidosrck.Play(person.Position[0], person.Position[1], person.Position[2], -1)

	def MolestiaCK(self, entity_name):
#		print "Se molesta..."
		self.MolestadoCK=1
		if self.DurmiendoCK:
			self.DurmiendoCK=0
			self.ronquidosrck.Stop()
		if self.MurmurandoCK:
			self.MurmurandoCK=0
			self.habladormidorck.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep_wall")#########################################
		person.SetOnFloor()
		self.molestiarck.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		person.AnmEndedFunc=self.DuermeCK

	def MuereCK(self, entity_name):
		#print "Muere..."
		#Bldb.set_trace()
		if self.DurmiendoCK:
			self.DurmiendoCK=0
			self.ronquidosrck.Stop()
		if self.MurmurandoCK:
			self.MurmurandoCK=0
			self.habladormidorck.Stop()
		if self.MolestadoCK:
			self.MolestadoCK=0
			self.molestiarck.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("dth0")
		person.SetOnFloor()
		self.muerterck.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		self.MuertoCK=1

	# Functions for loading and saving state
	def __getstate__(self):
		#print "DrunkWarder.__getstate__"
		NPCAlly_state=Ally_Def.NPCAlly.__getstate__(self)
		if(NPCAlly_state[0]!=1):
			#print "ERROR: DrunkWarder.__getstate__(): Base class version differs."
			return NPCAlly_state
		NPCAlly_state[1]["CaptiveKnight"]=(self.ronquidosrck.Name,self.habladormidorck.Name,
										   self.molestiarck.Name,self.muerterck.Name,
										   self.DurmiendoCK,self.MurmurandoCK,self.MolestadoCK,self.MuertoCK
										  )
		return NPCAlly_state
	
	def __setstate__(self,parm):
		#print "DrunkWarder.__setstate__"
		# Toma como par⮥tro lo que devuelve __getstate__() y debe recrear la clase
		Ally_Def.NPCAlly.__setstate__(self,parm)
		version=parm[0]
		if version==1:
			parms=parm[1]["CaptiveKnight"]
			self.ronquidosrck=Bladex.GetSound(parms[0])
			self.habladormidorck=Bladex.GetSound(parms[1])
			self.molestiarck=Bladex.GetSound(parms[2])
			self.muerterck=Bladex.GetSound(parms[3])
			self.DurmiendoCK=parms[4]
			self.MurmurandoCK=parms[5]
			self.MolestadoCK=parms[6]
			self.MuertoCK=parms[7]		
			




#########################################################################################################################
class WoundedOrk(Ally_Def.NPCAlly):

	DurmiendoWO=0
	MurmurandoWO=0
	MolestadoWO=0
	MuertoWO=0
	ronquidoswo=None
	habladormidowo=None
	molestiawo=None
	muertewo=None

	def __init__(self, person):
		Ally_Def.NPCAlly.__init__(self, person)
		self.DurmiendoWO=0
		self.MurmurandoWO=0
		self.MolestadoWO=0
		self.MuertoWO=0
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep2")
		person.SetOnFloor()

		self.ronquidoswo=Bladex.CreateSound("..\\..\\Sounds\\traidor-respira.wav", "RonquidosWO")
		self.ronquidoswo.Volume=1
		self.ronquidoswo.Scale=1.0
		self.ronquidoswo.MinDistance= 5000
		self.ronquidoswo.MaxDistance=15000

		self.habladormidowo=Bladex.CreateSound("..\\..\\Sounds\\traidor-respira.wav", "HablaDormidoWO")
		self.habladormidowo.Volume=1
		self.habladormidowo.Scale=1.0
		self.habladormidowo.MinDistance= 5000
		self.habladormidowo.MaxDistance=50000

		self.molestiawo=Bladex.CreateSound("..\\..\\Sounds\\herido-orco-3.wav", "MolestiaWO")
		self.molestiawo.Volume=1
		self.molestiawo.Scale=1.0
		self.molestiawo.MinDistance= 5000
		self.molestiawo.MaxDistance=25000

		self.muertewo=Bladex.CreateSound("..\\..\\Sounds\\muerte-orco-4.wav", "MuerteWO")
		self.muertewo.Volume=1
		self.muertewo.Scale=1.0
		self.muertewo.MinDistance= 5000
		self.muertewo.MaxDistance=15000

	def MurmuraWO(self, entity_name):
		self.MurmurandoWO=1
		if self.DurmiendoWO:
			self.DurmiendoWO=0
			self.ronquidoswo.Stop()
		if self.MolestadoWO:
			self.MolestadoWO=0
			self.molestiawo.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep")
		person.SetOnFloor()
		person.AnmEndedFunc=self.DuermeWO

	def DuermeWO(self, entity_name):
		if self.MuertoWO:
			return
		self.DurmiendoWO=1
		if self.MurmurandoWO:
			self.MurmurandoWO=0
		if self.MolestadoWO:
			self.MolestadoWO=0
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep2")
		person.SetOnFloor()
		

	def MolestiaWO(self, entity_name):
		self.MolestadoWO=1
		if self.DurmiendoWO:
			self.DurmiendoWO=0
			self.ronquidoswo.Stop()
		if self.MurmurandoWO:
			self.MurmurandoWO=0
			self.habladormidowo.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep_hit")
		person.SetOnFloor()
		self.molestiawo.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		person.AnmEndedFunc=self.DuermeWO

	def MuereWO(self, entity_name):
		if self.DurmiendoWO:
			self.DurmiendoWO=0
			self.ronquidoswo.Stop()
		if self.MurmurandoWO:
			self.MurmurandoWO=0
			self.habladormidowo.Stop()
		if self.MolestadoWO:
			self.MolestadoWO=0
			self.molestiawo.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_dth_sleep")
		person.SetOnFloor()
		self.muertewo.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		self.MuertoWO=1

	# Functions for loading and saving state
	def __getstate__(self):
		#print "DrunkWarder.__getstate__"
		NPCAlly_state=Ally_Def.NPCAlly.__getstate__(self)
		if(NPCAlly_state[0]!=1):
			#print "ERROR: DrunkWarder.__getstate__(): Base class version differs."
			return NPCPerson_state
		NPCAlly_state[1]["WoundedOrk"]=(self.ronquidoswo.Name,self.habladormidowo.Name,
										   self.molestiawo.Name,self.muertewo.Name,
										   self.DurmiendoWO,self.MurmurandoWO,self.MolestadoWO,self.MuertoWO
										  )
		return NPCAlly_state
	
	def __setstate__(self,parm):
		#print "DrunkWarder.__setstate__"
		# Toma como par⮥tro lo que devuelve __getstate__() y debe recrear la clase
		Ally_Def.NPCAlly.__setstate__(self,parm)
		version=parm[0]
		if version==1:
			parms=parm[1]["WoundedOrk"]
			self.ronquidoswo=Bladex.GetSound(parms[0])
			self.habladormidowo=Bladex.GetSound(parms[1])
			self.molestiawo=Bladex.GetSound(parms[2])
			self.muertewo=Bladex.GetSound(parms[3])
			self.DurmiendoWO=parms[4]
			self.MurmurandoWO=parms[5]
			self.MolestadoWO=parms[6]
			self.MuertoWO=parms[7]
			
			
###########################################################################################################################
class BreakSector:
	def __init__(self):
		self.ObjId=ObjStore.GetNewId() # Para identificarlo al grabar/guardar
		ObjStore.ObjectsStore[self.ObjId]=self
		self.sector=None
		self.sector2=None
		self.break_sound=None
		self.hit_sound=None
		self.polvo = 0
		self.polvo_vel=None
		self.polvo_p0=None
		self.polvo_p1=None
		self.polvo_p2=None
		self.polvo_p3=None
		self.life=None
		self.pos = (0,0,0)
		self.normal = (1,0,0)

	def persistent_id(self):
		return self.ObjId

	def __getstate__(self):
		return (1,
				self.ObjId,
				self.sector,
				self.sector2,
				self.break_sound,
				self.hit_sound,
				self.polvo,
				self.polvo_vel,
				self.polvo_p0,
				self.polvo_p1,
				self.polvo_p2,
				self.polvo_p3,
				self.life,
                self.pos,
                self.normal
				)

	def __setstate__(self,parm):
		if parm[0]==1:
			self.ObjId=parm[1]
			ObjStore.ObjectsStore[self.ObjId]=self
			self.sector=parm[2]
			self.sector2=parm[3]
			self.break_sound=parm[4]
			self.hit_sound=parm[5]
			self.polvo=parm[6]
			self.polvo_vel=parm[7]
			self.polvo_p0=parm[8]
			self.polvo_p1=parm[9]
			self.polvo_p2=parm[10]
			self.polvo_p3=parm[11]
			self.life=parm[12]
			self.pos=parm[13]
			self.normal=parm[14]
		else:
			print "Version mismatch in BreakSector"
			self.ObjId=ObjStore.GetNewId() # Para identificarlo al grabar/guardar
			ObjStore.ObjectsStore[self.ObjId]=self
			self.sector=None
			self.sector2=None
			self.break_sound=None
			self.hit_sound=None
			self.polvo = 0
			self.polvo_vel=None
			self.polvo_p0=None
			self.polvo_p1=None
			self.polvo_p2=None
			self.polvo_p3=None
			self.life=None
			self.pos = (0,0,0)
			self.normal = (1,0,0)

	def HitSector(self,sector,weapon,ipx,ipy,ipz,ximpulse=0,yimpulse=0,zimpulse=0,x_norm=0,y_norm=0,z_norm=0,material=""):
		self.life = self.life - 1

		if self.life <= 0:
			self.sector.DoBreak(self.normal, (ipx,ipy,ipz), (0.0, 0.0, 0.0))
			self.sector.Active = 1
			self.sector2.OnHit = ""
			self.break_sound.Play(self.pos[0],self.pos[1],self.pos[2],0)		

			if self.polvo:
				self.SetPolvo()
		else:
			self.hit_sound.Play(ipx,ipy,ipz,0)

	def InitBreak(self,pos,pos2,normal,life,dir,dir1,dir2):
		self.sector2 = Bladex.GetSector(pos2[0],pos2[1],pos2[2])
		self.sector = Bladex.GetSector(pos[0],pos[1],pos[2])
		
		self.break_sound=Bladex.CreateSound('..\..\Sounds\\madera-rotura-pesada.wav', 'SonidoDesprendimiento')
		self.break_sound.Volume=1.0
		self.break_sound.MinDistance=3000
		self.break_sound.MaxDistance=40000

		self.hit_sound=Bladex.CreateSound('..\..\Sounds\\golpe-madera-pesada.wav', 'SonidoHit')
		self.hit_sound.Volume=1.0
		self.hit_sound.MinDistance=3000
		self.hit_sound.MaxDistance=40000

		self.sector.InitBreak(dir, dir1, dir2)
		self.sector2.OnHit = self.HitSector		
		self.sector2.ActiveSurface = normal
		self.normal = normal[0] * -6.5,normal[1] * -6.5,normal[2] * -6.5

		self.sector.Active = 0
		self.life = life
		self.pos = pos

	def ActivatePolvo(self,p1,p2,p3,p4,vel):
		self.polvo_vel = vel
		self.polvo_p0 = p1
		self.polvo_p1 = p2
		self.polvo_p2 = p3
		self.polvo_p3 = p4
		self.polvo = 1

	def SetPolvo(self):
		self.polvoTri(self.polvo_p0,self.polvo_p1,self.polvo_p2,self.polvo_vel,"dustA")
		self.polvoTri(self.polvo_p1,self.polvo_p2,self.polvo_p3,self.polvo_vel,"dustB")

	def polvoTri(self,a,b,c,vel,name):
		dust=Bladex.CreateEntity(name, "Entity Particle System D3", a[0],a[1],a[2])
		dust.D1= b[0]-a[0] ,b[1]-a[1] ,b[2]-a[2]
		dust.D2= c[0]-b[0] ,c[1]-b[1] ,c[2]-b[2]
		dust.ParticleType="MediumDust"
		dust.YGravity=230.0
		dust.Friction=0.2
		dust.PPS=1000
		dust.Velocity= vel
		dust.RandomVelocity=20.0
		dust.Time2Live=16
		dust.DeathTime=Bladex.GetTime() + 0.8
		
		
		
###########################################################################################################################
import Bladex
import ItemTypes
class AmuletoInvisibility (ItemTypes.ItemOfProtection):
        def __init__ (self, me):
                ItemTypes.ItemOfProtection.__init__(self, me)
                self.UsedBy= "Player1"
                self.UseTime= 60.0
                self.Resistances= {}
                self.nUses= 2

        def UseStart (self, ObjectName, use_from):
                ItemTypes.ItemOfProtection.UseStart (self, ObjectName, use_from)
                pj=Bladex.GetEntity('Player1')
                pj.Alpha=0.0
                
		    


        def UseEnd (self,ObjectName, UserName):
                pj=Bladex.GetEntity('Player1')
                pj.Alpha=1.0
                ItemTypes.ItemOfProtection.UseEnd (self, ObjectName, UserName)