
import Bladex
import ObjStore
import EnemyTypes
import Enm_Def
import Reference
import AniSound
import Sounds
import Combat
import copy
import Actions
import GameStateAux
import Language
import ItemTypes
import Auras
import Sparks
import GenFX
import Breakings
import Damage
import netgame
import B3DLib
import BCopy
import InitDataField
import Objects
import whrandom
import math
import AuxFuncs
import CharStats
import pdb





MESSAGE_START_WEAPON         =7
MESSAGE_STOP_WEAPON          =8


#*************************************************************************************************
#*************************************************************************************************
#*************************************************************************************************
#*******************************								        **************************
#*******************************   Definiciones para Trampa_Pinchos.py  **************************
#*******************************								        **************************
#*************************************************************************************************
#*************************************************************************************************

class BreakSector:
	def __init__(self):
		self.ObjId=ObjStore.GetNewId() # Para identificarlo al grabar/guardar
		ObjStore.ObjectsStore[self.ObjId]=self
		self.sector=None
		self.sector2=None
		self.break_sound=None
		self.hit_sound=None
		self.polvo = 0
		self.polvo_vel=None
		self.polvo_p0=None
		self.polvo_p1=None
		self.polvo_p2=None
		self.polvo_p3=None
		self.life=None
		self.pos = (0,0,0)
		self.normal = (1,0,0)

	def persistent_id(self):
		return self.ObjId

	def __getstate__(self):
		return (1,
				self.ObjId,
				self.sector,
				self.sector2,
				self.break_sound,
				self.hit_sound,
				self.polvo,
				self.polvo_vel,
				self.polvo_p0,
				self.polvo_p1,
				self.polvo_p2,
				self.polvo_p3,
				self.life,
                self.pos,
                self.normal
				)

	def __setstate__(self,parm):
		if parm[0]==1:
			self.ObjId=parm[1]
			ObjStore.ObjectsStore[self.ObjId]=self
			self.sector=parm[2]
			self.sector2=parm[3]
			self.break_sound=parm[4]
			self.hit_sound=parm[5]
			self.polvo=parm[6]
			self.polvo_vel=parm[7]
			self.polvo_p0=parm[8]
			self.polvo_p1=parm[9]
			self.polvo_p2=parm[10]
			self.polvo_p3=parm[11]
			self.life=parm[12]
			self.pos=parm[13]
			self.normal=parm[14]
		else:
			print "Version mismatch in BreakSector"
			self.ObjId=ObjStore.GetNewId() # Para identificarlo al grabar/guardar
			ObjStore.ObjectsStore[self.ObjId]=self
			self.sector=None
			self.sector2=None
			self.break_sound=None
			self.hit_sound=None
			self.polvo = 0
			self.polvo_vel=None
			self.polvo_p0=None
			self.polvo_p1=None
			self.polvo_p2=None
			self.polvo_p3=None
			self.life=None
			self.pos = (0,0,0)
			self.normal = (1,0,0)

	def HitSector(self,sector,weapon,ipx,ipy,ipz,ximpulse=0,yimpulse=0,zimpulse=0,x_norm=0,y_norm=0,z_norm=0,material=""):
		self.life = self.life - 1

		if self.life <= 0:
			self.sector.DoBreak(self.normal, (ipx,ipy,ipz), (0.0, 0.0, 0.0))
			self.sector.Active = 1
			self.sector2.OnHit = ""
			self.break_sound.Play(self.pos[0],self.pos[1],self.pos[2],0)		

			if self.polvo:
				self.SetPolvo()
		else:
			self.hit_sound.Play(ipx,ipy,ipz,0)

	def InitBreak(self,pos,pos2,normal,life,dir,dir1,dir2):
		self.sector2 = Bladex.GetSector(pos2[0],pos2[1],pos2[2])
		self.sector = Bladex.GetSector(pos[0],pos[1],pos[2])
		
		self.break_sound=Bladex.CreateSound('..\..\Sounds\\madera-rotura-pesada.wav', 'SonidoDesprendimiento')
		self.break_sound.Volume=1.0
		self.break_sound.MinDistance=3000
		self.break_sound.MaxDistance=40000

		self.hit_sound=Bladex.CreateSound('..\..\Sounds\\golpe-madera-pesada.wav', 'SonidoHit')
		self.hit_sound.Volume=1.0
		self.hit_sound.MinDistance=3000
		self.hit_sound.MaxDistance=40000

		self.sector.InitBreak(dir, dir1, dir2)
		self.sector2.OnHit = self.HitSector		
		self.sector2.ActiveSurface = normal
		self.normal = normal[0] * -6.5,normal[1] * -6.5,normal[2] * -6.5

		self.sector.Active = 0
		self.life = life
		self.pos = pos

	def ActivatePolvo(self,p1,p2,p3,p4,vel):
		self.polvo_vel = vel
		self.polvo_p0 = p1
		self.polvo_p1 = p2
		self.polvo_p2 = p3
		self.polvo_p3 = p4
		self.polvo = 1

	def SetPolvo(self):
		self.polvoTri(self.polvo_p0,self.polvo_p1,self.polvo_p2,self.polvo_vel,"dustA")
		self.polvoTri(self.polvo_p1,self.polvo_p2,self.polvo_p3,self.polvo_vel,"dustB")

	def polvoTri(self,a,b,c,vel,name):
		dust=Bladex.CreateEntity(name, "Entity Particle System D3", a[0],a[1],a[2])
		dust.D1= b[0]-a[0] ,b[1]-a[1] ,b[2]-a[2]
		dust.D2= c[0]-b[0] ,c[1]-b[1] ,c[2]-b[2]
		dust.ParticleType="MediumDust"
		dust.YGravity=230.0
		dust.Friction=0.2
		dust.PPS=1000
		dust.Velocity= vel
		dust.RandomVelocity=20.0
		dust.Time2Live=16
		dust.DeathTime=Bladex.GetTime() + 0.8


####################################################################################################################


import Bladex
import ItemTypes
class AmuletoInvincibility (ItemTypes.ItemOfProtection):
        def __init__ (self, me):
                ItemTypes.ItemOfProtection.__init__(self, me)
                self.UsedBy= "Player1"
                self.UseTime= 60.0
                self.Resistances= {}
                self.nUses= 2

        def UseStart (self, ObjectName, use_from):
                ItemTypes.ItemOfProtection.UseStart (self, ObjectName, use_from)
                pj=Bladex.GetEntity('Player1')
                pj.Data.Invincibility= 1
                GenFX.AddPersonItemFX(self.UsedBy, ObjectName, self.UseTime)
		    


        def UseEnd (self,ObjectName, UserName):
                pj=Bladex.GetEntity('Player1')
                pj.Data.Invincibility= 0
                ItemTypes.ItemOfProtection.UseEnd (self, ObjectName, UserName)


####################################################################################################################


class BossAsleep(Enm_Def.NPCPerson):

	Durmiendo=0
	Murmurando=0
	Molestado=0
	Muerto=0
	ronquidos=None
	habladormido=None
	molestia=None
	muerte=None

	def __init__(self, person):
		Enm_Def.NPCPerson.__init__(self, person)
		self.Durmiendo=0
		self.Murmurando=0
		self.Molestado=0
		self.Muerto=0
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep2")
		person.SetOnFloor()

		self.ronquidos=Bladex.CreateSound("..\\..\\Sounds\\snore-loop.wav", "Ronquidos")
		self.ronquidos.Volume=1
		self.ronquidos.Scale=1.0
		self.ronquidos.MinDistance= 5000
		self.ronquidos.MaxDistance=15000

		self.habladormido=Bladex.CreateSound("..\\..\\Sounds\\drunk-loop.wav", "HablaDormido")
		self.habladormido.Volume=1
		self.habladormido.Scale=1.0
		self.habladormido.MinDistance= 5000
		self.habladormido.MaxDistance=50000

		self.molestia=Bladex.CreateSound("..\\..\\Sounds\\drunk-loop-short.wav", "Molestia")
		self.molestia.Volume=1
		self.molestia.Scale=1.0
		self.molestia.MinDistance= 5000
		self.molestia.MaxDistance=25000

		self.muerte=Bladex.CreateSound("..\\..\\Sounds\\knight-die.wav", "Muerte")
		self.muerte.Volume=1
		self.muerte.Scale=1.0
		self.muerte.MinDistance= 5000
		self.muerte.MaxDistance=15000

	def Murmura(self, entity_name):
#		print "Murmura..."
		self.Murmurando=1
		if self.Durmiendo:
			self.Durmiendo=0
			self.ronquidos.Stop()
		if self.Molestado:
			self.Molestado=0
			self.molestia.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep")
		person.SetOnFloor()
		self.habladormido.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		person.AnmEndedFunc=self.Duerme
	
	def Duerme(self, entity_name):
#		print "Duerme..."
		if self.Muerto:
			return
		self.Durmiendo=1
		if self.Murmurando:
			self.Murmurando=0
		if self.Molestado:
			self.Molestado=0
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.SetTmpAnmFlags(1, 1, 0, 0, 1, 1, 0)
		person.LaunchAnimation("Tkn_sleep2")
		person.SetOnFloor()
		self.ronquidos.Play(person.Position[0], person.Position[1], person.Position[2], -1)

	def Molestia(self, entity_name):
#		print "Se molesta..."
		self.Molestado=1
		if self.Durmiendo:
			self.Durmiendo=0
			self.ronquidos.Stop()
		if self.Murmurando:
			self.Murmurando=0
			self.habladormido.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_sleep_hit")
		person.SetOnFloor()
		self.molestia.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		person.AnmEndedFunc=self.Duerme

	def Muere(self, entity_name):
		#print "Muere..."
		#Bldb.set_trace()
		if self.Durmiendo:
			self.Durmiendo=0
			self.ronquidos.Stop()
		if self.Murmurando:
			self.Murmurando=0
			self.habladormido.Stop()
		if self.Molestado:
			self.Molestado=0
			self.molestia.Stop()
		person=Bladex.GetEntity(entity_name)
		person.Wuea=Reference.WUEA_ENDED
		person.LaunchAnimation("Tkn_dth_sleep")
		person.SetOnFloor()
		self.muerte.Play(person.Position[0], person.Position[1], person.Position[2], 0)
		self.Muerto=1

	# Functions for loading and saving state
	def __getstate__(self):
		#print "BossAsleep.__getstate__"
		NPCPerson_state=Enm_Def.NPCPerson.__getstate__(self)
		if(NPCPerson_state[0]!=1):
			#print "ERROR: BossAsleep.__getstate__(): Base class version differs."
			return NPCPerson_state
		NPCPerson_state[1]["BossAsleep"]=(self.ronquidos.Name,self.habladormido.Name,
										   self.molestia.Name,self.muerte.Name,
										   self.Durmiendo,self.Murmurando,self.Molestado,self.Muerto
										  )
		return NPCPerson_state
	
	def __setstate__(self,parm):
		#print "BossAsleep.__setstate__"
		# Toma como par⮥tro lo que devuelve __getstate__() y debe recrear la clase
		Enm_Def.NPCPerson.__setstate__(self,parm)
		version=parm[0]
		if version==1:
			parms=parm[1]["BossAsleep"]
			self.ronquidos=Bladex.GetSound(parms[0])
			self.habladormido=Bladex.GetSound(parms[1])
			self.molestia=Bladex.GetSound(parms[2])
			self.muerte=Bladex.GetSound(parms[3])
			self.Durmiendo=parms[4]
			self.Murmurando=parms[5]
			self.Molestado=parms[6]
			self.Muerto=parms[7]

#######################################################################################################################
###########################################bombs#######################################################################
#################firebomb
class PersistantItemType:
	def __init__(self, me):
		self.ObjId= ObjStore.GetNewId()
		ObjStore.ObjectsStore[self.ObjId]= self
	
	def persistent_id(self):
		return self.ObjId
	
	def __getstate__(self):
	# Tiene que devolver cmo poder guardar el estado de la clase
		return (1,{"PersistantItemType":(self.ObjId,
										)
				}
				)

	def __setstate__(self,parm):
		if parm[0]==1:
			parms=parm[1]["PersistantItemType"]
			self.ObjId=parms[0]
			ObjStore.ObjectsStore[self.ObjId]=self
		else:
			print "ItemOfProtection.__setstate__() -> Version mismatch"
			self.ObjId=ObjStore.GetNewId()
			ObjStore.ObjectsStore[self.ObjId]=self





class ActivateableSpecialWeapon(PersistantItemType):
	def __init__ (self, me):
		PersistantItemType.__init__(self, me)
		self.SpecialWeaponActive= 0
		self.SpecialWeaponActivatedKey= 0
		self.SpecialExtraDamage= []
		self.WeaponFX= None
		GenFX.AddWeaponFX(me.Name, self)
		self.Name= me.Name
	
	def __getstate__(self):

		state= PersistantItemType.__getstate__(self)
		state[1]["ActivateableSpecialWeapon"]=(self.SpecialWeaponActive,
									self.SpecialWeaponActivatedKey,
##									GameStateAux.SaveObjectAux(self.WeaponFX)
									self.WeaponFX,
									self.SpecialExtraDamage,
									self.Name
									)

		return state
		
	def __setstate__(self,parm):
		PersistantItemType.__setstate__(self,parm)
		if parm[0]==1:
			parms=parm[1]["ActivateableSpecialWeapon"]
			self.SpecialWeaponActive=parms[0]
			self.SpecialWeaponActivatedKey= parms[1]
##			GameStateAux.LoadObjectAux(parms[2],self,"WeaponFX")
			self.WeaponFX=parms[2]
			self.SpecialExtraDamage=parms[3]
			self.Name= parms[4]
		else:
			self.SpecialWeaponActive=0
			self.SpecialWeaponActivatedKey=0
			GenFX.AddWeaponFX(me.Name, self)
			self.SpecialExtraDamage= []
			self.Name=""

	def Start_Weapon_Special (self, EntityParentName,EventName):
		previously_active= self.SpecialWeaponActive
		self.SpecialWeaponActive= 1
		print "Start_Weapon_Special active"
		
		if not previously_active:
			# increase the damage data
			if not Reference.EntitiesObjectData.has_key (self.Name):
				obj= Bladex.GetEntity(self.Name)
				if obj:
					Reference.EntitiesObjectData[self.Name]= BCopy.deepcopy(Reference.DefaultObjectData[obj.Kind])
			
			if not Reference.EntitiesObjectData.has_key (self.Name):
				print "Start_Weapon_Special() Cannot create a dictionary entry for "+`self.Name`
				return
			
			for damage in self.SpecialExtraDamage:
				Reference.EntitiesObjectData[self.Name].append (damage)
		
		# Organize the switch off, based on a key, so that our switch off corresponds just to THIS switch on
		self.SpecialWeaponActivatedKey= time= Bladex.GetTime()
		parent= Bladex.GetEntity (EntityParentName)
		if parent:
			anim_duration= Bladex.GetAnimationDuration(parent.AnimFullName)
			if not anim_duration:
				anim_duration= 1.0
			anm_pos= parent.AnmPos
			time2finish= time+(1.0-anm_pos)*anim_duration
		else:
			time2finish= time+2.0
		Bladex.AddScheduledFunc (time2finish, self.Stop_Weapon_Special, (EntityParentName,"Stop_Weapon_Special", self.SpecialWeaponActivatedKey) , self.Stop_Weapon_Special.__name__)

	def Stop_Weapon_Special (self, EntityParentName,EventName, Key=-1):
		if Key!=-1:
			if Key != self.SpecialWeaponActivatedKey:
				return
		
		if not self.SpecialWeaponActive:
			return
		
		self.SpecialWeaponActive= 0	
		
		print "Start_Weapon_Special deactivated"
		
		if Reference.EntitiesObjectData.has_key (self.Name):
			for damage in self.SpecialExtraDamage:
				Reference.EntitiesObjectData[self.Name].remove (damage)

######################################################################################

class Bomb(ActivateableSpecialWeapon):

	
	def __init__(self, me):
		ActivateableSpecialWeapon.__init__(self, me)
		#self.SpecialExtraDamage= [["Fire", +1000.0],]
		me.Weapon= 1
		self.Age= 0
		self.FadeTime= 1.0
		self.Speed= 10000.0
		self.missileName= ""
		self.LastHitTime=-1
		self.AuxFuncsData=None
		
		self.WhileSound=Bladex.CreateEntity (me.Name+"MissileLoopSound", "Entity Sound", 0, 0, 0)
		self.WhileSound.SetSound("..\\..\\Sounds\\energy-ball.wav")
		self.WhileSound.MinDistance=5000
		self.WhileSound.MaxDistance=30000
		me.Link(self.WhileSound)
		
		self.ImpactSound=Bladex.CreateEntity (me.Name+"MissileImpactSound", "Entity Sound", 0, 0, 0)
		self.ImpactSound.SetSound("..\\..\\Sounds\\energy-ball-impact.wav")
		self.ImpactSound.MinDistance=5000
		self.ImpactSound.MaxDistance=30000
		self.OwnerName= ""

		
	def __getstate__(self):
		state= ActivateableSpecialWeapon.__getstate__(self)
		state[1]["Bomb"]=   (self.Age,
									self.FadeTime,
									self.Speed,
									self.missileName,
									self.LastHitTime,
									self.WhileSound.Name,
									self.ImpactSound.Name,
									self.AuxFuncsData,
									self.OwnerName
									)
		return state
		
	def __setstate__(self,parm):
		ActivateableSpecialWeapon.__setstate__(self,parm)
		if parm[0]==1:
			parms=parm[1]["Bomb"]
			self.Age=parms[0]
			self.FadeTime= parms[1]
			self.Speed=parms[2]
			self.missileName= parms[3]
			self.LastHitTime= parms[4]
			self.WhileSound= Bladex.GetEntity(parms[5])
			self.ImpactSound= Bladex.GetEntity(parms[6])
			self.AuxFuncsData= parms[7]
			self.OwnerName=  parms[8]
		else:
			self.Age=0
			self.FadeTime= 1.0
			self.Speed= 10000.0
			self.missileName= ""
			self.LastHitTime=-1
			self.WhileSound= Bladex.GetEntity(self.Name+"MissileLoopSound")
			self.ImpactSound= Bladex.GetEntity(self.Name+"MissileImpactSound")
			self.AuxFuncsData= None
			self.OwnerName= "Player1"
		
		weapon=  Bladex.GetEntity(self.Name)
		#if weapon:
		#	weapon.OnStopFunc=self.StartBackToPlayer
		
		if self.missileName:
			missile= Bladex.GetEntity(self.missileName)
			if missile:
				missile.InflictHitFunc= self.BladeSwordInflictHitFunc
				missile.OnHitFunc= self.MissileOnHitFunc
				if weapon:
					weapon.InflictHitFunc= self.BladeSwordInflictHitFunc
			else:
				print "Missile "+self.missileName+" unavailable for linking...."

	
	def DropReleaseEventHandler (self,EntityName,EventName):
		weapon= Bladex.GetEntity(self.Name)
		if not weapon:
			return
		self.OwnerName= weapon.Parent
		if not self.OwnerName:
			return		
		owner=Bladex.GetEntity(self.OwnerName)
		if not owner or owner.InvRight != self.Name:
			return	
		if weapon.TestHit:
			return
		Actions.RemoveFromInventory (owner, weapon, EventName)
		ix, iy, iz = owner.Rel2AbsVector(-1000.0, -1500.0, 0.0)
		weapon.Impulse(ix, iy, iz)
		weapon.ExcludeHitFor(owner)
		owner.DelAnmEventFunc(EventName)
	
	def ThrowReleaseEventHandler (self,EntityName,EventName):
		weapon= Bladex.GetEntity(self.Name)
		if not weapon:
			return
		self.OwnerName= weapon.Parent
		if not self.OwnerName:
			return
		owner=Bladex.GetEntity(self.OwnerName)
		if not owner or owner.InvRight != self.Name:
			return
		
		if weapon.TestHit:
			return
		
		Actions.RemoveFromInventory (owner, weapon, EventName)
		
		# Create a magic missile
		self.Age= self.Age+1
		x,y,z= weapon.Position
		missile= Bladex.CreateEntity(self.Name+"_Missile_"+`self.Age`, "Entity Magic Missile", x,y,z)
		InitDataField.Initialise(missile)
		missile.CastShadows=0
		missile.Color=0, 0, 0
		#missile.Visible=0
		self.missileName= missile.Name
		
		# Set the velocity of the missile
		if owner.ActiveEnemy:
			enemy= Bladex.GetEntity(owner.ActiveEnemy)
			if enemy and enemy.Person:
				tx1,ty1,tz1= enemy.GraspPos ("ViewPoint")
				tx2,ty2,tz2= enemy.Position
				tx= (tx1+tx2)/2.0; ty= (ty1+ty2)/2.0; tz= (tz1+tz2)/2.0; 
			else:
				tx,ty,tz= owner.Rel2AbsPoint(0,-30000.0,0.0)
		else:
			tx,ty,tz= owner.Rel2AbsPoint(0,-30000.0,0.0)
		
		angley= -B3DLib.GetYAngle(tx-x,ty-y,tz-z)
		vx,vy,vz= owner.Rel2AbsVector(0.0, -math.cos(angley)*self.Speed, -math.sin(angley)*self.Speed)
		
		anglexz= B3DLib.Pos2PosXZAngle(x,y,z,tx,ty,tz)
		diff_angle= min (max (B3DLib.DiffAngle(anglexz, owner.Angle), -Actions.FACINGANGLE), Actions.FACINGANGLE)
		cos_ang= math.cos(diff_angle); sin_ang= math.sin(diff_angle)
		vx,vy,vz=  (vx*cos_ang-vz*sin_ang, vy, vx*sin_ang+vz*cos_ang)
		
		# Reorient and Link the sword to the missile
		weapon.Orientation=0.707107,0.707107,0.000000,0.000000
		weapon.RotateRel(0,0,0, 0,-1,0, 3.14159/2.0)
		weapon.RotateRel(0,0,0, -1,0,0, (3.0*3.14159/2.0)-anglexz)
		weapon.RotateRel(0,0,0, 0,-1,0, -angley)
		
		weapon.Position=0, 0, 0
		missile.Link(weapon)
		AuxFuncs.FadeObject(weapon.Name, weapon.Alpha, 0.01, self.FadeTime)
		AuxFuncs.ColorObject(missile.Name, missile.Color, (190,90,90), self.FadeTime*2.0)
		missile.Velocity= vx,vy,vz
		
		prtl=Bladex.CreateEntity(weapon.Name+"TrailParticles"+`self.Age`, "Entity Particle System Dobj", 0, 0, 0)
		prtl.ObjectName=weapon.Name
		prtl.ParticleType="LargeFire"
		prtl.PPS=800
		prtl.Velocity=0.0, 0.0, 0.0
		prtl.NormalVelocity=14.0
		prtl.RandomVelocity=4.0
		prtl.YGravity=0.0
		prtl.Friction=0.01
		prtl.FollowFactor=0.0
		prtl.Time2Live=30
		
		self.WhileSound.PlaySound(-1)
		
		Reference.EntitiesObjectData[missile.Name]= Reference.DefaultObjectData[weapon.Kind]
		missile.OnHitFunc= self.MissileOnHitFunc
		missile.Data.ThrownBy= owner  		# this pointer may not be valid
		missile.InflictHitFunc= self.BladeSwordInflictHitFunc
		weapon.InflictHitFunc= self.BladeSwordInflictHitFunc
		
	def BladeSwordInflictHitFunc(self, EntityName, VictimName, ImpX, ImpY, ImpZ):
		if self.missileName:
			self.MissileOnHitFunc (self.missileName, VictimName)
	
	def DeleteMissileData(self):
		if self.missileName and Reference.EntitiesObjectData.has_key(self.missileName):
			del Reference.EntitiesObjectData[self.missileName]
			self.missileName= ""
			
	def MissileOnHitFunc (self, EntityName, hit_entity):
		time=Bladex.GetTime()
		if time==self.LastHitTime:
			return
		if hit_entity:
			#print EntityName+" hitting "+hit_entity
			pass
		else:
			pass
			#print EntityName+" hitting world"
		missile= Bladex.GetEntity(EntityName)
		weapon= Bladex.GetEntity(self.Name)
		if weapon: weapon.Data.InflictHitFunc=0
		if missile and weapon:
			Bladex.AddScheduledFunc(time, self.DeleteMissileData, (), "DeleteMissileData")
			prtl=Bladex.GetEntity(weapon.Name+"TrailParticles"+`self.Age`)
			if prtl:
				prtl.DeathTime=Bladex.GetTime()
			missile.Unlink(weapon)
			missile.Stop()
			missile.SubscribeToList("Pin")
			weapon.RemoveFromWorld()####################################################new bit
			self.WhileSound.StopSound()
			self.ImpactSound.Position=weapon.Position
			self.ImpactSound.PlaySound(0)
			owner= Bladex.GetEntity(self.OwnerName)
			if owner:
				inv= owner.GetInventory()
				flag=Reference.GiveWeaponFlag(weapon.Name)
				#inv.AddWeapon(weapon.Name,flag)
				blaura=Bladex.GetEntity(weapon.Name+"Aura")
				bllight=Bladex.GetEntity(weapon.Name+"Light")
				if not owner.InvRight:
					#inv.LinkRightHand(weapon.Name)	
					AuxFuncs.FadeObject(weapon.Name, 0.01, 1.0, self.FadeTime)
					if blaura:
						AuxFuncs.FadeAndScaleAura(blaura.Name, 250.0, 80.0, 0.01, 1.0, self.FadeTime)
					if bllight:
						AuxFuncs.SpotIntensityVariation(bllight.Name, 0.0, 1.0, self.FadeTime)
				else:
					weapon.Alpha= 1.0
					if blaura:
						blaura.SetAuraParams(80.0, 1.0, 1, 0, 0, 1)
					if bllight:
						bllight.Intensity=1.0
					weapon.RemoveFromWorld()
##########################################################################
####################blade of the Godess###################################
class Dagger(ActivateableSpecialWeapon):

	
	def __init__(self, me):
		ActivateableSpecialWeapon.__init__(self, me)
		#self.SpecialExtraDamage= [["Light", +1200],]
		me.Weapon= 1
		self.Age= 0
		self.FadeTime= 1.0
		self.Speed= 10000.0
		self.missileName= ""
		self.LastHitTime=-1
		self.AuxFuncsData=None
		
		self.WhileSound=Bladex.CreateEntity (me.Name+"MissileLoopSound", "Entity Sound", 0, 0, 0)
		self.WhileSound.SetSound("..\\..\\Sounds\\energy-ball.wav")
		self.WhileSound.MinDistance=5000
		self.WhileSound.MaxDistance=30000
		me.Link(self.WhileSound)
		
		self.ImpactSound=Bladex.CreateEntity (me.Name+"MissileImpactSound", "Entity Sound", 0, 0, 0)
		self.ImpactSound.SetSound("..\\..\\Sounds\\energy-ball-impact.wav")
		self.ImpactSound.MinDistance=5000
		self.ImpactSound.MaxDistance=30000
		self.OwnerName= ""


	def __getstate__(self):
		state= ActivateableSpecialWeapon.__getstate__(self)
		state[1]["Dagger"]=   (self.Age,
									self.FadeTime,
									self.Speed,
									self.missileName,
									self.LastHitTime,
									self.WhileSound.Name,
									self.ImpactSound.Name,
									self.AuxFuncsData,
									self.OwnerName
									)
		return state
		
	def __setstate__(self,parm):
		ActivateableSpecialWeapon.__setstate__(self,parm)
		if parm[0]==1:
			parms=parm[1]["Dagger"]
			self.Age=parms[0]
			self.FadeTime= parms[1]
			self.Speed=parms[2]
			self.missileName= parms[3]
			self.LastHitTime= parms[4]
			self.WhileSound= Bladex.GetEntity(parms[5])
			self.ImpactSound= Bladex.GetEntity(parms[6])
			self.AuxFuncsData= parms[7]
			self.OwnerName=  parms[8]
		else:
			self.Age=0
			self.FadeTime= 1.0
			self.Speed= 10000.0
			self.missileName= ""
			self.LastHitTime=-1
			self.WhileSound= Bladex.GetEntity(self.Name+"MissileLoopSound")
			self.ImpactSound= Bladex.GetEntity(self.Name+"MissileImpactSound")
			self.AuxFuncsData= None
			self.OwnerName= "Player1"
		
		weapon=  Bladex.GetEntity(self.Name)
		#if weapon:
		#	weapon.OnStopFunc=self.StartBackToPlayer
		
		if self.missileName:
			missile= Bladex.GetEntity(self.missileName)
			if missile:
				missile.InflictHitFunc= self.BladeSwordInflictHitFunc
				missile.OnHitFunc= self.MissileOnHitFunc
				if weapon:
					weapon.InflictHitFunc= self.BladeSwordInflictHitFunc
			else:
				print "Missile "+self.missileName+" unavailable for linking...."

	
	def DropReleaseEventHandler (self,EntityName,EventName):
		weapon= Bladex.GetEntity(self.Name)
		if not weapon:
			return
		self.OwnerName= weapon.Parent
		if not self.OwnerName:
			return		
		owner=Bladex.GetEntity(self.OwnerName)
		if not owner or owner.InvRight != self.Name:
			return	
		if weapon.TestHit:
			return
		Actions.RemoveFromInventory (owner, weapon, EventName)
		ix, iy, iz = owner.Rel2AbsVector(-1000.0, -1500.0, 0.0)
		weapon.Impulse(ix, iy, iz)
		weapon.ExcludeHitFor(owner)
		owner.DelAnmEventFunc(EventName)
	
	def ThrowReleaseEventHandler (self,EntityName,EventName):
		weapon= Bladex.GetEntity(self.Name)
		if not weapon:
			return
		self.OwnerName= weapon.Parent
		if not self.OwnerName:
			return
		owner=Bladex.GetEntity(self.OwnerName)
		if not owner or owner.InvRight != self.Name:
			return
		
		if weapon.TestHit:
			return
		
		Actions.RemoveFromInventory (owner, weapon, EventName)
		
		# Create a magic missile
		self.Age= self.Age+1
		x,y,z= weapon.Position
		missile= Bladex.CreateEntity(self.Name+"_Missile_"+`self.Age`, "Entity Magic Missile", x,y,z)
		InitDataField.Initialise(missile)
		missile.CastShadows=0
		missile.Color=0, 0, 0
		#missile.Visible=0
		self.missileName= missile.Name
		
		# Set the velocity of the missile
		if owner.ActiveEnemy:
			enemy= Bladex.GetEntity(owner.ActiveEnemy)
			if enemy and enemy.Person:
				tx1,ty1,tz1= enemy.GraspPos ("ViewPoint")
				tx2,ty2,tz2= enemy.Position
				tx= (tx1+tx2)/2.0; ty= (ty1+ty2)/2.0; tz= (tz1+tz2)/2.0; 
			else:
				tx,ty,tz= owner.Rel2AbsPoint(0,-30000.0,0.0)
		else:
			tx,ty,tz= owner.Rel2AbsPoint(0,-30000.0,0.0)
		
		angley= -B3DLib.GetYAngle(tx-x,ty-y,tz-z)
		vx,vy,vz= owner.Rel2AbsVector(0.0, -math.cos(angley)*self.Speed, -math.sin(angley)*self.Speed)
		
		anglexz= B3DLib.Pos2PosXZAngle(x,y,z,tx,ty,tz)
		diff_angle= min (max (B3DLib.DiffAngle(anglexz, owner.Angle), -Actions.FACINGANGLE), Actions.FACINGANGLE)
		cos_ang= math.cos(diff_angle); sin_ang= math.sin(diff_angle)
		vx,vy,vz=  (vx*cos_ang-vz*sin_ang, vy, vx*sin_ang+vz*cos_ang)
		
		# Reorient and Link the sword to the missile
		weapon.Orientation=0.707107,0.707107,0.000000,0.000000
		weapon.RotateRel(0,0,0, 0,-1,0, 3.14159/2.0)
		weapon.RotateRel(0,0,0, -1,0,0, (3.0*3.14159/2.0)-anglexz)
		weapon.RotateRel(0,0,0, 0,-1,0, -angley)
		
		weapon.Position=0, 0, 0
		missile.Link(weapon)
		AuxFuncs.FadeObject(weapon.Name, weapon.Alpha, 0.01, self.FadeTime)
		AuxFuncs.ColorObject(missile.Name, missile.Color, (90,220,90), self.FadeTime*2.0)
		missile.Velocity= vx,vy,vz
		
		prtl=Bladex.CreateEntity(weapon.Name+"TrailParticles"+`self.Age`, "Entity Particle System Dobj", 0, 0, 0)
		prtl.ObjectName=weapon.Name
		prtl.ParticleType="BladeSwordMissile"
		prtl.PPS=800
		prtl.Velocity=0.0, 0.0, 0.0
		prtl.NormalVelocity=14.0
		prtl.RandomVelocity=4.0
		prtl.YGravity=0.0
		prtl.Friction=0.01
		prtl.FollowFactor=0.0
		prtl.Time2Live=30
		
		self.WhileSound.PlaySound(-1)
		
		Reference.EntitiesObjectData[missile.Name]= Reference.DefaultObjectData[weapon.Kind]
		missile.OnHitFunc= self.MissileOnHitFunc
		missile.Data.ThrownBy= owner  		# this pointer may not be valid
		missile.InflictHitFunc= self.BladeSwordInflictHitFunc
		weapon.InflictHitFunc= self.BladeSwordInflictHitFunc
		
	def BladeSwordInflictHitFunc(self, EntityName, VictimName, ImpX, ImpY, ImpZ):
		if self.missileName:
			self.MissileOnHitFunc (self.missileName, VictimName)
	
	def DeleteMissileData(self):
		if self.missileName and Reference.EntitiesObjectData.has_key(self.missileName):
			del Reference.EntitiesObjectData[self.missileName]
			self.missileName= ""
			
	def MissileOnHitFunc (self, EntityName, hit_entity):
		time=Bladex.GetTime()
		if time==self.LastHitTime:
			return
		if hit_entity:
			#print EntityName+" hitting "+hit_entity
			pass
		else:
			pass
			#print EntityName+" hitting world"
		missile= Bladex.GetEntity(EntityName)
		weapon= Bladex.GetEntity(self.Name)
		if weapon: weapon.Data.InflictHitFunc=0
		if missile and weapon:
			Bladex.AddScheduledFunc(time, self.DeleteMissileData, (), "DeleteMissileData")
			prtl=Bladex.GetEntity(weapon.Name+"TrailParticles"+`self.Age`)
			if prtl:
				prtl.DeathTime=Bladex.GetTime()
			missile.Unlink(weapon)
			missile.Stop()
			missile.SubscribeToList("Pin")
			weapon.RemoveFromWorld()####################################################new bit
			self.WhileSound.StopSound()
			self.ImpactSound.Position=weapon.Position
			self.ImpactSound.PlaySound(0)
			owner= Bladex.GetEntity(self.OwnerName)
			if owner:
				inv= owner.GetInventory()
				flag=Reference.GiveWeaponFlag(weapon.Name)
				#inv.AddWeapon(weapon.Name,flag)
				blaura=Bladex.GetEntity(weapon.Name+"Aura")
				bllight=Bladex.GetEntity(weapon.Name+"Light")
				if not owner.InvRight:
					#inv.LinkRightHand(weapon.Name)#stop return to player	
					AuxFuncs.FadeObject(weapon.Name, 0.01, 1.0, self.FadeTime)
					if blaura:
						AuxFuncs.FadeAndScaleAura(blaura.Name, 250.0, 80.0, 0.01, 1.0, self.FadeTime)
					if bllight:
						AuxFuncs.SpotIntensityVariation(bllight.Name, 0.0, 1.0, self.FadeTime)
				else:
					weapon.Alpha= 1.0
					if blaura:
						blaura.SetAuraParams(80.0, 1.0, 1, 0, 0, 1)
					if bllight:
						bllight.Intensity=1.0
					weapon.RemoveFromWorld()

####################################################################################################
###########################cyanide star#############################################################


class Suriken(ActivateableSpecialWeapon):

	
	def __init__(self, me):
		ActivateableSpecialWeapon.__init__(self, me)
		#self.SpecialExtraDamage= [["Light", +1200],]
		me.Weapon= 1
		self.Age= 0
		self.FadeTime= 1.0
		self.Speed= 10000.0
		self.missileName= ""
		self.LastHitTime=-1
		self.AuxFuncsData=None
		
		self.WhileSound=Bladex.CreateEntity (me.Name+"MissileLoopSound", "Entity Sound", 0, 0, 0)
		self.WhileSound.SetSound("..\\..\\Sounds\\vueltas-en-el-aire.wav")
		self.WhileSound.MinDistance=5000
		self.WhileSound.MaxDistance=30000
		me.Link(self.WhileSound)
		
		self.ImpactSound=Bladex.CreateEntity (me.Name+"MissileImpactSound", "Entity Sound", 0, 0, 0)
		self.ImpactSound.SetSound("..\\..\\Sounds\\energy-ball-impact.wav")
		self.ImpactSound.MinDistance=5000
		self.ImpactSound.MaxDistance=30000
		self.OwnerName= ""


	def __getstate__(self):
		state= ActivateableSpecialWeapon.__getstate__(self)
		state[1]["Suriken"]=   (self.Age,
									self.FadeTime,
									self.Speed,
									self.missileName,
									self.LastHitTime,
									self.WhileSound.Name,
									self.ImpactSound.Name,
									self.AuxFuncsData,
									self.OwnerName
									)
		return state
		
	def __setstate__(self,parm):
		ActivateableSpecialWeapon.__setstate__(self,parm)
		if parm[0]==1:
			parms=parm[1]["Suriken"]
			self.Age=parms[0]
			self.FadeTime= parms[1]
			self.Speed=parms[2]
			self.missileName= parms[3]
			self.LastHitTime= parms[4]
			self.WhileSound= Bladex.GetEntity(parms[5])
			self.ImpactSound= Bladex.GetEntity(parms[6])
			self.AuxFuncsData= parms[7]
			self.OwnerName=  parms[8]
		else:
			self.Age=0
			self.FadeTime= 1.0
			self.Speed= 10000.0
			self.missileName= ""
			self.LastHitTime=-1
			self.WhileSound= Bladex.GetEntity(self.Name+"MissileLoopSound")
			self.ImpactSound= Bladex.GetEntity(self.Name+"MissileImpactSound")
			self.AuxFuncsData= None
			self.OwnerName= "Player1"
		
		weapon=  Bladex.GetEntity(self.Name)
		#if weapon:
		#	weapon.OnStopFunc=self.StartBackToPlayer
		
		if self.missileName:
			missile= Bladex.GetEntity(self.missileName)
			if missile:
				missile.InflictHitFunc= self.BladeSwordInflictHitFunc
				missile.OnHitFunc= self.MissileOnHitFunc
				if weapon:
					weapon.InflictHitFunc= self.BladeSwordInflictHitFunc
			else:
				print "Missile "+self.missileName+" unavailable for linking...."

	
	def DropReleaseEventHandler (self,EntityName,EventName):
		weapon= Bladex.GetEntity(self.Name)
		if not weapon:
			return
		self.OwnerName= weapon.Parent
		if not self.OwnerName:
			return		
		owner=Bladex.GetEntity(self.OwnerName)
		if not owner or owner.InvRight != self.Name:
			return	
		if weapon.TestHit:
			return
		Actions.RemoveFromInventory (owner, weapon, EventName)
		ix, iy, iz = owner.Rel2AbsVector(-1000.0, -1500.0, 0.0)
		weapon.Impulse(ix, iy, iz)
		weapon.ExcludeHitFor(owner)
		owner.DelAnmEventFunc(EventName)
	
	def ThrowReleaseEventHandler (self,EntityName,EventName):
		weapon= Bladex.GetEntity(self.Name)
		if not weapon:
			return
		self.OwnerName= weapon.Parent
		if not self.OwnerName:
			return
		owner=Bladex.GetEntity(self.OwnerName)
		if not owner or owner.InvRight != self.Name:
			return
		
		if weapon.TestHit:
			return
		
		Actions.RemoveFromInventory (owner, weapon, EventName)
		
		# Create a magic missile
		self.Age= self.Age+1
		x,y,z= weapon.Position
		missile= Bladex.CreateEntity(self.Name+"_Missile_"+`self.Age`, "Entity Magic Missile", x,y,z)
		InitDataField.Initialise(missile)
		missile.CastShadows=0
		missile.Color=0, 0, 0
		#missile.Visible=0
		self.missileName= missile.Name
		
		# Set the velocity of the missile
		if owner.ActiveEnemy:
			enemy= Bladex.GetEntity(owner.ActiveEnemy)
			if enemy and enemy.Person:
				tx1,ty1,tz1= enemy.GraspPos ("ViewPoint")
				tx2,ty2,tz2= enemy.Position
				tx= (tx1+tx2)/2.0; ty= (ty1+ty2)/2.0; tz= (tz1+tz2)/2.0; 
			else:
				tx,ty,tz= owner.Rel2AbsPoint(0,-30000.0,0.0)
		else:
			tx,ty,tz= owner.Rel2AbsPoint(0,-30000.0,0.0)
		
		angley= -B3DLib.GetYAngle(tx-x,ty-y,tz-z)
		vx,vy,vz= owner.Rel2AbsVector(0.0, -math.cos(angley)*self.Speed, -math.sin(angley)*self.Speed)
		
		anglexz= B3DLib.Pos2PosXZAngle(x,y,z,tx,ty,tz)
		diff_angle= min (max (B3DLib.DiffAngle(anglexz, owner.Angle), -Actions.FACINGANGLE), Actions.FACINGANGLE)
		cos_ang= math.cos(diff_angle); sin_ang= math.sin(diff_angle)
		vx,vy,vz=  (vx*cos_ang-vz*sin_ang, vy, vx*sin_ang+vz*cos_ang)
		
		# Reorient and Link the sword to the missile
		weapon.Orientation=0.707107,0.707107,0.000000,0.000000
		weapon.RotateRel(0,0,0, 0,-1,0, 3.14159/2.0)
		weapon.RotateRel(0,0,0, -1,0,0, (3.0*3.14159/2.0)-anglexz)
		weapon.RotateRel(0,0,0, 0,-1,0, -angley)
		
		weapon.Position=0, 0, 0
		missile.Link(weapon)
		AuxFuncs.FadeObject(weapon.Name, weapon.Alpha, 0.01, self.FadeTime)
		AuxFuncs.ColorObject(missile.Name, missile.Color, (90,220,90), self.FadeTime*2.0)
		missile.Velocity= vx,vy,vz
		
		prtl=Bladex.CreateEntity(weapon.Name+"TrailParticles"+`self.Age`, "Entity Particle System Dobj", 0, 0, 0)
		prtl.ObjectName=weapon.Name
		prtl.ParticleType="GasVenenoso"
		prtl.PPS=800
		prtl.Velocity=0.0, 0.0, 0.0
		prtl.NormalVelocity=14.0
		prtl.RandomVelocity=4.0
		prtl.YGravity=0.0
		prtl.Friction=0.01
		prtl.FollowFactor=0.0
		prtl.Time2Live=30
		
		self.WhileSound.PlaySound(-1)
		
		Reference.EntitiesObjectData[missile.Name]= Reference.DefaultObjectData[weapon.Kind]
		missile.OnHitFunc= self.MissileOnHitFunc
		missile.Data.ThrownBy= owner  		# this pointer may not be valid
		missile.InflictHitFunc= self.BladeSwordInflictHitFunc
		weapon.InflictHitFunc= self.BladeSwordInflictHitFunc
		
	def BladeSwordInflictHitFunc(self, EntityName, VictimName, ImpX, ImpY, ImpZ):
		if self.missileName:
			self.MissileOnHitFunc (self.missileName, VictimName)
	
	def DeleteMissileData(self):
		if self.missileName and Reference.EntitiesObjectData.has_key(self.missileName):
			del Reference.EntitiesObjectData[self.missileName]
			self.missileName= ""
			
	def MissileOnHitFunc (self, EntityName, hit_entity):
		time=Bladex.GetTime()
		if time==self.LastHitTime:
			return
		if hit_entity:
			#print EntityName+" hitting "+hit_entity
			pass
		else:
			pass
			#print EntityName+" hitting world"
		missile= Bladex.GetEntity(EntityName)
		weapon= Bladex.GetEntity(self.Name)
		if weapon: weapon.Data.InflictHitFunc=0
		if missile and weapon:
			Bladex.AddScheduledFunc(time, self.DeleteMissileData, (), "DeleteMissileData")
			prtl=Bladex.GetEntity(weapon.Name+"TrailParticles"+`self.Age`)
			if prtl:
				prtl.DeathTime=Bladex.GetTime()
			missile.Unlink(weapon)
			missile.Stop()
			missile.SubscribeToList("Pin")
			weapon.RemoveFromWorld()#######################################################
			self.WhileSound.StopSound()
			self.ImpactSound.Position=weapon.Position
			self.ImpactSound.PlaySound(0)
			owner= Bladex.GetEntity(self.OwnerName)
			if owner:
				inv= owner.GetInventory()
				flag=Reference.GiveWeaponFlag(weapon.Name)
				#inv.AddWeapon(weapon.Name,flag)#stops everlasting effect
				blaura=Bladex.GetEntity(weapon.Name+"Aura")
				bllight=Bladex.GetEntity(weapon.Name+"Light")
				if not owner.InvRight:
					#inv.LinkRightHand(weapon.Name)#stop return to player	
					AuxFuncs.FadeObject(weapon.Name, 0.01, 1.0, self.FadeTime)
					if blaura:
						AuxFuncs.FadeAndScaleAura(blaura.Name, 250.0, 80.0, 0.01, 1.0, self.FadeTime)
					if bllight:
						AuxFuncs.SpotIntensityVariation(bllight.Name, 0.0, 1.0, self.FadeTime)
				else:
					weapon.Alpha= 1.0
					if blaura:
						blaura.SetAuraParams(80.0, 1.0, 1, 0, 0, 1)
					if bllight:
						bllight.Intensity=1.0
					weapon.RemoveFromWorld()

#####################################################################################################
##############################phurbhu

class Phurbhu(ActivateableSpecialWeapon):

	
	def __init__(self, me):
		ActivateableSpecialWeapon.__init__(self, me)
		#self.SpecialExtraDamage= [["Light", +1200],]
		me.Weapon= 1
		self.Age= 0
		self.FadeTime= 1.0
		self.Speed= 10000.0
		self.missileName= ""
		self.LastHitTime=-1
		self.AuxFuncsData=None
		
		self.WhileSound=Bladex.CreateEntity (me.Name+"MissileLoopSound", "Entity Sound", 0, 0, 0)
		self.WhileSound.SetSound("..\\..\\Sounds\\electric-eels.wav")
		self.WhileSound.MinDistance=5000
		self.WhileSound.MaxDistance=30000
		me.Link(self.WhileSound)
		
		self.ImpactSound=Bladex.CreateEntity (me.Name+"MissileImpactSound", "Entity Sound", 0, 0, 0)
		self.ImpactSound.SetSound("..\\..\\Sounds\\energy-ball-impact.wav")
		self.ImpactSound.MinDistance=5000
		self.ImpactSound.MaxDistance=30000
		self.OwnerName= ""


	def __getstate__(self):
		state= ActivateableSpecialWeapon.__getstate__(self)
		state[1]["Phurbhu"]=   (self.Age,
									self.FadeTime,
									self.Speed,
									self.missileName,
									self.LastHitTime,
									self.WhileSound.Name,
									self.ImpactSound.Name,
									self.AuxFuncsData,
									self.OwnerName
									)
		return state
		
	def __setstate__(self,parm):
		ActivateableSpecialWeapon.__setstate__(self,parm)
		if parm[0]==1:
			parms=parm[1]["Phurbhu"]
			self.Age=parms[0]
			self.FadeTime= parms[1]
			self.Speed=parms[2]
			self.missileName= parms[3]
			self.LastHitTime= parms[4]
			self.WhileSound= Bladex.GetEntity(parms[5])
			self.ImpactSound= Bladex.GetEntity(parms[6])
			self.AuxFuncsData= parms[7]
			self.OwnerName=  parms[8]
		else:
			self.Age=0
			self.FadeTime= 1.0
			self.Speed= 10000.0
			self.missileName= ""
			self.LastHitTime=-1
			self.WhileSound= Bladex.GetEntity(self.Name+"MissileLoopSound")
			self.ImpactSound= Bladex.GetEntity(self.Name+"MissileImpactSound")
			self.AuxFuncsData= None
			self.OwnerName= "Player1"
		
		weapon=  Bladex.GetEntity(self.Name)
		#if weapon:
		#	weapon.OnStopFunc=self.StartBackToPlayer
		
		if self.missileName:
			missile= Bladex.GetEntity(self.missileName)
			if missile:
				missile.InflictHitFunc= self.BladeSwordInflictHitFunc
				missile.OnHitFunc= self.MissileOnHitFunc
				if weapon:
					weapon.InflictHitFunc= self.BladeSwordInflictHitFunc
			else:
				print "Missile "+self.missileName+" unavailable for linking...."

	
	def DropReleaseEventHandler (self,EntityName,EventName):
		weapon= Bladex.GetEntity(self.Name)
		if not weapon:
			return
		self.OwnerName= weapon.Parent
		if not self.OwnerName:
			return		
		owner=Bladex.GetEntity(self.OwnerName)
		if not owner or owner.InvRight != self.Name:
			return	
		if weapon.TestHit:
			return
		Actions.RemoveFromInventory (owner, weapon, EventName)
		ix, iy, iz = owner.Rel2AbsVector(-1000.0, -1500.0, 0.0)
		weapon.Impulse(ix, iy, iz)
		weapon.ExcludeHitFor(owner)
		owner.DelAnmEventFunc(EventName)
	
	def ThrowReleaseEventHandler (self,EntityName,EventName):
		weapon= Bladex.GetEntity(self.Name)
		if not weapon:
			return
		self.OwnerName= weapon.Parent
		if not self.OwnerName:
			return
		owner=Bladex.GetEntity(self.OwnerName)
		if not owner or owner.InvRight != self.Name:
			return
		
		if weapon.TestHit:
			return
		
		Actions.RemoveFromInventory (owner, weapon, EventName)
		
		# Create a magic missile
		self.Age= self.Age+1
		x,y,z= weapon.Position
		missile= Bladex.CreateEntity(self.Name+"_Missile_"+`self.Age`, "Entity Magic Missile", x,y,z)
		InitDataField.Initialise(missile)
		missile.CastShadows=0
		missile.Color=0, 0, 0
		#missile.Visible=0
		self.missileName= missile.Name
		
		# Set the velocity of the missile
		if owner.ActiveEnemy:
			enemy= Bladex.GetEntity(owner.ActiveEnemy)
			if enemy and enemy.Person:
				tx1,ty1,tz1= enemy.GraspPos ("ViewPoint")
				tx2,ty2,tz2= enemy.Position
				tx= (tx1+tx2)/2.0; ty= (ty1+ty2)/2.0; tz= (tz1+tz2)/2.0; 
			else:
				tx,ty,tz= owner.Rel2AbsPoint(0,-30000.0,0.0)
		else:
			tx,ty,tz= owner.Rel2AbsPoint(0,-30000.0,0.0)
		
		angley= -B3DLib.GetYAngle(tx-x,ty-y,tz-z)
		vx,vy,vz= owner.Rel2AbsVector(0.0, -math.cos(angley)*self.Speed, -math.sin(angley)*self.Speed)
		
		anglexz= B3DLib.Pos2PosXZAngle(x,y,z,tx,ty,tz)
		diff_angle= min (max (B3DLib.DiffAngle(anglexz, owner.Angle), -Actions.FACINGANGLE), Actions.FACINGANGLE)
		cos_ang= math.cos(diff_angle); sin_ang= math.sin(diff_angle)
		vx,vy,vz=  (vx*cos_ang-vz*sin_ang, vy, vx*sin_ang+vz*cos_ang)
		
		# Reorient and Link the sword to the missile
		weapon.Orientation=0.707107,0.707107,0.000000,0.000000
		weapon.RotateRel(0,0,0, 0,-1,0, 3.14159/2.0)
		weapon.RotateRel(0,0,0, -1,0,0, (3.0*3.14159/2.0)-anglexz)
		weapon.RotateRel(0,0,0, 0,-1,0, -angley)
		
		weapon.Position=0, 0, 0
		missile.Link(weapon)
		AuxFuncs.FadeObject(weapon.Name, weapon.Alpha, 0.01, self.FadeTime)
		AuxFuncs.ColorObject(missile.Name, missile.Color, (90,220,90), self.FadeTime*2.0)
		missile.Velocity= vx,vy,vz
		
		prtl=Bladex.CreateEntity(weapon.Name+"TrailParticles"+`self.Age`, "Entity Particle System Dobj", 0, 0, 0)
		prtl.ObjectName=weapon.Name
		prtl.ParticleType="SnowDust"
		prtl.PPS=800
		prtl.Velocity=0.0, 0.0, 0.0
		prtl.NormalVelocity=14.0
		prtl.RandomVelocity=4.0
		prtl.YGravity=0.0
		prtl.Friction=0.01
		prtl.FollowFactor=0.0
		prtl.Time2Live=30
		
		self.WhileSound.PlaySound(-1)
		
		Reference.EntitiesObjectData[missile.Name]= Reference.DefaultObjectData[weapon.Kind]
		missile.OnHitFunc= self.MissileOnHitFunc
		missile.Data.ThrownBy= owner  		# this pointer may not be valid
		missile.InflictHitFunc= self.BladeSwordInflictHitFunc
		weapon.InflictHitFunc= self.BladeSwordInflictHitFunc
		
	def BladeSwordInflictHitFunc(self, EntityName, VictimName, ImpX, ImpY, ImpZ):
		if self.missileName:
			self.MissileOnHitFunc (self.missileName, VictimName)
	
	def DeleteMissileData(self):
		if self.missileName and Reference.EntitiesObjectData.has_key(self.missileName):
			del Reference.EntitiesObjectData[self.missileName]
			self.missileName= ""
			
	def MissileOnHitFunc (self, EntityName, hit_entity):
		time=Bladex.GetTime()
		if time==self.LastHitTime:
			return
		if hit_entity:
			#print EntityName+" hitting "+hit_entity
			pass
		else:
			pass
			#print EntityName+" hitting world"
		missile= Bladex.GetEntity(EntityName)
		weapon= Bladex.GetEntity(self.Name)
		if weapon: weapon.Data.InflictHitFunc=0
		if missile and weapon:
			Bladex.AddScheduledFunc(time, self.DeleteMissileData, (), "DeleteMissileData")
			prtl=Bladex.GetEntity(weapon.Name+"TrailParticles"+`self.Age`)
			if prtl:
				prtl.DeathTime=Bladex.GetTime()
			missile.Unlink(weapon)
			missile.Stop()
			missile.SubscribeToList("Pin")
			weapon.RemoveFromWorld()#######################################################
			self.WhileSound.StopSound()
			self.ImpactSound.Position=weapon.Position
			self.ImpactSound.PlaySound(0)
			owner= Bladex.GetEntity(self.OwnerName)
			if owner:
				inv= owner.GetInventory()
				flag=Reference.GiveWeaponFlag(weapon.Name)
				#inv.AddWeapon(weapon.Name,flag)#stops everlasting effect
				blaura=Bladex.GetEntity(weapon.Name+"Aura")
				bllight=Bladex.GetEntity(weapon.Name+"Light")
				if not owner.InvRight:
					#inv.LinkRightHand(weapon.Name)#stop return to player	
					AuxFuncs.FadeObject(weapon.Name, 0.01, 1.0, self.FadeTime)
					if blaura:
						AuxFuncs.FadeAndScaleAura(blaura.Name, 250.0, 80.0, 0.01, 1.0, self.FadeTime)
					if bllight:
						AuxFuncs.SpotIntensityVariation(bllight.Name, 0.0, 1.0, self.FadeTime)
				else:
					weapon.Alpha= 1.0
					if blaura:
						blaura.SetAuraParams(80.0, 1.0, 1, 0, 0, 1)
					if bllight:
						bllight.Intensity=1.0
					weapon.RemoveFromWorld()


	
	

	
	
			
	
		
