#******************************************************************************************
#******************************************************************************************
# DefFuncs.py   ->  fichero de definicion de funciones
#******************************************************************************************
#******************************************************************************************

# Imports necesarios
import Actions
#import AbreCam
#import AniSound
import Auras
import AuxFuncs
import B3DLib
import Basic_Funcs
import Bladex
import Breakings
#import Button
import CharStats
import darfuncs
#import def_class
import Doors
import EnemyTypes
#import Enm_Gen
import EnmGenRnd
import GameText
#import GotoMapVars
import heavyObjects
import ItemTypes
import Language
import Levers
import Locks
from math import pow
#import MenuText
import Menu
#import MusicTool
#import NetSounds
import Objects
import ObjStore
import Ontake
#import pdb
import pocimac
#import ReadGSFile
import Reference
#import Room
import Scorer
#import ScriptSkip
import Sounds
import stone
import Stars
import Sparks
import Torchs
#import Traps_C


#####################################
## Habilitar la opcion de salvar
if Language.Current == 'Spanish':
	GameText.MapList['HERESY'] = 'Herejia';
else:
	GameText.MapList['HERESY'] = 'Heresy';
#####################################

#####################################
## Situacion del SOL -> 87 80 -15
Bladex.SetSun(1, 87, 80, -15)
#####################################


###############################
#------- traduc.py ------------------
#--------------------------------------------------
#

#---- Funcion para la traduccion de los textos del nivel
def Traduce(cadena):
	global Diccionario
	return Diccionario[cadena]
#---- 

#
###############################

###############################
#------- animaciones.py ------------------
#--------------------------------------------------
#

## Funciones genericas
#---- Funcion de Keoh para encapsular la llamada a los movimientos de camara
def muevecamara(cuerpoinicial,mirillainicial,cuerpofinal,mirillafinal,tiempo,funcion):	
	cam1=Bladex.GetEntity("Camera")
	AuxFuncs.MoveCamFromTo(cuerpoinicial[0], cuerpoinicial[1], cuerpoinicial[2], cuerpofinal[0], cuerpofinal[1], cuerpofinal[2], mirillainicial[0], mirillainicial[1], mirillainicial[2], mirillafinal[0], mirillafinal[1], mirillafinal[2], tiempo,funcion)
#----

#---- Funcion para subir a una persona de nivel (los valore son de Keoh xD)
def SubirdeNivel(name):
	pers = Bladex.GetEntity(name)
	if pers.Level < 18:
		t = Bladex.GetTime()
		aura=Auras.MakeAura(name, 2.0, (1, 0.01, 1.0, 0, 0, 1),(),(),(2,  0.8, 0.9, 1.0, 0.6, 0.3  ,  0.2, 0.6, 0.8, 0.4, 1.0))
		aura.Data.AddEvent(t + 0.75,(30, 1.0, 1.0, 0, 0, 1),(),(),(2,  0.4, 0.9, 0.5, 0.6, 0.3  ,  0.2, 0.6, 0.8, 0.4, 1.0))
		aura.Data.AddEvent(t + 2.0,(240, 0.01, 1.0, 0, 0, 1),(),(),(2,  0.9, 0.2, 0.2, 0.6, 0.4  ,  0.0, 0.0, 0.6, 0.4, 0.5))
	
		pers.Level = pers.Level + 1
		pers.Life = CharStats.GetCharMaxLife(pers.Kind, pers.Level)
		print("un nivel mas")
#----
	
#---- Funcion que devuelve el control al jugador y realiza un fade desde negro
def FinAnimacionConFade():
	AuxFuncs.FadeFrom(2.0, 0.0)
	Scorer.SetVisible(1)
	Bladex.ActivateInput()
	AuxFuncs.ResetScene()
#----

#---- Funcion que devuelve el control al jugador
def FinAnimacion():
	Scorer.SetVisible(1)
	Bladex.ActivateInput()
	AuxFuncs.ResetScene()
#----

#---- Animacion cuando llegas desde las cuevas
def Intro1():
	Bladex.DeactivateInput()
	Scorer.SetVisible(0)
	#Actions.FreeBothHands("Player1")
	char = Bladex.GetEntity("Player1")
	#(-84688.3369997, 864.296380545, 155188.406507), antes (-85392.0922068, 909.613192136, 155207.136483)
	#5.01363145865, antes 4.91411516805
	char.Position=-85392.0922068, 909.613192136, 155207.136483
	char.Angle=4.91411516805
	### Gotos de los guevos que no funcionan
	char.GoToJogging=0
	##(-75998.3353879, 2387.10371931, 155192.825615), antes (-77392.0922068, 909.613192136, 155207.136483)
	#char.GoTo(-75035.6544643, 2430.43396262, 155755.002002)
	Bladex.AddScheduledFunc(Bladex.GetTime() + 0.1, char.GoTo, (-77392.0922068, 909.613192136, 155207.136483))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 2.0, AuxFuncs.FadeTo, (2.0, 31.0))
	GameText.WriteTextAux(Traduce("... y finalmente apareces en una maloliente cripta"),5.0,255,255,255,[])
	muevecamara(camXYZa, objXYZa, camXYZb, objXYZb, 5.0, FinAnimacionConFade)
#----

#---- Animacion cuando activas las momias de la cripta izquierda
def EscCriptaI():
	Bladex.DeactivateInput()
	Scorer.SetVisible(0)
	# Lanzo un sonido de tesioorrrrl y hago que el to se de la vuelta
	char = Bladex.GetEntity("Player1")
	char.GoToJogging=0
	char.GoTo(-69797.2432088, 2463.73111653, 156540.684339)
	Bladex.AddScheduledFunc(Bladex.GetTime() + 1.0, sndSorpresa1.Play, (char.Position[0], char.Position[1], char.Position[2], 0))
###	Bladex.AddScheduledFunc(Bladex.GetTime() + 4.0, Actions.QuickTurnToFaceEntity, ("Player1","Knight_Zombie_437"))	 ## Mira al caballero zombie
	Bladex.AddScheduledFunc(Bladex.GetTime() + 4.0, Actions.QuickTurnToFaceEntity, ("Player1", "Lich_434"))	 ## Mira al Lich_434
	muevecamara(camEscCriptaI1, objEscCriptaI1, camEscCriptaI2, objEscCriptaI2, 5.5, FinAnimacion)
#----

#---- Animacion cuando entras en la cripta real
def EscGranCripta(sectorindex, entityname):
	if entityname == "Player1":
		## Quito la funcion asociada al sector
		sencos=Bladex.GetSector(sectorindex)
		sencos.OnEnter=""

		Bladex.DeactivateInput()
		Scorer.SetVisible(0)

		char = Bladex.GetEntity("Player1")
		char.GoToJogging=0
		Actions.FreeBothHands("Player1")
		char.GoTo(-57114.6852578, 3383.77340297, 139455.350231) ## Lampara, un poco antes

		Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5, sndSuspense_1.Play, (char.Position[0], char.Position[1], char.Position[2], 0))
		Bladex.AddScheduledFunc(Bladex.GetTime() + 2.3, sndInicioCombate33.Play,  (char.Position[0], char.Position[1], char.Position[2], 0))

		#Bladex.AddScheduledFunc(Bladex.GetTime() + 6.0, Actions.TurnToFaceEntity, ("Player1","PowerPot_A")) ## Mira a la pocion de poder
		muevecamara(camEscGranCripta1, objEscGranCripta1, camEscGranCripta2, objEscGranCripta2, 3.0, EscGranCripta2)

def EscGranCripta2():
	muevecamara(camEscGranCripta2, objEscGranCripta2, camEscGranCripta3, objEscGranCripta3, 3.0, EscGranCripta3)
def EscGranCripta3():
	Actions.TurnToFaceEntity, ("Player1","PowerPot_A")
	char = Bladex.GetEntity("Player1")
	Bladex.AddScheduledFunc(Bladex.GetTime() + 0.1, GameText.WriteTextAux, (Traduce("Dios salve al rey"), 3.0,122,203,220,[]))
	char.LaunchAnmType("Kgt_fire_g")
	#char.Wuea = Reference.WUEA_ENDED
	muevecamara(camEscGranCripta3, objEscGranCripta3, camEscGranCripta3, objEscGranCripta3, 1.7, FinAnimacion)
#----

#---- Animacion cuando aparecen los vampiros en la cripta real
def EscVampirosCripta():
	Bladex.DeactivateInput()
	Scorer.SetVisible(0)

	## Los pongo a andar (no tira)
	v1=Bladex.GetEntity("Vamp_467")
	#v1.GoToJogging=0
	#v1.GoTo(-56700.0000315,3170.13820374,130013.990542)
	v2=Bladex.GetEntity("Vamp_470")
	#v2.GoToJogging=0
	#v2.GoTo(-56128.4662987,3170.13805788,130283.335429)

	## Cambio la camara
	sndSorpresa6.Play(char.Position[0], char.Position[1], char.Position[2], 0)
	muevecamara(camEscVampirosCripta1, v1.Position, camEscVampirosCripta2, v2.Position, 5.0, FinAnimacion)
#----

#---- Animacion cuando despiertan los golems
def EscGolems():
	Bladex.DeactivateInput()
	Scorer.SetVisible(0)

	char=Bladex.GetEntity("Player1")

	## Cambio la camara
	Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5, sndGolemDespierta.Play,  (char.Position[0], char.Position[1], char.Position[2], 0))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 1.5, sndGolemDespierta.Play,  (char.Position[0], char.Position[1], char.Position[2], 0))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 2.0, Actions.QuickTurnToFaceEntity, ("Player1","Golem1"))  ## Mira al golem
	muevecamara(camEscGolems, char.Position, camEscGolems, char.Position, 3.0, FinAnimacion)
#----

#---- Animacion al salir de las criptas al cementerio
def EscSalidaCriptas():
	Bladex.DeactivateInput()
	Scorer.SetVisible(0)

	char=Bladex.GetEntity("Player1")
	char.GoToJogging=0
	char.GoTo(-55907.2221616, 187.563349187, 184198.017227)

	Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5, sndInicioCombate6.Play,  (char.Position[0], char.Position[1], char.Position[2], 0))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 5.0, Actions.TurnToFaceEntity, ("Player1","Ork_494"))  ## Mira al otro orco de abajo
	Bladex.AddScheduledFunc(Bladex.GetTime() + 3.0, salCripta.CloseDoor,  ())

	muevecamara(camEscSalidaCriptas1, objEscSalidaCriptas1, camEscSalidaCriptas2, objEscSalidaCriptas2, 7.0, EscSalidaCriptas2)

def EscSalidaCriptas2():
	## Activamos los orcos del cementerio
	o=Bladex.GetEntity("Ork_491")
	o.Blind = 0
	o.Deaf = 0
	o=Bladex.GetEntity("Ork_494")
	o.Blind = 0
	o.Deaf = 0
	o=Bladex.GetEntity("Ork_501")
	o.Blind = 0
	o.Deaf = 0
#	o=Bladex.GetEntity("Ork_502")
#	o.Blind = 0
#	o.Deaf = 0
	print("despiertos en cementerio")
	muevecamara(camEscSalidaCriptas2, objEscSalidaCriptas2, camEscSalidaCriptas3, objEscSalidaCriptas3, 1.0, FinAnimacion)
#----

#---- Animacion al activar el generador del cementerio
def EscCementerio():
	Bladex.DeactivateInput()
	Scorer.SetVisible(0)

	## Los pongo a andar
	char=Bladex.GetEntity("Player1")

	Bladex.AddScheduledFunc(Bladex.GetTime() + 0.7, generadorT1.GenerateEnemy, ())
	Bladex.AddScheduledFunc(Bladex.GetTime() + 1.0, sndInicioCombate7.Play,  (char.Position[0], char.Position[1], char.Position[2], 0))

	muevecamara(camEscCementerio1, objEscCementerio1, camEscCementerio2, objEscCementerio2, 6.0, FinAnimacion)
#----

#---- Animacion al entrar en la zona del minotauro del campanario
def EscMinotauro(sectorindex, entityname):
	if entityname == "Player1":
		## Quito la funcion asociada al sector
		sencos=Bladex.GetSector(sectorindex)
		sencos.OnEnter=""
		Bladex.DeactivateInput()
		Scorer.SetVisible(0)

		## Lo pongo a andar
		char=Bladex.GetEntity("Player1")
		char.GoToJogging=0
		char.GoTo(-10066.4740337, -10033.5057898, 214959.530558)
		Bladex.AddScheduledFunc(Bladex.GetTime() + 1.5, Actions.TurnToFaceEntity, ("Player1", "MinotauroCabron"))
		Bladex.AddScheduledFunc(Bladex.GetTime() + 0.7, sndSorpresa3.Play, (char.Position[0], char.Position[1], char.Position[2], 0))
		muevecamara(camEscMinotauro1, char.Position, camEscMinotauro2, objEscMinotauro2, 6.0, EscMinotauro2)

def EscMinotauro2():
	## Aprovecho para cerrar el cementerio
	CierraRastrilloCementerio()
	char=Bladex.GetEntity("MinotauroCabron")
	objet = (char.Position[0], char.Position[1] - 3.0, char.Position[2])
	muevecamara(camEscMinotauro2, objEscMinotauro2, camEscMinotauro3, objet, 3.0, FinAnimacion)
#----


#---- Animacion al quemar la cuerda para matar al minotauro
def RematarMino():
	mino=Bladex.GetEntity("MinotauroCabron")
	if mino and mino.Life > 0:
		mino.Life = -1
		print("mino muerto con truqui")	

def EscCampana():
	Bladex.DeactivateInput()
	Scorer.SetVisible(0)

	mino = Bladex.GetEntity("MinotauroCabron")
	sndInicio23.Play(char.Position[0], char.Position[1], char.Position[2], 0)
	Bladex.AddScheduledFunc(Bladex.GetTime() + 14.9, sndCampana.Play, (mino.Position[0], mino.Position[1], mino.Position[2], 0))
	## truqui
	Bladex.AddScheduledFunc(Bladex.GetTime() + 15.5, RematarMino, ())
	muevecamara(camEscCampana1, objEscCampana1, camEscCampana2, objEscCampana2, 3.0, EscCampana2)

def EscCampana2():
	muevecamara(camEscCampana2, objEscCampana2, camEscCampana3, objEscCampana3, 3.5, EscCampana3)

def EscCampana3():
	## Pausa
	muevecamara(camEscCampana3, objEscCampana3, camEscCampana3, objEscCampana3, 1.5, EscCampana4)
def EscCampana4():
	## Salto
	muevecamara(camEscCampana4, objEscCampana4, camEscCampana5, objEscCampana5, 2.5, EscCampana5)

def EscCampana5():
	## Salto (pausa)
	## Recompensamos la resolucion del puzzle
	Bladex.AddScheduledFunc(Bladex.GetTime() + 5.0, SubirdeNivel, ("Player1", ))
	muevecamara(camEscCampana6, objEscCampana6, camEscCampana6, objEscCampana6, 4.5, FinAnimacion)
#----

#---- Animaciones en el control de las escaleras
def FinEscEscaleras():
	sector=Bladex.GetSector(30000.0, -1000.0, 142000.0)
	sector.OnEnter=ControlEscaleras
	FinAnimacion()
	print("fin esc escaleras")


## Si vale
def EscCambioTurnoEscaleras():
	Bladex.DeactivateInput()
	Scorer.SetVisible(0)

	char = Bladex.GetEntity("Player1")
	char.GoToJogging=0
	char.GoTo(33258.6831862, -1055.66432831, 142716.994114)
	Actions.FreeBothHands("Player1")
	enem = Bladex.GetEntity("K_Vigilante")
	enem.Position = (36059.2221309, -1503.95904118, 141971.685083)
	enem.Angle =0.693495530266
	t = Bladex.GetTime()
	Bladex.AddScheduledFunc(t + 1.5, GameText.WriteTextAux, (Traduce("Traigo los mapas para el jefe"), 3.0,122,203,220,[]))
	Bladex.AddScheduledFunc(t + 2.1, Actions.TurnToFaceEntity, ("Player1", "K_Vigilante"))
	Bladex.AddScheduledFunc(t + 2.5, Actions.TurnToFaceEntity, ("K_Vigilante", "Player1"))
	Bladex.AddScheduledFunc(t + 4.2, Actions.FreeBothHands, ("K_Vigilante",))
	Bladex.AddScheduledFunc(t + 4.8, GameText.WriteTextAux, (Traduce("Ya era hora...de paso me sustituyes"), 4.3 ,219,39,3,[]))
	Bladex.AddScheduledFunc(t + 7.2, enem.GoTo, (34337.3793656, -1569.71539934, 141675.342558))
	Bladex.AddScheduledFunc(t + 7.5, char.GoTo, (33210.211406, -1113.09935581, 142878.459432))
	Bladex.AddScheduledFunc(t + 10.0, Actions.TurnToFaceEntity, ("K_Vigilante", "Player1"))
	Bladex.AddScheduledFunc(t + 10.2, Actions.TurnToFaceEntity, ("Player1", "K_Vigilante"))
	Bladex.AddScheduledFunc(t + 10.5, GameText.WriteTextAux, (Traduce("Yo me voy a vacunar a mi pokemon"), 4.3 ,219,39,3,[]))
	Bladex.AddScheduledFunc(t + 11.4, enem.GoTo, (30434.8413017, -1068.38669054, 142224.74468))
	Bladex.AddScheduledFunc(t + 13.2, char.GoTo, (35527.7547082, -1598.97406449, 142081.136128))
	Bladex.AddScheduledFunc(t + 14.3, Actions.TurnToFaceEntity, ("Player1", "LamparaNegra_219"))
	Bladex.AddScheduledFunc(t + 14.3, darfuncs.HideBadGuy, ("K_Vigilante",))

	## Me quito el traje
	Bladex.AddScheduledFunc(t + 16.0, QuitarseDisfraz, ())

	Bladex.AddScheduledFunc(t + 20.3, ActivaGuardiaEscaleras, ())
	Bladex.AddScheduledFunc(t + 21.0, ActivaGuardiaSalaArmas, ())

	print("fin schds. en pasamacho")

	muevecamara(camEscCTEsc, objEscCTEsc, camEscCTEsc, objEscCTEsc, 20.0, FinAnimacion)
	print("fin anim pasamacho")

## Si no vale
def EscVeteaPaseoEscaleras():
	Bladex.DeactivateInput()
	Scorer.SetVisible(0)

	Cam = Bladex.GetEntity("Camera")
	Cam.SetPersonView("K_Vigilante")
	Cam.Cut()

	char=Bladex.GetEntity("Player1")
	char.GoToJogging=0
	char.GoTo(31580.2060219, -1615.57896117, 142639.933005)
	Bladex.AddScheduledFunc(Bladex.GetTime() + 1.5, Actions.TurnToFaceEntity, ("Player1", "K_Vigilante"))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 2.0, Actions.TurnToFaceEntity, ("K_Vigilante", "Player1"))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 1.5, GameText.WriteTextAux, (Traduce("Necesito ver al jefe"), 3.0,122,203,220,[]))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 5.3, GameText.WriteTextAux, (Traduce("Hay rdenes: slo pasara el portador del mapa"), 3.0 ,219,39,3,[]))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 8.9, GameText.WriteTextAux, (Traduce("El jefe ha sido muy claro"), 2.8 ,219,39,3,[]))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 11.3, char.GoTo, (26762.6525987, -839.883714834, 142420.360858))

	Bladex.AddScheduledFunc(Bladex.GetTime() + 14.6, FinEscEscaleras, ())
	print("fin anim ketepires")

## Si te mata
def DespiertaVigilante():
	Bladex.ActivateInput()
#	Scorer.SetVisible(1)
	enem=Bladex.GetEntity("K_Vigilante")
	enem.Blind = 0
	enem.Deaf = 0
	Cam = Bladex.GetEntity("Camera")
	Cam.SetPersonView("Player1")
	Cam.Cut()
	print("despierto!!!")
	
def SoyDebil(EntityName, WeaponName, Cx, Cy, Cz, DirX, DirY, DirZ,wcx,wcy,wcz,wdx,wdy,wdz):
	char=Bladex.GetEntity("Player1")
	char.Life = char.Life - 6937
	
huyePorEscaleras = 0
def NoHuyas(sectorindex, entity):
	global huyePorEscaleras

	if entity == "Player1":
		huyePorEscaleras = 1
		sector=Bladex.GetSector(36180.2060219, -1615.57896117, 142639.933005)
		sector.OnEnter=""
		print("quitado sector huida hacia escaleras")
		## Te quito el control para que mueras
		Bladex.DeactivateInput()
		Scorer.SetVisible(0)
		Cam = Bladex.GetEntity("Camera")
		Cam.SetPersonView("K_Vigilante")
		Cam.Cut()
		Bladex.AddScheduledFunc(Bladex.GetTime() + 0.3, Actions.QuickTurnToFaceEntity, ("Player1", "K_Vigilante"))
		print("<- No Huyas")

def EscMuerteControlEscaleras():
	Bladex.DeactivateInput()
	Scorer.SetVisible(0)

	Cam = Bladex.GetEntity("Camera")
	Cam.SetPersonView("K_Vigilante")
	Cam.Cut()

	### Ponemos un control en el sector que da hacia las escaleras para que no se escape
	sector=Bladex.GetSector(36180.2060219, -1615.57896117, 142639.933005)
	sector.OnEnter=NoHuyas

	char=Bladex.GetEntity("Player1")
	char.GoToJogging=0
	char.HitFunc = SoyDebil
	char.GoTo(29580.2060219, -1615.57896117, 142639.933005)

	sector=Bladex.GetSector(30000.0, -1000.0, 142000.0)
	sector.OnLeave=EscHuidaEscaleras ## Si sales del sector (areaMax del vigilante) )antes de que te endie, sobrevives
	print("on exit activado")

	Bladex.AddScheduledFunc(Bladex.GetTime() + 1.5, GameText.WriteTextAux, (Traduce("Un intruso!!! Te advierto que nadie ha sido capaz de herirme jams"), 4.5 ,219,39,3,[]) )
	Bladex.AddScheduledFunc(Bladex.GetTime() + 2.2, DespiertaVigilante, ())

	print("fin anim matame")

def OrientaVigilante():
	enem=Bladex.GetEntity("K_Vigilante")
	enem.Angle = 1.55483819587

def EscHuidaEscaleras(sectorindex, entity):
	if entity == "Player1" and not huyePorEscaleras:
		Bladex.DeactivateInput()
		Scorer.SetVisible(0)
	
		## Dormimos al vigilante
		enem=Bladex.GetEntity("K_Vigilante")
		enem.Blind = 1
		enem.Deaf = 1
		enem.GoTo(35580.2060219, -1615.57896117, 142639.933005)

		char=Bladex.GetEntity("Player1")
		char.GoToJogging=1
		char.GoTo(25580.2060219, -1615.57896117, 142639.933005)

		sector=Bladex.GetSector(sectorindex)
		sector.OnLeave=""

		## Quitamos la funcion que evita la huida
		sector=Bladex.GetSector(36180.2060219, -1615.57896117, 142639.933005)
		sector.OnEnter=""
		print("quitado sector huida hacia escaleras")
		
		## Funcion Hit original
		char.HitFunc = Basic_Funcs.PlayerPerson.HitFunc

		Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5, GameText.WriteTextAux, (Traduce("Y no vuelvas por aqui"), 2.5 ,219,39,3,[]))
		Bladex.AddScheduledFunc(Bladex.GetTime() + 3.5, GameText.WriteTextAux, (Traduce("Ese tio es demasiado duro para mi"), 2.0,122,203,220,[]))
		Bladex.AddScheduledFunc(Bladex.GetTime() + 5.5, FinEscEscaleras, ())
		Bladex.AddScheduledFunc(Bladex.GetTime() + 8.0, OrientaVigilante, ())

		print("fin huida escaleras")
#----

#---- Animacion al enfrentarse con el malote
def EscSalaTrono():
	Bladex.DeactivateInput()
	Scorer.SetVisible(0)

	char=Bladex.GetEntity("Player1")
	char.GoToJogging=0
	char.GoTo(18800.4499421, -29067.530441, 163428.990108)

	Bladex.AddScheduledFunc(Bladex.GetTime() + 2.5, GameText.WriteTextAux, (Traduce("Pense que no lograrias llegar hasta aqui..."), 3.5 ,219,139,3,[]) )

	sndCombate4.Play(char.Position[0], char.Position[1], char.Position[2], 0)

	muevecamara(camEscSalaTrono1, objEscSalaTrono1, camEscSalaTrono2, objEscSalaTrono2, 8.0, EscSalaTrono2)
	print("fin anim sala trono")

def EscSalaTrono2():
	cam = Bladex.GetEntity("Camera")
	cam.SetPersonView("KC_SalaTrono")
	cam.Cut()

	char=Bladex.GetEntity("Player1")

	Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5, GameText.WriteTextAux, (Traduce("Creo que disfrutare viendote morir"), 4.0 ,219,139,3,[]) )

	muevecamara(cam.Position, cam.TPos, cam.Position, char.Position, 5.0, EscSalaTrono3)
	print("fin anim sala trono 2")

def EscSalaTrono3():
	jefe=Bladex.GetEntity("KC_SalaTrono")

	Bladex.AddScheduledFunc(Bladex.GetTime() + 1.5, GameText.WriteTextAux, (";-P", 2.0,122,203,220,[]))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 4.5, GameText.WriteTextAux, (Traduce("Pringaaaaaaaaaaaaaoo"), 3.0,122,203,220,[]))

	Bladex.AddScheduledFunc(Bladex.GetTime() + 6.5, ActivaGuardiaSalaTrono, ())

	camPos = (19015.2499296, -29998.3266363, 161386.464977)
	muevecamara(camPos, jefe.Position, camPos, jefe.Position, 8.0, FinAnimacion)
	print("fin anim sala trono 3")
#----

#---- Animacion final
bailar = 1
def EscFinal():
	global bailar

	bailar = 1
	Bladex.DeactivateInput()
	Scorer.SetVisible(0)
	AuxFuncs.FadeTo(2.0, 31.0)
	EscFinal2()	

def EscFinal2():
	#Actions.FreeBothHands("Player1")
	char = Bladex.GetEntity("Player1")
	char.Position=(-57.0303254146, -2319.36461517, 193728.006238)
	char.Angle=2.73919183055

	cam = Bladex.GetEntity("Camera")
	cam.Position = (679.670936791, -768.00884097, 188958.468457)
	cam.TPos = (-57.0303254146, -3319.36461517, 193728.006238)
	
	#Lanzar Animaciones guapas ?? no las tengo :(
	char.LaunchAnmType("Kgt_drp_r")
	char.AnmEndedFunc=AnimFin3

	AuxFuncs.FadeFrom(3.0, 0.0)
	Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5, GameText.WriteTextAux, (Traduce("Esto es todo."), 2.0,222,223,20,[]))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 4.0, GameText.WriteTextAux, (Traduce("Aprovecho para agradeceros la ayuda prestada..."), 4.0,222,223,20,[]))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 9.0, GameText.WriteTextAux, ("...Masklin, Raziel, Keoh, Gelpi, Quel, Goosebrush, Lerfox12+1...", 4.0,222,223,20,[]))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 14.0, GameText.WriteTextAux, (Traduce("...a todos los de MoriaMod...a todos los de Edicion de Scripts..."), 4.0,222,223,20,[]))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 19.0, GameText.WriteTextAux, (Traduce("...a todos los que habeis jugado este mapa...a todos los demas..."), 4.0,222,223,20,[]))

	#sndFinal=Bladex.CreateSound("MusicaFinal.wav", "SonidoFinalRumbeeeeeeeero")
	#sndFinal.Volume=2.0
	sndFinal.Play(-268.003487457,-4708.1417187,197931.45290266, 0)
	muevecamara(cam.Position, cam.TPos, cam.Position, cam.TPos, 23.0, FinNivel)
	print("fin anim final beta")

def FinNivel2():	
	global bailar

	## Acabamos el nivel tras mostrar FIN
	bailar = 0
	Bladex.ActivateInput() ## Igual no hace falta
	VolveralMenu()
	print("En serio... gracias por jugar xD")

def FinNivel():
	global bailar

	AuxFuncs.FadeTo (1.0, 144000.0)
	## Paramos animaciones, sonido, etc
	Bladex.AddScheduledFunc(Bladex.GetTime() + 2.0, GameText.WriteTextAux, (Traduce("FIN"), 2.0,222,223,20,[]))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 4.5, FinNivel2, ())

def AnimFin2(entity):	
	global bailar

	char = Bladex.GetEntity(entity)
	char.LaunchAnmType("Kgt_drp_r")
	if bailar:
		char.AnmEndedFunc=AnimFin3
	else:
		VolveralMenu()
	print("animfin2")

def AnimFin3(entity):
	char = Bladex.GetEntity(entity)
	char.LaunchAnmType("Kgt_drp_l")
	char.AnmEndedFunc=AnimFin4
	print("animfin3")

def AnimFin4(entity):
	char = Bladex.GetEntity(entity)
	char.LaunchAnmType("Kgt_fury")
	char.AnmEndedFunc=AnimFin2
	print("animfin4")
#----

#---- Funcion para acabar el nivel
def VolveralMenu():
	ObjStore.CheckStore()

	import Language
	import SplashImage
	scr_name="../../Data/Menu/Save/"+Language.Current+"/Cerrando.jpg"
	SplashImage.ShowImage(scr_name,0)

	Menu.ActivateMenu()
#----
	
#
###############################



###############################
#--------- cementerio.py ------------------
#--------------------------------------------------
#

#---- Funcion que permite matar a los arqueros de un solo flechazo
def DameyMuero(EntityName, WeaponName, Cx, Cy, Cz, DirX, DirY, DirZ,wcx,wcy,wcz,wdx,wdy,wdz):
	enem=Bladex.GetEntity(EntityName)
	enem.Life = -1
	print("Enemigo matado de un golpe")
#----

#---- Funciones para la activacion del generador y la apertura del rastrillo (tacita)
levantarEsqueletos = 1
### Control de la salida del cementerio al poner la calavera ancestral en la taza del pedestal
def UsaTacita(ObjectName,use_from):
	global levantarEsqueletos

	char = Bladex.GetEntity("Player1")
	inv = char.GetInventory()
	obj = inv.GetSelectedObject()
	if obj == "PiedraPesada":
		Bladex.DeactivateInput()
		Scorer.SetVisible(0)
		if  char.InvRight != "":
			Actions.FreeBothHands("Player1")
		Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5, SacaPiedra, ())
	else:
		## Si inspecciona la taza por primera vez, lanzamos el generador de esqueletos (animacion)
		if levantarEsqueletos:
			levantarEsqueletos = 0
			EscCementerio()			
		else:			
			GameText.WriteTextAux(Traduce("Parece un altar para realizar ofrendas"),2.5,122,203,220,[])
			print("Eso no sirve")

def SacaPiedra():
	print("sacas")
	char = Bladex.GetEntity("Player1")
	## Lanzo la animacion de coger algo de la espalda con la derecha
#	char.Wuea = Reference.WUEA_ENDED
	char.LaunchAnmType("Chg_r")
	char.AnmEndedFunc = PonPiedra
	print("fin SacaPiedra")

def PonPiedra(entity):
	print("pones")
	char = Bladex.GetEntity("Player1")
	inv = char.GetInventory()				
	inv.LinkRightHand("PiedraPesada")
	Actions.TurnToFaceEntity ("Player1","TacitaLigera")
	char.LaunchAnmType("Kgt_fire1")	
	Bladex.AddScheduledFunc(Bladex.GetTime() + 0.3, PiedraPuesta, ())
	print("fin PonPiedra")

def PiedraPuesta():
	print("puesto")
	char = Bladex.GetEntity("Player1")
	#char.Wuea = Reference.WUEA_ENDED
	inv = char.GetInventory()				
	inv.LinkRightHand("None")
	inv.RemoveObject("PiedraPesada")

	p = Bladex.GetEntity("PiedraPesada")
	p.Position =  (-64855.2279686,-524.229667063,180755.188971)
	p.Static=1
	darfuncs.SetHint(p, "")
	t = Bladex.GetEntity("TacitaLigera")
	t.UseFunc=""
	darfuncs.SetHint(t, Traduce("Mecanismo del cementerio"))
	print ("Ha puesto la piedra en la taza")
	sndStoneLever.Play(t.Position[0], t.Position[1], t.Position[2], 0)
	## Las calaveras ya no se cogen en el inventario
	Reference.DefaultObjectData['Skull']=            Reference.DefaultObjectData['Femur']

	## Devolvemos el control al jugador
	Bladex.ActivateInput()
	Scorer.SetVisible(1)

	## Abrimos la puerta tras sonido del mecanismo
	Bladex.AddScheduledFunc(Bladex.GetTime() + 2.0, AbreRastrilloCementerio, ())
	DespiertaEnemigosPatio()
	print("fin PiedraPuesta")
#----

#---- Funciones para abrir/cerrar el rastrillo del cementerio
def AbreRastrilloCementerio():
	print ("Abro cementerio")
	desplazamientos=(1500.0, 1000.0)
	vectores=((0.0, -1.0, 0.0), (0.0, -1.0, 0.0))
	vel_iniciales=(0.0, 500)
	vel_finales=(500.0, 200)
	
	#sonidos asociados a la puerta-objeto rastrilloCementerioDIN
	son_iniciales=("", "")
	son_durante=(sonidorastrillo, sonidorastrillo)
	son_finales=("", golpemetalmediano)
	Objects.NDisplaceObject(rastrilloCementerioDIN, desplazamientos, vectores, vel_iniciales, vel_finales, (), son_durante, son_finales)

	print ("salgo de Abrir rastrillo Cementerio")	

def CierraRastrilloCementerio():
	global rastrilloCrpAbierto

	print ("Cierro Cementerio")
	## Controlo que este abierto
	desplazamientos=(1000.0, 1500.0)
	vectores=((0.0, 1.0, 0.0), (0.0, 1.0, 0.0))
	vel_iniciales=(0.0, 3000.0)
	vel_finales=(3000.0, 5500.0)

	#sonidos asociados a la puerta-objeto rastrilloCementerioDIN
	son_iniciales=("", "")
	son_durante=(sonidorastrillo, sonidorastrillo)
	son_finales=("", golpemetalmediano)
	Objects.NDisplaceObject(rastrilloCementerioDIN, desplazamientos, vectores, vel_iniciales, vel_finales, (), son_durante, son_finales)
		
	print ("salgo de Cierra rastrillo Cementerio")	
#----

#---- Funciones del sistema de particulas para el generador
def RemueveTierraGen2(pos, v1, v2, v3):
	tierra=Bladex.CreateEntity("TierraRemoviendose", "Entity Particle System D3", pos[0]+v1[0], pos[1]-900.0, pos[2]+v1[2])
	tierra.D1=v2[0]-v1[0], 0.0, v2[2]-v1[2]
	tierra.D2=v3[0]-v1[0], 0.0, v3[2]-v1[2]
	tierra.ParticleType="Tierra2x"
	tierra.PPS=64
	tierra.YGravity=200.0
	tierra.Friction=0.1
	tierra.Velocity=0.0, -400.0, 0.0
	tierra.RandomVelocity=15.0
	tierra.Time2Live=64
	tierra.DeathTime=Bladex.GetTime()+2.0

def SaltaTierraGen2(enmgen):	
	char=Bladex.GetEntity("Player1")
	pos=enmgen.Position	
	v=char.Position[0]-pos[0], 0.0, char.Position[2]-pos[2]
	v=B3DLib.Normalize(v)
	v1=v[0]*500.0, 0.0, v[2]*500.0
	v2=v1[0]*math.cos(1.7453)-v1[2]*math.sin(1.7453), 0.0, v1[0]*math.sin(1.7453)+v1[2]*math.cos(1.7453)
	v3=v2[0]*math.cos(2.7925)-v2[2]*math.sin(2.7925), 0.0, v2[0]*math.sin(2.7925)+v2[2]*math.cos(2.7925)

	saltatie=Bladex.CreateEntity("TierraSaltando", "Entity Particle System D1", pos[0], pos[1]-900.0, pos[2])
	saltatie.ParticleType="Tierra3x"
	saltatie.PPS=1024
	saltatie.YGravity=4900.0
	saltatie.Friction=0.05
	saltatie.Velocity=0.0, -600.0, 0.0
	saltatie.RandomVelocity=50.0
	saltatie.Time2Live=60
	saltatie.DeathTime=Bladex.GetTime()+10.0/60.0

	saltati2=Bladex.CreateEntity("TierraSaltando2", "Entity Particle System D1", pos[0], pos[1]-900.0, pos[2])
	saltati2.ParticleType="Tierra2x"
	saltati2.PPS=128
	saltati2.YGravity=200.0
	saltati2.Friction=0.1
	saltati2.Velocity=0.0, -300.0, 0.0
	saltati2.RandomVelocity=15.0
	saltati2.Time2Live=32
	saltati2.DeathTime=Bladex.GetTime()+10.0/60.0
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, RemueveTierraGen2, (pos, v1, v2, v3))
#----

#---- Funciones del generador de enemigos del cemeneterio
def FinGeneradorT1(recibe1):
	print("Han muerto todos los esqueletos del generador T1")
	CreaGPGrieta()

def Facilitar(o):
	o.Level = 15
	EnemyTypes.EnemyDefaultFuncs(o)
	#o. Life = 5
	o.ActionAreaMin=pow(2,2)
	o.ActionAreaMax=pow(2,3)
	#print ("que facil")
#----

#---- Funciones utilizadas en el derrumbamiento del muro
def PolvoRoturaGrieta():
	polvorotura=Bladex.CreateEntity("PolvoRoturaGrieta", "Entity Particle System D2", -66416.056734, 1197.117590017, 196507.787457)
	polvorotura.ParticleType="WallDust"
	polvorotura.D=2500, 0, 0
	polvorotura.YGravity=0.0
	polvorotura.Friction=0.2
	polvorotura.PPS=480
	polvorotura.Velocity=0.0, -1000.0, -2000.0
	polvorotura.RandomVelocity=80.0
	polvorotura.Time2Live=60
	polvorotura.DeathTime=Bladex.GetTime()+3.0/2.0

def RoturaGrieta():
	murogrietader.DoBreak((0.5, 1.3, 0.5), (-66408.5279614, 182.960091578, 196527.832093), (0.0, 0.0, 0.0))
	murogrietaizq.DoBreak((1.5, 0.0, -1.0), (-66408.5279614, 937.270176366, 195396.583033), (0.0, 0.0, 0.0))

	c = Bladex.GetEntity("CincelLapidas")
	c.Position =(-66112.1500983, -367.545462047, 196140.876295)
	c.Orientation = (0.836516261101, 0.129409536719, 0.482962936163, 0.224143862724)
	c.Static=0
	c.Impulse(0, 0, 0)
	darfuncs.SetHint(c, Traduce("Cincel"))
	## Ya no se puede usar
	c.UseFunc = ""

	derrumbegrieta.Play(-66112.1500983, -367.545462047, 196140.876295)
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.2, PolvoRoturaGrieta, ())
	print("<-muro derribado")

def PolvoCincel():
	polvo=Bladex.CreateEntity("PolvoRotura", "Entity Particle System D2",  -65962.1500983,-367.545462047,196040.876295)
	polvo.ParticleType="WallDust"
	polvo.D=100, 0, 0
	polvo.YGravity=0.0
	polvo.Friction=0.2
	polvo.PPS=40
	polvo.Velocity=200.0, -700.0, 0.0
	polvo.RandomVelocity=5.0
	polvo.Time2Live=30
	polvo.DeathTime=Bladex.GetTime()+3.0/20.0

golpesCincel = 3
def GolpeaCincel(stick,sticker,x,y,z,xc,yc,zc,wcx,wcy,wcz,wdx,wdy,wdz):
	global golpesCincel

	print("Golpea el cincel")
	c=Bladex.GetEntity("CincelLapidas")
	Sparks.ThrowMetalSparks(c,sticker,x,y,z,xc,yc,zc,wcx,wcy,wcz,wdx,wdy,wdz)
	if char.InvRight == "MartilloLapidas":
		golpesCincel = golpesCincel - 1
		if (golpesCincel <= 0):
			## Quito el cincel fantasma y las esquirlas
			c2=Bladex.GetEntity("CincelGrande")
			c2.SubscribeToList("Pin")
			o=Bladex.GetEntity("Esquirla_597")
			o.SubscribeToList("Pin")	
			o=Bladex.GetEntity("Esquirla_598")
			o.SubscribeToList("Pin")	
			o=Bladex.GetEntity("Esquirla_599")
			o.SubscribeToList("Pin")	
			Bladex.AddScheduledFunc(Bladex.GetTime()+0.2, RoturaGrieta, ())
		else:
			Bladex.AddScheduledFunc(Bladex.GetTime() + 0.3, GameText.WriteTextAux, (Traduce("Un golpecito mas..."), 2.5,122,203,220,[]))	
		## Polvo de cincel
		c=Bladex.GetEntity("CincelLapidas")
		pos = (c.Position[0] - 50.0, c.Position[1], c.Position[2])
		c.Position = pos
		Bladex.AddScheduledFunc(Bladex.GetTime()+0.1, PolvoCincel, ())
	
	print("fin de GolpeaCincel")


cincel_puesto = 0
def ExaminaGrieta(obj_name, use_from):
	char = Bladex.GetEntity("Player1")
	if cincel_puesto:
		GameText.WriteTextAux(Traduce("Creo que un golpecito bastaria..."),2.5,122,203,220,[])			
	else:
		inv = char.GetInventory()
		obj = inv.GetSelectedObject()
		if obj == "CincelLapidas":
			Bladex.DeactivateInput()
			Scorer.SetVisible(0)
			if  char.InvRight != "":
				Actions.FreeBothHands("Player1")
			Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5, SacaCincel, ())
		else:
			GameText.WriteTextAux(Traduce("Este muro no est en muy buen estado"),2.5,122,203,220,[])
			print("Eso no sirve")
	
def SacaCincel():
	print("sacas")
	char = Bladex.GetEntity("Player1")
	## Lanzo la animacion de coger algo de la espalda con la derecha
#	char.Wuea = Reference.WUEA_ENDED
	char.LaunchAnmType("Chg_r")
	char.AnmEndedFunc = PonCincel
	print("fin SacaCincel")

def PonCincel(entity):
	print("pones")
	char = Bladex.GetEntity("Player1")
	inv = char.GetInventory()				
	inv.LinkRightHand("CincelLapidas")
	Actions.TurnToFaceEntity ("Player1","PunteroGrieta")
	char.LaunchAnmType("Kgt_fire2")	
	Bladex.AddScheduledFunc(Bladex.GetTime() + 0.3, CincelPuesto, ())
	print("fin PonCincel")

def CincelPuesto():
	global cincel_puesto

	print("puesto")
	char = Bladex.GetEntity("Player1")
	#char.Wuea = Reference.WUEA_ENDED
	inv = char.GetInventory()				
	inv.LinkRightHand("None")
	inv.RemoveObject("CincelLapidas")

	## El cincel est insertado
	c=Bladex.GetEntity("CincelLapidas")
	c.Position =  (-65962.1500983,-367.545462047,196040.876295)
	c.Orientation = (0.683012664318,0.183012709022,0.683012723923,0.18301269412) 
	c.Static=1 ## Para que no lo pueda coger

	### Asociamos la funcion de golpear y de examinar el cincel
	Reference.DefaultObjectData['Cincel']=            [Reference.OBJ_NONE]
	c.UseFunc = ExaminaCincelPuesto
	darfuncs.SetHint(c, Traduce("Cincel introducido en una grieta"))

	### Creamos un cincel transparente para que sea ms facil darle
	c2=Bladex.CreateEntity("CincelGrande","Cincel",0.0,0.0,0.0, "Physic")
	c2.Alpha=0
	#c2.CastShadow=0
	c2.Scale=4.0
	c2.Orientation=(0.683012664318,0.183012709022,0.683012723923,0.18301269412) 
	c2.Position = -66262.1500983,-367.545462047,196040.876295
	#ItemTypes.ItemDefaultFuncs(c2)
	c2.HitFunc = GolpeaCincel


	print ("Ha puesto el cincel en la grieta")

	cincel_puesto = 1
	## Quitamos el puntero fantasma
	p= Bladex.GetEntity("PunteroGrieta")
	p.RemoveFromWorld()

	## Devolvemos el control al jugador
	Bladex.ActivateInput()
	Scorer.SetVisible(1)
	print("fin CincelPuesto")

pistaMartillo = 0
def ExaminaCincelPuesto(obj_name, use_from):
	global pistaMartillo

	if not pistaMartillo:
		pistaMartillo = 1
		Stars.Twinkle("MartilloLapdas")
		print("coge lo que tiene estrellitas anda...")
	GameText.WriteTextAux(Traduce("Creo que un golpecito bastaria..."),2.5,122,203,220,[])

def CreaGPGrieta():
	punterogrieta=Bladex.CreateEntity("PunteroGrieta","GhostPointer", -65905.3522174,-341.332091328,196044.648307)
	punterogrieta.Static=1
	punterogrieta.Scale=3.0
	punterogrieta.Orientation=0.707107,0.707107,0.000000,0.000000
	darfuncs.SetHint(punterogrieta,Traduce("Grieta"))
	punterogrieta.UseFunc=ExaminaGrieta	
	print("Se ha creado el puntero fantasma de la grieta")
#----

#
###############################


###############################
#--------------- criptas.py ------------------
#--------------------------------------------------
#

#---- Funcion que controla los enemigos muertos de la cripta izquierda
def MuerteCriptaI(entity):
	global vivosCriptaI
	global rastrilloCrpJodido

	me = Bladex.GetEntity(entity)
	if me.Data.OldImDeadFunc:
		me.Data.OldImDeadFunc(entity)
	vivosCriptaI=vivosCriptaI - 1
	if vivosCriptaI==0 :
		# Sonido de mecanismo
		palanRastrilloCriptaI.mode=3 
		rastrilloCrpJodido=0	
		sndMechanism3.Play(-71063.4415672, 2379.18156383, 153839.413505, 0)
		print ("Todos muertos -> Arreglo el rastrillo")
#---- 		

#---- Funcion que muestra los enemigos de la cripta izquierda
def MuestraEnemigosCriptaI():
	global momiasCreadas

	darfuncs.UnhideBadGuy("Lich_435")
	darfuncs.UnhideBadGuy("Lich_434")
	#darfuncs.UnhideBadGuy("Knight_Zombie_437")
	momiasCreadas=1
#---- 

#---- Funcion que crea los enemigos de la cripta derecha, contando cuantos son
def CreaEnemigosCriptaD():
	global vivosCriptaD
	global momias2Creadas

	#### Momia 1
	vivosCriptaD=vivosCriptaD+1
	o=Bladex.CreateEntity("Lich_441","Lich",-72697.879719,2518.79606548,168316.490293, "Person")
	o.Scale=1.0
	o.Angle=6.02082476024
	o.Level=8
	o.Life=600.0
	#o.Deaf= 1
	#o.Blind= 1
	EnemyTypes.EnemyDefaultFuncs(o)
	#o.Life=69.0
	o.ActionAreaMin=pow(2,0)
	o.ActionAreaMax=pow(2,1)
	o.Data.OldImDeadFunc = o.ImDeadFunc
	o.ImDeadFunc = MuerteCriptaD
	o=Bladex.CreateEntity ("Martillo_448", "Martillo", 0,0,0, "Weapon")
	ItemTypes.ItemDefaultFuncs(o)
	Actions.TakeObject("Lich_441", "Martillo_448")

	#### Momia 2
	##vivosCriptaD=vivosCriptaD+1
	##o=Bladex.CreateEntity("Lich_442","Lich",-77060.6720812,2518.79606548,168936.143502, "Person")
	##o.Scale=1.0
	##o.Angle=4.6469834975
	##o.Level=9
	##o.Life=650.0
	#o.Deaf= 1
	#o.Blind= 1
	##EnemyTypes.EnemyDefaultFuncs(o)
	##o.Life=69.0
	##o.ActionAreaMin=pow(2,0)
	##o.ActionAreaMax=pow(2,1)
	##o.Data.OldImDeadFunc = o.ImDeadFunc
	##o.ImDeadFunc = MuerteCriptaD
	##o=Bladex.CreateEntity ("Hacha3_449", "Hacha3", 0,0,0, "Weapon")
	##ItemTypes.ItemDefaultFuncs(o)
	##Actions.TakeObject("Lich_442", "Hacha3_449")
	
	#### Momia 3
	##vivosCriptaD=vivosCriptaD+1
	##o=Bladex.CreateEntity("Lich_443","Lich",-76646.7794861,2518.037115,175340.291826, "Person")
	##o.SetOnFloor()
	##o.Scale=0.6
	##o.Angle=4.6469834975
	##o.Level=2
	##o.Life=100.0
	#o.Deaf= 1
	#o.Blind= 1
	##EnemyTypes.EnemyDefaultFuncs(o)
	##o.Life=69.0
	##o.ActionAreaMin=pow(2,0)
	##o.ActionAreaMax=pow(2,1)
	##o.Data.OldImDeadFunc = o.ImDeadFunc
	##o.ImDeadFunc = MuerteCriptaD
	##o=Bladex.CreateEntity ("Gladius_450", "Gladius", 0,0,0, "Weapon")
	##ItemTypes.ItemDefaultFuncs(o)
	##Actions.TakeObject("Lich_443", "Gladius_450")
		
	#### Momia 4
	##vivosCriptaD=vivosCriptaD+1
	##o=Bladex.CreateEntity("Lich_447","Lich",-74648.0396629,2518.79606548,173265.518179, "Person")
	##o.Scale=1.0
	##o.Angle=4.6469834975
	##o.Level=11
	##o.Life=850.0
	#o.Deaf= 1
	#o.Blind= 1
	##EnemyTypes.EnemyDefaultFuncs(o)
	##o.Life=69.0
	##o.ActionAreaMin=pow(2,0)
	##o.ActionAreaMax=pow(2,1)
	##o.Data.OldImDeadFunc = o.ImDeadFunc
	##o.ImDeadFunc = MuerteCriptaD
	##o=Bladex.CreateEntity ("Hacha3_459", "Hacha3", 0,0,0, "Weapon")
	##ItemTypes.ItemDefaultFuncs(o)
	##Actions.TakeObject("Lich_447", "Hacha3_459")
	
	#### Momia 5
	vivosCriptaD=vivosCriptaD+1
	o=Bladex.CreateEntity("Lich_444","Lich",-72517.8390459,2518.79606548,175398.868097, "Person")
	o.Scale=1.0
	o.Angle=2.21002423437
	o.Level=7
	o.Life=500.0
	#o.Deaf= 1
	#o.Blind= 1
	EnemyTypes.EnemyDefaultFuncs(o)
	#o.Life=69.0
	o.ActionAreaMin=pow(2,0)
	o.ActionAreaMax=pow(2,1)
	o.Data.OldImDeadFunc = o.ImDeadFunc
	o.ImDeadFunc = MuerteCriptaD
	o=Bladex.CreateEntity ("Martillo2_460", "Martillo2", 0,0,0, "Weapon")
	ItemTypes.ItemDefaultFuncs(o)
	Actions.TakeObject("Lich_444", "Martillo2_460")
	
	##### Caballero Zombie
	vivosCriptaD=vivosCriptaD+1
	o=Bladex.CreateEntity("Knight_Zombie_437b","Knight_Zombie",-78060.6720812,2518.79606548,169936.143502, "Person")
	o.Scale=1.0
	o.Angle=4.44297023048
	o.Level=14
	o.Life=900.0
	#o.Deaf= 1
	#o.Blind= 1
	EnemyTypes.EnemyDefaultFuncs(o)
	#o.Life=69.0
	o.ActionAreaMin=pow(2,0)
	o.ActionAreaMax=pow(2,1)
	o.Data.OldImDeadFunc = o.ImDeadFunc
	o.ImDeadFunc = MuerteCriptaD
	o=Bladex.CreateEntity ("Hacha3_440b", "Hacha5", 0,0,0, "Weapon")
	ItemTypes.ItemDefaultFuncs(o)
	Actions.TakeObject("Knight_Zombie_437b", "Hacha3_440b")
	momias2Creadas =1
	print("Creados enemigos de la cripta derecha")
#---- 

#---- Funcion que controla los enemigos muertos de la cripta izquierda
def MuerteCriptaD(entity):
	global vivosCriptaD

	me = Bladex.GetEntity(entity)
	if me.Data.OldImDeadFunc:
		me.Data.OldImDeadFunc(entity)
	vivosCriptaD=vivosCriptaD - 1
	if vivosCriptaD==0 :
		print ("Todos muertos -> Abro la gran cripta")
		AbreGranCripta()
#---- 

#---- Funciones para abrir/cerrar, cada puerta de las criptas
## Rastrillo de la cripta izquierda
def AbreRastrilloCriptaI():
	global momiasCreadas
	global rastrilloCrpJodido
	global rastrilloCrpAbierto

	print ("llamANDO a la de abrir rastrillo")
	if not (rastrilloCrpJodido or rastrilloCrpAbierto):
		print ("Abro")
		desplazamientos=(1500.0, 1150.0)
		vectores=((0.0, -1.0, 0.0), (0.0, -1.0, 0.0))
		vel_iniciales=(0.0, 2000)
		vel_finales=(2000.0, 100)
	
		#sonidos asociados a la puerta-objeto rastrilloCriptaIDIN
		son_iniciales=("", "")
		son_durante=(sonidorastrillo, sonidorastrillo)
		son_finales=("", golpemetalmediano)
		Objects.NDisplaceObject(rastrilloCriptaIDIN, desplazamientos, vectores, vel_iniciales, vel_finales, (), son_durante, son_finales)

		rastrilloCrpAbierto=1
		if not momias2Creadas:
			CreaEnemigosCriptaD()
	
	else:
		if not momiasCreadas:
			### Al darle al rastrillo, lanzo la animacin en que se ve las momias detrs del to
			MuestraEnemigosCriptaI()
			Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5, EscCriptaI, ())		
	
	print ("salgo de Abrir rastrillo")	

def CierraRastrilloCriptaI():
	global rastrilloCrpAbierto

	print ("llamANDO a la de cerrar rastrillo")
	## Controlo que este abierto
	if rastrilloCrpAbierto:
		print ("Cierro")
		desplazamientos=(1150.0, 1500.0)
		vectores=((0.0, 1.0, 0.0), (0.0, 1.0, 0.0))
		vel_iniciales=(0.0, 2000.0)
		vel_finales=(2000.0, 7000.0)
	
		#sonidos asociados a la puerta-objeto rastrilloCriptaIDIN
		son_iniciales=("", "")
		son_durante=(sonidorastrillo, sonidorastrillo)
		son_finales=("", golpemetalmediano)
		Objects.NDisplaceObject(rastrilloCriptaIDIN, desplazamientos, vectores, vel_iniciales, vel_finales, (), son_durante, son_finales)

		rastrilloCrpAbierto=0
		
	print ("salgo de Cierra rastrillo")	

## Puerta de la gran cripta
def AbreGranCripta():
	pCripta.OpenDoor()
	print("Gran Cripta Abierta")

def CierraGranCripta():
	pCripta.CloseDoor()
	print("Gran Cripta Cerrada")

## Puerta de salida de la cripta
def AbreSalidaCripta():
	salCripta.OpenDoor()
	print("Salida Cripta Abierta")

### Esta funcion cierra las criptas, lanzando una animacion
def CierraSalidaCripta(sectorindex, entityname):
	if entityname == "Player1":		
		sencos=Bladex.GetSector(sectorindex)
		sencos.OnEnter=""

		## Lanzamos la animacion
		EscSalidaCriptas()
#---- 

#---- Funcion que los pone al alcance del jugador los vampiros de la gran cripta (al subirse a por la pocion de poder)
def HolaVampiros(sectorindex, entityname):
	global crearVampiros

	if entityname == "Player1":
		## Quito la funcion asociada al sector
		sencos=Bladex.GetSector(sectorindex)
		sencos.OnEnter=""

		## Cierro la gran cripta
		CierraGranCripta()

		## Los traigo a la cripta 
		o=Bladex.GetEntity("Vamp_467")
		o.Position = (-65700.0000315,3170.13820374,137013.990542)
		o=Bladex.GetEntity("Vamp_470")
		o.Position = (-47128.4662987,3170.13805788,136283.335429)
		crearVampiros = 0		

		### Lanzo la animacion
		EscVampirosCripta()

		print("Vampiros traidos")
#---- 

#---- Funcion que controla los vampiros muertos
def MuereVampiroCripta(entity):
	global vampirosVivos
	global crearGolems

	me = Bladex.GetEntity(entity)
	if me.Data.OldImDeadFunc:
		me.Data.OldImDeadFunc(entity)

	vampirosVivos = vampirosVivos - 1
	if not vampirosVivos:
		AbreGranCripta()
		crearGolems=1
		print("Abro la gran cripta de nuevo")
#---- 

#---- Funcion que controla los golems muertos
def MuereGolemCripta(entity):
	global golemsVivos

	me = Bladex.GetEntity(entity)
	if me.Data.OldImDeadFunc:
		me.Data.OldImDeadFunc(entity)

	golemsVivos = golemsVivos - 1
	if not golemsVivos:
		AbreSalidaCripta()
		print("Abro la salida de la cripta")
#---- 

#---- Funcion que sustituye las estatuas por los golems
def DarVidaAGolems():
	global crearGolems	

	if crearGolems :	
		## Cierro la cripta
		CierraGranCripta()
		o = Bladex.GetEntity("EstatuaGolem1")
		#o.Position = (-45745.8834863,101437.85183148,168841.689627)
		o.RemoveFromWorld()
		o = Bladex.GetEntity("EstatuaGolem2")
		#o.Position = (-45758.9249289,101462.86297145,159077.017393)
		o.RemoveFromWorld()

		o = Bladex.GetEntity("Golem1")
		o.Position = (-46051.7235642,1405.31328032,169402.46765)
		o.Blind=0
		o.Deaf=0
		o = Bladex.GetEntity("Golem2")
		o.Position = (-46201.8842766,1405.3132805,159189.141739)
		o.Blind=0
		o.Deaf=0

		crearGolems = 0
		print("ESTA VIVO!!!! ESTA VIVO!!! JUASJUASJUAS")
#---- 

#---- Eventos asociados a sectores
def EntraSectorGolems(sectorindex, entityname):
	global crearGolems

	if entityname == "Player1":
		## Primero cierro el rastrillo
		CierraRastrilloCriptaI()
		
		## Compruebo si hay que crear los golems
		if crearGolems:
			DarVidaAGolems()
			EscGolems()
			CierraGranCripta()

			sencos=Bladex.GetSector(sectorindex)
			sencos.OnEnter=""
#---- 

#
###############################


###############################
#----------- pamatar.py ------------------
#--------------------------------------------------
#

#---- Funcion que informa de que no se puede prender con el tronchy
def TronchyNoPrende(rec1, rec2):
	char = Bladex.GetEntity("Player1")
	objright=Bladex.GetEntity(char.InvRight)	 
	objrighttorch=objright.Data.torchobjdata		 
	if objright and (objright.Kind in Torchs.tipos_antorcha) and (objrighttorch.LightStatus==Torchs.OFF):	
		GameText.WriteTextAux(Traduce("En lo que tarde en prenderse, el minotauro me puede destrozar"), 4.5,122,203,220,[])
		print("tronchy inutil")

#---- Funcion para desencarar al minotaturo
def DesencaraMinotauro(sectorindex, entityname):
	if entityname == "Player1":
		char = Bladex.GetEntity("Player1")
		char.SetActiveEnemy(None)
		print("<-desencaro")

#---- 

#---- Funcion para acabar con el minotauro
def MuereMinotauroCabron():
	### Que se muera antes de que caiga la campana y esta le quede encima
	mino = Bladex.GetEntity("MinotauroCabron")
	mino.Data.Invincibility = 0
#	mino.Life=-1980
#	mino.ImDeadFunc("MinotauroCabron")
	### Lo coloco para que le caiga la campana
#	mino.GoToJogging=1
#	mino.GoTo(-13030.2862898, -12018.5481039, 217412.774505)
	mino.Position = (-13030.2862898, -14018.5481039, 214412.774505)
	mino.SetOnFloor()
#	mino.Blind = 1
#	mino.Deaf = 1
	print("minotauro listo para morir")
#---- 

#---- Funcion que se llama cuando le pegas, cada cierto tiempo se rie
def SoyInvulnerable(EntityName, WeaponName, Cx, Cy, Cz, DirX, DirY, DirZ,wcx,wcy,wcz,wdx,wdy,wdz): 
	global leches

	mino = Bladex.GetEntity("MinotauroCabron")
	if mino.Life > 0:
		t = Bladex.GetTime()
		## Aura de superguerrero
		aura=Auras.MakeAura("MinotauroCabron",0.5, (1, 0.01, 1.0, 0, 0, 1),(),(),(2,  1.0, 0.9, 0.1, 0.6, 0.3  ,  0.9, 0.9, 0.1, 0.4, 1.0))
		aura.Data.AddEvent(t + 0.2,(30, 1.0, 1.0, 0, 0, 1),(),(),(2,  0.8, 0.7, 0.1, 0.6, 0.3  ,  0.8, 0.7, 0.1, 0.4, 1.0))
		aura.Data.AddEvent(t + 0.5,(240, 0.01, 1.0, 0, 0, 1),(),(),(2,  0.6, 0.5, 0.1, 0.6, 0.4  ,  0.3, 0.0, 0.0, 0.4, 0.5))
		leches = leches + 1
		if (leches%frecRisa == 0):
			## Sonido y animacion de mofa
			mino.LaunchAnmType("standup")
			MinoSndRisa.Play(mino.Position[0], mino.Position[1], mino.Position[2], 0)
			print("JAJAJA NO ME PUEDES MATAR")
			leches = 0
#---- 

#---- Funciones para el sistema de particulas que simula humo
def ReduceSmoke3():
	global humo
	humo.RandomVelocity=30.0
	humo.Time2Live=30
	humo.DeathTime=Bladex.GetTime()+3.0
	print("humo muere en 3seg")

def ReduceSmoke2():
	global humo
	humo.Position=-15385.7878833,-22686.8248944,212444.659631
	humo.D=-450.0, 0.0, -450.0
	humo.RandomVelocity=40.0
	humo.Time2Live=40
	Bladex.AddScheduledFunc(Bladex.GetTime()+7.0, ReduceSmoke3, ())

def ReduceSmoke1():
	global humo
	humo.Time2Live=60
	Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, ReduceSmoke2, ())

def LaunchSmoke():
	global humo
	humo=Bladex.CreateEntity("Humo", "Entity Particle System D2",  -15385.7878833,-20686.8248944,212444.659631)
	humo.D=-250.0, 0.0, -250.0
	humo.ParticleType="LightDarkSmoke"
	humo.PPS=30
	humo.Time2Live=96
	humo.Velocity=0.0, 0.0, 0.0
	humo.RandomVelocity=20.0
	humo.Friction=0.07
	humo.YGravity=-1000
	Bladex.AddScheduledFunc(Bladex.GetTime()+3.0, ReduceSmoke1, ())
#---- 

#---- Funciones de combustion y destruccion en el puzzle del campanario
def CampanaEstatica():
	din = Bladex.GetEntity("Campana_Heavy")
	estat = Bladex.CreateEntity("Campana_Estatica","Campana",10000000.0, 10000000.0, 10000000.0, "Physic")
	estat = Sparks.SetMetalSparkling("Campana_Estatica")
	estat.Scale = din.Scale
	estat.Orientation = din.Orientation
	estat.Position = din.Position
	estat.Static = 1
	din.SubscribeToList ("Pin")
	print("campana ya Estatica")

def EliminarCenizas():
	### elimina las entidades quemadas
	o = Bladex.GetEntity("CuerdaBaja")
	o.SubscribeToList ("Pin")
	o = Bladex.GetEntity("CuerdaAlta")
	o.SubscribeToList ("Pin")
	o = Bladex.GetEntity("Viga_A")
	o.SubscribeToList ("Pin")
	o = Bladex.GetEntity("Viga_B")
	o.SubscribeToList ("Pin")
	print ("elimino cenizas")
	Bladex.AddScheduledFunc(Bladex.GetTime() + 9, CampanaEstatica, ())	

def QuitarCenizas():
	global faded

	faded = faded - 1
	t = Bladex.GetTime()
	if faded > 0:
		o = Bladex.GetEntity("CuerdaBaja")
		o.Alpha = o.Alpha/1.3		
		o = Bladex.GetEntity("CuerdaAlta")
		o.Alpha = o.Alpha/1.3		
		o = Bladex.GetEntity("Viga_A")
		o.Alpha = o.Alpha/1.3		
		o = Bladex.GetEntity("Viga_B")
		o.Alpha = o.Alpha/1.3
		## Llamada recursiva un segundo despues		
		Bladex.AddScheduledFunc(t+ 0.1, QuitarCenizas, ())
		print ("hecho fading")
	else:
		o = Bladex.GetEntity("CuerdaBaja")
		o.Alpha = 0
		o = Bladex.GetEntity("CuerdaAlta")
		o.Alpha = 0		
		o = Bladex.GetEntity("Viga_A")
		o.Alpha = 0		
		o = Bladex.GetEntity("Viga_B")
		o.Alpha = 0		
		Bladex.AddScheduledFunc(t+ 0.1, EliminarCenizas, ())
		print ("cenizas transparentes")

def PrenderVigaA(ObjectName, use_from):
	global Tviga
	global DTvigaA

	## Alteramos las propiedades del objeto
	o=Bladex.GetEntity("Viga_A")	
	o.CastShadows=0
	o.CatchOnFire(0,0,0)
	o.Data.UsedBy = ObjectName
	o.UseFunc=0
	print("quemo A")
	Actions.HumoDeFuego (o)

def PrenderVigaB(ObjectName, use_from):
	global Tviga
	global DTvigaB

	## Capturamos el tiempo para lanzar las funciones asociadas
	t = Bladex.GetTime()
	Bladex.AddScheduledFunc(t + Tviga, PrenderVigaA, (ObjectName, use_from))

	## Alteramos las propiedades del objeto
	o=Bladex.GetEntity("Viga_B")	
	o.CastShadows=0
	o.CatchOnFire(0,0,0)
	o.Data.UsedBy = ObjectName
	o.UseFunc=0
	print("quemo B")
	Actions.HumoDeFuego (o)

def PrenderCuerdaAlta(ObjectName, use_from):
	global Tcuerda
	global DTcuerdaAl

	## Capturamos el tiempo para lanzar las funciones asociadas
	t = Bladex.GetTime()
	Bladex.AddScheduledFunc(t + Tcuerda, PrenderVigaB, (ObjectName, use_from))

	## Alteramos las propiedades del objeto
	o=Bladex.GetEntity("CuerdaAlta")	
	o.CastShadows=0
	o.CatchOnFire(0,0,0)
	o.Data.UsedBy = ObjectName
	o.UseFunc=0
	print("quemo alta")
	Actions.HumoDeFuego (o)

def PrenderCuerda(ObjectName, use_from):
	global Tcuerda
	global DTcuerdaBa
	global BTtotal
	global DTtotal

#	Actions.StdSetFireToUseFunc(ObjectName,use_from)
	char = Bladex.GetEntity("Player1")
	AuxFuncs.GetSpot(Bladex.GetEntity(char.InvRight)).CastShadows = 0
	Torchs.ExtingueAntorcha(char.InvRight)

	## Capturamos el tiempo para lanzar las funciones asociadas
	t = Bladex.GetTime()
#	Bladex.AddScheduledFunc(t + Tcuerda, PrenderCuerdaAlta, (ObjectName, use_from))
	Bladex.AddScheduledFunc(t + 1.5, LaunchSmoke, ())
	Bladex.AddScheduledFunc(t + BTtotal - 1, QuitarCenizas, ())  	## Hace el fading de los objetos

	## Alteramos las propiedades del objeto
	o=Bladex.GetEntity("CuerdaBaja")	
	#o.CastShadows=0
	o.CatchOnFire(0,0,0)
	o.Data.UsedBy = ObjectName
	o.UseFunc=0
	MuereMinotauroCabron() ## Lo coloco
	print("quemo baja")
	
def funcCuerda(gpointer, use_from):
	global cuerdaQuemada

	print("llamada funcion ghost")
	if not cuerdaQuemada:
		char = Bladex.GetEntity("Player1")
		objright=Bladex.GetEntity(char.InvRight)	 
		objrighttorch=objright.Data.torchobjdata		 
		if objright and (objright.Kind in Torchs.tipos_antorcha) and (objrighttorch.LightStatus==Torchs.ON):	
			print("a prender")
			### Quito la funcion al tronchy
			t = Bladex.GetEntity("Tronchy_572")
			t.UseFunc = None
			###
			cuerdaQuemada = 1
			Actions.StdSetFireToUseFunc(gpointer,use_from) ## Para la animacion
			Bladex.AddScheduledFunc(Bladex.GetTime() + 1.5, PrenderCuerda, (gpointer, use_from))
			gp = Bladex.GetEntity("GhpCuerda")
			darfuncs.SetHint(gp, "")
			Bladex.AddScheduledFunc(Bladex.GetTime() + 5, gp.SubscribeToList, ("Pin"))
			EscCampana()
			print("fin funcCuerda")
#----

#---- Funcion de debug
def Trae():
	o=Bladex.GetEntity("Mechero")
	o.Position =(-16591.6770432, -20065.1293502, 212367.946759)

	o=Bladex.GetEntity("Palangana_291")
	o.Position =(-14591.6770432, -20065.1293502, 212367.946759)

	char.Position=(-16101.5154705, -21067.7582178, 212366.311359)
#----


#
###############################


###############################
#----------- patio.py ------------------
#--------------------------------------------------
#

#---- Funcion para descubrir los enemigos del patio
def DespiertaEnemigosPatio():
	darfuncs.UnhideBadGuy("Great_Ork_474")
	darfuncs.UnhideBadGuy("Ork_482")
	darfuncs.UnhideBadGuy("Ork_485")
#----

#---- Funcion que controla la muerte del gran orco del patio
def MuereGranOrcoPatio(entity):
	me = Bladex.GetEntity(entity)
	if me.Data.OldImDeadFunc:
		me.Data.OldImDeadFunc(entity)	
	AbrePuertaCampanario()
	print ("Orco muerto y campanario abierto")
#----

#---- Funciones para abrir/cerrar las puertas del patio
def AbrePuertaCampanario():
	p1.OpenDoor()

def CierraPuertaCampanario():
	p1.CloseDoor()

def AbrePuertaIglesia():
	p2.OpenDoor()
	ActivaGuardiaIglesia()

def CierraPuertaIglesia():
	p2.CloseDoor()
#---- 

#
###############################


###############################
#----------- patrullas.py ------------------
#--------------------------------------------------
#

#---- Funciones de las patrullas
def Paseillo_K_Pasillo():
	pers = Bladex.GetEntity("K_PasilloP")
	pers.AddBayPoint=-27710.3251475, -1096.2124937, 178329.676879
	pers.AddBayPoint=-34347.1319848, -1114.79241313, 183797.739225
	pers.Blind = 0
	pers.Deaf = 0
	pers.LaunchBayRoute() 

def Paseillo_K_NaveI():
	pers = Bladex.GetEntity("K_NaveI")
	pers.AddBayPoint=-20455.1325826, -1116.36397826, 182700.226387
	pers.AddBayPoint=-21465.462968, -1111.30193867, 139281.69121
	pers.Blind = 0
	pers.Deaf = 0
	pers.LaunchBayRoute() 

def Paseillo_Ks_Puerta():
	pers = Bladex.GetEntity("K1_Puerta")
	pers2 = Bladex.GetEntity("K2_Puerta")
	pers.AddBayPoint=-7245.53817803, -1119.24569734, 125994.494409
	pers.AddBayPoint=21114.2783673, -1098.25902347, 125858.47261
	pers.AddBayPoint=22056.7103346, -1115.60700734, 144024.510338
	pers2.AddBayPoint=22056.7103346, -1115.60700734, 144024.510338
	pers2.AddBayPoint=21114.2783673, -1098.25902347, 125858.47261
	pers2.AddBayPoint=-7245.53817803, -1119.24569734, 125994.494409
	pers.Blind = 0
	pers.Deaf = 0
	pers2.Blind = 0
	pers2.Deaf = 0
	pers.LaunchBayRoute() 
	pers2.LaunchBayRoute() 

def Paseillo_K_Altar():
	pers=Bladex.GetEntity("K_Altar")
	pers.AddBayPoint=21585.7045099, -1099.60078874, 185088.742069
	pers.AddBayPoint=6505.52042077, -1098.26706707, 185372.737257
	pers.AddBayPoint=4840.06384423, -3126.29196682, 198778.564855
	pers.AddBayPoint=-3864.38369528, -3113.95726803, 198585.963299
	pers.AddBayPoint=426.711891266, -1116.38992069, 186700.26295
	pers.Blind = 0
	pers.Deaf = 0
	pers.LaunchBayRoute()

def Paseillo_Ks_NaveC():
	pers = Bladex.GetEntity("K1_NaveC")
	pers2 = Bladex.GetEntity("K2_NaveC")
	persC = Bladex.GetEntity("KC_NaveC")
	pers.AddBayPoint=-5756.90388112, -1114.54575452, 181524.17022
	pers.AddBayPoint=-5438.26132375, -1130.2654096, 138890.928044
	pers.AddBayPoint=6503.7181302, -1105.6584555, 139657.26252
	pers.AddBayPoint=7761.22176861, -1113.01374714, 173901.913153
	pers2.AddBayPoint=-5156.90388112, -1114.54575452, 180524.17022
	pers2.AddBayPoint=-5438.26132375, -1130.2654096, 138890.928044
	pers2.AddBayPoint=6503.7181302, -1105.6584555, 139657.26252
	pers2.AddBayPoint=7761.22176861, -1113.01374714, 173901.913153
	pers.Blind = 0
	pers.Deaf = 0
	pers2.Blind = 0
	pers2.Deaf = 0
	persC.Blind = 0
	persC.Deaf = 0
	pers.LaunchBayRoute() 
	pers2.LaunchBayRoute() 

def Paseillo_K_Esc1():
	pers = Bladex.GetEntity("K_Esc1")
	pers.AddBayPoint=35589.5991413, -8096.85713284, 158618.333339
	pers.AddBayPoint=33141.9635134, -16113.0664176, 182393.846351
	pers.Blind = 0
	pers.Deaf = 0
	pers.LaunchBayRoute() 

def Paseillo_K_Esc2():
	pers = Bladex.GetEntity("K_Esc2")
	pers.AddBayPoint=30238.0577703, -16615.0759977, 182318.099273
	pers.AddBayPoint=30441.8932677, -23123.7549457, 160095.595541
	pers.Blind = 0
	pers.Deaf = 0
	pers.LaunchBayRoute() 
#---- 

#---- Funcion para controlar cuando se coge el mapa
mapaCogido = 0
def CojoMapa():
	global mapaCogido
	mapaCogido = 1
#---- 

#---- Funciones para disfrazarse de traitor
soyTraitor = 0
def MuereTraitorCentral(entity):
	me = Bladex.GetEntity(entity)
	if me.Data.OldImDeadFunc:
		me.Data.OldImDeadFunc(entity)
	#Bladex.AddScheduledFunc(Bladex.GetTime() + 2.0, CambiaCadaverporDisfraz, ("KC_NaveC"))
	CambiaCadaverporDisfraz("KC_NaveC")
	print("Fin MuereTraitor")
	
def CambiaCadaverporDisfraz(entity):	
	cuerpo = Bladex.GetEntity(entity)
	cuerpo.Data.Invincibility = 1
	cuerpo.UseFunc = Disfrazarse
#	cuerpo.Static = 1
	darfuncs.SetHint(cuerpo, Traduce("Cadaver"))
	print("se queda el disfraz en el suelo")

def Disfrazarse(ObjectName,use_from):
	Bladex.DeactivateInput()
	Scorer.SetVisible(0)

	t = Bladex.GetTime()
	AuxFuncs.FadeTo(1.0, 20.0)
#	Bladex.AddScheduledFunc(t + 2.0, Disfrazarse2, ("KC_NaveC"))
#	Bladex.AddScheduledFunc(t + 1.0, AuxFuncs.FadeTo, (1.0, 20.0))
	Bladex.AddScheduledFunc(t + 1.0, Disfrazarse2, ())
#	Disfrazarse2("KC_NaveC")
 	print("fin disfrazarse")

#def Disfrazarse2(ObjectName):
def Disfrazarse2():
	global soyTraitor

	char = Bladex.GetEntity("Player1")
#	object=Bladex.GetEntity(ObjectName)
	object=Bladex.GetEntity("KC_NaveC")

	# Sonido de disfrazarse
	sound=Bladex.CreateSound("..\\..\\Sounds\\cambio-armadura2.wav", "CambioTraje")
	sound.Volume=0.6
	sound.MinDistance=10000
	sound.MaxDistance=20000
	sound.PlayStereo()

	# Para quitar lo de las manos y luego volverlo a poner
	right= char.InvRight
	left= char.InvLeft
	rightback= char.InvRightBack
	leftback= char.InvLeftBack
	inv= char.GetInventory()
	inv.LinkRightHand ("")
	inv.LinkLeftHand ("")

	char.SetMesh("Dark_Knight")
	if rightback:
		inv.LinkRightHand (rightback)
		inv.LinkRightBack(rightback)
	if leftback:
		inv.LinkLeftHand (leftback)
		inv.LinkLeftBack(leftback)
	if right:
		inv.LinkRightHand (right)
	if left:
		inv.LinkLeftHand (left)
	## Ponemos un tio en bolas
	muerto=Bladex.CreateEntity("TraitorMuerto", "Prisoner_1", 0.0, 0.0, 0.0,"Person")
	muerto.Position = object.Position
	muerto.SetOnFloor()
	muerto.Static = 1
	muerto.Scale=1.0
	muerto.Blind=1
	muerto.Deaf=1
	muerto.Life=-1
	## Quitamos el cuerpo de enmedio
	object.SubscribeToList("Pin")

	FinAnimacionConFade()
	#AuxFuncs.FadeFrom(2.0, 0.0)
	soyTraitor = 1
	print("fin disfrazarse2")

def NoMutilar(self,EntityName,obj_name,x,y,z,nx,ny,nz,node):
	print("no mutilo")
#---- 

#---- Funcion para quitarse el disfraz
def QuitarseDisfraz():
	me = Bladex.GetEntity("Player1")
	ct = Bladex.GetCharType(me.CharType,me.CharTypeExt)
	AuxFuncs.FadeTo(1.5, 31.0)
	# Sonido de disfrazarse
	sound2=Bladex.CreateSound("..\\..\\Sounds\\cambio-armadura2.wav", "CambioTraje2")
	sound2.Volume=0.6
	Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5, GameText.WriteTextAux, (Traduce("Joder lo que pesa esta armadura... mejor me la quito"), 3.5,122,203,220,[]))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 1.7, sound2.Play, (char.Position[0], char.Position[1], char.Position[2], 0))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 1.9, me.SetMesh, (ct.NoArmour, ))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 2.3,	AuxFuncs.FadeFrom, (1.5, 0.0))
	print("<-sin disfraz")
#---- 

#---- Funciones para el control de las escaleras
def ControlEscaleras(sectorindex, entity):
	global soyTraitor
	global mapaCogido

	if entity == "Player1":
		sector=Bladex.GetSector(30000.0, -1000.0, 142000.0)
		sector.OnEnter=""
		print("control")
		if soyTraitor:
			print("soy Traidor")
			if mapaCogido:
				print("llevo mapa")
				EscCambioTurnoEscaleras()
			else:
				print("no llevo mapa")
				EscVeteaPaseoEscaleras()
		else:
			print("no soy Traidor")
			EscMuerteControlEscaleras()
		print("fin control escaleras")

def SuperGuerrero(EntityName, WeaponName, Cx, Cy, Cz, DirX, DirY, DirZ,wcx,wcy,wcz,wdx,wdy,wdz):
	### Le pongo un aura al vigilante para que se pispe el jugador y lanza chispitas
	t = Bladex.GetTime()
	aura=Auras.MakeAura("K_Vigilante",0.5, (1, 0.01, 1.0, 0, 0, 1),(),(),(2,  1.0, 0.9, 0.1, 0.6, 0.3  ,  0.9, 0.9, 0.1, 0.4, 1.0))
	aura.Data.AddEvent(t + 0.2,(30, 1.0, 1.0, 0, 0, 1),(),(),(2,  0.8, 0.7, 0.1, 0.6, 0.3  ,  0.8, 0.7, 0.1, 0.4, 1.0))
	aura.Data.AddEvent(t + 0.5,(240, 0.01, 1.0, 0, 0, 1),(),(),(2,  0.6, 0.5, 0.1, 0.6, 0.4  ,  0.3, 0.0, 0.0, 0.4, 0.5))
	Sparks.ThrowMetalSparks(EntityName, WeaponName, Cx, Cy, Cz, DirX, DirY, DirZ,wcx,wcy,wcz,wdx,wdy,wdz)
#---- 

#---- Funcion que abre el rastrillo de la capilla
def AbreCapilla():
	print("abro la capilla")
	desplazamientos=(4500.0, 1000.0)
	vectores=((0.0, -1.0, 0.0), (0.0, -1.0, 0.0))
	vel_iniciales=(0.0, 500)
	vel_finales=(500.0, 200)
	
	#sonidos asociados a la puerta-objeto rastrilloCapillaDIN
	son_iniciales=("", "")
	son_durante=(sonidorastrillo, sonidorastrillo)
	son_finales=("", golpemetalmediano)
	Objects.NDisplaceObject(rastrilloCapillaDIN, desplazamientos, vectores, vel_iniciales, vel_finales, (), son_durante, son_finales)
	print ("salgo de abrir capilla")
#---- 

#---- Funcion para controlar las muertes de los guardias en la iglesia
def MuerteIglesia(entity):
	global vivosIglesia

	print ("MuerteIglesia->")
	me = Bladex.GetEntity(entity)
	if me.Data.OldImDeadFunc:
		me.Data.OldImDeadFunc(entity)
	vivosIglesia = vivosIglesia - 1
	if vivosIglesia == 0:
		AbreCapilla()		
		print ("Todos muertos -> Abro Capilla")
	print ("<- MuerteIglesia")
#---- 

#---- Funcion para controlar las muertes de los guardias de la sala de armas
vivosSalaArmas = 2
def MuerteSalaArmas(entity):
	global vivosSalaArmas

	print ("MuerteSalaArmas->")
	me = Bladex.GetEntity(entity)
	if me.Data.OldImDeadFunc:
		me.Data.OldImDeadFunc(entity)
	vivosSalaArmas =	vivosSalaArmas - 1
	if vivosSalaArmas == 0:
		AbreSalaTrono()
		EscSalaTrono()
		print ("Todos muertos -> Abro Sala trono")
	print ("<- MuerteSalaArmas")
#---- 

#---- Funcion cuando matas al jefe, se acaba la beta y se lanza la animacion final
def MuerteJefe(entity):
	Bladex.DeactivateInput()
	Scorer.SetVisible(0)

	me = Bladex.GetEntity(entity)
	if me.Data.OldImDeadFunc:
		me.Data.OldImDeadFunc(entity)

	Bladex.AddScheduledFunc(Bladex.GetTime() + 0.5, SubirdeNivel, ("Player1", ))	
	Bladex.AddScheduledFunc(Bladex.GetTime() + 3.0, GameText.WriteTextAux, (Traduce("Ya te has muerto? Menudo payaso"), 3.5,122,203,220,[]))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 4.5, AuxFuncs.FadeTo, (2.0, 31.0))
	Bladex.AddScheduledFunc(Bladex.GetTime() + 9.0, EscFinal, ())
	print ("Jefe Muerto...")
#---- 

#---- Funciones que activan a los enemigos
def ActivaGuardiaIglesia():
	Paseillo_K_Altar()
	Paseillo_Ks_Puerta()
	Paseillo_K_NaveI()
	Paseillo_K_Pasillo()
	Paseillo_Ks_NaveC() ##activa los que andan y al que no lo hace no
#	pers = Bladex.GetEntity("K_Vigilante")
#	pers.Blind = 0
#	pers.Deaf = 0
	print("guardias iglesia activados")

def ActivaGuardiaEscaleras():
	Paseillo_K_Esc1()
	Paseillo_K_Esc2()
	pers = Bladex.GetEntity("K_Desc")
	pers.Blind = 0
	pers.Deaf = 0
	print("guardias escaleras activados")

def ActivaGuardiaSalaArmas():
	pers = Bladex.GetEntity("K1_SalaArmas")
	pers.Blind = 0
	pers.Deaf = 0
	pers = Bladex.GetEntity("K2_SalaArmas")
	pers.Blind = 0
	pers.Deaf = 0
	print("guardias sala armas activados")

def ActivaGuardiaSalaTrono():
##	pers = Bladex.GetEntity("K1_SalaTrono")
##	pers.Blind = 0
##	pers.Deaf = 0
##	pers = Bladex.GetEntity("K2_SalaTrono")
##	pers.Blind = 0
##	pers.Deaf = 0
	pers = Bladex.GetEntity("KC_SalaTrono")
	pers.Blind = 0
	pers.Deaf = 0
	print("guardias sala trono activados")

def ActivaGuardias():
	ActivaGuardiaIglesia()
	ActivaGuardiaEscaleras()
	ActivaGuardiaSalaArmas()
	##ActivaGuardiaSalaTrono()  <- Lo activamos en la animacin
	print("guardias activadas")

#---- Funciones par controlar la puerta de la sala del trono
def AbreSalaTrono():
	puertaSalaTrono.OpenDoor()

def CierraSalaTrono():
	puertaSalaTrono.CloseDoor()
#---- 


#
###############################

print ("Todo en DefFuncs.py")