#******************************************************************************************
#******************************************************************************************
# cementerio.py   ->  entidades, enemigos, etc... de la zona del cementerio
#******************************************************************************************
#******************************************************************************************

import Bladex
import GameText
import Doors
import Levers
import Locks
import Objects
import Sounds
import Button
import ReadGSFile
import AuxFuncs
import darfuncs
import Stars
import Sparks
import EnemyTypes
from math import pow
import Actions
import pocimac
import Reference
import ItemTypes
import EnmGenRnd
import Breakings


#################################################
### Orcos que estan en el suelo al entrar en el cementerio
o=Bladex.CreateEntity("Ork_491","Ork",-64940.3206154,265.088141104,186437.368447, "Person")
o.Scale=1.0
o.Angle=5.05421456985
o.Level=12
o.Life=1500.0
o.Blind=1
o.Deaf=1 # Despiertan tras la animacion que hay al salir
EnemyTypes.EnemyDefaultFuncs(o)
o.ActionAreaMin=pow(2,2)
o.ActionAreaMax=pow(2,3)
o=Bladex.CreateEntity ("Hacha2_492", "Hacha2", 0,0,0, "Weapon")
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject("Ork_491", "Hacha2_492")
o=Bladex.CreateEntity ("Escudo2_493", "Escudo2", 0,0,0)
ItemTypes.ItemDefaultFuncs(o)
Sparks.MakeShield("Escudo2_493")
Actions.TakeObject("Ork_491", "Escudo2_493")

o=Bladex.CreateEntity("Ork_494","Ork",-47652.4322703,265.088140994,194212.613042, "Person")
o.Scale=1.0
o.Angle=2.16181519286
o.Level=12
o.Life=1500.0
o.Blind=1
o.Deaf=1 # Despiertan tras la animacion que hay al salir
EnemyTypes.EnemyDefaultFuncs(o)
o.ActionAreaMin=pow(2,2)
o.ActionAreaMax=pow(2,3)
o=Bladex.CreateEntity ("Hacha2_495", "Hacha2", 0,0,0, "Weapon")
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject("Ork_494", "Hacha2_495")
o=Bladex.CreateEntity ("Escudo5_497", "Escudo5", 0,0,0)
ItemTypes.ItemDefaultFuncs(o)
Sparks.MakeShield("Escudo5_497")
Actions.TakeObject("Ork_494", "Escudo5_497")

### Orcos arqueros en la muralla del cementerio
o=Bladex.CreateEntity("Ork_501","Ork",-65129.8070247,-8984.91153655,181195.219202, "Person")
o.Scale=1.0
o.Angle=0.146600716136
o.Level=9
#o.Life=220.0
o.Blind=1
o.Deaf=1
inv=o.GetInventory()
arco=Bladex.CreateEntity("Arco_Ork_501","Arco",0,0,0,"Weapon")
carcaj=Bladex.CreateEntity("Carcaj_Ork_501","Carcaj2",0,0,0)
ItemTypes.ItemDefaultFuncs(arco)
ItemTypes.ItemDefaultFuncs(carcaj)
inv.AddBow(arco.Name)
#inv.AddQuiver(carcaj.Name)
#carcaj.Data.ArrowsLeft=10
#
carcaj.Data.SetNumberOfArrows(10, o.Name)
Actions.TakeObject(o.Name,carcaj.Name)
#
EnemyTypes.EnemyDefaultFuncs(o)
o.HitFunc = DameyMuero
o=Bladex.CreateEntity ("Hacha2_495arq", "Hacha2", 0,0,0, "Weapon")
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject("Ork_501", "Hacha2_495arq")

##o=Bladex.CreateEntity("Ork_502","Ork",-66692.9577511,-8984.91153655,183297.443607, "Person")
##o.Scale=1.0
##o.Angle=5.49130388393
##o.Level=9
#o.Life=220.0
##o.Blind=1
##o.Deaf=1
##inv=o.GetInventory()
##arco=Bladex.CreateEntity("Arco_Ork_502","Arco",0,0,0,"Weapon")
##carcaj=Bladex.CreateEntity("Carcaj_Ork_502","Carcaj",0,0,0)
##ItemTypes.ItemDefaultFuncs(arco)
##ItemTypes.ItemDefaultFuncs(carcaj)
##inv.AddBow(arco.Name)
##inv.AddQuiver(carcaj.Name)
##carcaj.Data.ArrowsLeft=15
##EnemyTypes.EnemyDefaultFuncs(o)
##o.HitFunc = DameyMuero
#################################################


#################################################
### Entidades para el mecanismo del rastrillo
o=Bladex.CreateEntity("TacitaLigera","Tacita",-64905.2279686,-424.229667063,180805.188971, Reference.ObjType("Tacita"))
o.Static=1
o.Scale=2.1
o.Orientation=(0.609514772892,0.632303953171,0.330386728048,-0.34572827816)
o.UseFunc=UsaTacita
darfuncs.SetHint(o,Traduce("Altar de las Ofrendas"))

o=Bladex.CreateEntity("Columnaestrecha_398","Columnaestrecha",-64885.2190777,388.152662051,180719.935683, Reference.ObjType("Columnaestrecha"))
o.Static=1
o.Scale=0.8
o.Orientation=(0.707308590412,0.706894695759,0.00105811969843,-0.00365427974612)
#################################################


#################################################
### Rastrillo que hace las veces de puerta
o=Bladex.CreateEntity("RastrilloCementerio","Rastrillo102",-45944.7927144,-569.994975836,196341.011272, Reference.ObjType("Rastrillo102"))
o.Scale=0.8
o.Orientation=(0.500000059605,0.500000059605,0.499999940395,-0.499999970198)
o=Sparks.SetMetalSparkling("RastrilloCementerio")
o.Frozen=1
## Creamos el objeto dinamico, que es el que vamos a mover
rastrilloCementerioDIN=Objects.CreateDinamicObject("RastrilloCementerio")
#################################################


#################################################
### Decoracion al otro lado de la verja
o=Bladex.CreateEntity("Arbolseco2_505","Arbolseco2",-72512.1429811,-319.740671791,189871.106524, Reference.ObjType("Arbolseco2"))
o.Static=1
o.Scale=1.8
o.Orientation=(0.0461478531361,-0.350528776646,0.699429392815,-0.621126770973)

o=Bladex.CreateEntity("PiedrasBarbaro_511","PiedrasBarbaro",-68613.0623418,1029.42292049,191823.905442, Reference.ObjType("PiedrasBarbaro"))
o.Static=1
o.Scale=1.2
o.Orientation=(0.821845769882,0.565344393253,-0.0611268132925,0.0349102839828)
#################################################

#################################################
## Sistema de particulas del cementerio
Bladex.AddParticleGType("Tierra2x","SmokeParticle",B_PARTICLE_GTYPE_BLEND,64)

for i in range(64):
	aux=(64.0-i)/64.0
	r=210
	g=190
	b=140
	a=255.0*(1.0-aux)**0.5
	size=80.0+aux*400.0
	Bladex.SetParticleGVal("Tierra2x",i,r,g,b,a,size)


Bladex.AddParticleGType("Tierra3x","GenericParticle",B_PARTICLE_GTYPE_BLEND,60)

for i in range(60):
	aux=(60-i)/60
	r=40
	g=30
	b=0
	a=255*(1.0-aux/2.0)
	size=60.0*(1.0-aux)
	Bladex.SetParticleGVal("Tierra3x",i,r,g,b,a,size)
#################################################

#################################################
## Generador de esqueletos del cementerio
## Creo un generador con 12 enemigos, salen de 3 en 3
#generadorT1 = EnmGenRnd.CreateEnemiesGenerator(12, 3)
generadorT1 = EnmGenRnd.CreateEnemiesGenerator(8, 2)
generadorT1.CallBak =  Facilitar
## Las posiciones se corresponden mas o menos con las tumbas del cementerio
generadorT1.AddPoint((-56957.038060, 1800.0, 186766.120529),("TombGen11Skl_1", "Skeleton", "Espadaromana", 0, "Escudo5", 1), "Skl_appears1",4)
generadorT1.AddPoint((-58807.402093, 1800.0, 189189.598259),("TombGen11Skl_2", "Skeleton", "Espadaromana", 0, "Escudo2", 1), "Skl_appears1",5)
generadorT1.AddPoint((-53498.229393, 1800.0, 186003.01025),("TombGen11Skl_3", "Skeleton", "Hacha4", 0, "Escudo2", 1), "Skl_appears1",5)
generadorT1.AddPoint((-51926.576757, 1800.0, 195288.843238),("TombGen11Skl_4", "Skeleton", "Maza2", 0, "Escudo2", 1), "Skl_appears1",5)
generadorT1.AddPoint((-50428.437801, 1800.0, 184934.085896),("TombGen11Skl_5", "Skeleton", "Hacha3", 0, "Escudo5", 1), "Skl_appears1",6)
generadorT1.AddPoint((-50354.447056, 1800.0, 188774.570527),("TombGen11Skl_6", "Skeleton", "HookSword", 0, "Escudo2", 1), "Skl_appears1",7)
generadorT1.AddPoint((-53065.179745, 1800.0, 196480.533523),("TombGen11Skl_7", "Skeleton", "Hacha4", 0, "Escudo1", 1), "Skl_appears1",6)
generadorT1.AddPoint((-49927.267586, 1800.0, 191725.952608),("TombGen11Skl_8", "Skeleton", "HookSword", 0, "Escudo1", 1), "Skl_appears1",7)
#generadorT1.AddPoint((-53756.098843, 1800.0, 192407.478514),("TombGen11Skl_9", "Skeleton", "Hacha3", 0, "Escudo2", 1), "Skl_appears1",8)
#generadorT1.AddPoint((-52637.817726, 1800.0, 191284.193163),("TombGen11Skl_10", "Skeleton", "Hacha3", 0, "Escudo1", 1), "Skl_appears1",8)
#generadorT1.AddPoint((-56345.533081, 1800.0, 194248.124069),("TombGen11Skl_11", "Skeleton", "Maza2", 0, "Escudo2", 1), "Skl_appears1",9)
#generadorT1.AddPoint((-55706.116919, 1800.0, 190584.755548),("TombGen11Skl_12", "Skeleton", "HookSword", 0, "Escudo1", 1), "Skl_appears1",10)
generadorT1.InitGenFunc=SaltaTierraGen2
generadorT1.Activate()
generadorT1.FinishGenFunc=FinGeneradorT1
#################################################


#################################################
### Entidades que intervienen en el derrumbe del muro
murogrietader=Bladex.GetSector(-66408.5279614, 182.960091578, 196527.832093)
murogrietader.Active=0

murogrietaizq=Bladex.GetSector(-66408.5279614, 937.270176366, 195396.583033)
murogrietaizq.Active=0

murogrietader.InitBreak((200.0, 1500.0, 200.0), (0.0, 500.0, 100.0), (100.0, 100.0, 500.0))
murogrietaizq.InitBreak((300.0, 0.0, 0.0), (0.0, 0.0, 1230.0), (0.0, 0.0, 730.0))
#################################################

#################################################
### Sistema de particulas del muro
Bladex.AddParticleGType("WallDust","SmokeParticle",B_PARTICLE_GTYPE_BLEND,60)

for i in range(60):
	if i>30:
		traux=0.0
	else:
		traux=((30.0-i)/30.0)**0.5
	aux=((60.0-i)/60.0)**0.5
	r=215
	g=180
	b=190
	a=60.0*(1.0-traux)
	size=7.0+aux*1000.0
	Bladex.SetParticleGVal("WallDust",i,r,g,b,a,size)
#################################################


#################################################
### Entidades que se encuentran al derribar el muro
o=Bladex.CreateEntity("Femur_554","Femur",-68380.7907081,123.449235523,196481.50683, "Weapon")
o.Scale=1.0
o.Orientation=(0.899231612682,0.00747514562681,0.00475454423577,-0.437383204699)

o=Bladex.CreateEntity("Femur_555","Femur",-67754.9004418,133.51613404,196619.488954, "Weapon")
o.Scale=1.0
o.Orientation=(0.297713398933,-0.0889452621341,0.950500071049,-0.00224579521455)

o=Bladex.CreateEntity("Restos_553","Restos",-68026.0711602,97.1132288028,196314.884002, Reference.ObjType("Restos"))
o.Scale=1.0
o.Orientation=(0.914986133575,-0.312202990055,-0.0998745560646,0.23527598381)

o=Bladex.CreateEntity("Columna_552","Columna",-68129.7956588,753.356636064,196504.444439, Reference.ObjType("Columna"))
o.Scale=1.2
o.Orientation=(0.707106769085,0.707106769085,0.0,0.0)

#### Esta calavera se pasa al inventario para usarla en la tacita
o=Bladex.CreateEntity("PiedraPesada","Skull",-68048.3710157,77.6747078144,196571.963919, Reference.ObjType("Pergamino2"))
o.Scale=1.0
o.Orientation=(0.338956832886,0.381909042597,-0.791475236416,0.335887849331)
Reference.DefaultObjectData['Skull']=            [Reference.OBJ_ITEM]
darfuncs.SetHint(o,Traduce("Calavera Ancestral"))
ItemTypes.ItemDefaultFuncs(o)

o=Bladex.CreateEntity("BolitadeFuego_562","BolitadeFuego",-68071.0308918,87.8651967407,196608.143421, Reference.ObjType("BolitadeFuego"))
o.Static=1
o.Scale=2.0
o.Orientation=(0.382683426142,0.923879504204,0.0,0.0)
o.FiresIntensity=[ -2.0 ]
o.Lights = [(2.0, 0.0500000007451, (128, 128, 255))]
#################################################

################################################################
## Entidades de la sala del tallador
o=Bladex.CreateEntity("Mesa_520","Mesa",-43239.0685165,569.940709286,176702.450521, Reference.ObjType("Mesa"))
o.Scale=1.2
o.Orientation=(0.707106769085,0.707106769085,0.0,0.0)
#Breakings.SetBreakable("Mesa_520",12,100)

o=Bladex.CreateEntity("Antorchaenpared_521","Antorchaenpared",-40839.0685165,-630.059290714,180002.450521, Reference.ObjType("Antorchaenpared"))
o.Static=1
o.Scale=1.0
o.Orientation=(0.560985565186,0.560985565186,0.430459290743,-0.430459320545)
o.FiresIntensity=[ 0.0 ]
o.Lights = [(7.0, 0.03125, (220, 170, 100))]

o=Bladex.CreateEntity("Bloque_530","Bloque",-36947.6534052,847.18355361,179331.303884, Reference.ObjType("Bloque"))
o.Static=1
o.Scale=1.6
o.Orientation=(0.935523569584,-0.000506533309817,0.353261560202,-0.001292248955)

o=Bladex.CreateEntity("Bloque_532","Bloque",-36646.0635486,789.620229884,178294.687559, Reference.ObjType("Bloque"))
o.Static=1
o.Scale=1.2
o.Orientation=(0.639105618,0.301727235317,0.301852881908,0.63983553648)

o=Bladex.CreateEntity("BloqueTallado_531","BloqueTallado",-36666.7024231,57.467128955,179339.752093, Reference.ObjType("BloqueTallado"))
o.Static=1
o.Scale=1.4
o.Orientation=(0.860629558563,-0.023385129869,-0.50174677372,0.0837859660387)

o=Bladex.CreateEntity("Lapida_534","Lapida",-42532.715707,860.641368414,179435.641695, Reference.ObjType("Lapida"))
o.Scale=0.8
o.Orientation=(0.113016523421,0.291332304478,0.360410392284,-0.878895401955)

o=Bladex.CreateEntity("Lapida_533","Lapida",-43239.8990672,725.547637667,179711.583525, Reference.ObjType("Lapida"))
o.Scale=1.0
o.Orientation=(0.933457612991,0.358400285244,-0.0142702534795,0.00156832730863)

o=Bladex.CreateEntity("Barril_539","Barril",-36729.8886776,822.581240343,175276.494381, Reference.ObjType("Barril"))
o.Scale=1.0
o.Orientation=(0.204207926989,-0.211735144258,0.676839828491,0.674800097942)
Breakings.SetBreakable("Barril_539",12,100)

### Pocima oculta en el barril pequenyo
o=Bladex.CreateEntity("Barril_535","Barril",-36493.1518859,495.602951659,174446.578725, Reference.ObjType("Barril"))
o.Scale=1.8
o.Orientation=(0.2085942626,-0.210178732872,0.676913797855,0.673870146275)
poci=Breakings.CreateHiddenObject("pocima100_2", "Pocima100", 0.9, (0.0,0.0,0.0), (0.707107,0.707107,0.000000,0.000000))
pocimac.CreatePotion("pocima100_2")
Breakings.SetBreakable("Barril_535",12,100, "pocima100_2")

o=Bladex.CreateEntity("Cajon_537","Cajon",-37921.3351239,887.821014461,175012.353193, Reference.ObjType("Cajon"))
o.Scale=0.6
o.Orientation=(0.563845276833,0.558115303516,0.432350665331,-0.428554236889)
Breakings.SetBreakable("Cajon_537",12,100)

o=Bladex.CreateEntity("Lapida3_540","Lapida3",-43064.2421831,-101.603065854,176631.884202, Reference.ObjType("Lapida3"))
o.Scale=1.0
o.Orientation=(0.972783267498,0.00233209202997,-0.231705024838,0.000325196277117)

o=Bladex.CreateEntity("Taburete_Cincelador","Taburete",-41543.8226649,1000.17542259,178248.790282, "Weapon")
o.Scale=1.0
o.Orientation=(0.57625079155,-0.579251766205,0.406691014767,0.408662319183)

o=Bladex.CreateEntity("Pala_542","Pala",-37692.9661093,779.876654315,174855.794115, "Weapon")
o.Scale=1.0
o.Orientation=(0.700279712677,-0.536825656891,0.0325821936131,0.469430416822)

o=Bladex.CreateEntity("CincelLapidas","Cincel",-40221.4348023,1193.18542387,176601.97067, "Physic")
##Reference.ObjType("Pergamino2")
o.Scale=1.0
o.Orientation=(0.460073560476,0.0517016686499,0.885531425476,-0.0386435352266)
Reference.DefaultObjectData['Cincel']=            [Reference.OBJ_ITEM]
ItemTypes.ItemDefaultFuncs(o)
darfuncs.SetHint(o, Traduce("Cincel"))

o=Bladex.CreateEntity("VigaPlana_545","VigaPlana",-40541.1968232,-917.756166154,175455.224737, Reference.ObjType("VigaPlana"))
o.Static=1
o.Scale=1.6
o.Orientation=(1.0,0.0,0.0,0.0)

o=Bladex.CreateEntity("Botella_546","Botella",-40941.1963392,-1041.91241615,175455.225511, "Weapon")
o.Scale=0.6
o.Orientation=(0.707106769085,0.707106769085,0.0,0.0)

o=Bladex.CreateEntity("Saquito_547","Saquito",-40424.8455432,-995.67481466,175479.858184, Reference.ObjType("Saquito"))
o.Scale=0.8
o.Orientation=(0.358192056417,0.569428920746,0.527030289173,0.519315183163)
darfuncs.SetHint(o,Traduce("Saquito"))

talladormuerto=Bladex.CreateEntity("TalladorMuerto", "Prisoner_6",-41543.8226649,1000.17542259,178248.790282,"Person")
talladormuerto.Scale=1.0
talladormuerto.Blind=1
talladormuerto.Deaf=1
talladormuerto.Life=-1
#talladormuerto.Wuea=Reference.WUEA_ENDED
#talladormuerto.LaunchAnimation("Prs_dth")
talladormuerto.Position = (-41156.5209669,1143.57687069,177030.00061)
talladormuerto.Angle=1.30899682304

o=Bladex.CreateEntity("MartilloLapidas","MartilloForja",-43262.548202,-91.4480270248,177334.11322, "Weapon")
o.Scale=1.2
o.Orientation=(0.729317486286,-0.0937574729323,0.187086045742,0.651386499405)

### Arco y Flechas para cargarse a los de arriba
arco=Bladex.CreateEntity("Arco2_573","Arco2",-36012.3148408,1196.99940782,177815.797467, "Weapon")
arco.Scale=1.0
arco.Orientation=(0.614705681801,0.000443873577751,0.000379411474569,0.788756370544)

carcaj=Bladex.CreateEntity("Carcaj2_575","Carcaj2",-36218.5580442,1186.8677625,178288.179393, "Weapon")
carcaj.Scale=0.8
carcaj.Orientation=(0.132534146309,0.00844234414399,0.991000950336,-0.0167477428913)

ItemTypes.ItemDefaultFuncs(arco)
ItemTypes.ItemDefaultFuncs(carcaj)
carcaj.Data.ArrowsLeft=10
################################################################

################################################################
# Esquirlas del cementerio
o=Bladex.CreateEntity("Esquirla_597","Esquirla",-65944.9413238,-293.011662072,196021.851526, Reference.ObjType("Esquirla"))
o.Static=1
o.Scale=0.85
o.Orientation=(1.0,0.0,0.0,0.0)
darfuncs.SetHint(o,"")

o=Bladex.CreateEntity("Esquirla_598","Esquirla",-65992.7210075,-389.492966482,196069.490947, Reference.ObjType("Esquirla"))
o.Static=1
o.Scale=0.55
o.Orientation=(0.0,1.0,0.0,0.0)
darfuncs.SetHint(o,"")

o=Bladex.CreateEntity("Esquirla_599","Esquirla",-65985.3522174,-321.332091328,196099.648307, Reference.ObjType("Esquirla"))
o.Static=1
o.Scale=0.55
o.Orientation=(0.382683426142,-0.923879504204,0.0,0.0)
darfuncs.SetHint(o,"")
################################################################