#******************************************************************************************
#******************************************************************************************
# criptas.py -> entidades, enemigos, etc... de la zona de las criptas
#******************************************************************************************
#******************************************************************************************

import Bladex
import Doors
import Levers
import Locks
import Objects
import Sounds
import Button
import ReadGSFile
import AuxFuncs
import darfuncs
import Stars
import Sparks
import EnemyTypes
from math import pow
import Actions
import pocimac

########################################################
# Definicion de variables
rastrilloCrpJodido=1	## Se cambia al matar a las momias
rastrilloCrpAbierto=0	## Se cambia al abrir/cerrar el rastrillo
momiasCreadas=0		## Controla que se hayan creado las momias de la cripta izquierda
momias2Creadas=0	## Controla que se hayan creado las momias de la cripta derecha
vivosCriptaI=0		## Contador del numero de enemigos vivos en la cripta izquierda
vivosCriptaD=0		## Contador del numero de enemigos vivos en la cripta izquierda
crearGolems=0		## Indica si al entrar en cierto sector hay que abrir una puerta
golemsVivos=2		## Contador de los golems de la gran cripta
vampirosVivos=2		## Contador de los vampiros de la gran cripta
########################################################

########################################################
## Momias de la cripta izquierda
##### Momia 1
vivosCriptaI=vivosCriptaI+1 
o=Bladex.CreateEntity("Lich_435","Lich",-78269.9696226,2518.79606548,159317.195022, "Person")
o.Scale=1.0
o.Angle=3.45368912173
o.Level=9
o.Life=700.0
#o.Deaf= 1
#o.Blind= 1
EnemyTypes.EnemyDefaultFuncs(o)
#o.Life=69.0
o.Data.OldImDeadFunc = o.ImDeadFunc
o.ImDeadFunc = MuerteCriptaI
o=Bladex.CreateEntity ("Martillo2_436", "Martillo2", 0,0,0, "Weapon")
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject("Lich_435", "Martillo2_436")
darfuncs.HideBadGuy("Lich_435")

##### Momia 2
vivosCriptaI=vivosCriptaI+1 
o=Bladex.CreateEntity("Lich_434","Lich",-77508.3434873,2520.42938298,152399.369141, "Person")
o.Scale=1.0
o.Angle=5.42386975976
o.Level=8
o.Life=600.0
#o.Deaf= 1
#o.Blind= 1
EnemyTypes.EnemyDefaultFuncs(o)
#o.Life=69.0
o.Data.OldImDeadFunc = o.ImDeadFunc
o.ImDeadFunc = MuerteCriptaI
##o=Bladex.CreateEntity ("Martillo2_434", "Martillo2", 0,0,0, "Weapon")
o=Bladex.CreateEntity ("Martillo2_434", "Hacha3", 0,0,0, "Weapon")
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject("Lich_434", "Martillo2_434")
darfuncs.HideBadGuy("Lich_434")
	
##### Caballero Zombie
##vivosCriptaI=vivosCriptaI+1 
##o=Bladex.CreateEntity("Knight_Zombie_437","Knight_Zombie",-79090.9090344,2527.70357285,155596.089425, "Person")
##o.Scale=1.0
##o.Angle=4.44297023048
##o.Level=12
##o.Life=800.0
#o.Deaf= 1
#o.Blind= 1
##EnemyTypes.EnemyDefaultFuncs(o)
#o.Life=69.0
##o.Data.OldImDeadFunc = o.ImDeadFunc
##o.ImDeadFunc = MuerteCriptaI
##o=Bladex.CreateEntity ("Hacha3_440", "Hacha3", 0,0,0, "Weapon")
##ItemTypes.ItemDefaultFuncs(o)
##Actions.TakeObject("Knight_Zombie_437", "Hacha3_440")
##o=Bladex.CreateEntity ("Escudo1_439", "Escudo1", 0,0,0)
##ItemTypes.ItemDefaultFuncs(o)
##Sparks.MakeShield("Escudo1_439")
##Actions.TakeObject("Knight_Zombie_437", "Escudo1_439")
##darfuncs.HideBadGuy("Knight_Zombie_437")
########################################################
	
########################################################
# Objetos/Sectores que conforman cada puerta
## Rastrillo de la cripta izquierda
rastrilloCriptaI=Bladex.CreateEntity("RastCrpI","Rastrillo2",-68496.1975855,934.167850244,156041.228433,"Physic") 
rastrilloCriptaI.Scale=0.95
rastrilloCriptaI.Orientation=(0.5,0.500000059605,0.499999970198,-0.499999970198)
rastrilloCriptaI=Sparks.SetMetalSparkling("RastCrpI")
rastrilloCriptaI.Frozen=1
## Creamos el objeto dinamico, que es el que vamos a mover
rastrilloCriptaIDIN=Objects.CreateDinamicObject("RastCrpI")

## Entrada a la gran cripta
pCripta=Doors.CreateDoor("puertaCripta",(-53398.5002555, 2385.06574656, 149479.342453),(0,1,0),0,6200,Doors.CLOSED)
pCripta.opentype=Doors.UNIF
pCripta.o_med_vel=-400
pCripta.o_med_displ=5500
pCripta.closetype=Doors.AC
pCripta.c_init_displ=6200
pCripta.c_med_vel=7000

## Salida de la cripta
salCripta=Doors.CreateDoor("salidaCripta",(-53408.6388867, -115.830186463, 179446.720256),(0,1,0),0,4200,Doors.CLOSED)
salCripta.opentype=Doors.UNIF
salCripta.o_med_vel=-600
salCripta.o_med_displ=3000
salCripta.closetype=Doors.AC
salCripta.c_init_displ=4200
salCripta.c_med_vel=9000
########################################################

########################################################
# Asociacion de sonidos a cada puerta
## Entrada a la gran cripta
pCripta.SetWhileCloseSound(spuertar1d)
pCripta.SetEndCloseSound(spuertar1g)
pCripta.SetWhileOpenSound(spuertar1d)
pCripta.SetEndOpenSound(spuertar1g)
## Salida de la cripta
salCripta.SetWhileCloseSound(spuertar1d)
salCripta.SetEndCloseSound(spuertar1g)
salCripta.SetWhileOpenSound(spuertar1d)
salCripta.SetEndOpenSound(spuertar1g)
########################################################

#######################################################
# Artilugios para la apertura de las puertas (palancas, llaves, cerraduras, muertes,...)
## Rastrillo de la cripta izquierda (PALANCA EN SU INTERIOR)
palanRastrilloCriptaI=Levers.PlaceLever("palancaRastrilloCriptaI",Levers.LeverType3,(-69100.1417335, 1988.03194339, 153500.620702),(0.495618,0.495618,0.504344,-0.504344),0.8)
palanRastrilloCriptaI.Scale=0.8
palanRastrilloCriptaI.mode=1  ## Este modo vuelve arriba solo (Antes de matar a las momias, mode 3 despues)
##palanRastrilloCriptaI.mode=3  ## Este modo diferencia las posiciones On/Off (Cambia al matar a las momias)
palanRastrilloCriptaI.OnTurnOnFunc=AbreRastrilloCriptaI
palanRastrilloCriptaI.OnTurnOnArgs=()
### El rastrillo se cierra desde otro sector (por eventos)
palanRastrilloCriptaI.OnTurnOffFunc=CierraRastrilloCriptaI
palanRastrilloCriptaI.OnTurnOffArgs=()
#######################################################

#######################################################
#### Vampiros que nos esperan en la cripta
o=Bladex.CreateEntity("Vamp_467","Vamp",-65700.0000315,103170.13820374,137013.990542, "Person")
o.Scale=1.0
o.Angle=4.08760746916
o.Level=7
EnemyTypes.EnemyDefaultFuncs(o)
o.Life=3500.0
#o.Life=69.0
o.Data.OldImDeadFunc = o.ImDeadFunc
o.ImDeadFunc = MuereVampiroCripta
o=Bladex.CreateEntity ("VampWeapon_468", "VampWeapon", 0,0,0, "Weapon")
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject("Vamp_467", "VampWeapon_468")
#o=Bladex.CreateEntity ("VampShield_469", "VampShield", 0,0,0)
#ItemTypes.ItemDefaultFuncs(o)
#Sparks.MakeShield("VampShield_469")
#Actions.TakeObject("Vamp_467", "VampShield_469")


o=Bladex.CreateEntity("Vamp_470","Vamp",-47128.4662987,103170.13805788,136283.335429, "Person")
o.Scale=1.0
o.Angle=2.11694177494
o.Level=7
EnemyTypes.EnemyDefaultFuncs(o)
o.Life=3500.0
#o.Life=69.0
o.Data.OldImDeadFunc = o.ImDeadFunc
o.ImDeadFunc = MuereVampiroCripta
o=Bladex.CreateEntity ("VampWeapon_471", "VampWeapon", 0,0,0, "Weapon")
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject("Vamp_470", "VampWeapon_471")
#o=Bladex.CreateEntity ("VampShield_472", "VampShield", 0,0,0)
#ItemTypes.ItemDefaultFuncs(o)
#Sparks.MakeShield("VampShield_472")
#Actions.TakeObject("Vamp_470", "VampShield_472")
#######################################################

#######################################################
## Estatuas de golems (desaparecen cuando aparecen los correspondientes golems
#### POSICIONES: (2)-46201.8842766,1405.3132805,159189.141739  -> o.Angle=1.15079897704
####                           (1)-46051.7235642,1405.31328032,169402.46765 -> o.Angle=1.66385417504
o=Bladex.CreateEntity("EstatuaGolem1","EstatuaGolem",-46051.7235642,1405.31328032,169402.46765, Reference.ObjType("EstatuaGolem"))
o.Static=1
o.Scale=1.0
o.Orientation=(0.568797647953,0.557968139648,0.431360304356,-0.423165529966)

o=Bladex.CreateEntity("EstatuaGolem2","EstatuaGolem",-46201.8842766,1405.3132805,159189.141739, Reference.ObjType("EstatuaGolem"))
o.Static=1
o.Scale=1.0
o.Orientation=(0.430459320545,0.430459320545,0.560985565186,-0.560985505581)

## Ponemos los golems a mucha altura, los bajamos cuando corresponda
o=Bladex.CreateEntity("Golem1","Golem_stone",-46051.7235642,101405.31328032,169402.46765, "Person")
o.Scale=1.0
o.Angle=1.66385417504
o.Level=9
o.Blind=1
o.Deaf=1
EnemyTypes.EnemyDefaultFuncs(o)
#o.Life=69.0
o.Life=4000.0
o.Data.OldImDeadFunc = o.ImDeadFunc
o.ImDeadFunc = MuereGolemCripta

o=Bladex.CreateEntity("Golem2","Golem_stone",-46201.8842766,101405.3132805,159189.141739, "Person")
o.Scale=1.0
o.Angle=1.15079897704
o.Level=9
o.Blind=1
o.Deaf=1
EnemyTypes.EnemyDefaultFuncs(o)
#o.Life=69.0
o.Life=4000.0
o.Data.OldImDeadFunc = o.ImDeadFunc
o.ImDeadFunc = MuereGolemCripta
#######################################################


########################################################
## Eventos asociados a sectores
#### Sector de cerrar el rastrillo, crear los golems, cerrar la granCripta
#(-57000.0, 0.0, 171000.0)
SecCrearGolems=Bladex.GetSector(-57000.0, 0.0, 171000.0)
SecCrearGolems.OnEnter=EntraSectorGolems

#### Sector de animacion de la gran cripta
#(-56847.0800542, 2887.55046519, 148261.213405)
SecEscenaCripta=Bladex.GetSector(-56847.0800542, 2887.55046519, 148261.213405)
SecEscenaCripta.OnEnter=EscGranCripta

#### Sector de traer a los vampiros (HolaVampiros lanza la animacion)
#(-57098.9820683, 1384.509737176, 126874.580326)
SecTraerVampiros=Bladex.GetSector(-57098.9820683, 1384.509737176, 126874.580326)
SecTraerVampiros.OnEnter=HolaVampiros

#### Sector que cierra el acceso a las criptas
#(-53000.0, 0.0, 183000.0)
SecCerrarCriptas=Bladex.GetSector(-53000.0, 0.0, 183000.0)
SecCerrarCriptas.OnEnter=CierraSalidaCripta
########################################################

print ("Todo en criptas.py")