#******************************************************************************************
#******************************************************************************************
# patio.py  -> elementos del patio del campanario
#******************************************************************************************
#******************************************************************************************

# Imports necesarios
from math import pow
import EnemyTypes
import Actions
import Bladex
import Reference
import Breakings
import math
import AuxFuncs
import Torchs
import Doors
import Levers
import Locks
import Objects
import Sounds
import darfuncs
import Stars

################################################################
## Enemigos del patio
o=Bladex.CreateEntity("Great_Ork_474","Great_Ork",-11835.7780953,-87.6652025329,208215.627109, "Person")
o.Scale=1.0
o.Angle=3.07898370562
o.Level=12
#o.Life=1900.0
o.ActionAreaMin=math.pow(2,7)
o.ActionAreaMax=math.pow(2,6)
EnemyTypes.EnemyDefaultFuncs(o)
#o.Life = 10
#o.Deaf = 1
#o.Blind = 1
## Al morir abre la entrada al campanario
o.Data.OldImDeadFunc = o.ImDeadFunc
o.ImDeadFunc = MuereGranOrcoPatio
o=Bladex.CreateEntity ("Garrote2_475", "Garrote2", 0,0,0, "Weapon")
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject("Great_Ork_474", "Garrote2_475")
o=Bladex.CreateEntity ("Escudo9_481", "Escudo9", 0,0,0)
ItemTypes.ItemDefaultFuncs(o)
Sparks.MakeShield("Escudo9_481")
Actions.TakeObject("Great_Ork_474", "Escudo9_481")
o=Bladex.CreateEntity ("Pocima50_477", "Pocima50", 0,0,0)
o.Static=0
o.Solid=1
pocimac.CreatePotion("Pocima50_477")
Actions.TakeObject("Great_Ork_474", "Pocima50_477")
darfuncs.HideBadGuy("Great_Ork_474")

o=Bladex.CreateEntity("Ork_482","Ork",-31786.5489511,-484.911536547,188008.115011, "Person")
o.Scale=1.0
o.Angle=0.654389297713
o.Level=13
o.Life=1700.0
o.ActionAreaMin=math.pow(2,6)
o.ActionAreaMax=math.pow(2,7)
EnemyTypes.EnemyDefaultFuncs(o)
#o.Life = 10
#o.Deaf = 1
#o.Blind = 1
o=Bladex.CreateEntity ("Orksword_483", "Orksword", 0,0,0, "Weapon")
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject("Ork_482", "Orksword_483")
o=Bladex.CreateEntity ("Escudo2_484", "Escudo2", 0,0,0)
ItemTypes.ItemDefaultFuncs(o)
Sparks.MakeShield("Escudo2_484")
Actions.TakeObject("Ork_482", "Escudo2_484")
darfuncs.HideBadGuy("Ork_482")

o=Bladex.CreateEntity("Ork_485","Ork",-36560.723436,-484.911536547,188313.246722, "Person")
o.Scale=1.0
o.Angle=6.07863591337
o.Level=13
o.Life=1700.0
o.ActionAreaMin=math.pow(2,6)
o.ActionAreaMax=math.pow(2,7)
EnemyTypes.EnemyDefaultFuncs(o)
#o.Life = 10
#o.Deaf = 1
#o.Blind = 1
o=Bladex.CreateEntity ("Orksword_486", "Orksword", 0,0,0, "Weapon")
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject("Ork_485", "Orksword_486")
o=Bladex.CreateEntity ("Escudo2_487", "Escudo2", 0,0,0)
ItemTypes.ItemDefaultFuncs(o)
Sparks.MakeShield("Escudo2_487")
Actions.TakeObject("Ork_485", "Escudo2_487")
darfuncs.HideBadGuy("Ork_485")
################################################################

################################################################
## Puertas del patio

### Puerta del campanario
### (-12491.615712, -59.2347914751, 209116.107395)
p1=Doors.CreateDoor("p1",  (-12000.615712, -59.2347914751, 209816.107395),(0,1,0),0,4500,Doors.CLOSED)
p1.opentype=Doors.UNIF
p1.o_med_vel=-500
p1.o_med_displ=3750
p1.closetype=Doors.AC
p1.c_init_displ=4500
p1.c_med_vel=12000
p1.SetWhileOpenSound(spuertar1d)
p1.SetEndOpenSound(spuertar1g)
p1.SetWhileCloseSound(spuertar1d)
p1.SetEndCloseSound(spuertar1g)

### Puerta de la iglesia (la llave la tiene el minotauro)
### (-33499.4838254, -1093.14805792, 186540.126197)
p2=Doors.CreateDoor("p2",  (-33499.4838254, -1093.14805792, 186540.126197),(0,1,0),0,4500,Doors.CLOSED)
p2.opentype=Doors.UNIF
p2.o_med_vel=-500
p2.o_med_displ=3925
p2.closetype=Doors.AC
p2.c_init_displ=4500
p2.c_med_vel=12000
p2.SetWhileOpenSound(spuertar1d)
p2.SetEndOpenSound(spuertar1g)
p2.SetWhileCloseSound(spuertar1d)
p2.SetEndCloseSound(spuertar1g)

## Cerradura de la puerta... se abre con la llave del minotauro
#o=Bladex.CreateEntity("Cerradurpla_513","Cerradurpla",-36331.4769877,-870.940095488,187007.717097, Reference.ObjType("Cerradurpla"))
#o.Scale=1.8
#o.Orientation=(0.499999970198,0.500000059605,-0.499999970198,0.5)

## Cerradura y llave
cerradurap2=Locks.PlaceLock("cerradurap2","Cerradurpla",(-36331.4769877,-870.940095488,187007.717097),(0.499999970198,0.500000059605,-0.499999970198,0.5),1.8)
cerradurap2.key="llavePuertaIglesia"
darfuncs.SetHint(cerradurap2.obj,Traduce("Cerradura de la Catedral"))
cerradurap2.OnUnLockFunc=AbrePuertaIglesia
cerradurap2.OnUnLockArgs=()
cerradurap2.OnLockFunc=CierraPuertaIglesia
cerradurap2.OnLockArgs=()
################################################################