#******************************************************************************************
#******************************************************************************************
# patrullas.py  -> enemigos de la zona de la catedral
#******************************************************************************************
#******************************************************************************************

# Imports necesarios
from math import pow
import EnemyTypes
import Actions
import Bladex
import pdb
import Reference
import Breakings
import AniSound
import math
import AuxFuncs
import Torchs
import Reference
import MenuText
import ItemTypes
import pocimac
import darfuncs
import Ontake
import Sparks
import Objects

######### Especificaciones para el superjefe
from CharData import CharMaxLifeValue
from CharData import CharMaxEnergyValue
from CharData import CharDamageData
from CharData import CharDefenseData
from CharData import CharExperienceCost
from CharData import CharExperienceReward
from CharData import CharResistances
from CharData import CharAccuracy

TipoJefe = "Ragnar"
NivelJefe = 19

CharMaxLifeValue[TipoJefe][NivelJefe] = 8000
#CharMaxEnergyValue[TipoJefe][NivelJefe] = 20000
CharDamageData[TipoJefe][NivelJefe] = 250
CharDefenseData[TipoJefe][NivelJefe] = 250
#CharExperienceCost[TipoJefe][NivelJefe] =
CharExperienceReward[TipoJefe][NivelJefe] = 1 ## Se sube de nivel al matarle
CharResistances[TipoJefe] = {'Impale': 0.40, 'Venom': 1.00, 'Slash': 0.40, 'Crush': 0.50, 'Ice': 1.00, 'Fire': 1.00, 'Light': 0.50, 'Drain': 1.00}
#CharAccuracy[TipoJefe][NivelJefe] =

## Para abrir la capilla hay que matar a todos los guardias de la zona de la iglesia (salvo el traitor central)
vivosIglesia = 0

#########################################################################
########## EN PASILLO DE ENTRADA POR PATIO (un guardia)
#### PUNTOs
#(-27710.3251475, -1096.2124937, 178329.676879)
#1.19391505279
#(-34347.1319848, -1114.79241313, 183797.739225)
#0.00798965015815
######
## AREAS: 11 / 12

arma=Bladex.CreateEntity("K_PasilloP_arma","Maza",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(arma)
escudo=Bladex.CreateEntity("K_PasilloP_escudo","Escudo4",0,0,0)
ItemTypes.ItemDefaultFuncs(escudo)
pers=Bladex.CreateEntity("K_PasilloP","Knight_Traitor",-27710.3251475, -1096.2124937, 178329.676879,"Person")
pers.Angle=1.19391505279
pers.Level=9
pers.ActionAreaMin=pow(2,11)
pers.ActionAreaMax=pow(2,12)
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
Actions.TakeObject(pers.Name, arma.Name)
Actions.TakeObject(pers.Name, escudo.Name)
pers.Blind = 1
pers.Deaf = 1
pers.Data.OldImDeadFunc = pers.ImDeadFunc
pers.ImDeadFunc = MuerteIglesia
vivosIglesia = vivosIglesia + 1


#########################################################################
######### En nave lateral junto a pasillo (un guardia)
#### Puntos
#(-20455.1325826, -1116.36397826, 182700.226387)
#3.18531060236
#(-21465.462968, -1111.30193867, 139281.69121)
#3.10031245465

########

arma=Bladex.CreateEntity("K_NaveI_arma","Katana",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(arma)
escudo=Bladex.CreateEntity("K_NaveI_escudo","Escudo4",0,0,0)
ItemTypes.ItemDefaultFuncs(escudo)
pers=Bladex.CreateEntity("K_NaveI","Knight_Traitor",-20455.1325826, -1116.36397826, 182700.226387,"Person")
pers.Angle=3.18531060236
pers.Level=10
pers.ActionAreaMin=pow(2,12)
pers.ActionAreaMax=pow(2,13)
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
Actions.TakeObject(pers.Name, arma.Name)
Actions.TakeObject(pers.Name, escudo.Name)
pers.Blind = 1
pers.Deaf = 1
pers.Data.OldImDeadFunc = pers.ImDeadFunc
pers.ImDeadFunc = MuerteIglesia
vivosIglesia = vivosIglesia + 1


#########################################################################
######### En zona de puerta (2 guardias)
#### Puntos
#(-7245.53817803, -1119.24569734, 125994.494409)
#4.694214159
#(21114.2783673, -1098.25902347, 125858.47261)
#6.21906952342
#(22056.7103346, -1115.60700734, 144024.510338)
#4.6755243077
######

## 1
arma=Bladex.CreateEntity("K1_Puerta_arma","Maza2",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(arma)
escudo=Bladex.CreateEntity("K1_Puerta_escudo","Escudo4",0,0,0)
ItemTypes.ItemDefaultFuncs(escudo)
pers=Bladex.CreateEntity("K1_Puerta","Knight_Traitor",-7245.53817803, -1119.24569734, 125994.494409,"Person")
pers.Angle=4.694214159
pers.Level=11
pers.ActionAreaMin=pow(2,14)
pers.ActionAreaMax=pow(2,15)
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
pers.Data.JoinGroup(pers.Name, "traidores patrullando puerta")
Actions.TakeObject(pers.Name, arma.Name)
Actions.TakeObject(pers.Name, escudo.Name)
pers.Blind = 1
pers.Deaf = 1
pers.Data.OldImDeadFunc = pers.ImDeadFunc
pers.ImDeadFunc = MuerteIglesia
vivosIglesia = vivosIglesia + 1


## 2
arma=Bladex.CreateEntity("K2_Puerta_arma","Katana",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(arma)
escudo=Bladex.CreateEntity("K2_Puerta_escudo","Escudo4",0,0,0)
ItemTypes.ItemDefaultFuncs(escudo)
pers=Bladex.CreateEntity("K2_Puerta","Knight_Traitor",22056.7103346, -1115.60700734, 144024.510338,"Person")
pers.Angle=4.6755243077
pers.Level=11
pers.ActionAreaMin=pow(2,14)
pers.ActionAreaMax=pow(2,15)
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
pers.Data.JoinGroup(pers.Name, "traidores patrullando puerta")
Actions.TakeObject(pers.Name, arma.Name)
Actions.TakeObject(pers.Name, escudo.Name)
pers.Blind = 1
pers.Deaf = 1
pers.Data.OldImDeadFunc = pers.ImDeadFunc
pers.ImDeadFunc = MuerteIglesia
vivosIglesia = vivosIglesia + 1


#########################################################################
######### En zona de capilla y altar (un guardia)
#### Puntos
#(21585.7045099, -1099.60078874, 185088.742069)
#1.57011256423
#(6505.52042077, -1098.26706707, 185372.737257)
#0.00434530738834
#(4840.06384423, -3126.29196682, 198778.564855)
#0.848251566553
#(-3864.38369528, -3113.95726803, 198585.963299)
#2.56263072848
#(426.711891266, -1116.38992069, 186700.26295)
#4.61778819437
######

arma=Bladex.CreateEntity("K_Altar_arma","Maza2",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(arma)
escudo=Bladex.CreateEntity("K_Altar_escudo","Escudo4",0,0,0)
ItemTypes.ItemDefaultFuncs(escudo)
pers=Bladex.CreateEntity("K_Altar","Knight_Traitor",21585.7045099, -1099.60078874, 185088.742069,"Person")
pers.Angle=1.57011256423
pers.Level=13
pers.ActionAreaMin=pow(2,16)
pers.ActionAreaMax=pow(2,17)
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
Actions.TakeObject(pers.Name, arma.Name)
Actions.TakeObject(pers.Name, escudo.Name)
pers.Blind = 1
pers.Deaf = 1
pers.Data.OldImDeadFunc = pers.ImDeadFunc
pers.ImDeadFunc = MuerteIglesia
vivosIglesia = vivosIglesia + 1


#########################################################################
######## En nave central (2 guardias patrullando y uno en el centro)
#RUTA
#### Puntos
#(-5756.90388112, -1114.54575452, 181524.17022)
#3.09805875495
#(-5438.26132375, -1130.2654096, 138890.928044)
#4.74347709423
#(6503.7181302, -1105.6584555, 139657.26252)
#0.00493009609784
#(7761.22176861, -1113.01374714, 173901.913153)
#1.54145533865

## 1
arma=Bladex.CreateEntity("K1_NaveC_arma","Maza2",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(arma)
escudo=Bladex.CreateEntity("K1_NaveC_escudo","Escudo3",0,0,0)
ItemTypes.ItemDefaultFuncs(escudo)
pers=Bladex.CreateEntity("K1_NaveC","Knight_Traitor",-5756.90388112, -1114.54575452, 181524.17022,"Person")
pers.Angle=3.09805875495
pers.Level=12
pers.ActionAreaMin=pow(2,0)
pers.ActionAreaMax=pow(2,1)
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
pers.Data.JoinGroup(pers.Name, "traidores patrullando nave central")
Actions.TakeObject(pers.Name, arma.Name)
Actions.TakeObject(pers.Name, escudo.Name)
pers.Blind = 1
pers.Deaf = 1
pers.Data.OldImDeadFunc = pers.ImDeadFunc
pers.ImDeadFunc = MuerteIglesia
vivosIglesia = vivosIglesia + 1


## 2
arma=Bladex.CreateEntity("K2_NaveC_arma","Katana",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(arma)
escudo=Bladex.CreateEntity("K2_NaveC_escudo","Escudo3",0,0,0)
ItemTypes.ItemDefaultFuncs(escudo)
pers=Bladex.CreateEntity("K2_NaveC","Knight_Traitor",-5156.90388112, -1114.54575452, 180524.17022,"Person")
pers.Angle=3.89805875495
pers.Level=12
pers.ActionAreaMin=pow(2,0)
pers.ActionAreaMax=pow(2,1)
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
pers.Data.JoinGroup(pers.Name, "traidores patrullando nave central")
Actions.TakeObject(pers.Name, arma.Name)
Actions.TakeObject(pers.Name, escudo.Name)
pers.Blind = 1
pers.Deaf = 1
pers.Data.OldImDeadFunc = pers.ImDeadFunc
pers.ImDeadFunc = MuerteIglesia
vivosIglesia = vivosIglesia + 1


######
#CENTRAL (este tiene el traje distinto, que es de lo que hay que vestirse para que te dejen entrar en las escaleras, si les llevas el pergamino)
#### Puntos
#(938.248783644, -1123.42312812, 167979.706511)
#3.051065354
######

arma=Bladex.CreateEntity("KC_NaveC_arma","Maza3",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(arma)
escudo=Bladex.CreateEntity("KC_NaveC_escudo","Escudo7",0,0,0)
ItemTypes.ItemDefaultFuncs(escudo)
pers=Bladex.CreateEntity("KC_NaveC","Dark_Knight",938.248783644, -1123.42312812, 167979.706511,"Person")
pers.Angle=3.051065354
pers.Level=17
pers.ActionAreaMin=pow(2,0)
pers.ActionAreaMax=pow(2,1)
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
pers.Data.JoinGroup(pers.Name, "traidores patrullando nave central")
Actions.TakeObject(pers.Name, arma.Name)
Actions.TakeObject(pers.Name, escudo.Name)
pers.Blind = 1
pers.Deaf = 1
## Al morir debe quedar el cadaver para poder vestirnos
pers.Data.MutilateFunc = NoMutilar
pers.Data.OldImDeadFunc = pers.ImDeadFunc
pers.ImDeadFunc = MuereTraitorCentral

#########################################################################
#### Zona de la capilla
o=Bladex.CreateEntity("Mapa","Pergamino2",21293.354321,-1453.67093579,198262.73898, Reference.ObjType("Pergamino2"))
o.Scale=1.0
o.Orientation=(0.664463102818,-0.241844728589,0.241844803095,-0.664462983608)
darfuncs.SetHint(o, Traduce("Mapa del Reino"))
Ontake.AddOnTakeEvent("Mapa", CojoMapa)

########## EL QUE CONTROLA LA ENTRADA A LAS ESCALERAS 
### (se supone que tu vas a llevarle algo al jefe, si no llevas el traje te destroza, si lo llevas pero no el pergamino, te manda a paseo).

## posicion del char antes del control -> char.Position = (26675.350339, -1068.67089252, 142476.377131)
#### Puntos
#(35580.2060219, -1615.57896117, 142639.933005)
#1.55483819587
######
arma=Bladex.CreateEntity("K_Vigilante_arma","LightEdge",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(arma)
escudo=Bladex.CreateEntity("K_Vigilante_escudo","Escudo8",0,0,0)
ItemTypes.ItemDefaultFuncs(escudo)
pers=Bladex.CreateEntity("K_Vigilante","Dark_Knight", 35580.2060219, -1615.57896117, 142639.933005,"Person")
pers.Angle=1.55483819587
pers.Level=19
### Area de accion en la zona de entrada a las escaleras
pers.ActionAreaMin=pow(2,8)
pers.ActionAreaMax=pow(2,9)
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
Actions.TakeObject(pers.Name, arma.Name)
Actions.TakeObject(pers.Name, escudo.Name)
pers.Blind = 1
pers.Deaf = 1
## No le puedes tocar
pers.Data.Invincibility = 1
pers.HitFunc = SuperGuerrero
## Sector del control de entrada a las escaleras
# 30, -1,142
SecControlEscaleras=Bladex.GetSector(30000.0, -1000.0, 142000.0)
SecControlEscaleras.OnEnter=ControlEscaleras


### Los de las escaleras no tienen areas
#########################################################################
######## Primer tramo de escaleras (1)
#### Puntos
#(35589.5991413, -8096.85713284, 158618.333339)
#6.25376223428
#(33141.9635134, -16113.0664176, 182393.846351)
#4.49219690732
######
arma=Bladex.CreateEntity("K_Esc1_arma","Maza2",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(arma)
escudo=Bladex.CreateEntity("K_Esc1_escudo","Escudo7",0,0,0)
ItemTypes.ItemDefaultFuncs(escudo)
pers=Bladex.CreateEntity("K_Esc1","Knight_Traitor",35589.5991413, -8096.85713284, 158618.333339,"Person")
pers.Angle=6.25376223428
pers.Level=14
#pers.ActionAreaMin=pow(2,2)
#pers.ActionAreaMax=pow(2,3)
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
Actions.TakeObject(pers.Name, arma.Name)
Actions.TakeObject(pers.Name, escudo.Name)
pers.Blind = 1
pers.Deaf = 1

#########################################################################
######## Segundo tramo de escaleras (1)
#### Puntos
#(30238.0577703, -16615.0759977, 182318.099273)
#3.1316240801
#(30441.8932677, -23123.7549457, 160095.595541)
#0.00564203146079
######

arma=Bladex.CreateEntity("K_Esc2_arma","Katana",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(arma)
escudo=Bladex.CreateEntity("K_Esc2_escudo","Escudo7",0,0,0)
ItemTypes.ItemDefaultFuncs(escudo)
pers=Bladex.CreateEntity("K_Esc2","Knight_Traitor",30238.0577703, -16615.0759977, 182318.099273,"Person")
pers.Angle=3.1316240801
pers.Level=14
#pers.ActionAreaMin=pow(2,2)
#pers.ActionAreaMax=pow(2,3)
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
Actions.TakeObject(pers.Name, arma.Name)
Actions.TakeObject(pers.Name, escudo.Name)
pers.Blind = 1
pers.Deaf = 1

### COMIENZO CON  AREAS A PARTIR DE 20
#########################################################################
####### Arriba de las escaleras (1)
#### Puntos
#(29065.1287382, -29101.3536905, 146078.582235)
#5.93169224331
######
arma=Bladex.CreateEntity("K_Desc_arma","Maza3",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(arma)
escudo=Bladex.CreateEntity("K_Desc_escudo","Escudo7",0,0,0)
ItemTypes.ItemDefaultFuncs(escudo)
pers=Bladex.CreateEntity("K_Desc","Knight_Traitor",29065.1287382, -29101.3536905, 146078.582235,"Person")
pers.Angle=5.93169224331
pers.Level=14
pers.ActionAreaMin=pow(2,20)
pers.ActionAreaMax=pow(2,19)
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
Actions.TakeObject(pers.Name, arma.Name)
Actions.TakeObject(pers.Name, escudo.Name)
pers.Blind = 1
pers.Deaf = 1

#########################################################################
####### Sala de armas (1)
#### Puntos
######
#(14430.8130552, -29115.9982582, 151887.724434)
#4.59017958407
#(21560.2971862, -29102.5292474, 157657.553114)
#3.08744567143
### Cuando mueren los dos se abre la sala del trono

arma=Bladex.CreateEntity("K1_SalaArmas_arma","Maza3",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(arma)
escudo=Bladex.CreateEntity("K1_SalaArmas_escudo","Escudo7",0,0,0)
ItemTypes.ItemDefaultFuncs(escudo)
pers=Bladex.CreateEntity("K1_SalaArmas","Knight_Traitor",14430.8130552, -29115.9982582, 151887.724434,"Person")
pers.Angle=4.59017958407
pers.Level=16
pers.ActionAreaMin=pow(2,19)
pers.ActionAreaMax=pow(2,21)
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
Actions.TakeObject(pers.Name, arma.Name)
Actions.TakeObject(pers.Name, escudo.Name)
pers.Blind = 1
pers.Deaf = 1
pers.Data.OldImDeadFunc = pers.ImDeadFunc
pers.ImDeadFunc = MuerteSalaArmas

arma=Bladex.CreateEntity("K2_SalaArmas_arma","Maza3",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(arma)
escudo=Bladex.CreateEntity("K2_SalaArmas_escudo","Escudo7",0,0,0)
ItemTypes.ItemDefaultFuncs(escudo)
pers=Bladex.CreateEntity("K2_SalaArmas","Knight_Traitor",21560.2971862, -29102.5292474, 157657.553114,"Person")
pers.Angle=3.08744567143
pers.Level=16
pers.ActionAreaMin=pow(2,19)
pers.ActionAreaMax=pow(2,21)
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
Actions.TakeObject(pers.Name, arma.Name)
Actions.TakeObject(pers.Name, escudo.Name)
pers.Blind = 1
pers.Deaf = 1
pers.Data.OldImDeadFunc = pers.ImDeadFunc
pers.ImDeadFunc = MuerteSalaArmas


#########################################################################
####### Sala del trono (1 guardia a cada lado y caballero en el centro)
#### Puntos
## 1
#(22843.6567547, -29126.0509398, 166147.409706)
#0.0781344824418
## 2
#(13322.016127, -29113.6243165, 165711.628396)
#5.97526395357

### Vamos a quitar un par de guardias que si no se lo acaban!!!
##arma=Bladex.CreateEntity("K1_SalaTrono_arma","LightEdge",0,0,0,"Weapon")
##ItemTypes.ItemDefaultFuncs(arma)
##escudo=Bladex.CreateEntity("K1_SalaTrono_escudo","Escudo8",0,0,0)
##ItemTypes.ItemDefaultFuncs(escudo)
##pers=Bladex.CreateEntity("K1_SalaTrono","Dark_Knight",23843.6567547, -29126.0509398, 166747.409706,"Person")
##pers.Angle=0.0781344824418
##pers.Level=16
##pers.ActionAreaMin=pow(2,22)
##pers.ActionAreaMax=pow(2,19)
##EnemyTypes.EnemyDefaultFuncs(pers)
##pers.SetOnFloor()
##Actions.TakeObject(pers.Name, arma.Name)
##Actions.TakeObject(pers.Name, escudo.Name)
##pers.Blind = 1
##pers.Deaf = 1

##arma=Bladex.CreateEntity("K2_SalaTrono_arma","LightEdge",0,0,0,"Weapon")
##ItemTypes.ItemDefaultFuncs(arma)
##escudo=Bladex.CreateEntity("K2_SalaTrono_escudo","Escudo8",0,0,0)
##ItemTypes.ItemDefaultFuncs(escudo)
##pers=Bladex.CreateEntity("K2_SalaTrono","Dark_Knight",13322.016127, -29113.6243165, 166711.628396,"Person")
##pers.Angle=5.97526395357
##pers.Level=16
##pers.ActionAreaMin=pow(2,22)
##pers.ActionAreaMax=pow(2,19)
##EnemyTypes.EnemyDefaultFuncs(pers)
##pers.SetOnFloor()
##Actions.TakeObject(pers.Name, arma.Name)
##Actions.TakeObject(pers.Name, escudo.Name)
##pers.Blind = 1
##pers.Deaf = 1

## Centro
######
#(18607.6049815, -29114.4551672, 179011.257319)
#3.19254892352

arma=Bladex.CreateEntity("KC_SalaTrono_arma","Espada",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(arma)
escudo=Bladex.CreateEntity("KC_SalaTrono_escudo","Escudo6",0,0,0)
ItemTypes.ItemDefaultFuncs(escudo)
pers=Bladex.CreateEntity("KC_SalaTrono",TipoJefe,18607.6049815, -29114.4551672, 179011.257319,"Person")
pers.Angle=3.19254892352
pers.Level=NivelJefe
pers.ActionAreaMin=pow(2,22)
pers.ActionAreaMax=pow(2,19)
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
Actions.TakeObject(pers.Name, arma.Name)
Actions.TakeObject(pers.Name, escudo.Name)
pers.Blind = 1
pers.Deaf = 1
####### HACERLE UN MAL  BICHO
#pers.Life = 500
pers.Data.OldImDeadFunc = pers.ImDeadFunc
pers.ImDeadFunc = MuerteJefe
#########################################################################


#########################################################################
#### Puerta de la sala del trono
puertaSalaTrono=Doors.CreateDoor("p3", (16507.3777739, -29072.0555467, 164793.936295),(0,1,0),0,6500,Doors.CLOSED)

puertaSalaTrono.opentype=Doors.UNIF
puertaSalaTrono.o_med_vel=-800
puertaSalaTrono.o_med_displ=5250

puertaSalaTrono.closetype=Doors.AC
puertaSalaTrono.c_init_displ=6500
puertaSalaTrono.c_med_vel=12000

puertaSalaTrono.SetWhileOpenSound(spuertar1d)
puertaSalaTrono.SetEndOpenSound(spuertar1g)
puertaSalaTrono.SetWhileCloseSound(spuertar1d)
puertaSalaTrono.SetEndCloseSound(spuertar1g)
#########################################################################

#########################################################################
#### Rastrillo de la capilla
o=Bladex.CreateEntity("RastrilloCapilla","Rastrillo",20897.0615821,-3771.29578535,189723.491071, Reference.ObjType("Rastrillo"))
o.Scale=1.3
o.Orientation=(0.707106769085,0.707106769085,0.0,0.0)
o=Sparks.SetMetalSparkling("RastrilloCapilla")
o.Frozen=1
## Creamos el objeto dinamico, que es el que vamos a mover
rastrilloCapillaDIN=Objects.CreateDinamicObject("RastrilloCapilla")
#########################################################################