# ======================================================================================================
#		"MOD" DEL MOD GLADIATOR
# Modificado por Shyrka sobre el cdigo de Josh Dahlby
#
#		--->  IMPORTANTE!! <---
#
# Este archivo es una modificacin del original escrito por Josh Dahlby para su mod Gladiator.
#
# El 99,99% del cdigo es el del original. Yo slo he modificado cosas puntuales y de poca monta.
#
# Dichas modificaciones se han realizado conforme a mis gustos, y Josh Dahlby NO es responsable de ellas.
#
# Si no te gustan, tienes dos opciones:
#	1) No utilizar esta modificacin
#	2) Modificarla a tu vez para adaptarla a tu gusto
#	
# Si encuentras algn bug, te agradecera que me lo notificases en Shyrka@bigfoot.com
#
# Tambin puedes usar esa direccin para preguntar dudas o hacer sugerencias
#
# Para ms informacin puedes ver Shyrka.txt
#
#	Mod. 0.3 - 2/Feb/02
# ======================================================================================================

###############################################################################
#  Random Enemy Generator
#  by Josh Dahlby
#
#  Description:
#    This module creates random enemies based on the player level.  
#
#  Use:
#
#    Here is how to use the generator
#
#	 import RndEnmGen
#	 def GetPosition():
#		# return some valid position for the map you are in
#		return (0, 0, 0)
#    EnemyGen = RndEnmGen.EnemyGenerator("Player1", [], GetPosition):
#
#    # To start generation
#	 EnemyGen.StartGeneration()
#
###############################################################################

import Bladex
import EnemyTypes
import Actions
import ItemTypes
import math
import Sounds
import darfuncs
import ObjStore
import whrandom
import CharStats
import Reference
import dust
import copy

# Shyrka
import GladCfg

###############################################################################
# Constants
###############################################################################

# Maximum number of points that can be on the field at a time.  Total point
# count of all current monsters must be less than this number.
MAXPOINTS = 8

# Maximum number enemies that can be on the field.  Define the entries
# First number is the percentage chance per level.
# Second is the maximum percentage
# Third number is the starting level
MAXENEMIES = [(100, 100, 0),# 100% chance 
			  (5, 90, 1),	# 5% per level starting at level 2
			  (4, 90, 5),	# 4% per level starting at level 6
			  (3, 90, 10)]	# 3% per level starting at level 11 

# Percentage to use for getting the maximum amount of experience a spawned 
# enemy can use.
# (Player.ExperienceCost(level) * MAXEXP > Enemy.ExperienceReward(level))
MAXEXP = 0.3

# Percentage to use for getting the minimum amount of experience a spawned 
# enemy can use.  This is used to set the level of the enemy.
# (Player.ExperienceCost(level) * MINEXP < Enemy.ExperienceReward(level))
MINEXP = 0.1

# Percentage to use for getting a weapon.  This relates to how much of the
# players total hit points a weapon can do in a single hit.
# (Player.MAXLIFE * MAXDAMAGE < Weapon.Damage)
MAXDAMAGE = 0.15

# Percentage to use for getting the highest resistance shield that can be 
# used.  
# (MAXLIFE * MAXRES > Shield.Resistance)
MAXRES = 2

# Maximum level to spawn
MAXLEVEL = 19

###############################################################################
# Fix some entries for enemies that just don't seem right
###############################################################################

CharStats.CharExperienceReward['Salamander'] = [100, 200, 400, 800, 1600, 3200, 6400, 12800, 25600, 51200, 70000, 90000, 110000, 130000, 150000, 170000, 190000, 210000, 240000, 260000]
CharStats.CharMaxLifeValue['Ragnar'] = [60, 100, 200, 400, 600, 800, 1000, 1200, 1500, 1700, 1900, 2100, 2300, 2500, 2700, 2900, 3100, 3300, 3500, 3900]
CharStats.CharDamageData['Ragnar'] = [12, 15, 18, 25, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140, 150, 160, 170, 180]
CharStats.CharExperienceReward['Ragnar'] = [40, 50, 60, 120, 240, 480, 960, 1920, 3840, 7680, 15360, 30720, 61440, 122880, 135000, 150000, 170000, 190000, 210000, 240000]

def GenBotExp():
	cost = CharStats.CharExperienceCost['Knight_N']
	exp = []
	for i in range(len(cost)):
		exp.append((cost[i] * MAXEXP) - 1)
	CharStats.CharExperienceReward['Knight_N'] = exp
	CharStats.CharExperienceReward['Barbarian_N'] = exp
	CharStats.CharExperienceReward['Amazon_N'] = exp
	CharStats.CharExperienceReward['Dwarf_N'] = exp

GenBotExp()

###############################################################################
# Weapon Types - Organized by type.  Each enemy is assigned a type
###############################################################################
W_NONE	= -1	# No weapons
W_1H	= 0     # One handed weapons
W_2H	= 1		# Two handed weapons
W_SP	= 3		# Spears
W_DAL	= 4		# DalGurak weapon
W_VAMP	= 5		# Vampire weapon
W_CHAOS = 6		# Chaos Knight weapon
W_BIG	= 7		# Troll and Minotaur weapons
W_OTHER	= 8		# Weapons not used
W_MAGIC = 9		# Magic 1 handed weapons

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

WeaponTypes = {}
WeaponTypes[W_NONE] = []
WeaponTypes[W_1H] = ["Gladius", "Sablazo", "Hacha", "Hacha2", "Hacha3", 
	"Hacha4", "Hacha5", "Hacha6", "Garrote", "Martillo", "Martillo2", 
	"Garropin", "MazaDoble", "Garrote2", "Martillo3", "Orksword", 
	"Espadaelfica", "Espadaromana", "Espadacurva", "Dagesse", "Cimitarra", 
	"EgyptSword", "Espadafilo", "Espada", "Maza", "Maza2", "Maza3", "TaiSword", 
	"LightEdge", "Ninjato", "HookSword", "Katana", "DoubleSword"]

WeaponTypes[W_MAGIC] = ["CrushHammer", "FireAxe", "IceHammer", "QueenSword", 
	"FireSword", "IceSword"]

WeaponTypes[W_2H] = ["Chaosword", "DeathSword", "LongSword", "Alfanje", 
	"BigSword", "SawSword", "FlatSword",  "FireBigSword", "IceAxe", "Eclipse", 
	"Guadanya", "Hacha2hojas", "RhinoClub", "Hacharrajada"]

WeaponTypes[W_BIG] = ["Hachacarnicero", "Mazapiedra"]
WeaponTypes[W_VAMP] = ["VampWeapon"]
WeaponTypes[W_DAL] = ["DalWeapon"] # "DalBlade" is created automatically 
WeaponTypes[W_CHAOS] = ["Espadon"]
WeaponTypes[W_SP] = ["IceWand", "SteelFeather", "FireBo", "Bo", "Lanza", 
	"Naginata", "Tridente", "Hachacuchilla", "Naginata2", "DeathBo", "CrushBo", 
	"LanzaAncha", "Axpear", "Arpon", "Bichero", "Crosspear"]

WeaponTypes[W_OTHER] = [
#These have no skins	
	"DeathKatar", "Chakram", "Katarmoon", "Chakram2", "Katar", "KatarDoble",
# These are just not useful
	"Varita7", "Varita6", "Varita5", "Varita2", "Varita1", "Daga", "Cuchillo", 
	"Phurbhu", "Baston3", "Suriken", "Dagarrojar", "Canica", "KingSword",
	"Alabarda", 
# Don't know
	"EspadaMagica1", "EspadaMagica2", "EspadaMagica3",
# Special DalBlade
	"DalBlade",
# Trap weapons
	"CuchillaFernando", "Pendulo", "PinchoManuel", "PinchoMiguel", 
	"Roca1Aurelio", "Pivote"
]

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

KnightWeapons = [("Gladius", ), ("Gladius", ), ("Gladius", ), ("Gladius", ), 
	("Maza", ), ("Maza", ), ("Espadaromana", ), ("Espadaromana", ), 
	("Espadaelfica", ), ("Maza2", ), ("QueenSword", "HookSword", ),	("Espadacurva", ), 
	("FireSword", ), ("Dagesse", ), ("Cimitarra", ), ("Maza3", ), ("DoubleSword", ),
	("IceSword", "Espadafilo", ), ("Espada", )]

BarbarianWeapons = [("Chaosword", ), ("Chaosword", ), ("Chaosword", ), ("Chaosword", ), 
	("Eclipse", ), ("Eclipse", ), ("DeathSword", ), ("DeathSword", ), ("Guadanya", ), 
	("LongSword", ), ("QueenSword", "Alfanje", "Alfanje", ), ("Hacha2hojas", ), 
	("IceAxe", "FireBigSword", ), ("FlatSword", ), ("BigSword", ), ("RhinoClub", ), 
	("RhinoClub", ), ("FireBigSword", "Hacharrajada", ), ("SawSword", )]

DwarfWeapons = [("Garrote",), ("Garrote",), ("Hacha",), ("Hacha",), ("Hacha5",),
	("Hacha5",), ("Garropin",), ("Garropin",), ("Hacha4",), ("Hacha3",), 
	("QueenSword", "Martillo",), ("Martillo2",), ("IceHammer",), ("Garrote2",), 
	("MazaDoble",), ("Hacha6",), ("CrushHammer",), ("Hacha2", "FireAxe",), ("Martillo3",)]

AmazonWeapons = [ ("Bo",), ("Bo",), ("Bo",), ("Bo",), ("Bichero",), ("Bichero",), ("Lanza",), 
	("Lanza",), ("Naginata",), ("Tridente",), ("QueenSword", "Axpear",), ("DeathBo",), 
	("IceWand",), ("Crosspear",), ("FireBo", "Hachacuchilla",), ("CrushBo",), ("Arpon",), 
	("SteelFeather", "Naginata2",), ("LanzaAncha", )]

###############################################################################
# Shield Types - Organized by type.  Each enemy is assigned a type
###############################################################################

S_NONE	= -1		# No shield
S_NORMAL = 0		# Normal shield selection
S_CHAOS = 1		# Chaos Knight shield
S_DAL	= 2		# DalGurak shield
S_VAMP	= 3		# Vampire shield
S_MAGIC = 4		# Magic shield

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

ShieldTypes = {}
ShieldTypes[S_NONE] = []
ShieldTypes[S_NORMAL] = ["Escudo1", "Escudo2", "Escudo3", "Escudo4", "Escudo5", 
	"Escudo6", "Escudo7", "Escudo8", "Escudo9", "KingShield"]
ShieldTypes[S_VAMP] = ["VampShield"]
ShieldTypes[S_DAL] = ["DalShield"]
ShieldTypes[S_CHAOS] = ["Escudon"]
ShieldTypes[S_MAGIC] = ["MagicShield"]

###############################################################################
# Armor Types - Bots get armor at a certain level
###############################################################################

ArmorTypes = {}
ArmorTypes["Amazon"] = {5: "ArmaduraAmazonaLigera" }
ArmorTypes["Knight"] = {5: "ArmaduraCaballeroLigera",
					    10: "ArmaduraCaballeroMedia",
						15: "ArmaduraCaballeroCompleta"}
ArmorTypes["Barbarian"] = {5: "ArmaduraBarbaroLigera" }
ArmorTypes["Dwarf"] = {5: "ArmaduraEnanoLigera",
					   10: "ArmaduraEnanoMedia"}

###############################################################################
# Enemy information
#
# Each enemy is listed with the following information
#   name	= The enemy name.  Used to create it.
#   mmp		= The bitmap file for the enemy
#   wflag	= Name of the weapons array to use for the enemy.  
#   sflag	= Name of the shield array to use for the enemy.  
#	points	= How many points one of these takes from the MAXPOINTS.
#	dusting = Should the enemy be dusted?  1 for yes (default), 0 for no
#
#   Internally it calculates the following
#   MinPlayerLevel = Minimum level it should show up
#   MaxPlayerLevel = Maximum level it should show up
###############################################################################

EnemyData = {}

class EnemyDataItem:
	initialized = 0
	def __init__(self, name, mmp, wflag=W_NONE, sflag=S_NONE, points=MAXPOINTS, dusting=1):
		self.Name = name
		self.MMPName = "../../3dChars/" + mmp + ".mmp"
		self.WeaponFlag = wflag
		self.ShieldFlag = sflag
		self.Points = points
		self.AllowDusting = dusting
		self.CanBeInvisible = wflag != W_NONE
		if self.Name in ('Lich', 'Knight_Zombie'):
			self.CanBeInvisible = 0

		global EnemyData
		if EnemyData.has_key(self.Name):
			Reference.debugprint("ERROR: Enemy already in EnemyData array")
		else:
			EnemyData[self.Name] = self

		# All characters have the same requirements.
		cost = CharStats.CharExperienceCost["Knight_N"]
		
		# Determine the minimum and maximum level the enemy can appear on
		self.MinPlayerLevel = 0
		self.MaxPlayerLevel = 0
		global MAXLEVEL
		global MAXEXP
		global MINEXP
		minexp = CharStats.GetCharExperienceReward(self.GetCoreName(), 0)
		maxexp = CharStats.GetCharExperienceReward(self.GetCoreName(), MAXLEVEL)
		for i in cost:
			if minexp > i * MAXEXP:
				self.MinPlayerLevel = self.MinPlayerLevel + 1
			if maxexp > i * MINEXP:
				 self.MaxPlayerLevel = self.MaxPlayerLevel + 1
		
		# Add some levels to the max to account for multiple enemies
		self.MaxPlayerLevel = self.MaxPlayerLevel + 2

		if self.MaxPlayerLevel > MAXLEVEL:
			self.MaxPlayerLevel = MAXLEVEL
		if self.MinPlayerLevel > self.MaxPlayerLevel:
			self.MinPlayerLevel = self.MaxPlayerLevel
		
		# Adjustments
		if self.Name == 'Knight_Zombie':
			self.MinPlayerLevel = 3
		if self.Name == 'Lich':
			self.MinPlayerLevel = 2
		if self.Name == 'Cos':
			self.MaxPlayerLevel = 8
		if self.Name == 'Spidersmall':
			self.MaxPlayerLevel = 6
		if self.Name in ('Barbarian_N', 'Knight_N', 'Amazon_N', 'Dwarf_N'):
			self.MinPlayerLevel = 4
		if self.Name == 'Ragnar':
			self.MinPlayerLevel = 3
		if self.Name == 'Troll_snow':
			self.MinPlayerLevel = 7

	def Initialize(self):
		if self.initialized == 1:
			return
		self.initialized = 1
		self.Dummy = Bladex.CreateEntity(self.Name + "_dummy", self.GetCoreName(), 100000, 100000, 100000, "Person")
		self.AfterCreate(self.Dummy)
		darfuncs.HideBadGuy(self.Name + "_dummy")

	def GetCoreName(self):
		return self.Name

	def AfterCreate(self, entity):
		EnemyTypes.EnemyDefaultFuncs(entity)

	def GetWeaponType(self, level):
		return None

	def GetShieldType(self, level, weapon):
		return None

#-----------------------------------------------------------------------------------------------------------------------------------------------------------
# Shyrka:
# Esta clase especial es necesaria para el golem de hielo porque no hay entradas para l en las tablas de referencia (nicamente hay una entrada para las
# resistencias). As pues, lo hereda todo del golem de piedra (Excepto su aspecto, el tipo de piedras que lanza y su resistencia). La falta de estas
# entradas supongo que se debe a que slo aparece uno en todo el juego (Es el enemigo final de la fase "El desfiladero de Orlok)"

class IceGolemDataItem (EnemyDataItem):
	def GetCoreName(self):
		return "Golem_stone"

	def AfterCreate(self, entity):
		EnemyDataItem.AfterCreate(self, entity)
		entity.Alpha=0.6
		entity.SelfIlum=0.8
		entity.CastShadows = 0
		entity.MeshName="Golem_ice"
		entity.Data.Resistances= copy.copy(CharStats.GetCharResistances("Golem_ice"))
		entity.Data.StoneType="Piedra_Glm_ic"
		entity.Data.StoneAlpha=0.6
		entity.Data.StoneSelfIlum=0.8

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

class DalGurakDataItem (EnemyDataItem):
	def AfterCreate(self, entity):
		EnemyDataItem.AfterCreate(self, entity)
		entity.Data.Phase = 2

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

class DarkLordDataItem (EnemyDataItem):
	def AfterCreate(self, entity):
		EnemyDataItem.AfterCreate(self, entity)
		entity.ImDeadFunc = entity.Data.StdImDead

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

class GladiatorDataItem (EnemyDataItem):
	def __init__(self, name, mmp, wflag=W_NONE, sflag=S_NONE, points=MAXPOINTS, dusting=1):
		EnemyDataItem.__init__(self, name, mmp, wflag, sflag, points, dusting)
		self.CanBeInvisible = 0

	def Initialize(self):
		if self.initialized == 0:
			if self.Name == "Barbarian_N":
				Bladex.ReadBitMap("../../Data/Icons/icono barbaro.bmp","BarbarianIcon")
				Reference.EnemiesDefaultScorerData['Barbarian_N']=("BarbarianIcon","Barbarian")
			elif self.Name == "Dwarf_N":
				Bladex.ReadBitMap("../../Data/Icons/icono enano.bmp","DwarfIcon")
				Reference.EnemiesDefaultScorerData['Dwarf_N']=("DwarfIcon","Dwarf")
			elif self.Name == "Amazon_N":
				Bladex.ReadBitMap("../../Data/Icons/icono amazona.bmp","AmazonIcon")
				Reference.EnemiesDefaultScorerData['Amazon_N']=("AmazonIcon","Amazon")
		EnemyDataItem.Initialize(self)

	def AfterCreate(self, entity):
		import GladTypes
		GladTypes.GladiatorDefaultFuncs(entity)

		# Check to see if the character should have armor
		enType = entity.Kind[:len(entity.Kind)-2]
		if enType in ("Barbarian", "Amazon", "Knight", "Dwarf"):
			armor = ArmorTypes[enType]
			# Subtract two levels so player can hurt them.
			for i in range(entity.Level - 2, -1, -1):
				if armor.has_key(i+1):
					self.CreateArmor(entity, armor[i+1])
					break

	def CreateArmor(self, entity, type):
		object_data = Reference.DefaultObjectData[type]
		entity.Data.armour_level=object_data[2]
		entity.Data.armour_prot_factor=object_data[3]
		if entity.MeshName[:len(entity.MeshName)-2] == entity.Kind[:len(entity.Kind)-2]:
			ct = Bladex.GetCharType(entity.CharType, entity.CharTypeExt)
			if object_data[2]==0:
				entity.SetMesh(ct.NoArmour)
			elif object_data[2]==1:
				entity.SetMesh(ct.LowArmour)
			elif object_data[2]==2:
				entity.SetMesh(ct.MedArmour)
			elif object_data[2]==3:
				entity.SetMesh(ct.HighArmour)

	def GetWeaponType(self, level):
		if self.Name == "Knight_N":
			return self.GetLevelWeapon(KnightWeapons, level)
		elif self.Name == "Barbarian_N":
			Arma = self.GetLevelWeapon(BarbarianWeapons, level)
			return Arma
		elif self.Name == "Dwarf_N":
			return self.GetLevelWeapon(DwarfWeapons, level)
		elif self.Name == "Amazon_N":
			return self.GetLevelWeapon(AmazonWeapons, level)
		return None

	def GetShieldType(self, level, weapon):
		if self.Name in ("Knight_N", "Dwarf_N"):
			if level < 3:
				return "Escudo1" #300
			elif level < 6:
				return "KingShield" #1000
			elif level < 8:
				return "Escudo9" #2000
			elif level < 10:
				return "Escudo4" #2500
			elif level < 13:
				return "Escudo8" #3000
			elif level < 15:
				return "Escudo3" #4000
			elif level < 17:
				return "Escudo7" #5000
			else:
				return "Escudo6" #8000
		elif weapon == "QueenSword":
			return "Escudo8"
		return None

#-----------------------------------------------------------------------------------------------------------------------------------------------------------
# Shyrka:
# Esta funcin devuelve el arma de nivel "level" del array "weapons". Por ejemplo, si es el array de armas del enano y "level" es 1, devuelve ("Garrote",).
# Se utiliza slo para los bots de los protagonistas, no de los monstruos. La he modificado para que a partir del nivel mximo se devuelva un arma
# aleatoria porque si no toca luchar siempre contra la misma arma y es aburrido

	def GetLevelWeapon(self, weapons, level):
		if level >= len(weapons): # Si level es muy alto se devuelve un arma aleatoria para dar variedad
			Weapons2 = weapons
			if weapons[0] == ("Gladius", ):		# Caballero
				Weapons2 = [("Gladius", ),("Maza", ),("Espadaromana", ),("Espadaelfica", ),("Maza2", ),("QueenSword", ),("HookSword", ),("Espadacurva", ),("FireSword", ),("Dagesse", ), ("Cimitarra", ), ("Maza3", ), ("DoubleSword", ), ("IceSword", ), ("Espadafilo", ), ("Espada", )]
			elif weapons[0] == ("Chaosword", ):	# Brbaro
				Weapons2 = [("Chaosword", ), ("Eclipse", ), ("DeathSword", ), ("Guadanya", ), ("LongSword", ), ("QueenSword", ), ("Alfanje", ), ("Hacha2hojas", ), ("IceAxe", ), ("FireBigSword", ), ("FlatSword", ), ("BigSword", ), ("RhinoClub", ), ("Hacharrajada", ), ("SawSword", )]
			elif weapons[0] == ("Garrote", ):	# Enano
				Weapons2 = [("Garrote",), ("Hacha",), ("Hacha5",), ("Garropin",), ("Hacha4",), ("Hacha3",), ("Martillo", ), ("Martillo2",), ("IceHammer",), ("Garrote2",), ("MazaDoble",), ("Hacha6",), ("CrushHammer",), ("Hacha2",),  ("FireAxe",), ("Martillo3",)]
			else:					# Amazona
				Weapons2 = [ ("Bo",), ("Bichero",), ("Lanza",), ("Naginata",), ("Tridente",), ("Axpear",), ("DeathBo",), ("IceWand",), ("Crosspear",), ("FireBo",),  ("Hachacuchilla",), ("CrushBo",), ("Arpon",), ("SteelFeather",), ("Naginata2",), ("LanzaAncha", )]
			
			Seleccion = Weapons2[whrandom.randint(0, len(Weapons2) - 1)]
			return Seleccion[0]

		# Si "level" es menor o igual que el mximo, se selecciona un arma de nivel "level"				
		Seleccion = weapons[level]

		if len(Seleccion) > 1:
			i = whrandom.randint(0, len(Seleccion) - 1)
			return Seleccion[i]
		else:
			return Seleccion[0]
			
#-----------------------------------------------------------------------------------------------------------------------------------------------------------

# Type that gets created when an error occurs
ERROR_ENEMY_TYPE = "Cos"

# Create enemy information
EnemyDataItem("Spidersmall", "spd", W_NONE, S_NONE, 1)
EnemyDataItem("Cos", "cosita", W_NONE, S_NONE, 1)
EnemyDataItem("Ork", "ork", W_1H, S_NORMAL, 2)
#EnemyDataItem("Dark_Ork", "dork", W_1H, S_NORMAL, 2)
EnemyDataItem("Knight_Traitor", "tkn", W_1H, S_NORMAL, 2)
EnemyDataItem("Great_Ork", "gok", W_1H, S_NORMAL, 3)
EnemyDataItem("Dark_Knight", "DarkKnight", W_1H, S_NORMAL, 3)
EnemyDataItem("Lich", "lch", W_1H, S_NORMAL, 2, 0)
EnemyDataItem("Knight_Zombie", "zkn", W_1H, S_NORMAL, 2, 0)
EnemyDataItem("Skeleton", "skl", W_1H, S_NORMAL, 3, 0)
EnemyDataItem("Salamander", "slm", W_NONE, S_NONE, 3)
EnemyDataItem("Troll_Dark", "trl_dk", W_BIG, S_NONE, 4)
EnemyDataItem("Troll_snow", "trl_sn", W_BIG, S_NONE, 4)
EnemyDataItem("Minotaur", "min", W_BIG, S_NONE, 4)
EnemyDataItem("Golem_clay", "glm_cl", W_NONE, S_NONE, 4)
EnemyDataItem("Golem_stone", "glm_st", W_NONE, S_NONE, 4)
EnemyDataItem("Golem_metal", "glm_mt", W_NONE, S_NONE, 4)
EnemyDataItem("Little_Demon", "ldm", W_NONE, S_NONE, 4, 0)
EnemyDataItem("Ragnar", "rgn", W_1H, S_NORMAL, 2)
EnemyDataItem("Golem_lava", "glm_lv", W_NONE, S_NONE, 4)

DalGurakDataItem("DalGurak", "DalGurak", W_DAL, S_DAL, 6)
EnemyDataItem("Vamp", "vmp", W_VAMP, S_VAMP, 4)
EnemyDataItem("ChaosKnight", "chk", W_CHAOS, S_CHAOS, 4)
EnemyDataItem("Great_Demon", "gdemon", W_NONE, S_NONE, 6, 0)
# Needs some work.  He disappears into nowhere.
#DarkLordDataItem("DarkLord", "darklord", W_NONE, S_NONE, MAXPOINTS)

#-----------------------------------------------------------------------------------------------------------------------------------------------------------
# Special classes
IceGolemDataItem("Golem_ice", "glm_ic", W_NONE, S_NONE, 4)
#-----------------------------------------------------------------------------------------------------------------------------------------------------------

# Other chars
#GladiatorDataItem("Enano1", "enanos", W_1H, S_NORMAL, 4)
#GladiatorDataItem("Enano2", "enanos", W_1H, S_NORMAL, 4)
#GladiatorDataItem("Gold_Ork", "org", W_1H, S_NORMAL, 4)
# Bots 
GladiatorDataItem("Knight_N", "KgtSkin2", W_1H, S_NORMAL, 6)
GladiatorDataItem("Barbarian_N", "BarSkin2", W_2H, S_NONE, 6)
GladiatorDataItem("Amazon_N", "AmzSkin1", W_SP, S_NONE, 6)
GladiatorDataItem("Dwarf_N", "DwfSkin1", W_1H, S_NORMAL, 6)

###############################################################################
# EnemyInfo
#
#   This class is used to hold a generated enemy's information.  It is used
#   internally by the EnemyGenerator
#
###############################################################################

enemyID = 0
class EnemyInfo:
	def __init__(self):
		global enemyID
		self.Name = None
		while self.Name == None:
			id = enemyID
			enemyID = enemyID + 1
			self.Name = "enemy_" + str(id)
			if Bladex.GetEntity(self.Name) != None:
				self.Name = None

		self.Data = None
		self.WeaponType = None
		self.WeaponName = None
		self.ShieldType = None
		self.ShieldName = None
		self.Position = [0, 0, 0] 
		self.Level = 0

###############################################################################
# EnemyGenerator
#
#   The EnemyGenerator class is used to randomly create multiple monsters 
#   based on the users level.
#
#	Creation Parameters:
#		playerName = Name of the player.  Usually "Player1"
#		getPosFunc = A method that is called to get a valid position for the
#			enemy.  Return a Position tuple (x,y,z)
#		levelUpFunc = A method that is called when the player levels up.
#			Return 0 to stop the generator, or 1 to continue
#		createEnemyFunc = A method that is called when an enemy is created.
#			This is called before the enemy is shown.  It takes 1 parameter
#			which is the enemy entity object.
#		showEnemyFunc =  A method that is called when an enemy is about to
#			be activated.  It takes 1 parameter which is the enemy entity 
#			object.
#
###############################################################################

class EnemyGenerator:

	ObjId = 0
	LastPlayerLevel = -1
	ValidEnemies = [EnemyData[ERROR_ENEMY_TYPE]]
	Queue = []
	Enemies = {}
	OnGetPosition = None
	OnLevelUp = None
	OnCreateEnemy = None
	OnShowEnemy = None
	LevelKilling = 0
	KillOnLevelUp = 1
	DoGeneration = 0
	EnemyList = []

	def __init__(self, playerName="Player1", enemyList=[], getPosFunc=None, levelUpFunc=None, createEnemyFunc=None, showEnemyFunc=None, allowInvisible=1, maxEnemies=4):
		self.ObjId = ObjStore.GetNewId() 
		ObjStore.ObjectsStore[self.ObjId] = self
		self.player = Bladex.GetEntity(playerName)
		self.OnGetPosition = getPosFunc
		self.OnLevelUp = levelUpFunc
		self.OnCreateEnemy = createEnemyFunc
		self.OnShowEnemy = showEnemyFunc
		self.AllowInvisible = allowInvisible
		self.MaxEnemies = maxEnemies+1
		global MAXENEMIES
		if len(MAXENEMIES) < self.MaxEnemies:
			self.MaxEnemies = len(MAXENEMIES)
		if self.MaxEnemies < 1:
			self.MaxEnemies = 1

		global EnemyData
		if len(enemyList) == 0:
			enemyList = EnemyData.keys()
		self.EnemyList = enemyList
		# Make sure they are all valid
		for key in self.EnemyList:
			if not EnemyData.has_key(key):
				self.EnemyList.remove(key)
		for key in self.EnemyList:
			EnemyData[key].Initialize()

	def StartGeneration(self):
		self.DoGeneration = 1
		self.GenerateEnemies()

	def StopGeneration(self):
		self.DoGeneration = 0

	# This function manages the actual generation of the enemies.
	# It determines if an enemy should appear, and also how many should
	# appear
	def GenerateEnemies(self):
		if self.DoGeneration == 0:
			return
		if self.player.Level != self.LastPlayerLevel:
			self.HandleLevelUp()
			return

		global MAXENEMIES
		global MonsterData
		curPoints = 0
		curNumber = 0
		list = self.Enemies.keys()
		for key in list:
			info = self.Enemies[key]
			curPoints = curPoints + info.Data.Points
			curNumber = curNumber + 1
		
		for i in range(self.MaxEnemies):
			if curNumber == i:
				newPoints = self.CheckSpawn(MAXENEMIES[i], curNumber, curPoints)
				if newPoints != 0:
					curPoints = newPoints + curPoints
					curNumber = curNumber + 1
				else:
					break

	def HandleLevelUp(self):
		self.GenEnemyList()
		if self.KillOnLevelUp != 0:
			self.StopGeneration()
			self.KillCurrentEnemies()
		start = 1
		# don't call OnLevelUp on the first generation
		if self.LastPlayerLevel != -1:
			if self.OnLevelUp != None:
				start = apply(self.OnLevelUp, ())
		self.LastPlayerLevel = self.player.Level
		if start == 1:
			Bladex.AddScheduledFunc(Bladex.GetTime()+1, self.StartGeneration,(), "StartGeneration")

	def GetMinimumPlayerLevel(self):
		global EnemeyData
		minLevel = 19
		for enemy in self.EnemyList:
			lvl = EnemyData[enemy].MinPlayerLevel
			if lvl < minLevel:
				minLevel = lvl
		return minLevel

# Shyrka:
# Esta funcin se encarga de eliminar a todos los enemigos presentes en la arena cuando el personaje sube de nivel. Para que queda ms chulo, se hace con
# espectaculares mutilaciones. Sin embargo, algunos enemigos no admiten cualquier forma de morir y otros (Los golem) tienen un aspecto poco realista
# mutilados de esta forma (Se tambalean hacia atrs sobre unas piernas inexistentes)

	# Kills all current enemies, in imaginative ways...
	def KillCurrentEnemies(self):
		self.LevelKilling = 1
		try:
			list = self.Enemies.keys()
			for name in list:
				Enemy = Bladex.GetEntity(name)
				Enemy.CastShadows = 0
				Enemy.RemoveFromInventRight()
				Enemy.RemoveFromInventLeft()
				Enemy.Life = 0
			# Enemigos con efectos especiales en su muerte
				if Enemy.Kind[:5] == 'Golem':
					if Enemy.Kind=="Golem_lava":
						MuerteGolemDeLava(Enemy)
					elif Enemy.Name[:9]=="Golem_ice":
						MuerteGolemDeHielo(Enemy)
					elif Enemy.Name[:10]=="Golem_clay":				
						Bladex.AddScheduledFunc(Bladex.GetTime()+3.2, DestrozarGolem,(Enemy,))
					Enemy.MutilateFunc = DesaparecerLimbs # Con esto nos aseguramos de hacer desaparecer los pedazos del golem
					continue
				elif (Enemy.Kind == "Skeleton") and (Enemy.Data.Fuego == 1):
					MuerteEsqueletoDeFuego(Enemy)
				elif (Enemy.Kind == "ChaosKnight"):
					MuerteCaballeroDelCaos(Enemy)
					continue;

				for i in (1, 2, 4, 6, 8):
					limb = Enemy.SeverLimb(i)
					if limb != 0:
						x = z = 0
						y = -10000
						if i == 1:
							x = 0
							z = 0
						else:
							x = -10000 * math.cos(Enemy.Angle)
							z = -10000 * math.sin(Enemy.Angle)
						limb.Impulse(x,y,z)
		finally:
			self.LevelKilling = 0

	# Helper function to check to see if another monster should be generated.
	def CheckSpawn(self, data, curNumber, curPoints):
		global MAXPOINTS
		maxp = MAXPOINTS
		if self.player.Level > 19:
			maxp = maxp + ((self.player.Level - 19) * 2)
		roll = whrandom.randint(0, 100)
		chance = min(((self.player.Level - data[2]) + 1) * data[0], data[1])
		if roll <= chance:
			if len(self.Queue) == 0:
				global MAXENEMIES
				for i in range(len(MAXENEMIES) * 2): # generate several monsters at a time.
					self.GenerateSingleEnemy()
			nextPoints = self.Queue[0].Data.Points
			if nextPoints + curPoints <= maxp:
				self.ShowEnemy()
				return nextPoints
		return 0		
	
	# Does the work of actually generating the enemy
	def GenerateSingleEnemy(self):
		info = EnemyInfo()
		try:
			info.Data = self.GenEnemyType()
			info.Name = info.Data.Name + info.Name 
			info.Level = self.GenEnemyLevel(info)
			# See if the enemy specifies it's own weapon generation
			info.WeaponType = info.Data.GetWeaponType(info.Level)
			if info.WeaponType == None:
				info.WeaponType = self.GenEnemyWeapon(info)
			if info.WeaponType != None:
				info.WeaponName = info.Name + "_weapon"
			# See if the enemy specifies it's own shield generation
			info.ShieldType = info.Data.GetShieldType(info.Level, info.WeaponType)
			if info.ShieldType == None:
				info.ShieldType = self.GenEnemyShield(info)
			if info.ShieldType != None:
				info.ShieldName = info.Name + "_shield"
			info.Position = (0, 0, 0)
		except:
			Reference.debugprint("ERROR: Exception while generating new enemy")
			info.Data = EnemyData[ERROR_ENEMY_TYPE]
			info.WeaponType = None
			info.ShieldType = None
			info.Position = (0, 0, 0)
			info.Level = 0
		self.CreateEnemy(info)

	# Creates a list of valid enemies to appear based on player level
	def GenEnemyList(self):
		global MAXLEVEL
		try:
			self.ValidEnemies = []
			max = self.player.Level
			if max > MAXLEVEL:
				max = MAXLEVEL
			for key in self.EnemyList:
				info = EnemyData[key]
				if info.MinPlayerLevel <= self.player.Level and info.MaxPlayerLevel >= max:
					self.ValidEnemies.append(info)

			if len(self.ValidEnemies) == 0:
				for key in self.EnemyList:
					self.ValidEnemies.append(EnemyData[key])
		except:
			self.ValidEnemies = [EnemyData[ERROR_ENEMY_TYPE]]

	# Trap the enemy death so we can generate a new enemy
	def EnemyDied(self, entity):
		enemy = Bladex.GetEntity(entity)
		
		if enemy == None:
			return
		if self.Enemies.has_key(entity):
			info = self.Enemies[entity]
			del self.Enemies[entity]
			global EnemyData
			if EnemyData[enemy.Kind].AllowDusting > 0:
				Bladex.AddScheduledFunc(Bladex.GetTime()+10, self.DustPerson,(entity,), "Dust_" + entity)
			del info
		if self.LevelKilling == 0: 
			Bladex.AddScheduledFunc(Bladex.GetTime()+1, self.GenerateEnemies,(), "GenerateEnemies")
		enemy.Data.OldImDeadFunc(entity)

# Shyrka:
# La funcin "DustPerson" se encargaba originariamente de eliminar del campo de batalla los cuerpos de los enemigos cados. Yo la he modificado para que los
# cuerpos pemanezcan sobre el campo de batalla, pues me parece ms realista. La nica excepcin son los enemigos cuyo cuerpo desaparece de forma natural,
# (Golems de lava y hielo y caballero del caos). Estos cuerpos s que son retirados por esta funcin.

	def DustPerson(self, entity):
		# Check to see it exists, before calling EnPolvoPerson
		body = Bladex.GetEntity(entity)
		if (body != None):
			if GladCfg.AutoCleanCorpses or (body.Kind == "Golem_lava") or (body.Name[:9] == "Golem_ice") or (body.Name[:11] == "ChaosKnight"):
				dust.EnPolvoPerson(entity, 100, 0)
				Bladex.AddScheduledFunc(Bladex.GetTime()+6, self.RemoveBody,(entity, ), "RemoveBody")
		
	def RemoveBody(self, entity):
		body = Bladex.GetEntity(entity)
		if body != None:
			body.SubscribeToList("Pin")

# Shyrka:
# He tenido que modificar esta funcin para corregir el bug de las partculas del golem de barro

	# Create the actual enemy entity and its inventory	and put it in the queue
	def CreateEnemy(self, info):
		# This initial position isn't really needed, but it gets rid of the warning.
		pos = self.GenEnemyPosition()
		info.Enemy = Bladex.CreateEntity(info.Name, info.Data.GetCoreName(), pos[0], pos[1], pos[2], "Person")
		
		info.Enemy.Level = info.Level
		info.Data.AfterCreate(info.Enemy)
		
		# Shyrka:
		# El golem de barro trae incorporados los efectos de polvo de barro. Por lo tanto, en el momento de crearlo este povo se hace visible,
		# aunque an no se haya activado el golem. Esto significa que en un rea del espacio del mapa aparece el polvo flotando en la nada
		# (En realidad est brotando del golem que est en la cola esperando ser activado). Con este if comprobamos si es un golem de barro y
		# ponemos el Time2Live de las partculas a cero. Mas tarde, en el ShowEnemy, lo pondremos a 64 que es el valor correcto.
		# NOTA: Es imprescindible realizar esta operacin tras ejecutar info.Data.AfterCreate (Lnea anterior) pues ah se crean las partculas.
		if info.Enemy.Kind == "Golem_clay":
			Polvillo_Golem_Barro = Bladex.GetEntity(info.Name+" hedorshit") # Nombre sacado de EnemyTypes.py lnea 4.930
			Polvillo_Golem_Barro.Time2Live=0
			
		info.Enemy.Life = CharStats.GetCharMaxLife(info.Enemy.Kind, info.Enemy.Level)
		info.Enemy.Data.OldImDeadFunc = info.Enemy.ImDeadFunc
		info.Enemy.ImDeadFunc = self.EnemyDied

		# Create shield
		if info.ShieldType != None:
			shield = ItemTypes.MakeShield(info.ShieldName, info.ShieldType)
			ItemTypes.ItemDefaultFuncs(shield)
			Actions.TakeObject(info.Enemy.Name, shield.Name)

		# Create Weapon
		if info.WeaponType != None:
			weapon = None
			if info.WeaponType == "VampWeapon":
				weapon = ItemTypes.MakeVampireSword(info.WeaponName)
			else:
				weapon = Bladex.CreateEntity(info.WeaponName, info.WeaponType, 0, 0, 0, "Weapon")
			ItemTypes.ItemDefaultFuncs(weapon)
			Actions.TakeObject(info.Enemy.Name, weapon.Name)
		if self.OnCreateEnemy != None:
			apply(self.OnCreateEnemy, (info.Enemy, ))
		darfuncs.HideBadGuy(info.Enemy.Name)
		self.Queue.append(info)

	def SetEnemyPosition(self, info):
		info.Enemy.Position = self.GenRandomPosition(info)
		info.Enemy.InitPos = info.Enemy.Position
		Actions.TurnToFaceEntityNow(info.Enemy.Name, self.player.Name)
		darfuncs.UnhideBadGuy(info.Enemy.Name)
		info.Enemy.SetOnFloor()
		if not info.Enemy.CanISee(self.player):
			Reference.debugprint("CANNOT SEE ENEMY")

	def GenRandomPosition(self, info):
		for i in range(50):
			pos = self.GenEnemyPosition()
			if info.Enemy.TestPos(pos[0], pos[1], pos[2], 0, 10000):
				return pos
		Reference.debugprint("POS FAILED")
		return (0,0,0)

# Shyrka:
# La funcin ShowEnemy es una de las ms modificadas (Y la primera que lo fue). Aqu se dotan a los golems de lava y hielo y al esqueleto de fuego de sus
# auras y partculas

	# Show the enemy on the map
	def ShowEnemy(self):
		if self.DoGeneration != 1:
			return
		info = self.Queue.pop(0)
		if info == None:
			Reference.debugprint("ERROR: ShowEnemy called, but nothing to show")
			return
		if self.AllowInvisible and info.Data.CanBeInvisible:
			chance = self.player.Level * 0.7
			if chance > 10:
				chance = 10
			if whrandom.randint(0, 100) <= chance:
				info.Enemy.Alpha = 0		# Esto lo vuelve invisible (Alpha es opacidad)
				info.Enemy.CastShadows = 0	# Y esto le elimina las sombras
		self.SetEnemyPosition(info)
		info.Enemy.Data.JoinGroup(info.Enemy.Name, "generated" + str(self.ObjId))
		info.Enemy.Data.LaunchMyWatch(info.Enemy.Name)
		self.Enemies[info.Enemy.Name] = info
		info.Enemy.SetActiveEnemy(self.player.Name)

			####   ESQUELETO DE FUEGO   ####
			################################
			
		if (info.Enemy.Kind == "Skeleton"):
			info.Enemy.Data.Fuego = 0 # Creamos una entrada en el data para los esqueletos. Valdr 1 cuando sea de fuego.
			if (whrandom.randint(0,1) == 1): # El esqueleto ser o no de fuego aleatoriamente
		# El esqueleto generado ser de fuego. Conservar los atributos de vida, ataque y defensa del esqueleto normal porque es ms apropiado en
		# Gladiator, pero no las resistencias (Ha de ser inmune al fuego y muy vulnerable al hielo). Las heredar de "Flame_Skeleton" (CharData.py)
				
		# Marcamos el esqueleto para indicar que es de fuego				
				info.Enemy.Data.Fuego = 1
				info.Enemy.Data.Contador = 0	# Este contador sirve para despus apagar gradualmente su fuego al morir
				
		# En primer lugar preparamos los datos de combustin y lo incendiamos
				Bladex.AddCombustionDataFor("Skeleton", "Fire", 250, 400, 4, 1, 3, 144000)
				info.Enemy.CatchOnFire(0,0,0)
			
		# Asignaremos una luz de fuego al esqueleto para darle realismo
				Luz_Flame_Skeleton		= Bladex.CreateEntity("Luz_Flame_Skeleton-" + info.Enemy.Name, "Entity Spot", 0, 0, 0)
				Luz_Flame_Skeleton.Color	= 200,100,0
				Luz_Flame_Skeleton.Intensity	= 6
				Luz_Flame_Skeleton.Precission	= 0.077
				Luz_Flame_Skeleton.CastShadows	= 0
				Luz_Flame_Skeleton.Visible	= 0
				Luz_Flame_Skeleton.SizeFactor	= 0
				info.Enemy.Link(Luz_Flame_Skeleton)
		# Por ltimo, le asignamos las resistencias de "Flame_Skeleton"
				info.Enemy.Data.Resistances= copy.copy(CharStats.GetCharResistances("Flame_Skeleton"))

			####   GOLEM DE LAVA   ####
			############################

		elif (info.Enemy.Kind == "Golem_lava"):
		# Preparamos las llamas del golem y lo ponemos a arder
			Bladex.AddCombustionDataFor( "Golem_lava" , "LargeFire", 500, 900, 4, 0.8, 10, 144000) 
			info.Enemy.CatchOnFire(0,0,0)
		# Luz de incendio que posee el golem
			Luz_Golem_Lava             = Bladex.CreateEntity("Luz_Golem_Lava-" + info.Enemy.Name, "Entity Spot", 0, 0, 0)
			Luz_Golem_Lava.Color       = 200,100,0
			Luz_Golem_Lava.Intensity   = 7
			Luz_Golem_Lava.Precission  = 0.303456
			Luz_Golem_Lava.CastShadows = 1
			Luz_Golem_Lava.Visible     = 1
			Luz_Golem_Lava.SizeFactor  = 5
			info.Enemy.Link(Luz_Golem_Lava)
		# La autoliminacin ms intensa, como corresponde a un ser hecho de fuego, y nada de sombras (Interfiere con su propia luz)
			info.Enemy.SelfIlum	= 1
			info.Enemy.CastShadows	= 0
		# Partculas de pequeas llamas y pavesas
			Llamitas_Golem_Lava = Bladex.CreateEntity("Llamitas_Golem_Lava-" + info.Enemy.Name, "Entity Particle System Dperson", 0.0, 0.0, 0.0)
			Llamitas_Golem_Lava.PersonName		= info.Enemy.Name
			Llamitas_Golem_Lava.ParticleType	= "Llamita2"
			Llamitas_Golem_Lava.Time2Live		= 12
			Llamitas_Golem_Lava.RandomVelocity	= 0
			Llamitas_Golem_Lava.Velocity		= 0,0,0 
			Llamitas_Golem_Lava.NormalVelocity	= 1.0
			Llamitas_Golem_Lava.YGravity		= -1000.0
			Llamitas_Golem_Lava.PPS			= 500
		# Partculas de combustin violenta y erupciones
			Erupciones_Golem_Lava = Bladex.CreateEntity("Erupciones_Golem_Lava-" + info.Enemy.Name, "Entity Particle System Dperson", 0, 0, 0)
			Erupciones_Golem_Lava.PersonName	= info.Enemy.Name
			Erupciones_Golem_Lava.ParticleType	= "DGLifeUpEnergyConc"
			Erupciones_Golem_Lava.PPS		= 400
			Erupciones_Golem_Lava.YGravity		= 0
			Erupciones_Golem_Lava.Friction		= 0.0
			Erupciones_Golem_Lava.RandomVelocity	= 0
			Erupciones_Golem_Lava.NormalVelocity	= 0
			Erupciones_Golem_Lava.FollowFactor	= 0.0
			Erupciones_Golem_Lava.Time2Live		= 10
			Erupciones_Golem_Lava.Velocity		= 0.0, 0.0, 0.0
		# Aura anaranjada que refleja la condensacin del aire en contacto con el golem.
			Aura_Golem_Lava = Bladex.CreateEntity("Aura_Golem_Lava-" + info.Enemy.Name, "Entity Aura", 0, 0, 0)
			Aura_Golem_Lava.SetAuraParams(100, 1, 1, 0, 0, 1)
			Aura_Golem_Lava.SetAuraGradient(2, 1.0, 1.0, 0.0, 0.2, 0.1, 1.0, 1.0, 0.0, 0.0, 0.8)
			info.Enemy.Link(Aura_Golem_Lava)
			Aura_Golem_Lava.SetAuraActive(1)
			
			####   GOLEM DE HIELO   ####
			############################
		
		elif (info.Enemy.MeshName == "Golem_ice"):
		# Efecto de vaho por conglacin del aire a su alrededor
			Vaho_Golem_Ice = Bladex.CreateEntity("Vaho_Golem_Hielo-" + info.Enemy.Name, "Entity Particle System Dperson", 0.0, 0.0, 0.0)
			Vaho_Golem_Ice.PersonName	= info.Enemy.Name
			Vaho_Golem_Ice.ParticleType	= "Vaho"
			Vaho_Golem_Ice.Time2Live	= 25
			Vaho_Golem_Ice.RandomVelocity	= 0
			Vaho_Golem_Ice.Velocity		= 0,0,0 
			Vaho_Golem_Ice.NormalVelocity	= 0
			Vaho_Golem_Ice.YGravity		= -600
			Vaho_Golem_Ice.PPS		= 500
		# Luz azul sin parpadeo (Queda mas misteriosa)
			Luz_Golem_Ice		= Bladex.CreateEntity("Luz_Golem_Hielo-" + info.Enemy.Name, "Entity Spot", 0, 0, 0)
			Luz_Golem_Ice.Color	= 0,100,200
			Luz_Golem_Ice.Intensity	= 2
			Luz_Golem_Ice.Flick	= 0
			Luz_Golem_Ice.Visible	= 0
			info.Enemy.Link(Luz_Golem_Ice)
		# Aura que refleja el intenso fro del golem
			Aura_Golem_Ice=Bladex.CreateEntity("Aura_Golem_Hielo-" + info.Enemy.Name, "Entity Aura", 0, 0, 0)
			Aura_Golem_Ice.SetAuraParams(50, 1, 1, 0, 0, 1)
			Aura_Golem_Ice.SetAuraGradient(2, 0.9, 1.0, 1.0, 0.2, 0.1, 0.4, 0.8, 1.0, 0.0, 0.8)
			info.Enemy.Link(Aura_Golem_Ice)
			Aura_Golem_Ice.SetAuraActive(1)

			####   GOLEM DE BARRO   ####
			############################
			
		elif (info.Enemy.MeshName == "Golem_clay"):
		# "Activamos" las partculas de polvo de barro, "deshabilitadas" en CreateEnemy
			Polvillo_Golem_Barro=Bladex.GetEntity(info.Enemy.Name + " hedorshit")
			Polvillo_Golem_Barro.Time2Live = 64
			
	# Generate a random enemy type
	def GenEnemyType(self):
		return self.ValidEnemies[whrandom.randint(0, len(self.ValidEnemies)-1)]

	# Generate a random weapon for the specified enemy
	def GenEnemyWeapon(self, info):
		global MAXDAMAGE
		weapons = WeaponTypes[info.Data.WeaponFlag]
		if len(weapons) == 0:
			return None
		if len(weapons) == 1:
			return weapons[0]
		maxdamage = CharStats.GetCharMaxLife(self.player.Kind, self.player.Level) * MAXDAMAGE
		mindamage = CharStats.GetCharDefenseData(self.player.CharType, self.player.Level) + self.player.Data.armour_prot_factor + 2

		valid = []
		for weapon in weapons:
			dmg = Reference.DefaultObjectData[weapon][1]
			if dmg <= maxdamage and dmg >= mindamage:
				valid.append(weapon)

		if len(valid) == 0:
			return weapons[0]
		if len(valid) == 1:
			return valid[0]
		ArmaElegida = valid[whrandom.randint(0, len(valid) - 1)]
		return ArmaElegida


	# Generate a random shield for the specified enemy
	def GenEnemyShield(self, info):
		global MAXRES
		shields = ShieldTypes[info.Data.ShieldFlag]
		if len(shields) == 0:
			return None
		if len(shields) == 1:
			return shields[0]
		maxres = CharStats.GetCharMaxLife(self.player.Kind, self.player.Level) * MAXRES
		minres = CharStats.GetCharMaxLife(self.player.Kind, self.player.Level) * 0.4

		valid = []
		for shield in shields:
			res = Reference.DefaultObjectData[shield][2]
			if res <= maxres and res >= minres:
				valid.append(shield)
		if len(valid) == 0:
			return shields[0]
		if len(valid) == 1:
			return valid[0]
		return valid[whrandom.randint(0, len(valid) - 1)]

	# Get a valid position for the enemy
	def GenEnemyPosition(self):
		if self.OnGetPosition != None:
			return apply(self.OnGetPosition, ())
		else:
			return (0, 0, 0)

# Shyrka:
# Est funcin la he modificado para hacerla ms eficiente y ahorrar clculos. El primer comentario explica cmo.
	# Generate the level of the enemy
	def GenEnemyLevel(self, info):
	# Directamente, si el nivel del jugador es 20 o mayor (Sus atributos no mejoran ms), el enemigo tendr tambin el mximo nivel (Se devuelve 19 porque luego
	# externamente el programa le suma 1 nivel, quedando 20 que es el mximo.
		if self.player.Level > 19:
			return 19

		global MAXEXP
		global MINEXP
		global MAXLEVEL

	# GetCharExperienceCost: Puntos de experiencia necesarios para pasar al siguiente nivel
		exp = CharStats.GetCharExperienceCost(self.player.Kind, self.player.Level)
		maxexp = exp * MAXEXP
		minexp = exp * MINEXP
		minlevel = 0
		maxlevel = 0

	# CharExperienceReward: Puntos de experiencia que se dan al asesino
		for x in CharStats.CharExperienceReward[info.Data.GetCoreName()]:
			if x < minexp:
				minlevel = minlevel + 1
			if x > maxexp:
				maxlevel = maxlevel - 1
				break
			maxlevel = maxlevel + 1
		else:
			maxlevel = MAXLEVEL
		
		if self.player.Level < 4 and info.Name == 'Lich':
			maxlevel = self.player.Level
		if minlevel < 0:
			minlevel = 0
		if maxlevel < 0:
			maxlevel = 0
		if minlevel > maxlevel:
			minlevel = maxlevel
		return whrandom.randint(minlevel, maxlevel)
		
	def CheckEnemies(self):
		list = self.Enemies.keys()
		for key in list:
			info = self.Enemies[key]
			if not info.Enemy.CanISee(self.player):
				info.Enemy.Life = 0

# Shyrka:
# Las siguientes funciones son las encargadas de "rematar" correctamente a los enemigos con efectos especiales. Una vez ms, Masklin fue de gran ayuda, as
# como el tutorial de partculas de Quel
#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def MuerteGolemDeHielo(G_H):
	Aura = Bladex.GetEntity("Aura_Golem_Hielo-" + G_H.Name)
	if Aura:
		Aura.SubscribeToList("Pin")
	Luz = Bladex.GetEntity("Luz_Golem_Hielo-" + G_H.Name)
	if Luz:
		Luz.TimerFunc = ApagarLuzGolemDeHielo
		Luz.SubscribeToList("Timer15")
	Vaho = Bladex.GetEntity("Vaho_Golem_Hielo-" + G_H.Name)
	if Vaho:
		Vaho.TimerFunc = ApagarVahoGolemDeHielo
		Vaho.SubscribeToList("Timer15")

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def ApagarLuzGolemDeHielo(entityName,time):
	Luz=Bladex.GetEntity(entityName)
	if Luz:
		Luz.Intensity=Luz.Intensity-0.01
		if (Luz.Intensity <= 0):
			Luz.Intensity = 0.0;
			Luz.RemoveFromList("Timer15")
			Luz.TimerFunc = ""
			Luz.SubscribeToList("Pin")

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def ApagarVahoGolemDeHielo(entityName,time):
	Vaho = Bladex.GetEntity(entityName)
	if Vaho:
		Vaho.PPS = Vaho.PPS - 3
		if (Vaho.PPS <= 0):
			Vaho.PPS = 0.0;
			Vaho.RemoveFromList("Timer15")
			Vaho.TimerFunc = ""
			Vaho.SubscribeToList("Pin")
		
#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def MuerteEsqueletoDeFuego(E_F):
	Bladex.AddScheduledFunc(Bladex.GetTime() + 12.0, ApagateEsqueletoDeFuego, (E_F,));
	Luz = Bladex.GetEntity("Luz_Flame_Skeleton-" + E_F.Name)
	if Luz:
		Luz.TimerFunc = ApagarLuzEsqueletoDeFuego
		Luz.SubscribeToList("Timer15")	

#-----------------------------------------------------------------------------------------------------------------------------------------------------------
# Esta funcin me trajo de cabeza durante das y das. Finalmente, Masklin me dio la solucin :-)

def ApagateEsqueletoDeFuego(ent):
	n_child = ent.GetNChildren()
	for n in range(n_child):
		child = Bladex.GetEntity(ent.GetChild(n))
		if child:
			if child.Kind == "Entity Dynamic Fire":
				child.TimerFunc = ApagarFuegoEsqueleto
				child.SubscribeToList("Timer15")

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def ApagarFuegoEsqueleto(entityName,time):
	F = Bladex.GetEntity(entityName)
	if F:
		F.Intensity = F.Intensity + 1
		if (F.Intensity >= 30) :
			F.RemoveFromList("Timer15")
			F.TimerFunc = ""

#-----------------------------------------------------------------------------------------------------------------------------------------------------------
		
def ApagarLuzEsqueletoDeFuego(entityName,time):
	Luz = Bladex.GetEntity(entityName)
	if Luz:
		Luz.Intensity = Luz.Intensity - 0.03
		if (Luz.Intensity <= 0):
			Luz.Intensity = 0.0;
			Luz.RemoveFromList("Timer15")
			Luz.TimerFunc = ""
			Luz.SubscribeToList("Pin")

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

import GenFX

def MuerteCaballeroDelCaos(C_C):
	DeathCloud=Bladex.CreateEntity("DeathCloud-" + C_C.Name, "Entity Particle System Dperson", 0.0, 0.0, 0.0)
	DeathCloud.PersonName		= C_C.Name
	DeathCloud.ParticleType		= "DeathCloud"
	DeathCloud.Time2Live		= 64
	DeathCloud.RandomVelocity	= 5
	DeathCloud.Velocity		= 0,0,0
	DeathCloud.NormalVelocity	= 3.0
	DeathCloud.YGravity		= -100
	DeathCloud.FollowFactor		= 0.5
	DeathCloud.DeathTime		= Bladex.GetTime() + 11
	DeathCloud.PPS			= 600
	
	ListaDeNodos=("Head", "L_Shoulder", "L_Elbow", "L_Hand", "R_Shoulder", "R_Elbow", "R_Hand", "Center", "L_Knee", "L_Foot", "R_Knee", "R_Foot")
	GenFX.ElectricDischarge(C_C.Name, "ElectricBolt-" + C_C.Name, 255, 40, 10, 600, ListaDeNodos, 10, 10)

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def MuerteGolemDeLava(G_L):
	Luz = Bladex.GetEntity("Luz_Golem_Lava-" + G_L.Name)
	if Luz:
		Luz.TimerFunc = ApagarLuzGolemLava
		Luz.SubscribeToList("Timer15")
	Llamitas = Bladex.GetEntity("Llamitas_Golem_Lava-" + G_L.Name)
	if Llamitas:
		Llamitas.TimerFunc = ApagarLlamitasGolemLava
		Llamitas.SubscribeToList("Timer15")
			
	Erupciones=Bladex.GetEntity("Erupciones_Golem_Lava-" + G_L.Name)
	if Erupciones:
		Erupciones.TimerFunc = ApagarErupcionesGolemLava
		Erupciones.SubscribeToList("Timer15")

	Aura = Bladex.GetEntity("Aura_Golem_Lava-" + G_L.Name)
	if Aura:
		Bladex.AddScheduledFunc(Bladex.GetTime() + 9, Aura.SetAuraParams,(100, 0, 1, 0, 0, 1))

	ApagateGolemDeLava(G_L)	

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def DestrozarGolem(Golem):
	if Golem:
		Golem.SeverLimb(1)
		Golem.SeverLimb(2)
		Golem.SeverLimb(4)
		Golem.SeverLimb(6)
		Golem.SeverLimb(8)
		Golem.CastShadows = 0

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def ApagateGolemDeLava(ent):
	n_child = ent.GetNChildren()
	for n in range(n_child):
		child = Bladex.GetEntity(ent.GetChild(n))
		if child.Kind == "Entity Dynamic Fire":
			child.TimerFunc = ApagarFuegoGolemLava
			child.SubscribeToList("Timer15")

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def ApagarFuegoGolemLava(entityName,time):
	F = Bladex.GetEntity(entityName)
	F.Intensity = F.Intensity + 1
	if (F.Intensity >= 30) :
		F.RemoveFromList("Timer15")
		F.TimerFunc = ""
		F.SubscribeToList("Pin")

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def ApagarErupcionesGolemLava(entityName,time):
	Erupciones = Bladex.GetEntity(entityName)
	if Erupciones:
		Erupciones.PPS = Erupciones.PPS - 3
		if (Erupciones.PPS <= 0):
			Erupciones.PPS = 0.0;
			Erupciones.RemoveFromList("Timer15")
			Erupciones.TimerFunc = ""
			Erupciones.SubscribeToList("Pin")

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def ApagarLlamitasGolemLava(entityName,time):
	Llamitas = Bladex.GetEntity(entityName)
	if Llamitas:
		Llamitas.PPS = Llamitas.PPS - 3
		if (Llamitas.PPS <= 0):
			Llamitas.PPS = 0.0;
			Llamitas.RemoveFromList("Timer15")
			Llamitas.TimerFunc = ""
			Llamitas.SubscribeToList("Pin")

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def ApagarLuzGolemLava(entityName,time):
	Luz = Bladex.GetEntity(entityName)
	if Luz:
		if Luz.Intensity >= 2:
			Luz.Intensity = Luz.Intensity - 0.03
		else:
			Luz.Intensity = Luz.Intensity - 0.06
		if (Luz.Intensity <= 0):
			Luz.Intensity = 0.0;
			Luz.RemoveFromList("Timer15")
			Luz.TimerFunc = ""
			Luz.SubscribeToList("Pin")

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def DesaparecerLimbs(EntityName,obj_name,x,y,z,nx,ny,nz,node):
 	Entidad = Bladex.GetEntity(EntityName)
 	if Entidad:
		if (Entidad.Name[:10] == "Golem_lava") or (Entidad.Name[:9] == "Golem_ice"):
			L = Bladex.GetEntity(obj_name)
			if L:
				L.CastShadows = 0
				L.TimerFunc = Desaparecer
				L.SubscribeToList("Timer15")

#-----------------------------------------------------------------------------------------------------------------------------------------------------------
		
def Desaparecer(entityName,time):
	Entidad = Bladex.GetEntity(entityName)
	if Entidad:
		Entidad.Alpha = Entidad.Alpha - 0.01
		if (Entidad.Alpha <= 0):
			Entidad.Alpha = 0.0;
			Entidad.RemoveFromList("Timer15")
			Entidad.TimerFunc=""
			Entidad.SubscribeToList("Pin")
		
#-----------------------------------------------------------------------------------------------------------------------------------------------------------