# ======================================================================================================
#		"MOD" DEL MOD GLADIATOR
# Modificado por Shyrka sobre el cdigo de Josh Dahlby
#
#		--->  IMPORTANTE!! <---
#
# Este archivo es una modificacin del original escrito por Josh Dahlby para su mod Gladiator.
#
# El 99,99% del cdigo es el del original. Yo slo he modificado cosas puntuales y de poca monta.
#
# Dichas modificaciones se han realizado conforme a mis gustos, y Josh Dahlby NO es responsable de ellas.
#
# Si no te gustan, tienes dos opciones:
#	1) No utilizar esta modificacin
#	2) Modificarla a tu vez para adaptarla a tu gusto
#	
# Si encuentras algn bug, te agradecera que me lo notificases en Shyrka@bigfoot.com
#
# Tambin puedes usar esa direccin para preguntar dudas o hacer sugerencias
#
# Para ms informacin puedes ver Shyrka.txt
#
#	Mod. 0.3 - 2/Feb/02
# ======================================================================================================

###############################################################################
#  Gladiator Mod (see readme.txt for update details)
#  by Josh Dahlby
#
#
#  Main
#    bonus grants
#    round management
#    etc...
#
###############################################################################

import Bladex
import Reference
import Actions
import Scorer
import ItemTypes
import darfuncs
import whrandom                      
import GameText
import CharStats
import dust
import Objects
import GenFX
import Auras
import string
import GotoMapVars
import ObjStore
import BUIx	
import ScorerWidgets
import Damage
import os

import RndEnmGen
import GladCfg

###############################################################################
# Translations
###############################################################################
import Language
import MenuText


#-----------------------------------------------------------------------------------------------------------------------------------------------------------
# Estas variables almacenan cadenas de texto para los mensajes en pantalla

SMusicOff = "Music off"
SNoMusic = "No music found at %s"
SMusicError = "Error playing %s"
SMusicPlaying = "Playing %s"
SCongratulations = "Congratulations!  You have survived round %d"
SHowStart = "Press '%s' to start the next round..."
SStartRound = "Starting round %d"
SScoreBoard = "Kills: %d\nDeaths: %d\nScore: %d\n"
SDefeated = "You have been defeated.  Press '%s' to continue..."
# Shyrka:
# Las siguientes estn aadidas en la versin modificada por Shyrka
SMatrixOn = "Matrix FX On"
SMatrixOff = "Matrix FX Off"
SPaused = "Game paused"
STimeContinues = "Time X0.%d"
SNormalTime = "Normal time"
SDeathMatrixOn = "DeathMatrix On"
SDeathMatrixOff = "DeathMatrix Off"

#-----------------------------------------------------------------------------------------------------------------------------------------------------------
# Aqu se traducen los mensajes anteriores al espaol

if Language.Current == "Spanish":
	MenuText.ForeingDict[SMusicOff]			= 'Msica desactivada'
	MenuText.ForeingDict[SNoMusic]			= 'No se han encontrado ficheros de msica en %s'
	MenuText.ForeingDict[SMusicError]		= 'Error reproduciendo %s'
	MenuText.ForeingDict[SMusicPlaying]		= 'Reproduciendo %s'
	MenuText.ForeingDict[SCongratulations]		= "Enhorabuena! Has sobrevivido al asalto %d"  # Cambiado por Toni. Pona "...a un asalto..."
	MenuText.ForeingDict[SHowStart]			= "Presiona '%s' para iniciar el siguiente asalto..."
	MenuText.ForeingDict[SStartRound]		= "Iniciando asalto %d"
	MenuText.ForeingDict[SScoreBoard]		= "Eliminados: %d\nMuertes: %d\nPuntos: %d\n"
	MenuText.ForeingDict[SDefeated]			= "Has sido derrotado. Presiona '%s' para continuar..."
# Shyrka:
# Los siguientes son de la versin modificada por Shyrka
	MenuText.ForeingDict[SMatrixOn]			= "Efecto Matrix activado"	# Mensajes en espaol del efecto Matrix
	MenuText.ForeingDict[SMatrixOff]		= "Efecto Matrix desactivado"	
	MenuText.ForeingDict[SPaused]			= "Juego en pausa"
	MenuText.ForeingDict[STimeContinues]		= "Tiempo X 0.%d"
	MenuText.ForeingDict[SNormalTime]		= "Tiempo Normal"
	MenuText.ForeingDict[SDeathMatrixOn]		= "DeathMatrix activado"
	MenuText.ForeingDict[SDeathMatrixOff]		= "DeathMatrix desactivado"

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def GetText(s):
	return MenuText.GetMenuText(s)

###############################################################################
# Globals
###############################################################################

# Used to keep track of what round it is 
round = 0

# If a round is started or not
roundStarted = 0

# Number of deaths
deathCount = 0

# Number of kills
killCount = 0

# Player score
score = 0

# Number of enemies killed since last clean
cleanCount = 0

# Percentage of experience to remove on player death
EXP_PENALTY = 0.05

###############################################################################
# GetKey
###############################################################################

def GetKey(action):
	import BInput
	import KeybWidget
	IManager = BInput.GetInputManager()
	IActions = IManager.GetInputActions()
	IAction = IActions.Find(action)
	if IAction.Name() == "NULL":
		return ''
	if IAction.nInputEvents() > 0:
		IEvent = IAction.GetnInputEvent(0)
		if IEvent.GetDevice() == "Keyboard":
			return IEvent.GetKey()
	return ''

###############################################################################
# Gladiator TravelBook
###############################################################################

class GladiatorTravelBook(BUIx.B_RectWidget):
	def __init__(self,Parent,Menudesc,StackMenu,VertPos=0):
		import Language
		import Raster
		self.index = 1
		self.images = []
		self.vidw = 1
		self.vidh = 1
		char = Bladex.GetEntity("Player1")
		Raster.UnifyRenderBuffers()
		self.AddImage("..\\..\\Data\\TB\\" + Language.Current + "\\" + char.Kind + "\\plantillaspecials.jpg")
		self.AddImage("..\\..\\Data\\TB\\" + Language.Current + "\\" + char.Kind + "\\plantillaweapons.jpg")
		self.AddImage("..\\..\\Data\\TB\\" + Language.Current + "\\" + char.Kind + "\\plantillahabilities.jpg")
		self.AddImage("..\\..\\Data\\TB\\" + Language.Current +"\\Items\\plantillaGitems.jpg")
		self.AddImage("..\\..\\Maps\\gladiator\\gladiator.jpg")
		self.AddImage("..\\..\\Maps\\gladiator\\credits.jpg")
		BUIx.B_RectWidget.__init__(self,Parent,Menudesc["Name"],self.vidw,self.vidh)
		self.Selected=0
		self.Solid=0
		self.Border=0
		self.SetDrawFunc(self.Draw)
		self.SndCorreGema=Bladex.CreateSound("..\\..\\Sounds\\golpe-2.wav","Chanje")
		self.SndCorreGema.Volume=0.5
		self.SndCorreGema.MinDistance=1000000.0
		self.SndCorreGema.MaxDistance=2000000

	def AddImage(self, file):
		import BBLib
		image = BBLib.B_BitMap24()
		image.ReadFromFile(file)
		self.images.append(image)

	def Draw(self,x,y,time):
		import Menu
		import Raster
		char = Bladex.GetEntity("Player1")
		x,y = Raster.GetSize()
		Raster.SetPosition((x - 640)/2, (y - 480)/2)
		if self.index < 0:
			self.index = len(self.images) - 1
		if self.index > len(self.images) - 1:
			self.index = 0
		Raster.DrawImage(640,480,"BGR","Normal",self.images[self.index].GetData())
		self.DefDraw(x,y,time)

	def FinalRelease(self):
		BUIx.B_RectWidget.FinalRelease(self)

	def AcceptsFocus(self):
		return 1

	def IncMenuItem(self):
		self.SndCorreGema.PlayStereo()
		self.index = self.index + 1

	def DecMenuItem(self):
		self.SndCorreGema.PlayStereo()
		self.index = self.index - 1

	def GetFocus(self):
	    return self

	def ActivateItem(self,activate):
		import Menu
		Menu.ActivateMenu()

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def ExecTravelBook():
	import Menu
	import GameText
	import Scorer
	import acts
	GameText.AbortText()
	if not Menu.MENU_PREACTIVATED:
		try:
			Menu.TB_ACTIVATED=1
		except:
			pass
		Menu.MENU_PREACTIVATED = 1
		pepote = Menu.Desc1
		Menu.Desc1={"Name":"TopMenu","FrameKind":GladiatorTravelBook,"ListDescr":[{"Name":"Back","Kind":GladiatorTravelBook}]}
		Menu.ActivateMenu()
		Menu.Desc1 = pepote
		Scorer.HideTBS()
		for kn in acts.GetKeyList("Turn Left"):
			if kn!="Left":
				Bladex.AssocKey("Menu Dec","Keyboard",kn)
		for kn in acts.GetKeyList("Turn Right"):
			if kn!="Right":
				Bladex.AssocKey("Menu Inc","Keyboard",kn)

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

Bladex.AddBoundFunc("LaunchTravel",ExecTravelBook)
import acts
Bladex.RemoveBoundFunc("LaunchTravel",acts.ExecTravelBookNP)

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

import Menu
def ActivateMenu():
	GladCfg.SavePlayer(Bladex.GetEntity("Player1"), killCount, deathCount, score, round)
	Menu.PreActivateMenu()

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

Bladex.AddBoundFunc("Activate Menu",ActivateMenu)
Bladex.RemoveBoundFunc("Activate Menu",Menu.PreActivateMenu)

###############################################################################
# Sound
###############################################################################

soundNewArmor = Bladex.CreateSound("..\\..\\Sounds\\voz-arma.wav","NewArmorSound")
soundNewArmor.MinDistance=1000000.0
soundNewArmor.MaxDistance=1000000.0

soundNewLevel = Bladex.CreateSound("..\\..\\Sounds\\voz-nivel.wav","NewLevelSound")
soundNewLevel.MinDistance=1000000.0
soundNewLevel.MaxDistance=1000000.0

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def PlaySound(sound):
	sound.PlayStereo()

###############################################################################
# Music
###############################################################################

musicOn = 0
def StartMusic():
	global musicOn
	if musicOn == 1:
		Bladex.KillMusic()
		musicOn = 0
		GameText.WriteTextAux(GetText(SMusicOff), 5.0, 255,255,255,[])
		Bladex.RemoveScheduledFunc("CheckMusic")
		return
	selection = None
	musicDir = GladCfg.MusicDir
	if string.upper(musicDir) == "DEFAULT":
		selection = "..\\..\\Sounds\\tema.mp3"
	elif os.path.isdir(musicDir):
		files = os.listdir(musicDir)
		music = []
		for file in files:
			ext = string.upper(os.path.splitext(file)[1])
			if ext == ".MP3" or ext == ".WAV":
				music.append(file)
		if len(music) > 0:
			selection = os.path.join(musicDir, music[whrandom.randint(0, len(music) - 1)])
	elif os.path.isfile(musicDir):
		ext = string.upper(os.path.splitext(musicDir)[1])
		if ext == ".MP3" or ext == ".WAV":
			selection = musicDir
	if selection == None:
		GameText.WriteTextAux(GetText(SNoMusic) %(musicDir), 5.0, 255,255,255,[])
		return
	try:
		selection = string.replace(selection, '\\', '/')
		ext = string.upper(os.path.splitext(selection)[1])
		if ext == ".MP3":
			Bladex.AddMusicEventMP3("GladiatorMusic", selection, 1, 1, 1, 10000, 0, 0, 0)
		else:
			Bladex.AddMusicEventWAV("GladiatorMusic", selection, 1, 1, 1, 10000, 0, 0, 0)
		Bladex.ExeMusicEvent(Bladex.GetMusicEvent("GladiatorMusic"))
		GameText.WriteTextAux(GetText(SMusicPlaying) %(os.path.split(selection)[1]), 5.0, 255,255,255,[])
		musicOn = 1
		CheckMusic()
	except:
		GameText.WriteTextAux(GetText(SMusicError) %(os.path.split(selection)[1]), 5.0, 255,255,255,[])

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def CheckMusic():
	Bladex.SaveMusicState("music.tmp")
	f = open("music.tmp", "rb")
	if f != None:
		data = f.read()
		f.close()
		match = "GladiatorMusic"
		matchLen = len(match)
		matchIdx = 0
		for i in range(len(data)):
			if data[i] == match[matchIdx]:
				matchIdx = matchIdx + 1
				if matchLen == matchIdx:
					# Music is still playing
					Bladex.AddScheduledFunc(Bladex.GetTime()+3, CheckMusic,(), "CheckMusic")
					return;
			else:
				matchIdx = 0
	# music is not playing anymore
	global musicOn
	if musicOn == 1:
		musicOn = 0
		StartMusic()
		
###############################################################################
# Weapon bonus information
#
# Tried to put 19 weapons in so each class would get a new weapon each level.  
# This means that the weapons don't always have combos.  Will have to wait for
# feedback to see how people like this.
###############################################################################

BonusWeapons = {}

BonusWeapons["Knight"] = [ "Gladius", "Maza", "Orksword", "Espadaromana", "Espadaelfica", 
	"Maza2", "QueenSword", "HookSword", "EgyptSword", "Espadacurva", "FireSword", "Dagesse", 
	"Cimitarra", "Maza3", "DoubleSword", "IceSword", "Espadafilo", "TaiSword", "Espada"] 

# Shyrka:
# He reordenado la lista de armas del enano para que aparezca en primer lugar el garrote, que es el arma bsica.
BonusWeapons["Dwarf"] = ["Garrote", "Hacha", None, "Hacha5", "Garropin", "Hacha4", "Hacha3", 
	"QueenSword", "Martillo", "Martillo2", "IceHammer", "Garrote2", "MazaDoble", "Hacha6", 
	"CrushHammer", "Hacha2", "FireAxe", "Martillo3"]

BonusWeapons["Amazon"] = [ "Bo", "Bichero", None, "Lanza", "Naginata", "Tridente", "QueenSword", 
	"Axpear", "DeathBo", "IceWand", "Crosspear", "FireBo", "Hachacuchilla", "CrushBo", "Arpon", 
	"SteelFeather", "Naginata2", "LanzaAncha"]

BonusWeapons["Barbarian"] = [ "Chaosword", None, "Eclipse", None, "DeathSword", None, "Guadanya", "LongSword", 
	"QueenSword", "Alfanje", "Hacha2hojas", "IceAxe", "FlatSword", "BigSword", "RhinoClub", 
	"FireBigSword", "Hacharrajada", "SawSword"]

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

weaponID = 0

def CreateWeapon(player, type):
	global weaponID

	weaponID = weaponID + 1
	weapon = None	
	try:
		if type == None:
			return None
		elif type == "VampWeapon":
			weapon = ItemTypes.MakeVampireSword("plyr_wep_" + `weaponID`)
		else:
			weapon = Bladex.CreateEntity("plyr_wep_" + `weaponID`, type, 0, 0, 0, "Weapon")
	except:
		Reference.debugprint("ERROR: Unable to create weapon (" + type + ")")
		return None
	ItemTypes.ItemDefaultFuncs(weapon)
	weapon.Position = player.Position
	return weapon

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

shieldID = 0

def CreateShield(player, type):
	global shieldID
	shieldID = shieldID + 1
	if type == None:
		return None
	shield = None
	try:
		shield = ItemTypes.MakeShield("plyr_shield_" + `shieldID`, type)
	except:
		Reference.debugprint("ERROR: Unable to create shield (" + type + ")")
		return None
	ItemTypes.ItemDefaultFuncs(shield)
	shield.Position = player.Position
	return shield

#-----------------------------------------------------------------------------------------------------------------------------------------------------------
# Shyrka:
# Esta funcin devuelve el arma de bonificacin correspondiente al nivel del jugador.
# En el Gladiator original se dejaban de ofrecer armas una vez alcanzado el nivel 20. Esto es una faena para el brbaro y la amazona, pues sus armas se
# quiebran al detener golpes con ellas y ningn enemigo utiliza sus armas. Lo he modificado para que el flujo de armas nunca se detenga.

def CheckWeaponBonus():
	Player = Bladex.GetEntity("Player1")
	Weapons = BonusWeapons[Player.Kind[:len(Player.Kind)-2]]

	Weapon = CreateWeapon(Player, Weapons[Player.Level % len(Weapons)])

	if Weapon == None:
		return
	if GladCfg.weaponPosition != None:
		Weapon.Position = GladCfg.weaponPosition
	else:
		pos = Weapon.Position
		Weapon.Position = (pos[0] + 1000, pos[1], pos[2])
	
	Actions.TurnToFaceEntity(Player.Name, Weapon.Name)
	Aura = Auras.MakeAura(Weapon.Name, 8.0,(25,1.0,1.0,1,0,0), (),(),(2,  0.8,0.8,1.0, 1.0, 0.6  , 0.0,0.0,1.0, 0.0, 1.0))
	DinObj = Objects.CreateDinamicObject(Weapon.Name)
	Objects.RotateObject(DinObj, 3.14159*50.0, 20.0, 50.0, (0, 0, 0), (0, 0, 1), Objects.REL, "", "", "", WeaponRotateFunc, (Weapon.Name,), WeaponEndRotateFunc, (Weapon.Name,))

	if Player.Level > len(Weapons) - 1:
		return

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def WeaponRotateFunc(entity):
	obj = Bladex.GetEntity(entity)
	if obj.Parent != None:
		dinobj = obj.Data.dinobjdata
		dinobj.OnMovement = 0
		dinobj.OnRotation = 0

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

# Bonus weapon drops from mid-air
def WeaponEndRotateFunc(entity):
	obj = Bladex.GetEntity(entity)
	if obj.Parent == None:
		weapon = Bladex.GetEntity(entity)
		weapon.Impulse(0.0, 0.0, 0.0)

###############################################################################
# Armor Bonus information
# 
# Player gets armor bonus at certain levels
###############################################################################

def CreateArmor(player, type):
	object_data = Reference.DefaultObjectData[type]
	player.Data.armour_level=object_data[2]
	player.Data.armour_prot_factor=object_data[3]
	if player.MeshName[:len(player.MeshName)-2] == player.Kind[:len(player.Kind)-2]:
		ct = Bladex.GetCharType(player.CharType, player.CharTypeExt)
		if object_data[2]==0:
			player.SetMesh(ct.NoArmour)
		elif object_data[2]==1:
			player.SetMesh(ct.LowArmour)
		elif object_data[2]==2:
			player.SetMesh(ct.MedArmour)
		elif object_data[2]==3:
			player.SetMesh(ct.HighArmour)

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def CheckArmorBonus():
	player = Bladex.GetEntity("Player1")
	kind = player.Kind[:len(player.Kind)-2]
	armor = RndEnmGen.ArmorTypes[kind]
	if armor.has_key(player.Level + 1):
		CreateArmor(player, armor[player.Level+1])
		PlaySound(soundNewArmor)
		return 1
	return 0

###############################################################################
# Round functions
#
#	EndRound() = Finishes the round and grants bonuses
#
#	StartRound() = Starts the round
#
###############################################################################

def EndRound():
	global roundStarted
	global round
	if roundStarted == 1:
		round = round + 1
		roundStarted = 0
		player = Bladex.GetEntity("Player1")
		GladCfg.SavePlayer(player, killCount, deathCount, score, round)
		if player.Data.Poisoned:
			player.Data.UnVenom()
		GameText.WriteTextAux(GetText(SCongratulations) %(round), 5.0, 255,255,255,[])
		if CheckArmorBonus() == 0:
			PlaySound(soundNewLevel)
		CheckWeaponBonus()
		Bladex.AddScheduledFunc(Bladex.GetTime()+5, DisplayText,(GetText(SHowStart) %(GetKey("StartRound")), ), "DisplayHowStart")
		return 0
	else:
		return 1

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def StartRound():
	global roundStarted
	GladCfg.SavePlayer(Bladex.GetEntity("Player1"), killCount, deathCount, score, round)
	if roundStarted == 0:
		roundStarted = 1
		CleanUpArena()
		ClearText()
		global round
		GameText.WriteTextAux(GetText(SStartRound) %(round + 1), 5.0, 255,255,255,[])
	else:
		EnemyGen.CheckEnemies()
	EnemyGen.StartGeneration()

###############################################################################
# Enemy Generator
#
#   GetPosition = Gets a valid position on the map for the enemy to appear
#
#   EnemyGen = The enemy generator.
#
###############################################################################

def GetPosition():
	if GladCfg.positionFunc != None:
		try:
			return GladCfg.positionFunc()
		except:
			pass
	if GladCfg.randomPositions:
		x,y,z = Bladex.GetEntity("Player1").Position
		tmp = whrandom.randint(3000, 6000)
		if  whrandom.randint(0, 1) == 0:
			tmp = tmp * -1
		x = x + tmp
		tmp = whrandom.randint(3000, 6000)
		if  whrandom.randint(0, 1) == 0:
			tmp = tmp * -1
		z = z + tmp
		return (x, y, z)
	else:
		pos = None
		tries = 0
		while pos == None and tries < 30:
			pos = GladCfg.spawnPositions[whrandom.randint(0, len(GladCfg.spawnPositions) -1 )];
			if darfuncs.ValidAppear(pos["Position"]) != 1:
				pos = None
			tries = tries + 1
		if pos == None:
			Reference.debugprint("ERROR: Could not get starting position for monster!")
			pos = GladCfg.spawnPositions[0]
		return pos["Position"]

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

#Enemy generator
enemyList = GladCfg.SelectedEnemies
try:
	for enemy in GladCfg.excludeEnemies:
		if enemyList.count(enemy) > 0:
			enemyList.remove(enemy)
except:
	pass

EnemyGen = RndEnmGen.EnemyGenerator("Player1", enemyList, GetPosition, EndRound, None, None, GladCfg.InvisibleEnemies, GladCfg.MaxEnemies)

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def CheckPlayer():
	player = Bladex.GetEntity("Player1")
	player.InitPos = GladCfg.playerPosition
	player.Position = GladCfg.playerPosition
	player.Angle = GladCfg.playerAngle
	player.SetOnFloor()
	Scorer.SetLifeValue(0, 1, 0)

	global round
	global killCount
	global deathCount
	global score
	killCount, deathCount, score, round = GladCfg.PlayerScore

	playerType = player.Kind[:len(player.Kind)-2]

	# Check for armor
	armor = RndEnmGen.ArmorTypes[playerType]
	for i in range(player.Level, -1, -1):
		if armor.has_key(i+1):
			CreateArmor(player, armor[i + 1])
			break
	inv = player.GetInventory()

	# Check weapons
	if inv.nWeapons == 0:
		wepTypes = BonusWeapons[playerType]
		maxIdx = player.Level
		if maxIdx > len(wepTypes) - 1:
			maxIdx = len(wepTypes) - 1
		count = 0
		for i in range(maxIdx, -1, -1):
			if wepTypes[i] != None:
				weapon = CreateWeapon(player, wepTypes[i])
				Actions.TakeObject(player.Name, weapon.Name)
				if count == 3:
					break
				count = count + 1

	# Check Shields
	if (inv.nShields == 0) and (playerType in ["Knight", "Dwarf"]):
		type = None
		num = 3
		if player.Level < 3:
			type = "Escudo1" #300
			num = player.Level + 1
		elif player.Level < 6:
			type = "KingShield" #1000
		elif player.Level < 8:
			type = "Escudo9" #2000
		elif player.Level < 10:
			type = "Escudo4" #2500
		elif player.Level < 13:
			type = "Escudo8" #3000
		elif player.Level < 15:
			type = "Escudo3" #4000
		elif player.Level < 17:
			type = "Escudo7" #5000
		else:
			type = "Escudo6" #8000
		for i in range(num):
			shield = CreateShield(player, type)
			Actions.TakeObject(player.Name, shield.Name)

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

CheckPlayer()

###############################################################################
# Score Board
###############################################################################

scoreBoardOn = 1

wScoreBoard = BUIx.B_TextWidget(Scorer.wFrame,"ScoreBoardTextWidget","", ScorerWidgets.font_server,"../../Data/Letras menu med.bmp")
wScoreBoard.SetAlpha(scoreBoardOn)
wScoreBoard.SetColor(255,255,255)
Scorer.wFrame.AddWidget(wScoreBoard,5,10, 
	BUIx.B_FrameWidget.B_FR_AbsoluteRight,BUIx.B_FrameWidget.B_FR_Right, 
	BUIx.B_FrameWidget.B_FR_AbsoluteTop,BUIx.B_FrameWidget.B_FR_Top)

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

# Shyrka:
# He cambiado esta funcin para que primero se retire el panel de vida y luego los marcadores de puntuacin.
def ToggleScoreBoard():
	global scoreBoardOn
	if scoreBoardOn == 2:		# 2 significa ambos ocultos
		scoreBoardOn = 1	# 1 significa slo visible la puntuacin
	elif scoreBoardOn == 1:
		scoreBoardOn = 0	# 0 significa ambos visibles
	else:
		scoreBoardOn = 2
	if scoreBoardOn == 2:
		Scorer.SetVisible(0)
		wScoreBoard.SetAlpha(0)
		GameText.HideMessage() # Shyrka - Con esto consegimos que se retire el mensaje "Juego en pausa", ente otros
	else:
		Scorer.SetVisible(scoreBoardOn)
		wScoreBoard.SetAlpha(1)
		if JUEGO_PAUSADO and scoreBoardOn > 0:	# Shyrka - Con esto consegimos que se vuelva a mostrar el mensaje "Juego en pausa"
			GameText.ShowMessage(GetText(SPaused),255,255,255);

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def UpdateScoreBoard():
	wScoreBoard.SetText(GetText(SScoreBoard) %(killCount, deathCount, score))
	Scorer.wFrame.RecalcLayout()

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

UpdateScoreBoard()	

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

# Detect Kills
OldPlayerHitFunc = Damage.PlayerHitFunc

# Shyrka:
# Esta funcin redefine la original de Blade. La he modificado para permitir el funcinamiento del efecto DeathMatrix as como para disparar los efectos
# de las muertes de los esqueletos de fuego y de los golems de lava y hielo. Permite, adems, corregir el bug de los miembros mutilados del jugador.
def PlayerHitFunc(victim, attacker, life, prevLife):
	global score
	global cleanCount
	global Matrix_Activado
	global VelocidadTiempo
	if victim == "Player1" and attacker != "Player1":
		score = score - (prevLife - life)
		Entidad = Bladex.GetEntity(victim)
		Entidad.MutilateFunc = ComprobarManos # Comprobamos las mutilaciones para corregir el mencionado bug
		if Entidad.Life <= 0 and prevLife > 0 and DEATH_MATRIX: # Si el jugador ha sido derrotado, se lanza el efecto Matrix
			darfuncs.StartMatrixFX()
			# Slow time in Matrix mode: 1 =~ 10s?         <-- Te suena, Masklin? ;-) Gracias
			if Matrix_Activado == 0: # Si est activado el modo Matrix permanente, no interrumpimos el efecto
				Bladex.AddScheduledFunc(Bladex.GetTime()+1.0,PararEfectoMatrix,());
	if attacker == 'Player1':
		score = score + (prevLife - life)
	if OldPlayerHitFunc != "":
		OldPlayerHitFunc(victim, attacker, life, prevLife)
	if victim != "Player1":
		Entidad = Bladex.GetEntity(victim)
		if attacker == "Player1":
			Entidad.MutilateFunc = HeadMatrix # Esta asignacin es para que cuando se mate al enemigo decapitndolo, tambin aparezca el efecto Matrix

		if (Entidad.Life <= 0) and (prevLife > 0): # Ahora es cuando comprobamos la identidad del enemigo para ver si hay efectos especiales a su muerte
			if Entidad.Kind == "Golem_lava":
				RndEnmGen.MuerteGolemDeLava(Entidad)
			elif Entidad.Name[:9] == "Golem_ice":
				RndEnmGen.MuerteGolemDeHielo(Entidad)	
			elif Entidad.Name[:10] == "Golem_clay":				
				Bladex.AddScheduledFunc(Bladex.GetTime() + 3.2, RndEnmGen.DestrozarGolem,(Entidad,))
			elif (Entidad.Kind == "Skeleton") and (Entidad.Data.Fuego == 1):
				RndEnmGen.MuerteEsqueletoDeFuego(Entidad)
			elif (Entidad.Kind == "ChaosKnight"):
				RndEnmGen.MuerteCaballeroDelCaos(Entidad)
			
			if attacker == "Player1":
				if DEATH_MATRIX:
					darfuncs.StartMatrixFX()
					if Matrix_Activado == 0: # Si est activado el modo Matrix permanente, no interrumpimos el efecto
						Bladex.AddScheduledFunc(Bladex.GetTime()+1.0,PararEfectoMatrix,());

				global killCount
				killCount = killCount + 1
				cleanCount = cleanCount + 1
				score = score + CharStats.GetCharExperienceReward(Entidad.Kind, Entidad.Level)
	UpdateScoreBoard()
	if cleanCount > 10:
		CleanUpArena()

Damage.PlayerHitFunc = PlayerHitFunc

#-----------------------------------------------------------------------------------------------------------------------------------------------------------
# Shyrka:
# Esta es la funcin que permite corregir el bug de los miembros mutilados del jugador. Funciona de la siguiente manera:
# 1) ComprobarManos es asignada como la MutilateFunc del jugador
# 2) Cuando se lanza, comprueba si alguno de los nodos de mutilacin es un brazo o una mano (El nmero es distinto segn el tipo de jugador)
# 3) Si es el caso, guarda en una variable global ("Arma" o "Escudo") el objeto que portase en ella.
# 4) Hace que el objeto se caiga
# Luego, en el respawn, se comprueba si estas variable globales guardan algn objeto y se restaura en el jugador.

Arma = None
Escudo = None
KindArma = None

def ComprobarManos (EntityName,obj_name,x,y,z,nx,ny,nz,node): # Hay que ver nodos 5 y 4 (Manos dcha)
	global Arma
	global Escudo
	global KindArma
	
	Player = Bladex.GetEntity(EntityName)

	if Player.Kind == "Amazon_N":
		if node == 5 or node == 7:
			Arma = Bladex.GetEntity(Bladex.GetEntity('Player1').InvRight)
			if Arma != None:
				Actions.DropToMakeRoomFor ("Player1", Bladex.GetEntity('Player1').InvRight)
		elif node == 10:
			Escudo = Bladex.GetEntity(Bladex.GetEntity('Player1').InvLeft)
			if Escudo != None:
				Actions.DropToMakeRoomFor ("Player1", Bladex.GetEntity('Player1').InvLeft)
	elif Player.Kind == "Barbarian_N":
		if node == 3 or node == 5:
			Arma = Bladex.GetEntity(Bladex.GetEntity('Player1').InvRight)
			if Arma != None:
				KindArma = Arma.Kind
				Actions.DropToMakeRoomFor ("Player1", Bladex.GetEntity('Player1').InvRight)
		elif node == 9 or node == 12:
			Escudo = Bladex.GetEntity(Bladex.GetEntity('Player1').InvLeft)
			if Escudo != None:
				Actions.DropToMakeRoomFor ("Player1", Bladex.GetEntity('Player1').InvLeft)
	elif Player.Kind == "Knight_N":
		if node == 3 or node == 5:
			Arma = Bladex.GetEntity(Bladex.GetEntity('Player1').InvRight)
			if Arma != None:
				Actions.DropToMakeRoomFor ("Player1", Bladex.GetEntity('Player1').InvRight)
		elif node == 10 or node == 13:
			Escudo = Bladex.GetEntity(Bladex.GetEntity('Player1').InvLeft)
			if Escudo != None:
				Actions.DropToMakeRoomFor ("Player1", Bladex.GetEntity('Player1').InvLeft)
	else:
		if node == 4 or node == 7:
			Arma = Bladex.GetEntity(Bladex.GetEntity('Player1').InvRight)
			if Arma != None:
				Actions.DropToMakeRoomFor ("Player1", Bladex.GetEntity('Player1').InvRight)
		elif node == 9 or node == 11:
			Escudo = Bladex.GetEntity(Bladex.GetEntity('Player1').InvLeft)
			if Escudo != None:
				Actions.DropToMakeRoomFor ("Player1", Bladex.GetEntity('Player1').InvLeft)
		
#-----------------------------------------------------------------------------------------------------------------------------------------------------------
# Shyrka:
# Esta funcin est copiada al 99% del mod "HeadMatrix" escrito por Masklin. He conservado el nombre en agradecimiento por su ayuda. Tiene tres utilidades:
# - La primera es asegurarse de que se dispara el DeathMatrix cuando el golpe del jugador rebana la cabeza del enemigo, pero no tiene fuerza intrnseca para
#   acabar con toda su vida. Con el condicional de Vida <= 0 no se disparaba en este caso
# - La segunda es por los golems de lava y hielo. Se ha de aplicar un tratamiento a sus pedazos, y se referencian desde aqu.
# - La tercera es por el vampiro, que tiene el mismo problema que el personaje cunado le cortan la mano derecha (No se le cae el arma)

def HeadMatrix (EntityName,obj_name,x,y,z,nx,ny,nz,node):
 	Victima=Bladex.GetEntity(EntityName)
	
	if (Victima.Name[:10] == "Golem_lava") or (Victima.Name[:9] == "Golem_ice"):
		L = Bladex.GetEntity(obj_name)
		L.CastShadows = 0
		L.TimerFunc = RndEnmGen.Desaparecer
		L.SubscribeToList("Timer15")
	elif (Victima.Name[:4] == "Vamp") and (node == 3 or node == 5):
		Arma = Bladex.GetEntity(Victima.InvRight)
		if Arma != None:
			Actions.DropToMakeRoomFor (EntityName, Victima.InvRight)		

	if node == 3 and Victima.Life > 0 and DEATH_MATRIX:
		darfuncs.StartMatrixFX()
		Bladex.AddScheduledFunc(Bladex.GetTime()+1.0, PararEfectoMatrix,())

###############################################################################
# Player Death
###############################################################################

def EndReSpawn():
	player = Bladex.GetEntity("Player1")
	if player.Data.Invincibility == 3:
		player.Data.Invincibility = 0

#-----------------------------------------------------------------------------------------------------------------------------------------------------------
# Shyrka:
# Esta funcin tambin la he modificado para permitir el funcionamiento correcto de DeathMatrix y para corregir el bug de los brazos cercenados del
# jugador.

def ReSpawn():
	ClearText()
	if DEATH_MATRIX and not Matrix_Activado:
		PararEfectoMatrix() # Si el usuario inicia el round en pleno Matrix de su muerte, que se detenga (Pero no si Matrix permanente est activo)
	Player = Bladex.GetEntity("Player1")
	if Player.Life <= 0:
		Player.PartialLevel = Player.PartialLevel - (CharStats.GetCharExperienceCost(Player.CharType, Player.Level) * EXP_PENALTY)
		if Player.PartialLevel < 0:
			Player.PartialLevel = 0
		Scorer.SetLevelBarValue(Player.PartialLevel)
		# Update scoreboard
		Bladex.RemoveAfterFrameFunc("Fade")
		global deathCount
		deathCount = deathCount + 1
		global score
		score = score - (Player.Level * Player.Level * 75)
		UpdateScoreBoard()
	# Esto es para recuperar el arma si es que la perdi debido a una mutilacin.
		global Arma
		global Escudo
		global KindArma
		
		if Arma != None:
			Actions.TakeObject(Player.Name, Arma.Name)
			Arma = None
		if Escudo != None:
			Actions.TakeObject(Player.Name, Escudo.Name)
			Escudo = None
		# launch animation to take care of falling death
		Player.LaunchAnmType("Rlx")
		Player.Data.ReSpawn("Player1")
		if (darfuncs.ValidAppear(GladCfg.playerPosition) != 1) or (GladCfg.randomPositions):
			# If there are enemies around the starting position, then 
			# use a different one
			Player.Position = GetPosition()
		else:
			Player.Position = GladCfg.playerPosition
			Player.Angle = GladCfg.playerAngle
		GenFX.PersonMagicallyAppearing()
		invincibleTime = 4
		Auras.MakeAura(Player.Name,invincibleTime,(25,1.0,1.0,1,0,0), (),(),(2,  0.8,0.8,1.0, 1.0, 0.6  , 0.0,0.0,1.0, 0.0, 1.0))
		if Player.Data.Invincibility == 0:
			Player.Data.Invincibility = 3
		Bladex.AddScheduledFunc(Bladex.GetTime() + invincibleTime, EndReSpawn,(), "EndReSpawn")

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def PlayerDied (entity):
	ClearText()
	player = Bladex.GetEntity("Player1")
	player.InitPos = player.Position
	player.Wuea = Reference.WUEA_ENDED
	DisplayText(GetText(SDefeated) %(GetKey("ReSpawn")))

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def SetupPlayerDeathFunc():
	player = Bladex.GetEntity("Player1")
	player.Data.OldImDeadFunc = player.ImDeadFunc
	player.ImDeadFunc = PlayerDied

SetupPlayerDeathFunc()

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

# Fixes for the player moving while dead
for func in acts.FuncList:
	Bladex.RemoveBoundFunc("Toggle Weapons",func)

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def IsPlayerDead():
	return Bladex.GetEntity("Player1").Life <= 0

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def FixToggleWeapons(EntityName):
	if (EntityName == "Player1") and (IsPlayerDead()):
		return
	Actions.StdToggleWeapons(EntityName)
Bladex.AddBoundFunc("Toggle Weapons", acts.DefArgWrapper("Player1", FixToggleWeapons))

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

OldTryDropRight = Actions.TryDropRight

def FixTryDropRight(EntityName):
	if (EntityName == "Player1") and (IsPlayerDead()):
		return
	OldTryDropRight(EntityName)

Actions.TryDropRight = FixTryDropRight

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

OldTryDropLeft = Actions.TryDropLeft

def FixTryDropLeft(EntityName):
	if (EntityName == "Player1") and (IsPlayerDead()):
		return
	OldTryDropLeft(EntityName)

Actions.TryDropLeft = FixTryDropLeft

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

OldStdThrowObject = Actions.StdThrowObject

def FixStdThrowObject(EntityName):
	if (EntityName == "Player1") and (IsPlayerDead()):
		return
	OldStdThrowObject(EntityName)

Actions.StdThrowObject = FixStdThrowObject


###############################################################################
# Text Display functions
###############################################################################

def DisplayText(text):
	ClearText()
	if Scorer.VISIBLE==0:
		Scorer.wFrame.SetSize(10,10)
		Scorer.wFrame.RecalcLayout()
	Scorer.wGameText.SetColor(255, 255, 255)
	Scorer.wGameText.SetText(text)
	Scorer.wFrame.MoveWidgetTo("GameTextWidget",0.5,27);
	Scorer.wFrame.RecalcLayout()
	GameText.FadeText(0,1)

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def ClearText():
	GameText.ClearText()


###############################################################################
# Cleanup the arena
###############################################################################

def RemoveObject(obj):
	Reference.debugprint("CLEANING: " + obj.Name)
	obj.RemoveFromWorld()
	obj.SubscribeToList("Pin")

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def RemoveBreakableObject(obj):
	try:
		brkobj = obj.Data.brkobjdata
		for i in brkobj.n_piezas:
			RemoveObject(brkobj.pieza[i])
	except:
		pass
	RemoveObject(obj)

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def InInventory(objtype, name, inv):
	if objtype == Reference.OBJ_WEAPON:
		for i in range(inv.nWeapons):
			if inv.GetWeapon(i) == name:
				return 1
	elif objtype == Reference.OBJ_SHIELD:
		for i in range(inv.nShields):
			if inv.GetShield(i) == name:
				return 1
	return 0

#-----------------------------------------------------------------------------------------------------------------------------------------------------------
# Shyrka:
# Otra modificacin ms. He aadido el parmetro "DejarArmas" para permitir al jugador limpiar la arena dejando slo las armas y escudos

def CleanUpArena(DejarArmas=0):
	global cleanCount
	cleanCount = 0
	# call the garbage collector
	ObjStore.CheckStore()
	# clean up everything
	player = Bladex.GetEntity("Player1")
	nents = Bladex.nEntities()
	inv = player.GetInventory()
	for i in range(nents):
		obj = Bladex.GetEntity(i)
		if obj == None:
			continue
		if obj.Person == 1: 
			# Originariamente, los cuerpos eran retirados automticamente por el generador. Yo cambi eso, de modo que ahora permanecen sobre la
			# arena a la espera de ser retirados por esta funcin. El problema viene cuando el estado del jugador es salvado estando muerto. En
			# este caso, cuando comience una nueva partida con este personaje la ejecucin de CleanUpArena por parte de StartRound provocara el
			# intento de retirar de la arena el cadver del jugador, dando un error MUY gordo. De ah que en la siguiente lnea se compruebe
			# que no es el jugador el objeto al que estamos apuntando.
			if (obj.Life <= 0) and (obj.Name != "Player1"):
				obj.SubscribeToList("Pin")
		else:
			objtype = Reference.GiveObjectFlag(obj.Name)
			if (objtype == Reference.OBJ_WEAPON or objtype == Reference.OBJ_SHIELD) and DejarArmas == 0:
				if DejarArmas == 0:
					# If parent is set, just leave the object
					if obj.Parent == None:
						# Check to see if the player has it
						if InInventory(objtype, obj.Name, inv) == 0:
							# BUG: When an enemy dies, the Parent flag gets cleared, but for
							# some reason the en.InvLeft and en.InvRight property still 
							# contains a reference to an object.  If we delete the object, 
							# then the reference is bogus and BOD will end up crashing when 
							# it tries to clean up that entity.  So, what we do is search 
							# for the parent and if it is still around, just leave the 
							# objects for cleanup next time.  
							owner = Bladex.GetEntity(obj.Name[:len(obj.Name)-7])
							if owner == None:
								RemoveBreakableObject(obj)
								continue

					if obj.Parent != None:
						P=Bladex.GetEntity(obj.Parent)
		# Si es un objeto que no se puede coger (Intil para el jugador) se retira
			if (obj.Kind == "Mazapiedra" or obj.Kind == "Hachacarnicero" or obj.Kind == "Espadon" or obj.Kind == "Escudon"):
				owner = Bladex.GetEntity(obj.Name[:len(obj.Name)-7])
				if (owner == None) or (owner.Life <= 0):
					RemoveObject(obj)
					continue
					
			elif obj.Kind[:4] == "Limb":
				RemoveObject(obj)
			elif objtype == Reference.OBJ_STANDARD:
				if obj.Parent == None:
					RemoveObject(obj)
			elif obj.Kind == "Entity Pool":
				# Remove all pools
				RemoveObject(obj)
			else:
				# look for weapon/shield pieces without owners.
				idx = string.find(obj.Name, "Pieza")
				if idx != -1:
					parent = Bladex.GetEntity(obj.Name[:idx])
					if parent == None:
						RemoveObject(obj)
						continue
				# Things that get here are not necessarily bad.  
				# They may be cleaned by other methods.
				# Reference.debugprint("NOT CLEANED: " + obj.Name + " " + obj.Kind + " " + str(objtype))


################################################################################
# Modo Matrix								(Shyrka)
################################################################################

# Esta variable global sirve para saber si est activado el efecto Matrix
Matrix_Activado = 0

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

# Esta funcin se implement para poder efectuar al mismo tiempo la parada del efecto Matrix y el ajuste del tiempo segn lo que dijo el usuario
def PararEfectoMatrix():
	darfuncs.StopMatrixFX()
	Bladex.SetTimeSpeed(VelocidadTiempo/10)
	
#-----------------------------------------------------------------------------------------------------------------------------------------------------------

# Esta funcin activa/desactiva el efecto matrix (Como un interruptor)
def ConmutarMatrix():
	global Matrix_Activado
	if Matrix_Activado:
		PararEfectoMatrix()
		Matrix_Activado = 0
		if scoreBoardOn < 2: # Si scoreBoardOn es 2, significa que se ocultan todos los indicadores
			GameText.WriteTextAux(GetText(SMatrixOff),2.0,255,255,255,[]) # El GetText sirve para que elija en el ForeignDict el idioma
	else:
		darfuncs.StartMatrixFX()
		Matrix_Activado = 1
		if scoreBoardOn < 2:
			GameText.WriteTextAux(GetText(SMatrixOn),2.0,255,255,255,[])

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

# Estas lneas dan de alta la funcin, o algo as, para poder ser invocada mediente teclado
Bladex.AddInputAction("ConmutarMatrix", 0)
Bladex.AddBoundFunc("ConmutarMatrix", ConmutarMatrix)

################################################################################
# Matar enemigo								(Shyrka)
################################################################################

# Esta funcin mata al enemigo seleccionado de forma chula

def KillSelected():
	char = Bladex.GetEntity("Player1")
	if char.Data.selected_enemy:
		Enemy = Bladex.GetEntity(char.Data.selected_enemy[0])
		if Enemy:
			Enemy.Life = 0
			if (Enemy.Kind == "Golem_lava"):
				Enemy.MutilateFunc = RndEnmGen.DesaparecerLimbs
				RndEnmGen.MuerteGolemDeLava(Enemy)
			elif (Enemy.Name[:9] == "Golem_ice") :
				Enemy.MutilateFunc = RndEnmGen.DesaparecerLimbs
				RndEnmGen.MuerteGolemDeHielo(Enemy)
			elif Enemy.Name[:10] == "Golem_clay":				
				Bladex.AddScheduledFunc(Bladex.GetTime() + 3.2, RndEnmGen.DestrozarGolem,(Enemy,))
			elif ((Enemy.Kind == "Skeleton") and (Enemy.Data.Fuego == 1)):
				Limb = Enemy.SeverLimb(1)
				Limb.Impulse(0,-5000,0)
				RndEnmGen.MuerteEsqueletoDeFuego(Enemy)
			elif (Enemy.Kind == "ChaosKnight"):
				RndEnmGen.MuerteCaballeroDelCaos(Enemy)
			elif Enemy.Kind in ["Amazon_N", "Barbarian_N", "Knight_N", "Dwarf_N", "Knight_Zombie", "Lich", "Cos", "Ragnar", "Troll_snow", "Troll_Dark", "Ork", "Knight_Traitor", "Great_Ork", "Dark_Knight", "Skeleton", "Salamander", "Minotaur", "Little_Demon", "Vamp"]:
				if Enemy.Kind == "Salamander":
					Limb = Enemy.SeverLimb(0) # En Salamander la cabeza es el nodo 0
				elif Enemy.Kind == "Little_Demon":
					Enemy.Alpha = 1
					return
				else:
					Limb = Enemy.SeverLimb(1)
				
				x = whrandom.randint(0,5) * 1000
				if whrandom.randint(0,1) == 1: x = x * (-1)
				
				y = whrandom.randint(0,5) * 1000
				if whrandom.randint(0,1) == 1: y = y * (-1)
				
				if Enemy.Kind == "Skeleton":
					Limb.Impulse(x,-5000,y)
				elif Enemy.Kind == "Vamp":
					Limb.Impulse(x,-5000,y)
				elif Enemy.Kind == "Minotaur":
					Limb.Impulse(x * 10,-100000,y * 10)
				elif Enemy.Kind == "Great_Ork":
					Limb.Impulse(x,-100000,y)
				elif Enemy.Kind == "Dwarf_N":
					Limb.Impulse(x,-30000,y)
				elif Enemy.Kind in ["Amazon_N", "Troll_snow", "Troll_Dark"]:
					Limb.Impulse(x,-20000,y)
				else:
					Limb.Impulse(x,-10000,y)
#-----------------------------------------------------------------------------------------------------------------------------------------------------------			

# Estas lneas dan de alta la funcin, o algo as, para poder ser invocada mediente teclado
Bladex.AddInputAction("KillSelected", 0)
Bladex.AddBoundFunc("KillSelected", KillSelected)

################################################################################
# CMARA LENTA								(Shyrka)
################################################################################

VelocidadTiempo = 10.0

def RalentizarTiempo():
	if not JUEGO_PAUSADO:
		global VelocidadTiempo
		if VelocidadTiempo > 1:
			VelocidadTiempo = VelocidadTiempo - 1;
			Bladex.SetTimeSpeed(VelocidadTiempo/10);
			GameText.ShowMessage(GetText(STimeContinues) % ((Bladex.GetTimeSpeed() * 10)),255,255,255);
			Bladex.AddScheduledFunc((Bladex.GetTime()+2),GameText.HideMessage,(),"HideMessage")
		elif VelocidadTiempo == 1:
			PausarJuego();
			VelocidadTiempo = 0.0

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def AcelerarTiempo():
	global VelocidadTiempo
	if JUEGO_PAUSADO: VelocidadTiempo = 0.0
	if VelocidadTiempo < 10:
		VelocidadTiempo = VelocidadTiempo + 1;
		Bladex.SetTimeSpeed(VelocidadTiempo/10);
		if VelocidadTiempo < 10:
			GameText.ShowMessage(GetText(STimeContinues) % ((Bladex.GetTimeSpeed() * 10)),255,255,255);
		else:
			GameText.ShowMessage(GetText(SNormalTime))
		Bladex.AddScheduledFunc((Bladex.GetTime()+2),GameText.HideMessage,(),"HideMessage")
	if JUEGO_PAUSADO: PausarJuego();

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

Bladex.AddInputAction("RalentizarTiempo", 0)
Bladex.AddBoundFunc("RalentizarTiempo", RalentizarTiempo)

Bladex.AddInputAction("AcelerarTiempo", 0)
Bladex.AddBoundFunc("AcelerarTiempo", AcelerarTiempo)

################################################################################
# Pausar juego								(Shyrka)
################################################################################

JUEGO_PAUSADO = 0

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

#Esta funcin pausa/reanuda el juego
def PausarJuego():
	global JUEGO_PAUSADO
	GameText.HideMessage();
	if JUEGO_PAUSADO:	# Si el juego est en pausa
		if Bladex.GetTimeSpeed() < 1:
			GameText.ShowMessage(GetText(STimeContinues) % ((Bladex.GetTimeSpeed() * 10)),255,255,255);
			Bladex.AddScheduledFunc((Bladex.GetTime() + 2),GameText.HideMessage,(),"HideMessage")
		else:
			GameText.ShowMessage(GetText(SNormalTime),255,255,255);
			Bladex.AddScheduledFunc((Bladex.GetTime() + 2),GameText.HideMessage,(),"HideMessage")
		Bladex.RestartTime();	# Reanudamos el juego
		JUEGO_PAUSADO = 0
	else:
		if scoreBoardOn != 2:
			GameText.ShowMessage(GetText(SPaused),255,255,255);
		Bladex.AddScheduledFunc((Bladex.GetTime() + 2),GameText.HideMessage,(),"HideMessage")
		Bladex.StopTime();	# Pausamos el juego
		JUEGO_PAUSADO = 1

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

# Estas lneas dan de alta la funcin, o algo as, para poder ser invocada mediente teclado
Bladex.AddInputAction("PausarJuego", 0)
Bladex.AddBoundFunc("PausarJuego", PausarJuego)

################################################################################
# Efecto Matrix en muertes						(Shyrka)
################################################################################

DEATH_MATRIX = 1

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

def ConmutarDeathMatrix():
	global DEATH_MATRIX
	DEATH_MATRIX = not DEATH_MATRIX
	if scoreBoardOn < 2: # Si scoreBoardOn es 2, significa que se ocultan todos los indicadores
		if DEATH_MATRIX:
			GameText.WriteTextAux(GetText(SDeathMatrixOn),2.0,255,255,255,[]) # El GetText sirve para que elija en el ForeignDict el idioma
		else:
			PararEfectoMatrix()
			GameText.WriteTextAux(GetText(SDeathMatrixOff),2.0,255,255,255,[])

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

# Estas lneas dan de alta la funcin, o algo as, para poder ser invocada mediente teclado
Bladex.AddInputAction("ConmutarDeathMatrix", 0)
Bladex.AddBoundFunc("ConmutarDeathMatrix", ConmutarDeathMatrix)

################################################################################
# Limpieza de la arena							(Shyrka)
################################################################################

def LimpiarArena():
	CleanUpArena(1)	

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

# Estas lneas dan de alta la funcin, o algo as, para poder ser invocada mediente teclado
Bladex.AddInputAction("LimpiarArena", 0)
Bladex.AddBoundFunc("LimpiarArena", LimpiarArena)

################################################################################
# Salida rpida del juego						(Shyrka)
################################################################################

def Salir():
	GladCfg.SavePlayer(Bladex.GetEntity("Player1"), killCount, deathCount, score, round)
	Bladex.Quit()

#-----------------------------------------------------------------------------------------------------------------------------------------------------------

# Estas lneas dan de alta la funcin, o algo as, para poder ser invocada mediante teclado
Bladex.AddInputAction("Salir", 0)
Bladex.AddBoundFunc("Salir", Salir)

###############################################################################
# Keyboard binding
###############################################################################

Bladex.AddBoundFunc("ReSpawn", ReSpawn)
Bladex.AddBoundFunc("StartMusic", StartMusic)
Bladex.AddBoundFunc("StartRound", StartRound)
Bladex.AddBoundFunc("Show Scorer", ToggleScoreBoard)

###############################################################################
# Start it off...
###############################################################################

StartRound()

if GladCfg.CombosMultiples == 1:
	execfile ("CombosMultiples.py")