###########################################################################
## Talk System Data Base
###########################################################################

import Talk


###########################################################################
## Standard Dialogs
###########################################################################


## Alone: The player says these texts when there is not nobody faced
##-------------------------------------------------------------------------

TSDB.Alone = ["I might as well talk to the wall!",
	      "Whom do you want to talk with?",
	      "Do you think is right to shout?",
	      "Am I talking to myself?"]

              
## Alone: The player says these texts when the faced character doesn't
## have assigned any dialogue.
##-------------------------------------------------------------------------
              
TSDB.Ignore = ["It seems he has nothing to say.",
               "I am afraid I'm being ignored.",
               "He doesn't seem to want to talk.",
               "Hi!!"]              
               
###########################################################################
## Customized dialogs for each character
###########################################################################

## Dlg Database:
## Format:
##    TSDB.Dlg [pers.Name]={
##           'dlgId': {
##              'Text':
##                """Texto libre""",
##               'Answers': ['ansId1',...'ansIdn']
##              'OtherKey': value
##           }
##    }
##
## * Text: The text will be formatted for TS.
## * Answer: List of answers (ansId). If the list is null [] the
##   conversation is stopped.
##  Please reads the documentation to know the details
##
##-------------------------------------------------------------------------

TSDB.Dlg ["Glofror"]={
	'Hola': {
	    'Text':
	     """Orks! The creature has yet to be born that can withstand Glofror's Axe! """\
	     """Are you alright boy? No one should be overconfident when dealing with these beasts. """\
	     """They are stupid but strong.""",
           'Answers': ['Soy yo', 'Soy yo sin orcos', 'Dejame']
        },
	'Pues tu veras': {
	    'Text':
	     """This is not the best place to refuse help. I'll go and see how """\
	     """Old Elglar is doing.""",
            'Answers': [],
	    'NewDlg': None
        },
	'Quedan orcos': {
	    'Text':
	     """I think theres another one at the back of the Inn. My arm is hurt """\
	     """and I don't think I would be able to survive another skirmish. """\
	     """Meanwhile I'll go to see old Elglar.""", 
            'Answers': ['Yo me encargo','Si hay que ir se va']
        },
	'A por ellos': {
	    'Text':
	     """By the Beard of Durin! May Gondor keep giving us brave men!""", 
            'Answers': [],
	    'NewDlg': 'Alguno mas'
        },
	'Si tu lo dices': {
	    'Text':
	     """Perhaps you're right! But it will be difficult for me go with you. My fighting days are over. """\
	     """A long time will pass before this arm is healed again. """, 
            'HideDelay':20, 
            'Answers': [],
	    'NewDlg': None
        },
	'Alguno mas': {
	    'Text':
	     """For Aul's sake boy! You're still alive! Did you find any more beasts?""",
            'Answers': ['Uno grande', 'Ninguno'],
	    'NewDlg': 'Vienes de Gondor'
        },
	'Vienes de Gondor': {
	    'Text':
	     """Dol Amroth?...I don't know that place, but all Gondorians are Glofror's friends. """\
	     """A bit far from your homeland, don't you think?""",
            'Answers': ['Iba tras los orcos']
        },
	'Una historia extraa': {
	    'Text':
	     """A strange tale you are telling us! Long ago I travelled through the lands of Gondor, """\
	     """but it always looked like a safe place. What the heck were those Orks doing so far from """\
	     """the Dark Lord's land?. Is there nowhere left that is safe?... Eh Elglar! Do you remember"""\
	     """that girl who was here some days ago? She told us a very similar story.""",
	    'ExtraDlg': ['Elglar',
	                 """Of course I remember! She was following a group of Orks that had killed her mother... """\
	                 """She was desperate and decided to go to the mountains. We warned her...and more than """\
	                 """three moons have passed since then."""],
	     'CallBack':'UnPocoDeMusicaON', 
            'Answers': ['SoyElla', 'Montaas']
	},
	'Lord': {
	    'Text':
	     """I neither know nor wish to find the answer. There were lots of merchants that used to travel """\
	     """the Gwathlo route, but very few dare to pass through the gorge now. Some weeks ago Lord Adrinnor """\
	     """tried that route, but was forced to turn back.""",
            'Answers': ['SoyElla','Qu pas']
	},
	'Puente roto': {
	    'Text':
	     """From what he told us, the path is full of beasts. Enormous Orks hungry for blood. """\
	     """Lord Adrinnor and his bodyguards finally reached the Hill of Sevarel, but they said """\
	     """the bridge was destroyed and the waters of the Gwathlo are very dangerous this time of year.""",
	     'CallBack':'UnPocoDeMusicaOFF', 
            'Answers': ['SoyElla']
	},
	'Me temo que no': {
	    'Text':
	     """I'm not sure, I think she came from Minhiriath. I have traveled far, but  """\
	     """I'll be damned if I know where it is!  If all the inhabitants are similar then it's time to pay  """\
	     """a visit. What do you think, Elglar?""",
	    'ExtraDlg': ['Elglar',
	                 """What with all the beasts around here, I'm thinking of moving to a safer place."""],
            'Answers': ['Montaas'],
	    'ReplaceAns':{'Montaas':['Qu pas']},
	    'NewDlg': None
	},
	'Mas datos': {
	    'Text':
	     """Don't think bad of me boy. That wanderer was an arrogant fool, but I didn't drown him. """\
	     """When he saw the waterfalls he started to jump about like a madman. He slipped and went over the edge. """\
	     """I suppose the waters of the Gwatlo did everything else...""",
            'HideDelay':30, 
            'Answers': [],
	    'NewDlg': None
        }
}



###########################################################################
## Player Answers
###########################################################################

## Answers Database:
## Format:
##   TSDB.Ans [pers.Name]={
##	'ansId': {
##	    'Text':
##	     """Texto""",
##	    'NextDlg': 'ansId',
##	    'Enabled':1
##          'OtherKey': value
##       }
##    }
## * Text: The text will be formatted for TS.
## * NextDlg: The identifier of the next dialogue (dlgId). To stop a  
##   conversation: None.
##  Please reads the documentation to know the details
##-------------------------------------------------------------------------



TSDB.Ans ["Glofror"]={
	'Soy yo': {
	    'Text':
	     """Truth is, these ones didn't seem as stupid! My name is Damathar, son of Othar, """\
	     """soldier of Gondor at Dol Amroth. Thanks for your help.""",
	    'NextDlg': 'Quedan orcos',
	    'Enabled':1
        },
	'Soy yo sin orcos': {
	    'Text':
	     """Truth is, these ones didn't seem as stupid! My name is Damathar, son of Othar, """\
	     """soldier of Gondor at Dol Amroth. Thanks for your help.""",
	    'NextDlg': 'No quedan orcos',
	    'Enabled':0
        },
	'Dejame': {
	    'Text':
	     """Leave me alone! I can take care of myself.""",
	    'NextDlg': 'Pues tu veras',
	    'Enabled':1
        },
	'Yo me encargo': {
	    'Text':
	     """Don't worry Glofror. I'll take a look in the stable and be back in no time. """,
	    'NextDlg': 'A por ellos',
	    'Journal': 'BuscaOrco',
	    'Enabled':1
        },
	'Si hay que ir se va': {
	    'Text':
	     """I'd better follow you to the Inn. I don't think it's a good idea being out alone.""",
	    'NextDlg': 'Si tu lo dices',
	    'Enabled':1
        },
	'Uno grande': {
	    'Text':
	     """The biggest Ork I've seen in my entire life! May Ilvatar protect us! """\
	     """Beasts such as that shouldn't exist!""",
	    'NextDlg': 'Vienes de Gondor',
	    'Enabled':1
        },
	'Ninguno': {
	    'Text':
	     """I haven't seen anything. Maybe they retreated to the mountains""",
	    'NextDlg': 'Vienes de Gondor',
	    'Enabled':1
        },
	'Iba tras los orcos': {
	    'Text':
	     """Some days ago a group of Orks attacked my father's farm. I couldn't prevent his death. """\
	     """I could follow their tracks. I think they are the same group that attacked the Inn.""",
	    'NextDlg': 'Una historia extraa',
	    'Enabled':1
        },
	'SoyElla': {
	    'Text':
	     """That girl? Did she say her name?""",
	    'NextDlg': 'Me temo que no',
	    'Enabled':1
        },
	'Montaas': {
	    'Text':
	     """What's going on in the mountains?""",
	    'NextDlg': 'Lord',
	    'Enabled':1
        },
	'Qu pas': {
	    'Text':
	     """Why did Lord Adrinnor come back?v""",
	    'NextDlg': 'Puente roto',
	    'Enabled':1
        }
}

###########################################################################
## Journal
###########################################################################

TSDB.JrlTxt = {
	'BuscaOrco':
	    """Glofror has asked me to look behind the Inn. It seems that there are """\
	    """still some Orcs around."""
        }
