###########################################################################
## Talk System v 0.8  - by Masklin Jun-2003
###########################################################################

import Bladex
import Scorer
import ScorerWidgets
import BUIx
import Raster
import KeybWidget
import Language
import BInput
import GameText
import Actions
import B3DLib
import GameStateAux
import ObjStore
import Enm_Def
import DefaultSelectionData
import Menu
import MenuText
import acts

import os
import string
import re
import whrandom

###########################################################################
## Global configuration
###########################################################################


#TSFont            = "../../Data/letras ts med.bmp"
TSFont             = "../../Data/letras menu med.bmp"
TSmmp              = "../../Data/TSWidgets.mmp"
   
MaxLines           = 8
RMargin            = 66
ColorDlg           = 255,255,255
ColorAns           = 207,144,49
ColorAnsSelected   = 252,247,167
ColorjTitle        = 255,204,51 # 201,62,39
ColorjText         = 252,247,167
ColorjTextSelected = 255,204,51

TextYBase        = 300
TextYSize        = 14
TextXBase        = 35

TSTalkRange      = 5000
TSHideDelay      = 10.0

SeeEvent         = 1
NoWarning        = 1

SelectNPCArea    = 10000


rh,rv=Raster.GetSize()


if rh == 800:
  jMaxLines        = 15
  jRMargin         = 35
  jTextYBase       = 90
  jTextYSize       = 14
  jTextXBase       = 380

elif rh == 1024:
  jMaxLines        = 15
  jRMargin         = 35
  jTextYBase       = 90
  jTextYSize       = 14
  jTextXBase       = 410

else:
  jMaxLines        = 15
  jRMargin         = 32
  jTextYBase       = 90
  jTextYSize       = 14
  jTextXBase       = 359


if Language.Current == 'Spanish':
	JournalTitle   = "D I A R I O"
	KBTalkLabel    = "Hablar"
	KBJournalLabel = "Diario"
else:
	JournalTitle = "J O U R N A L"
	KBTalkLabel    = "Talk"
	KBJournalLabel = "Journal"

# Enable this flag for extra debug messages:
Debug   = 0

###########################################################################
## Allow customization
###########################################################################

try:
   execfile ('TSCustom.py')
   if Debug:
      print "TS-DBG: Customized script loaded"
except:
   pass



###########################################################################
## Utilities
###########################################################################

def findall(pattern, source):
        pos = 0
        end = len(source)
        results = []
        p=re.compile(pattern)
        while pos <= end:
           regs = p.search(source, pos, end)
           if not regs:
                break
           results.append(regs.group())
           pos = max(regs.start()+1, pos+1)
        return results

import stat

def copyfile(src, dst):
    """Copy data from src to dst"""
    fsrc = None
    fdst = None
    try:
        fsrc = open(src, 'rb')
        fdst = open(dst, 'wb')
        while 1:
            buf = fsrc.read(16*1024)
            if not buf:
                break
            fdst.write(buf)
    finally:
        if fdst:
            fdst.close()
        if fsrc:
            fsrc.close()

def copystat(src, dst):
    """Copy all stat info (mode bits, atime and mtime) from src to dst"""
    st = os.stat(src)
    mode = stat.S_IMODE(st[stat.ST_MODE])
    os.utime(dst, (st[stat.ST_ATIME], st[stat.ST_MTIME]))
    os.chmod(dst, mode)

def copy2(src, dst):
    """Copy data and all stat info ("cp -p src dst").

    The destination may be a directory.

    """
    if os.path.isdir(dst):
        dst = os.path.join(dst, os.path.basename(src))
    copyfile(src, dst)
    copystat(src, dst)

def SelectNPC ():
	pj  = Bladex.GetEntity("Player1")
	pjp = pj.Position
	enemyList=[]
	for ename in Bladex.GetEntitiesAt(pjp[0],pjp[1],pjp[2], SelectNPCArea):
            ene=Bladex.GetEntity(ename)
	    if ene.Person and ene.Life > 0 and pj.CanISee(ene) and ene.Name<>'Player1':
               enemyList.append(ene.Name)
        if len (enemyList) == 0: return None
        enemyList.sort(Enm_Def.ChooseNearest)
        return enemyList[0]


###########################################################################
## Keyboard
###########################################################################

Defined_Key_Talk    = 0
Defined_Key_Journal = 0
KEY_TALK    = 'T'
KEY_JOURNAL = 'J'

def UnBindKey (KeyName):

	IManager = BInput.GetInputManager()
	keyb=IManager.GetAttachedDevice("Keyboard")
	if not keyb.IsBinded('T'):
	   return

    	IActions=IManager.GetInputActions()
    
    	for i in range (0, IActions.nElements()):
            IAction=IActions.GetAction(i)
     
      	    if IAction.Name()=="NULL":
               continue
      
            for j in range(IAction.nInputEvents()):
      	        IEvent=IAction.GetnInputEvent(j)
      	        IDevice=IEvent.GetDevice()
      	        if(IDevice=="Keyboard" and IEvent.GetKey()==KeyName):
	           IAction.RemoveEvent(keyb, KeyName, 1)
	           return
	           
def GetKey(line):
	import re
	return re.split('"*"', line)[5]

def GetKeyBindings():
	try:
		import string
		f = open('../../Config/Control.py', 'r')
		if not f:
			return
		line = "tmp"
		while line != "":
			line = f.readline()
			idx = string.find(line, '"TSStartConversation"')
			if idx != -1:
				global KEY_TALK, Defined_Key_Talk
				KEY_TALK = GetKey(line)
				Defined_Key_Talk    = 1
			idx = string.find(line, '"TSEnableJournal"')
			if idx != -1:
				global KEY_JOURNAL, Defined_Key_Journal
				KEY_JOURNAL = GetKey(line)
				Defined_Key_Journal = 1
		f.close()
	except:
		pass


GetKeyBindings()

def NewKeyMenu(name, action, defkey):
	# Add to configurable list
	try:
	  idx= ConfigurableActions.index ((name, action, [],))
	except:
	  acts.ConfigurableActions.append((name, action, [],));

	# Add to key configs
	IManager = BInput.GetInputManager()
	oldSet = IManager.GetInputActionsSet()
	IManager.SetInputActionsSet("Default")
	IActions = IManager.GetInputActions()
	IAction = IActions.Find(action)	
	if IAction.Name() == "NULL":
		Bladex.AddInputAction(action, 0)
	try:
	  import GotoMapVars
          Sinfo=GotoMapVars.MainCharState('Player1').GetProps()
	  # New game: Control -> Talk
	  #UnBindKey (defkey)
	  Bladex.AssocKey(action, "Keyboard", defkey, 1)		
        except:
	  # Saved game: Talk -> Control
	  pass

	Menu.GetMenuItem(['CONTROLS','KEYBOARD', 'KeybList'])['ListDescr'].append({
		"Name":MenuText.GetMenuText(name),
		"Position": Menu.CtrlsPosition,
		"Action": action, 
		"Kind": KeybWidget.ControlMenuItem,
		"kFlags":[], "Size":(200,300)
		})


NewKeyMenu(KBTalkLabel, "TSStartConversation", KEY_TALK)
if Defined_Key_Talk == 0:
#   UnBindKey (KEY_TALK)
   if not os.path.exists ('../../Config/Control.py'):
      try:	
         copy2 ('../../Scripts/DefControl.py', '../../Config/Control.py')
         os.chmod('../../Config/Control.py', 0777)
      except:
          pass		
   try:
	  f=open('../../Config/Control.py','a')
          text='Bladex.AssocKey("%s","%s","%s")\n'%("TSStartConversation","Keyboard",KEY_TALK)
          f.write(text)
          f.close()
   except:
          pass		

NewKeyMenu(KBJournalLabel, "TSEnableJournal", KEY_JOURNAL)
if Defined_Key_Journal == 0:
#   UnBindKey (KEY_JOURNAL)
   if not os.path.exists ('../../Config/Control.py'):
      try:	
         copy2 ('../../Scripts/DefControl.py', '../../Config/Control.py')
         os.chmod('../../Config/Control.py', 0777)
      except:
          pass		
   try:
	  f=open('../../Config/Control.py','a')
          text='Bladex.AssocKey("%s","%s","%s")\n'%("TSEnableJournal","Keyboard",KEY_JOURNAL)
          f.write(text)
          f.close()
   except:
          pass		

InputManager=BInput.GetInputManager()

CurrentIAS = InputManager.GetInputActionsSet()

InputManager.SetInputActionsSet("Default")
Bladex.AddInputAction("TSStartConversation",0)
Bladex.AddInputAction("TSEnableJournal",0)

def StartConversation ():
	pj = Bladex.GetEntity("Player1")
	personName=None
	if pj.Data.selected_enemy:
           personName=pj.Data.selected_enemy[0]
	else:
	   personName=SelectNPC()
        if personName <> None:
	   if Debug:
	      print "TS-DBG: Start conversation with ", personName
           tk=Bladex.GetEntity(personName)
	   try:
              dlgId=tk.Data.dlgId
	   except:
	      dlgId=None
	   if dlgId <> None:
              TS.Say (tk.Name)
              TSWidgets.Enable()
           else:
              GameText.WriteTextAux(TSDB.IgnoreMe(),4.0,255,255,255,[])
        else:
           GameText.WriteTextAux(TSDB.ImAlone(),4.0,255,255,255,[])

Bladex.AddBoundFunc("TSStartConversation", StartConversation)


def EnableJournal ():
	TSWidgets.jEnable()


Bladex.AddBoundFunc("TSEnableJournal", EnableJournal)


InputManager.AddInputActionsSet("TalkSystem")
InputManager.SetInputActionsSet("TalkSystem")

Bladex.AddInputAction("TSRetrocede",0)
Bladex.AddInputAction("TSAvanza",0)
Bladex.AddInputAction("TSNext",0)
Bladex.AddInputAction("TSCancelar",0)
Bladex.AddInputAction("TSSelecciona",0)


Bladex.AssocKey("TSRetrocede","Mouse","WheelUp")
Bladex.AssocKey("TSRetrocede","Keyboard","PgUp")
Bladex.AssocKey("TSAvanza","Mouse","WheelDown")
Bladex.AssocKey("TSAvanza","Keyboard","PgDown")
Bladex.AssocKey("TSNext","Keyboard","Tab")
Bladex.AssocKey("TSNext","Mouse","RightButton")
Bladex.AssocKey("TSSelecciona","Keyboard","Enter")
Bladex.AssocKey("TSSelecciona","Mouse","LeftButton")
Bladex.AssocKey("TSCancelar","Keyboard","Esc")


def PressKeyUp ():
        TSText.MoveUp ()


def PressKeyDown ():
        TSText.MoveDown ()

def PressKeyNext ():
        TSText.NextAnswer ()

def PressKeyEsc ():
        TSWidgets.Disable()

def PressKeyEnter ():
	try:
           ansId = TSText.Line[TSText.Answers[TSText.CurrentAns]['LineInf']]['ansId']
           TS.AnswerDisable (TS.CurrentPerson, ansId)
		
           if TSDB.Ans[TS.CurrentPerson][ansId].has_key('DisableAns'):
	      for DansId in TSDB.Ans[TS.CurrentPerson][ansId]['DisableAns']:
                  TS.AnswerDisable (TS.CurrentPerson, DansId)

           if TSDB.Ans[TS.CurrentPerson][ansId].has_key('NewDlg'):
                 tk=Bladex.GetEntity(TS.CurrentPerson)
                 tk.Data.dlgId=TSDB.Ans[TS.CurrentPerson][ansId]['NewDlg']

	   if TSDB.Ans[TS.CurrentPerson][ansId].has_key('CallBack'):
	   	callBackFunc=TSDB.Ans[TS.CurrentPerson][ansId]['CallBack']+'(\''+TS.CurrentPerson+'\',\''+ansId+'\')'
	   	try:
   		  if Debug:
		      print "TS-DBG: Exec CallBack Func: ", callBackFunc
  	     	  Func = TS.CallBackFuncs[TSDB.Ans[TS.CurrentPerson][ansId]['CallBack']]
	          Func(TS.CurrentPerson,ansId)
	   	except:
	   	  print "Talk System: Error executing function "+ callBackFunc
		  import traceback
		  traceback.print_exc()
		  pass

	   if TSDB.Ans[TS.CurrentPerson][ansId].has_key('Journal'):
  		if Debug:
		      print "TS-DBG: Add Journal Entry: ", TSDB.Ans[TS.CurrentPerson][ansId]['Journal']
	   	TSDB.AddToJournal (TSDB.Ans[TS.CurrentPerson][ansId]['Journal'])

	   if Debug:
	      print "TS-DBG: Selected ", ansId, "...  Say ",ansId
	   if TSDB.Ans[TS.CurrentPerson][ansId]['NextDlg']:
	      TS.Say (TS.CurrentPerson, TSDB.Ans[TS.CurrentPerson][ansId]['NextDlg']) 
	   else:
	      Bladex.AddScheduledFunc(Bladex.GetTime(), TSWidgets.Disable,(),"TS_Disable")
	   
	except:
           TSWidgets.Disable()

Bladex.AddBoundFunc("TSRetrocede",PressKeyUp)
Bladex.AddBoundFunc("TSAvanza",PressKeyDown)
Bladex.AddBoundFunc("TSNext",PressKeyNext)
Bladex.AddBoundFunc("TSCancelar",PressKeyEsc)
Bladex.AddBoundFunc("TSSelecciona",PressKeyEnter)


InputManager.AddInputActionsSet("TSJournal")
InputManager.SetInputActionsSet("TSJournal")

Bladex.AddInputAction("TSJRetrocede",0)
Bladex.AddInputAction("TSJAvanza",0)
Bladex.AddInputAction("TSJNext",0)
Bladex.AddInputAction("TSJCancelar",0)

Bladex.AddInputAction("TSDisableJournal",0)

Bladex.AssocKey("TSJRetrocede","Mouse","WheelUp")
Bladex.AssocKey("TSJRetrocede","Keyboard","PgUp")
Bladex.AssocKey("TSJAvanza","Mouse","WheelDown")
Bladex.AssocKey("TSJAvanza","Keyboard","PgDown")
Bladex.AssocKey("TSJNext","Keyboard","Tab")
Bladex.AssocKey("TSJNext","Mouse","LeftButton")
Bladex.AssocKey("TSJNext","Mouse","RightButton")
Bladex.AssocKey("TSJCancelar","Keyboard","Esc")

Bladex.AssocKey("TSDisableJournal","Keyboard",KEY_JOURNAL)

def jPressKeyUp ():
        TSjText.MoveUp ()


def jPressKeyDown ():
        TSjText.MoveDown ()

def jPressKeyNext ():
        TSjText.NextEntry ()

def DisableJournal ():
	TSWidgets.jDisable()
	
Bladex.AddBoundFunc("TSJRetrocede",jPressKeyUp)
Bladex.AddBoundFunc("TSJAvanza",jPressKeyDown)
Bladex.AddBoundFunc("TSJNext",jPressKeyNext)
Bladex.AddBoundFunc("TSJCancelar", DisableJournal)
Bladex.AddBoundFunc("TSJSelecciona",jPressKeyNext)

Bladex.AddBoundFunc("TSDisableJournal", DisableJournal)

InputManager.SetInputActionsSet(CurrentIAS)

###########################################################################
## Sounds
###########################################################################

TSJ=Bladex.CreateSound("..\\..\\Sounds\\M-DESENFUNDA-PIEDRA.wav","TSJournal")
TSJ.Volume=1.0
TSJ.MinDistance=1000000.0
TSJ.MaxDistance=2000000

TSJw=Bladex.CreateSound("..\\..\\Sounds\\mechanism-operated-2.wav","TSNewEntry")
TSJw.Volume=1.0
TSJw.MinDistance=1000000.0
TSJw.MaxDistance=2000000

###########################################################################
## Custom classes
###########################################################################

class ClsTSDB:
    
    DataPath = './TS/'
    Dlg      = {}
    Ans      = {}
    Var      = {}
    Alone    = []
    Ignore   = []
    Jrl      = []
    JrlIds   = []
    
    def __init__(self):
	self.ObjId=ObjStore.GetNewId() # Para identificarlo al grabar/guardar
	ObjStore.ObjectsStore[self.ObjId]=self

    def persistent_id(self):
		return self.ObjId

    def __getstate__(self):
		# Tiene que devolver cmo poder guardar el estado de la clase
		return (1,
				self.ObjId,
				self.Dlg,
				self.Ans,
				self.Var,
				self.Jrl,
				self.JrlIds,
				GameStateAux.SaveNewMembers(self),
#				GameStateAux.SaveFunctionAux(self.InitGenFunc),
				)
		
    def __setstate__(self,parm):
		# Toma como parmetro lo que devuelve __getstate__() y debe recrear la clase
		if parm[0]==1:
			self.ObjId=parm[1]
			ObjStore.ObjectsStore[self.ObjId]=self
			
			self.Dlg=parm[2]
			self.Ans=parm[3]
			self.Var=parm[4]
			self.Jrl=parm[5]
			self.JrlIds=parm[6]
    			TSDB.Jrl=self.Jrl # :-)
			GameStateAux.LoadNewMembers(self,parm[7])
#			GameStateAux.LoadFunctionAux(parm[13],self,"InitGenFunc")
		else:
			print "EnmGen.__setstate__() -> Version mismatch"
			# Valores de creacin por si valen para algo.
			self.ObjId=ObjStore.GetNewId() # Para identificarlo al grabar/guardar
			ObjStore.ObjectsStore[self.ObjId]=self

    def Init (self, module=None):
	if module:
	   self.DataPath = '../../'+module+'/TS/'

    def Clear (self):
	self.Dlg = {}
	self.Ans = {}
	TS.CallBackFunc = {}

    def ClearVars (self):
	self.Var = {}

    def ClearJournal (self):
	self.Jrl = {}
	self.JrlIds = []
	TSjText.Reset()

    def SetVar (self, name, value):
	self.Var[name]=value

    def GetVar (self, name):
	if self.Var.has_key(name):
		return self.Var[name]
	else:
		return ''

    def Load (self, filename):
	if   os.path.exists (self.DataPath + Language.Current +'/'+filename+'.py'):
	  try:
            execfile(self.DataPath + Language.Current +'/'+filename+'.py')
          except:
            print "Talk System: Error loading "+ Language.Current + " database: ",  filename
	    import traceback
	    traceback.print_exc()
	    pass
	else:
          try:
            execfile(self.DataPath + '/'+filename+'.py')
          except:
            print "Talk System: Error loading generic database: ", filename
	    import traceback
	    traceback.print_exc()
	    pass

    def Assign (self, person, dlgId, event=None):
	tk=Bladex.GetEntity(person)
	if tk:
	   try:
	    tk.Data.dlgId=dlgId
	    if event:
	       if event == SeeEvent:
		  tk.Data.TSoldSeeFunc=tk.SeeFunc
		  tk.SeeFunc = TS.SeeFunc
	   except:
            print "Talk System: Error setting dlgId ("+dlgId+") for ", person
	    import traceback
	    traceback.print_exc()
	    pass

    def ImAlone (self):
    	try:
	   return self.Alone [whrandom.randint(0, len(self.Alone)-1)]
	except:
	   return ""

    def IgnoreMe (self):
    	try:
	   return self.Ignore [whrandom.randint(0, len(self.Ignore)-1)]
	except:
	   return ""

    def Validate (self):
	print "Validate TSDB: Current Database"
	for person in TSDB.Dlg.keys():
	   print "Validate TSDB: Processing ", person
	   print "Validate TSDB:    Dlg Test"
	   for dlgId in TSDB.Dlg[person].keys():
	       print "Validate TSDB:         dlgId ", dlgId
	       for ansId in TSDB.Dlg[person][dlgId]['Answers']:
		   if TSDB.Ans[person].has_key(ansId):
	       	      print "Validate TSDB:            ansId ", ansId, " OK"
		   else:		   	
	       	      print "Validate TSDB:            ansId ", ansId, " *** Not Found ***"

	       if TSDB.Dlg[person][dlgId].has_key('NewDlg'):
	       	   ndlgId=TSDB.Dlg[person][dlgId]['NewDlg']
		   if TSDB.Dlg[person].has_key(ndlgId) or ndlgId == None:
	       	      print "Validate TSDB:            New dlgId ", ndlgId, " OK"
		   else:		   	
	       	      print "Validate TSDB:            New dlgId ", ndlgId, " Not Found"
	       	      
	   print "Validate TSDB:    Ans Test"
	   for ansId in TSDB.Ans[person].keys():
	       if TSDB.Dlg[person].has_key(TSDB.Ans[person][ansId]['NextDlg']):
	          print "Validate TSDB:            AnsId ", ansId, " OK"
	       else:		   	
	          print "Validate TSDB:            AnsId ", ansId, " Not Found"
	       if TSDB.Ans[person][ansId].has_key('NewDlg'):
	       	   ndlgId=TSDB.Ans[person][ansId]['NewDlg']
		   if TSDB.Dlg[person].has_key(ndlgId) or ndlgId == None:
	       	      print "Validate TSDB:            New dlgId ", ndlgId, " OK"
		   else:		   	
	       	      print "Validate TSDB:            New dlgId ", ndlgId, " Not Found"

    def AddToJournal (self, jrlId, Warning=0):

	Text = self.JrlTxt[jrlId]
	if Debug:
	   print "TS-DBG: AddToJournal : jrlId =",jrlId, " Text = ", Text

	self.Jrl.append(Text)
        self.JrlIds.append (jrlId)
       	if Warning == 0:
	   TSWidgets.SlidejNE (0)


    def RemoveFromJournal (self, jrlId):

	if Debug:
	   print "TS-DBG: RemoveFromJournal : jrlId =",jrlId
	try:
	  jrlN = self.JrlIds.index(jrlId)
	  if Debug:
	     print "TS-DBG: RemoveFromJournal : Text =",self.Jrl [jrlN]
	  del self.Jrl [jrlN]
	  del self.JrlIds [jrlN]
	except:
	  pass

class ClsTS:
        
    CurrentPerson = None
    CallBackFuncs = {}

    def __init__(self):
	pass
	
    def Parse (self, text):
    	for var in findall ('%\w+', text):
   	    text = string.replace (text, var, str (TSDB.GetVar(var[1:])))
   	return text

    def AnswerDisable (self, person, ansId):
       	TSDB.Ans[person][ansId]['Enabled']=0

    def AnswerEnable (self, person, ansId):
       	TSDB.Ans[person][ansId]['Enabled']=1

    def Say (self, person, dlgId=None):

        TSText.Reset()
	self.CurrentPerson = person
        tk=Bladex.GetEntity(person)
        if dlgId == None:
           dlgId=tk.Data.dlgId	
	if dlgId == None:
	   return
	CurrentDlg = TSDB.Dlg[person][dlgId]
	if Debug:
	   print "TS-DBG: Say ", person, " - ",dlgId
        TSText.AddText (self.Parse(person+': '+CurrentDlg['Text']))
        if CurrentDlg.has_key('ExtraDlg'):
           TSText.AddText (self.Parse(CurrentDlg['ExtraDlg'][0]+': '+CurrentDlg['ExtraDlg'][1]))

	nAnswers=0
	if len(CurrentDlg['Answers']):
	   for ansId in CurrentDlg['Answers']:
	       validAnsId=None
	       if TSDB.Ans[person][ansId]['Enabled']:
	       	  validAnsId=ansId
	       elif CurrentDlg.has_key('ReplaceAns'):
	          if CurrentDlg['ReplaceAns'].has_key(ansId):
	       	     for nextAnsId in CurrentDlg['ReplaceAns'][ansId]:
	              if TSDB.Ans[person][nextAnsId]['Enabled']:
	       	         validAnsId=nextAnsId
	       	         break
	       if validAnsId:
        	  TSText.AddText (self.Parse(TSDB.Ans[person][validAnsId]['Text']), validAnsId)
		  nAnswers=nAnswers+1
	if nAnswers == 0:
	   if CurrentDlg.has_key('HideDelay'):
	     hideDelay = CurrentDlg['HideDelay']
	   else:
	     hideDelay = TSHideDelay
	   Bladex.AddScheduledFunc(Bladex.GetTime()+hideDelay, TSWidgets.Disable,(),"TS_Disable")
	else:
	   TSText.TargetLInf = TSText.Answers[TSText.CurrentAns]['LineInf']
	   TSText.TargetLSup = TSText.Answers[TSText.CurrentAns]['LineSup']   
        if CurrentDlg.has_key('NewDlg'):
           tk.Data.dlgId=CurrentDlg['NewDlg']
        TSText.ShowText()
        
	if CurrentDlg.has_key('CallBack'):
   	   callBackFunc=CurrentDlg['CallBack']+'(\''+self.CurrentPerson+'\',\''+dlgId+'\')'
	   try:
   	     if Debug:
	        print "TS-DBG: Exec CallBack Func: ", callBackFunc
  	     Func = self.CallBackFuncs[CurrentDlg['CallBack']]
	     Func(self.CurrentPerson,dlgId)
	   except:
	     print "Talk System: Error executing function "+ callBackFunc
	     import traceback
	     traceback.print_exc()
	     pass

	if CurrentDlg.has_key('Journal'):
  	   if Debug:
	      print "TS-DBG: Add Journal Entry: ", CurrentDlg['Journal']
	   TSDB.AddToJournal (CurrentDlg['Journal'])


    def SetAnswer (self, person, ansId, text, nextdlgId=None):
       	TSDB.Ans[person][ansId]['Text']=text
       	if nextdlgId:
       	   TSDB.Ans[person][ansId]['NextDlg']=nextdlgId
       	TSDB.Ans[person][ansId]['Enabled']=1
		
    def SetDialog (self, person, dlgId, text, answers=None):
       	TSDB.Dlg[person][dlgId]['Text']=text
       	if answers:
       	   TSDB.Dlg[person][dlgId]['Answers']=answers
       
       
    def SeeFunc (self, EntityName):
        tk=Bladex.GetEntity(EntityName)
        if tk.Life <0 : return
	if B3DLib.GetXZDistance (EntityName, 'Player1') < TSTalkRange:
	   if tk.Data.TSoldSeeFunc or tk.Data.TSoldSeeFunc==None:
	      tk.SeeFunc=tk.Data.TSoldSeeFunc
	   Actions.TurnToFaceEntityNow("Player1", tk.Name)   
           if tk.Data.dlgId and tk.Data.dlgId != None:
              TS.Say (tk.Name)
              TSWidgets.Enable()

    def AddCallBackFunc (self, FuncName, Func):
	self.CallBackFuncs[FuncName]=Func

    def ShowMessage (self, Text, HideDelay):
        TSText.Reset()
	if Debug:
	   print "TS-DBG: ShowMessage : Text = ", Text, "\nDelay = ",HideDelay
        TSText.AddText (self.Parse(Text))
        TSText.ShowText()
        Bladex.AddScheduledFunc(Bladex.GetTime()+HideDelay, TSWidgets.Disable,())


	   
class ClsTSText:

    Line         = {}
    NLines       = 0
    MaxLines     = 8
    LineInf      = 1
    LineSup      = 1
    Answers      = {}
    NAns         = 0
    CurrentAns   = 1
    TargetLInf   = 0
    TargetLSup   = 0
    RMargin      = 66


    def __init__(self):
    	global MaxLines
    	self.MaxLines = MaxLines

    def Reset (self):
    	global MaxLines, RMargin
    	self.MaxLines    = MaxLines
        self.Line        = {}
        self.NLines      = 0
        self.LineInf     = 1
        self.LineSup     = 1
        self.Answers     = {}
        self.NAns        = 0
        self.CurrentAns  = 1
        self.TargetLInf  = 0
        self.TargetLSup  = 0
	self.RMargin     = RMargin
	
    def AddText (self, Text, ansId=None):
    	
	lineLen = 0
	sText   = ''
	for word in string.split(Text):
	    wLen = len (word)
	    if lineLen + wLen < self.RMargin:
	       lineLen = lineLen + wLen + 1
	       sText = sText + word + ' '
	    else:
	       sText = sText + "\n" + word + ' '
	       lineLen = wLen + 1
	Text = sText

        initNLines = self.NLines+1
        for line in string.split(Text,"\n"):
            self.NLines = self.NLines + 1
            self.Line[self.NLines]= {'Text':line + "\n", 'ansId':ansId}
	    if Debug:
	       print "TS-DBG: AddText (",ansId,") - ", line
	if ansId:
           self.NAns = self.NAns + 1
       	   self.Answers[self.NAns]= {'LineInf':initNLines, 'LineSup':self.NLines}
       	else:
            self.NLines = self.NLines + 1
            self.Line[self.NLines]= {'Text':"\n", 'ansId':ansId}       	
        self.LineInf = 1
        self.LineSup = min (self.MaxLines, self.NLines)

    def ShowText (self):    	
        for i in range (1, self.MaxLines+1):
            currentLine = self.LineInf+i-1
	    if Debug:
	       print "TS-DBG: ShowText - Line: ", currentLine
            try:
              ansId = self.Line[currentLine]['ansId']
              if   not ansId:
                   selectedMark=''
            	   TSWidgets.TextWidget[i].SetColor(ColorDlg[0],ColorDlg[1],ColorDlg[2])
              elif currentLine >= self.TargetLInf and currentLine <= self.TargetLSup:
                   selectedMark='> '
            	   TSWidgets.TextWidget[i].SetColor(ColorAnsSelected[0],ColorAnsSelected[1],ColorAnsSelected[2])
              else:
                   selectedMark='  '
            	   TSWidgets.TextWidget[i].SetColor(ColorAns[0],ColorAns[1],ColorAns[2])
              Text  = selectedMark+self.Line[currentLine]['Text']
	      if Debug:
	         print "TS-DBG: ShowText - Text: ", Text
              TSWidgets.TextWidget[i].SetText(Text)
            except:
              TSWidgets.TextWidget[i].SetText('')
	if currentLine < self.NLines:
	    Text = string.replace (Text, '\n', '  >>>\n')
	    TSWidgets.TextWidget[i].SetText(Text)


    def MoveUp (self):
	self.LineInf = self.LineInf-1
    	if self.LineInf < 1:
    	   self.LineInf = 1
	self.LineSup = self.LineInf + self.MaxLines -1
        self.ShowText()

    def MoveDown (self):
	self.LineInf = self.LineInf+1
    	if self.LineInf > self.NLines-self.MaxLines+1:
    	   self.LineInf = self.LineInf -1
	self.LineSup = self.LineInf + self.MaxLines -1
        self.ShowText()

    def NextAnswer (self):
    	if self.NAns == 0:
    	   return
	self.CurrentAns = self.CurrentAns+1
    	if self.CurrentAns > self.NAns:
    	   self.CurrentAns = 1
  	self.TargetLInf = self.Answers[self.CurrentAns]['LineInf']
	self.TargetLSup = self.Answers[self.CurrentAns]['LineSup']

	if   self.TargetLSup > self.LineSup:
	     self.LineSup = self.TargetLSup
	     self.LineInf = self.LineSup - self.MaxLines +1
	elif self.TargetLInf < self.LineInf:
	     self.LineInf = self.TargetLInf
	     self.LineSup = self.LineInf + self.MaxLines
        self.ShowText()


class ClsTSjText:

    Line         = {}
    NLines       = 0
    MaxLines     = 15
    LineInf      = 1
    LineSup      = 1
    JrlData      = {}
    NJrl         = 0
    CurrentJrl   = 1
    TargetLInf   = 0
    TargetLSup   = 0
    RMargin      = 40


    def __init__(self):
    	global jMaxLines
    	self.MaxLines = jMaxLines

    def Reset (self):
    	global jMaxLines, jRMargin
    	self.MaxLines   = jMaxLines
        self.Line        = {}
        self.NLines      = 0
        self.LineInf     = 1
        self.LineSup     = 1
        self.JrlData     = {}
        self.NJrl        = 0
        self.CurrentJrl  = 1
        self.TargetLInf  = 0
        self.TargetLSup  = 0
	self.RMargin     = jRMargin
	
    def AddText (self, Text, jrlN):
    	
	lineLen = 0
	sText   = ''
	for word in string.split(Text):
	    wLen = len (word)
	    if lineLen + wLen < self.RMargin:
	       lineLen = lineLen + wLen + 1
	       sText = sText + word + ' '
	    else:
	       sText = sText + "\n" + word + ' '
	       lineLen = wLen + 1
	Text = sText

        initNLines = self.NLines+1
        for line in string.split(Text,"\n"):
            self.NLines = self.NLines + 1
            self.Line[self.NLines]= {'Text':line + "\n", 'jrlN':jrlN}
	    if Debug:
	       print "TS-DBG: AddText (",jrlN,") - ", line
        self.NLines = self.NLines + 1
        self.Line[self.NLines]= {'Text':"\n", 'jrlN':jrlN}
        self.NJrl = self.NJrl + 1
	self.JrlData[self.NJrl]= {'LineInf':initNLines, 'LineSup':self.NLines}
        self.LineInf = 1
        self.LineSup = min (self.MaxLines, self.NLines)


    def ShowText (self):    	
        for i in range (1, self.MaxLines+1):
            currentLine = self.LineInf+i-1
	    if Debug:
	       print "TS-DBG: ShowText - Line: ", currentLine
            try:
              jrlN = self.Line[currentLine]['jrlN']
              if currentLine >= self.TargetLInf and currentLine <= self.TargetLSup:
            	   TSWidgets.jTextWidget[i].SetColor(ColorjTextSelected[0],ColorjTextSelected[1],ColorjTextSelected[2])
              else:
            	   TSWidgets.jTextWidget[i].SetColor(ColorjText[0],ColorjText[1],ColorjText[2])
              Text  = self.Line[currentLine]['Text']
	      if Debug:
	         print "TS-DBG: ShowText - Text: ", Text
              TSWidgets.jTextWidget[i].SetText(Text)
            except:
              TSWidgets.jTextWidget[i].SetText('')
	if currentLine < self.NLines:
	    TSWidgets.jMoreWidget.SetVisible(1)
	    TSWidgets.jTextWidget[i].SetText(Text)
	else:
	    TSWidgets.jMoreWidget.SetVisible(0)

    def MoveUp (self):
	self.LineInf = self.LineInf-1
    	if self.LineInf < 1:
    	   self.LineInf = 1
	self.LineSup = self.LineInf + self.MaxLines -1
        self.ShowText()

    def MoveDown (self):
	self.LineInf = self.LineInf+1
    	if self.LineInf > self.NLines-self.MaxLines+1:
    	   self.LineInf = self.LineInf -1
	self.LineSup = self.LineInf + self.MaxLines -1
        self.ShowText()

    def NextEntry (self):
    	if self.NJrl == 0:
    	   return
	self.CurrentJrl = self.CurrentJrl+1
    	if self.CurrentJrl > self.NJrl:
    	   self.CurrentJrl = 1
           
  	self.TargetLInf = self.JrlData[self.CurrentJrl]['LineInf']
	self.TargetLSup = self.JrlData[self.CurrentJrl]['LineSup']

	if   self.TargetLSup > self.LineSup:
	     self.LineSup = self.TargetLSup
	     self.LineInf = self.LineSup - self.MaxLines +1
	elif self.TargetLInf < self.LineInf:
	     self.LineInf = self.TargetLInf
	     self.LineSup = self.LineInf + self.MaxLines
        self.ShowText()

    def LoadJournalText (self):

        self.Reset()
        jrlN=0
	for text in TSDB.Jrl:
	    self.AddText (TS.Parse(text), jrlN)
	    jrlN = jrlN + 1
	if jrlN > 0:
	   self.CurrentJrl = jrlN -1
	   self.NextEntry()
        self.ShowText()       


class ClsTSWidgets:

    TextWidget      = []
    jTextWidget     = []
    marco1          = 0
    marco2          = 0
    marco3          = 0
    journal         = 0
    LastIAS         = 'Default'
    jTitleWidget    = 0
    jMoreWidget     = 0
    jNewEntry       = 0  
    BitMapIdx       = 0

    def __init__(self):
        self.TextWidget.append(None)
        for i in range (1, MaxLines+1):
            textWidget=BUIx.B_TextWidget(Scorer.wFrame,"TextWidget","",ScorerWidgets.font_server, TSFont)
            self.TextWidget.append(textWidget)
            self.TextWidget[i].SetAlpha(1)
            Scorer.wFrame.AddWidget(self.TextWidget[i], TextXBase , TextYBase + TextYSize * i,
                                    BUIx.B_FrameWidget.B_FR_AbsoluteLeft, BUIx.B_FrameWidget.B_FR_Left,
                                    BUIx.B_FrameWidget.B_FR_AbsoluteTop,BUIx.B_FrameWidget.B_FR_Top)
            self.TextWidget[i].SetVisible(0)
            self.TextWidget[i].SetAutoScale(0)

        self.marco1=BUIx.B_BitmapWidget(Scorer.wFrame,"Marco1",256,256,"TSBarra1", TSmmp)
        self.marco1.SetColor(255,255,255)
        Scorer.wFrame.AddWidget(self.marco1,0,480-256,
        	BUIx.B_FrameWidget.B_FR_AbsoluteLeft,BUIx.B_FrameWidget.B_FR_Left,
        	BUIx.B_FrameWidget.B_FR_AbsoluteTop,BUIx.B_FrameWidget.B_FR_Top)
        self.marco1.SetAlpha(1.0)
        self.marco1.SetVisible(0)
        self.marco1.SetAutoScale(1)

        self.marco2=BUIx.B_BitmapWidget(Scorer.wFrame,"Marco2",256,256,"TSBarra2", TSmmp)
        self.marco2.SetColor(255,255,255)
        Scorer.wFrame.AddWidget(self.marco2,256,480-256,
        	BUIx.B_FrameWidget.B_FR_AbsoluteLeft,BUIx.B_FrameWidget.B_FR_Left,
        	BUIx.B_FrameWidget.B_FR_AbsoluteTop,BUIx.B_FrameWidget.B_FR_Top)
        self.marco2.SetAlpha(1.0)
        self.marco2.SetVisible(0)
        self.marco2.SetAutoScale(1)

        self.marco3=BUIx.B_BitmapWidget(Scorer.wFrame,"Marco3",256,256,"TSBarra3", TSmmp)
        self.marco3.SetColor(255,255,255)
        Scorer.wFrame.AddWidget(self.marco3,512,480-256,
        	BUIx.B_FrameWidget.B_FR_AbsoluteLeft,BUIx.B_FrameWidget.B_FR_Left,
        	BUIx.B_FrameWidget.B_FR_AbsoluteTop,BUIx.B_FrameWidget.B_FR_Top)
        self.marco3.SetAlpha(1.0)
        self.marco3.SetVisible(0)
        self.marco3.SetAutoScale(1)



        self.jTitleWidget=BUIx.B_TextWidget(Scorer.wFrame,"jTitleWidget","",ScorerWidgets.font_server, TSFont)
        Scorer.wFrame.AddWidget(self.jTitleWidget, 450 , 60,
                                    BUIx.B_FrameWidget.B_FR_AbsoluteLeft, BUIx.B_FrameWidget.B_FR_Left,
                                    BUIx.B_FrameWidget.B_FR_AbsoluteTop,BUIx.B_FrameWidget.B_FR_Top)
	self.jTitleWidget.SetAlpha(1.0)
	self.jTitleWidget.SetVisible(0)
	self.jTitleWidget.SetAutoScale(0)
	self.jTitleWidget.SetText(JournalTitle)
	self.jTitleWidget.SetColor(ColorjTitle[0],ColorjTitle[1],ColorjTitle[2])

        self.jTextWidget.append(None)
        for i in range (1, jMaxLines+1):
            textWidget=BUIx.B_TextWidget(Scorer.wFrame,"jTextWidget"+`i`,"",ScorerWidgets.font_server, TSFont)
            self.jTextWidget.append(textWidget)
            self.jTextWidget[i].SetAlpha(1)
            Scorer.wFrame.AddWidget(self.jTextWidget[i], jTextXBase , jTextYBase + jTextYSize * i,
                                    BUIx.B_FrameWidget.B_FR_AbsoluteLeft, BUIx.B_FrameWidget.B_FR_Left,
                                    BUIx.B_FrameWidget.B_FR_AbsoluteTop,BUIx.B_FrameWidget.B_FR_Top)
            self.jTextWidget[i].SetVisible(0)
            self.jTextWidget[i].SetAutoScale(1)
            self.jTextWidget[i].SetAutoSize(1)

        self.jMoreWidget=BUIx.B_TextWidget(Scorer.wFrame,"jMoreWidget","",ScorerWidgets.font_server, TSFont)

        Scorer.wFrame.AddWidget(self.jMoreWidget,  460, 354,
                                    BUIx.B_FrameWidget.B_FR_AbsoluteLeft, BUIx.B_FrameWidget.B_FR_Left,
                                    BUIx.B_FrameWidget.B_FR_AbsoluteTop,BUIx.B_FrameWidget.B_FR_Top)
	self.jMoreWidget.SetAlpha(1.0)
	self.jMoreWidget.SetVisible(0)
	self.jMoreWidget.SetAutoScale(1)
	self.jMoreWidget.SetText(">>>")
	self.jMoreWidget.SetColor(ColorjTitle[0],ColorjTitle[1],ColorjTitle[2])


	self.journal=BUIx.B_BitmapWidget(Scorer.wFrame,"Journal",512,512,"TSJournal", TSmmp)
	self.journal.SetColor(255,255,255)
	hsize=512*rh/640
	vsize=512*rv/480
	hPos=130
	vPos=-10
	Scorer.wFrame.AddWidget(self.journal,hPos,vPos,
                   BUIx.B_FrameWidget.B_FR_AbsoluteLeft,BUIx.B_FrameWidget.B_FR_Left,
                   BUIx.B_FrameWidget.B_FR_AbsoluteTop,BUIx.B_FrameWidget.B_FR_Top)
	self.journal.SetAlpha(1.0)
	self.journal.SetVisible(0)
	self.journal.SetAutoScale(1)
	self.journal.SetSize(hsize,vsize)

	self.jNewEntry=BUIx.B_BitmapWidget(Scorer.wFrame,"jNewEntry",256,256,"TSWarning",TSmmp)
	self.jNewEntry.SetColor(255,255,255)
	Scorer.wFrame.AddWidget(self.jNewEntry,0,0,BUIx.B_FrameWidget.B_FR_AbsoluteRight,BUIx.B_FrameWidget.B_FR_Right,BUIx.B_FrameWidget.B_FR_AbsoluteBottom,BUIx.B_FrameWidget.B_FR_Bottom)
	self.jNewEntry.SetAlpha(1.0)
	self.jNewEntry.SetVisible(0)

    def SlideFrame(self, OnOff,time = 0):
        Size_Y=480
        MarcoAnchoTex = 256.0
        MarcoAltoTex = 256.0

        if time < 1.0:
                Bladex.AddScheduledFunc(Bladex.GetTime() + 0.025,self.SlideFrame,(OnOff,time + 0.05),"TS_SlideFrame")
        else:
                time = 1.0

        if OnOff:
                Y_DOWN = (Size_Y - MarcoAltoTex) + MarcoAltoTex * time
        else:
                Y_DOWN = Size_Y - MarcoAltoTex * time

        Scorer.wFrame.MoveWidgetTo("Marco1",0,Y_DOWN)
        Scorer.wFrame.MoveWidgetTo("Marco2",MarcoAnchoTex,Y_DOWN)
        Scorer.wFrame.MoveWidgetTo("Marco3",MarcoAnchoTex * 2.0,Y_DOWN)
                
    def SetBitMap (self, Name, File):
    	self.BitMapIdx=self.BitMapIdx+1
    	BitMapName="SBM_"+Name+"_"+`self.BitMapIdx`
	Bladex.ReadAlphaBitMap(File, BitMapName)
	if    Name == 'TSBarra1':
		self.marco1.SetBitmap (BitMapName)	
	elif  Name == 'TSBarra2':
		self.marco2.SetBitmap (BitMapName)
	elif  Name == 'TSBarra3':
		self.marco3.SetBitmap (BitMapName)
	elif  Name == 'TSJournal':
		self.journal.SetBitmap (BitMapName)
	elif  Name == 'TSWarning':
		self.jNewEntry.SetBitmap (BitMapName)
		
		
    def Enable (self):
        IManager=BInput.GetInputManager()
        self.LastIAS = IManager.GetInputActionsSet()
    	Bladex.RemoveBoundFunc("Attack","Attack")	
        IManager.SetInputActionsSet("TalkSystem")
    	Bladex.RemoveBoundFunc("Attack","Attack")	
	Actions.FreeBothHands ("Player1")
    	Scorer.PowDefWidgets.Deactivate()
        Bladex.RemoveScheduledFunc("TS_Hide")
	Bladex.RemoveScheduledFunc("TS_Disable")
    	Bladex.RemoveScheduledFunc("TS_SlideFrame")
        self.SlideFrame(0)
        self.marco1.SetVisible(1)
        self.marco2.SetVisible(1)
        self.marco3.SetVisible(1)
        Bladex.AddScheduledFunc(Bladex.GetTime() + 1,self.Show,(), "TS_Show")

    def Show (self):
	for i in range (1, MaxLines+1):
            self.TextWidget[i].SetVisible(1)
        TSText.ShowText()

    def Disable (self):
	for i in range (1, MaxLines+1):
            self.TextWidget[i].SetVisible(0)
    	Bladex.RemoveScheduledFunc("TS_Show")
    	Bladex.RemoveScheduledFunc("TS_SlideFrame")
        self.SlideFrame(1)
        Bladex.AddScheduledFunc(Bladex.GetTime() + 1,self.Hide,(),"TS_Hide")
        IManager=BInput.GetInputManager()
        IManager.SetInputActionsSet(self.LastIAS )
        Bladex.AddBoundFunc("Attack","Attack")	

    def Hide (self):
        self.marco1.SetVisible(0)
        self.marco2.SetVisible(0)
        self.marco3.SetVisible(0)
	pj=Bladex.GetEntity('Player1')
        pj.SetActiveEnemy(None)
	Scorer.PowDefWidgets.Activate()
	
    def jEnable (self):
    	Bladex.RemoveScheduledFunc("TS_Disable")
	TSJ.PlayStereo()
    	TSjText.LoadJournalText ()
        IManager=BInput.GetInputManager()
        self.LastIAS = IManager.GetInputActionsSet()
    	Bladex.RemoveBoundFunc("Attack","Attack")	
        IManager.SetInputActionsSet("TSJournal")
    	Bladex.RemoveBoundFunc("Attack","Attack")	
    	Bladex.RemoveScheduledFunc("TS_HideJournal")
	hsize=512*rh/640
	vsize=512*rv/480
	self.journal.SetSize(hsize,vsize)
	self.ShowJournal()
	self.jShow()


    def jShow (self):
	self.jTitleWidget.SetVisible(1)
	self.jMoreWidget.SetVisible(1)
	for i in range (1, jMaxLines+1):
            self.jTextWidget[i].SetVisible(1)
        TSjText.ShowText()

    def jDisable (self):
	TSJ.PlayStereo()
	self.jTitleWidget.SetVisible(0)
	self.jMoreWidget.SetVisible(0)
	for i in range (1, jMaxLines+1):
            self.jTextWidget[i].SetVisible(0)
    	Bladex.RemoveScheduledFunc("TS_ShowJournal")
	self.HideJournal()
        IManager=BInput.GetInputManager()
        IManager.SetInputActionsSet(self.LastIAS )
        Bladex.AddBoundFunc("Attack","Attack")	
	
    def ShowJournal (self, time = 0):

	hsize=512*rh/640
	hPos=130
	vPos=-10
	if time == 0: 
	   self.journal.SetVisible(1)
	   time = 0.2 # Saltar mscara transparente
	if time < 1.0:
                Bladex.AddScheduledFunc(Bladex.GetTime() + 0.025,self.ShowJournal,(time + 0.05,),"TS_ShowJournal")
        else:
                time = 1.0

        incr  = hsize - hsize * time
        Scorer.wFrame.MoveWidgetTo("Journal",hPos + incr,vPos)
	for i in range (1, jMaxLines+1):
            Scorer.wFrame.MoveWidgetTo("jTextWidget"+`i`,jTextXBase + incr,jTextYBase + jTextYSize * i)
        Scorer.wFrame.MoveWidgetTo("jTitleWidget", 450 + incr, 60)
        Scorer.wFrame.MoveWidgetTo("jMoreWidget",  460 + incr, 354)

    def HideJournal (self, time = 0):

	hsize=512*rh/640
	hPos=130
	vPos=-10
        if time < 1.0:
                Bladex.AddScheduledFunc(Bladex.GetTime() + 0.025,self.HideJournal, (time + 0.05,),"TS_HideJournal")
        else:
                time = 1.0
		self.journal.SetVisible(0)

        X_POS = hsize * time + hPos
        Scorer.wFrame.MoveWidgetTo("Journal",X_POS,vPos)
        
    def SlidejNE (self, dir,time = 0):
	TSJw.PlayStereo()
        Bladex.RemoveScheduledFunc("TS_HideNewEntry")
        Bladex.RemoveScheduledFunc("TS_ShowNewEntry")
	self.SlidejNE2(dir,time)

    def SlidejNE2(self, dir,time = 0):
	
	MarcoAnchoTex = 256
	hsize=256*rh/640/4
	vsize=256*rv/480/4
	vPos=210
	self.jNewEntry.SetSize(hsize,vsize)
	if time < 0.25:
		Bladex.AddScheduledFunc(Bladex.GetTime() + 0.015,self.SlidejNE2,(dir,time + 0.02), "TS_ShowNewEntry")
	else:
		time = 0.25

	if dir:
		XPos = -MarcoAnchoTex * time * 4
	else:
		self.jNewEntry.SetVisible(1)
		XPos = -MarcoAnchoTex + (MarcoAnchoTex * time * 4)

		Scorer.wFrame.MoveWidgetTo("jNewEntry",XPos, vPos)
		
	Bladex.AddScheduledFunc(Bladex.GetTime() + 7,self.HidejNE,(), "TS_HideNewEntry")
		
    def HidejNE(self):
        Bladex.RemoveScheduledFunc("TS_HideNewEntry")
        Bladex.RemoveScheduledFunc("TS_ShowNewEntry")
	self.jNewEntry.SetVisible(0)




###########################################################################
## Initialization
###########################################################################


try:
# Hay una forma ms elegante de ver si existe la instancia TSDB?
   dummy =TSDB.persistent_id()
except:
   TSDB      = ClsTSDB()

TSWidgets = ClsTSWidgets()
TSText    = ClsTSText()
TSjText   = ClsTSjText()
TS        = ClsTS ()

###########################################################################
## User Interface
###########################################################################

def DBClear ():
	TSDB.Clear()
	
def ClearVars ():
	TSDB.ClearVars()
	
def ClearJournal ():
	TSDB.ClearJournal()

def SetVar (name, value):
	TSDB.SetVar(name, value)

def GetVar (name):
	return TSDB.GetVar(name)

def Load (filename):
	TSDB.Load (filename)

def Assign (person, dlgId, event=None):
	TSDB.Assign (person, dlgId, event)

def Validate ():
	TSDB.Validate ()

def AnswerDisable (person, ansId):
	TS.AnswerDisable (person, ansId)

def AnswerEnable (person, ansId):
       	TS.AnswerEnable (person, ansId)

def Say (person, dlgId=None):
	TS.Say (person, dlgId)
	TSWidgets.Enable()

def SetAnswer (person, ansId, text, nextdlgId=None):
	TS.SetAnswer (person, ansId, text, nextdlgId)
		
def SetDialog (person, dlgId, text, answers=None):
       	TS.SetDialog (person, dlgId, text, answers)

def AddCallBackFunc (FuncName, Func):
       	TS.AddCallBackFunc (FuncName, Func)


def ShowMessage (Text, HideDelay=TSHideDelay):
	TS.ShowMessage ( Text, HideDelay)
	TSWidgets.Enable()

def Hide ():
	TSWidgets.Disable()


def AddToJournal (jrlId, Warning=0):
	TSDB.AddToJournal (jrlId, Warning)

def RemoveFromJournal (jrlId):
	TSDB.RemoveFromJournal (jrlId)


def SetBitMap (Name, File):
	TSWidgets.SetBitMap (Name, File)

