import Bladex
import GenFX
import Auras
import Reference
import CharStats
import GameText
import MenuText
import darfuncs
import EnemyTypes
import EnmGenRnd
import AuxFuncs
import Sparks
import Actions
import pocimac
import Breakings
import ItemTypes
import Basic_Funcs
import Damage
import Objects
import Sounds
import whrandom
import Scorer
import stone
import heavyObjects
import Doors
import Levers
import Locks
###############################################################################
def GetText(s):
	return MenuText.GetMenuText(s)
def ClearText():
	global combshow
	combshow=0	
	GameText.ClearText()
################################################################################

GameText.MapList['CONQUEST'] = 'Conquest';

#################################################################################
####### Sounds
Bladex.AddMusicEventADPCM("introbowork",   "..\\..\\Sounds\\ATMOSFERA18.wav", 0.1, 1.0, 1.0, 1, 0, 1 )
Bladex.AddMusicEventADPCM("LavaPuz",   "..\\..\\Sounds\\block-sliding.wav", 0.1, 1.0, 1.0, 1, 0, 1 )	
Bladex.AddMusicEventADPCM("VampIntro",   "..\\..\\Sounds\\final-demonice.mp3", 0.1, 1.0, 1.0, 1, 0, 1 )
Bladex.AddMusicEventADPCM("Finale",   "..\\..\\Sounds\\ATMOSFERA35.wav", 0.1, 1.0, 1.0, 1.0, 0, 1 )
Bladex.AddMusicEventADPCM("Appear",   "..\\..\\Sounds\\COMBATE6.wav", 0.1, 1.0, 1.0, 5, 0, 1 )
Bladex.AddMusicEventADPCM("Darks",   "..\\..\\Sounds\\SORPRESA6.wav", 0.1, 1.0, 1.0, 1, 0, 1 )
Bladex.AddMusicEventADPCM("SkullTurn",   "..\\..\\Sounds\\CORO6.mp3", 0.1, 1.0, 1.0, 1, 0, 0)
#Bladex.AddMusicEventADPCM("Flash",   "..\\..\\Sounds\\fuego-boo.wav", 0.1, 1.0, 1.0, 1, 0, 0)
Bladex.AddMusicEventADPCM("Golem",   "..\\..\\Sounds\\combate1.wav", 0.1, 1.0, 1.0, 1, 0, 1 )
Bladex.AddMusicEventADPCM("FinEnter",   "..\\..\\Sounds\\CORO2.mp3", 0.1, 1.0, 1.0, 1, 0, 1 )
Bladex.AddMusicEventADPCM("Tunnel",   "..\\..\\Sounds\\ATMOSFERA8.wav", 0.1, 1.0, 1.0, 1, 0, 1 )
Bladex.AddMusicEventADPCM("Waypoint",   "..\\..\\Sounds\\sesgado-especial-largo2.wav", 0.1, 1.0, 1.0, 1, 0, 1 )
Bladex.AddMusicEventADPCM("FightDal",   "..\\..\\Sounds\\COMBATE-KAOS.wav", 0.1, 1.0, 1.0, 1, 0, 1 )
Bladex.AddMusicEventADPCM("DalLaugh",   "..\\..\\Sounds\\RisaDkn2.wav", 0.1, 1.0, 1.0, 1, 0, 1 )
Bladex.AddMusicEventADPCM("DalOrders",   "..\\..\\Sounds\\catchhim.wav", 0.1, 1.0, 1.0, 1, 0, 1 )

###########################################################

def EnterMusic():
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("Tunnel"),))
darfuncs.EnterSecEvent(-20000, 23500, -53500, EnterMusic)
#"persephone_normal.mp3"

def BackToMe():
	darfuncs.BackPlayer()

def Powerup(name):
	time=Bladex.GetTime()
	aura=Auras.MakeAura("Player1",1.7, (1, 0.01, 1.0, 0, 0, 1),(),(),(2,  0.8, 0.9, 1.0, 0.6, 0.3  ,  0.2, 0.6, 0.8, 0.4, 1.0))
	aura.Data.AddEvent(time+0.7,(30, 1.0, 1.0, 0, 0, 1),(),(),(2,  0.8, 0.9, 1.0, 0.6, 0.3  ,  0.2, 0.6, 0.8, 0.4, 1.0))
	aura.Data.AddEvent(time+1.7,(240, 0.01, 1.0, 0, 0, 1),(),(),(2,  0.2, 0.2, 0.6, 0.6, 0.4  ,  0.0, 0.0, 0.6, 0.4, 0.5))

####################### Camera, Action! #############
##################### PLAYER RESPAWN AT LAST WAYPOINT ###########################
			                              ###########################
### Init Values #####

player=Bladex.GetEntity("Player1")
player.InitPos=11000,-1500,-7000
WayPoint=11000,-1500,-7000
WayPointAngle=7
WayPointLevel=player.Level
WayPointPartialLevel=0
WayPointLife=player.Life
WayCurrent=""
SavePenalty=0
ShowCStats=0
deathCount=0
deadcheck=0
killcount=0
MaxSaves=30 
DLife=20000 
CLife=20000 
VLife=10000 
GraFX=1
PlayerSkill = ["Godlike","Gladiator","Master of the Blade","Expert Warrior","Weapons Master","Veteran Swordsman","Skilled Swordsman","Swordsman","Apprentice Swordsman","Trainee Swordsman","Footsoldier","Trainee Soldier","Raw Recruit","Peasant","Weakling","Orc Food","Poor","Very Poor","Awful","Hopeless","Total Loser"]
##################################################################################
def KilledEnemy (EntityName):
  	pers=Bladex.GetEntity("Player1")
	pers.Data.OnKilledEnemyOrg(EntityName)
	global killcount
	killcount=killcount+1
pers=Bladex.GetEntity ("Player1")
pers.Data.OnKilledEnemyOrg=pers.Data.OnKilledEnemy
pers.Data.OnKilledEnemy=KilledEnemy
######################################
OldPlayerHitFunc = Damage.PlayerHitFunc
def PlayerHitFunc(victim, attacker, life, prevLife):
	if victim == "Player1":
		global WayCurrent
		o=Bladex.GetEntity(attacker)
		WayCurrent=o.Name
	if OldPlayerHitFunc != "":
		OldPlayerHitFunc(victim, attacker, life, prevLife)

Damage.PlayerHitFunc = PlayerHitFunc



####################################################################################
#                                                                                  #
#  Player ReSpawn + While Dead Functions adapted from Gladiator Mod by Josh Dahlby #
#                                                                                  # 
####################################################################################

def EndReSpawn():
	player = Bladex.GetEntity("Player1")
	if player.Data.Invincibility == 3:
		player.Data.Invincibility = 0

def ReSpawn():
	ClearText()
	player = Bladex.GetEntity("Player1")
	if player.Life <= 0:
		darfuncs.StopMatrixFX()
		Bladex.RemoveAfterFrameFunc("Fade")
		player.InitPos = WayPoint
		player.LaunchAnmType("Rlx")
		player.Data.ReSpawn("Player1")
		global deadcheck
		deadcheck=0
		global WayPoint
		global WayPointAngle
		global WayPointPartialLevel
		global WayPointLevel
		global WayPointLife
		global WayPointPoison
		player.Position = WayPoint[0],WayPoint[1]+1500,WayPoint[2]
		player.Angle = WayPointAngle
		player.Level = WayPointLevel
		player.PartialLevel = WayPointPartialLevel
		player.Life = WayPointLife
		Scorer.SetLevelBarValue(player.PartialLevel)
		player.SetOnFloor()
		global WayCurrent
		if WayCurrent:
			o=Bladex.GetEntity(WayCurrent)
			o.Life=CharStats.GetCharMaxLife(o.Kind, o.Level)
			if (o.Name=="GDmon1"):
				global DLife
				o.Life=DLife
			if (o.Name=="ck1"):
				global CLife
				o.Life=CLife
			if (o.Name=="vamp"):
				global VLife
				o.Life=VLife
			WayCurrent=""
		darfuncs.BackPlayer()
		GenFX.PersonMagicallyAppearing()
		invincibleTime = 4
		if player.Data.Invincibility == 0:
			player.Data.Invincibility = 3
		Bladex.AddScheduledFunc(Bladex.GetTime()+invincibleTime, EndReSpawn,(), "EndReSpawn")
#######################################
def PlayerDied (entity):
	Bladex.KillMusic()
	ClearText()
	global deathCount
	global deadcheck
	deadcheck=deadcheck+1
	if deadcheck==1:
		deathCount=deathCount+1
	global SavePenalty
	global PlayerSkill
	skillCount=deathCount+SavePenalty
	if skillCount > len(PlayerSkill)-1:
		skillCount=len(PlayerSkill)-1
	player = Bladex.GetEntity("Player1")
	player.Wuea = Reference.WUEA_ENDED
	testpar=player.PartialLevel
	if player.ActiveEnemy:
		o=Bladex.GetEntity(player.ActiveEnemy)
		o.Life=CharStats.GetCharMaxLife(o.Kind, o.Level)
	global killcount
	darfuncs.StartMatrixFX(ESource = "Player1")
	ClearText()
	GameText.WriteTextAux(GetText("RANK:...."+str(PlayerSkill[skillCount])+"\n\nDEATHS:...................."+str(deathCount)+"\n\nKILLS..............."+str(killcount)+"\n\nSAVES..............."+str(SavePenalty)+"\n\nF7..............CONTINUE"+"\n\nESC............MAIN MENU"), 40.0, 255,170,10,0,200,[])

def SetupPlayerDeathFunc():
	player = Bladex.GetEntity("Player1")
	player.Data.OldImDeadFunc = player.ImDeadFunc
	player.ImDeadFunc = PlayerDied

SetupPlayerDeathFunc()
for func in acts.FuncList:
	Bladex.RemoveBoundFunc("Toggle Weapons",func)

def IsPlayerDead():
	return Bladex.GetEntity("Player1").Life <= 0

def FixToggleWeapons(EntityName):
	if (EntityName == "Player1") and (IsPlayerDead()):
		return
	Actions.StdToggleWeapons(EntityName)
Bladex.AddBoundFunc("Toggle Weapons", acts.DefArgWrapper("Player1", FixToggleWeapons))

OldTryDropRight = Actions.TryDropRight
def FixTryDropRight(EntityName):
	if (EntityName == "Player1") and (IsPlayerDead()):
		return
	OldTryDropRight(EntityName)
Actions.TryDropRight = FixTryDropRight

OldTryDropLeft = Actions.TryDropLeft
def FixTryDropLeft(EntityName):
	if (EntityName == "Player1") and (IsPlayerDead()):
		return
	OldTryDropLeft(EntityName)
Actions.TryDropLeft = FixTryDropLeft

OldStdThrowObject = Actions.StdThrowObject
def FixStdThrowObject(EntityName):
	if (EntityName == "Player1") and (IsPlayerDead()):
		return
	OldStdThrowObject(EntityName)
Actions.StdThrowObject = FixStdThrowObject
###############################################################################################
############################################################## FX #############################
def ShockBolt1(x1,y1,z1,x,y,z,max):
	r=220
	g=200
	b=200
	r2=250
	g2=120
	b2=20
	r1=0
	g1=0
	b1=0
	sound=Bladex.CreateSound("..\\..\\Sounds\\RAYOS-ELECTRICOS.wav", "EBoltSnd")
	sound.Volume=1
	sound.MinDistance=1000000.0
	sound.MaxDistance=1000000.0
	sound.Play(o.Position[0], o.Position[1], o.Position[2], 0)
	ray=Bladex.CreateEntity("Ray"+str(z)+str(x), "Entity ElectricBolt", x1, y1, z1)
	ray.Target           = x, y, z
	ray.MaxAmplitude     = max
	ray.MinSectorLength  = 100000
	ray.Active           = 1
	ray.Damage           = 0
######################################################################
def ShockBolt2(x1,y1,z1,x,y,z,max):
	sound=Bladex.CreateSound("..\\..\\Sounds\\RAYOS-ELECTRICOS.wav", "EBolt2Snd")
	sound.Volume=1
	sound.Play(o.Position[0], o.Position[1], o.Position[2], 0)
	ray2=Bladex.CreateEntity("Ray"+str(z)+str(x), "Entity ElectricBolt", x1, y1, z1)
	ray2.Target           = x, y, z
	ray2.MaxAmplitude     = max
	ray2.MinSectorLength  = 100000
	ray2.CoreGlowColor=240, 255, 240
	ray2.InnerGlowColor=10, 80, 10
#	ray2.OuterGlowColor=0.0, 0.0, 0.0
	ray2.Active           = 1
	ray2.Damage           = 0
def SwordAppearsFX(ob,effect,ran):
	t = Bladex.GetTime()
	sound=Bladex.CreateSound("..\\..\\Sounds\\fuego-boo.wav", "SndAppSwrd")
	sound.Volume=1
	sound.Play(-66500, 28800,-58000, 0)
	FireBall2 = Bladex.CreateEntity("App"+str(t), "Entity Particle System Dobj", 0,0,0)
	FireBall2.ObjectName=ob
	FireBall2.ParticleType   = effect
	FireBall2.YGravity       = -600 # -1000
	FireBall2.Friction       = 1
	FireBall2.PPS            = 1024 # 2024
	FireBall2.Velocity       = 0,0, 0 # 0,800,0
	FireBall2.Time2Live      = 20 # 30
	FireBall2.RandomVelocity = ran
	FireBall2.DeathTime=Bladex.GetTime()+3.0
def NewSwordFX(entity,tmf):
	time=Bladex.GetTime()
	aura=Auras.MakeAura("NewWeapon",tmf, (1, 0.01, 1.0, 0, 0, 1),(),(),(2,  0.8, 0.9, 1.0, 0.6, 0.3  ,  0.2, 0.6, 0.8, 0.4, 1.0))
	aura.Data.AddEvent(time+tmf/2,(30, 1.0, 1.0, 0, 0, 1),(),(),(2,  0.8, 0.9, 1.0, 0.6, 0.3  ,  0.2, 0.6, 0.8, 0.4, 1.0))
	aura.Data.AddEvent(time+tmf,(120, 0.01, 1.0, 0, 0, 1),(),(),(2,  0.2, 0.2, 0.6, 0.6, 0.4  ,  0.0, 0.0, 0.4, 0.4, 0.5))
def ChangeRasterMode2(ent_name, mode):
	Bladex.GetEntity(ent_name).RasterMode=mode
def EnemyMagicallyAppearing(enemy, xtm):
	TimeEffect=xtm
	time=Bladex.GetTime()
	char=Bladex.GetEntity(enemy)
#	char.Alpha=0.01
#	char.RasterMode="Read"
#	Bladex.AddScheduledFunc(time+TimeEffect, ChangeRasterMode2, (enemy, "Full"))
#	AuxFuncs.FadeObject(enemy, 0.01, 1.0, 2.0)
	AuraParams0=(240, 0.01, 1.0, 0, 1, 1)
	AuraParams1=(50 , 1.0 , 1.0, 0, 1, 1)
	AuraParams2=(50 , 0.01, 1.0, 0, 1, 1)
	AuraGradient0=(2,  0.4, 0.4, 1.0, 1.0, 0.2  ,  0.0, 0.3, 0.9, 0.0, 0.7)
	AuraGradient1=(2,  0.1, 0.2, 0.9, 1.0, 0.2  ,  0.6, 0.6, 0.9, 0.1, 1.0)
	aura=Auras.MakeAura(enemy, TimeEffect, AuraParams0, (), (), AuraGradient0)
	aura.Data.AddEvent (time+TimeEffect/2.0, AuraParams1, (), (), AuraGradient1)
	aura.Data.AddEvent (time+TimeEffect, AuraParams2, (), (), AuraGradient0)
	ps=Bladex.CreateEntity("PSEnemyMagicallyAppearing", "Entity Particle System Dperson", 0.0, 0.0, 0.0)
	ps.PersonName=enemy
	ps.ParticleType="FastEnergyConc"
	ps.PPS=400  #200
	ps.YGravity=-800     #0.0 # -300! #-800 !!
	ps.Friction=0.5 ############0.01
	ps.Velocity=0.0, 0.0, 0.0
	ps.RandomVelocity=0.5
	ps.NormalVelocity=-2.0
	ps.Time2Live=30     # 30
	ps.DeathTime=time+TimeEffect/2.0
###########################################
def Venomglow(enemy, xtm):
	time=Bladex.GetTime()
	TimeEffect=xtm
	AuraParams=(160, 1, 1, 0, 0, 0) #80
	AuraGradient=(2, 0.586, 0.735, 0.33, 0.2, 0.0, 0.73, 0.865, 0.214, 0.1, 0.5)
###################=(2, 0.2, 0.6, 0.2, 0.2, 0.0, 0.4, 0.8, 0.4, 0.1, 0.5)
	aura=Auras.MakeAura(enemy, TimeEffect, AuraParams, (), (), AuraGradient)
	pg=Bladex.CreateEntity("PSVenomglow"+str(xtm), "Entity Particle System Dperson", 0.0, 0.0, 0.0)
	pg.PersonName=enemy
	pg.ParticleType="GasVenenoso"
	pg.PPS=30
	pg.YGravity=-900 # 400 # 0
	pg.Friction=0.02
	pg.Velocity=0.0, 0.0, 0.0
	pg.RandomVelocity=1.0
	pg.NormalVelocity=0
	pg.Time2Live=60
	pg.DeathTime=time+TimeEffect/2.0

################################### Ven-Item ###################

def Venomglow2(enemy, xtm):
	time=Bladex.GetTime()
	TimeEffect=xtm
	pg2=Bladex.CreateEntity("PSVenomglow"+str(time), "Entity Particle System Dobj", 0.0, 0.0, 0.0)
	pg2.ObjectName=enemy
	pg2.ParticleType="GasVenenoso"
	pg2.PPS=30
	pg2.YGravity=-500 # 400 # 0
	pg2.Friction=0.02
	pg2.Velocity=0.0, 0.0, 0.0
	pg2.RandomVelocity=5.0
	pg2.NormalVelocity=0
	pg2.Time2Live=60
	pg2.DeathTime=time+TimeEffect

#####################################################

def DeathAppears(PersonName):
	time=Bladex.GetTime()
	aura=Auras.MakeAura(PersonName,0.8,   ( 50, 1.0 , 0.0, 0, 0, 0), (), (), (2,  0.9, 0.9, 0.0, 0.9, 0.0  ,  0.9, 0.9, 0.0, 0.9, 0.8))
	aura.Data.AddEvent(time+0.4,          (150, 0.5 , 0.0, 0, 0, 0), (), (), (2,  0.9, 0.9, 0.0, 0.9, 0.0  ,  0.9, 0.9, 0.0, 0.9, 0.8))
	aura.Data.AddEvent(time+0.8,          (200, 0.01, 0.0, 0, 0, 0), (), (), (2,  0.9, 0.9, 0.0, 0.9, 0.0  ,  0.9, 0.9, 0.0, 0.9, 0.8))

	wps=Bladex.CreateEntity(PersonName+"WPS", "Entity Particle System Dperson", 0.0, 0.0, 0.0)
	wps.PersonName=PersonName
	wps.ParticleType="DeathCloud"
	wps.Time2Live=32
	wps.RandomVelocity=2.0
	wps.Velocity=0,0,0
	wps.NormalVelocity=20
	wps.YGravity=0
	wps.DeathTime=Bladex.GetTime()+1.5
	wps.PPS=1024

###################################################

def SeePowup(entity,effect):
	esq = Bladex.GetEntity(entity)
	sound=Bladex.CreateSound("..\\..\\Sounds\\fuego-boo.wav", "SndFireball")
	sound.Volume=1
	sound.Play(esq.Position[0], esq.Position[1], esq.Position[2], 0)
	FireBall = Bladex.CreateEntity("Flash"+str(entity), "Entity Particle System D1", esq.Position[0],esq.Position[1],esq.Position[2])
	FireBall.ParticleType   = effect
	FireBall.YGravity       = -1000 # -1000
	FireBall.Friction       = 0
	FireBall.PPS            = 1024 # 2024
	FireBall.Velocity       = 0,800, 0 # 0,800,0
	FireBall.Time2Live      = 30 # 30
	FireBall.RandomVelocity = 35
	FireBall.DeathTime=Bladex.GetTime()+0.8

#####################################################

############################################################################
################################# Set WayPoints ############################
############################################################################

def Saved():
	char=Bladex.GetEntity("Player1")
	global WayPointLevel
	global WayPointPartialLevel
	global WayPointLife
	global WayPointPoison
	WayPointLevel=char.Level
	WayPointPartialLevel=char.PartialLevel
	WayPointLife=char.Life
	WayPointPoison = char.Data.Poisoned
	ClearText()
	GameText.WriteTextAux(GetText("Game Saved"), 3.0, 255,255,255,0,30,[])

def WSaved():
	char=Bladex.GetEntity("Player1")
	global WayPointLevel
	global WayPointPartialLevel
	global WayPointLife
	WayPointLevel=char.Level
	WayPointPartialLevel=char.PartialLevel
	char.Life=CharStats.GetCharMaxLife(char.Kind, char.Level)
	WayPointLife=char.Life
	Powerup("Player1")
	pos=char.Position
	sound=Bladex.CreateSound("..\\..\\Sounds\\sesgado-especial-largo2.wav", "SndWaypoint")
	sound.Volume=1
	sound.Play(pos[0], pos[1], pos[2], 0)
	ClearText()
	GameText.WriteTextAux(GetText("Waypoint Saved"), 3.0, 180,200,255,0,30,[])


######################
def SetWayCustom():
	char=Bladex.GetEntity("Player1")
	health=CharStats.GetCharMaxLife(char.Kind, char.Level)
	if char.Life >= health/4:
	    global MaxSaves
	    global SavePenalty
	    if SavePenalty < MaxSaves:
		global WayPoint
		global WayPointAngle
		global WayPointLevel
		global WayPointPartialLevel
		global WayPointLife
		pos=char.Position
		WayPoint=pos[0],pos[1]-1500,pos[2]
		WayPointAngle=char.Angle
		SavePenalty=SavePenalty+1
		WayPointLevel=char.Level
		WayPointPartialLevel=char.PartialLevel
		WayPointLife=char.Life
		ClearText()
		GameText.WriteTextAux(GetText(str(MaxSaves-SavePenalty)+" Saves Left"), 3.0, 255,255,255,0,30,[])
	    else:
		ClearText()
		GameText.WriteTextAux(GetText("No Saves Left!"), 3.0, 255,255,255,0,30,[])
	else:
		ClearText()
		GameText.WriteTextAux(GetText("Too weak to Save"), 3.0, 255,155,155,0,30,[])
		
############################### Save Keys
o=Bladex.CreateEntity("way01","Varita1",-13000,3000,6000,"Physic")
o.Scale=0.5
o.Static=1
o.SelfIlum=0.1
o.Orientation=0.7,0.7,0,0
dinobj = Objects.CreateDinamicObject(o.Name)
Objects.RotateObject(dinobj, 3.14159*500000, 2, 1, (0, 1, 0), (1, 0, 0), Objects.REL, "", "", "","",(),"",())



o=Bladex.CreateEntity("way1","LlaveAmarilla_Aura",-16250,22500,-49250,"Physic")
o.Scale=2
o.Static=1
o.SelfIlum=0.1
o.Orientation=0.5,0.5,-0.5,-0.5
dinobj = Objects.CreateDinamicObject(o.Name)
Objects.RotateObject(dinobj, 3.14159*500000, 2, 1, (0, 1, 0), (1, 0, 0), Objects.REL, "", "", "","",(),"",())


o=Bladex.CreateEntity("way2","LlaveAzul",7500, 38500, 2500,"Physic")
o.Scale=3
o.Static=1
o.SelfIlum=0.1
o.Orientation=0.5,0.5,-0.5,-0.5
dinobj = Objects.CreateDinamicObject(o.Name)
Objects.RotateObject(dinobj, 3.14159*500000, 2, 1, (0, 1, 0), (1, 0, 0), Objects.REL, "", "", "","",(),"",())

o=Bladex.CreateEntity("way3","LlaveNegra",33000,38000,-2500,"Physic")
o.Scale=2
o.Static=1
o.SelfIlum=0.1
o.Orientation=0.5,0.5,-0.5,-0.5
dinobj = Objects.CreateDinamicObject(o.Name)
Objects.RotateObject(dinobj, 3.14159*500000, 2, 1, (0, 1, 0), (1, 0, 0), Objects.REL, "", "", "","",(),"",())

o=Bladex.CreateEntity("way4","LlaveBlanca",61000,38500,-24000,"Physic")
o.Scale=2
o.Static=1
o.SelfIlum=0.8
o.Orientation=0.5,0.5,-0.5,-0.5
dinobj = Objects.CreateDinamicObject(o.Name)
Objects.RotateObject(dinobj, 3.14159*500000, 2, 1, (0, 1, 0), (1, 0, 0), Objects.REL, "", "", "","",(),"",())

o=Bladex.CreateEntity("way5","Varita5",88000,38500,-60250,"Physic")
o.Scale=1
o.Static=1
o.SelfIlum=0.1
o.Orientation=0.7,0.7,0,0
dinobj = Objects.CreateDinamicObject(o.Name)
Objects.RotateObject(dinobj, 3.14159*500000, 2, 1, (0, 1, 0), (0, 0, 1), Objects.REL, "", "", "","",(),"",())

o=Bladex.CreateEntity("way6","Corona",148000,38000,-60000,"Physic")
o.Scale=2
o.Static=1
o.SelfIlum=0.3
o.Orientation=0.7,0.7,0,0
dinobj = Objects.CreateDinamicObject(o.Name)
Objects.RotateObject(dinobj, 3.14159*500000, 2, 1, (0, 1, 0), (0, 0, 1), Objects.REL, "", "", "","",(),"",())

#################################################
def waydissap(entity):
	o=Bladex.GetEntity(entity)	
	SwordAppearsFX(o.Name,"EnergyDissip",20)
	o.Alpha=0
#######################
def SetWay0():
	global WayPoint
	global WayPointAngle
	WayPoint=-13000, 4800, 6000
	WayPointAngle=2
	waydissap("way01")
	char=Bladex.GetEntity("Player1")
	if (char.Level < 9):
	    char.Level = 9
	    char.PartialLevel=0
	    Scorer.SetLevelBarValue(0)
	WSaved()
################################################
def SetWay1():
	global WayPoint
	global WayPointAngle
	WayPoint=-17000, 22500, -50000
	WayPointAngle=2
	waydissap("way1")
	char=Bladex.GetEntity("Player1")
	if (char.Level < 11):
	    char.Level = 11
	    char.PartialLevel=0
	    Scorer.SetLevelBarValue(0)
	WSaved()
darfuncs.EnterSecEvent(-17000,24000,-50000, SetWay1)
######################
def SetWay2():
	global WayPoint
	global WayPointAngle
	WayPoint=7500, 38500, 2500
	WayPointAngle=3.5
	waydissap("way2")
	char=Bladex.GetEntity("Player1")
	if (char.Level < 13):
	    char.Level = 13
	    char.PartialLevel=0
	    Scorer.SetLevelBarValue(0)
	WSaved()
darfuncs.EnterSecEvent(7500, 38500, 2500, SetWay2)
#######################
def SetWay3():
	global WayPoint
	global WayPointAngle
	WayPoint=33000,38000,-2500
	WayPointAngle=6
	waydissap("way3")
	char=Bladex.GetEntity("Player1")
	if (char.Level < 15):
	    char.Level = 15
	    char.PartialLevel=0
	    Scorer.SetLevelBarValue(0)
	WSaved()
darfuncs.EnterSecEvent(33000,38000,-2500, SetWay3)
#######################
def SetWay4():
	global WayPoint
	global WayPointAngle
	WayPoint=61000, 38500, -62500
	WayPointAngle=2
	waydissap("way4")
	char=Bladex.GetEntity("Player1")
#	if (char.Level < 17):
#	    char.Level = 17
#	    char.PartialLevel=0
#	    Scorer.SetLevelBarValue(0)

	WSaved()
darfuncs.EnterSecEvent(61000, 38500, -22000, SetWay4)
#######################
def SetWay5():
	global WayPoint
	global WayPointAngle
	WayPoint=88500, 38500, -60500
	WayPointAngle=4
	waydissap("way5")
	WSaved()
darfuncs.EnterSecEvent(88000, 38500, -60000, SetWay5)
#######################
def SetWay6():
	global WayPoint
	global WayPointAngle
	WayPoint=148000, 38500, -60000
	WayPointAngle=0
	waydissap("way6")
	WSaved()
darfuncs.EnterSecEvent(148000, 38500, -60000, SetWay6)
#######################
def SetWay7():
	global WayPoint
	global WayPointAngle
	WayPoint=232000, 44500, -60000
	WayPointAngle=0
	WSaved()

############################# Cnoc Mr #################################
def unhideindork():
	darfuncs.UnhideBadGuy("indork")
	darfuncs.UnhideBadGuy("indork2")

def Indiana():
	o=Bladex.GetEntity("Boulder")
	o.Impulse(0,0,0)
	indy=Bladex.CreateSound("..\\..\\Sounds\\Stone-floor-collapse.wav", "Startindy")
	indy.Volume=1
	indy.MinDistance=12000
	indy.MaxDistance=60000
	indy.Play(o.Position[0], o.Position[1], o.Position[2], 0)
	unhideindork()
p=8000,1000,-12500
r=0.707107,0.707107,0.000000,0.000000
o=heavyObjects.CreateHeavyObject("Boulder","BoladePiedra",p,r,1.0, heavyObjects.StoneHitEvent )
o.Scale=0.95
o.Static=0
stone.lock( o.Name, stone.DROPDARKDUST, 0, 1100, 0.0, 0.6, 20.0, stone.STONESOUND, 1 ) 

darfuncs.EnterSecEvent(32000, 17800, -29500, Indiana)
darfuncs.EnterSecEvent(8000, 6500, -22000, Indiana)

##############################################################################

#####################################
##################################### AREA TEXT DESCRIPTIONS/TRIGGERS
#####################################

def SerpentsLair():
	char=Bladex.GetEntity("Player1")
	RewardText=""
	if (char.Level < 17):
	    char.Level = 17
	    char.PartialLevel=0
	    Scorer.SetLevelBarValue(0)
	    RewardText="\nLEVEL 18\nThe Gods reward your Efforts"
	    Powerup("Player1")
	GameText.WriteTextAux(GetText("Secret Entrance to the Chaos Vaults..\n"+str(RewardText)), 10.0, 150,10,10, 0,260,[])

def UpperForge():
	GameText.WriteTextAux(GetText("The Sulphur Pits..."), 5.0, 185,140,20, 0,300,[])

def EnterMaze():
	GameText.WriteTextAux(GetText("The Evil Place...\nTomb of the living dead"), 4.0, 160,10,10,0,300,[])
############## Triggers

darfuncs.EnterSecEvent(1500, 10500, -24000, UpperForge)
darfuncs.EnterSecEvent(38500, 38500, -1500, EnterMaze)
darfuncs.EnterSecEvent(61000, 38000, -10000, SerpentsLair)

#####################

com1 = ""
com2 = ""
com3 = ""
com4 = ""
com5 = ""
com6 = ""
com7 = ""
com8 = ""
com9 = ""
com10 = ""
comb1 = "No combos available yet\n"
comb2 = ""
comb3 = ""
comb4 = ""
comb5 = ""
comb6 = ""
comb7 = ""
comb8 = ""
comb9 = ""
comb10 = ""
midbar = "==============================================\n"
powerup1 = ""
powerup2 = ""
powerup3 = ""
powerup4 = ""
powerup5 = ""
powerup6 = ""
pupvenom = 0
puplight = 0
pupfire = 0
pupdrain = 0
pupice = 0
pupelec = 0
combmenu = 0
combshow = 0
############################ Screen Text

BLFontSmall="../../BODLoader/Letras BODLoader peq.bmp"
BLFontMed="../../BODLoader/Letras BODLoader med.bmp"
BLFontBig="../../BODLoader/Letras BODLoader gra.bmp"
def InitCombos():
	global com1
	global com2
	global com3
	global com4
	global com5
	global com6
	global com7
	global com8
	global com9
	global com10
	global PlayerType
	if PlayerType == "Knight":
		com1 = "Swing of Pride              Att  +  Left-Up\n"
		com2 = "Righteous Anger             Att-Left  +  Up\n"
		com3 = "The Dream                   Att  +  Up-Right\n"
		com4 = "Hook Sweep                  Att-Up  +  Down\n"
		com5 = "Soul of Honour              Att-Right  +  Left\n"
		com6 = "Vampire Attack              Att-Left  +  Down-Right\n"
		com7 = "Triple Attack               Att  +  Up-Down  +  Up\n"
		com8 = "Wrath of the Gods           Att-Right  +  Att-Right  +  Left\n"
		com9 = "Sword of Justice            Att  +  Left-Down\n"
		com10 = "Majestic Sweep              Att-Up  +  Left-Right\n"
	elif PlayerType == "Barbarian":
		com1 = "Speed Kill                  Att-Up  +  Down\n"
		com2 = ""
		com3 = "Death Sweep                 Att-Up  +  Up-Down\n"
		com4 = ""
		com5 = "Hell Swing                  Att-Left  +  Right\n"
		com6 = ""
		com7 = "Blind Rage                  Att-Left  +  Up-Right\n"
		com8 = "Destroyer                   Att  +  Left-Right\n"
		com9 = "Spike of Evil               Att-Left  +  Att-Left\n"
		com10 = "Overkill                    Att-Right  +  Down-Left\n"
	elif PlayerType == "Dwarf":
		com1 = "Morning Star                Att-Up  +  Down\n"
		com2 = ""
		com3 = "Slash Back                  Att-Right  +  Left\n"
		com4 = "Bone Breaker                Att  +  Down\n"
		com5 = "Earthquake                  Att-Down  +  Down\n"
		com6 = "Vampire Attack              Att-Left  +  Down-Right\n"
		com7 = "Brutality                   Att-Up  +  Up\n"
		com8 = "Eagles Eye                  Att  +  Up\n"
		com9 = "Liberator                   Att-Left  +  Right\n"
		com10 = "Demolition                 Att-Up  +  Down-Right\n"
	else:
		com1 = "Killer Strike               Att-Right  +  Left\n"
		com2 = ""
		com3 = "Sea Smash                   Att  +  Left-Down\n"
		com4 = "Nightmare                   Att-Up  +  Up-Right\n"
		com5 = "Dark Star                   Att-Left  +  Down\n"
		com6 = "Vampire Attack              Att-Left  +  Down-Right\n"
		com7 = "Lightning Cut               Att  +  Down-Right\n"
		com8 = "Tumble Kill                 Att-Right  +  Left-Right\nDeadly Mist                 Att-Up  +  Att-Up\n"
		com9 = "Gut Wrencher                Att  +  Up-Down\n"
		com10 = "Spiral of Death            Att  +  Left-Right  +  Up-Down\n"


InitCombos()

def ShowInventory():
	global comb1
	global comb2
	global comb3
	global comb4
	global comb5
	global comb6
	global comb7
	global comb8
	global comb9
	global comb10
	global com1
	global com2
	global com3
	global com4
	global com5
	global com6
	global com7
	global com8
	global com9
	global com10
	global powerup1
	global powerup2
	global powerup3
	global powerup4
	global powerup5
	global powerup6
	global pupvenom
	global puplight
	global pupfire
	global pupdrain
	global pupice
	global pupelec
	global combmenu
	global combshow
	if (combshow == 0):
	  if (combmenu == 1):
	    char=Bladex.GetEntity("Player1")
	    if (char.Level > 9):
		comb1 = com1
		comb2 = com2
		comb3 = com3
	    if (char.Level > 10):
		comb4 = com4
	    if (char.Level > 11):
		comb5 = com5
	    if (char.Level > 12):
		comb6 = com6
	    if (char.Level > 13):
		comb7 = com7
	    if (char.Level > 15):
		comb8 = com8
	    if (char.Level > 16):
		comb9 = com9
	    if (char.Level > 17):
		comb10 = com10
	    if (pupvenom == 1):
		powerup1 = "Lethal Injection\n"
	    if (pupfire == 1):
		powerup2 = "Soul Burner\n"
	    if (puplight == 1):
		powerup3 = "Spine Freezer\n"
	    if (pupdrain == 1):
		powerup4 = "Life Extractor\n"
	    if (pupice == 1):
		powerup5 = "White Lightning\n"
	    if (pupelec == 1):
		powerup6 = "Electrocution\n"
	    if (pupvenom+puplight+pupfire+pupdrain+pupice+pupelec == 0):
		powerup1 = "0/6\n"
	    ClearText()	
	    combshow = 1
	    GameText.WriteTextAux(GetText("- Knightshade Combos -\n"+str(comb1)+str(comb2)+str(comb3)+str(comb4)+str(comb5)+str(comb6)+str(comb7)+str(comb8)+str(comb9)+str(comb10)+str(midbar)+"- Knightshade Power Ups -\n" + str(powerup1) + str(powerup2) + str(powerup3) + str(powerup4) + str(powerup5) + str(powerup6)), 300, 255,150,10, 0, 160, [])
	  else:
	    ClearText()
	    GameText.WriteTextAux(GetText("You must find Knightshade!"),5.0,255,150,20,0,260,[])
	else:
		combshow = 0
		ClearText()

##################### Player Input ##################

def ShowVersion ():
	GameText.WriteTextAux(GetText("Conquest Version 1.1\n"+"by Sir Random 2001\n"+"random(a)eircom.net"),5.0,255,150,20,0,20,[])

###################################
###################################
########## Stats
def ConquestStats():
	global ShowCStats
	if ShowCStats==0:
		ShowCStats=1
		global deathCount
		global killcount
		global SavePenalty
		global PlayerSkill
		SkillLevel=SavePenalty+deathCount
		if SkillLevel > len(PlayerSkill)-1:
			SkillLevel=len(PlayerSkill)-1
		global pupvenom
		global pupfire
		global pupdrain
		global puplight
		global pupice
		global pupelec
		Showpups=""
		if (pupvenom+pupfire+pupdrain+puplight+pupice+pupelec==0):
			Showpups="\nNo Power-Ups found"
		if pupvenom==1: 
			Showpups=Showpups+"\nLethal Injection"
		if pupfire==1: 
			Showpups=Showpups+"\nSoul Burner"
		if pupdrain==1: 
			Showpups=Showpups+"\nLife Extractor"
		if puplight==1: 
			Showpups=Showpups+"\nSpine Freezer"
		if pupice==1: 
			Showpups=Showpups+"\nWhite Lightning"
		if pupelec==1: 
			Showpups=Showpups+"\nElectrocution"

		ClearText()
		GameText.WriteTextAux(GetText("***** GAME STATS *****\n\nRANK:  "+str(PlayerSkill[SkillLevel])+"\nKILLS:  "+str(killcount)+"\nDEATHS:  "+str(deathCount)+"\nSAVES:  "+str(SavePenalty)+"\n\n***** POWER UPS *****\n"+str(Showpups)), 300, 250,150,10,0,200,[])
	else:
		ShowCStats=0
		ClearText()		
#######################################################
################# Key Associations ####################

Bladex.AddInputAction("ShowVersion", 0)
Bladex.AddBoundFunc("ShowVersion", ShowVersion)
Bladex.AssocKey("ShowVersion", "Keyboard", "V", 1)

Bladex.AddInputAction("ShowInventory", 0)
Bladex.AddBoundFunc("ShowInventory", ShowInventory)
Bladex.AssocKey("ShowInventory", "Keyboard", "F3", 1)

Bladex.AddInputAction("SetWayCustom", 0)
Bladex.AddBoundFunc("SetWayCustom", SetWayCustom)
Bladex.AssocKey("SetWayCustom", "Keyboard", "F4", 1)

Bladex.AddInputAction("ReSpawn", 0)
Bladex.AddBoundFunc("ReSpawn", ReSpawn)
Bladex.AssocKey("ReSpawn", "Keyboard", "F7", 1)

Bladex.AddInputAction("ConquestStats", 0)
Bladex.AddBoundFunc("ConquestStats", ConquestStats)
Bladex.AssocKey("ConquestStats", "Keyboard", "F8", 1)


#####################################################################
################################# BIG SKULL #########################
#vueltas-en-el-aire
#sesgado-especial-largo.wav
#CORO6.mp3
#trueno5.wav
#golpe-metal-mediano.wav
###################################################################
################################### Find Sword FX #################
o=Bladex.CreateEntity("BigSkull","Varita6", -66500, 34500, -48500,"Physic")#26800
o.Scale=34
o.Alpha=0
o.SelfIlum=0
o.Orientation=0.7,0.7,0,0


o=Bladex.CreateEntity("Orbstand","SoporteOrbe",-66500, 29800,-58000,"Physic")
o.Scale=1.5
o.Static=1
Sparks.SetStoneSparkling(o.Name)
o.Orientation=0.707107,0.707107,0.000000,0.000000
###################################################################
################################## sWORD #######################
def SkullRotateFunc(entity):
	obj = Bladex.GetEntity(entity)
	if obj.Parent != None:
		dinobj = obj.Data.dinobjdata
		dinobj.OnMovement = 0
		dinobj.OnRotation = 0

#############################

def WeapEndRotateFunc(entity):
	aura = Auras.MakeAura("NewWeapon",100000.0,(20,1.0,1.0,1,0,0), (),(),(2,  0.4,0.4,0.9, 0.6, 0.6  , 0.1,0.1,0.6, 0.3, 1.0))
	GameText.WriteTextAux(GetText("Press F3 to toggle combo menu"), 4.0, 255,255,255, 0, 360, [])
####################
def WeaponEndRotateFunc(entity):
	darfuncs.BackPlayer()
	Bladex.ActivateInput() ###### Movie Ends...
	NewSwordFX("NewWeapon",1.8)
	o = Bladex.GetEntity("NewWeapon")
	sound=Bladex.CreateSound("..\\..\\Sounds\\RAYOS-ELECTRICOS.wav", "SndSwrdR")
	sound.Volume=1
	sound.Play(o.Position[0], o.Position[1], o.Position[2], 0)
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.RotateObject(dinobj, 3.14159*8, 30, 1, (0, 1, 0), (0, 0, 1), Objects.REL, "", "", "", SkullRotateFunc, (o.Name,), WeapEndRotateFunc, (o.Name,))
###############################
Character="Sarg"

def AppSwordFunc():
	ShockBolt2(-66500, 25500, -48500, -66500, 29800,-58000, 800)
	aura = Auras.MakeAura("Orbstand",60000.0,(15,1.0,1.0,0,0,1), (),(),(2,  0.4,0.9,0.4, 0.4, 0.2  , 0.1,0.6,0.1, 0.5, 0.6))
	o=Bladex.CreateEntity("NewWeapon",DKType,-66500, 30000,-58000,"Weapon")
	o.Scale=1.0
	o.Orientation=0.7,0.7,0,0
	global Character
	o.SelfIlum=5
	ItemTypes.ItemDefaultFuncs (o)
	luz2=Bladex.CreateEntity("Luzblu","Entity Spot",-66500, 29500,-58000)
	luz2.Color=150,150,200
	luz2.Intensity=1
	luz2.Precission=0.125
	luz2.CastShadows=0
	luz2.Visible=0
	luz2.Flick=0   
	luz2.SizeFactor = 0.2
	luz2.AngVel=0.1
	luz2.GlowTexture="SunFlare"
	o.Link(luz2)
	if Character=="Dwarf_N":
		o=Bladex.GetEntity("NewWeapon")
		o.Scale=1.3
		o.Orientation=0.5,0.5,-0.5,-0.5
	SwordAppearsFX("NewWeapon","FastEnergyConc",20)
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj, (-66500, 30000,-58000), (-66500, 28500,-58000), 1000, 100, "", "", "",  SkullRotateFunc, (o.Name,), WeaponEndRotateFunc, (o.Name,)) 

def SkullEndRotateFunc(entity):
	o=Bladex.CreateEntity("BskullOrb","Orbe", -66500, 25500, -48500,"Physic")
	o.Static=1
	o.Scale=1
	o.SelfIlum=0
	ItemTypes.ItemDefaultFuncs (o)
	Actions.TurnToFaceEntity("Player1", "BskullOrb")
	SeePowup("BskullOrb","LargeFire")
	Bladex.AddScheduledFunc(Bladex.GetTime()+2, AppSwordFunc, (),"Appswrd")



def SeeSkull():
	global combmenu
	combmenu = 1
#	darfuncs.ChangePointOfView(-72000,26500,-48000,1,"Player1")
	darfuncs.ChangePointOfView(-68000,28300,-62500,5,"Player1")
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime()+1, Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("SkullTurn"),))
	o=Bladex.GetEntity("BigSkull")
	o.Alpha=1
	o.SelfIlum=1
	Actions.TurnToFaceEntity("Player1", "BigSkull")
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.RotateObject(dinobj, 3.14159*20, 20, 1, (0, 0, 0), (0, 0, 1), Objects.REL, "", "", "", SkullRotateFunc, ("BigSkull",), SkullEndRotateFunc, ("BigSkull",))

darfuncs.EnterSecEvent(-67000,29800,-63000, SeeSkull)

def SwordMovie():
	Bladex.DeactivateInput() ###### Player watch movie
	pers=Bladex.GetEntity("Player1")
	pers.GoToJogging = 0
	pers.GoTo(-68000,28500,-60000)
	Actions.TurnToFaceEntity("Player1", "BigSkull")

darfuncs.EnterSecEvent(-67000,29500,-68000, SwordMovie)

################################### drag #######################


#o=Bladex.CreateEntity("Dragfly","Dragon_estatua",187000, 7000, -60000,"Physic")
#o.Scale=1
#o.Alpha=1
#o.SelfIlum=0.1
#o.Orientation=-0.5,-0.5,-0.5,0.5

#def EndDragFly(entity):
#	o=Bladex.GetEntity("Dragfly")
#	o.Alpha=0
#def Dragoff():
#	o=Bladex.GetEntity("Dragfly")
#	dinobj = Objects.CreateDinamicObject(o.Name)
#	Objects.DisplaceObjectFromTo(dinobj, (157000, 20000, -60000), (1000, -36000, 30000), 1000, 8000, "", "", "","", (), "", ())

#def Dragup():
#	o=Bladex.GetEntity("Dragfly")
#	dinobj = Objects.CreateDinamicObject(o.Name)
#	Objects.DisplaceObjectFromTo(dinobj, (157000, 36000, -60000), (157000, 20000, -60000), 1000, 8000, "", "", "","", (), #Dragoff, ())


#def Drag1():
#	o=Bladex.GetEntity("Dragfly")
#	sound=Bladex.CreateSound("..\\..\\Sounds\\trueno5.wav", "SndDragFlyBy")
#	sound.Volume=1
#	sound.Play(148000,38800,-57000, 0)
#	o.Link(sound)
#	Actions.TurnToFaceEntity("Player1", "Dragfly")
#	dinobj = Objects.CreateDinamicObject(o.Name)
#	Objects.DisplaceObjectFromTo(dinobj, (187000, 7000, -60000), (157000, 36000, -60000), 1000, 8000, "", "", "","", (), #Dragup, ()) 

#darfuncs.EnterSecEvent(148000,34800,-62000, Drag1)






################################################################


def AddLightToShade():
	global puplight
	global DKType
	puplight=1
	Reference.DefaultObjectData[DKType].append(["Light", +50.0])
	SeePowup("Powerup4","LargeFire")
	GameText.WriteTextAux(GetText("******** Spine Freezer ********\nPower-Up"), 5.0, 155,155,255,0,260,[])
darfuncs.EnterSecEvent(61500, 35600, -84000, AddLightToShade)

def AddFireToShade():
	global pupfire
	global DKType
	pupfire=1
	Reference.DefaultObjectData[DKType].append(['Fire', +100.0])
	SeePowup("Powerup2","LargeFire")
	GameText.WriteTextAux(GetText("******** Soul Burner ********\nPower-Up"), 5.0, 255,155,20,0,260,[])
darfuncs.EnterSecEvent(44500,39700,-16000, AddFireToShade)
#################

def AddVenomToShade():
	global pupvenom
	global DKType
	pupvenom=1
	Reference.DefaultObjectData[DKType].append(["Venom", +50.0])
	SeePowup("Powerup1","LargeFire")
	GameText.WriteTextAux(GetText("******** Lethal Injection ********\nPower-Up"), 5.0, 100,200,100,0,260,[])
darfuncs.EnterSecEvent(-110500, 38600, 38000, AddVenomToShade)
###########################
def AddDrainToShade():
	global pupdrain
	global DKType
	pupdrain=1
	Reference.DefaultObjectData[DKType].append(["Drain", +20])
	SeePowup("Powerup3","LargeFire")
	GameText.WriteTextAux(GetText("******** Life Extractor ********\nPower-Up"), 5.0, 200,10,10,0,260,[])
darfuncs.EnterSecEvent(141000,35200,81000, AddDrainToShade)

def AddIceToShade():
	global pupice
	global DKType
	pupice=1
	Reference.DefaultObjectData[DKType].append(["Ice", +50.0])
	SeePowup("Powerup5","LargeFire")
	GameText.WriteTextAux(GetText("******** White Lightning ********\nPower-Up"), 5.0, 200,200,255,0,260,[])
darfuncs.EnterSecEvent(134500,38200,-81500, AddIceToShade)

def AddElectricToShade():
	global pupelec
	global DKType
	pupelec=1
	Reference.DefaultObjectData[DKType].append(['Electric', +150.0])
	SeePowup("Powerup6","LargeFire")
	GameText.WriteTextAux(GetText("********* Electrocution *********"), 5.0, 0,0,255,0,260,[])
darfuncs.EnterSecEvent(128000, 38600, -35000, AddElectricToShade)


########################################### Enemy2.py
import EnmGenRnd



##########################################
############################## Spectres ###################
def VanishIt(entity):
	char=Bladex.GetEntity(entity)
	char.Alpha=0
	Spectre2()
def VanishIt2(entity):
	char=Bladex.GetEntity(entity)
	char.Alpha=0

o=Bladex.CreateEntity("Spect1","Espectro",-66500, 25500, -48500,"Physic")
o.Scale=3.5
o.Alpha=0.2
o.SelfIlum=0.8
o.Orientation=0.495618,0.504344,-0.495618,0.504344
ItemTypes.ItemDefaultFuncs (o)
o=Bladex.CreateEntity("Spect2","Espectro",-66500, 25500, -46500,"Physic")
o.Scale=3.5
o.Alpha=0.4
o.SelfIlum=0.8
o.Orientation=0.495618,0.504344,-0.495618,0.504344
ItemTypes.ItemDefaultFuncs (o)

def Spectre():
	o=Bladex.GetEntity("Spect1")
	p=Bladex.GetEntity("Player1")
	sound=Bladex.CreateSound("..\\..\\Sounds\\Demon-spirit3.wav", "SndSpec")
	sound.Volume=1
	sound.MinDistance=1000000.0
	sound.MaxDistance=1000000.0
	sound.Play(o.Position[0], o.Position[1], o.Position[2], 0)
	dinobj2 = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj2, (-68500, 34500, -70000), (p.Position[0], p.Position[1]+3000, p.Position[2]-1000), 2000, 8000, "", "", "", Venomglow2, (o.Name,500), VanishIt, (o.Name,)) 
def Spectre2():
	Venomglow2("Spect2",4)
	o=Bladex.GetEntity("Spect2")
	q=Bladex.GetEntity("Player1")
	sound=Bladex.CreateSound("..\\..\\Sounds\\Demon-spirit5.wav", "SndSpec2")
	sound.Volume=1
	sound.MinDistance=1000000.0
	sound.MaxDistance=1000000.0
	sound.Play(o.Position[0], o.Position[1], o.Position[2], 0)
	dinobj2 = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj2, (-70000, 33000, -70000), (q.Position[0], q.Position[1]+3200, q.Position[2]-2000), 2000, 8000, "", "", "", Venomglow2, (o.Name,5), VanishIt2, (o.Name,)) 

darfuncs.EnterSecEvent(-56000, 29800, -74000, Spectre)



############################################################
############# Acid Golem #############################
def unhideaglm():
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("Darks"),))
	darfuncs.UnhideBadGuy("AcidG1")
	Venomglow("AcidG1",1000)
	Actions.TurnToFaceEntity("Player1", "AcidG1")
	EnemyMagicallyAppearing("AcidG1",12)

pers=Bladex.CreateEntity("AcidG1","Golem_lava",-82500, 42200, -3000,"Person")
pers.Angle=3
pers.Level=15
pers.Alpha=1
pers.SelfIlum=8
pers.SetOnFloor()
EnemyTypes.EnemyDefaultFuncs(pers)
darfuncs.HideBadGuy("AcidG1")
darfuncs.EnterSecEvent(-66000, 39800, -16000, unhideaglm)
###############################################################



###################### Acid Spiders

def unhidespiders():
	for arachnid in range (6):
		darfuncs.UnhideBadGuy("spider" +str(arachnid))
		Venomglow("spider"+str(arachnid),20000)
sidestep = 500
sgap = 2000
for arachnid in range (6):
	pers=Bladex.CreateEntity("spider" +str(arachnid),"Spidersmall", -110500+sgap, 39800, 20000+arachnid*500,"Person")
	pers.Angle=3
	pers.Level=17
	pers.Blind       = 1
	pers.Deaf        = 1
	EnemyTypes.EnemyDefaultFuncs(pers)
	pers.SetOnFloor()
	darfuncs.HideBadGuy(pers.Name)
	sgap = sgap * -1

darfuncs.EnterSecEvent(-102000, 38800, 8000, unhidespiders)


###############################################

################ Demons, Salamanders & Vamp

###############################################

############# Little Demons ###########
def unhideldms():
	darfuncs.UnhideBadGuy("ldm1")
	darfuncs.UnhideBadGuy("ldm2")

pers=Bladex.CreateEntity("ldm1","Little_Demon",137000, 34000, 66000,"Person")
pers.Angle=3
pers.Level=15
pers.SetOnFloor()
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetActiveEnemy("Player1")
darfuncs.HideBadGuy("ldm1")
#####################################
pers=Bladex.CreateEntity("ldm2","Little_Demon",145000, 34000, 66000,"Person")
pers.Angle=3
pers.Level=15
pers.SetOnFloor()
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetActiveEnemy("Player1")
darfuncs.HideBadGuy("ldm2")
darfuncs.EnterSecEvent(125000, 35500, 46000, unhideldms)
####################################
bigdmdone=0
def unhidebigdms():
	global bigdmdone
	if bigdmdone==0:
		bigdmdone=1
		darfuncs.UnhideBadGuy("bigdm2")
		darfuncs.UnhideBadGuy("bigdm4")

pers=Bladex.CreateEntity("bigdm2","Salamander",57000, 35000, -6000,"Person")
pers.Angle=4
pers.Level=15
pers.SetOnFloor()
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetActiveEnemy("Player1")
darfuncs.HideBadGuy("bigdm2")
#####################################
pers=Bladex.CreateEntity("bigdm4","Salamander",71000, 35000, -6000,"Person")
pers.Angle=4
pers.Level=15
pers.SetOnFloor()
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetActiveEnemy("Player1")
darfuncs.HideBadGuy("bigdm4")
darfuncs.EnterSecEvent(60000, 35000, 2000, unhidebigdms)
darfuncs.EnterSecEvent(70000, 35000, 2000, unhidebigdms)
darfuncs.EnterSecEvent(80000, 35000, -2000, unhidebigdms)
##########################
######### vamp boss & knights

def OutMusic():
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("FinEnter"),))

def RestoreCam():
	darfuncs.StopMatrixFX()
	darfuncs.BackPlayer()

def VampIsDead(entity):
	darfuncs.StartMatrixFX(ESource = "vamp")
	Bladex.AddScheduledFunc(Bladex.GetTime()+2, RestoreCam,())
	Bladex.AddScheduledFunc(Bladex.GetTime()+2.1,Abredoor5,())
	Bladex.AddScheduledFunc(Bladex.GetTime()+6,OutMusic,())

def DeadVampFunc(entity):
	VampIsDead(entity)


def unhidevamp():
	darfuncs.UnhideBadGuy("vamp")
	EnemyMagicallyAppearing("vamp",5)
	aura = Auras.MakeAura("vamp",5568.0,(5,1.0,1.0,1,0,0), (),(),(2,  0.4,0.8,0.4, 1.0, 0.6  , 0,250,150, 0.0, 1.0))
	Cierradoor4()
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("Golem"),))

pers=Bladex.CreateEntity("vamp","Vamp",104000, 37000, -60000,"Person")
pers.Angle=0
pers.Scale=2.5
pers.Level=19
o=Bladex.CreateEntity("mvs1","VampWeapon",0,0,0,"Weapon")
o.Scale=1
aura = Auras.MakeAura("mvs1",5568.0,(25,1.0,1.0,1,0,0), (),(),(2,  0.8,0.8,1.0, 1.0, 0.6  , 0,250,50, 0.0, 1.0))
ItemTypes.ItemDefaultFuncs (o)
o=Bladex.CreateEntity("mvsh1","VampShield",0,0,0,"Weapon")
o.Scale=1
aura = Auras.MakeAura("mvsh1",5568.0,(25,1.0,1.0,1,0,0), (),(),(2,  0.8,0.8,1.0, 1.0, 0.6  , 0,150,50, 0.0, 1.0))
ItemTypes.ItemDefaultFuncs (o)
Actions.TakeObject(pers.Name,"mvs1")
Actions.TakeObject(pers.Name,"mvsh1")
pers.Blind       = 1
pers.Deaf        = 1
EnemyTypes.EnemyDefaultFuncs(pers)
pers.Life=VLife
pers.Alpha=0.2
pers.SetOnFloor()
pers.Data.VeryOldImDeadFunc = pers.ImDeadFunc
pers.ImDeadFunc = DeadVampFunc


darfuncs.HideBadGuy("vamp")
darfuncs.EnterSecEvent(91500, 39800, -60000, unhidevamp)

######################################################################
#####################Show Dark Knights and Chaos Knight

def unhidedks():
	darfuncs.UnhideBadGuy("dk1")
	darfuncs.UnhideBadGuy("dk2")
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("Darks"),))

####### knight1
global GrafX
global Arrowbox
if GrafX==1:
	Arrowbox = "Carcaj"
else:
	Arrowbox = "CarcajFuego"

o=Bladex.CreateEntity("dks1","Dagesse",0,0,0,"Weapon")
o.Scale=1.2
ItemTypes.ItemDefaultFuncs (o)
o=Bladex.CreateEntity("dksh1","Escudo6",0,0,0,"Weapon")
o.Scale=1
ItemTypes.ItemDefaultFuncs (o)

pers=Bladex.CreateEntity("dk1","Dark_Knight",71500, 35800, -54000,"Person")
pers.Angle=0
pers.Level=17
pers.Life=100
 
o=Bladex.CreateEntity("dk1bow","Arco",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)

o=Bladex.CreateEntity("dk1quiver",Arrowbox,0,0,0,"Physic")
ItemTypes.ItemDefaultFuncs (o)
o.Data.SetNumberOfArrows(5, pers.Name)
Actions.TakeObject(pers.Name,o.Name)

Actions.TakeObject(pers.Name,"dks1")
Actions.TakeObject(pers.Name,"dksh1")
pers.Blind       = 1
pers.Deaf        = 1

EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()


######## knight2

o=Bladex.CreateEntity("dks2","Espadacurva",0,0,0,"Weapon")
o.Scale=1.2
ItemTypes.ItemDefaultFuncs (o)
o=Bladex.CreateEntity("dksh2","Escudo6",0,0,0,"Weapon")
o.Scale=1
ItemTypes.ItemDefaultFuncs (o)
pers=Bladex.CreateEntity("dk2","Dark_Knight",51000, 35800, -54000,"Person")
pers.Angle=0
pers.Level=17
o=Bladex.CreateEntity("dk2bow","Arco",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)
o=Bladex.CreateEntity("dk2quiver",Arrowbox,0,0,0,"Physic")
ItemTypes.ItemDefaultFuncs (o)
o.Data.SetNumberOfArrows(5, pers.Name)
Actions.TakeObject(pers.Name,o.Name)
Actions.TakeObject(pers.Name,"dks2")
Actions.TakeObject(pers.Name,"dksh2")
pers.Blind       = 1
pers.Deaf        = 1

EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
###
darfuncs.HideBadGuy("dk1")
darfuncs.HideBadGuy("dk2")

darfuncs.EnterSecEvent(61000, 39800, -41000, unhidedks)

############### Chaos Knight & Trap door ##############
######## trap door

################# Mutilation
def Dismember (EntityName):
        pers = Bladex.GetEntity(EntityName)
        if pers:
                for limb_id in range (1, 8):
                        limb= pers.SeverLimb(limb_id)
                sound=Bladex.CreateSound("..\\..\\Sounds\\desangre2.wav","SndDestroza")
                sound.Volume=1
                sound.MinDistance=1000000.0
                sound.MaxDistance=1000000.0
                sound.Play(pers.Position[0], pers.Position[1], pers.Position[2], 0)

def Abredoor2():
	door2.OpenDoor()
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("LavaRoom"),))

def Cierradoor2():
	door2.CloseDoor()
	for x in range(1,6001,2000):
    		for y in range(1,4001,2000):
			Soldier = 'M'+str(x)+str(y)
			enemy = Bladex.GetEntity(Soldier)
			enemypos = enemy.Position[0]
			if (enemy) and (enemypos > 78500):
				if (enemypos < 87500):
					enemy.Life = 0
#					Dismember(enemy.Name)
########## Chaos Death FX

def ChaosFXEnd(entity):
	Abredoor2()
	DeathAppears("ck1")
	o=Bladex.GetEntity("ck1")
	o.Alpha=0.01
#	if OldChaosDeadFunc !="":
#		OldChaosDeadFunc(entity)

def GetCHFX(entity):
 Abredoor2()
 EnemyMagicallyAppearing("ck1",9)
 o=Bladex.GetEntity("ck1")
 o.Alpha=0.01
 o=Bladex.GetEntity("cksh1")
 o.Alpha=0.01
 o=Bladex.GetEntity("cks1")
 o.Alpha=0.01

# if OldChaosDeadFunc !="":
# OldChaosDeadFunc(entity)

def VanishChaos(entity):
	GetCHFX(entity)

def ChaosDeadFunc(entity):
	VanishChaos(entity)

def unhideck1():
	darfuncs.UnhideBadGuy("ck1")
	EnemyMagicallyAppearing("ck1",5)
o=Bladex.CreateEntity("cks1","Espadon",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs (o)
o=Bladex.CreateEntity("cksh1","Escudon",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs (o)
pers=Bladex.CreateEntity("ck1","ChaosKnight",61250, 39800, -72500,"Person")
pers.Angle=0
pers.Level=17
Actions.TakeObject(pers.Name,"cks1")
Actions.TakeObject(pers.Name,"cksh1")
pers.Blind       = 1
pers.Deaf        = 1
EnemyTypes.EnemyDefaultFuncs(pers)
pers.Life=CLife
pers.SetOnFloor()
OldChaosDeadFunc = pers.ImDeadFunc
pers.ImDeadFunc = ChaosDeadFunc

darfuncs.HideBadGuy("ck1")
darfuncs.EnterSecEvent(61250, 39800, -71000, unhideck1)
####################################################
####################################################



########### Dark Knights Leader & close off lava ##################
def AbreDoor8():
	door8.OpenDoor()
#	Bladex.AddScheduledFunc(Bladex.GetTime()+5, CierraDoor8,())

def CierraDoor8():
	door8.CloseDoor()
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("LavaPuz"),))
########### Seal off lava lower
palanm8=Levers.PlaceLever("PALAm8",Levers.LeverType3,(59100,38500,-57000),(0.5,0.5,-0.5,0.5),0.5)
palanm8.mode=1

palanm8.OnTurnOnFunc=AbreDoor8
palanm8.OnTurnOnArgs=()

palanm8.OnTurnOffFunc=CierraDoor8
palanm8.OnTurnOffArgs=()


door8=Doors.CreateDoor("door8", (62000, 39000, -58000), (0,1,0), 0, 6000, Doors.CLOSED)
door8.opentype=Doors.UNIF
door8.o_med_vel=-1200
door8.o_med_displ=6000
door8.closetype=Doors.AC
door8.c_init_displ=6000
door8.c_med_vel=10000

AbreDoor8()
########################################

def unhideDKnf():
	CierraDoor8()
	darfuncs.UnhideBadGuy("crork")
	Actions.TurnToFaceEntity("Player1", "crork")
	DeathAppears("crork")
o=Bladex.CreateEntity("cr1","Espada",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs (o)
o=Bladex.CreateEntity("crs1","Escudo6",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs (o)

pers=Bladex.CreateEntity("crork","Dark_Knight",61250, 39800, -71000,"Person")
pers.Angle=0
pers.Level=17
Actions.TakeObject(pers.Name,"cr1")
Actions.TakeObject(pers.Name,"crs1")
pers.Blind       = 0
pers.Deaf        = 0
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetActiveEnemy("Player1")
pers.SetOnFloor()
darfuncs.HideBadGuy("crork")
darfuncs.EnterSecEvent(61500, 39800, -60000, unhideDKnf)


############################################
############################### Great Demon

####################################### Final Levers
stairflag1=0
stairflag2=0
stairflagmain=0
def SetStair1():
	unhideGDemon()
	global stairflag1
	stairflag1=1
	global stairflag2
	global Demonflag
	if stairflag2+Demonflag==2:
		global stairflagmain
		stairflagmain=1

def SetStair2():
	unhideGDemon()
	global stairflag2
	stairflag2=1
	global stairflag1
	global Demonflag
	if stairflag1+Demonflag==2:
		global stairflagmain
		stairflagmain=1
			

palanmf1=Levers.PlaceLever("FinLever1",Levers.LeverType3,(188600,30500,-73000),(0.5,0.5,-0.5,0.5),0.5)
palanmf1.mode=1
palanmf1.OnTurnOnFunc=SetStair1
palanmf1.OnTurnOnArgs=()
palanmf1.OnTurnOffFunc=SetStair1
palanmf1.OnTurnOffArgs=()

palanmf2=Levers.PlaceLever("FinLever2",Levers.LeverType3,(188600,30500,-47000),(0.5,0.5,-0.5,0.5),0.5)
palanmf2.mode=1
palanmf2.OnTurnOnFunc=SetStair2
palanmf2.OnTurnOnArgs=()
palanmf2.OnTurnOffFunc=SetStair2
palanmf2.OnTurnOffArgs=()

Demonflag=0

def Demon(entity):
	global Demonflag
	Demonflag=1
	global stairflag1
	global stairflag2
	if stairflag1+stairflag2==2:
		global stairflagmain
		stairflagmain=1


def DemonDeadFunc(entity):
	Demon(entity)

def unhideGDemon():
   global Demonflag
   if Demonflag == 0:
	darfuncs.UnhideBadGuy("GDmon1")
	Actions.TurnToFaceEntity("Player1", "GDmon1")
	EnemyMagicallyAppearing("GDmon1",5)
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("Finale"),))

pers=Bladex.CreateEntity("GDmon1","Great_Demon",200000, 38500, -60000,"Person")
pers.Angle=2
pers.Scale=1
pers.Level=9
pers.Blind       = 1
pers.Deaf        = 1
EnemyTypes.EnemyDefaultFuncs(pers)
pers.Life=DLife
pers.SetOnFloor()
OldDemonDeadFunc = pers.ImDeadFunc
pers.ImDeadFunc = DemonDeadFunc
darfuncs.HideBadGuy("GDmon1")

#o=Bladex.GetSector(210000, 25800, -60000)
#o.TooSteep=1
#darfuncs.EnterSecEvent(187500, 39800, -60000, unhideGDemon)

############################################################################
############################### Dal Gurak & friends... #################

def Finale5Func():
#	Bladex.AddScheduledFunc(Bladex.GetTime()+10, Finale5Func,())
	global ShowCStats
	ShowCStats = 0
	ConquestStats()

def Finale4Func():
	Bladex.AddScheduledFunc(Bladex.GetTime()+60, Finale5Func,())
	ClearText()
	GameText.WriteTextAux(GetText("You have found the Sword of Ianna and released\nits powers from the evil force of Chaos.\nThe youngest of the Chaos magicians lies slain in his own Cathedral\n but your journey is only beginning....\n\n Are you prepared for your next Conquest??"),300.0,255,150,20,0,260,[])

def Finale3Func():
	stair5.OpenDoor()
	pers = Bladex.GetEntity("Player1")
	pers.GoToJogging = 0
	pers.GoTo(180500,38500,-60000)
	Bladex.AddScheduledFunc(Bladex.GetTime()+20, Finale4Func,())

def Finale2Func():
	doorX.CloseDoor()
	Bladex.AddScheduledFunc(Bladex.GetTime()+7, Finale3Func,())

def FinaleFunc():
#	Bladex.DeactivateInput() ###### Player watch movie
	pers = Bladex.GetEntity("Player1")
	pers.GoToJogging = 0
	pers.GoTo(230500,44500,-59000)
	Bladex.AddScheduledFunc(Bladex.GetTime()+3, Finale2Func,())

def EndGameFunc(): # Last function July 15th 19.45
	RestoreCam()
	FinaleFunc()
######################### Dal Appears ##################################
def unhidedal1():
	darfuncs.UnhideBadGuy("GenDalGurak3")
	Actions.TurnToFaceEntity("Player1", "GenDalGurak3")
	EnemyMagicallyAppearing("GenDalGurak3",4)
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("Finale"),))
#########################################################################
##########################################################################


def DalIsDead(entity):
	darfuncs.StartMatrixFX(ESource = "GenDalGurak3")
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("FightDal"),))
	Bladex.AddScheduledFunc(Bladex.GetTime()+9, EndGameFunc,())


def MuereDalGurak(entity):
	DalIsDead(entity)

gen_DalGurak3 = EnmGenRnd.CreateEnemy((224000, 44500, -60000),"GenDalGurak3", "DalGurak", "", 0, "", 0, 9)
gen_DalGurak3.Data.VeryOldImDeadFunc = gen_DalGurak3.ImDeadFunc
gen_DalGurak3.ImDeadFunc = MuereDalGurak
gen_DalGurak3.Data.positionlist.append([237000, 44500, -54500, 0])
gen_DalGurak3.Data.positionlist.append([237000, 44500, -65500, 0])
gen_DalGurak3.Data.positionlist.append([226000, 44500, -54500, 0])
gen_DalGurak3.Data.positionlist.append([226000, 44500, -65500, 0])
gen_DalGurak3.Data.positionlist.append([224000, 44500, -60000, 0])
gen_DalGurak3.Data.positionlist.append([239000, 44500, -60000, 0])
#gen_DalGurak3.Angle=1.6
gen_DalGurak3.SelfIlum=8
dalinv=gen_DalGurak3.GetInventory()
gen_DalGurak3.Data.Dalweapon=Bladex.CreateEntity("DalWeapon", "DalWeapon", 0,0,0, "Weapon")
ItemTypes.ItemDefaultFuncs(gen_DalGurak3.Data.Dalweapon)
dalinv.AddWeapon(gen_DalGurak3.Data.Dalweapon.Name)
gen_DalGurak3.Data.Dalshield=Bladex.CreateEntity("DalShield","DalShield",0,0,0, "Weapon")
Sparks.MakeShield(gen_DalGurak3.Data.Dalshield.Name)
dalinv.AddShield(gen_DalGurak3.Data.Dalshield.Name)
dalmagicshield= ItemTypes.MakeMagicShield("DalMagicShield", gen_DalGurak3)
darfuncs.HideBadGuy("GenDalGurak3")
#darfuncs.EnterSecEvent(244500, 38500, -60250, unhidedal1)



############################ Bring Skels to LIFE!!! ######################
#FX

#Dead
o=Bladex.CreateEntity("DeadSkeleton1","Skeleton_Optimiced",244500, 39000, -63000,"Physic")
o.Scale=0.9
o.SelfIlum=0.1
o.Orientation=-0.5,-0.5,-0.5,0.5

o=Bladex.CreateEntity("DeadSkeleton2","Skeleton_Optimiced",244500, 39000, -57000,"Physic")
o.Scale=0.9
o.SelfIlum=0.1
o.Orientation=-0.5,-0.5,-0.5,0.5

#Alive
pers=Bladex.CreateEntity("LifeSkeleton1","Skeleton",244500, 38500, -63000,"Person")
pers.Angle=1.6
pers.Level=19
pers.SelfIlum=0.3
pers.SendTriggerSectorMsgs=0
o=Bladex.CreateEntity("LI1","DoubleSword",0,0,0,"Weapon")
o.SelfIlum=0.3
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)
o=Bladex.CreateEntity("LISH1","Escudo6",0,0,0,"Weapon")
o.SelfIlum=0.3
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)
pers.Blind       = 1
pers.Deaf        = 1
pers.SetOnFloor()
EnemyTypes.EnemyDefaultFuncs(pers)
darfuncs.HideBadGuy("LifeSkeleton1")
######################################################################################
pers=Bladex.CreateEntity("LifeSkeleton2","Skeleton",244500, 38500, -57000,"Person")
pers.Angle=5
pers.Level=19
pers.SelfIlum=0.3
pers.SendTriggerSectorMsgs=0
o=Bladex.CreateEntity("LI2","DoubleSword",0,0,0,"Weapon")
o.SelfIlum=0.3
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)
o=Bladex.CreateEntity("LISH2","Escudo6",0,0,0,"Weapon")
o.SelfIlum=0.3
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)
pers.Blind       = 1
pers.Deaf        = 1
pers.SetOnFloor()
EnemyTypes.EnemyDefaultFuncs(pers)
darfuncs.HideBadGuy("LifeSkeleton2")

#Dead to Alive
def ToLifeSkel(dent,lent):
#	Bladex.KillMusic()
#	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("Appear"),))
	dsk=Bladex.GetEntity(dent)
	lsk=Bladex.GetEntity(lent)
	Actions.TurnToFaceEntity("Player1", dsk.Name)
	darfuncs.UnhideBadGuy(lsk.Name)
	lsk.SetActiveEnemy("Player1")
#	DeathAppears(lsk.Name)
	dsk.Alpha=0

def Undeadsk1():
	ToLifeSkel("DeadSkeleton1","LifeSkeleton1")
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.2, ToLifeSkel,("DeadSkeleton2","LifeSkeleton2"), "ToLifeSkel")

#	ToLifeSkel("DeadSkeleton2","LifeSkeleton2")

darfuncs.EnterSecEvent(241500, 39000, -60000, Undeadsk1)

################################################################################################
######################## Shadow Lights #######################################
Luzrr1=Bladex.CreateEntity("Spot1Luz","Entity Spot",196500,31900, -47750)
Luzrr1.Color=145,80,40
Luzrr1.Intensity=25
Luzrr1.Precission=0.5
Luzrr1.Visible=0
Luzrr1.CastShadows=1
Luzrr1.Flick=0

Luzrr2=Bladex.CreateEntity("Spot2Luz","Entity Spot",206500,31900, -47750)
Luzrr2.Color=145,80,40
Luzrr2.Intensity=25
Luzrr2.Precission=0.5
Luzrr2.Visible=0
Luzrr2.CastShadows=1
Luzrr2.Flick=0

Luzrr6=Bladex.CreateEntity("Spot6Luz","Entity Spot",196500,31900, -72250)
Luzrr6.Color=145,80,40
Luzrr6.Intensity=25
Luzrr6.Precission=0.5
Luzrr6.Visible=0
Luzrr6.CastShadows=1
Luzrr6.Flick=0

Luzrr7=Bladex.CreateEntity("Spot7Luz","Entity Spot",206500,31900, -72250)
Luzrr7.Color=145,80,40
Luzrr7.Intensity=25
Luzrr7.Precission=0.5
Luzrr7.Visible=0
Luzrr7.CastShadows=1
Luzrr7.Flick=0

######################################## Run Skulls ##########################################




pers=Bladex.CreateEntity("Runskl1","Skeleton",190000, 30500, -47000,"Person")
pers.Angle=4
pers.Level=19
pers.SelfIlum=0
pers.SendTriggerSectorMsgs=0
o=Bladex.CreateEntity("Run1","DoubleSword",0,0,0,"Weapon")
o.SelfIlum=0
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)
o=Bladex.CreateEntity("RunSH1","Escudo6",0,0,0,"Weapon")
o.SelfIlum=0
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)
pers.Blind       = 1
pers.Deaf        = 1
pers.SetOnFloor()
EnemyTypes.EnemyDefaultFuncs(pers)
darfuncs.HideBadGuy("Runskl1")
###########
pers=Bladex.CreateEntity("Runskl1a","Skeleton",194000, 30500, -47000,"Person")
pers.Angle=4
pers.Level=19
pers.SelfIlum=0
pers.SendTriggerSectorMsgs=0
o=Bladex.CreateEntity("Run1a","DoubleSword",0,0,0,"Weapon")
o.SelfIlum=0
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)
o=Bladex.CreateEntity("RunSH1a","Escudo6",0,0,0,"Weapon")
o.SelfIlum=0
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)
pers.Blind       = 1
pers.Deaf        = 1
pers.SetOnFloor()
EnemyTypes.EnemyDefaultFuncs(pers)
darfuncs.HideBadGuy("Runskl1a")


########################################################################
pers=Bladex.CreateEntity("Runskl2","Skeleton",190000, 30500, -73000,"Person")
pers.Angle=4
pers.Level=19
pers.SelfIlum=0
pers.SendTriggerSectorMsgs=0
o=Bladex.CreateEntity("Run2","DoubleSword",0,0,0,"Weapon")
o.SelfIlum=0
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)
o=Bladex.CreateEntity("RunSH2","Escudo6",0,0,0,"Weapon")
o.SelfIlum=0
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)
pers.Blind       = 1
pers.Deaf        = 1
pers.SetOnFloor()
EnemyTypes.EnemyDefaultFuncs(pers)
darfuncs.HideBadGuy("Runskl2")
#############
pers=Bladex.CreateEntity("Runskl2a","Skeleton",194000, 30500, -73000,"Person")
pers.Angle=4
pers.Level=19
pers.SelfIlum=0
pers.SendTriggerSectorMsgs=0
o=Bladex.CreateEntity("Run2a","DoubleSword",0,0,0,"Weapon")
o.SelfIlum=0
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)
o=Bladex.CreateEntity("RunSH2a","Escudo6",0,0,0,"Weapon")
o.SelfIlum=0
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)
pers.Blind       = 1
pers.Deaf        = 1
pers.SetOnFloor()
EnemyTypes.EnemyDefaultFuncs(pers)
darfuncs.HideBadGuy("Runskl2a")



def Jog2():
	o=Bladex.GetEntity("Runskl1")
	o.Blind       = 0
	o.Deaf        = 0
	o.SetActiveEnemy("Player1")
	o=Bladex.GetEntity("Runskl1a")
	o.Blind       = 0
	o.Deaf        = 0
	o.SetActiveEnemy("Player1")
	o=Bladex.GetEntity("Runskl2")
	o.Blind       = 0
	o.Deaf        = 0
	o.SetActiveEnemy("Player1")
	o=Bladex.GetEntity("Runskl2a")
	o.Blind       = 0
	o.Deaf        = 0
	o.SetActiveEnemy("Player1")

#	Actions.TurnToFaceEntity("Runskl2","Player1")

def MovS(Point,Target,Time):
	cam=Bladex.GetEntity("Camera")
	auxi1=cam.Position
	auxi2=cam.TPos
	AuxFuncs.MoveCamFromTo(auxi1[0], auxi1[1], auxi1[2], Point[0], Point[1], Point[2], auxi2[0],auxi2[1], auxi2[2],Target[0], Target[1], Target[2], Time, "")
###################
def BacC():
	C = Bladex.GetEntity("Camera")
	C.SetPersonView("Player1")
	C.Cut()
def LookSkl3():
	Bladex.ActivateInput()
	Bladex.AddScheduledFunc(Bladex.GetTime()+3, Jog2,())
	BacC()
	ClearText()
	GameText.WriteTextAux(GetText("Waypoint Saved"), 3.0, 180,200,255,0,30,[])



def LookSkl2():
	o=Bladex.GetEntity("Runskl2")
	darfuncs.UnhideBadGuy(o.Name)
	o.Blind       = 1
	o.Deaf        = 1
	o.GoToJogging = 1
	o.GoTo(216000,34500,-60000)
	o=Bladex.GetEntity("Runskl2a")
	darfuncs.UnhideBadGuy(o.Name)
	o.Blind       = 1
	o.Deaf        = 1
	o.GoToJogging = 1
	o.GoTo(216000,34500,-60000)
	Actions.TurnToFaceEntity("Player1", "Runskl2")
	Point=202000,36000,-54000
	Target=196000,35000,-72000
	Time=2
#	MovS(Point,Target,Time)
	Bladex.AddScheduledFunc(Bladex.GetTime()+2, LookSkl3,())
#####################
stair5=Doors.CreateDoor("stair5", (188000, 38000,-60000), (0,1,0), 200, 10000, Doors.CLOSED)
stair5.opentype=Doors.UNIF
stair5.o_med_vel=-1100
stair5.o_med_displ=10000
stair5.closetype=Doors.AC
stair5.c_init_displ=10000
stair5.c_med_vel=8000
stair5.OpenDoor()

###########################
def unhideRunskl1():
#	Bladex.DeactivateInput() ###### Player watch movie
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("Appear"),))
	o=Bladex.GetEntity("Runskl1")
	darfuncs.UnhideBadGuy(o.Name)
	o.Blind       = 1
	o.Deaf        = 1
	o.GoToJogging = 1
	o.GoTo(216000,34500,-60000)
	o=Bladex.GetEntity("Runskl1a")
	darfuncs.UnhideBadGuy(o.Name)
	o.Blind       = 1
	o.Deaf        = 1
	o.GoToJogging = 1
	o.GoTo(216000,34500,-60000)
	Point=200000,36000,-66000
	Target=196000,35000,-47000
	Time=2
	MovS(Point,Target,Time)
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.5, LookSkl2,())

#######################
def CloseCath():
	stair5.CloseDoor()
	global WayPoint
	global WayPointAngle
	WayPoint=189500, 38500, -60000
	WayPointAngle=6
	char=Bladex.GetEntity("Player1")
	global WayPointLevel
	global WayPointPartialLevel
	global WayPointLife
	WayPointLevel=char.Level
	WayPointPartialLevel=char.PartialLevel
	char.Life=CharStats.GetCharMaxLife(char.Kind, char.Level)
	WayPointLife=char.Life
	Powerup("Player1")
	pos=char.Position
	sound=Bladex.CreateSound("..\\..\\Sounds\\sesgado-especial-largo2.wav", "SndWaypoint")
	sound.Volume=1
	sound.Play(pos[0], pos[1], pos[2], 0)
	unhideRunskl1()


################ Running Skeletons with Shadows 
darfuncs.EnterSecEvent(191000, 39800, -60000, CloseCath)

########################## SR.py

############################# Finale Funcs ##################################
################################ DOOM objects ############################

o=Bladex.CreateEntity("Doom","Orbe",246000, 38600, -59500,"Weapon")
o.Static=1
o.Scale=0.75
o.SelfIlum=0.2
o.Orientation=0.7,0.7,0,0
ItemTypes.ItemDefaultFuncs (o)
AuraParams=(40, 1, 1, 0, 0, 1)
AuraGradient=(2, 0.8, 0.6, 0.0, 0.6, 0.0, 0.8, 0.1, 0.0, 0.0, 0.6)
aura=Auras.MakeAura(o.Name, 100000, AuraParams, (), (), AuraGradient)
luzD=Bladex.CreateEntity("LuzD","Entity Spot",246000, 38600, -59500)
luzD.Color=255, 120, 0
luzD.Intensity=25
luzD.Precission=0.5 #0.125
luzD.CastShadows=1
luzD.Visible=0
luzD.Flick=0   
luzD.SizeFactor = 0.2
luzD.AngVel=0.1
luzD.GlowTexture="SunFlare"
o.Link(luzD)

o=Bladex.CreateEntity("DoomX","Orbe",247000, 38600, -59500,"Weapon")
o.Static=1
o.Scale=0.5
o.SelfIlum=0
o.Orientation=0.7,0.7,0,0
ItemTypes.ItemDefaultFuncs (o)






o=Bladex.CreateEntity("Altar1","Altar",242000, 39100, -60000,"Physic")
o.Scale=1
o.SelfIlum=0
o.Orientation=0.5,0.5,-0.5,0.5
o.Static=1
o.Solid=1
Sparks.SetStoneSparkling(o.Name)

################################### Doom FX #################


################################### FLASH ########################################

def CoolFX(entity,effect,tm):
	o = Bladex.GetEntity(entity)
	sound=Bladex.CreateSound("..\\..\\Sounds\\fuego-boo.wav", "SndFireDoom")
	sound.Volume=1
	sound.Play(o.Position[0], o.Position[1], o.Position[2], 0)
	FX = Bladex.CreateEntity("FXO"+str(entity), "Entity Particle System D1",o.Position[0], o.Position[1], o.Position[2])
	FX.ParticleType   = effect
	FX.YGravity       = -500 # -1000
	FX.Friction       = 0.01
	FX.PPS            = 1024
	FX.Velocity       = 0, 0, 0 # 0,800,0
	FX.Time2Live      = 30 #60
	FX.NormalVelocity=0.1 #-2.0
	FX.RandomVelocity = 20 #65
	FX.DeathTime=Bladex.GetTime()+tm

def CoolFXObj(entity,effect,tm,T2,RV):
	o = Bladex.GetEntity(entity)
	sound=Bladex.CreateSound("..\\..\\Sounds\\fuego-boo.wav", "SndObjDoom")
	sound.Volume=1
	sound.Play(o.Position[0], o.Position[1], o.Position[2], 0)
	FX = Bladex.CreateEntity("FXO"+str(entity), "Entity Particle System Dobj",o.Position[0], o.Position[1], o.Position[2])
	FX.ObjectName=entity
	FX.ParticleType   = effect
	FX.YGravity       = -600 # -1000
	FX.Friction       = 0.01
	FX.PPS            = 256 # 1024
	FX.Velocity       = 0, 0, 0 # 0,800,0
	FX.Time2Live      = T2 #30 #60
	FX.NormalVelocity=0.1 #-2.0
	FX.RandomVelocity = RV #20 #65
	FX.DeathTime=Bladex.GetTime()+tm


#####################################################################################

def ObjIsRotateFunc(entity):
	dinobj = obj.Data.dinobjdata
	dinobj.OnMovement = 0
	dinobj.OnRotation = 0

#################################################################################
##################################### Dynamic Cut Scene ###########################

def ShowDalFunc():
	unhidedal1()
	Actions.TurnToFaceEntity("Player1", "GenDalGurak3")
	darfuncs.BackPlayer()
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("Finale"),))
	SetWay7()


##################################################
LZ=[235000,-61500,235000,-58500,233000,-56500,230000,-56500,228000,-58500,228000,-61500,230000,-63500,233000,-63500]
Z=40000

def DalFunc():
	ShockBolt1(LZ[14], Z, LZ[15], LZ[0], Z, LZ[1],60)
	Bladex.ActivateInput() ####### Movie ending...
	AbredoorX()
	darfuncs.ChangePointOfView(228000,39000,-59000,5,"Player1") #################
	stm=Bladex.GetTime()
	Bladex.AddScheduledFunc(stm+8, ShowDalFunc,())

def Bang8(o):
	ShockBolt1(LZ[12], Z, LZ[13], LZ[14], Z, LZ[15],60)
	CoolFXObj("DoomX","LargeFire",1,30,10)
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj,(LZ[14],Z,LZ[15]),(LZ[0],Z,LZ[1]),4000,4000,"","","","",(),DalFunc,()) 

def Bang7(o):
	ShockBolt1(LZ[10], Z, LZ[11], LZ[12], Z, LZ[13],60)
	CoolFXObj("DoomX","LargeFire",1,30,10)
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj, (LZ[12], Z, LZ[13]), (LZ[14], Z, LZ[15]), 4000, 4000, "", "", "",  ObjIsRotateFunc, (o.Name,), Bang8, (o,)) 

def Bang6(o):
	ShockBolt1(LZ[8], Z, LZ[9], LZ[10], Z, LZ[11],60)
	CoolFXObj("DoomX","LargeFire",1,30,10)
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj, (LZ[10], Z, LZ[11]), (LZ[12], Z, LZ[13]), 4000, 4000, "", "", "",  ObjIsRotateFunc, (o.Name,), Bang7, (o,)) 


def Bang5(o):
	ShockBolt1(LZ[6], Z, LZ[7], LZ[8], Z, LZ[9],60)
	CoolFXObj("DoomX","LargeFire",1,30,10)
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj, (LZ[8], Z, LZ[9]), (LZ[10], Z, LZ[11]), 4000, 4000, "", "", "",  ObjIsRotateFunc, (o.Name,), Bang6, (o,)) 

def Bang4(o):
	ShockBolt1(LZ[4], Z, LZ[5], LZ[6], Z, LZ[7],60)
	CoolFXObj("DoomX","LargeFire",1,30,10)
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj, (LZ[6], Z, LZ[7]), (LZ[8], Z, LZ[9]), 4000, 4000, "", "", "",  ObjIsRotateFunc, (o.Name,), Bang5, (o,)) 


def Bang3(o):
	ShockBolt1(LZ[2], Z, LZ[3], LZ[4], Z, LZ[5],60)
	CoolFXObj("DoomX","LargeFire",1,30,10)
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj, (LZ[4], Z, LZ[5]), (LZ[6], Z, LZ[7]), 4000, 4000, "", "", "",  ObjIsRotateFunc, (o.Name,), Bang4, (o,)) 


def Bang2(o):
	ShockBolt1(LZ[0], Z, LZ[1], LZ[2], Z, LZ[3],80)
	CoolFXObj("DoomX","LargeFire",1,30,10)
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj, (LZ[2], Z, LZ[3]), (LZ[4], Z, LZ[5]), 4000, 4000, "", "", "",  ObjIsRotateFunc, (o.Name,), Bang3, (o,)) 



def Bang1(o):
	CoolFXObj("DoomX","LargeFire",1,30,10)
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj, (LZ[0], Z, LZ[1]), (LZ[2], Z, LZ[3]), 4000, 4000, "", "", "",  ObjIsRotateFunc, (o.Name,), Bang2, (o,)) 

def End2Func():
	darfuncs.ChangePointOfView(243000,34000,-59000,3,"Player1") ############## 
	o=Bladex.GetEntity("Doom")
	p=o.Position
	ShockBolt1(p[0], p[1], p[2], LZ[0], 40000, LZ[1],200)
	ShockBolt1(p[0], p[1], p[2], LZ[2], 40000, LZ[3],200)
	o=Bladex.GetEntity("DoomX")
	Bang1(o)

def TakeFunc():
	o=Bladex.GetEntity("Doom2")
	me=Bladex.GetEntity("Player1")
#	me.Data.maxWeapon=5
#	Actions.StdToggleWeapons(me)
	inv=me.GetInventory()
	inv.maxWeapons = 5
	if me.InvRight:
		inv.LinkBack(me.InvRight)
	me.LaunchAnmType("Chg_r_l")
	Actions.TakeObject("Player1",o.Name)
	inv.LinkRightHand(o.Name)
	stm=Bladex.GetTime()
	Bladex.AddScheduledFunc(stm+1.0, End2Func,())


def StashFunc():
	darfuncs.StopMatrixFX()         #########################################
	darfuncs.ChangePointOfView(225000,37000,-59000,2,"Player1") ############## 
	stm=Bladex.GetTime()
	Bladex.AddScheduledFunc(stm+3.0, TakeFunc,())

def MatPause():
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.8, StashFunc,())
	

def ObjToPlayerFunc(o,stm):
	pers = Bladex.GetEntity("Player1")
	pos=pers.Position
	o=Bladex.GetEntity("Doom2")
	CoolFXObj("Doom2","EnergyDissip",4,60,30)
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj, (o.Position[0], o.Position[1], o.Position[2]), (pos[0]+1500, pos[1], pos[2]), 4000, 500, "", "", "",  ObjIsRotateFunc, (o.Name,), MatPause, ()) 


def ObjDropFunc(entity):
	o = Bladex.GetEntity("Doom2")
	stm=Bladex.GetTime()
	Bladex.AddScheduledFunc(stm+0.1, ObjToPlayerFunc,(o.Name,stm),"GetSword")

def RotateSwordFunc():
	darfuncs.StartMatrixFX(ESource = "Doom2")      ############################
	o=Bladex.GetEntity("Doom2")
	dinobj = Objects.CreateDinamicObject(o.Name)
	SwordAppearsFX("Doom2","FastEnergyConc",5)
	Actions.TurnToFaceEntity("Player1", "Doom2")
	Objects.RotateObject(dinobj, 3.14159*5.5, 20, 1, (0, 1, 0), (0, 0, 1), Objects.REL, "", "", "", ObjIsRotateFunc, (o.Name,), ObjDropFunc, (o.Name,))
##################################################################
############# below func
def MovC2(Point,Target,Time):
	cam=Bladex.GetEntity("Camera")
	auxi1=cam.Position
	auxi2=cam.TPos
	AuxFuncs.MoveCamFromTo(auxi1[0], auxi1[1], auxi1[2], Point[0], Point[1], Point[2], auxi2[0],auxi2[1], auxi2[2],Target[0], Target[1], Target[2], Time, "")
####

############################# E-Bolt and create Blade ######################



def BladeFunc():
	global SkPer
	if SkPer==3:
		IannaS="BladeSword2Barbarian"
	else:
		IannaS="BladeSword2"
	o=Bladex.CreateEntity("Doom2",IannaS,242000, 39800, -60000,"Weapon")
	o.Static=1
	o.Scale=1
	o.SelfIlum=8
	o.Orientation=-0.5,-0.5,0,0
	ItemTypes.ItemDefaultFuncs (o)
	Actions.TurnToFaceEntity("Player1", "Doom2")
	pos=242000,36000,-60000
	Point=242000,36500,-63000
	MovC2(Point,pos,6) ###############################
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj, (o.Position[0], o.Position[1], o.Position[2]), (o.Position[0], o.Position[1]-2800, o.Position[2]), 600, 200, "", "", "",  ObjIsRotateFunc, (o.Name,), RotateSwordFunc, ()) 

def ObjElectricFunc():
	o = Bladex.GetEntity("Doom")
	ShockBolt1(o.Position[0], o.Position[1], o.Position[2], 241800,38200,-60000, 200)
	o=Bladex.GetEntity("Book1")
	o.SelfIlum=0.8
	stm=Bladex.GetTime()
	Bladex.AddScheduledFunc(stm+1, BladeFunc,())


def OrbPause():
	stm=Bladex.GetTime()
	Bladex.AddScheduledFunc(stm+1, ObjElectricFunc,())

def ObjGoAltarFunc():
	o = Bladex.GetEntity("Doom")
	sound=Bladex.CreateSound("..\\..\\Sounds\\trueno5.wav", "SndDoomFly1")
	sound.Volume=1
	sound.Play(o.Position[0], o.Position[1], o.Position[2], 0)
	CoolFXObj("Doom","LargeFire",3,30,10)
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj, (o.Position[0], o.Position[1], o.Position[2]), (240000, 35000, -60000), 4000, 2000, "", "", "",  ObjIsRotateFunc, (o.Name,), OrbPause, ()) 

def ObjRotateAbsFunc(o):
	o = Bladex.GetEntity("Doom")
	pers = Bladex.GetEntity("Player1")
	pos=pers.Position
#	darfuncs.BackPlayer()
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.RotateObject(dinobj, 3.14159*1.5, 1, 3, (pos[0],38000,pos[2]), (0, 1, 0), Objects.ABS, "", "", "", ObjIsRotateFunc, (o.Name,), ObjGoAltarFunc, ())


def ObjSpinFunc(o,tm):
	pers = Bladex.GetEntity("Player1")
	pos=pers.Position
	o = Bladex.GetEntity("Doom")
	o.Position=234000, 40000, -60000
	Actions.TurnToFaceEntity(pers.Name, o.Name)
	CoolFXObj("Doom","LargeFire",2.0,30,35)
	darfuncs.ChangePointOfView(223000,36000,-59000,3,"Player1") ############## 
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj, (o.Position[0], o.Position[1], o.Position[2]), (234000, 38000, -60000), 200, 1000, "", "", "",  ObjIsRotateFunc, (o.Name,), ObjRotateAbsFunc, (o.Name,)) 
	GameText.WriteTextAux(GetText("***** The Sphere of Truth *****\n"), 5, 250,150,10,0,30,[])

def ObjRaiseFunc(o):
	Actions.TurnToFaceEntity("Player1", "Altar1")
	stm=Bladex.GetTime()
	Bladex.AddScheduledFunc(stm+3, ObjSpinFunc,("Player1",stm),"test")

def AlainnFunc():
#	stair3.CloseDoor()
	Bladex.DeactivateInput() ###### Player watch movie
	pers = Bladex.GetEntity("Player1")
	Target=231500,38000,-60000
	Point=238000,35000,-60000
	MovC2(Point,Target,2) 
#	darfuncs.ChangePointOfView(240000,34000,-60000,3,"Player1") #####################
#	cam=Bladex.GetEntity("Camera")
#	cam.TPos=250000,37000,-60000
	pers.GoToJogging = 0
	pers.GoTo(231500,38500,-59000)

darfuncs.EnterSecEvent(222000,39800,-60500, AlainnFunc)
darfuncs.EnterSecEvent(230000,39800,-60500, ObjRaiseFunc)


##################################### END SR.PY #################################################

############ Dal's Magic Arena
#################### Lava magic stuff ###################

o=Bladex.CreateEntity("orbit","PowerupGold",134000,40000,-50600,"Physic")
o.Scale=2
o.SelfIlum=5
o.Orientation=0.7,0.7,0,0
o.Static=1
o.Solid=1
#############
o=Bladex.CreateEntity("orbit2","PowerupGold",122000,40000,-30400,"Physic")
o.Scale=2
o.SelfIlum=5
o.Orientation=0.7,0.7,0,0
o.Static=1
o.Solid=1
##############
o=Bladex.CreateEntity("orbit3","PowerupGold",128000,40000,-45000,"Physic")
o.Scale=2
o.SelfIlum=5
o.Orientation=0.7,0.7,0,0
o.Static=1
o.Solid=1

def Orbit():
	o = Bladex.GetEntity("orbit")
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.RotateObject(dinobj,3.14159*50000,0.3,3,(134000,40000,-47000),(0,1,0),Objects.ABS,"","","","",(),"",())
	o = Bladex.GetEntity("orbit2")
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.RotateObject(dinobj,3.14159*50000,0.4,3,(122000,40000,-33000),(0,1,0),Objects.ABS,"","","","",(),"",())
	o = Bladex.GetEntity("orbit3")
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.RotateObject(dinobj,3.14159*-50000,0.5,1,(128000,40000,-40000),(0,1,0),Objects.ABS,"","","","",(),"",())

darfuncs.EnterSecEvent(116500, 38500, -57500, Orbit)
darfuncs.EnterSecEvent(144000, 38500, -28000, Orbit)


######################### Planets
o=Bladex.CreateEntity("Pluto","BoladePiedra",128000,40000,-40000,"Physic")
o.Scale=1
o.Static=1
o.SelfIlum=0.1
o.Orientation=0.7,0.7,0,0
AuraParams=(140, 1, 1, 0, 0, 1)
AuraGradient=(2, 0.8, 0.6, 0.0, 0.6, 0.0, 0.8, 0.1, 0.0, 0.0, 0.6)
aura=Auras.MakeAura(o.Name, 100000, AuraParams, (), (), AuraGradient)
luzP=Bladex.CreateEntity("LuzP","Entity Spot",128000, 40000, -40000)
luzP.Color=255, 120, 0
luzP.Intensity=25
luzP.Precission=0.5 #0.125
luzP.CastShadows=1
luzP.Visible=0
luzP.Flick=0   
luzP.SizeFactor = 0.5
luzP.AngVel=0.1
luzP.GlowTexture="SunFlare"
o.Link(luzP)
dinobj = Objects.CreateDinamicObject(o.Name)
Objects.RotateObject(dinobj, 3.14159*500000, 2, 1, (0, 1, 0), (0, 0, 1), Objects.REL, "", "", "","",(),"",())
#########


o=Bladex.CreateEntity("Asteroid1","EsferaGemaVerde",128000,40000,-43000,"Physic")
o.Scale=2
o.Static=1
o.SelfIlum=1
o.Orientation=0.7,0.7,0,0
Venomglow2("Asteroid1",500000)
dinobj = Objects.CreateDinamicObject(o.Name)
Objects.RotateObject(dinobj,3.14159*50000,1,3,(128000,40000,-40000),(0, 1, 0),Objects.ABS,"","","","",(),"",())
#############
o=Bladex.CreateEntity("Asteroid2","EsferaGemaRoja",128000,37000,-40000,"Physic")
o.Scale=2
o.Static=1
o.SelfIlum=1
o.Orientation=0.7,0.7,0,0
Venomglow2("Asteroid2",500000)
dinobj = Objects.CreateDinamicObject(o.Name)
Objects.RotateObject(dinobj,3.14159*50000,1,3,(128000,40000,-40000),(1, 0, 0),Objects.ABS,"","","","",(),"",())
###########
o=Bladex.CreateEntity("Asteroid3","EsferaGemaAzul",128000,43000,-40000,"Physic")
o.Scale=1
o.Static=1
o.SelfIlum=1
o.Orientation=0.7,0.7,0,0
Venomglow2("Asteroid3",500000)
dinobj = Objects.CreateDinamicObject(o.Name)
Objects.RotateObject(dinobj,3.14159*50000,1,3,(128000,40000,-40000),(0, 0, 1),Objects.ABS,"","","","",(),"",())

######################### Start
def EndStrt4():
	Bladex.ActivateInput()
	BacC()
#	darfuncs.BackPlayer()
############
def EndStrt3():
	Bladex.AddScheduledFunc(Bladex.GetTime()+1, EndStrt4, ())

########
def MovCc(Point,Target,Time):
	cam=Bladex.GetEntity("Camera")
	auxi1=cam.Position
	auxi2=cam.TPos
	AuxFuncs.MoveCamFromTo(auxi1[0], auxi1[1], auxi1[2], Point[0], Point[1], Point[2], auxi2[0],auxi2[1], auxi2[2],Target[0], Target[1], Target[2], Time, EndStrt3)

#######
def EndStrt2():
	pers=Bladex.GetEntity("Player1")
	pos=pers.Position
	Point=16000,-4000,-9000
	Target=pos[0],pos[1],pos[2]
	Time=3
	Bladex.AddScheduledFunc(Bladex.GetTime()+3, MovCc, (Point,Target,Time))
###############
def MovCb(Point,Target,Time):
	cam=Bladex.GetEntity("Camera")
	auxi1=cam.Position
	auxi2=cam.TPos
	AuxFuncs.MoveCamFromTo(auxi1[0], auxi1[1], auxi1[2], Point[0], Point[1], Point[2], auxi2[0],auxi2[1], auxi2[2],Target[0], Target[1], Target[2], Time, EndStrt2)
####
########
def EndStrt1():
	Point=-18000,-19000,11000
	Target=-36000,40000,-29000
	Time=5
	Bladex.AddScheduledFunc(Bladex.GetTime()+5, MovCb, (Point,Target,Time))
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("introbowork"),))
	o=Bladex.GetEntity("DramaSkel1")
#	o.Alpha=1
	o.GoToJogging = 0
	o.GoTo(15000,-18500,17000)
	GameText.WriteTextAux(GetText("*** The Rocky Valley ***"), 5.0, 255,150,20,0,300,[])
#########
def MovC(Point,Target,Time):
	cam=Bladex.GetEntity("Camera")
	auxi1=cam.Position
	auxi2=cam.TPos
	AuxFuncs.MoveCamFromTo(auxi1[0], auxi1[1], auxi1[2], Point[0], Point[1], Point[2], auxi2[0],auxi2[1], auxi2[2],Target[0], Target[1], Target[2], Time, EndStrt1)
####
def StrtM1():
	Bladex.DeactivateInput()
	Point=29000,-24000,0
	Target=-26000,0,-2000
	Time=3
	MovC(Point,Target,Time)
darfuncs.EnterSecEvent(8000,-500,-3000, StrtM1)

##############################################################
#################### See Dal Movie

def EndDM2():
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("DalOrders"),))
	Bladex.AddScheduledFunc(Bladex.GetTime()+2, EndStrt4, ())

def EndDM1():
#	pers=Bladex.GetEntity("DramaDal1")
#	pers.Angle=2.6
	Actions.TurnToFaceEntity("DramaDal1","Player1")
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("DalLaugh"),))
	Bladex.AddScheduledFunc(Bladex.GetTime()+1.8, EndDM2, ())

def MovD(Point,Target,Time):
	cam=Bladex.GetEntity("Camera")
	auxi1=cam.Position
	auxi2=cam.TPos
	AuxFuncs.MoveCamFromTo(auxi1[0], auxi1[1], auxi1[2], Point[0], Point[1], Point[2], auxi2[0],auxi2[1], auxi2[2],Target[0], Target[1], Target[2], Time, EndDM1)

def StrtDM1():
	Bladex.DeactivateInput()
	Point=190000,16000,-59000
	Target=148000,38500,-82000
	Time=5
	MovD(Point,Target,Time)
darfuncs.EnterSecEvent(148000,38500,-80000, StrtDM1)





#########################################
# create the trap door    CRUSHER       #
#########################################

door2=Doors.CreateDoor("door2", (80000, 36000, -62500), (0,1,0), 200, 4000, Doors.CLOSED)

door2.opentype=Doors.UNIF
door2.o_med_vel=-1000
door2.o_med_displ=4000

door2.closetype=Doors.AC
door2.c_init_displ=4000
door2.c_med_vel=8000

########################################
# Action of lever to open door         #
########################################

#palanm2=Levers.PlaceLever("PALAm2",Levers.LeverType3,(74000,39000,-58100),(0.707000,0.707000,0.0,0.0),0.8)
#palanm2.mode=1

#palanm2.OnTurnOnFunc=Abredoor2
#palanm2.OnTurnOnArgs=()

#palanm2.OnTurnOffFunc=Cierradoor2
#palanm2.OnTurnOffArgs=()

#####################################################################################


def FinPEnd1():
	Bladex.KillMusic()
#	unhideGDemon()

def FinPEnd():
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.4, FinPEnd1,())

o=Bladex.CreateEntity("FinDoor1","PuertaFernando",186500, 33000, -56800,"Physic")
o.Scale=1
o.Orientation=-0.5,-0.5,-0.5,0.5
o.Static=1
o.Solid=1
o.SelfIlum=0

o=Bladex.CreateEntity("FinDoor2","PuertaFernando",186500, 33000, -63800,"Physic")
o.Scale=1
o.Orientation=0.5,0.5,-0.5,0.5
o.Static=1
o.Solid=1
o.SelfIlum=0

def DoorsFunc():
	o=Bladex.GetEntity("FinDoor1")
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj,(186500,33000,-56800),(186500,33000,-53800),100,640, "", "", "", "",(),"",()) 
	o=Bladex.GetEntity("FinDoor2")
	dinobj = Objects.CreateDinamicObject(o.Name)
	Objects.DisplaceObjectFromTo(dinobj,(186500,33000,-63800),(186500,33000,-66800),100,640, "", "", "", "",(),FinPEnd,()) 
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("VampIntro"),))

############################## Last Knight
def showfinknight():
	darfuncs.UnhideBadGuy("Outk")
	DeathAppears("Outk")

def DkIsDead(entity):
	DoorsFunc()

def DkDeadFunc(entity):
	DkIsDead(entity)

pers=Bladex.CreateEntity("Outk","Dark_Knight",184000, 39800, -60000,"Person")
pers.Angle=2
pers.Level=19
pers.Alpha=1
o=Bladex.CreateEntity("outs1","Espada",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)
o=Bladex.CreateEntity("outsh1","Escudo6",0,0,0,"Weapon")
ItemTypes.ItemDefaultFuncs(o)
Actions.TakeObject(pers.Name,o.Name)
pers.Blind       = 0
pers.Deaf        = 0
EnemyTypes.EnemyDefaultFuncs(pers)
pers.SetOnFloor()
darfuncs.HideBadGuy(pers.Name)
OldDkDeadFunc = pers.ImDeadFunc
pers.ImDeadFunc = DkDeadFunc

darfuncs.EnterSecEvent(180000, 39800, -60000, showfinknight)

########################### Stairs 

stair1=Doors.CreateDoor("stair1", (212500, 38000,-60000), (0,-1,0), 0, 1000, Doors.CLOSED)
stair1.opentype=Doors.UNIF
stair1.o_med_vel=-600
stair1.o_med_displ=1000
stair1.closetype=Doors.AC
stair1.c_init_displ=1000
stair1.c_med_vel=8000

stair2=Doors.CreateDoor("stair2", (213500, 38000,-60000), (0,-1,0), 0, 2000, Doors.CLOSED)
stair2.opentype=Doors.UNIF
stair2.o_med_vel=-600
stair2.o_med_displ=2000
stair2.closetype=Doors.AC
stair2.c_init_displ=2000
stair2.c_med_vel=8000

stair3=Doors.CreateDoor("stair3", (214500, 38000,-60000), (0,-1,0), 0, 3000, Doors.CLOSED)
stair3.opentype=Doors.UNIF
stair3.o_med_vel=-600
stair3.o_med_displ=3000
stair3.closetype=Doors.AC
stair3.c_init_displ=3000
stair3.c_med_vel=8000

stair4=Doors.CreateDoor("stair4", (216500, 38000,-60000), (0,1,0), 0, 3400, Doors.CLOSED)
stair4.opentype=Doors.UNIF
stair4.o_med_vel=-1100
stair4.o_med_displ=3400
stair4.closetype=Doors.AC
stair4.c_init_displ=3400
stair4.c_med_vel=2000
stair4.OpenDoor()


#########################################################
#def UnsealRoom():
#	stair4.OpenDoor()
#	Bladex.KillMusic()
#	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("LavaPuz"),))

def Flipstair1():
	stair1.OpenDoor()
#	Bladex.AddScheduledFunc(Bladex.GetTime()+1.8,UnsealRoom,())

def Flipstair2():
	stair2.OpenDoor()
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.8,Flipstair1,())


def Flipstair3():
	Actions.TurnToFaceEntity("Player1", "Altar1")
	stair3.OpenDoor()
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("LavaPuz"),))
	Bladex.AddScheduledFunc(Bladex.GetTime()+0.8,Flipstair2,())
def SealRoom():
	stair4.CloseDoor()
	Bladex.KillMusic()
	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("LavaPuz"),))

def Flipstair(sector,entity):
	if (entity == "Player1"):
		global stairflagmain
		if stairflagmain==1:
			trig.OnEnter=""
			Flipstair3()

trig=Bladex.GetSector(211000,36800,-60000)
trig.OnEnter=Flipstair




#darfuncs.EnterSecEvent(211000,36800,-60000, Flipstair3)
##############################################################


#door9=Doors.CreateDoor("door9", (202000, 26000, -60000), (0,0,1), 0, 12000, Doors.CLOSED)
#door9.opentype=Doors.UNIF
#door9.o_med_vel=-3000
#door9.o_med_displ=12000
#door9.closetype=Doors.AC
#door9.c_init_displ=12000
#door9.c_med_vel=2000

#def OpenCeiling():
#	door9.OpenDoor()
#	Bladex.KillMusic()
#	Bladex.AddScheduledFunc(Bladex.GetTime(), Bladex.ExeMusicEvent, (Bladex.GetMusicEvent("LavaPuz"),))
#	Bladex.AddScheduledFunc(Bladex.GetTime()+0.8,End1,())

#####################################################################################
###################### Change Weapon & Enemy Stats (new stats) & Data ###############


Reference.DefaultSelectionData[DKType]=(9.0,6000.0,"Deadly Knightshade")
Reference.DefaultSelectionData['Gema']=(1.0,100.0,"o")
Reference.DefaultSelectionData['EspadaMagica1']=(9.0,4000.0,"Celtic Curse")
Reference.DefaultSelectionData['SoporteOrbe']=(4.0,1000.0,"Star Gate")
Reference.DefaultSelectionData['LlaveAmarilla_Aura']=(5.0,5000,"Save Gem")
Reference.DefaultSelectionData['LlaveAzul']=(5.0,5000,"Save Gem")
Reference.DefaultSelectionData['LlaveNegra']=(5.0,5000,"Save Gem")
Reference.DefaultSelectionData['LlaveBlanca']=(5.0,5000,"Save Gem")
Reference.DefaultSelectionData['Varita5']=(5.0,5000,"Save Gem")
Reference.DefaultSelectionData['Varita1']=(5.0,5000,"Save Gem")
Reference.DefaultSelectionData['Corona']=(5.0,5000,"Save Gem")

###################################################################################
CharStats.CharExperienceReward['Salamander'] = [100, 200, 400, 800, 1600, 3200, 6400, 12800, 25600, 51200, 70000, 90000, 110000, 130000, 150000, 170000, 190000, 210000, 240000, 260000]

CharStats.CharMaxLifeValue['Ragnar'] = [60, 100, 200, 400, 600, 800, 1000, 1200, 1500, 1700, 1900, 2100, 2300, 2500, 2700, 2900, 3100, 3300, 3500, 10000]
CharStats.CharDamageData['Ragnar'] = [12, 15, 18, 25, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140, 150, 160, 170, 500]
CharStats.CharExperienceReward['Ragnar'] = [40, 50, 60, 120, 240, 480, 960, 1920, 3840, 7680, 15360, 30720, 61440, 122880, 135000, 150000, 170000, 190000, 210000, 240000]


############# Help get started... :)
CharStats.CharExperienceReward['Ork'] = [40, 50, 60, 120, 240, 480, 960, 2500, 5000, 8000, 15360, 30720, 61440, 122880, 135000, 150000, 170000, 190000, 210000, 240000]
#############


CharStats.CharMaxLifeValue['Dark_Ork']=              [    10,     30,     50,     70,    120,    220,    350,    470,    790,    930,   1250,   1480,   1600,   1800,   2000,   2100,   2200,   2300,   2400,   2500]
CharStats.CharMaxLifeValue['Gold_Ork']=              [    10,     30,     50,     70,    120,    220,    350,    470,    790,    930,   1250,   1480,   1600,   1800,   2000,   2100,   2200,   2300,   2400,   2500]

CharStats.CharDamageData['Dark_Ork']=                [     1,      5,     10,     15,     20,     25,     40,     45,     50,     55,     60,     65,     70,     75,     80,     85,     90,     95,    100,    110]
CharStats.CharDamageData['Gold_Ork']=                [     1,      5,     10,     15,     20,     25,     40,     45,     50,     55,     60,     65,     70,     75,     80,     85,     90,     95,    100,    110]

CharStats.CharExperienceReward['Dark_Ork']=               [     5,     10,     15,     20,     40,     80,    160,    320,    640,   1280,   2560,   5120,  10240,  20480,  40960,  60000,  80000, 100000, 120000, 150000]
CharStats.CharExperienceReward['Gold_Ork']=               [     5,     10,     15,     20,     40,     80,    160,    320,    640,   1280,   2560,   5120,  10240,  20480,  40960,  60000,  80000, 100000, 120000, 150000]

CharStats.CharAccuracy['Dark_Ork']=                 [   0.1,    0.1,    0.2,    0.2,    0.3,    0.3,    0.4,    0.4,    0.5,    0.5,    0.6,    0.6,    0.6,    0.7,    0.7,    0.7,    0.8,    0.8,    0.9,    0.9]
CharStats.CharAccuracy['Gold_Ork']=            [   0.1,    0.1,    0.2,    0.2,    0.3,    0.3,    0.4,    0.4,    0.5,    0.5,    0.6,    0.6,    0.6,    0.7,    0.7,    0.7,    0.8,    0.8,    0.9,    0.9]


##############  ########

CharStats.CharResistances['Vamp']= {'Impale': 1.00, 'Venom': 0.2, 'Slash': 0.40, 'Crush': 0.20, 'Ice': 0.2, 'Fire': 0.2, 'Light': 0.2, 'Drain': 0.4}

CharStats.CharResistances['Spidersmall']= {'Impale': 0.00, 'Venom': -1.00, 'Slash': 0.00, 'Crush': 0.00, 'Ice': 0.00, 'Fire': 1.00, 'Light': 0.00, 'Drain': 0.90}
####################################


