######################################################################################	
# Difficulty Mod (by Josh Dahlby)
######################################################################################	
import Bladex
import netgame
import Damage

Levels = ["Very Easy", "Easy", "Medium","Hard (original)","Harder", "Hell", "Impossible"]

# Percentage of damage to do.  
GiveMod = [2, 1.5, 1.25, 1, 0.75, 0.5, 0.25]

# Percentage of damage to take.
TakeMod = [0.25, 0.5, 0.75, 1, 1.25, 1.5, 2]

DifficultyLevel = 3

def GetDamageModifier(attacker, victim):
	if netgame.GetNetState() != 0: # Don't modify net games
		return 1;
	elif attacker == "Player1":
		return GiveMod[GetDifficulty()]
	elif victim == "Player1":
		return TakeMod[GetDifficulty()]
	else:
		return 1;

def SetDifficulty(option):
	global DifficultyLevel
	DifficultyLevel = Levels.index(option)
	cfgfile=open("../../Config/Difficulty.cfg", "w")
	cfgfile.write(option)
	cfgfile.close()

def GetDifficulty():
	global DifficultyLevel
	return DifficultyLevel

try:
  cfgfile=open("../../Config/Difficulty.cfg", "r")
  temp = cfgfile.read();
  cfgfile.close()
  global DifficultyLevel
  DifficultyLevel = Levels.index(temp)
except:
  print "Difficulty.py -> No Difficulty.cfg found"

OldPlayerHitFunc = Damage.PlayerHitFunc

def PlayerHitFunc(victim, attacker, life, prevLife):
	mod = GetDamageModifier(attacker, victim)
	if mod != 1:
		dmg = prevLife - life
		newdmg = dmg * mod
		print "OldDamage = " + `dmg` + " NewDamage = " + `newdmg`
		en = Bladex.GetEntity(victim)
		en.Life = prevLife - newdmg
		if life <= 0 and en.Life > 0:
			en.Data.Mutilate = 0
	global OldPlayerHitFunc
	if OldPlayerHitFunc != "":
		OldPlayerHitFunc(victim, attacker, en.Life, prevLife)

# Assign local damage function
if netgame.GetNetState() == 0:
	Damage.PlayerHitFunc = PlayerHitFunc
